/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.desktop.appearance.AppearanceUIController;
import org.gephi.desktop.appearance.AppearanceUIModel;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.TableObserver;
import org.openide.util.Lookup;

public class TableObserverExecutor
implements Runnable {
    private static final long DEFAULT_DELAY = 1000L;
    private final AppearanceUIModel model;
    private ScheduledExecutorService executor;
    private TableObserver nodeTableObserver;
    private TableObserver edgeTableObserver;

    public TableObserverExecutor(AppearanceUIModel model) {
        this.model = model;
    }

    public void start() {
        GraphModel graphModel = this.model.appearanceModel.getGraphModel();
        this.nodeTableObserver = graphModel.getNodeTable().createTableObserver(false);
        this.edgeTableObserver = graphModel.getEdgeTable().createTableObserver(false);
        this.executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "Appearance Table Observer"));
        this.executor.scheduleWithFixedDelay(this, 0L, this.getDelayInMs(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
        }
        TableObserverExecutor tableObserverExecutor = this;
        synchronized (tableObserverExecutor) {
            if (this.nodeTableObserver != null) {
                this.nodeTableObserver.destroy();
                this.nodeTableObserver = null;
            }
            if (this.edgeTableObserver != null) {
                this.edgeTableObserver.destroy();
                this.edgeTableObserver = null;
            }
        }
        this.executor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TableObserverExecutor tableObserverExecutor = this;
        synchronized (tableObserverExecutor) {
            try {
                String selectedElementClass = this.model.selectedElementClass;
                if (this.nodeTableObserver != null && selectedElementClass.equals("nodes")) {
                    if (this.nodeTableObserver.hasTableChanged()) {
                        ((AppearanceUIController)Lookup.getDefault().lookup(AppearanceUIController.class)).refreshColumnsList();
                    }
                } else if (this.edgeTableObserver != null && selectedElementClass.equals("edges") && this.edgeTableObserver.hasTableChanged()) {
                    ((AppearanceUIController)Lookup.getDefault().lookup(AppearanceUIController.class)).refreshColumnsList();
                }
            }
            catch (Exception e) {
                Logger.getLogger(TableObserverExecutor.class.getName()).log(Level.SEVERE, "Error while refreshing appearance's column list", e);
            }
        }
    }

    public boolean isRunning() {
        return this.executor != null;
    }

    private long getDelayInMs() {
        return 1000L;
    }
}

