/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.forceAtlas2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.forceAtlas2.ForceAtlas2LayoutData;
import org.gephi.layout.plugin.forceAtlas2.ForceFactory;

public class Region {
    private final List<Node> nodes;
    private final List<Region> subregions = new ArrayList<Region>();
    private double mass;
    private double massCenterX;
    private double massCenterY;
    private double size;

    public Region(Node[] nodes) {
        this.nodes = new ArrayList<Node>();
        this.nodes.addAll(Arrays.asList(nodes));
        this.updateMassAndGeometry();
    }

    public Region(ArrayList<Node> nodes) {
        this.nodes = new ArrayList<Node>(nodes);
        this.updateMassAndGeometry();
    }

    private void updateMassAndGeometry() {
        if (this.nodes.size() > 1) {
            this.mass = 0.0;
            double massSumX = 0.0;
            double massSumY = 0.0;
            for (Node n : this.nodes) {
                ForceAtlas2LayoutData nLayout = (ForceAtlas2LayoutData)n.getLayoutData();
                this.mass += nLayout.mass;
                massSumX += (double)n.x() * nLayout.mass;
                massSumY += (double)n.y() * nLayout.mass;
            }
            this.massCenterX = massSumX / this.mass;
            this.massCenterY = massSumY / this.mass;
            this.size = Double.MIN_VALUE;
            for (Node n : this.nodes) {
                double distance = Math.sqrt(((double)n.x() - this.massCenterX) * ((double)n.x() - this.massCenterX) + ((double)n.y() - this.massCenterY) * ((double)n.y() - this.massCenterY));
                this.size = Math.max(this.size, 2.0 * distance);
            }
        }
    }

    public synchronized void buildSubRegions() {
        if (this.nodes.size() > 1) {
            Region subregion;
            ArrayList<Object> oneNodeList;
            Object subregion2;
            ArrayList leftNodes = new ArrayList();
            ArrayList rightNodes = new ArrayList();
            for (Node n : this.nodes) {
                ArrayList nodesColumn = (double)n.x() < this.massCenterX ? leftNodes : rightNodes;
                nodesColumn.add(n);
            }
            ArrayList<Node> topleftNodes = new ArrayList<Node>();
            ArrayList<Node> bottomleftNodes = new ArrayList<Node>();
            for (Node n : leftNodes) {
                ArrayList<Node> nodesLine = (double)n.y() < this.massCenterY ? topleftNodes : bottomleftNodes;
                nodesLine.add(n);
            }
            ArrayList<Node> bottomrightNodes = new ArrayList<Node>();
            ArrayList<Node> toprightNodes = new ArrayList<Node>();
            for (Node n : rightNodes) {
                ArrayList<Node> nodesLine = (double)n.y() < this.massCenterY ? toprightNodes : bottomrightNodes;
                nodesLine.add(n);
            }
            if (topleftNodes.size() > 0) {
                if (topleftNodes.size() < this.nodes.size()) {
                    subregion2 = new Region(topleftNodes);
                    this.subregions.add((Region)subregion2);
                } else {
                    for (Node n : topleftNodes) {
                        oneNodeList = new ArrayList<Node>();
                        oneNodeList.add(n);
                        subregion = new Region(oneNodeList);
                        this.subregions.add(subregion);
                    }
                }
            }
            if (bottomleftNodes.size() > 0) {
                if (bottomleftNodes.size() < this.nodes.size()) {
                    subregion2 = new Region(bottomleftNodes);
                    this.subregions.add((Region)subregion2);
                } else {
                    for (Node n : bottomleftNodes) {
                        oneNodeList = new ArrayList();
                        oneNodeList.add(n);
                        subregion = new Region(oneNodeList);
                        this.subregions.add(subregion);
                    }
                }
            }
            if (bottomrightNodes.size() > 0) {
                if (bottomrightNodes.size() < this.nodes.size()) {
                    subregion2 = new Region(bottomrightNodes);
                    this.subregions.add((Region)subregion2);
                } else {
                    for (Node n : bottomrightNodes) {
                        oneNodeList = new ArrayList();
                        oneNodeList.add(n);
                        subregion = new Region(oneNodeList);
                        this.subregions.add(subregion);
                    }
                }
            }
            if (toprightNodes.size() > 0) {
                if (toprightNodes.size() < this.nodes.size()) {
                    subregion2 = new Region(toprightNodes);
                    this.subregions.add((Region)subregion2);
                } else {
                    for (Node n : toprightNodes) {
                        oneNodeList = new ArrayList();
                        oneNodeList.add(n);
                        subregion = new Region(oneNodeList);
                        this.subregions.add(subregion);
                    }
                }
            }
            for (Region subregion3 : this.subregions) {
                subregion3.buildSubRegions();
            }
        }
    }

    public void applyForce(Node n, ForceFactory.RepulsionForce Force, double theta) {
        if (this.nodes.size() < 2) {
            Node regionNode = this.nodes.get(0);
            Force.apply(n, regionNode);
        } else {
            double distance = Math.sqrt(((double)n.x() - this.massCenterX) * ((double)n.x() - this.massCenterX) + ((double)n.y() - this.massCenterY) * ((double)n.y() - this.massCenterY));
            if (distance * theta > this.size) {
                Force.apply(n, this);
            } else {
                for (Region subregion : this.subregions) {
                    subregion.applyForce(n, Force, theta);
                }
            }
        }
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public double getMassCenterX() {
        return this.massCenterX;
    }

    public void setMassCenterX(double massCenterX) {
        this.massCenterX = massCenterX;
    }

    public double getMassCenterY() {
        return this.massCenterY;
    }

    public void setMassCenterY(double massCenterY) {
        this.massCenterY = massCenterY;
    }
}

