/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph;

import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.impl.GraphModelImpl;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;

public class GraphControllerImpl
implements GraphController {
    @Override
    public GraphModel getGraphModel() {
        Workspace currentWorkspace = ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace();
        if (currentWorkspace == null) {
            return null;
        }
        return this.getGraphModel(currentWorkspace);
    }

    @Override
    public synchronized GraphModel getGraphModel(Workspace workspace) {
        GraphModel model = (GraphModel)workspace.getLookup().lookup(GraphModel.class);
        if (model == null) {
            model = this.newGraphModel(workspace);
        }
        return model;
    }

    private GraphModel newGraphModel(Workspace workspace) {
        Configuration config = new Configuration();
        config.setTimeRepresentation(TimeRepresentation.INTERVAL);
        GraphModelImpl graphModelImpl = GraphModel.Factory.newInstance(config);
        workspace.add((Object)graphModelImpl);
        return graphModelImpl;
    }
}

