/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.api;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.datalab.spi.columns.merge.AttributeColumnsMergeStrategy;
import org.gephi.datalab.spi.columns.merge.AttributeColumnsMergeStrategyBuilder;
import org.gephi.datalab.spi.edges.EdgesManipulator;
import org.gephi.datalab.spi.edges.EdgesManipulatorBuilder;
import org.gephi.datalab.spi.general.GeneralActionsManipulator;
import org.gephi.datalab.spi.general.PluginGeneralActionsManipulator;
import org.gephi.datalab.spi.nodes.NodesManipulator;
import org.gephi.datalab.spi.nodes.NodesManipulatorBuilder;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategy;
import org.gephi.datalab.spi.rows.merge.AttributeRowsMergeStrategyBuilder;
import org.gephi.datalab.spi.values.AttributeValueManipulator;
import org.gephi.datalab.spi.values.AttributeValueManipulatorBuilder;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DataLaboratoryHelper {
    public static DataLaboratoryHelper getDefault() {
        return (DataLaboratoryHelper)Lookup.getDefault().lookup(DataLaboratoryHelper.class);
    }

    public NodesManipulator[] getNodesManipulators() {
        ArrayList<NodesManipulator> nodesManipulators = new ArrayList<NodesManipulator>();
        for (NodesManipulatorBuilder nm : Lookup.getDefault().lookupAll(NodesManipulatorBuilder.class)) {
            nodesManipulators.add(nm.getNodesManipulator());
        }
        this.sortManipulators(nodesManipulators);
        return nodesManipulators.toArray(new NodesManipulator[0]);
    }

    public EdgesManipulator[] getEdgesManipulators() {
        ArrayList<EdgesManipulator> edgesManipulators = new ArrayList<EdgesManipulator>();
        for (EdgesManipulatorBuilder em : Lookup.getDefault().lookupAll(EdgesManipulatorBuilder.class)) {
            edgesManipulators.add(em.getEdgesManipulator());
        }
        this.sortManipulators(edgesManipulators);
        return edgesManipulators.toArray(new EdgesManipulator[0]);
    }

    public GeneralActionsManipulator[] getGeneralActionsManipulators() {
        ArrayList generalActionsManipulators = new ArrayList();
        generalActionsManipulators.addAll(Lookup.getDefault().lookupAll(GeneralActionsManipulator.class));
        this.sortManipulators(generalActionsManipulators);
        return generalActionsManipulators.toArray(new GeneralActionsManipulator[0]);
    }

    public PluginGeneralActionsManipulator[] getPluginGeneralActionsManipulators() {
        ArrayList pluginGeneralActionsManipulators = new ArrayList();
        pluginGeneralActionsManipulators.addAll(Lookup.getDefault().lookupAll(PluginGeneralActionsManipulator.class));
        this.sortManipulators(pluginGeneralActionsManipulators);
        return pluginGeneralActionsManipulators.toArray(new PluginGeneralActionsManipulator[0]);
    }

    public AttributeColumnsManipulator[] getAttributeColumnsManipulators() {
        ArrayList attributeColumnsManipulators = new ArrayList();
        attributeColumnsManipulators.addAll(Lookup.getDefault().lookupAll(AttributeColumnsManipulator.class));
        this.sortAttributeColumnsManipulators(attributeColumnsManipulators);
        return attributeColumnsManipulators.toArray(new AttributeColumnsManipulator[0]);
    }

    public AttributeValueManipulator[] getAttributeValueManipulators() {
        ArrayList<AttributeValueManipulator> attributeValueManipulators = new ArrayList<AttributeValueManipulator>();
        for (AttributeValueManipulatorBuilder am : Lookup.getDefault().lookupAll(AttributeValueManipulatorBuilder.class)) {
            attributeValueManipulators.add(am.getAttributeValueManipulator());
        }
        this.sortManipulators(attributeValueManipulators);
        return attributeValueManipulators.toArray(new AttributeValueManipulator[0]);
    }

    public AttributeColumnsMergeStrategy[] getAttributeColumnsMergeStrategies() {
        ArrayList<AttributeColumnsMergeStrategy> strategies = new ArrayList<AttributeColumnsMergeStrategy>();
        for (AttributeColumnsMergeStrategyBuilder cs : Lookup.getDefault().lookupAll(AttributeColumnsMergeStrategyBuilder.class)) {
            strategies.add(cs.getAttributeColumnsMergeStrategy());
        }
        this.sortManipulators(strategies);
        return strategies.toArray(new AttributeColumnsMergeStrategy[0]);
    }

    public AttributeRowsMergeStrategy[] getAttributeRowsMergeStrategies() {
        ArrayList<AttributeRowsMergeStrategy> strategies = new ArrayList<AttributeRowsMergeStrategy>();
        for (AttributeRowsMergeStrategyBuilder cs : Lookup.getDefault().lookupAll(AttributeRowsMergeStrategyBuilder.class)) {
            strategies.add(cs.getAttributeRowsMergeStrategy());
        }
        this.sortManipulators(strategies);
        return strategies.toArray(new AttributeRowsMergeStrategy[0]);
    }

    private void sortManipulators(ArrayList<? extends Manipulator> m) {
        Collections.sort(m, new Comparator<Manipulator>(){

            @Override
            public int compare(Manipulator o1, Manipulator o2) {
                if (o1.getType() == o2.getType()) {
                    return o1.getPosition() - o2.getPosition();
                }
                return o1.getType() - o2.getType();
            }
        });
    }

    private void sortAttributeColumnsManipulators(ArrayList<? extends AttributeColumnsManipulator> m) {
        Collections.sort(m, new Comparator<AttributeColumnsManipulator>(){

            @Override
            public int compare(AttributeColumnsManipulator o1, AttributeColumnsManipulator o2) {
                if (o1.getType() == o2.getType()) {
                    return o1.getPosition() - o2.getPosition();
                }
                return o1.getType() - o2.getType();
            }
        });
    }

    public void executeManipulator(final Manipulator m) {
        if (m.canExecute()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final ManipulatorUI ui = m.getUI();
                    if (ui != null) {
                        final JButton okButton = new JButton(NbBundle.getMessage(DataLaboratoryHelper.class, (String)"DataLaboratoryHelper.ui.okButton.text"));
                        DialogControlsImpl dialogControls = new DialogControlsImpl(okButton);
                        ui.setup(m, dialogControls);
                        JPanel settingsPanel = ui.getSettingsPanel();
                        DialogDescriptor dd = new DialogDescriptor((Object)settingsPanel, NbBundle.getMessage(DataLaboratoryHelper.class, (String)"SettingsPanel.title", (Object)ui.getDisplayName()), ui.isModal(), new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (e.getSource().equals(okButton)) {
                                    ui.unSetup();
                                    DataLaboratoryHelper.this.executeManipulatorInOtherThread(m);
                                } else {
                                    ui.unSetup();
                                }
                            }
                        });
                        dd.setOptions(new Object[]{okButton, DialogDescriptor.CANCEL_OPTION});
                        dd.setClosingOptions(null);
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                        dialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                ui.unSetup();
                            }
                        });
                        dialog.setVisible(true);
                    } else {
                        DataLaboratoryHelper.this.executeManipulatorInOtherThread(m);
                    }
                }
            });
        }
    }

    public boolean showAttributeRowsMergeStrategyUIDialog(AttributeRowsMergeStrategy m) {
        final ManipulatorUI ui = m.getUI();
        if (ui != null && m.canExecute()) {
            final JButton okButton = new JButton(NbBundle.getMessage(DataLaboratoryHelper.class, (String)"DataLaboratoryHelper.ui.okButton.text"));
            DialogControlsImpl dialogControls = new DialogControlsImpl(okButton);
            ui.setup(m, dialogControls);
            JPanel settingsPanel = ui.getSettingsPanel();
            DialogDescriptor dd = new DialogDescriptor((Object)settingsPanel, NbBundle.getMessage(DataLaboratoryHelper.class, (String)"SettingsPanel.title", (Object)ui.getDisplayName()), ui.isModal(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource().equals(okButton)) {
                        ui.unSetup();
                    }
                }
            });
            dd.setOptions(new Object[]{okButton, DialogDescriptor.CANCEL_OPTION});
            dd.setClosingOptions(null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            return true;
        }
        return false;
    }

    private void executeManipulatorInOtherThread(final Manipulator m) {
        new Thread(){

            @Override
            public void run() {
                this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        Logger.getLogger("").log(Level.SEVERE, null, e);
                    }
                });
                m.execute();
            }
        }.start();
    }

    public void executeAttributeColumnsManipulator(final AttributeColumnsManipulator m, final GraphModel graphModel, final Table table, final Column column) {
        if (m.canManipulateColumn(table, column)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final AttributeColumnsManipulatorUI ui = m.getUI(table, column);
                    if (ui != null) {
                        final JButton okButton = new JButton(NbBundle.getMessage(DataLaboratoryHelper.class, (String)"DataLaboratoryHelper.ui.okButton.text"));
                        DialogControlsImpl dialogControls = new DialogControlsImpl(okButton);
                        ui.setup(m, graphModel, table, column, dialogControls);
                        JPanel settingsPanel = ui.getSettingsPanel();
                        DialogDescriptor dd = new DialogDescriptor((Object)settingsPanel, NbBundle.getMessage(DataLaboratoryHelper.class, (String)"SettingsPanel.title", (Object)ui.getDisplayName()), ui.isModal(), new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (e.getSource().equals(okButton)) {
                                    ui.unSetup();
                                    DataLaboratoryHelper.this.executeAttributeColumnsManipulatorInOtherThread(m, table, column);
                                } else {
                                    ui.unSetup();
                                }
                            }
                        });
                        dd.setOptions(new Object[]{okButton, DialogDescriptor.CANCEL_OPTION});
                        dd.setClosingOptions(null);
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                        dialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                ui.unSetup();
                            }
                        });
                        dialog.setVisible(true);
                    } else {
                        DataLaboratoryHelper.this.executeAttributeColumnsManipulatorInOtherThread(m, table, column);
                    }
                }
            });
        }
    }

    private void executeAttributeColumnsManipulatorInOtherThread(final AttributeColumnsManipulator m, final Table table, final Column column) {
        new Thread(){

            @Override
            public void run() {
                m.execute(table, column);
            }
        }.start();
    }

    public NodesManipulator getNodesManipulatorByName(String name) {
        for (NodesManipulatorBuilder nm : Lookup.getDefault().lookupAll(NodesManipulatorBuilder.class)) {
            if (!nm.getNodesManipulator().getClass().getSimpleName().equals(name)) continue;
            return nm.getNodesManipulator();
        }
        return null;
    }

    public EdgesManipulator getEdgesManipulatorByName(String name) {
        for (EdgesManipulatorBuilder nm : Lookup.getDefault().lookupAll(EdgesManipulatorBuilder.class)) {
            if (!nm.getEdgesManipulator().getClass().getSimpleName().equals(name)) continue;
            return nm.getEdgesManipulator();
        }
        return null;
    }

    public GeneralActionsManipulator getGeneralActionsManipulatorByName(String name) {
        for (GeneralActionsManipulator m : Lookup.getDefault().lookupAll(GeneralActionsManipulator.class)) {
            if (!m.getClass().getSimpleName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public PluginGeneralActionsManipulator getPluginGeneralActionsManipulatorByName(String name) {
        for (PluginGeneralActionsManipulator m : Lookup.getDefault().lookupAll(PluginGeneralActionsManipulator.class)) {
            if (!m.getClass().getSimpleName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public AttributeColumnsManipulator getAttributeColumnsManipulatorByName(String name) {
        for (AttributeColumnsManipulator m : Lookup.getDefault().lookupAll(AttributeColumnsManipulator.class)) {
            if (!m.getClass().getSimpleName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public AttributeValueManipulator getAttributeValueManipulatorByName(String name) {
        for (AttributeValueManipulatorBuilder am : Lookup.getDefault().lookupAll(AttributeValueManipulatorBuilder.class)) {
            if (!am.getAttributeValueManipulator().getClass().getSimpleName().equals(name)) continue;
            return am.getAttributeValueManipulator();
        }
        return null;
    }

    public AttributeColumnsMergeStrategy getAttributeColumnsMergeStrategyByName(String name) {
        for (AttributeColumnsMergeStrategyBuilder cs : Lookup.getDefault().lookupAll(AttributeColumnsMergeStrategyBuilder.class)) {
            if (!cs.getAttributeColumnsMergeStrategy().getClass().getSimpleName().equals(name)) continue;
            return cs.getAttributeColumnsMergeStrategy();
        }
        return null;
    }

    public AttributeRowsMergeStrategy getAttributeRowsMergeStrategyByName(String name) {
        for (AttributeRowsMergeStrategyBuilder cs : Lookup.getDefault().lookupAll(AttributeRowsMergeStrategyBuilder.class)) {
            if (!cs.getAttributeRowsMergeStrategy().getClass().getSimpleName().equals(name)) continue;
            return cs.getAttributeRowsMergeStrategy();
        }
        return null;
    }

    class DialogControlsImpl
    implements DialogControls {
        JComponent okButton;

        public DialogControlsImpl(JComponent okButton) {
            this.okButton = okButton;
        }

        @Override
        public boolean isOkButtonEnabled() {
            return this.okButton.isEnabled();
        }

        @Override
        public void setOkButtonEnabled(boolean enabled) {
            this.okButton.setEnabled(enabled);
        }
    }
}

