/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.DimensionMismatchException;
import org.gephi.lib.gleem.linalg.Vec2f;
import org.gephi.lib.gleem.linalg.Vec3f;
import org.gephi.lib.gleem.linalg.Veci;

public class Vecf {
    private final float[] data;

    public Vecf(int n) {
        this.data = new float[n];
    }

    public Vecf(Vecf arg) {
        this.data = new float[arg.data.length];
        System.arraycopy(arg.data, 0, this.data, 0, this.data.length);
    }

    public int length() {
        return this.data.length;
    }

    public float get(int i) {
        return this.data[i];
    }

    public void set(int i, float val) {
        this.data[i] = val;
    }

    public Vec2f toVec2f() throws DimensionMismatchException {
        if (this.length() != 2) {
            throw new DimensionMismatchException();
        }
        Vec2f out = new Vec2f();
        for (int i = 0; i < 2; ++i) {
            out.set(i, this.get(i));
        }
        return out;
    }

    public Vec3f toVec3f() throws DimensionMismatchException {
        if (this.length() != 3) {
            throw new DimensionMismatchException();
        }
        Vec3f out = new Vec3f();
        for (int i = 0; i < 3; ++i) {
            out.set(i, this.get(i));
        }
        return out;
    }

    public Veci toInt() {
        Veci out = new Veci(this.length());
        for (int i = 0; i < this.length(); ++i) {
            out.set(i, (int)this.get(i));
        }
        return out;
    }
}

