/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterGDF;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.AbstractExporterSettings;
import org.gephi.ui.exporter.plugin.UIExporterGDFPanel;
import org.openide.util.NbBundle;

public class UIExporterGDF
implements ExporterUI {
    private final ExporterGDFSettings settings = new ExporterGDFSettings();
    private UIExporterGDFPanel panel;
    private ExporterGDF exporterGDF;

    public void setup(Exporter exporter) {
        this.exporterGDF = (ExporterGDF)exporter;
        this.settings.load(this.exporterGDF);
        if (this.panel != null) {
            this.panel.setup(this.exporterGDF);
        }
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterGDF);
            this.settings.save(this.exporterGDF);
        }
        this.panel = null;
        this.exporterGDF = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterGDFPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterGDF;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterGDF.class, (String)"UIExporterGDF.name");
    }

    private static class ExporterGDFSettings
    extends AbstractExporterSettings {
        private static final String NORMALIZE = "GDF_normalize";
        private static final String SIMPLE_QUOTES = "GDF_simpleQuotes";
        private static final String USE_QUOTES = "GDF_useQuotes";
        private static final String EXPORT_COLORS = "GDF_exportColors";
        private static final String EXPORT_POSITION = "GDF_exportPosition";
        private static final String EXPORT_ATTRIBUTES = "GDF_exportAttributes";
        private static final String EXPORT_VISIBILITY = "GDF_exportVisibility";
        private static final ExporterGDF DEFAULT = new ExporterGDF();

        private ExporterGDFSettings() {
        }

        private void save(ExporterGDF exporterGDF) {
            this.put(NORMALIZE, exporterGDF.isNormalize());
            this.put(SIMPLE_QUOTES, exporterGDF.isSimpleQuotes());
            this.put(USE_QUOTES, exporterGDF.isUseQuotes());
            this.put(EXPORT_COLORS, exporterGDF.isExportColors());
            this.put(EXPORT_POSITION, exporterGDF.isExportPosition());
            this.put(EXPORT_ATTRIBUTES, exporterGDF.isExportAttributes());
            this.put(EXPORT_VISIBILITY, exporterGDF.isExportVisibility());
        }

        private void load(ExporterGDF exporterGDF) {
            exporterGDF.setNormalize(this.get(NORMALIZE, DEFAULT.isNormalize()));
            exporterGDF.setSimpleQuotes(this.get(SIMPLE_QUOTES, DEFAULT.isSimpleQuotes()));
            exporterGDF.setUseQuotes(this.get(USE_QUOTES, DEFAULT.isUseQuotes()));
            exporterGDF.setExportColors(this.get(EXPORT_COLORS, DEFAULT.isExportColors()));
            exporterGDF.setExportAttributes(this.get(EXPORT_ATTRIBUTES, DEFAULT.isExportAttributes()));
            exporterGDF.setExportPosition(this.get(EXPORT_POSITION, DEFAULT.isExportPosition()));
            exporterGDF.setExportVisibility(this.get(EXPORT_VISIBILITY, DEFAULT.isExportVisibility()));
        }
    }
}

