/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.utils;

import java.awt.Color;

public class GradientUtils {

    public static class LinearGradient {
        private Color[] colors;
        private float[] positions;

        public LinearGradient(Color[] colors, float[] positions) {
            if (colors == null || positions == null) {
                throw new NullPointerException();
            }
            if (colors.length != positions.length) {
                throw new IllegalArgumentException();
            }
            this.colors = colors;
            this.positions = positions;
        }

        public Color getValue(float pos) {
            for (int a = 0; a < this.positions.length - 1; ++a) {
                if (this.positions[a] == pos) {
                    return this.colors[a];
                }
                if (!(this.positions[a] < pos) || !(pos < this.positions[a + 1])) continue;
                float v = (pos - this.positions[a]) / (this.positions[a + 1] - this.positions[a]);
                return this.tween(this.colors[a], this.colors[a + 1], v);
            }
            if (pos <= this.positions[0]) {
                return this.colors[0];
            }
            if (pos >= this.positions[this.positions.length - 1]) {
                return this.colors[this.colors.length - 1];
            }
            return null;
        }

        private Color tween(Color c1, Color c2, float p) {
            return new Color((int)((float)c1.getRed() * (1.0f - p) + (float)c2.getRed() * p), (int)((float)c1.getGreen() * (1.0f - p) + (float)c2.getGreen() * p), (int)((float)c1.getBlue() * (1.0f - p) + (float)c2.getBlue() * p), (int)((float)c1.getAlpha() * (1.0f - p) + (float)c2.getAlpha() * p));
        }

        public Color[] getColors() {
            return this.colors;
        }

        public void setColors(Color[] colors) {
            this.colors = colors;
        }

        public float[] getPositions() {
            return this.positions;
        }

        public void setPositions(float[] positions) {
            this.positions = positions;
        }
    }
}

