
#pragma once


#include <glbinding/nogl.h>

#include <glbinding/glbinding_features.h>

#include <type_traits>


namespace gl
{


enum class GLenum : unsigned int
{
    // AccumOp

    GL_ACCUM                                                      = 0x0100,
    GL_LOAD                                                       = 0x0101,
    GL_RETURN                                                     = 0x0102,
    GL_MULT                                                       = 0x0103,
    GL_ADD                                                        = 0x0104,

    // AlphaFunction

    GL_NEVER                                                      = 0x0200,
    GL_LESS                                                       = 0x0201,
    GL_EQUAL                                                      = 0x0202,
    GL_LEQUAL                                                     = 0x0203,
    GL_GREATER                                                    = 0x0204,
    GL_NOTEQUAL                                                   = 0x0205,
    GL_GEQUAL                                                     = 0x0206,
    GL_ALWAYS                                                     = 0x0207,

    // ArrayObjectPNameATI

    GL_OBJECT_BUFFER_SIZE_ATI                                     = 0x8764,
    GL_OBJECT_BUFFER_USAGE_ATI                                    = 0x8765,

    // ArrayObjectUsageATI

    GL_STATIC_ATI                                                 = 0x8760,
    GL_DYNAMIC_ATI                                                = 0x8761,

    // AtomicCounterBufferPName

    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER         = 0x90ED,
    GL_ATOMIC_COUNTER_BUFFER_BINDING                              = 0x92C1,
    GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE                            = 0x92C4,
    GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS               = 0x92C5,
    GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES        = 0x92C6,
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER          = 0x92C7,
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER    = 0x92C8,
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x92C9,
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER        = 0x92CA,
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER        = 0x92CB,

    // AttributeType

    GL_INT                                                        = 0x1404,
    GL_UNSIGNED_INT                                               = 0x1405,
    GL_FLOAT                                                      = 0x1406,
    GL_DOUBLE                                                     = 0x140A,
    GL_INT64_ARB                                                  = 0x140E,
    GL_INT64_NV                                                   = 0x140E,
    GL_UNSIGNED_INT64_ARB                                         = 0x140F,
    GL_UNSIGNED_INT64_NV                                          = 0x140F,
    GL_FLOAT_VEC2                                                 = 0x8B50,
    GL_FLOAT_VEC2_ARB                                             = 0x8B50,
    GL_FLOAT_VEC3                                                 = 0x8B51,
    GL_FLOAT_VEC3_ARB                                             = 0x8B51,
    GL_FLOAT_VEC4                                                 = 0x8B52,
    GL_FLOAT_VEC4_ARB                                             = 0x8B52,
    GL_INT_VEC2                                                   = 0x8B53,
    GL_INT_VEC2_ARB                                               = 0x8B53,
    GL_INT_VEC3                                                   = 0x8B54,
    GL_INT_VEC3_ARB                                               = 0x8B54,
    GL_INT_VEC4                                                   = 0x8B55,
    GL_INT_VEC4_ARB                                               = 0x8B55,
    GL_BOOL                                                       = 0x8B56,
    GL_BOOL_ARB                                                   = 0x8B56,
    GL_BOOL_VEC2                                                  = 0x8B57,
    GL_BOOL_VEC2_ARB                                              = 0x8B57,
    GL_BOOL_VEC3                                                  = 0x8B58,
    GL_BOOL_VEC3_ARB                                              = 0x8B58,
    GL_BOOL_VEC4                                                  = 0x8B59,
    GL_BOOL_VEC4_ARB                                              = 0x8B59,
    GL_FLOAT_MAT2                                                 = 0x8B5A,
    GL_FLOAT_MAT2_ARB                                             = 0x8B5A,
    GL_FLOAT_MAT3                                                 = 0x8B5B,
    GL_FLOAT_MAT3_ARB                                             = 0x8B5B,
    GL_FLOAT_MAT4                                                 = 0x8B5C,
    GL_FLOAT_MAT4_ARB                                             = 0x8B5C,
    GL_SAMPLER_1D                                                 = 0x8B5D,
    GL_SAMPLER_1D_ARB                                             = 0x8B5D,
    GL_SAMPLER_2D                                                 = 0x8B5E,
    GL_SAMPLER_2D_ARB                                             = 0x8B5E,
    GL_SAMPLER_3D                                                 = 0x8B5F,
    GL_SAMPLER_3D_ARB                                             = 0x8B5F,
    GL_SAMPLER_CUBE                                               = 0x8B60,
    GL_SAMPLER_CUBE_ARB                                           = 0x8B60,
    GL_SAMPLER_1D_SHADOW                                          = 0x8B61,
    GL_SAMPLER_1D_SHADOW_ARB                                      = 0x8B61,
    GL_SAMPLER_2D_SHADOW                                          = 0x8B62,
    GL_SAMPLER_2D_SHADOW_ARB                                      = 0x8B62,
    GL_SAMPLER_2D_RECT                                            = 0x8B63,
    GL_SAMPLER_2D_RECT_ARB                                        = 0x8B63,
    GL_SAMPLER_2D_RECT_SHADOW                                     = 0x8B64,
    GL_SAMPLER_2D_RECT_SHADOW_ARB                                 = 0x8B64,
    GL_FLOAT_MAT2x3                                               = 0x8B65,
    GL_FLOAT_MAT2x4                                               = 0x8B66,
    GL_FLOAT_MAT3x2                                               = 0x8B67,
    GL_FLOAT_MAT3x4                                               = 0x8B68,
    GL_FLOAT_MAT4x2                                               = 0x8B69,
    GL_FLOAT_MAT4x3                                               = 0x8B6A,
    GL_SAMPLER_BUFFER                                             = 0x8DC2,
    GL_SAMPLER_1D_ARRAY_SHADOW                                    = 0x8DC3,
    GL_SAMPLER_2D_ARRAY_SHADOW                                    = 0x8DC4,
    GL_SAMPLER_CUBE_SHADOW                                        = 0x8DC5,
    GL_UNSIGNED_INT_VEC2                                          = 0x8DC6,
    GL_UNSIGNED_INT_VEC3                                          = 0x8DC7,
    GL_UNSIGNED_INT_VEC4                                          = 0x8DC8,
    GL_INT_SAMPLER_1D                                             = 0x8DC9,
    GL_INT_SAMPLER_2D                                             = 0x8DCA,
    GL_INT_SAMPLER_3D                                             = 0x8DCB,
    GL_INT_SAMPLER_CUBE                                           = 0x8DCC,
    GL_INT_SAMPLER_2D_RECT                                        = 0x8DCD,
    GL_INT_SAMPLER_1D_ARRAY                                       = 0x8DCE,
    GL_INT_SAMPLER_2D_ARRAY                                       = 0x8DCF,
    GL_INT_SAMPLER_BUFFER                                         = 0x8DD0,
    GL_UNSIGNED_INT_SAMPLER_1D                                    = 0x8DD1,
    GL_UNSIGNED_INT_SAMPLER_2D                                    = 0x8DD2,
    GL_UNSIGNED_INT_SAMPLER_3D                                    = 0x8DD3,
    GL_UNSIGNED_INT_SAMPLER_CUBE                                  = 0x8DD4,
    GL_UNSIGNED_INT_SAMPLER_2D_RECT                               = 0x8DD5,
    GL_UNSIGNED_INT_SAMPLER_1D_ARRAY                              = 0x8DD6,
    GL_UNSIGNED_INT_SAMPLER_2D_ARRAY                              = 0x8DD7,
    GL_UNSIGNED_INT_SAMPLER_BUFFER                                = 0x8DD8,
    GL_DOUBLE_MAT2                                                = 0x8F46,
    GL_DOUBLE_MAT3                                                = 0x8F47,
    GL_DOUBLE_MAT4                                                = 0x8F48,
    GL_DOUBLE_MAT2x3                                              = 0x8F49,
    GL_DOUBLE_MAT2x4                                              = 0x8F4A,
    GL_DOUBLE_MAT3x2                                              = 0x8F4B,
    GL_DOUBLE_MAT3x4                                              = 0x8F4C,
    GL_DOUBLE_MAT4x2                                              = 0x8F4D,
    GL_DOUBLE_MAT4x3                                              = 0x8F4E,
    GL_INT64_VEC2_ARB                                             = 0x8FE9,
    GL_INT64_VEC3_ARB                                             = 0x8FEA,
    GL_INT64_VEC4_ARB                                             = 0x8FEB,
    GL_UNSIGNED_INT64_VEC2_ARB                                    = 0x8FF5,
    GL_UNSIGNED_INT64_VEC3_ARB                                    = 0x8FF6,
    GL_UNSIGNED_INT64_VEC4_ARB                                    = 0x8FF7,
    GL_DOUBLE_VEC2                                                = 0x8FFC,
    GL_DOUBLE_VEC3                                                = 0x8FFD,
    GL_DOUBLE_VEC4                                                = 0x8FFE,
    GL_SAMPLER_CUBE_MAP_ARRAY                                     = 0x900C,
    GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW                              = 0x900D,
    GL_INT_SAMPLER_CUBE_MAP_ARRAY                                 = 0x900E,
    GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY                        = 0x900F,
    GL_IMAGE_1D                                                   = 0x904C,
    GL_IMAGE_2D                                                   = 0x904D,
    GL_IMAGE_3D                                                   = 0x904E,
    GL_IMAGE_2D_RECT                                              = 0x904F,
    GL_IMAGE_CUBE                                                 = 0x9050,
    GL_IMAGE_BUFFER                                               = 0x9051,
    GL_IMAGE_1D_ARRAY                                             = 0x9052,
    GL_IMAGE_2D_ARRAY                                             = 0x9053,
    GL_IMAGE_CUBE_MAP_ARRAY                                       = 0x9054,
    GL_IMAGE_2D_MULTISAMPLE                                       = 0x9055,
    GL_IMAGE_2D_MULTISAMPLE_ARRAY                                 = 0x9056,
    GL_INT_IMAGE_1D                                               = 0x9057,
    GL_INT_IMAGE_2D                                               = 0x9058,
    GL_INT_IMAGE_3D                                               = 0x9059,
    GL_INT_IMAGE_2D_RECT                                          = 0x905A,
    GL_INT_IMAGE_CUBE                                             = 0x905B,
    GL_INT_IMAGE_BUFFER                                           = 0x905C,
    GL_INT_IMAGE_1D_ARRAY                                         = 0x905D,
    GL_INT_IMAGE_2D_ARRAY                                         = 0x905E,
    GL_INT_IMAGE_CUBE_MAP_ARRAY                                   = 0x905F,
    GL_INT_IMAGE_2D_MULTISAMPLE                                   = 0x9060,
    GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY                             = 0x9061,
    GL_UNSIGNED_INT_IMAGE_1D                                      = 0x9062,
    GL_UNSIGNED_INT_IMAGE_2D                                      = 0x9063,
    GL_UNSIGNED_INT_IMAGE_3D                                      = 0x9064,
    GL_UNSIGNED_INT_IMAGE_2D_RECT                                 = 0x9065,
    GL_UNSIGNED_INT_IMAGE_CUBE                                    = 0x9066,
    GL_UNSIGNED_INT_IMAGE_BUFFER                                  = 0x9067,
    GL_UNSIGNED_INT_IMAGE_1D_ARRAY                                = 0x9068,
    GL_UNSIGNED_INT_IMAGE_2D_ARRAY                                = 0x9069,
    GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY                          = 0x906A,
    GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE                          = 0x906B,
    GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY                    = 0x906C,
    GL_SAMPLER_2D_MULTISAMPLE                                     = 0x9108,
    GL_INT_SAMPLER_2D_MULTISAMPLE                                 = 0x9109,
    GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE                        = 0x910A,
    GL_SAMPLER_2D_MULTISAMPLE_ARRAY                               = 0x910B,
    GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                           = 0x910C,
    GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                  = 0x910D,

    // BindTransformFeedbackTarget

    GL_TRANSFORM_FEEDBACK                                         = 0x8E22,

    // BinormalPointerTypeEXT

    GL_BYTE                                                       = 0x1400,
    GL_SHORT                                                      = 0x1402,
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // BlendEquationModeEXT

    GL_FUNC_ADD                                                   = 0x8006,
    GL_FUNC_ADD_EXT                                               = 0x8006,
    GL_MIN                                                        = 0x8007,
    GL_MIN_EXT                                                    = 0x8007,
    GL_MAX                                                        = 0x8008,
    GL_MAX_EXT                                                    = 0x8008,
    GL_FUNC_SUBTRACT                                              = 0x800A,
    GL_FUNC_SUBTRACT_EXT                                          = 0x800A,
    GL_FUNC_REVERSE_SUBTRACT                                      = 0x800B,
    GL_FUNC_REVERSE_SUBTRACT_EXT                                  = 0x800B,
    GL_ALPHA_MIN_SGIX                                             = 0x8320,
    GL_ALPHA_MAX_SGIX                                             = 0x8321,

    // BlendingFactor

    GL_ZERO                                                       = 0,
    GL_SRC_COLOR                                                  = 0x0300,
    GL_ONE_MINUS_SRC_COLOR                                        = 0x0301,
    GL_SRC_ALPHA                                                  = 0x0302,
    GL_ONE_MINUS_SRC_ALPHA                                        = 0x0303,
    GL_DST_ALPHA                                                  = 0x0304,
    GL_ONE_MINUS_DST_ALPHA                                        = 0x0305,
    GL_DST_COLOR                                                  = 0x0306,
    GL_ONE_MINUS_DST_COLOR                                        = 0x0307,
    GL_SRC_ALPHA_SATURATE                                         = 0x0308,
    GL_CONSTANT_COLOR                                             = 0x8001,
    GL_ONE_MINUS_CONSTANT_COLOR                                   = 0x8002,
    GL_CONSTANT_ALPHA                                             = 0x8003,
    GL_ONE_MINUS_CONSTANT_ALPHA                                   = 0x8004,
    GL_SRC1_ALPHA                                                 = 0x8589,
    GL_SRC1_COLOR                                                 = 0x88F9,
    GL_ONE_MINUS_SRC1_COLOR                                       = 0x88FA,
    GL_ONE_MINUS_SRC1_ALPHA                                       = 0x88FB,
    GL_ONE                                                        = 1,

    // BlitFramebufferFilter

    GL_NEAREST                                                    = 0x2600,
    GL_LINEAR                                                     = 0x2601,

    // Buffer

    GL_COLOR                                                      = 0x1800,
    GL_DEPTH                                                      = 0x1801,
    GL_STENCIL                                                    = 0x1802,

    // BufferAccessARB

    GL_READ_ONLY                                                  = 0x88B8,
    GL_WRITE_ONLY                                                 = 0x88B9,
    GL_READ_WRITE                                                 = 0x88BA,

    // BufferPNameARB

    GL_BUFFER_IMMUTABLE_STORAGE                                   = 0x821F,
    GL_BUFFER_STORAGE_FLAGS                                       = 0x8220,
    GL_BUFFER_SIZE                                                = 0x8764,
    GL_BUFFER_SIZE_ARB                                            = 0x8764,
    GL_BUFFER_USAGE                                               = 0x8765,
    GL_BUFFER_USAGE_ARB                                           = 0x8765,
    GL_BUFFER_ACCESS                                              = 0x88BB,
    GL_BUFFER_ACCESS_ARB                                          = 0x88BB,
    GL_BUFFER_MAPPED                                              = 0x88BC,
    GL_BUFFER_MAPPED_ARB                                          = 0x88BC,
    GL_BUFFER_ACCESS_FLAGS                                        = 0x911F,
    GL_BUFFER_MAP_LENGTH                                          = 0x9120,
    GL_BUFFER_MAP_OFFSET                                          = 0x9121,

    // BufferPointerNameARB

    GL_BUFFER_MAP_POINTER                                         = 0x88BD,
    GL_BUFFER_MAP_POINTER_ARB                                     = 0x88BD,

    // BufferStorageTarget

    GL_ARRAY_BUFFER                                               = 0x8892,
    GL_ELEMENT_ARRAY_BUFFER                                       = 0x8893,
    GL_PIXEL_PACK_BUFFER                                          = 0x88EB,
    GL_PIXEL_UNPACK_BUFFER                                        = 0x88EC,
    GL_UNIFORM_BUFFER                                             = 0x8A11,
    GL_TEXTURE_BUFFER                                             = 0x8C2A,
    GL_TRANSFORM_FEEDBACK_BUFFER                                  = 0x8C8E,
    GL_COPY_READ_BUFFER                                           = 0x8F36,
    GL_COPY_WRITE_BUFFER                                          = 0x8F37,
    GL_DRAW_INDIRECT_BUFFER                                       = 0x8F3F,
    GL_SHADER_STORAGE_BUFFER                                      = 0x90D2,
    GL_DISPATCH_INDIRECT_BUFFER                                   = 0x90EE,
    GL_QUERY_BUFFER                                               = 0x9192,
    GL_ATOMIC_COUNTER_BUFFER                                      = 0x92C0,

    // BufferTargetARB

    GL_PARAMETER_BUFFER                                           = 0x80EE,
//  GL_ARRAY_BUFFER                                               = 0x8892, // reuse BufferStorageTarget
//  GL_ELEMENT_ARRAY_BUFFER                                       = 0x8893, // reuse BufferStorageTarget
//  GL_PIXEL_PACK_BUFFER                                          = 0x88EB, // reuse BufferStorageTarget
//  GL_PIXEL_UNPACK_BUFFER                                        = 0x88EC, // reuse BufferStorageTarget
//  GL_UNIFORM_BUFFER                                             = 0x8A11, // reuse BufferStorageTarget
//  GL_TEXTURE_BUFFER                                             = 0x8C2A, // reuse BufferStorageTarget
//  GL_TRANSFORM_FEEDBACK_BUFFER                                  = 0x8C8E, // reuse BufferStorageTarget
//  GL_COPY_READ_BUFFER                                           = 0x8F36, // reuse BufferStorageTarget
//  GL_COPY_WRITE_BUFFER                                          = 0x8F37, // reuse BufferStorageTarget
//  GL_DRAW_INDIRECT_BUFFER                                       = 0x8F3F, // reuse BufferStorageTarget
//  GL_SHADER_STORAGE_BUFFER                                      = 0x90D2, // reuse BufferStorageTarget
//  GL_DISPATCH_INDIRECT_BUFFER                                   = 0x90EE, // reuse BufferStorageTarget
//  GL_QUERY_BUFFER                                               = 0x9192, // reuse BufferStorageTarget
//  GL_ATOMIC_COUNTER_BUFFER                                      = 0x92C0, // reuse BufferStorageTarget

    // BufferUsageARB

    GL_STREAM_DRAW                                                = 0x88E0,
    GL_STREAM_READ                                                = 0x88E1,
    GL_STREAM_COPY                                                = 0x88E2,
    GL_STATIC_DRAW                                                = 0x88E4,
    GL_STATIC_READ                                                = 0x88E5,
    GL_STATIC_COPY                                                = 0x88E6,
    GL_DYNAMIC_DRAW                                               = 0x88E8,
    GL_DYNAMIC_READ                                               = 0x88E9,
    GL_DYNAMIC_COPY                                               = 0x88EA,

    // ClampColorModeARB

    GL_FIXED_ONLY                                                 = 0x891D,
    GL_FIXED_ONLY_ARB                                             = 0x891D,

    // ClampColorTargetARB

    GL_CLAMP_VERTEX_COLOR_ARB                                     = 0x891A,
    GL_CLAMP_FRAGMENT_COLOR_ARB                                   = 0x891B,
    GL_CLAMP_READ_COLOR                                           = 0x891C,
    GL_CLAMP_READ_COLOR_ARB                                       = 0x891C,

    // ClipControlDepth

    GL_NEGATIVE_ONE_TO_ONE                                        = 0x935E,
    GL_ZERO_TO_ONE                                                = 0x935F,

    // ClipControlOrigin

    GL_LOWER_LEFT                                                 = 0x8CA1,
    GL_UPPER_LEFT                                                 = 0x8CA2,

    // ClipPlaneName

    GL_CLIP_PLANE0                                                = 0x3000,
    GL_CLIP_DISTANCE0                                             = 0x3000,
    GL_CLIP_PLANE1                                                = 0x3001,
    GL_CLIP_DISTANCE1                                             = 0x3001,
    GL_CLIP_PLANE2                                                = 0x3002,
    GL_CLIP_DISTANCE2                                             = 0x3002,
    GL_CLIP_PLANE3                                                = 0x3003,
    GL_CLIP_DISTANCE3                                             = 0x3003,
    GL_CLIP_PLANE4                                                = 0x3004,
    GL_CLIP_DISTANCE4                                             = 0x3004,
    GL_CLIP_PLANE5                                                = 0x3005,
    GL_CLIP_DISTANCE5                                             = 0x3005,
    GL_CLIP_DISTANCE6                                             = 0x3006,
    GL_CLIP_DISTANCE7                                             = 0x3007,

    // ColorBuffer

    GL_NONE                                                       = 0,
    GL_FRONT_LEFT                                                 = 0x0400,
    GL_FRONT_RIGHT                                                = 0x0401,
    GL_BACK_LEFT                                                  = 0x0402,
    GL_BACK_RIGHT                                                 = 0x0403,
    GL_FRONT                                                      = 0x0404,
    GL_BACK                                                       = 0x0405,
    GL_LEFT                                                       = 0x0406,
    GL_RIGHT                                                      = 0x0407,
    GL_FRONT_AND_BACK                                             = 0x0408,
    GL_COLOR_ATTACHMENT0                                          = 0x8CE0,
    GL_COLOR_ATTACHMENT1                                          = 0x8CE1,
    GL_COLOR_ATTACHMENT2                                          = 0x8CE2,
    GL_COLOR_ATTACHMENT3                                          = 0x8CE3,
    GL_COLOR_ATTACHMENT4                                          = 0x8CE4,
    GL_COLOR_ATTACHMENT5                                          = 0x8CE5,
    GL_COLOR_ATTACHMENT6                                          = 0x8CE6,
    GL_COLOR_ATTACHMENT7                                          = 0x8CE7,
    GL_COLOR_ATTACHMENT8                                          = 0x8CE8,
    GL_COLOR_ATTACHMENT9                                          = 0x8CE9,
    GL_COLOR_ATTACHMENT10                                         = 0x8CEA,
    GL_COLOR_ATTACHMENT11                                         = 0x8CEB,
    GL_COLOR_ATTACHMENT12                                         = 0x8CEC,
    GL_COLOR_ATTACHMENT13                                         = 0x8CED,
    GL_COLOR_ATTACHMENT14                                         = 0x8CEE,
    GL_COLOR_ATTACHMENT15                                         = 0x8CEF,
    GL_COLOR_ATTACHMENT16                                         = 0x8CF0,
    GL_COLOR_ATTACHMENT17                                         = 0x8CF1,
    GL_COLOR_ATTACHMENT18                                         = 0x8CF2,
    GL_COLOR_ATTACHMENT19                                         = 0x8CF3,
    GL_COLOR_ATTACHMENT20                                         = 0x8CF4,
    GL_COLOR_ATTACHMENT21                                         = 0x8CF5,
    GL_COLOR_ATTACHMENT22                                         = 0x8CF6,
    GL_COLOR_ATTACHMENT23                                         = 0x8CF7,
    GL_COLOR_ATTACHMENT24                                         = 0x8CF8,
    GL_COLOR_ATTACHMENT25                                         = 0x8CF9,
    GL_COLOR_ATTACHMENT26                                         = 0x8CFA,
    GL_COLOR_ATTACHMENT27                                         = 0x8CFB,
    GL_COLOR_ATTACHMENT28                                         = 0x8CFC,
    GL_COLOR_ATTACHMENT29                                         = 0x8CFD,
    GL_COLOR_ATTACHMENT30                                         = 0x8CFE,
    GL_COLOR_ATTACHMENT31                                         = 0x8CFF,

    // ColorMaterialParameter

    GL_AMBIENT                                                    = 0x1200,
    GL_DIFFUSE                                                    = 0x1201,
    GL_SPECULAR                                                   = 0x1202,
    GL_EMISSION                                                   = 0x1600,
    GL_AMBIENT_AND_DIFFUSE                                        = 0x1602,

    // ColorPointerType

//  GL_BYTE                                                       = 0x1400, // reuse BinormalPointerTypeEXT
    GL_UNSIGNED_BYTE                                              = 0x1401,
//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
    GL_UNSIGNED_SHORT                                             = 0x1403,
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // ColorTableParameterPName

    GL_COLOR_TABLE_SCALE                                          = 0x80D6,
    GL_COLOR_TABLE_SCALE_SGI                                      = 0x80D6,
    GL_COLOR_TABLE_BIAS                                           = 0x80D7,
    GL_COLOR_TABLE_BIAS_SGI                                       = 0x80D7,
    GL_COLOR_TABLE_FORMAT                                         = 0x80D8,
    GL_COLOR_TABLE_FORMAT_SGI                                     = 0x80D8,
    GL_COLOR_TABLE_WIDTH                                          = 0x80D9,
    GL_COLOR_TABLE_WIDTH_SGI                                      = 0x80D9,
    GL_COLOR_TABLE_RED_SIZE                                       = 0x80DA,
    GL_COLOR_TABLE_RED_SIZE_SGI                                   = 0x80DA,
    GL_COLOR_TABLE_GREEN_SIZE                                     = 0x80DB,
    GL_COLOR_TABLE_GREEN_SIZE_SGI                                 = 0x80DB,
    GL_COLOR_TABLE_BLUE_SIZE                                      = 0x80DC,
    GL_COLOR_TABLE_BLUE_SIZE_SGI                                  = 0x80DC,
    GL_COLOR_TABLE_ALPHA_SIZE                                     = 0x80DD,
    GL_COLOR_TABLE_ALPHA_SIZE_SGI                                 = 0x80DD,
    GL_COLOR_TABLE_LUMINANCE_SIZE                                 = 0x80DE,
    GL_COLOR_TABLE_LUMINANCE_SIZE_SGI                             = 0x80DE,
    GL_COLOR_TABLE_INTENSITY_SIZE                                 = 0x80DF,
    GL_COLOR_TABLE_INTENSITY_SIZE_SGI                             = 0x80DF,

    // ColorTableTarget

    GL_COLOR_TABLE                                                = 0x80D0,
    GL_POST_CONVOLUTION_COLOR_TABLE                               = 0x80D1,
    GL_POST_COLOR_MATRIX_COLOR_TABLE                              = 0x80D2,
    GL_PROXY_COLOR_TABLE                                          = 0x80D3,
    GL_PROXY_POST_CONVOLUTION_COLOR_TABLE                         = 0x80D4,
    GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE                        = 0x80D5,

    // ColorTableTargetSGI

    GL_TEXTURE_COLOR_TABLE_SGI                                    = 0x80BC,
    GL_PROXY_TEXTURE_COLOR_TABLE_SGI                              = 0x80BD,
//  GL_COLOR_TABLE                                                = 0x80D0, // reuse ColorTableTarget
    GL_COLOR_TABLE_SGI                                            = 0x80D0,
//  GL_POST_CONVOLUTION_COLOR_TABLE                               = 0x80D1, // reuse ColorTableTarget
    GL_POST_CONVOLUTION_COLOR_TABLE_SGI                           = 0x80D1,
//  GL_POST_COLOR_MATRIX_COLOR_TABLE                              = 0x80D2, // reuse ColorTableTarget
    GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI                          = 0x80D2,
//  GL_PROXY_COLOR_TABLE                                          = 0x80D3, // reuse ColorTableTarget
    GL_PROXY_COLOR_TABLE_SGI                                      = 0x80D3,
//  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE                         = 0x80D4, // reuse ColorTableTarget
    GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI                     = 0x80D4,
//  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE                        = 0x80D5, // reuse ColorTableTarget
    GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI                    = 0x80D5,

    // CombinerBiasNV

//  GL_NONE                                                       = 0, // reuse ColorBuffer
    GL_BIAS_BY_NEGATIVE_ONE_HALF_NV                               = 0x8541,

    // CombinerComponentUsageNV

    GL_BLUE                                                       = 0x1905,
    GL_ALPHA                                                      = 0x1906,
    GL_RGB                                                        = 0x1907,

    // CombinerMappingNV

    GL_UNSIGNED_IDENTITY_NV                                       = 0x8536,
    GL_UNSIGNED_INVERT_NV                                         = 0x8537,
    GL_EXPAND_NORMAL_NV                                           = 0x8538,
    GL_EXPAND_NEGATE_NV                                           = 0x8539,
    GL_HALF_BIAS_NORMAL_NV                                        = 0x853A,
    GL_HALF_BIAS_NEGATE_NV                                        = 0x853B,
    GL_SIGNED_IDENTITY_NV                                         = 0x853C,
    GL_SIGNED_NEGATE_NV                                           = 0x853D,

    // CombinerParameterNV

    GL_COMBINER_INPUT_NV                                          = 0x8542,
    GL_COMBINER_MAPPING_NV                                        = 0x8543,
    GL_COMBINER_COMPONENT_USAGE_NV                                = 0x8544,

    // CombinerPortionNV

//  GL_ALPHA                                                      = 0x1906, // reuse CombinerComponentUsageNV
//  GL_RGB                                                        = 0x1907, // reuse CombinerComponentUsageNV

    // CombinerRegisterNV

    GL_TEXTURE0_ARB                                               = 0x84C0,
    GL_TEXTURE1_ARB                                               = 0x84C1,
    GL_PRIMARY_COLOR_NV                                           = 0x852C,
    GL_SECONDARY_COLOR_NV                                         = 0x852D,
    GL_SPARE0_NV                                                  = 0x852E,
    GL_SPARE1_NV                                                  = 0x852F,
    GL_DISCARD_NV                                                 = 0x8530,

    // CombinerScaleNV

//  GL_NONE                                                       = 0, // reuse ColorBuffer
    GL_SCALE_BY_TWO_NV                                            = 0x853E,
    GL_SCALE_BY_FOUR_NV                                           = 0x853F,
    GL_SCALE_BY_ONE_HALF_NV                                       = 0x8540,

    // CombinerStageNV

    GL_COMBINER0_NV                                               = 0x8550,
    GL_COMBINER1_NV                                               = 0x8551,
    GL_COMBINER2_NV                                               = 0x8552,
    GL_COMBINER3_NV                                               = 0x8553,
    GL_COMBINER4_NV                                               = 0x8554,
    GL_COMBINER5_NV                                               = 0x8555,
    GL_COMBINER6_NV                                               = 0x8556,
    GL_COMBINER7_NV                                               = 0x8557,

    // CombinerVariableNV

    GL_VARIABLE_A_NV                                              = 0x8523,
    GL_VARIABLE_B_NV                                              = 0x8524,
    GL_VARIABLE_C_NV                                              = 0x8525,
    GL_VARIABLE_D_NV                                              = 0x8526,
    GL_VARIABLE_E_NV                                              = 0x8527,
    GL_VARIABLE_F_NV                                              = 0x8528,
    GL_VARIABLE_G_NV                                              = 0x8529,

    // CommandOpcodesNV

    GL_TERMINATE_SEQUENCE_COMMAND_NV                              = 0x0000,
    GL_NOP_COMMAND_NV                                             = 0x0001,
    GL_DRAW_ELEMENTS_COMMAND_NV                                   = 0x0002,
    GL_DRAW_ARRAYS_COMMAND_NV                                     = 0x0003,
    GL_DRAW_ELEMENTS_STRIP_COMMAND_NV                             = 0x0004,
    GL_DRAW_ARRAYS_STRIP_COMMAND_NV                               = 0x0005,
    GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV                         = 0x0006,
    GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV                           = 0x0007,
    GL_ELEMENT_ADDRESS_COMMAND_NV                                 = 0x0008,
    GL_ATTRIBUTE_ADDRESS_COMMAND_NV                               = 0x0009,
    GL_UNIFORM_ADDRESS_COMMAND_NV                                 = 0x000A,
    GL_BLEND_COLOR_COMMAND_NV                                     = 0x000B,
    GL_STENCIL_REF_COMMAND_NV                                     = 0x000C,
    GL_LINE_WIDTH_COMMAND_NV                                      = 0x000D,
    GL_POLYGON_OFFSET_COMMAND_NV                                  = 0x000E,
    GL_ALPHA_REF_COMMAND_NV                                       = 0x000F,
    GL_VIEWPORT_COMMAND_NV                                        = 0x0010,
    GL_SCISSOR_COMMAND_NV                                         = 0x0011,
    GL_FRONT_FACE_COMMAND_NV                                      = 0x0012,

    // ConditionalRenderMode

    GL_QUERY_WAIT                                                 = 0x8E13,
    GL_QUERY_NO_WAIT                                              = 0x8E14,
    GL_QUERY_BY_REGION_WAIT                                       = 0x8E15,
    GL_QUERY_BY_REGION_NO_WAIT                                    = 0x8E16,
    GL_QUERY_WAIT_INVERTED                                        = 0x8E17,
    GL_QUERY_NO_WAIT_INVERTED                                     = 0x8E18,
    GL_QUERY_BY_REGION_WAIT_INVERTED                              = 0x8E19,
    GL_QUERY_BY_REGION_NO_WAIT_INVERTED                           = 0x8E1A,

    // ContainerType

    GL_PROGRAM_OBJECT_ARB                                         = 0x8B40,
    GL_PROGRAM_OBJECT_EXT                                         = 0x8B40,

    // ConvolutionBorderModeEXT

    GL_REDUCE                                                     = 0x8016,
    GL_REDUCE_EXT                                                 = 0x8016,

    // ConvolutionParameter

    GL_CONVOLUTION_BORDER_MODE                                    = 0x8013,
    GL_CONVOLUTION_BORDER_MODE_EXT                                = 0x8013,
    GL_CONVOLUTION_FILTER_SCALE                                   = 0x8014,
    GL_CONVOLUTION_FILTER_SCALE_EXT                               = 0x8014,
    GL_CONVOLUTION_FILTER_BIAS                                    = 0x8015,
    GL_CONVOLUTION_FILTER_BIAS_EXT                                = 0x8015,
    GL_CONVOLUTION_FORMAT                                         = 0x8017,
    GL_CONVOLUTION_FORMAT_EXT                                     = 0x8017,
    GL_CONVOLUTION_WIDTH                                          = 0x8018,
    GL_CONVOLUTION_WIDTH_EXT                                      = 0x8018,
    GL_CONVOLUTION_HEIGHT                                         = 0x8019,
    GL_CONVOLUTION_HEIGHT_EXT                                     = 0x8019,
    GL_MAX_CONVOLUTION_WIDTH                                      = 0x801A,
    GL_MAX_CONVOLUTION_WIDTH_EXT                                  = 0x801A,
    GL_MAX_CONVOLUTION_HEIGHT                                     = 0x801B,
    GL_MAX_CONVOLUTION_HEIGHT_EXT                                 = 0x801B,
    GL_CONVOLUTION_BORDER_COLOR                                   = 0x8154,

    // ConvolutionTarget

    GL_CONVOLUTION_1D                                             = 0x8010,
    GL_CONVOLUTION_2D                                             = 0x8011,

    // ConvolutionTargetEXT

//  GL_CONVOLUTION_1D                                             = 0x8010, // reuse ConvolutionTarget
    GL_CONVOLUTION_1D_EXT                                         = 0x8010,
//  GL_CONVOLUTION_2D                                             = 0x8011, // reuse ConvolutionTarget
    GL_CONVOLUTION_2D_EXT                                         = 0x8011,

    // CopyBufferSubDataTarget

//  GL_ARRAY_BUFFER                                               = 0x8892, // reuse BufferStorageTarget
//  GL_ELEMENT_ARRAY_BUFFER                                       = 0x8893, // reuse BufferStorageTarget
//  GL_PIXEL_PACK_BUFFER                                          = 0x88EB, // reuse BufferStorageTarget
//  GL_PIXEL_UNPACK_BUFFER                                        = 0x88EC, // reuse BufferStorageTarget
//  GL_UNIFORM_BUFFER                                             = 0x8A11, // reuse BufferStorageTarget
//  GL_TEXTURE_BUFFER                                             = 0x8C2A, // reuse BufferStorageTarget
//  GL_TRANSFORM_FEEDBACK_BUFFER                                  = 0x8C8E, // reuse BufferStorageTarget
//  GL_COPY_READ_BUFFER                                           = 0x8F36, // reuse BufferStorageTarget
//  GL_COPY_WRITE_BUFFER                                          = 0x8F37, // reuse BufferStorageTarget
//  GL_DRAW_INDIRECT_BUFFER                                       = 0x8F3F, // reuse BufferStorageTarget
//  GL_SHADER_STORAGE_BUFFER                                      = 0x90D2, // reuse BufferStorageTarget
//  GL_DISPATCH_INDIRECT_BUFFER                                   = 0x90EE, // reuse BufferStorageTarget
//  GL_QUERY_BUFFER                                               = 0x9192, // reuse BufferStorageTarget
//  GL_ATOMIC_COUNTER_BUFFER                                      = 0x92C0, // reuse BufferStorageTarget

    // CopyImageSubDataTarget

    GL_TEXTURE_1D                                                 = 0x0DE0,
    GL_TEXTURE_2D                                                 = 0x0DE1,
    GL_TEXTURE_3D                                                 = 0x806F,
    GL_TEXTURE_RECTANGLE                                          = 0x84F5,
    GL_TEXTURE_CUBE_MAP                                           = 0x8513,
    GL_TEXTURE_1D_ARRAY                                           = 0x8C18,
    GL_TEXTURE_2D_ARRAY                                           = 0x8C1A,
    GL_RENDERBUFFER                                               = 0x8D41,
    GL_TEXTURE_CUBE_MAP_ARRAY                                     = 0x9009,
    GL_TEXTURE_2D_MULTISAMPLE                                     = 0x9100,
    GL_TEXTURE_2D_MULTISAMPLE_ARRAY                               = 0x9102,

    // CullParameterEXT

    GL_CULL_VERTEX_EYE_POSITION_EXT                               = 0x81AB,
    GL_CULL_VERTEX_OBJECT_POSITION_EXT                            = 0x81AC,

    // DataTypeEXT

    GL_SCALAR_EXT                                                 = 0x87BE,
    GL_VECTOR_EXT                                                 = 0x87BF,
    GL_MATRIX_EXT                                                 = 0x87C0,

    // DebugSeverity

    GL_DONT_CARE                                                  = 0x1100,
    GL_DEBUG_SEVERITY_NOTIFICATION                                = 0x826B,
    GL_DEBUG_SEVERITY_HIGH                                        = 0x9146,
    GL_DEBUG_SEVERITY_MEDIUM                                      = 0x9147,
    GL_DEBUG_SEVERITY_LOW                                         = 0x9148,

    // DebugSource

//  GL_DONT_CARE                                                  = 0x1100, // reuse DebugSeverity
    GL_DEBUG_SOURCE_API                                           = 0x8246,
    GL_DEBUG_SOURCE_WINDOW_SYSTEM                                 = 0x8247,
    GL_DEBUG_SOURCE_SHADER_COMPILER                               = 0x8248,
    GL_DEBUG_SOURCE_THIRD_PARTY                                   = 0x8249,
    GL_DEBUG_SOURCE_APPLICATION                                   = 0x824A,
    GL_DEBUG_SOURCE_OTHER                                         = 0x824B,

    // DebugType

//  GL_DONT_CARE                                                  = 0x1100, // reuse DebugSeverity
    GL_DEBUG_TYPE_ERROR                                           = 0x824C,
    GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR                             = 0x824D,
    GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR                              = 0x824E,
    GL_DEBUG_TYPE_PORTABILITY                                     = 0x824F,
    GL_DEBUG_TYPE_PERFORMANCE                                     = 0x8250,
    GL_DEBUG_TYPE_OTHER                                           = 0x8251,
    GL_DEBUG_TYPE_MARKER                                          = 0x8268,
    GL_DEBUG_TYPE_PUSH_GROUP                                      = 0x8269,
    GL_DEBUG_TYPE_POP_GROUP                                       = 0x826A,

    // DepthFunction

//  GL_NEVER                                                      = 0x0200, // reuse AlphaFunction
//  GL_LESS                                                       = 0x0201, // reuse AlphaFunction
//  GL_EQUAL                                                      = 0x0202, // reuse AlphaFunction
//  GL_LEQUAL                                                     = 0x0203, // reuse AlphaFunction
//  GL_GREATER                                                    = 0x0204, // reuse AlphaFunction
//  GL_NOTEQUAL                                                   = 0x0205, // reuse AlphaFunction
//  GL_GEQUAL                                                     = 0x0206, // reuse AlphaFunction
//  GL_ALWAYS                                                     = 0x0207, // reuse AlphaFunction

    // DepthStencilTextureMode

    GL_STENCIL_INDEX                                              = 0x1901,
    GL_DEPTH_COMPONENT                                            = 0x1902,

    // DrawBufferMode

//  GL_NONE                                                       = 0, // reuse ColorBuffer
//  GL_FRONT_LEFT                                                 = 0x0400, // reuse ColorBuffer
//  GL_FRONT_RIGHT                                                = 0x0401, // reuse ColorBuffer
//  GL_BACK_LEFT                                                  = 0x0402, // reuse ColorBuffer
//  GL_BACK_RIGHT                                                 = 0x0403, // reuse ColorBuffer
//  GL_FRONT                                                      = 0x0404, // reuse ColorBuffer
//  GL_BACK                                                       = 0x0405, // reuse ColorBuffer
//  GL_LEFT                                                       = 0x0406, // reuse ColorBuffer
//  GL_RIGHT                                                      = 0x0407, // reuse ColorBuffer
//  GL_FRONT_AND_BACK                                             = 0x0408, // reuse ColorBuffer
    GL_AUX0                                                       = 0x0409,
    GL_AUX1                                                       = 0x040A,
    GL_AUX2                                                       = 0x040B,
    GL_AUX3                                                       = 0x040C,
//  GL_COLOR_ATTACHMENT0                                          = 0x8CE0, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT1                                          = 0x8CE1, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT2                                          = 0x8CE2, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT3                                          = 0x8CE3, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT4                                          = 0x8CE4, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT5                                          = 0x8CE5, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT6                                          = 0x8CE6, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT7                                          = 0x8CE7, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT8                                          = 0x8CE8, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT9                                          = 0x8CE9, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT10                                         = 0x8CEA, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT11                                         = 0x8CEB, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT12                                         = 0x8CEC, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT13                                         = 0x8CED, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT14                                         = 0x8CEE, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT15                                         = 0x8CEF, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT16                                         = 0x8CF0, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT17                                         = 0x8CF1, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT18                                         = 0x8CF2, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT19                                         = 0x8CF3, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT20                                         = 0x8CF4, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT21                                         = 0x8CF5, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT22                                         = 0x8CF6, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT23                                         = 0x8CF7, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT24                                         = 0x8CF8, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT25                                         = 0x8CF9, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT26                                         = 0x8CFA, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT27                                         = 0x8CFB, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT28                                         = 0x8CFC, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT29                                         = 0x8CFD, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT30                                         = 0x8CFE, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT31                                         = 0x8CFF, // reuse ColorBuffer

    // DrawElementsType

//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType

    // ElementPointerTypeATI

//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType

    // EnableCap

    GL_POINT_SMOOTH                                               = 0x0B10,
    GL_LINE_SMOOTH                                                = 0x0B20,
    GL_LINE_STIPPLE                                               = 0x0B24,
    GL_POLYGON_SMOOTH                                             = 0x0B41,
    GL_POLYGON_STIPPLE                                            = 0x0B42,
    GL_CULL_FACE                                                  = 0x0B44,
    GL_LIGHTING                                                   = 0x0B50,
    GL_COLOR_MATERIAL                                             = 0x0B57,
    GL_FOG                                                        = 0x0B60,
    GL_DEPTH_TEST                                                 = 0x0B71,
    GL_STENCIL_TEST                                               = 0x0B90,
    GL_NORMALIZE                                                  = 0x0BA1,
    GL_ALPHA_TEST                                                 = 0x0BC0,
    GL_DITHER                                                     = 0x0BD0,
    GL_BLEND                                                      = 0x0BE2,
    GL_INDEX_LOGIC_OP                                             = 0x0BF1,
    GL_COLOR_LOGIC_OP                                             = 0x0BF2,
    GL_SCISSOR_TEST                                               = 0x0C11,
    GL_TEXTURE_GEN_S                                              = 0x0C60,
    GL_TEXTURE_GEN_T                                              = 0x0C61,
    GL_TEXTURE_GEN_R                                              = 0x0C62,
    GL_TEXTURE_GEN_Q                                              = 0x0C63,
    GL_AUTO_NORMAL                                                = 0x0D80,
    GL_MAP1_COLOR_4                                               = 0x0D90,
    GL_MAP1_INDEX                                                 = 0x0D91,
    GL_MAP1_NORMAL                                                = 0x0D92,
    GL_MAP1_TEXTURE_COORD_1                                       = 0x0D93,
    GL_MAP1_TEXTURE_COORD_2                                       = 0x0D94,
    GL_MAP1_TEXTURE_COORD_3                                       = 0x0D95,
    GL_MAP1_TEXTURE_COORD_4                                       = 0x0D96,
    GL_MAP1_VERTEX_3                                              = 0x0D97,
    GL_MAP1_VERTEX_4                                              = 0x0D98,
    GL_MAP2_COLOR_4                                               = 0x0DB0,
    GL_MAP2_INDEX                                                 = 0x0DB1,
    GL_MAP2_NORMAL                                                = 0x0DB2,
    GL_MAP2_TEXTURE_COORD_1                                       = 0x0DB3,
    GL_MAP2_TEXTURE_COORD_2                                       = 0x0DB4,
    GL_MAP2_TEXTURE_COORD_3                                       = 0x0DB5,
    GL_MAP2_TEXTURE_COORD_4                                       = 0x0DB6,
    GL_MAP2_VERTEX_3                                              = 0x0DB7,
    GL_MAP2_VERTEX_4                                              = 0x0DB8,
//  GL_TEXTURE_1D                                                 = 0x0DE0, // reuse CopyImageSubDataTarget
//  GL_TEXTURE_2D                                                 = 0x0DE1, // reuse CopyImageSubDataTarget
    GL_POLYGON_OFFSET_POINT                                       = 0x2A01,
    GL_POLYGON_OFFSET_LINE                                        = 0x2A02,
//  GL_CLIP_PLANE0                                                = 0x3000, // reuse ClipPlaneName
//  GL_CLIP_DISTANCE0                                             = 0x3000, // reuse ClipPlaneName
//  GL_CLIP_PLANE1                                                = 0x3001, // reuse ClipPlaneName
//  GL_CLIP_DISTANCE1                                             = 0x3001, // reuse ClipPlaneName
//  GL_CLIP_PLANE2                                                = 0x3002, // reuse ClipPlaneName
//  GL_CLIP_DISTANCE2                                             = 0x3002, // reuse ClipPlaneName
//  GL_CLIP_PLANE3                                                = 0x3003, // reuse ClipPlaneName
//  GL_CLIP_DISTANCE3                                             = 0x3003, // reuse ClipPlaneName
//  GL_CLIP_PLANE4                                                = 0x3004, // reuse ClipPlaneName
//  GL_CLIP_DISTANCE4                                             = 0x3004, // reuse ClipPlaneName
//  GL_CLIP_PLANE5                                                = 0x3005, // reuse ClipPlaneName
//  GL_CLIP_DISTANCE5                                             = 0x3005, // reuse ClipPlaneName
//  GL_CLIP_DISTANCE6                                             = 0x3006, // reuse ClipPlaneName
//  GL_CLIP_DISTANCE7                                             = 0x3007, // reuse ClipPlaneName
    GL_LIGHT0                                                     = 0x4000,
    GL_LIGHT1                                                     = 0x4001,
    GL_LIGHT2                                                     = 0x4002,
    GL_LIGHT3                                                     = 0x4003,
    GL_LIGHT4                                                     = 0x4004,
    GL_LIGHT5                                                     = 0x4005,
    GL_LIGHT6                                                     = 0x4006,
    GL_LIGHT7                                                     = 0x4007,
//  GL_CONVOLUTION_1D_EXT                                         = 0x8010, // reuse ConvolutionTargetEXT
//  GL_CONVOLUTION_2D_EXT                                         = 0x8011, // reuse ConvolutionTargetEXT
    GL_SEPARABLE_2D_EXT                                           = 0x8012,
    GL_HISTOGRAM_EXT                                              = 0x8024,
    GL_MINMAX_EXT                                                 = 0x802E,
    GL_POLYGON_OFFSET_FILL                                        = 0x8037,
    GL_RESCALE_NORMAL_EXT                                         = 0x803A,
    GL_TEXTURE_3D_EXT                                             = 0x806F,
    GL_VERTEX_ARRAY                                               = 0x8074,
    GL_NORMAL_ARRAY                                               = 0x8075,
    GL_COLOR_ARRAY                                                = 0x8076,
    GL_INDEX_ARRAY                                                = 0x8077,
    GL_TEXTURE_COORD_ARRAY                                        = 0x8078,
    GL_EDGE_FLAG_ARRAY                                            = 0x8079,
    GL_INTERLACE_SGIX                                             = 0x8094,
    GL_MULTISAMPLE                                                = 0x809D,
    GL_MULTISAMPLE_SGIS                                           = 0x809D,
    GL_SAMPLE_ALPHA_TO_COVERAGE                                   = 0x809E,
    GL_SAMPLE_ALPHA_TO_MASK_SGIS                                  = 0x809E,
    GL_SAMPLE_ALPHA_TO_ONE                                        = 0x809F,
    GL_SAMPLE_ALPHA_TO_ONE_SGIS                                   = 0x809F,
    GL_SAMPLE_COVERAGE                                            = 0x80A0,
    GL_SAMPLE_MASK_SGIS                                           = 0x80A0,
//  GL_TEXTURE_COLOR_TABLE_SGI                                    = 0x80BC, // reuse ColorTableTargetSGI
//  GL_COLOR_TABLE                                                = 0x80D0, // reuse ColorTableTarget
//  GL_COLOR_TABLE_SGI                                            = 0x80D0, // reuse ColorTableTargetSGI
//  GL_POST_CONVOLUTION_COLOR_TABLE                               = 0x80D1, // reuse ColorTableTarget
//  GL_POST_CONVOLUTION_COLOR_TABLE_SGI                           = 0x80D1, // reuse ColorTableTargetSGI
//  GL_POST_COLOR_MATRIX_COLOR_TABLE                              = 0x80D2, // reuse ColorTableTarget
//  GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI                          = 0x80D2, // reuse ColorTableTargetSGI
    GL_TEXTURE_4D_SGIS                                            = 0x8134,
    GL_PIXEL_TEX_GEN_SGIX                                         = 0x8139,
    GL_SPRITE_SGIX                                                = 0x8148,
    GL_REFERENCE_PLANE_SGIX                                       = 0x817D,
    GL_IR_INSTRUMENT1_SGIX                                        = 0x817F,
    GL_CALLIGRAPHIC_FRAGMENT_SGIX                                 = 0x8183,
    GL_FRAMEZOOM_SGIX                                             = 0x818B,
    GL_FOG_OFFSET_SGIX                                            = 0x8198,
    GL_SHARED_TEXTURE_PALETTE_EXT                                 = 0x81FB,
    GL_DEBUG_OUTPUT_SYNCHRONOUS                                   = 0x8242,
    GL_ASYNC_HISTOGRAM_SGIX                                       = 0x832C,
    GL_PIXEL_TEXTURE_SGIS                                         = 0x8353,
    GL_ASYNC_TEX_IMAGE_SGIX                                       = 0x835C,
    GL_ASYNC_DRAW_PIXELS_SGIX                                     = 0x835D,
    GL_ASYNC_READ_PIXELS_SGIX                                     = 0x835E,
    GL_FRAGMENT_LIGHTING_SGIX                                     = 0x8400,
    GL_FRAGMENT_COLOR_MATERIAL_SGIX                               = 0x8401,
    GL_FRAGMENT_LIGHT0_SGIX                                       = 0x840C,
    GL_FRAGMENT_LIGHT1_SGIX                                       = 0x840D,
    GL_FRAGMENT_LIGHT2_SGIX                                       = 0x840E,
    GL_FRAGMENT_LIGHT3_SGIX                                       = 0x840F,
    GL_FRAGMENT_LIGHT4_SGIX                                       = 0x8410,
    GL_FRAGMENT_LIGHT5_SGIX                                       = 0x8411,
    GL_FRAGMENT_LIGHT6_SGIX                                       = 0x8412,
    GL_FRAGMENT_LIGHT7_SGIX                                       = 0x8413,
//  GL_TEXTURE_RECTANGLE                                          = 0x84F5, // reuse CopyImageSubDataTarget
    GL_TEXTURE_RECTANGLE_ARB                                      = 0x84F5,
    GL_TEXTURE_RECTANGLE_NV                                       = 0x84F5,
//  GL_TEXTURE_CUBE_MAP                                           = 0x8513, // reuse CopyImageSubDataTarget
    GL_TEXTURE_CUBE_MAP_ARB                                       = 0x8513,
    GL_TEXTURE_CUBE_MAP_EXT                                       = 0x8513,
    GL_PROGRAM_POINT_SIZE                                         = 0x8642,
    GL_DEPTH_CLAMP                                                = 0x864F,
    GL_TEXTURE_CUBE_MAP_SEAMLESS                                  = 0x884F,
    GL_SAMPLE_SHADING                                             = 0x8C36,
    GL_RASTERIZER_DISCARD                                         = 0x8C89,
    GL_PRIMITIVE_RESTART_FIXED_INDEX                              = 0x8D69,
    GL_FRAMEBUFFER_SRGB                                           = 0x8DB9,
    GL_SAMPLE_MASK                                                = 0x8E51,
    GL_PRIMITIVE_RESTART                                          = 0x8F9D,
    GL_DEBUG_OUTPUT                                               = 0x92E0,
    GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV                        = 0x95B1,

    // ErrorCode

    GL_NO_ERROR                                                   = 0,
    GL_INVALID_ENUM                                               = 0x0500,
    GL_INVALID_VALUE                                              = 0x0501,
    GL_INVALID_OPERATION                                          = 0x0502,
    GL_STACK_OVERFLOW                                             = 0x0503,
    GL_STACK_UNDERFLOW                                            = 0x0504,
    GL_OUT_OF_MEMORY                                              = 0x0505,
    GL_INVALID_FRAMEBUFFER_OPERATION                              = 0x0506,
    GL_INVALID_FRAMEBUFFER_OPERATION_EXT                          = 0x0506,
    GL_TABLE_TOO_LARGE_EXT                                        = 0x8031,
    GL_TABLE_TOO_LARGE                                            = 0x8031,
    GL_TEXTURE_TOO_LARGE_EXT                                      = 0x8065,

    // EvalTargetNV

    GL_EVAL_2D_NV                                                 = 0x86C0,
    GL_EVAL_TRIANGULAR_2D_NV                                      = 0x86C1,

    // ExternalHandleType

    GL_HANDLE_TYPE_OPAQUE_FD_EXT                                  = 0x9586,
    GL_HANDLE_TYPE_OPAQUE_WIN32_EXT                               = 0x9587,
    GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT                           = 0x9588,
    GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT                             = 0x9589,
    GL_HANDLE_TYPE_D3D12_RESOURCE_EXT                             = 0x958A,
    GL_HANDLE_TYPE_D3D11_IMAGE_EXT                                = 0x958B,
    GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT                            = 0x958C,
    GL_HANDLE_TYPE_D3D12_FENCE_EXT                                = 0x9594,

    // FeedBackToken

    GL_PASS_THROUGH_TOKEN                                         = 0x0700,
    GL_POINT_TOKEN                                                = 0x0701,
    GL_LINE_TOKEN                                                 = 0x0702,
    GL_POLYGON_TOKEN                                              = 0x0703,
    GL_BITMAP_TOKEN                                               = 0x0704,
    GL_DRAW_PIXEL_TOKEN                                           = 0x0705,
    GL_COPY_PIXEL_TOKEN                                           = 0x0706,
    GL_LINE_RESET_TOKEN                                           = 0x0707,

    // FeedbackType

    GL_2D                                                         = 0x0600,
    GL_3D                                                         = 0x0601,
    GL_3D_COLOR                                                   = 0x0602,
    GL_3D_COLOR_TEXTURE                                           = 0x0603,
    GL_4D_COLOR_TEXTURE                                           = 0x0604,

    // FenceConditionNV

    GL_ALL_COMPLETED_NV                                           = 0x84F2,

    // FenceParameterNameNV

    GL_FENCE_STATUS_NV                                            = 0x84F3,
    GL_FENCE_CONDITION_NV                                         = 0x84F4,

    // FfdTargetSGIX

    GL_GEOMETRY_DEFORMATION_SGIX                                  = 0x8194,
    GL_TEXTURE_DEFORMATION_SGIX                                   = 0x8195,

    // FogCoordinatePointerType

//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // FogCoordSrc

    GL_FOG_COORDINATE                                             = 0x8451,
    GL_FOG_COORDINATE_EXT                                         = 0x8451,
    GL_FOG_COORD                                                  = 0x8451,
    GL_FRAGMENT_DEPTH                                             = 0x8452,
    GL_FRAGMENT_DEPTH_EXT                                         = 0x8452,

    // FogMode

    GL_EXP                                                        = 0x0800,
    GL_EXP2                                                       = 0x0801,
//  GL_LINEAR                                                     = 0x2601, // reuse BlitFramebufferFilter
    GL_FOG_FUNC_SGIS                                              = 0x812A,

    // FogParameter

    GL_FOG_INDEX                                                  = 0x0B61,
    GL_FOG_DENSITY                                                = 0x0B62,
    GL_FOG_START                                                  = 0x0B63,
    GL_FOG_END                                                    = 0x0B64,
    GL_FOG_MODE                                                   = 0x0B65,
    GL_FOG_COLOR                                                  = 0x0B66,
    GL_FOG_OFFSET_VALUE_SGIX                                      = 0x8199,

    // FogPName

//  GL_FOG_INDEX                                                  = 0x0B61, // reuse FogParameter
//  GL_FOG_DENSITY                                                = 0x0B62, // reuse FogParameter
//  GL_FOG_START                                                  = 0x0B63, // reuse FogParameter
//  GL_FOG_END                                                    = 0x0B64, // reuse FogParameter
//  GL_FOG_MODE                                                   = 0x0B65, // reuse FogParameter
    GL_FOG_COORD_SRC                                              = 0x8450,

    // FogPointerTypeEXT

//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // FogPointerTypeIBM

//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // FragmentLightModelParameterSGIX

    GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX                     = 0x8408,
    GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX                         = 0x8409,
    GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX                          = 0x840A,
    GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX             = 0x840B,

    // FragmentLightNameSGIX

//  GL_FRAGMENT_LIGHT0_SGIX                                       = 0x840C, // reuse EnableCap
//  GL_FRAGMENT_LIGHT1_SGIX                                       = 0x840D, // reuse EnableCap
//  GL_FRAGMENT_LIGHT2_SGIX                                       = 0x840E, // reuse EnableCap
//  GL_FRAGMENT_LIGHT3_SGIX                                       = 0x840F, // reuse EnableCap
//  GL_FRAGMENT_LIGHT4_SGIX                                       = 0x8410, // reuse EnableCap
//  GL_FRAGMENT_LIGHT5_SGIX                                       = 0x8411, // reuse EnableCap
//  GL_FRAGMENT_LIGHT6_SGIX                                       = 0x8412, // reuse EnableCap
//  GL_FRAGMENT_LIGHT7_SGIX                                       = 0x8413, // reuse EnableCap

    // FragmentLightParameterSGIX

//  GL_AMBIENT                                                    = 0x1200, // reuse ColorMaterialParameter
//  GL_DIFFUSE                                                    = 0x1201, // reuse ColorMaterialParameter
//  GL_SPECULAR                                                   = 0x1202, // reuse ColorMaterialParameter
    GL_POSITION                                                   = 0x1203,
    GL_SPOT_DIRECTION                                             = 0x1204,
    GL_SPOT_EXPONENT                                              = 0x1205,
    GL_SPOT_CUTOFF                                                = 0x1206,
    GL_CONSTANT_ATTENUATION                                       = 0x1207,
    GL_LINEAR_ATTENUATION                                         = 0x1208,
    GL_QUADRATIC_ATTENUATION                                      = 0x1209,

    // FragmentOp1ATI

    GL_MOV_ATI                                                    = 0x8961,

    // FragmentOp2ATI

    GL_ADD_ATI                                                    = 0x8963,
    GL_MUL_ATI                                                    = 0x8964,
    GL_SUB_ATI                                                    = 0x8965,
    GL_DOT3_ATI                                                   = 0x8966,
    GL_DOT4_ATI                                                   = 0x8967,

    // FragmentOp3ATI

    GL_MAD_ATI                                                    = 0x8968,
    GL_LERP_ATI                                                   = 0x8969,
    GL_CND_ATI                                                    = 0x896A,
    GL_CND0_ATI                                                   = 0x896B,
    GL_DOT2_ADD_ATI                                               = 0x896C,

    // FragmentShaderConATI

    GL_CON_0_ATI                                                  = 0x8941,
    GL_CON_1_ATI                                                  = 0x8942,
    GL_CON_2_ATI                                                  = 0x8943,
    GL_CON_3_ATI                                                  = 0x8944,
    GL_CON_4_ATI                                                  = 0x8945,
    GL_CON_5_ATI                                                  = 0x8946,
    GL_CON_6_ATI                                                  = 0x8947,
    GL_CON_7_ATI                                                  = 0x8948,
    GL_CON_8_ATI                                                  = 0x8949,
    GL_CON_9_ATI                                                  = 0x894A,
    GL_CON_10_ATI                                                 = 0x894B,
    GL_CON_11_ATI                                                 = 0x894C,
    GL_CON_12_ATI                                                 = 0x894D,
    GL_CON_13_ATI                                                 = 0x894E,
    GL_CON_14_ATI                                                 = 0x894F,
    GL_CON_15_ATI                                                 = 0x8950,
    GL_CON_16_ATI                                                 = 0x8951,
    GL_CON_17_ATI                                                 = 0x8952,
    GL_CON_18_ATI                                                 = 0x8953,
    GL_CON_19_ATI                                                 = 0x8954,
    GL_CON_20_ATI                                                 = 0x8955,
    GL_CON_21_ATI                                                 = 0x8956,
    GL_CON_22_ATI                                                 = 0x8957,
    GL_CON_23_ATI                                                 = 0x8958,
    GL_CON_24_ATI                                                 = 0x8959,
    GL_CON_25_ATI                                                 = 0x895A,
    GL_CON_26_ATI                                                 = 0x895B,
    GL_CON_27_ATI                                                 = 0x895C,
    GL_CON_28_ATI                                                 = 0x895D,
    GL_CON_29_ATI                                                 = 0x895E,
    GL_CON_30_ATI                                                 = 0x895F,
    GL_CON_31_ATI                                                 = 0x8960,

    // FragmentShaderGenericSourceATI

//  GL_ZERO                                                       = 0, // reuse BlendingFactor
    GL_PRIMARY_COLOR                                              = 0x8577,
    GL_PRIMARY_COLOR_ARB                                          = 0x8577,
    GL_PRIMARY_COLOR_EXT                                          = 0x8577,
    GL_REG_0_ATI                                                  = 0x8921,
    GL_REG_1_ATI                                                  = 0x8922,
    GL_REG_2_ATI                                                  = 0x8923,
    GL_REG_3_ATI                                                  = 0x8924,
    GL_REG_4_ATI                                                  = 0x8925,
    GL_REG_5_ATI                                                  = 0x8926,
    GL_REG_6_ATI                                                  = 0x8927,
    GL_REG_7_ATI                                                  = 0x8928,
    GL_REG_8_ATI                                                  = 0x8929,
    GL_REG_9_ATI                                                  = 0x892A,
    GL_REG_10_ATI                                                 = 0x892B,
    GL_REG_11_ATI                                                 = 0x892C,
    GL_REG_12_ATI                                                 = 0x892D,
    GL_REG_13_ATI                                                 = 0x892E,
    GL_REG_14_ATI                                                 = 0x892F,
    GL_REG_15_ATI                                                 = 0x8930,
    GL_REG_16_ATI                                                 = 0x8931,
    GL_REG_17_ATI                                                 = 0x8932,
    GL_REG_18_ATI                                                 = 0x8933,
    GL_REG_19_ATI                                                 = 0x8934,
    GL_REG_20_ATI                                                 = 0x8935,
    GL_REG_21_ATI                                                 = 0x8936,
    GL_REG_22_ATI                                                 = 0x8937,
    GL_REG_23_ATI                                                 = 0x8938,
    GL_REG_24_ATI                                                 = 0x8939,
    GL_REG_25_ATI                                                 = 0x893A,
    GL_REG_26_ATI                                                 = 0x893B,
    GL_REG_27_ATI                                                 = 0x893C,
    GL_REG_28_ATI                                                 = 0x893D,
    GL_REG_29_ATI                                                 = 0x893E,
    GL_REG_30_ATI                                                 = 0x893F,
    GL_REG_31_ATI                                                 = 0x8940,
//  GL_CON_0_ATI                                                  = 0x8941, // reuse FragmentShaderConATI
//  GL_CON_1_ATI                                                  = 0x8942, // reuse FragmentShaderConATI
//  GL_CON_2_ATI                                                  = 0x8943, // reuse FragmentShaderConATI
//  GL_CON_3_ATI                                                  = 0x8944, // reuse FragmentShaderConATI
//  GL_CON_4_ATI                                                  = 0x8945, // reuse FragmentShaderConATI
//  GL_CON_5_ATI                                                  = 0x8946, // reuse FragmentShaderConATI
//  GL_CON_6_ATI                                                  = 0x8947, // reuse FragmentShaderConATI
//  GL_CON_7_ATI                                                  = 0x8948, // reuse FragmentShaderConATI
//  GL_CON_8_ATI                                                  = 0x8949, // reuse FragmentShaderConATI
//  GL_CON_9_ATI                                                  = 0x894A, // reuse FragmentShaderConATI
//  GL_CON_10_ATI                                                 = 0x894B, // reuse FragmentShaderConATI
//  GL_CON_11_ATI                                                 = 0x894C, // reuse FragmentShaderConATI
//  GL_CON_12_ATI                                                 = 0x894D, // reuse FragmentShaderConATI
//  GL_CON_13_ATI                                                 = 0x894E, // reuse FragmentShaderConATI
//  GL_CON_14_ATI                                                 = 0x894F, // reuse FragmentShaderConATI
//  GL_CON_15_ATI                                                 = 0x8950, // reuse FragmentShaderConATI
//  GL_CON_16_ATI                                                 = 0x8951, // reuse FragmentShaderConATI
//  GL_CON_17_ATI                                                 = 0x8952, // reuse FragmentShaderConATI
//  GL_CON_18_ATI                                                 = 0x8953, // reuse FragmentShaderConATI
//  GL_CON_19_ATI                                                 = 0x8954, // reuse FragmentShaderConATI
//  GL_CON_20_ATI                                                 = 0x8955, // reuse FragmentShaderConATI
//  GL_CON_21_ATI                                                 = 0x8956, // reuse FragmentShaderConATI
//  GL_CON_22_ATI                                                 = 0x8957, // reuse FragmentShaderConATI
//  GL_CON_23_ATI                                                 = 0x8958, // reuse FragmentShaderConATI
//  GL_CON_24_ATI                                                 = 0x8959, // reuse FragmentShaderConATI
//  GL_CON_25_ATI                                                 = 0x895A, // reuse FragmentShaderConATI
//  GL_CON_26_ATI                                                 = 0x895B, // reuse FragmentShaderConATI
//  GL_CON_27_ATI                                                 = 0x895C, // reuse FragmentShaderConATI
//  GL_CON_28_ATI                                                 = 0x895D, // reuse FragmentShaderConATI
//  GL_CON_29_ATI                                                 = 0x895E, // reuse FragmentShaderConATI
//  GL_CON_30_ATI                                                 = 0x895F, // reuse FragmentShaderConATI
//  GL_CON_31_ATI                                                 = 0x8960, // reuse FragmentShaderConATI
    GL_SECONDARY_INTERPOLATOR_ATI                                 = 0x896D,
//  GL_ONE                                                        = 1, // reuse BlendingFactor

    // FragmentShaderRegATI

//  GL_REG_0_ATI                                                  = 0x8921, // reuse FragmentShaderGenericSourceATI
//  GL_REG_1_ATI                                                  = 0x8922, // reuse FragmentShaderGenericSourceATI
//  GL_REG_2_ATI                                                  = 0x8923, // reuse FragmentShaderGenericSourceATI
//  GL_REG_3_ATI                                                  = 0x8924, // reuse FragmentShaderGenericSourceATI
//  GL_REG_4_ATI                                                  = 0x8925, // reuse FragmentShaderGenericSourceATI
//  GL_REG_5_ATI                                                  = 0x8926, // reuse FragmentShaderGenericSourceATI
//  GL_REG_6_ATI                                                  = 0x8927, // reuse FragmentShaderGenericSourceATI
//  GL_REG_7_ATI                                                  = 0x8928, // reuse FragmentShaderGenericSourceATI
//  GL_REG_8_ATI                                                  = 0x8929, // reuse FragmentShaderGenericSourceATI
//  GL_REG_9_ATI                                                  = 0x892A, // reuse FragmentShaderGenericSourceATI
//  GL_REG_10_ATI                                                 = 0x892B, // reuse FragmentShaderGenericSourceATI
//  GL_REG_11_ATI                                                 = 0x892C, // reuse FragmentShaderGenericSourceATI
//  GL_REG_12_ATI                                                 = 0x892D, // reuse FragmentShaderGenericSourceATI
//  GL_REG_13_ATI                                                 = 0x892E, // reuse FragmentShaderGenericSourceATI
//  GL_REG_14_ATI                                                 = 0x892F, // reuse FragmentShaderGenericSourceATI
//  GL_REG_15_ATI                                                 = 0x8930, // reuse FragmentShaderGenericSourceATI
//  GL_REG_16_ATI                                                 = 0x8931, // reuse FragmentShaderGenericSourceATI
//  GL_REG_17_ATI                                                 = 0x8932, // reuse FragmentShaderGenericSourceATI
//  GL_REG_18_ATI                                                 = 0x8933, // reuse FragmentShaderGenericSourceATI
//  GL_REG_19_ATI                                                 = 0x8934, // reuse FragmentShaderGenericSourceATI
//  GL_REG_20_ATI                                                 = 0x8935, // reuse FragmentShaderGenericSourceATI
//  GL_REG_21_ATI                                                 = 0x8936, // reuse FragmentShaderGenericSourceATI
//  GL_REG_22_ATI                                                 = 0x8937, // reuse FragmentShaderGenericSourceATI
//  GL_REG_23_ATI                                                 = 0x8938, // reuse FragmentShaderGenericSourceATI
//  GL_REG_24_ATI                                                 = 0x8939, // reuse FragmentShaderGenericSourceATI
//  GL_REG_25_ATI                                                 = 0x893A, // reuse FragmentShaderGenericSourceATI
//  GL_REG_26_ATI                                                 = 0x893B, // reuse FragmentShaderGenericSourceATI
//  GL_REG_27_ATI                                                 = 0x893C, // reuse FragmentShaderGenericSourceATI
//  GL_REG_28_ATI                                                 = 0x893D, // reuse FragmentShaderGenericSourceATI
//  GL_REG_29_ATI                                                 = 0x893E, // reuse FragmentShaderGenericSourceATI
//  GL_REG_30_ATI                                                 = 0x893F, // reuse FragmentShaderGenericSourceATI
//  GL_REG_31_ATI                                                 = 0x8940, // reuse FragmentShaderGenericSourceATI

    // FragmentShaderTextureSourceATI

    GL_TEXTURE0                                                   = 0x84C0,
    GL_TEXTURE1                                                   = 0x84C1,
    GL_TEXTURE2                                                   = 0x84C2,
    GL_TEXTURE3                                                   = 0x84C3,
    GL_TEXTURE4                                                   = 0x84C4,
    GL_TEXTURE5                                                   = 0x84C5,
    GL_TEXTURE6                                                   = 0x84C6,
    GL_TEXTURE7                                                   = 0x84C7,
    GL_TEXTURE8                                                   = 0x84C8,
    GL_TEXTURE9                                                   = 0x84C9,
    GL_TEXTURE10                                                  = 0x84CA,
    GL_TEXTURE11                                                  = 0x84CB,
    GL_TEXTURE12                                                  = 0x84CC,
    GL_TEXTURE13                                                  = 0x84CD,
    GL_TEXTURE14                                                  = 0x84CE,
    GL_TEXTURE15                                                  = 0x84CF,
    GL_TEXTURE16                                                  = 0x84D0,
    GL_TEXTURE17                                                  = 0x84D1,
    GL_TEXTURE18                                                  = 0x84D2,
    GL_TEXTURE19                                                  = 0x84D3,
    GL_TEXTURE20                                                  = 0x84D4,
    GL_TEXTURE21                                                  = 0x84D5,
    GL_TEXTURE22                                                  = 0x84D6,
    GL_TEXTURE23                                                  = 0x84D7,
    GL_TEXTURE24                                                  = 0x84D8,
    GL_TEXTURE25                                                  = 0x84D9,
    GL_TEXTURE26                                                  = 0x84DA,
    GL_TEXTURE27                                                  = 0x84DB,
    GL_TEXTURE28                                                  = 0x84DC,
    GL_TEXTURE29                                                  = 0x84DD,
    GL_TEXTURE30                                                  = 0x84DE,
    GL_TEXTURE31                                                  = 0x84DF,
//  GL_REG_0_ATI                                                  = 0x8921, // reuse FragmentShaderGenericSourceATI
//  GL_REG_1_ATI                                                  = 0x8922, // reuse FragmentShaderGenericSourceATI
//  GL_REG_2_ATI                                                  = 0x8923, // reuse FragmentShaderGenericSourceATI
//  GL_REG_3_ATI                                                  = 0x8924, // reuse FragmentShaderGenericSourceATI
//  GL_REG_4_ATI                                                  = 0x8925, // reuse FragmentShaderGenericSourceATI
//  GL_REG_5_ATI                                                  = 0x8926, // reuse FragmentShaderGenericSourceATI
//  GL_REG_6_ATI                                                  = 0x8927, // reuse FragmentShaderGenericSourceATI
//  GL_REG_7_ATI                                                  = 0x8928, // reuse FragmentShaderGenericSourceATI
//  GL_REG_8_ATI                                                  = 0x8929, // reuse FragmentShaderGenericSourceATI
//  GL_REG_9_ATI                                                  = 0x892A, // reuse FragmentShaderGenericSourceATI
//  GL_REG_10_ATI                                                 = 0x892B, // reuse FragmentShaderGenericSourceATI
//  GL_REG_11_ATI                                                 = 0x892C, // reuse FragmentShaderGenericSourceATI
//  GL_REG_12_ATI                                                 = 0x892D, // reuse FragmentShaderGenericSourceATI
//  GL_REG_13_ATI                                                 = 0x892E, // reuse FragmentShaderGenericSourceATI
//  GL_REG_14_ATI                                                 = 0x892F, // reuse FragmentShaderGenericSourceATI
//  GL_REG_15_ATI                                                 = 0x8930, // reuse FragmentShaderGenericSourceATI
//  GL_REG_16_ATI                                                 = 0x8931, // reuse FragmentShaderGenericSourceATI
//  GL_REG_17_ATI                                                 = 0x8932, // reuse FragmentShaderGenericSourceATI
//  GL_REG_18_ATI                                                 = 0x8933, // reuse FragmentShaderGenericSourceATI
//  GL_REG_19_ATI                                                 = 0x8934, // reuse FragmentShaderGenericSourceATI
//  GL_REG_20_ATI                                                 = 0x8935, // reuse FragmentShaderGenericSourceATI
//  GL_REG_21_ATI                                                 = 0x8936, // reuse FragmentShaderGenericSourceATI
//  GL_REG_22_ATI                                                 = 0x8937, // reuse FragmentShaderGenericSourceATI
//  GL_REG_23_ATI                                                 = 0x8938, // reuse FragmentShaderGenericSourceATI
//  GL_REG_24_ATI                                                 = 0x8939, // reuse FragmentShaderGenericSourceATI
//  GL_REG_25_ATI                                                 = 0x893A, // reuse FragmentShaderGenericSourceATI
//  GL_REG_26_ATI                                                 = 0x893B, // reuse FragmentShaderGenericSourceATI
//  GL_REG_27_ATI                                                 = 0x893C, // reuse FragmentShaderGenericSourceATI
//  GL_REG_28_ATI                                                 = 0x893D, // reuse FragmentShaderGenericSourceATI
//  GL_REG_29_ATI                                                 = 0x893E, // reuse FragmentShaderGenericSourceATI
//  GL_REG_30_ATI                                                 = 0x893F, // reuse FragmentShaderGenericSourceATI
//  GL_REG_31_ATI                                                 = 0x8940, // reuse FragmentShaderGenericSourceATI

    // FragmentShaderValueRepATI

//  GL_NONE                                                       = 0, // reuse ColorBuffer
    GL_RED                                                        = 0x1903,
    GL_GREEN                                                      = 0x1904,
//  GL_BLUE                                                       = 0x1905, // reuse CombinerComponentUsageNV
//  GL_ALPHA                                                      = 0x1906, // reuse CombinerComponentUsageNV

    // FramebufferAttachment

    GL_DEPTH_STENCIL_ATTACHMENT                                   = 0x821A,
//  GL_COLOR_ATTACHMENT0                                          = 0x8CE0, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT1                                          = 0x8CE1, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT2                                          = 0x8CE2, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT3                                          = 0x8CE3, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT4                                          = 0x8CE4, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT5                                          = 0x8CE5, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT6                                          = 0x8CE6, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT7                                          = 0x8CE7, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT8                                          = 0x8CE8, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT9                                          = 0x8CE9, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT10                                         = 0x8CEA, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT11                                         = 0x8CEB, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT12                                         = 0x8CEC, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT13                                         = 0x8CED, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT14                                         = 0x8CEE, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT15                                         = 0x8CEF, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT16                                         = 0x8CF0, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT17                                         = 0x8CF1, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT18                                         = 0x8CF2, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT19                                         = 0x8CF3, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT20                                         = 0x8CF4, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT21                                         = 0x8CF5, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT22                                         = 0x8CF6, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT23                                         = 0x8CF7, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT24                                         = 0x8CF8, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT25                                         = 0x8CF9, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT26                                         = 0x8CFA, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT27                                         = 0x8CFB, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT28                                         = 0x8CFC, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT29                                         = 0x8CFD, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT30                                         = 0x8CFE, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT31                                         = 0x8CFF, // reuse ColorBuffer
    GL_DEPTH_ATTACHMENT                                           = 0x8D00,
    GL_STENCIL_ATTACHMENT                                         = 0x8D20,

    // FramebufferAttachmentParameterName

    GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING                      = 0x8210,
    GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE                      = 0x8211,
    GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE                            = 0x8212,
    GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE                          = 0x8213,
    GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE                           = 0x8214,
    GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE                          = 0x8215,
    GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE                          = 0x8216,
    GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE                        = 0x8217,
    GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE                         = 0x8CD0,
    GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT                     = 0x8CD0,
    GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME                         = 0x8CD1,
    GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT                     = 0x8CD1,
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL                       = 0x8CD2,
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT                   = 0x8CD2,
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE               = 0x8CD3,
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT           = 0x8CD3,
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT              = 0x8CD4,
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER                       = 0x8CD4,
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT                   = 0x8CD4,
    GL_FRAMEBUFFER_ATTACHMENT_LAYERED                             = 0x8DA7,
    GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB                         = 0x8DA7,
    GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT                         = 0x8DA7,
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR               = 0x9630,
    GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR         = 0x9632,

    // FramebufferParameterName

    GL_FRAMEBUFFER_DEFAULT_WIDTH                                  = 0x9310,
    GL_FRAMEBUFFER_DEFAULT_HEIGHT                                 = 0x9311,
    GL_FRAMEBUFFER_DEFAULT_LAYERS                                 = 0x9312,
    GL_FRAMEBUFFER_DEFAULT_SAMPLES                                = 0x9313,
    GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS                 = 0x9314,

    // FramebufferStatus

    GL_FRAMEBUFFER_UNDEFINED                                      = 0x8219,
    GL_FRAMEBUFFER_COMPLETE                                       = 0x8CD5,
    GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT                          = 0x8CD6,
    GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT                  = 0x8CD7,
    GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER                         = 0x8CDB,
    GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER                         = 0x8CDC,
    GL_FRAMEBUFFER_UNSUPPORTED                                    = 0x8CDD,
    GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE                         = 0x8D56,
    GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS                       = 0x8DA8,

    // FramebufferTarget

    GL_READ_FRAMEBUFFER                                           = 0x8CA8,
    GL_DRAW_FRAMEBUFFER                                           = 0x8CA9,
    GL_FRAMEBUFFER                                                = 0x8D40,

    // FrontFaceDirection

    GL_CW                                                         = 0x0900,
    GL_CCW                                                        = 0x0901,

    // GetFramebufferParameter

    GL_DOUBLEBUFFER                                               = 0x0C32,
    GL_STEREO                                                     = 0x0C33,
    GL_SAMPLE_BUFFERS                                             = 0x80A8,
    GL_SAMPLES                                                    = 0x80A9,
    GL_IMPLEMENTATION_COLOR_READ_TYPE                             = 0x8B9A,
    GL_IMPLEMENTATION_COLOR_READ_FORMAT                           = 0x8B9B,
//  GL_FRAMEBUFFER_DEFAULT_WIDTH                                  = 0x9310, // reuse FramebufferParameterName
//  GL_FRAMEBUFFER_DEFAULT_HEIGHT                                 = 0x9311, // reuse FramebufferParameterName
//  GL_FRAMEBUFFER_DEFAULT_LAYERS                                 = 0x9312, // reuse FramebufferParameterName
//  GL_FRAMEBUFFER_DEFAULT_SAMPLES                                = 0x9313, // reuse FramebufferParameterName
//  GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS                 = 0x9314, // reuse FramebufferParameterName

    // GetHistogramParameterPNameEXT

    GL_HISTOGRAM_WIDTH                                            = 0x8026,
    GL_HISTOGRAM_WIDTH_EXT                                        = 0x8026,
    GL_HISTOGRAM_FORMAT                                           = 0x8027,
    GL_HISTOGRAM_FORMAT_EXT                                       = 0x8027,
    GL_HISTOGRAM_RED_SIZE                                         = 0x8028,
    GL_HISTOGRAM_RED_SIZE_EXT                                     = 0x8028,
    GL_HISTOGRAM_GREEN_SIZE                                       = 0x8029,
    GL_HISTOGRAM_GREEN_SIZE_EXT                                   = 0x8029,
    GL_HISTOGRAM_BLUE_SIZE                                        = 0x802A,
    GL_HISTOGRAM_BLUE_SIZE_EXT                                    = 0x802A,
    GL_HISTOGRAM_ALPHA_SIZE                                       = 0x802B,
    GL_HISTOGRAM_ALPHA_SIZE_EXT                                   = 0x802B,
    GL_HISTOGRAM_LUMINANCE_SIZE                                   = 0x802C,
    GL_HISTOGRAM_LUMINANCE_SIZE_EXT                               = 0x802C,
    GL_HISTOGRAM_SINK                                             = 0x802D,
    GL_HISTOGRAM_SINK_EXT                                         = 0x802D,

    // GetMapQuery

    GL_COEFF                                                      = 0x0A00,
    GL_ORDER                                                      = 0x0A01,
    GL_DOMAIN                                                     = 0x0A02,

    // GetMinmaxParameterPNameEXT

    GL_MINMAX_FORMAT                                              = 0x802F,
    GL_MINMAX_FORMAT_EXT                                          = 0x802F,
    GL_MINMAX_SINK                                                = 0x8030,
    GL_MINMAX_SINK_EXT                                            = 0x8030,

    // GetMultisamplePNameNV

    GL_SAMPLE_POSITION                                            = 0x8E50,
    GL_SAMPLE_LOCATION_ARB                                        = 0x8E50,
    GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB                           = 0x9341,

    // GetPName

    GL_CURRENT_COLOR                                              = 0x0B00,
    GL_CURRENT_INDEX                                              = 0x0B01,
    GL_CURRENT_NORMAL                                             = 0x0B02,
    GL_CURRENT_TEXTURE_COORDS                                     = 0x0B03,
    GL_CURRENT_RASTER_COLOR                                       = 0x0B04,
    GL_CURRENT_RASTER_INDEX                                       = 0x0B05,
    GL_CURRENT_RASTER_TEXTURE_COORDS                              = 0x0B06,
    GL_CURRENT_RASTER_POSITION                                    = 0x0B07,
    GL_CURRENT_RASTER_POSITION_VALID                              = 0x0B08,
    GL_CURRENT_RASTER_DISTANCE                                    = 0x0B09,
//  GL_POINT_SMOOTH                                               = 0x0B10, // reuse EnableCap
    GL_POINT_SIZE                                                 = 0x0B11,
    GL_POINT_SIZE_RANGE                                           = 0x0B12,
    GL_SMOOTH_POINT_SIZE_RANGE                                    = 0x0B12,
    GL_POINT_SIZE_GRANULARITY                                     = 0x0B13,
    GL_SMOOTH_POINT_SIZE_GRANULARITY                              = 0x0B13,
//  GL_LINE_SMOOTH                                                = 0x0B20, // reuse EnableCap
    GL_LINE_WIDTH                                                 = 0x0B21,
    GL_LINE_WIDTH_RANGE                                           = 0x0B22,
    GL_SMOOTH_LINE_WIDTH_RANGE                                    = 0x0B22,
    GL_LINE_WIDTH_GRANULARITY                                     = 0x0B23,
    GL_SMOOTH_LINE_WIDTH_GRANULARITY                              = 0x0B23,
//  GL_LINE_STIPPLE                                               = 0x0B24, // reuse EnableCap
    GL_LINE_STIPPLE_PATTERN                                       = 0x0B25,
    GL_LINE_STIPPLE_REPEAT                                        = 0x0B26,
    GL_LIST_MODE                                                  = 0x0B30,
    GL_MAX_LIST_NESTING                                           = 0x0B31,
    GL_LIST_BASE                                                  = 0x0B32,
    GL_LIST_INDEX                                                 = 0x0B33,
    GL_POLYGON_MODE                                               = 0x0B40,
//  GL_POLYGON_SMOOTH                                             = 0x0B41, // reuse EnableCap
//  GL_POLYGON_STIPPLE                                            = 0x0B42, // reuse EnableCap
    GL_EDGE_FLAG                                                  = 0x0B43,
//  GL_CULL_FACE                                                  = 0x0B44, // reuse EnableCap
    GL_CULL_FACE_MODE                                             = 0x0B45,
    GL_FRONT_FACE                                                 = 0x0B46,
//  GL_LIGHTING                                                   = 0x0B50, // reuse EnableCap
    GL_LIGHT_MODEL_LOCAL_VIEWER                                   = 0x0B51,
    GL_LIGHT_MODEL_TWO_SIDE                                       = 0x0B52,
    GL_LIGHT_MODEL_AMBIENT                                        = 0x0B53,
    GL_SHADE_MODEL                                                = 0x0B54,
    GL_COLOR_MATERIAL_FACE                                        = 0x0B55,
    GL_COLOR_MATERIAL_PARAMETER                                   = 0x0B56,
//  GL_COLOR_MATERIAL                                             = 0x0B57, // reuse EnableCap
//  GL_FOG                                                        = 0x0B60, // reuse EnableCap
//  GL_FOG_INDEX                                                  = 0x0B61, // reuse FogParameter
//  GL_FOG_DENSITY                                                = 0x0B62, // reuse FogParameter
//  GL_FOG_START                                                  = 0x0B63, // reuse FogParameter
//  GL_FOG_END                                                    = 0x0B64, // reuse FogParameter
//  GL_FOG_MODE                                                   = 0x0B65, // reuse FogParameter
//  GL_FOG_COLOR                                                  = 0x0B66, // reuse FogParameter
    GL_DEPTH_RANGE                                                = 0x0B70,
//  GL_DEPTH_TEST                                                 = 0x0B71, // reuse EnableCap
    GL_DEPTH_WRITEMASK                                            = 0x0B72,
    GL_DEPTH_CLEAR_VALUE                                          = 0x0B73,
    GL_DEPTH_FUNC                                                 = 0x0B74,
    GL_ACCUM_CLEAR_VALUE                                          = 0x0B80,
//  GL_STENCIL_TEST                                               = 0x0B90, // reuse EnableCap
    GL_STENCIL_CLEAR_VALUE                                        = 0x0B91,
    GL_STENCIL_FUNC                                               = 0x0B92,
    GL_STENCIL_VALUE_MASK                                         = 0x0B93,
    GL_STENCIL_FAIL                                               = 0x0B94,
    GL_STENCIL_PASS_DEPTH_FAIL                                    = 0x0B95,
    GL_STENCIL_PASS_DEPTH_PASS                                    = 0x0B96,
    GL_STENCIL_REF                                                = 0x0B97,
    GL_STENCIL_WRITEMASK                                          = 0x0B98,
    GL_MATRIX_MODE                                                = 0x0BA0,
//  GL_NORMALIZE                                                  = 0x0BA1, // reuse EnableCap
    GL_VIEWPORT                                                   = 0x0BA2,
    GL_MODELVIEW_STACK_DEPTH                                      = 0x0BA3,
    GL_MODELVIEW0_STACK_DEPTH_EXT                                 = 0x0BA3,
    GL_PROJECTION_STACK_DEPTH                                     = 0x0BA4,
    GL_TEXTURE_STACK_DEPTH                                        = 0x0BA5,
    GL_MODELVIEW_MATRIX                                           = 0x0BA6,
    GL_MODELVIEW0_MATRIX_EXT                                      = 0x0BA6,
    GL_PROJECTION_MATRIX                                          = 0x0BA7,
    GL_TEXTURE_MATRIX                                             = 0x0BA8,
    GL_ATTRIB_STACK_DEPTH                                         = 0x0BB0,
    GL_CLIENT_ATTRIB_STACK_DEPTH                                  = 0x0BB1,
//  GL_ALPHA_TEST                                                 = 0x0BC0, // reuse EnableCap
    GL_ALPHA_TEST_FUNC                                            = 0x0BC1,
    GL_ALPHA_TEST_REF                                             = 0x0BC2,
//  GL_DITHER                                                     = 0x0BD0, // reuse EnableCap
    GL_BLEND_DST                                                  = 0x0BE0,
    GL_BLEND_SRC                                                  = 0x0BE1,
//  GL_BLEND                                                      = 0x0BE2, // reuse EnableCap
    GL_LOGIC_OP_MODE                                              = 0x0BF0,
//  GL_INDEX_LOGIC_OP                                             = 0x0BF1, // reuse EnableCap
    GL_LOGIC_OP                                                   = 0x0BF1,
//  GL_COLOR_LOGIC_OP                                             = 0x0BF2, // reuse EnableCap
    GL_AUX_BUFFERS                                                = 0x0C00,
    GL_DRAW_BUFFER                                                = 0x0C01,
    GL_READ_BUFFER                                                = 0x0C02,
    GL_SCISSOR_BOX                                                = 0x0C10,
//  GL_SCISSOR_TEST                                               = 0x0C11, // reuse EnableCap
    GL_INDEX_CLEAR_VALUE                                          = 0x0C20,
    GL_INDEX_WRITEMASK                                            = 0x0C21,
    GL_COLOR_CLEAR_VALUE                                          = 0x0C22,
    GL_COLOR_WRITEMASK                                            = 0x0C23,
    GL_INDEX_MODE                                                 = 0x0C30,
    GL_RGBA_MODE                                                  = 0x0C31,
//  GL_DOUBLEBUFFER                                               = 0x0C32, // reuse GetFramebufferParameter
//  GL_STEREO                                                     = 0x0C33, // reuse GetFramebufferParameter
    GL_RENDER_MODE                                                = 0x0C40,
    GL_PERSPECTIVE_CORRECTION_HINT                                = 0x0C50,
    GL_POINT_SMOOTH_HINT                                          = 0x0C51,
    GL_LINE_SMOOTH_HINT                                           = 0x0C52,
    GL_POLYGON_SMOOTH_HINT                                        = 0x0C53,
    GL_FOG_HINT                                                   = 0x0C54,
//  GL_TEXTURE_GEN_S                                              = 0x0C60, // reuse EnableCap
//  GL_TEXTURE_GEN_T                                              = 0x0C61, // reuse EnableCap
//  GL_TEXTURE_GEN_R                                              = 0x0C62, // reuse EnableCap
//  GL_TEXTURE_GEN_Q                                              = 0x0C63, // reuse EnableCap
    GL_PIXEL_MAP_I_TO_I_SIZE                                      = 0x0CB0,
    GL_PIXEL_MAP_S_TO_S_SIZE                                      = 0x0CB1,
    GL_PIXEL_MAP_I_TO_R_SIZE                                      = 0x0CB2,
    GL_PIXEL_MAP_I_TO_G_SIZE                                      = 0x0CB3,
    GL_PIXEL_MAP_I_TO_B_SIZE                                      = 0x0CB4,
    GL_PIXEL_MAP_I_TO_A_SIZE                                      = 0x0CB5,
    GL_PIXEL_MAP_R_TO_R_SIZE                                      = 0x0CB6,
    GL_PIXEL_MAP_G_TO_G_SIZE                                      = 0x0CB7,
    GL_PIXEL_MAP_B_TO_B_SIZE                                      = 0x0CB8,
    GL_PIXEL_MAP_A_TO_A_SIZE                                      = 0x0CB9,
    GL_UNPACK_SWAP_BYTES                                          = 0x0CF0,
    GL_UNPACK_LSB_FIRST                                           = 0x0CF1,
    GL_UNPACK_ROW_LENGTH                                          = 0x0CF2,
    GL_UNPACK_SKIP_ROWS                                           = 0x0CF3,
    GL_UNPACK_SKIP_PIXELS                                         = 0x0CF4,
    GL_UNPACK_ALIGNMENT                                           = 0x0CF5,
    GL_PACK_SWAP_BYTES                                            = 0x0D00,
    GL_PACK_LSB_FIRST                                             = 0x0D01,
    GL_PACK_ROW_LENGTH                                            = 0x0D02,
    GL_PACK_SKIP_ROWS                                             = 0x0D03,
    GL_PACK_SKIP_PIXELS                                           = 0x0D04,
    GL_PACK_ALIGNMENT                                             = 0x0D05,
    GL_MAP_COLOR                                                  = 0x0D10,
    GL_MAP_STENCIL                                                = 0x0D11,
    GL_INDEX_SHIFT                                                = 0x0D12,
    GL_INDEX_OFFSET                                               = 0x0D13,
    GL_RED_SCALE                                                  = 0x0D14,
    GL_RED_BIAS                                                   = 0x0D15,
    GL_ZOOM_X                                                     = 0x0D16,
    GL_ZOOM_Y                                                     = 0x0D17,
    GL_GREEN_SCALE                                                = 0x0D18,
    GL_GREEN_BIAS                                                 = 0x0D19,
    GL_BLUE_SCALE                                                 = 0x0D1A,
    GL_BLUE_BIAS                                                  = 0x0D1B,
    GL_ALPHA_SCALE                                                = 0x0D1C,
    GL_ALPHA_BIAS                                                 = 0x0D1D,
    GL_DEPTH_SCALE                                                = 0x0D1E,
    GL_DEPTH_BIAS                                                 = 0x0D1F,
    GL_MAX_EVAL_ORDER                                             = 0x0D30,
    GL_MAX_LIGHTS                                                 = 0x0D31,
    GL_MAX_CLIP_PLANES                                            = 0x0D32,
    GL_MAX_CLIP_DISTANCES                                         = 0x0D32,
    GL_MAX_TEXTURE_SIZE                                           = 0x0D33,
    GL_MAX_PIXEL_MAP_TABLE                                        = 0x0D34,
    GL_MAX_ATTRIB_STACK_DEPTH                                     = 0x0D35,
    GL_MAX_MODELVIEW_STACK_DEPTH                                  = 0x0D36,
    GL_MAX_NAME_STACK_DEPTH                                       = 0x0D37,
    GL_MAX_PROJECTION_STACK_DEPTH                                 = 0x0D38,
    GL_MAX_TEXTURE_STACK_DEPTH                                    = 0x0D39,
    GL_MAX_VIEWPORT_DIMS                                          = 0x0D3A,
    GL_MAX_CLIENT_ATTRIB_STACK_DEPTH                              = 0x0D3B,
    GL_SUBPIXEL_BITS                                              = 0x0D50,
    GL_INDEX_BITS                                                 = 0x0D51,
    GL_RED_BITS                                                   = 0x0D52,
    GL_GREEN_BITS                                                 = 0x0D53,
    GL_BLUE_BITS                                                  = 0x0D54,
    GL_ALPHA_BITS                                                 = 0x0D55,
    GL_DEPTH_BITS                                                 = 0x0D56,
    GL_STENCIL_BITS                                               = 0x0D57,
    GL_ACCUM_RED_BITS                                             = 0x0D58,
    GL_ACCUM_GREEN_BITS                                           = 0x0D59,
    GL_ACCUM_BLUE_BITS                                            = 0x0D5A,
    GL_ACCUM_ALPHA_BITS                                           = 0x0D5B,
    GL_NAME_STACK_DEPTH                                           = 0x0D70,
//  GL_AUTO_NORMAL                                                = 0x0D80, // reuse EnableCap
//  GL_MAP1_COLOR_4                                               = 0x0D90, // reuse EnableCap
//  GL_MAP1_INDEX                                                 = 0x0D91, // reuse EnableCap
//  GL_MAP1_NORMAL                                                = 0x0D92, // reuse EnableCap
//  GL_MAP1_TEXTURE_COORD_1                                       = 0x0D93, // reuse EnableCap
//  GL_MAP1_TEXTURE_COORD_2                                       = 0x0D94, // reuse EnableCap
//  GL_MAP1_TEXTURE_COORD_3                                       = 0x0D95, // reuse EnableCap
//  GL_MAP1_TEXTURE_COORD_4                                       = 0x0D96, // reuse EnableCap
//  GL_MAP1_VERTEX_3                                              = 0x0D97, // reuse EnableCap
//  GL_MAP1_VERTEX_4                                              = 0x0D98, // reuse EnableCap
//  GL_MAP2_COLOR_4                                               = 0x0DB0, // reuse EnableCap
//  GL_MAP2_INDEX                                                 = 0x0DB1, // reuse EnableCap
//  GL_MAP2_NORMAL                                                = 0x0DB2, // reuse EnableCap
//  GL_MAP2_TEXTURE_COORD_1                                       = 0x0DB3, // reuse EnableCap
//  GL_MAP2_TEXTURE_COORD_2                                       = 0x0DB4, // reuse EnableCap
//  GL_MAP2_TEXTURE_COORD_3                                       = 0x0DB5, // reuse EnableCap
//  GL_MAP2_TEXTURE_COORD_4                                       = 0x0DB6, // reuse EnableCap
//  GL_MAP2_VERTEX_3                                              = 0x0DB7, // reuse EnableCap
//  GL_MAP2_VERTEX_4                                              = 0x0DB8, // reuse EnableCap
    GL_MAP1_GRID_DOMAIN                                           = 0x0DD0,
    GL_MAP1_GRID_SEGMENTS                                         = 0x0DD1,
    GL_MAP2_GRID_DOMAIN                                           = 0x0DD2,
    GL_MAP2_GRID_SEGMENTS                                         = 0x0DD3,
//  GL_TEXTURE_1D                                                 = 0x0DE0, // reuse CopyImageSubDataTarget
//  GL_TEXTURE_2D                                                 = 0x0DE1, // reuse CopyImageSubDataTarget
    GL_FEEDBACK_BUFFER_SIZE                                       = 0x0DF1,
    GL_FEEDBACK_BUFFER_TYPE                                       = 0x0DF2,
    GL_SELECTION_BUFFER_SIZE                                      = 0x0DF4,
    GL_POLYGON_OFFSET_UNITS                                       = 0x2A00,
//  GL_POLYGON_OFFSET_POINT                                       = 0x2A01, // reuse EnableCap
//  GL_POLYGON_OFFSET_LINE                                        = 0x2A02, // reuse EnableCap
//  GL_CLIP_PLANE0                                                = 0x3000, // reuse ClipPlaneName
//  GL_CLIP_PLANE1                                                = 0x3001, // reuse ClipPlaneName
//  GL_CLIP_PLANE2                                                = 0x3002, // reuse ClipPlaneName
//  GL_CLIP_PLANE3                                                = 0x3003, // reuse ClipPlaneName
//  GL_CLIP_PLANE4                                                = 0x3004, // reuse ClipPlaneName
//  GL_CLIP_PLANE5                                                = 0x3005, // reuse ClipPlaneName
//  GL_LIGHT0                                                     = 0x4000, // reuse EnableCap
//  GL_LIGHT1                                                     = 0x4001, // reuse EnableCap
//  GL_LIGHT2                                                     = 0x4002, // reuse EnableCap
//  GL_LIGHT3                                                     = 0x4003, // reuse EnableCap
//  GL_LIGHT4                                                     = 0x4004, // reuse EnableCap
//  GL_LIGHT5                                                     = 0x4005, // reuse EnableCap
//  GL_LIGHT6                                                     = 0x4006, // reuse EnableCap
//  GL_LIGHT7                                                     = 0x4007, // reuse EnableCap
    GL_BLEND_COLOR                                                = 0x8005,
    GL_BLEND_COLOR_EXT                                            = 0x8005,
    GL_BLEND_EQUATION                                             = 0x8009,
    GL_BLEND_EQUATION_EXT                                         = 0x8009,
    GL_BLEND_EQUATION_RGB                                         = 0x8009,
    GL_PACK_CMYK_HINT_EXT                                         = 0x800E,
    GL_UNPACK_CMYK_HINT_EXT                                       = 0x800F,
//  GL_CONVOLUTION_1D_EXT                                         = 0x8010, // reuse ConvolutionTargetEXT
//  GL_CONVOLUTION_2D_EXT                                         = 0x8011, // reuse ConvolutionTargetEXT
//  GL_SEPARABLE_2D_EXT                                           = 0x8012, // reuse EnableCap
    GL_POST_CONVOLUTION_RED_SCALE_EXT                             = 0x801C,
    GL_POST_CONVOLUTION_GREEN_SCALE_EXT                           = 0x801D,
    GL_POST_CONVOLUTION_BLUE_SCALE_EXT                            = 0x801E,
    GL_POST_CONVOLUTION_ALPHA_SCALE_EXT                           = 0x801F,
    GL_POST_CONVOLUTION_RED_BIAS_EXT                              = 0x8020,
    GL_POST_CONVOLUTION_GREEN_BIAS_EXT                            = 0x8021,
    GL_POST_CONVOLUTION_BLUE_BIAS_EXT                             = 0x8022,
    GL_POST_CONVOLUTION_ALPHA_BIAS_EXT                            = 0x8023,
//  GL_HISTOGRAM_EXT                                              = 0x8024, // reuse EnableCap
//  GL_MINMAX_EXT                                                 = 0x802E, // reuse EnableCap
//  GL_POLYGON_OFFSET_FILL                                        = 0x8037, // reuse EnableCap
    GL_POLYGON_OFFSET_FACTOR                                      = 0x8038,
    GL_POLYGON_OFFSET_BIAS_EXT                                    = 0x8039,
//  GL_RESCALE_NORMAL_EXT                                         = 0x803A, // reuse EnableCap
    GL_TEXTURE_BINDING_1D                                         = 0x8068,
    GL_TEXTURE_BINDING_2D                                         = 0x8069,
    GL_TEXTURE_3D_BINDING_EXT                                     = 0x806A,
    GL_TEXTURE_BINDING_3D                                         = 0x806A,
    GL_PACK_SKIP_IMAGES                                           = 0x806B,
    GL_PACK_SKIP_IMAGES_EXT                                       = 0x806B,
    GL_PACK_IMAGE_HEIGHT                                          = 0x806C,
    GL_PACK_IMAGE_HEIGHT_EXT                                      = 0x806C,
    GL_UNPACK_SKIP_IMAGES                                         = 0x806D,
    GL_UNPACK_SKIP_IMAGES_EXT                                     = 0x806D,
    GL_UNPACK_IMAGE_HEIGHT                                        = 0x806E,
    GL_UNPACK_IMAGE_HEIGHT_EXT                                    = 0x806E,
//  GL_TEXTURE_3D_EXT                                             = 0x806F, // reuse EnableCap
    GL_MAX_3D_TEXTURE_SIZE                                        = 0x8073,
    GL_MAX_3D_TEXTURE_SIZE_EXT                                    = 0x8073,
//  GL_VERTEX_ARRAY                                               = 0x8074, // reuse EnableCap
//  GL_NORMAL_ARRAY                                               = 0x8075, // reuse EnableCap
//  GL_COLOR_ARRAY                                                = 0x8076, // reuse EnableCap
//  GL_INDEX_ARRAY                                                = 0x8077, // reuse EnableCap
//  GL_TEXTURE_COORD_ARRAY                                        = 0x8078, // reuse EnableCap
//  GL_EDGE_FLAG_ARRAY                                            = 0x8079, // reuse EnableCap
    GL_VERTEX_ARRAY_SIZE                                          = 0x807A,
    GL_VERTEX_ARRAY_TYPE                                          = 0x807B,
    GL_VERTEX_ARRAY_STRIDE                                        = 0x807C,
    GL_VERTEX_ARRAY_COUNT_EXT                                     = 0x807D,
    GL_NORMAL_ARRAY_TYPE                                          = 0x807E,
    GL_NORMAL_ARRAY_STRIDE                                        = 0x807F,
    GL_NORMAL_ARRAY_COUNT_EXT                                     = 0x8080,
    GL_COLOR_ARRAY_SIZE                                           = 0x8081,
    GL_COLOR_ARRAY_TYPE                                           = 0x8082,
    GL_COLOR_ARRAY_STRIDE                                         = 0x8083,
    GL_COLOR_ARRAY_COUNT_EXT                                      = 0x8084,
    GL_INDEX_ARRAY_TYPE                                           = 0x8085,
    GL_INDEX_ARRAY_STRIDE                                         = 0x8086,
    GL_INDEX_ARRAY_COUNT_EXT                                      = 0x8087,
    GL_TEXTURE_COORD_ARRAY_SIZE                                   = 0x8088,
    GL_TEXTURE_COORD_ARRAY_TYPE                                   = 0x8089,
    GL_TEXTURE_COORD_ARRAY_STRIDE                                 = 0x808A,
    GL_TEXTURE_COORD_ARRAY_COUNT_EXT                              = 0x808B,
    GL_EDGE_FLAG_ARRAY_STRIDE                                     = 0x808C,
    GL_EDGE_FLAG_ARRAY_COUNT_EXT                                  = 0x808D,
//  GL_INTERLACE_SGIX                                             = 0x8094, // reuse EnableCap
    GL_DETAIL_TEXTURE_2D_BINDING_SGIS                             = 0x8096,
//  GL_MULTISAMPLE_SGIS                                           = 0x809D, // reuse EnableCap
//  GL_SAMPLE_ALPHA_TO_MASK_SGIS                                  = 0x809E, // reuse EnableCap
//  GL_SAMPLE_ALPHA_TO_ONE_SGIS                                   = 0x809F, // reuse EnableCap
//  GL_SAMPLE_MASK_SGIS                                           = 0x80A0, // reuse EnableCap
//  GL_SAMPLE_BUFFERS                                             = 0x80A8, // reuse GetFramebufferParameter
    GL_SAMPLE_BUFFERS_SGIS                                        = 0x80A8,
//  GL_SAMPLES                                                    = 0x80A9, // reuse GetFramebufferParameter
    GL_SAMPLES_SGIS                                               = 0x80A9,
    GL_SAMPLE_COVERAGE_VALUE                                      = 0x80AA,
    GL_SAMPLE_MASK_VALUE_SGIS                                     = 0x80AA,
    GL_SAMPLE_COVERAGE_INVERT                                     = 0x80AB,
    GL_SAMPLE_MASK_INVERT_SGIS                                    = 0x80AB,
    GL_SAMPLE_PATTERN_SGIS                                        = 0x80AC,
    GL_COLOR_MATRIX_SGI                                           = 0x80B1,
    GL_COLOR_MATRIX_STACK_DEPTH_SGI                               = 0x80B2,
    GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI                           = 0x80B3,
    GL_POST_COLOR_MATRIX_RED_SCALE_SGI                            = 0x80B4,
    GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI                          = 0x80B5,
    GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI                           = 0x80B6,
    GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI                          = 0x80B7,
    GL_POST_COLOR_MATRIX_RED_BIAS_SGI                             = 0x80B8,
    GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI                           = 0x80B9,
    GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI                            = 0x80BA,
    GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI                           = 0x80BB,
//  GL_TEXTURE_COLOR_TABLE_SGI                                    = 0x80BC, // reuse ColorTableTargetSGI
    GL_BLEND_DST_RGB                                              = 0x80C8,
    GL_BLEND_SRC_RGB                                              = 0x80C9,
    GL_BLEND_DST_ALPHA                                            = 0x80CA,
    GL_BLEND_SRC_ALPHA                                            = 0x80CB,
//  GL_COLOR_TABLE_SGI                                            = 0x80D0, // reuse ColorTableTargetSGI
//  GL_POST_CONVOLUTION_COLOR_TABLE_SGI                           = 0x80D1, // reuse ColorTableTargetSGI
//  GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI                          = 0x80D2, // reuse ColorTableTargetSGI
    GL_MAX_ELEMENTS_VERTICES                                      = 0x80E8,
    GL_MAX_ELEMENTS_INDICES                                       = 0x80E9,
    GL_POINT_SIZE_MIN                                             = 0x8126,
    GL_POINT_SIZE_MIN_ARB                                         = 0x8126,
    GL_POINT_SIZE_MIN_EXT                                         = 0x8126,
    GL_POINT_SIZE_MIN_SGIS                                        = 0x8126,
    GL_POINT_SIZE_MAX                                             = 0x8127,
    GL_POINT_SIZE_MAX_ARB                                         = 0x8127,
    GL_POINT_SIZE_MAX_EXT                                         = 0x8127,
    GL_POINT_SIZE_MAX_SGIS                                        = 0x8127,
    GL_POINT_FADE_THRESHOLD_SIZE                                  = 0x8128,
    GL_POINT_FADE_THRESHOLD_SIZE_ARB                              = 0x8128,
    GL_POINT_FADE_THRESHOLD_SIZE_EXT                              = 0x8128,
    GL_POINT_FADE_THRESHOLD_SIZE_SGIS                             = 0x8128,
    GL_DISTANCE_ATTENUATION_EXT                                   = 0x8129,
    GL_DISTANCE_ATTENUATION_SGIS                                  = 0x8129,
    GL_POINT_DISTANCE_ATTENUATION                                 = 0x8129,
    GL_POINT_DISTANCE_ATTENUATION_ARB                             = 0x8129,
    GL_FOG_FUNC_POINTS_SGIS                                       = 0x812B,
    GL_MAX_FOG_FUNC_POINTS_SGIS                                   = 0x812C,
    GL_PACK_SKIP_VOLUMES_SGIS                                     = 0x8130,
    GL_PACK_IMAGE_DEPTH_SGIS                                      = 0x8131,
    GL_UNPACK_SKIP_VOLUMES_SGIS                                   = 0x8132,
    GL_UNPACK_IMAGE_DEPTH_SGIS                                    = 0x8133,
//  GL_TEXTURE_4D_SGIS                                            = 0x8134, // reuse EnableCap
    GL_MAX_4D_TEXTURE_SIZE_SGIS                                   = 0x8138,
//  GL_PIXEL_TEX_GEN_SGIX                                         = 0x8139, // reuse EnableCap
    GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX                             = 0x813E,
    GL_PIXEL_TILE_CACHE_INCREMENT_SGIX                            = 0x813F,
    GL_PIXEL_TILE_WIDTH_SGIX                                      = 0x8140,
    GL_PIXEL_TILE_HEIGHT_SGIX                                     = 0x8141,
    GL_PIXEL_TILE_GRID_WIDTH_SGIX                                 = 0x8142,
    GL_PIXEL_TILE_GRID_HEIGHT_SGIX                                = 0x8143,
    GL_PIXEL_TILE_GRID_DEPTH_SGIX                                 = 0x8144,
    GL_PIXEL_TILE_CACHE_SIZE_SGIX                                 = 0x8145,
//  GL_SPRITE_SGIX                                                = 0x8148, // reuse EnableCap
    GL_SPRITE_MODE_SGIX                                           = 0x8149,
    GL_SPRITE_AXIS_SGIX                                           = 0x814A,
    GL_SPRITE_TRANSLATION_SGIX                                    = 0x814B,
    GL_TEXTURE_4D_BINDING_SGIS                                    = 0x814F,
    GL_MAX_CLIPMAP_DEPTH_SGIX                                     = 0x8177,
    GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX                             = 0x8178,
    GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX                        = 0x817B,
    GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX                       = 0x817C,
//  GL_REFERENCE_PLANE_SGIX                                       = 0x817D, // reuse EnableCap
    GL_REFERENCE_PLANE_EQUATION_SGIX                              = 0x817E,
//  GL_IR_INSTRUMENT1_SGIX                                        = 0x817F, // reuse EnableCap
    GL_INSTRUMENT_MEASUREMENTS_SGIX                               = 0x8181,
//  GL_CALLIGRAPHIC_FRAGMENT_SGIX                                 = 0x8183, // reuse EnableCap
//  GL_FRAMEZOOM_SGIX                                             = 0x818B, // reuse EnableCap
    GL_FRAMEZOOM_FACTOR_SGIX                                      = 0x818C,
    GL_MAX_FRAMEZOOM_FACTOR_SGIX                                  = 0x818D,
    GL_GENERATE_MIPMAP_HINT_SGIS                                  = 0x8192,
    GL_DEFORMATIONS_MASK_SGIX                                     = 0x8196,
//  GL_FOG_OFFSET_SGIX                                            = 0x8198, // reuse EnableCap
//  GL_FOG_OFFSET_VALUE_SGIX                                      = 0x8199, // reuse FogParameter
    GL_LIGHT_MODEL_COLOR_CONTROL                                  = 0x81F8,
//  GL_SHARED_TEXTURE_PALETTE_EXT                                 = 0x81FB, // reuse EnableCap
    GL_MAJOR_VERSION                                              = 0x821B,
    GL_MINOR_VERSION                                              = 0x821C,
    GL_NUM_EXTENSIONS                                             = 0x821D,
    GL_CONTEXT_FLAGS                                              = 0x821E,
    GL_PROGRAM_PIPELINE_BINDING                                   = 0x825A,
    GL_MAX_VIEWPORTS                                              = 0x825B,
    GL_VIEWPORT_SUBPIXEL_BITS                                     = 0x825C,
    GL_VIEWPORT_BOUNDS_RANGE                                      = 0x825D,
    GL_LAYER_PROVOKING_VERTEX                                     = 0x825E,
    GL_VIEWPORT_INDEX_PROVOKING_VERTEX                            = 0x825F,
    GL_MAX_COMPUTE_UNIFORM_COMPONENTS                             = 0x8263,
    GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS                         = 0x8264,
    GL_MAX_COMPUTE_ATOMIC_COUNTERS                                = 0x8265,
    GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS                    = 0x8266,
    GL_MAX_DEBUG_GROUP_STACK_DEPTH                                = 0x826C,
    GL_DEBUG_GROUP_STACK_DEPTH                                    = 0x826D,
    GL_MAX_UNIFORM_LOCATIONS                                      = 0x826E,
    GL_VERTEX_BINDING_DIVISOR                                     = 0x82D6,
    GL_VERTEX_BINDING_OFFSET                                      = 0x82D7,
    GL_VERTEX_BINDING_STRIDE                                      = 0x82D8,
    GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET                          = 0x82D9,
    GL_MAX_VERTEX_ATTRIB_BINDINGS                                 = 0x82DA,
    GL_MAX_LABEL_LENGTH                                           = 0x82E8,
    GL_CONVOLUTION_HINT_SGIX                                      = 0x8316,
    GL_ASYNC_MARKER_SGIX                                          = 0x8329,
    GL_PIXEL_TEX_GEN_MODE_SGIX                                    = 0x832B,
//  GL_ASYNC_HISTOGRAM_SGIX                                       = 0x832C, // reuse EnableCap
    GL_MAX_ASYNC_HISTOGRAM_SGIX                                   = 0x832D,
//  GL_PIXEL_TEXTURE_SGIS                                         = 0x8353, // reuse EnableCap
//  GL_ASYNC_TEX_IMAGE_SGIX                                       = 0x835C, // reuse EnableCap
//  GL_ASYNC_DRAW_PIXELS_SGIX                                     = 0x835D, // reuse EnableCap
//  GL_ASYNC_READ_PIXELS_SGIX                                     = 0x835E, // reuse EnableCap
    GL_MAX_ASYNC_TEX_IMAGE_SGIX                                   = 0x835F,
    GL_MAX_ASYNC_DRAW_PIXELS_SGIX                                 = 0x8360,
    GL_MAX_ASYNC_READ_PIXELS_SGIX                                 = 0x8361,
    GL_VERTEX_PRECLIP_SGIX                                        = 0x83EE,
    GL_VERTEX_PRECLIP_HINT_SGIX                                   = 0x83EF,
//  GL_FRAGMENT_LIGHTING_SGIX                                     = 0x8400, // reuse EnableCap
//  GL_FRAGMENT_COLOR_MATERIAL_SGIX                               = 0x8401, // reuse EnableCap
    GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX                          = 0x8402,
    GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX                     = 0x8403,
    GL_MAX_FRAGMENT_LIGHTS_SGIX                                   = 0x8404,
    GL_MAX_ACTIVE_LIGHTS_SGIX                                     = 0x8405,
    GL_LIGHT_ENV_MODE_SGIX                                        = 0x8407,
//  GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX                     = 0x8408, // reuse FragmentLightModelParameterSGIX
//  GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX                         = 0x8409, // reuse FragmentLightModelParameterSGIX
//  GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX                          = 0x840A, // reuse FragmentLightModelParameterSGIX
//  GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX             = 0x840B, // reuse FragmentLightModelParameterSGIX
//  GL_FRAGMENT_LIGHT0_SGIX                                       = 0x840C, // reuse EnableCap
    GL_PACK_RESAMPLE_SGIX                                         = 0x842E,
    GL_UNPACK_RESAMPLE_SGIX                                       = 0x842F,
    GL_ALIASED_POINT_SIZE_RANGE                                   = 0x846D,
    GL_ALIASED_LINE_WIDTH_RANGE                                   = 0x846E,
    GL_ACTIVE_TEXTURE                                             = 0x84E0,
    GL_MAX_RENDERBUFFER_SIZE                                      = 0x84E8,
    GL_TEXTURE_COMPRESSION_HINT                                   = 0x84EF,
    GL_TEXTURE_BINDING_RECTANGLE                                  = 0x84F6,
    GL_TEXTURE_BINDING_RECTANGLE_ARB                              = 0x84F6,
    GL_TEXTURE_BINDING_RECTANGLE_NV                               = 0x84F6,
    GL_MAX_RECTANGLE_TEXTURE_SIZE                                 = 0x84F8,
    GL_MAX_TEXTURE_LOD_BIAS                                       = 0x84FD,
    GL_TEXTURE_BINDING_CUBE_MAP                                   = 0x8514,
    GL_TEXTURE_BINDING_CUBE_MAP_ARB                               = 0x8514,
    GL_TEXTURE_BINDING_CUBE_MAP_EXT                               = 0x8514,
    GL_MAX_CUBE_MAP_TEXTURE_SIZE                                  = 0x851C,
    GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB                              = 0x851C,
    GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT                              = 0x851C,
    GL_PACK_SUBSAMPLE_RATE_SGIX                                   = 0x85A0,
    GL_UNPACK_SUBSAMPLE_RATE_SGIX                                 = 0x85A1,
    GL_VERTEX_ARRAY_BINDING                                       = 0x85B5,
//  GL_PROGRAM_POINT_SIZE                                         = 0x8642, // reuse EnableCap
    GL_NUM_COMPRESSED_TEXTURE_FORMATS                             = 0x86A2,
    GL_COMPRESSED_TEXTURE_FORMATS                                 = 0x86A3,
    GL_NUM_PROGRAM_BINARY_FORMATS                                 = 0x87FE,
    GL_PROGRAM_BINARY_FORMATS                                     = 0x87FF,
    GL_STENCIL_BACK_FUNC                                          = 0x8800,
    GL_STENCIL_BACK_FAIL                                          = 0x8801,
    GL_STENCIL_BACK_PASS_DEPTH_FAIL                               = 0x8802,
    GL_STENCIL_BACK_PASS_DEPTH_PASS                               = 0x8803,
    GL_MAX_DRAW_BUFFERS                                           = 0x8824,
    GL_BLEND_EQUATION_ALPHA                                       = 0x883D,
    GL_MAX_VERTEX_ATTRIBS                                         = 0x8869,
    GL_MAX_TEXTURE_IMAGE_UNITS                                    = 0x8872,
    GL_ARRAY_BUFFER_BINDING                                       = 0x8894,
    GL_ELEMENT_ARRAY_BUFFER_BINDING                               = 0x8895,
    GL_PIXEL_PACK_BUFFER_BINDING                                  = 0x88ED,
    GL_PIXEL_UNPACK_BUFFER_BINDING                                = 0x88EF,
    GL_MAX_DUAL_SOURCE_DRAW_BUFFERS                               = 0x88FC,
    GL_MAX_ARRAY_TEXTURE_LAYERS                                   = 0x88FF,
    GL_MIN_PROGRAM_TEXEL_OFFSET                                   = 0x8904,
    GL_MAX_PROGRAM_TEXEL_OFFSET                                   = 0x8905,
    GL_SAMPLER_BINDING                                            = 0x8919,
    GL_FRAGMENT_SHADER_ATI                                        = 0x8920,
    GL_UNIFORM_BUFFER_BINDING                                     = 0x8A28,
    GL_UNIFORM_BUFFER_START                                       = 0x8A29,
    GL_UNIFORM_BUFFER_SIZE                                        = 0x8A2A,
    GL_MAX_VERTEX_UNIFORM_BLOCKS                                  = 0x8A2B,
    GL_MAX_GEOMETRY_UNIFORM_BLOCKS                                = 0x8A2C,
    GL_MAX_FRAGMENT_UNIFORM_BLOCKS                                = 0x8A2D,
    GL_MAX_COMBINED_UNIFORM_BLOCKS                                = 0x8A2E,
    GL_MAX_UNIFORM_BUFFER_BINDINGS                                = 0x8A2F,
    GL_MAX_UNIFORM_BLOCK_SIZE                                     = 0x8A30,
    GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS                     = 0x8A31,
    GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS                   = 0x8A32,
    GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS                   = 0x8A33,
    GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT                            = 0x8A34,
    GL_MAX_FRAGMENT_UNIFORM_COMPONENTS                            = 0x8B49,
    GL_MAX_VERTEX_UNIFORM_COMPONENTS                              = 0x8B4A,
    GL_MAX_VARYING_FLOATS                                         = 0x8B4B,
    GL_MAX_VARYING_COMPONENTS                                     = 0x8B4B,
    GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS                             = 0x8B4C,
    GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS                           = 0x8B4D,
    GL_FRAGMENT_SHADER_DERIVATIVE_HINT                            = 0x8B8B,
    GL_CURRENT_PROGRAM                                            = 0x8B8D,
//  GL_IMPLEMENTATION_COLOR_READ_TYPE                             = 0x8B9A, // reuse GetFramebufferParameter
//  GL_IMPLEMENTATION_COLOR_READ_FORMAT                           = 0x8B9B, // reuse GetFramebufferParameter
    GL_TEXTURE_BINDING_1D_ARRAY                                   = 0x8C1C,
    GL_TEXTURE_BINDING_2D_ARRAY                                   = 0x8C1D,
    GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS                           = 0x8C29,
    GL_MAX_TEXTURE_BUFFER_SIZE                                    = 0x8C2B,
    GL_TEXTURE_BINDING_BUFFER                                     = 0x8C2C,
    GL_TRANSFORM_FEEDBACK_BUFFER_START                            = 0x8C84,
    GL_TRANSFORM_FEEDBACK_BUFFER_SIZE                             = 0x8C85,
    GL_TRANSFORM_FEEDBACK_BUFFER_BINDING                          = 0x8C8F,
    GL_STENCIL_BACK_REF                                           = 0x8CA3,
    GL_STENCIL_BACK_VALUE_MASK                                    = 0x8CA4,
    GL_STENCIL_BACK_WRITEMASK                                     = 0x8CA5,
    GL_DRAW_FRAMEBUFFER_BINDING                                   = 0x8CA6,
    GL_RENDERBUFFER_BINDING                                       = 0x8CA7,
    GL_READ_FRAMEBUFFER_BINDING                                   = 0x8CAA,
    GL_MAX_COLOR_ATTACHMENTS                                      = 0x8CDF,
    GL_MAX_COLOR_ATTACHMENTS_EXT                                  = 0x8CDF,
    GL_MAX_ELEMENT_INDEX                                          = 0x8D6B,
    GL_MAX_GEOMETRY_UNIFORM_COMPONENTS                            = 0x8DDF,
    GL_SHADER_BINARY_FORMATS                                      = 0x8DF8,
    GL_NUM_SHADER_BINARY_FORMATS                                  = 0x8DF9,
    GL_SHADER_COMPILER                                            = 0x8DFA,
    GL_MAX_VERTEX_UNIFORM_VECTORS                                 = 0x8DFB,
    GL_MAX_VARYING_VECTORS                                        = 0x8DFC,
    GL_MAX_FRAGMENT_UNIFORM_VECTORS                               = 0x8DFD,
    GL_TIMESTAMP                                                  = 0x8E28,
    GL_PROVOKING_VERTEX                                           = 0x8E4F,
    GL_MAX_SAMPLE_MASK_WORDS                                      = 0x8E59,
    GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS                            = 0x8E89,
    GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS                         = 0x8E8A,
    GL_PRIMITIVE_RESTART_INDEX                                    = 0x8F9E,
    GL_MIN_MAP_BUFFER_ALIGNMENT                                   = 0x90BC,
    GL_SHADER_STORAGE_BUFFER_BINDING                              = 0x90D3,
    GL_SHADER_STORAGE_BUFFER_START                                = 0x90D4,
    GL_SHADER_STORAGE_BUFFER_SIZE                                 = 0x90D5,
    GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS                           = 0x90D6,
    GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS                         = 0x90D7,
    GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS                     = 0x90D8,
    GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS                  = 0x90D9,
    GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS                         = 0x90DA,
    GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS                          = 0x90DB,
    GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS                         = 0x90DC,
    GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS                         = 0x90DD,
    GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT                     = 0x90DF,
    GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS                         = 0x90EB,
    GL_DISPATCH_INDIRECT_BUFFER_BINDING                           = 0x90EF,
    GL_TEXTURE_BINDING_2D_MULTISAMPLE                             = 0x9104,
    GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY                       = 0x9105,
    GL_MAX_COLOR_TEXTURE_SAMPLES                                  = 0x910E,
    GL_MAX_DEPTH_TEXTURE_SAMPLES                                  = 0x910F,
    GL_MAX_INTEGER_SAMPLES                                        = 0x9110,
    GL_MAX_SERVER_WAIT_TIMEOUT                                    = 0x9111,
    GL_MAX_VERTEX_OUTPUT_COMPONENTS                               = 0x9122,
    GL_MAX_GEOMETRY_INPUT_COMPONENTS                              = 0x9123,
    GL_MAX_GEOMETRY_OUTPUT_COMPONENTS                             = 0x9124,
    GL_MAX_FRAGMENT_INPUT_COMPONENTS                              = 0x9125,
    GL_CONTEXT_PROFILE_MASK                                       = 0x9126,
    GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT                            = 0x919F,
    GL_MAX_COMPUTE_UNIFORM_BLOCKS                                 = 0x91BB,
    GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS                            = 0x91BC,
    GL_MAX_COMPUTE_WORK_GROUP_COUNT                               = 0x91BE,
    GL_MAX_COMPUTE_WORK_GROUP_SIZE                                = 0x91BF,
    GL_MAX_VERTEX_ATOMIC_COUNTERS                                 = 0x92D2,
    GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS                           = 0x92D3,
    GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS                        = 0x92D4,
    GL_MAX_GEOMETRY_ATOMIC_COUNTERS                               = 0x92D5,
    GL_MAX_FRAGMENT_ATOMIC_COUNTERS                               = 0x92D6,
    GL_MAX_COMBINED_ATOMIC_COUNTERS                               = 0x92D7,
    GL_MAX_FRAMEBUFFER_WIDTH                                      = 0x9315,
    GL_MAX_FRAMEBUFFER_HEIGHT                                     = 0x9316,
    GL_MAX_FRAMEBUFFER_LAYERS                                     = 0x9317,
    GL_MAX_FRAMEBUFFER_SAMPLES                                    = 0x9318,
    GL_NUM_DEVICE_UUIDS_EXT                                       = 0x9596,
    GL_DEVICE_UUID_EXT                                            = 0x9597,
    GL_DRIVER_UUID_EXT                                            = 0x9598,
    GL_DEVICE_LUID_EXT                                            = 0x9599,
    GL_DEVICE_NODE_MASK_EXT                                       = 0x959A,
//  GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV                        = 0x95B1, // reuse EnableCap
    GL_SHADING_RATE_IMAGE_PALETTE_COUNT_NV                        = 0x95B2,
    GL_MAX_TIMELINE_SEMAPHORE_VALUE_DIFFERENCE_NV                 = 0x95B6,

    // GetPointervPName

    GL_FEEDBACK_BUFFER_POINTER                                    = 0x0DF0,
    GL_SELECTION_BUFFER_POINTER                                   = 0x0DF3,
    GL_VERTEX_ARRAY_POINTER                                       = 0x808E,
    GL_VERTEX_ARRAY_POINTER_EXT                                   = 0x808E,
    GL_NORMAL_ARRAY_POINTER                                       = 0x808F,
    GL_NORMAL_ARRAY_POINTER_EXT                                   = 0x808F,
    GL_COLOR_ARRAY_POINTER                                        = 0x8090,
    GL_COLOR_ARRAY_POINTER_EXT                                    = 0x8090,
    GL_INDEX_ARRAY_POINTER                                        = 0x8091,
    GL_INDEX_ARRAY_POINTER_EXT                                    = 0x8091,
    GL_TEXTURE_COORD_ARRAY_POINTER                                = 0x8092,
    GL_TEXTURE_COORD_ARRAY_POINTER_EXT                            = 0x8092,
    GL_EDGE_FLAG_ARRAY_POINTER                                    = 0x8093,
    GL_EDGE_FLAG_ARRAY_POINTER_EXT                                = 0x8093,
    GL_INSTRUMENT_BUFFER_POINTER_SGIX                             = 0x8180,
    GL_DEBUG_CALLBACK_FUNCTION                                    = 0x8244,
    GL_DEBUG_CALLBACK_USER_PARAM                                  = 0x8245,

    // GetTexBumpParameterATI

    GL_BUMP_ROT_MATRIX_ATI                                        = 0x8775,
    GL_BUMP_ROT_MATRIX_SIZE_ATI                                   = 0x8776,
    GL_BUMP_NUM_TEX_UNITS_ATI                                     = 0x8777,
    GL_BUMP_TEX_UNITS_ATI                                         = 0x8778,

    // GetTextureParameter

    GL_TEXTURE_WIDTH                                              = 0x1000,
    GL_TEXTURE_HEIGHT                                             = 0x1001,
    GL_TEXTURE_INTERNAL_FORMAT                                    = 0x1003,
    GL_TEXTURE_COMPONENTS                                         = 0x1003,
    GL_TEXTURE_BORDER_COLOR                                       = 0x1004,
    GL_TEXTURE_BORDER                                             = 0x1005,
    GL_TEXTURE_MAG_FILTER                                         = 0x2800,
    GL_TEXTURE_MIN_FILTER                                         = 0x2801,
    GL_TEXTURE_WRAP_S                                             = 0x2802,
    GL_TEXTURE_WRAP_T                                             = 0x2803,
    GL_TEXTURE_RED_SIZE                                           = 0x805C,
    GL_TEXTURE_GREEN_SIZE                                         = 0x805D,
    GL_TEXTURE_BLUE_SIZE                                          = 0x805E,
    GL_TEXTURE_ALPHA_SIZE                                         = 0x805F,
    GL_TEXTURE_LUMINANCE_SIZE                                     = 0x8060,
    GL_TEXTURE_INTENSITY_SIZE                                     = 0x8061,
    GL_TEXTURE_PRIORITY                                           = 0x8066,
    GL_TEXTURE_RESIDENT                                           = 0x8067,
    GL_TEXTURE_DEPTH_EXT                                          = 0x8071,
    GL_TEXTURE_WRAP_R_EXT                                         = 0x8072,
    GL_DETAIL_TEXTURE_LEVEL_SGIS                                  = 0x809A,
    GL_DETAIL_TEXTURE_MODE_SGIS                                   = 0x809B,
    GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS                            = 0x809C,
    GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS                           = 0x80B0,
    GL_SHADOW_AMBIENT_SGIX                                        = 0x80BF,
    GL_DUAL_TEXTURE_SELECT_SGIS                                   = 0x8124,
    GL_QUAD_TEXTURE_SELECT_SGIS                                   = 0x8125,
    GL_TEXTURE_4DSIZE_SGIS                                        = 0x8136,
    GL_TEXTURE_WRAP_Q_SGIS                                        = 0x8137,
    GL_TEXTURE_MIN_LOD_SGIS                                       = 0x813A,
    GL_TEXTURE_MAX_LOD_SGIS                                       = 0x813B,
    GL_TEXTURE_BASE_LEVEL_SGIS                                    = 0x813C,
    GL_TEXTURE_MAX_LEVEL_SGIS                                     = 0x813D,
    GL_TEXTURE_FILTER4_SIZE_SGIS                                  = 0x8147,
    GL_TEXTURE_CLIPMAP_CENTER_SGIX                                = 0x8171,
    GL_TEXTURE_CLIPMAP_FRAME_SGIX                                 = 0x8172,
    GL_TEXTURE_CLIPMAP_OFFSET_SGIX                                = 0x8173,
    GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX                         = 0x8174,
    GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX                            = 0x8175,
    GL_TEXTURE_CLIPMAP_DEPTH_SGIX                                 = 0x8176,
    GL_POST_TEXTURE_FILTER_BIAS_SGIX                              = 0x8179,
    GL_POST_TEXTURE_FILTER_SCALE_SGIX                             = 0x817A,
    GL_TEXTURE_LOD_BIAS_S_SGIX                                    = 0x818E,
    GL_TEXTURE_LOD_BIAS_T_SGIX                                    = 0x818F,
    GL_TEXTURE_LOD_BIAS_R_SGIX                                    = 0x8190,
    GL_GENERATE_MIPMAP_SGIS                                       = 0x8191,
    GL_TEXTURE_COMPARE_SGIX                                       = 0x819A,
    GL_TEXTURE_COMPARE_OPERATOR_SGIX                              = 0x819B,
    GL_TEXTURE_LEQUAL_R_SGIX                                      = 0x819C,
    GL_TEXTURE_GEQUAL_R_SGIX                                      = 0x819D,
    GL_TEXTURE_MAX_CLAMP_S_SGIX                                   = 0x8369,
    GL_TEXTURE_MAX_CLAMP_T_SGIX                                   = 0x836A,
    GL_TEXTURE_MAX_CLAMP_R_SGIX                                   = 0x836B,
    GL_NORMAL_MAP                                                 = 0x8511,
    GL_NORMAL_MAP_ARB                                             = 0x8511,
    GL_NORMAL_MAP_EXT                                             = 0x8511,
    GL_NORMAL_MAP_NV                                              = 0x8511,
    GL_REFLECTION_MAP                                             = 0x8512,
    GL_REFLECTION_MAP_ARB                                         = 0x8512,
    GL_REFLECTION_MAP_EXT                                         = 0x8512,
    GL_REFLECTION_MAP_NV                                          = 0x8512,

    // GetVariantValueEXT

    GL_VARIANT_VALUE_EXT                                          = 0x87E4,
    GL_VARIANT_DATATYPE_EXT                                       = 0x87E5,
    GL_VARIANT_ARRAY_STRIDE_EXT                                   = 0x87E6,
    GL_VARIANT_ARRAY_TYPE_EXT                                     = 0x87E7,

    // GraphicsResetStatus

//  GL_NO_ERROR                                                   = 0, // reuse ErrorCode
    GL_GUILTY_CONTEXT_RESET                                       = 0x8253,
    GL_INNOCENT_CONTEXT_RESET                                     = 0x8254,
    GL_UNKNOWN_CONTEXT_RESET                                      = 0x8255,

    // HintMode

//  GL_DONT_CARE                                                  = 0x1100, // reuse DebugSeverity
    GL_FASTEST                                                    = 0x1101,
    GL_NICEST                                                     = 0x1102,

    // HintTarget

//  GL_PERSPECTIVE_CORRECTION_HINT                                = 0x0C50, // reuse GetPName
//  GL_POINT_SMOOTH_HINT                                          = 0x0C51, // reuse GetPName
//  GL_LINE_SMOOTH_HINT                                           = 0x0C52, // reuse GetPName
//  GL_POLYGON_SMOOTH_HINT                                        = 0x0C53, // reuse GetPName
//  GL_FOG_HINT                                                   = 0x0C54, // reuse GetPName
    GL_PREFER_DOUBLEBUFFER_HINT_PGI                               = 0x1A1F8,
    GL_CONSERVE_MEMORY_HINT_PGI                                   = 0x1A1FD,
    GL_RECLAIM_MEMORY_HINT_PGI                                    = 0x1A1FE,
    GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI                             = 0x1A203,
    GL_NATIVE_GRAPHICS_END_HINT_PGI                               = 0x1A204,
    GL_ALWAYS_FAST_HINT_PGI                                       = 0x1A20C,
    GL_ALWAYS_SOFT_HINT_PGI                                       = 0x1A20D,
    GL_ALLOW_DRAW_OBJ_HINT_PGI                                    = 0x1A20E,
    GL_ALLOW_DRAW_WIN_HINT_PGI                                    = 0x1A20F,
    GL_ALLOW_DRAW_FRG_HINT_PGI                                    = 0x1A210,
    GL_ALLOW_DRAW_MEM_HINT_PGI                                    = 0x1A211,
    GL_STRICT_DEPTHFUNC_HINT_PGI                                  = 0x1A216,
    GL_STRICT_LIGHTING_HINT_PGI                                   = 0x1A217,
    GL_STRICT_SCISSOR_HINT_PGI                                    = 0x1A218,
    GL_FULL_STIPPLE_HINT_PGI                                      = 0x1A219,
    GL_CLIP_NEAR_HINT_PGI                                         = 0x1A220,
    GL_CLIP_FAR_HINT_PGI                                          = 0x1A221,
    GL_WIDE_LINE_HINT_PGI                                         = 0x1A222,
    GL_BACK_NORMALS_HINT_PGI                                      = 0x1A223,
    GL_VERTEX_DATA_HINT_PGI                                       = 0x1A22A,
    GL_VERTEX_CONSISTENT_HINT_PGI                                 = 0x1A22B,
    GL_MATERIAL_SIDE_HINT_PGI                                     = 0x1A22C,
    GL_MAX_VERTEX_HINT_PGI                                        = 0x1A22D,
//  GL_PACK_CMYK_HINT_EXT                                         = 0x800E, // reuse GetPName
//  GL_UNPACK_CMYK_HINT_EXT                                       = 0x800F, // reuse GetPName
    GL_PHONG_HINT_WIN                                             = 0x80EB,
    GL_CLIP_VOLUME_CLIPPING_HINT_EXT                              = 0x80F0,
    GL_TEXTURE_MULTI_BUFFER_HINT_SGIX                             = 0x812E,
    GL_GENERATE_MIPMAP_HINT                                       = 0x8192,
//  GL_GENERATE_MIPMAP_HINT_SGIS                                  = 0x8192, // reuse GetPName
    GL_PROGRAM_BINARY_RETRIEVABLE_HINT                            = 0x8257,
//  GL_CONVOLUTION_HINT_SGIX                                      = 0x8316, // reuse GetPName
    GL_SCALEBIAS_HINT_SGIX                                        = 0x8322,
//  GL_VERTEX_PRECLIP_SGIX                                        = 0x83EE, // reuse GetPName
//  GL_VERTEX_PRECLIP_HINT_SGIX                                   = 0x83EF, // reuse GetPName
//  GL_TEXTURE_COMPRESSION_HINT                                   = 0x84EF, // reuse GetPName
    GL_TEXTURE_COMPRESSION_HINT_ARB                               = 0x84EF,
    GL_VERTEX_ARRAY_STORAGE_HINT_APPLE                            = 0x851F,
    GL_MULTISAMPLE_FILTER_HINT_NV                                 = 0x8534,
    GL_TRANSFORM_HINT_APPLE                                       = 0x85B1,
    GL_TEXTURE_STORAGE_HINT_APPLE                                 = 0x85BC,
//  GL_FRAGMENT_SHADER_DERIVATIVE_HINT                            = 0x8B8B, // reuse GetPName
    GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB                        = 0x8B8B,

    // HintTargetPGI

//  GL_VERTEX_DATA_HINT_PGI                                       = 0x1A22A, // reuse HintTarget
//  GL_VERTEX_CONSISTENT_HINT_PGI                                 = 0x1A22B, // reuse HintTarget
//  GL_MATERIAL_SIDE_HINT_PGI                                     = 0x1A22C, // reuse HintTarget
//  GL_MAX_VERTEX_HINT_PGI                                        = 0x1A22D, // reuse HintTarget

    // HistogramTarget

    GL_HISTOGRAM                                                  = 0x8024,
    GL_PROXY_HISTOGRAM                                            = 0x8025,

    // HistogramTargetEXT

//  GL_HISTOGRAM                                                  = 0x8024, // reuse HistogramTarget
//  GL_HISTOGRAM_EXT                                              = 0x8024, // reuse EnableCap
//  GL_PROXY_HISTOGRAM                                            = 0x8025, // reuse HistogramTarget
    GL_PROXY_HISTOGRAM_EXT                                        = 0x8025,

    // ImageTransformPNameHP

    GL_IMAGE_SCALE_X_HP                                           = 0x8155,
    GL_IMAGE_SCALE_Y_HP                                           = 0x8156,
    GL_IMAGE_TRANSLATE_X_HP                                       = 0x8157,
    GL_IMAGE_TRANSLATE_Y_HP                                       = 0x8158,
    GL_IMAGE_ROTATE_ANGLE_HP                                      = 0x8159,
    GL_IMAGE_ROTATE_ORIGIN_X_HP                                   = 0x815A,
    GL_IMAGE_ROTATE_ORIGIN_Y_HP                                   = 0x815B,
    GL_IMAGE_MAG_FILTER_HP                                        = 0x815C,
    GL_IMAGE_MIN_FILTER_HP                                        = 0x815D,
    GL_IMAGE_CUBIC_WEIGHT_HP                                      = 0x815E,

    // ImageTransformTargetHP

    GL_IMAGE_TRANSFORM_2D_HP                                      = 0x8161,

    // IndexFunctionEXT

//  GL_NEVER                                                      = 0x0200, // reuse AlphaFunction
//  GL_LESS                                                       = 0x0201, // reuse AlphaFunction
//  GL_EQUAL                                                      = 0x0202, // reuse AlphaFunction
//  GL_LEQUAL                                                     = 0x0203, // reuse AlphaFunction
//  GL_GREATER                                                    = 0x0204, // reuse AlphaFunction
//  GL_NOTEQUAL                                                   = 0x0205, // reuse AlphaFunction
//  GL_GEQUAL                                                     = 0x0206, // reuse AlphaFunction
//  GL_ALWAYS                                                     = 0x0207, // reuse AlphaFunction

    // IndexMaterialParameterEXT

//  GL_INDEX_OFFSET                                               = 0x0D13, // reuse GetPName

    // IndexPointerType

//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // InstancedPathCoverMode

    GL_PATH_FILL_COVER_MODE_NV                                    = 0x9082,
    GL_CONVEX_HULL_NV                                             = 0x908B,
    GL_BOUNDING_BOX_NV                                            = 0x908D,
    GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV                          = 0x909C,

    // InterleavedArrayFormat

    GL_V2F                                                        = 0x2A20,
    GL_V3F                                                        = 0x2A21,
    GL_C4UB_V2F                                                   = 0x2A22,
    GL_C4UB_V3F                                                   = 0x2A23,
    GL_C3F_V3F                                                    = 0x2A24,
    GL_N3F_V3F                                                    = 0x2A25,
    GL_C4F_N3F_V3F                                                = 0x2A26,
    GL_T2F_V3F                                                    = 0x2A27,
    GL_T4F_V4F                                                    = 0x2A28,
    GL_T2F_C4UB_V3F                                               = 0x2A29,
    GL_T2F_C3F_V3F                                                = 0x2A2A,
    GL_T2F_N3F_V3F                                                = 0x2A2B,
    GL_T2F_C4F_N3F_V3F                                            = 0x2A2C,
    GL_T4F_C4F_N3F_V4F                                            = 0x2A2D,

    // InternalFormat

//  GL_STENCIL_INDEX                                              = 0x1901, // reuse DepthStencilTextureMode
//  GL_DEPTH_COMPONENT                                            = 0x1902, // reuse DepthStencilTextureMode
//  GL_RED                                                        = 0x1903, // reuse FragmentShaderValueRepATI
//  GL_RGB                                                        = 0x1907, // reuse CombinerComponentUsageNV
    GL_RGBA                                                       = 0x1908,
    GL_R3_G3_B2                                                   = 0x2A10,
    GL_ALPHA4                                                     = 0x803B,
    GL_ALPHA4_EXT                                                 = 0x803B,
    GL_ALPHA8                                                     = 0x803C,
    GL_ALPHA8_EXT                                                 = 0x803C,
    GL_ALPHA12                                                    = 0x803D,
    GL_ALPHA12_EXT                                                = 0x803D,
    GL_ALPHA16                                                    = 0x803E,
    GL_ALPHA16_EXT                                                = 0x803E,
    GL_LUMINANCE4                                                 = 0x803F,
    GL_LUMINANCE4_EXT                                             = 0x803F,
    GL_LUMINANCE8                                                 = 0x8040,
    GL_LUMINANCE8_EXT                                             = 0x8040,
    GL_LUMINANCE12                                                = 0x8041,
    GL_LUMINANCE12_EXT                                            = 0x8041,
    GL_LUMINANCE16                                                = 0x8042,
    GL_LUMINANCE16_EXT                                            = 0x8042,
    GL_LUMINANCE4_ALPHA4                                          = 0x8043,
    GL_LUMINANCE4_ALPHA4_EXT                                      = 0x8043,
    GL_LUMINANCE6_ALPHA2                                          = 0x8044,
    GL_LUMINANCE6_ALPHA2_EXT                                      = 0x8044,
    GL_LUMINANCE8_ALPHA8                                          = 0x8045,
    GL_LUMINANCE8_ALPHA8_EXT                                      = 0x8045,
    GL_LUMINANCE12_ALPHA4                                         = 0x8046,
    GL_LUMINANCE12_ALPHA4_EXT                                     = 0x8046,
    GL_LUMINANCE12_ALPHA12                                        = 0x8047,
    GL_LUMINANCE12_ALPHA12_EXT                                    = 0x8047,
    GL_LUMINANCE16_ALPHA16                                        = 0x8048,
    GL_LUMINANCE16_ALPHA16_EXT                                    = 0x8048,
    GL_INTENSITY                                                  = 0x8049,
    GL_INTENSITY4                                                 = 0x804A,
    GL_INTENSITY4_EXT                                             = 0x804A,
    GL_INTENSITY8                                                 = 0x804B,
    GL_INTENSITY8_EXT                                             = 0x804B,
    GL_INTENSITY12                                                = 0x804C,
    GL_INTENSITY12_EXT                                            = 0x804C,
    GL_INTENSITY16                                                = 0x804D,
    GL_INTENSITY16_EXT                                            = 0x804D,
    GL_RGB2_EXT                                                   = 0x804E,
    GL_RGB4                                                       = 0x804F,
    GL_RGB4_EXT                                                   = 0x804F,
    GL_RGB5                                                       = 0x8050,
    GL_RGB5_EXT                                                   = 0x8050,
    GL_RGB8                                                       = 0x8051,
    GL_RGB8_EXT                                                   = 0x8051,
    GL_RGB10                                                      = 0x8052,
    GL_RGB10_EXT                                                  = 0x8052,
    GL_RGB12                                                      = 0x8053,
    GL_RGB12_EXT                                                  = 0x8053,
    GL_RGB16                                                      = 0x8054,
    GL_RGB16_EXT                                                  = 0x8054,
    GL_RGBA2                                                      = 0x8055,
    GL_RGBA2_EXT                                                  = 0x8055,
    GL_RGBA4                                                      = 0x8056,
    GL_RGBA4_EXT                                                  = 0x8056,
    GL_RGB5_A1                                                    = 0x8057,
    GL_RGB5_A1_EXT                                                = 0x8057,
    GL_RGBA8                                                      = 0x8058,
    GL_RGBA8_EXT                                                  = 0x8058,
    GL_RGB10_A2                                                   = 0x8059,
    GL_RGB10_A2_EXT                                               = 0x8059,
    GL_RGBA12                                                     = 0x805A,
    GL_RGBA12_EXT                                                 = 0x805A,
    GL_RGBA16                                                     = 0x805B,
    GL_RGBA16_EXT                                                 = 0x805B,
    GL_DUAL_ALPHA4_SGIS                                           = 0x8110,
    GL_DUAL_ALPHA8_SGIS                                           = 0x8111,
    GL_DUAL_ALPHA12_SGIS                                          = 0x8112,
    GL_DUAL_ALPHA16_SGIS                                          = 0x8113,
    GL_DUAL_LUMINANCE4_SGIS                                       = 0x8114,
    GL_DUAL_LUMINANCE8_SGIS                                       = 0x8115,
    GL_DUAL_LUMINANCE12_SGIS                                      = 0x8116,
    GL_DUAL_LUMINANCE16_SGIS                                      = 0x8117,
    GL_DUAL_INTENSITY4_SGIS                                       = 0x8118,
    GL_DUAL_INTENSITY8_SGIS                                       = 0x8119,
    GL_DUAL_INTENSITY12_SGIS                                      = 0x811A,
    GL_DUAL_INTENSITY16_SGIS                                      = 0x811B,
    GL_DUAL_LUMINANCE_ALPHA4_SGIS                                 = 0x811C,
    GL_DUAL_LUMINANCE_ALPHA8_SGIS                                 = 0x811D,
    GL_QUAD_ALPHA4_SGIS                                           = 0x811E,
    GL_QUAD_ALPHA8_SGIS                                           = 0x811F,
    GL_QUAD_LUMINANCE4_SGIS                                       = 0x8120,
    GL_QUAD_LUMINANCE8_SGIS                                       = 0x8121,
    GL_QUAD_INTENSITY4_SGIS                                       = 0x8122,
    GL_QUAD_INTENSITY8_SGIS                                       = 0x8123,
    GL_DEPTH_COMPONENT16                                          = 0x81A5,
    GL_DEPTH_COMPONENT16_ARB                                      = 0x81A5,
    GL_DEPTH_COMPONENT16_SGIX                                     = 0x81A5,
    GL_DEPTH_COMPONENT24                                          = 0x81A6,
    GL_DEPTH_COMPONENT24_ARB                                      = 0x81A6,
    GL_DEPTH_COMPONENT24_SGIX                                     = 0x81A6,
    GL_DEPTH_COMPONENT32                                          = 0x81A7,
    GL_DEPTH_COMPONENT32_ARB                                      = 0x81A7,
    GL_DEPTH_COMPONENT32_SGIX                                     = 0x81A7,
    GL_COMPRESSED_RED                                             = 0x8225,
    GL_COMPRESSED_RG                                              = 0x8226,
    GL_RG                                                         = 0x8227,
    GL_R8                                                         = 0x8229,
    GL_R8_EXT                                                     = 0x8229,
    GL_R16                                                        = 0x822A,
    GL_RG8                                                        = 0x822B,
    GL_RG8_EXT                                                    = 0x822B,
    GL_RG16                                                       = 0x822C,
    GL_R16F                                                       = 0x822D,
    GL_R16F_EXT                                                   = 0x822D,
    GL_R32F                                                       = 0x822E,
    GL_R32F_EXT                                                   = 0x822E,
    GL_RG16F                                                      = 0x822F,
    GL_RG16F_EXT                                                  = 0x822F,
    GL_RG32F                                                      = 0x8230,
    GL_RG32F_EXT                                                  = 0x8230,
    GL_R8I                                                        = 0x8231,
    GL_R8UI                                                       = 0x8232,
    GL_R16I                                                       = 0x8233,
    GL_R16UI                                                      = 0x8234,
    GL_R32I                                                       = 0x8235,
    GL_R32UI                                                      = 0x8236,
    GL_RG8I                                                       = 0x8237,
    GL_RG8UI                                                      = 0x8238,
    GL_RG16I                                                      = 0x8239,
    GL_RG16UI                                                     = 0x823A,
    GL_RG32I                                                      = 0x823B,
    GL_RG32UI                                                     = 0x823C,
    GL_COMPRESSED_RGB_S3TC_DXT1_EXT                               = 0x83F0,
    GL_COMPRESSED_RGBA_S3TC_DXT1_EXT                              = 0x83F1,
    GL_COMPRESSED_RGBA_S3TC_DXT3_EXT                              = 0x83F2,
    GL_COMPRESSED_RGBA_S3TC_DXT5_EXT                              = 0x83F3,
    GL_COMPRESSED_RGB                                             = 0x84ED,
    GL_COMPRESSED_RGBA                                            = 0x84EE,
    GL_DEPTH_STENCIL                                              = 0x84F9,
    GL_DEPTH_STENCIL_EXT                                          = 0x84F9,
    GL_DEPTH_STENCIL_NV                                           = 0x84F9,
    GL_RGBA32F                                                    = 0x8814,
    GL_RGBA32F_ARB                                                = 0x8814,
    GL_RGBA32F_EXT                                                = 0x8814,
    GL_RGB32F                                                     = 0x8815,
    GL_RGB32F_ARB                                                 = 0x8815,
    GL_RGB32F_EXT                                                 = 0x8815,
    GL_RGBA16F                                                    = 0x881A,
    GL_RGBA16F_ARB                                                = 0x881A,
    GL_RGBA16F_EXT                                                = 0x881A,
    GL_RGB16F                                                     = 0x881B,
    GL_RGB16F_ARB                                                 = 0x881B,
    GL_RGB16F_EXT                                                 = 0x881B,
    GL_DEPTH24_STENCIL8                                           = 0x88F0,
    GL_DEPTH24_STENCIL8_EXT                                       = 0x88F0,
    GL_R11F_G11F_B10F                                             = 0x8C3A,
    GL_R11F_G11F_B10F_EXT                                         = 0x8C3A,
    GL_RGB9_E5                                                    = 0x8C3D,
    GL_RGB9_E5_EXT                                                = 0x8C3D,
    GL_SRGB                                                       = 0x8C40,
    GL_SRGB_EXT                                                   = 0x8C40,
    GL_SRGB8                                                      = 0x8C41,
    GL_SRGB8_EXT                                                  = 0x8C41,
    GL_SRGB_ALPHA                                                 = 0x8C42,
    GL_SRGB_ALPHA_EXT                                             = 0x8C42,
    GL_SRGB8_ALPHA8                                               = 0x8C43,
    GL_SRGB8_ALPHA8_EXT                                           = 0x8C43,
    GL_COMPRESSED_SRGB                                            = 0x8C48,
    GL_COMPRESSED_SRGB_ALPHA                                      = 0x8C49,
    GL_COMPRESSED_SRGB_S3TC_DXT1_EXT                              = 0x8C4C,
    GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT                        = 0x8C4D,
    GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT                        = 0x8C4E,
    GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT                        = 0x8C4F,
    GL_DEPTH_COMPONENT32F                                         = 0x8CAC,
    GL_DEPTH32F_STENCIL8                                          = 0x8CAD,
    GL_STENCIL_INDEX1                                             = 0x8D46,
    GL_STENCIL_INDEX1_EXT                                         = 0x8D46,
    GL_STENCIL_INDEX4                                             = 0x8D47,
    GL_STENCIL_INDEX4_EXT                                         = 0x8D47,
    GL_STENCIL_INDEX8                                             = 0x8D48,
    GL_STENCIL_INDEX8_EXT                                         = 0x8D48,
    GL_STENCIL_INDEX16                                            = 0x8D49,
    GL_STENCIL_INDEX16_EXT                                        = 0x8D49,
    GL_RGB565                                                     = 0x8D62,
    GL_RGBA32UI                                                   = 0x8D70,
    GL_RGBA32UI_EXT                                               = 0x8D70,
    GL_RGB32UI                                                    = 0x8D71,
    GL_RGB32UI_EXT                                                = 0x8D71,
    GL_ALPHA32UI_EXT                                              = 0x8D72,
    GL_INTENSITY32UI_EXT                                          = 0x8D73,
    GL_LUMINANCE32UI_EXT                                          = 0x8D74,
    GL_LUMINANCE_ALPHA32UI_EXT                                    = 0x8D75,
    GL_RGBA16UI                                                   = 0x8D76,
    GL_RGBA16UI_EXT                                               = 0x8D76,
    GL_RGB16UI                                                    = 0x8D77,
    GL_RGB16UI_EXT                                                = 0x8D77,
    GL_ALPHA16UI_EXT                                              = 0x8D78,
    GL_INTENSITY16UI_EXT                                          = 0x8D79,
    GL_LUMINANCE16UI_EXT                                          = 0x8D7A,
    GL_LUMINANCE_ALPHA16UI_EXT                                    = 0x8D7B,
    GL_RGBA8UI                                                    = 0x8D7C,
    GL_RGBA8UI_EXT                                                = 0x8D7C,
    GL_RGB8UI                                                     = 0x8D7D,
    GL_RGB8UI_EXT                                                 = 0x8D7D,
    GL_ALPHA8UI_EXT                                               = 0x8D7E,
    GL_INTENSITY8UI_EXT                                           = 0x8D7F,
    GL_LUMINANCE8UI_EXT                                           = 0x8D80,
    GL_LUMINANCE_ALPHA8UI_EXT                                     = 0x8D81,
    GL_RGBA32I                                                    = 0x8D82,
    GL_RGBA32I_EXT                                                = 0x8D82,
    GL_RGB32I                                                     = 0x8D83,
    GL_RGB32I_EXT                                                 = 0x8D83,
    GL_ALPHA32I_EXT                                               = 0x8D84,
    GL_INTENSITY32I_EXT                                           = 0x8D85,
    GL_LUMINANCE32I_EXT                                           = 0x8D86,
    GL_LUMINANCE_ALPHA32I_EXT                                     = 0x8D87,
    GL_RGBA16I                                                    = 0x8D88,
    GL_RGBA16I_EXT                                                = 0x8D88,
    GL_RGB16I                                                     = 0x8D89,
    GL_RGB16I_EXT                                                 = 0x8D89,
    GL_ALPHA16I_EXT                                               = 0x8D8A,
    GL_INTENSITY16I_EXT                                           = 0x8D8B,
    GL_LUMINANCE16I_EXT                                           = 0x8D8C,
    GL_LUMINANCE_ALPHA16I_EXT                                     = 0x8D8D,
    GL_RGBA8I                                                     = 0x8D8E,
    GL_RGBA8I_EXT                                                 = 0x8D8E,
    GL_RGB8I                                                      = 0x8D8F,
    GL_RGB8I_EXT                                                  = 0x8D8F,
    GL_ALPHA8I_EXT                                                = 0x8D90,
    GL_INTENSITY8I_EXT                                            = 0x8D91,
    GL_LUMINANCE8I_EXT                                            = 0x8D92,
    GL_LUMINANCE_ALPHA8I_EXT                                      = 0x8D93,
    GL_DEPTH_COMPONENT32F_NV                                      = 0x8DAB,
    GL_DEPTH32F_STENCIL8_NV                                       = 0x8DAC,
    GL_COMPRESSED_RED_RGTC1                                       = 0x8DBB,
    GL_COMPRESSED_RED_RGTC1_EXT                                   = 0x8DBB,
    GL_COMPRESSED_SIGNED_RED_RGTC1                                = 0x8DBC,
    GL_COMPRESSED_SIGNED_RED_RGTC1_EXT                            = 0x8DBC,
    GL_COMPRESSED_RED_GREEN_RGTC2_EXT                             = 0x8DBD,
    GL_COMPRESSED_RG_RGTC2                                        = 0x8DBD,
    GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT                      = 0x8DBE,
    GL_COMPRESSED_SIGNED_RG_RGTC2                                 = 0x8DBE,
    GL_COMPRESSED_RGBA_BPTC_UNORM                                 = 0x8E8C,
    GL_COMPRESSED_RGBA_BPTC_UNORM_ARB                             = 0x8E8C,
    GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM                           = 0x8E8D,
    GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB                       = 0x8E8D,
    GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT                           = 0x8E8E,
    GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB                       = 0x8E8E,
    GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT                         = 0x8E8F,
    GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB                     = 0x8E8F,
    GL_R8_SNORM                                                   = 0x8F94,
    GL_RG8_SNORM                                                  = 0x8F95,
    GL_RGB8_SNORM                                                 = 0x8F96,
    GL_RGBA8_SNORM                                                = 0x8F97,
    GL_R16_SNORM                                                  = 0x8F98,
    GL_RG16_SNORM                                                 = 0x8F99,
    GL_RGB16_SNORM                                                = 0x8F9A,
    GL_RGBA16_SNORM                                               = 0x8F9B,
    GL_SR8_EXT                                                    = 0x8FBD,
    GL_SRG8_EXT                                                   = 0x8FBE,
    GL_RGB10_A2UI                                                 = 0x906F,
    GL_COMPRESSED_R11_EAC                                         = 0x9270,
    GL_COMPRESSED_SIGNED_R11_EAC                                  = 0x9271,
    GL_COMPRESSED_RG11_EAC                                        = 0x9272,
    GL_COMPRESSED_SIGNED_RG11_EAC                                 = 0x9273,
    GL_COMPRESSED_RGB8_ETC2                                       = 0x9274,
    GL_COMPRESSED_SRGB8_ETC2                                      = 0x9275,
    GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2                   = 0x9276,
    GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2                  = 0x9277,
    GL_COMPRESSED_RGBA8_ETC2_EAC                                  = 0x9278,
    GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC                           = 0x9279,
    GL_COMPRESSED_RGBA_ASTC_4x4_KHR                               = 0x93B0,
    GL_COMPRESSED_RGBA_ASTC_5x4_KHR                               = 0x93B1,
    GL_COMPRESSED_RGBA_ASTC_5x5_KHR                               = 0x93B2,
    GL_COMPRESSED_RGBA_ASTC_6x5_KHR                               = 0x93B3,
    GL_COMPRESSED_RGBA_ASTC_6x6_KHR                               = 0x93B4,
    GL_COMPRESSED_RGBA_ASTC_8x5_KHR                               = 0x93B5,
    GL_COMPRESSED_RGBA_ASTC_8x6_KHR                               = 0x93B6,
    GL_COMPRESSED_RGBA_ASTC_8x8_KHR                               = 0x93B7,
    GL_COMPRESSED_RGBA_ASTC_10x5_KHR                              = 0x93B8,
    GL_COMPRESSED_RGBA_ASTC_10x6_KHR                              = 0x93B9,
    GL_COMPRESSED_RGBA_ASTC_10x8_KHR                              = 0x93BA,
    GL_COMPRESSED_RGBA_ASTC_10x10_KHR                             = 0x93BB,
    GL_COMPRESSED_RGBA_ASTC_12x10_KHR                             = 0x93BC,
    GL_COMPRESSED_RGBA_ASTC_12x12_KHR                             = 0x93BD,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR                       = 0x93D0,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR                       = 0x93D1,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR                       = 0x93D2,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR                       = 0x93D3,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR                       = 0x93D4,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR                       = 0x93D5,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR                       = 0x93D6,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR                       = 0x93D7,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR                      = 0x93D8,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR                      = 0x93D9,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR                      = 0x93DA,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR                     = 0x93DB,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR                     = 0x93DC,
    GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR                     = 0x93DD,

    // InternalFormatPName

//  GL_SAMPLES                                                    = 0x80A9, // reuse GetFramebufferParameter
    GL_GENERATE_MIPMAP                                            = 0x8191,
    GL_INTERNALFORMAT_SUPPORTED                                   = 0x826F,
    GL_INTERNALFORMAT_PREFERRED                                   = 0x8270,
    GL_INTERNALFORMAT_RED_SIZE                                    = 0x8271,
    GL_INTERNALFORMAT_GREEN_SIZE                                  = 0x8272,
    GL_INTERNALFORMAT_BLUE_SIZE                                   = 0x8273,
    GL_INTERNALFORMAT_ALPHA_SIZE                                  = 0x8274,
    GL_INTERNALFORMAT_DEPTH_SIZE                                  = 0x8275,
    GL_INTERNALFORMAT_STENCIL_SIZE                                = 0x8276,
    GL_INTERNALFORMAT_SHARED_SIZE                                 = 0x8277,
    GL_INTERNALFORMAT_RED_TYPE                                    = 0x8278,
    GL_INTERNALFORMAT_GREEN_TYPE                                  = 0x8279,
    GL_INTERNALFORMAT_BLUE_TYPE                                   = 0x827A,
    GL_INTERNALFORMAT_ALPHA_TYPE                                  = 0x827B,
    GL_INTERNALFORMAT_DEPTH_TYPE                                  = 0x827C,
    GL_INTERNALFORMAT_STENCIL_TYPE                                = 0x827D,
    GL_MAX_WIDTH                                                  = 0x827E,
    GL_MAX_HEIGHT                                                 = 0x827F,
    GL_MAX_DEPTH                                                  = 0x8280,
    GL_MAX_LAYERS                                                 = 0x8281,
    GL_COLOR_COMPONENTS                                           = 0x8283,
    GL_COLOR_RENDERABLE                                           = 0x8286,
    GL_DEPTH_RENDERABLE                                           = 0x8287,
    GL_STENCIL_RENDERABLE                                         = 0x8288,
    GL_FRAMEBUFFER_RENDERABLE                                     = 0x8289,
    GL_FRAMEBUFFER_RENDERABLE_LAYERED                             = 0x828A,
    GL_FRAMEBUFFER_BLEND                                          = 0x828B,
    GL_READ_PIXELS                                                = 0x828C,
    GL_READ_PIXELS_FORMAT                                         = 0x828D,
    GL_READ_PIXELS_TYPE                                           = 0x828E,
    GL_TEXTURE_IMAGE_FORMAT                                       = 0x828F,
    GL_TEXTURE_IMAGE_TYPE                                         = 0x8290,
    GL_GET_TEXTURE_IMAGE_FORMAT                                   = 0x8291,
    GL_GET_TEXTURE_IMAGE_TYPE                                     = 0x8292,
    GL_MIPMAP                                                     = 0x8293,
    GL_AUTO_GENERATE_MIPMAP                                       = 0x8295,
    GL_COLOR_ENCODING                                             = 0x8296,
    GL_SRGB_READ                                                  = 0x8297,
    GL_SRGB_WRITE                                                 = 0x8298,
    GL_FILTER                                                     = 0x829A,
    GL_VERTEX_TEXTURE                                             = 0x829B,
    GL_TESS_CONTROL_TEXTURE                                       = 0x829C,
    GL_TESS_EVALUATION_TEXTURE                                    = 0x829D,
    GL_GEOMETRY_TEXTURE                                           = 0x829E,
    GL_FRAGMENT_TEXTURE                                           = 0x829F,
    GL_COMPUTE_TEXTURE                                            = 0x82A0,
    GL_TEXTURE_SHADOW                                             = 0x82A1,
    GL_TEXTURE_GATHER                                             = 0x82A2,
    GL_TEXTURE_GATHER_SHADOW                                      = 0x82A3,
    GL_SHADER_IMAGE_LOAD                                          = 0x82A4,
    GL_SHADER_IMAGE_STORE                                         = 0x82A5,
    GL_SHADER_IMAGE_ATOMIC                                        = 0x82A6,
    GL_IMAGE_TEXEL_SIZE                                           = 0x82A7,
    GL_IMAGE_COMPATIBILITY_CLASS                                  = 0x82A8,
    GL_IMAGE_PIXEL_FORMAT                                         = 0x82A9,
    GL_IMAGE_PIXEL_TYPE                                           = 0x82AA,
    GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST                        = 0x82AC,
    GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST                      = 0x82AD,
    GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE                       = 0x82AE,
    GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE                     = 0x82AF,
    GL_TEXTURE_COMPRESSED_BLOCK_WIDTH                             = 0x82B1,
    GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT                            = 0x82B2,
    GL_TEXTURE_COMPRESSED_BLOCK_SIZE                              = 0x82B3,
    GL_CLEAR_BUFFER                                               = 0x82B4,
    GL_TEXTURE_VIEW                                               = 0x82B5,
    GL_VIEW_COMPATIBILITY_CLASS                                   = 0x82B6,
    GL_TEXTURE_COMPRESSED                                         = 0x86A1,
    GL_IMAGE_FORMAT_COMPATIBILITY_TYPE                            = 0x90C7,
    GL_CLEAR_TEXTURE                                              = 0x9365,
    GL_NUM_SAMPLE_COUNTS                                          = 0x9380,

    // InvalidateFramebufferAttachment

//  GL_COLOR                                                      = 0x1800, // reuse Buffer
//  GL_DEPTH                                                      = 0x1801, // reuse Buffer
//  GL_STENCIL                                                    = 0x1802, // reuse Buffer
//  GL_DEPTH_STENCIL_ATTACHMENT                                   = 0x821A, // reuse FramebufferAttachment
//  GL_COLOR_ATTACHMENT0                                          = 0x8CE0, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT0_EXT                                      = 0x8CE0,
//  GL_COLOR_ATTACHMENT1                                          = 0x8CE1, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT1_EXT                                      = 0x8CE1,
//  GL_COLOR_ATTACHMENT2                                          = 0x8CE2, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT2_EXT                                      = 0x8CE2,
//  GL_COLOR_ATTACHMENT3                                          = 0x8CE3, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT3_EXT                                      = 0x8CE3,
//  GL_COLOR_ATTACHMENT4                                          = 0x8CE4, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT4_EXT                                      = 0x8CE4,
//  GL_COLOR_ATTACHMENT5                                          = 0x8CE5, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT5_EXT                                      = 0x8CE5,
//  GL_COLOR_ATTACHMENT6                                          = 0x8CE6, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT6_EXT                                      = 0x8CE6,
//  GL_COLOR_ATTACHMENT7                                          = 0x8CE7, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT7_EXT                                      = 0x8CE7,
//  GL_COLOR_ATTACHMENT8                                          = 0x8CE8, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT8_EXT                                      = 0x8CE8,
//  GL_COLOR_ATTACHMENT9                                          = 0x8CE9, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT9_EXT                                      = 0x8CE9,
//  GL_COLOR_ATTACHMENT10                                         = 0x8CEA, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT10_EXT                                     = 0x8CEA,
//  GL_COLOR_ATTACHMENT11                                         = 0x8CEB, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT11_EXT                                     = 0x8CEB,
//  GL_COLOR_ATTACHMENT12                                         = 0x8CEC, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT12_EXT                                     = 0x8CEC,
//  GL_COLOR_ATTACHMENT13                                         = 0x8CED, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT13_EXT                                     = 0x8CED,
//  GL_COLOR_ATTACHMENT14                                         = 0x8CEE, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT14_EXT                                     = 0x8CEE,
//  GL_COLOR_ATTACHMENT15                                         = 0x8CEF, // reuse ColorBuffer
    GL_COLOR_ATTACHMENT15_EXT                                     = 0x8CEF,
//  GL_COLOR_ATTACHMENT16                                         = 0x8CF0, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT17                                         = 0x8CF1, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT18                                         = 0x8CF2, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT19                                         = 0x8CF3, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT20                                         = 0x8CF4, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT21                                         = 0x8CF5, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT22                                         = 0x8CF6, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT23                                         = 0x8CF7, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT24                                         = 0x8CF8, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT25                                         = 0x8CF9, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT26                                         = 0x8CFA, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT27                                         = 0x8CFB, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT28                                         = 0x8CFC, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT29                                         = 0x8CFD, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT30                                         = 0x8CFE, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT31                                         = 0x8CFF, // reuse ColorBuffer
//  GL_DEPTH_ATTACHMENT                                           = 0x8D00, // reuse FramebufferAttachment
    GL_DEPTH_ATTACHMENT_EXT                                       = 0x8D00,
    GL_STENCIL_ATTACHMENT_EXT                                     = 0x8D20,

    // LightEnvModeSGIX

//  GL_ADD                                                        = 0x0104, // reuse AccumOp
    GL_REPLACE                                                    = 0x1E01,
    GL_MODULATE                                                   = 0x2100,

    // LightEnvParameterSGIX

//  GL_LIGHT_ENV_MODE_SGIX                                        = 0x8407, // reuse GetPName

    // LightModelColorControl

    GL_SINGLE_COLOR                                               = 0x81F9,
    GL_SINGLE_COLOR_EXT                                           = 0x81F9,
    GL_SEPARATE_SPECULAR_COLOR                                    = 0x81FA,
    GL_SEPARATE_SPECULAR_COLOR_EXT                                = 0x81FA,

    // LightModelParameter

//  GL_LIGHT_MODEL_LOCAL_VIEWER                                   = 0x0B51, // reuse GetPName
//  GL_LIGHT_MODEL_TWO_SIDE                                       = 0x0B52, // reuse GetPName
//  GL_LIGHT_MODEL_AMBIENT                                        = 0x0B53, // reuse GetPName
//  GL_LIGHT_MODEL_COLOR_CONTROL                                  = 0x81F8, // reuse GetPName
    GL_LIGHT_MODEL_COLOR_CONTROL_EXT                              = 0x81F8,

    // LightName

//  GL_LIGHT0                                                     = 0x4000, // reuse EnableCap
//  GL_LIGHT1                                                     = 0x4001, // reuse EnableCap
//  GL_LIGHT2                                                     = 0x4002, // reuse EnableCap
//  GL_LIGHT3                                                     = 0x4003, // reuse EnableCap
//  GL_LIGHT4                                                     = 0x4004, // reuse EnableCap
//  GL_LIGHT5                                                     = 0x4005, // reuse EnableCap
//  GL_LIGHT6                                                     = 0x4006, // reuse EnableCap
//  GL_LIGHT7                                                     = 0x4007, // reuse EnableCap
//  GL_FRAGMENT_LIGHT0_SGIX                                       = 0x840C, // reuse EnableCap
//  GL_FRAGMENT_LIGHT1_SGIX                                       = 0x840D, // reuse EnableCap
//  GL_FRAGMENT_LIGHT2_SGIX                                       = 0x840E, // reuse EnableCap
//  GL_FRAGMENT_LIGHT3_SGIX                                       = 0x840F, // reuse EnableCap
//  GL_FRAGMENT_LIGHT4_SGIX                                       = 0x8410, // reuse EnableCap
//  GL_FRAGMENT_LIGHT5_SGIX                                       = 0x8411, // reuse EnableCap
//  GL_FRAGMENT_LIGHT6_SGIX                                       = 0x8412, // reuse EnableCap
//  GL_FRAGMENT_LIGHT7_SGIX                                       = 0x8413, // reuse EnableCap

    // LightParameter

//  GL_AMBIENT                                                    = 0x1200, // reuse ColorMaterialParameter
//  GL_DIFFUSE                                                    = 0x1201, // reuse ColorMaterialParameter
//  GL_SPECULAR                                                   = 0x1202, // reuse ColorMaterialParameter
//  GL_POSITION                                                   = 0x1203, // reuse FragmentLightParameterSGIX
//  GL_SPOT_DIRECTION                                             = 0x1204, // reuse FragmentLightParameterSGIX
//  GL_SPOT_EXPONENT                                              = 0x1205, // reuse FragmentLightParameterSGIX
//  GL_SPOT_CUTOFF                                                = 0x1206, // reuse FragmentLightParameterSGIX
//  GL_CONSTANT_ATTENUATION                                       = 0x1207, // reuse FragmentLightParameterSGIX
//  GL_LINEAR_ATTENUATION                                         = 0x1208, // reuse FragmentLightParameterSGIX
//  GL_QUADRATIC_ATTENUATION                                      = 0x1209, // reuse FragmentLightParameterSGIX

    // LightTextureModeEXT

    GL_FRAGMENT_MATERIAL_EXT                                      = 0x8349,
    GL_FRAGMENT_NORMAL_EXT                                        = 0x834A,
    GL_FRAGMENT_COLOR_EXT                                         = 0x834C,
//  GL_FRAGMENT_DEPTH                                             = 0x8452, // reuse FogCoordSrc
//  GL_FRAGMENT_DEPTH_EXT                                         = 0x8452, // reuse FogCoordSrc

    // LightTexturePNameEXT

    GL_ATTENUATION_EXT                                            = 0x834D,
    GL_SHADOW_ATTENUATION_EXT                                     = 0x834E,

    // ListMode

    GL_COMPILE                                                    = 0x1300,
    GL_COMPILE_AND_EXECUTE                                        = 0x1301,

    // ListNameType

//  GL_BYTE                                                       = 0x1400, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
    GL_2_BYTES                                                    = 0x1407,
    GL_3_BYTES                                                    = 0x1408,
    GL_4_BYTES                                                    = 0x1409,

    // ListParameterName

    GL_LIST_PRIORITY_SGIX                                         = 0x8182,

    // LogicOp

    GL_CLEAR                                                      = 0x1500,
    GL_AND                                                        = 0x1501,
    GL_AND_REVERSE                                                = 0x1502,
    GL_COPY                                                       = 0x1503,
    GL_AND_INVERTED                                               = 0x1504,
    GL_NOOP                                                       = 0x1505,
    GL_XOR                                                        = 0x1506,
    GL_OR                                                         = 0x1507,
    GL_NOR                                                        = 0x1508,
    GL_EQUIV                                                      = 0x1509,
    GL_INVERT                                                     = 0x150A,
    GL_OR_REVERSE                                                 = 0x150B,
    GL_COPY_INVERTED                                              = 0x150C,
    GL_OR_INVERTED                                                = 0x150D,
    GL_NAND                                                       = 0x150E,
    GL_SET                                                        = 0x150F,

    // MapAttribParameterNV

    GL_MAP_ATTRIB_U_ORDER_NV                                      = 0x86C3,
    GL_MAP_ATTRIB_V_ORDER_NV                                      = 0x86C4,

    // MapParameterNV

    GL_MAP_TESSELLATION_NV                                        = 0x86C2,

    // MapQuery

//  GL_COEFF                                                      = 0x0A00, // reuse GetMapQuery
//  GL_ORDER                                                      = 0x0A01, // reuse GetMapQuery
//  GL_DOMAIN                                                     = 0x0A02, // reuse GetMapQuery

    // MapTarget

//  GL_MAP1_COLOR_4                                               = 0x0D90, // reuse EnableCap
//  GL_MAP1_INDEX                                                 = 0x0D91, // reuse EnableCap
//  GL_MAP1_NORMAL                                                = 0x0D92, // reuse EnableCap
//  GL_MAP1_TEXTURE_COORD_1                                       = 0x0D93, // reuse EnableCap
//  GL_MAP1_TEXTURE_COORD_2                                       = 0x0D94, // reuse EnableCap
//  GL_MAP1_TEXTURE_COORD_3                                       = 0x0D95, // reuse EnableCap
//  GL_MAP1_TEXTURE_COORD_4                                       = 0x0D96, // reuse EnableCap
//  GL_MAP1_VERTEX_3                                              = 0x0D97, // reuse EnableCap
//  GL_MAP1_VERTEX_4                                              = 0x0D98, // reuse EnableCap
//  GL_MAP2_COLOR_4                                               = 0x0DB0, // reuse EnableCap
//  GL_MAP2_INDEX                                                 = 0x0DB1, // reuse EnableCap
//  GL_MAP2_NORMAL                                                = 0x0DB2, // reuse EnableCap
//  GL_MAP2_TEXTURE_COORD_1                                       = 0x0DB3, // reuse EnableCap
//  GL_MAP2_TEXTURE_COORD_2                                       = 0x0DB4, // reuse EnableCap
//  GL_MAP2_TEXTURE_COORD_3                                       = 0x0DB5, // reuse EnableCap
//  GL_MAP2_TEXTURE_COORD_4                                       = 0x0DB6, // reuse EnableCap
//  GL_MAP2_VERTEX_3                                              = 0x0DB7, // reuse EnableCap
//  GL_MAP2_VERTEX_4                                              = 0x0DB8, // reuse EnableCap
//  GL_GEOMETRY_DEFORMATION_SGIX                                  = 0x8194, // reuse FfdTargetSGIX
//  GL_TEXTURE_DEFORMATION_SGIX                                   = 0x8195, // reuse FfdTargetSGIX

    // MapTextureFormatINTEL

    GL_LAYOUT_DEFAULT_INTEL                                       = 0,
    GL_LAYOUT_LINEAR_INTEL                                        = 1,
    GL_LAYOUT_LINEAR_CPU_CACHED_INTEL                             = 2,

    // MapTypeNV

//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // MaterialParameter

//  GL_AMBIENT                                                    = 0x1200, // reuse ColorMaterialParameter
//  GL_DIFFUSE                                                    = 0x1201, // reuse ColorMaterialParameter
//  GL_SPECULAR                                                   = 0x1202, // reuse ColorMaterialParameter
//  GL_EMISSION                                                   = 0x1600, // reuse ColorMaterialParameter
    GL_SHININESS                                                  = 0x1601,
//  GL_AMBIENT_AND_DIFFUSE                                        = 0x1602, // reuse ColorMaterialParameter
    GL_COLOR_INDEXES                                              = 0x1603,

    // MatrixIndexPointerTypeARB

//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType

    // MatrixMode

    GL_MODELVIEW                                                  = 0x1700,
    GL_MODELVIEW0_EXT                                             = 0x1700,
    GL_PROJECTION                                                 = 0x1701,
    GL_TEXTURE                                                    = 0x1702,

    // MemoryObjectParameterName

    GL_DEDICATED_MEMORY_OBJECT_EXT                                = 0x9581,
    GL_PROTECTED_MEMORY_OBJECT_EXT                                = 0x959B,

    // MeshMode1

    GL_POINT                                                      = 0x1B00,
    GL_LINE                                                       = 0x1B01,

    // MeshMode2

//  GL_POINT                                                      = 0x1B00, // reuse MeshMode1
//  GL_LINE                                                       = 0x1B01, // reuse MeshMode1
    GL_FILL                                                       = 0x1B02,

    // MinmaxTarget

    GL_MINMAX                                                     = 0x802E,

    // MinmaxTargetEXT

//  GL_MINMAX                                                     = 0x802E, // reuse MinmaxTarget
//  GL_MINMAX_EXT                                                 = 0x802E, // reuse EnableCap

    // NormalPointerType

//  GL_BYTE                                                       = 0x1400, // reuse BinormalPointerTypeEXT
//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // ObjectIdentifier

//  GL_TEXTURE                                                    = 0x1702, // reuse MatrixMode
//  GL_VERTEX_ARRAY                                               = 0x8074, // reuse EnableCap
    GL_BUFFER                                                     = 0x82E0,
    GL_SHADER                                                     = 0x82E1,
    GL_PROGRAM                                                    = 0x82E2,
    GL_QUERY                                                      = 0x82E3,
    GL_PROGRAM_PIPELINE                                           = 0x82E4,
    GL_SAMPLER                                                    = 0x82E6,
//  GL_FRAMEBUFFER                                                = 0x8D40, // reuse FramebufferTarget
//  GL_RENDERBUFFER                                               = 0x8D41, // reuse CopyImageSubDataTarget
//  GL_TRANSFORM_FEEDBACK                                         = 0x8E22, // reuse BindTransformFeedbackTarget

    // ObjectTypeAPPLE

    GL_DRAW_PIXELS_APPLE                                          = 0x8A0A,
    GL_FENCE_APPLE                                                = 0x8A0B,

    // OcclusionQueryParameterNameNV

    GL_PIXEL_COUNT_NV                                             = 0x8866,
    GL_PIXEL_COUNT_AVAILABLE_NV                                   = 0x8867,

    // ParameterRangeEXT

    GL_NORMALIZED_RANGE_EXT                                       = 0x87E0,
    GL_FULL_RANGE_EXT                                             = 0x87E1,

    // PatchParameterName

    GL_PATCH_VERTICES                                             = 0x8E72,
    GL_PATCH_DEFAULT_INNER_LEVEL                                  = 0x8E73,
    GL_PATCH_DEFAULT_OUTER_LEVEL                                  = 0x8E74,

    // PathColor

//  GL_PRIMARY_COLOR_NV                                           = 0x852C, // reuse CombinerRegisterNV
//  GL_SECONDARY_COLOR_NV                                         = 0x852D, // reuse CombinerRegisterNV
//  GL_PRIMARY_COLOR                                              = 0x8577, // reuse FragmentShaderGenericSourceATI

    // PathColorFormat

//  GL_NONE                                                       = 0, // reuse ColorBuffer
//  GL_ALPHA                                                      = 0x1906, // reuse CombinerComponentUsageNV
//  GL_RGB                                                        = 0x1907, // reuse CombinerComponentUsageNV
//  GL_RGBA                                                       = 0x1908, // reuse InternalFormat
    GL_LUMINANCE                                                  = 0x1909,
    GL_LUMINANCE_ALPHA                                            = 0x190A,
//  GL_INTENSITY                                                  = 0x8049, // reuse InternalFormat

    // PathCoordType

    GL_CLOSE_PATH_NV                                              = 0x00,
    GL_MOVE_TO_NV                                                 = 0x02,
    GL_RELATIVE_MOVE_TO_NV                                        = 0x03,
    GL_LINE_TO_NV                                                 = 0x04,
    GL_RELATIVE_LINE_TO_NV                                        = 0x05,
    GL_HORIZONTAL_LINE_TO_NV                                      = 0x06,
    GL_RELATIVE_HORIZONTAL_LINE_TO_NV                             = 0x07,
    GL_VERTICAL_LINE_TO_NV                                        = 0x08,
    GL_RELATIVE_VERTICAL_LINE_TO_NV                               = 0x09,
    GL_QUADRATIC_CURVE_TO_NV                                      = 0x0A,
    GL_RELATIVE_QUADRATIC_CURVE_TO_NV                             = 0x0B,
    GL_CUBIC_CURVE_TO_NV                                          = 0x0C,
    GL_RELATIVE_CUBIC_CURVE_TO_NV                                 = 0x0D,
    GL_SMOOTH_QUADRATIC_CURVE_TO_NV                               = 0x0E,
    GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV                      = 0x0F,
    GL_SMOOTH_CUBIC_CURVE_TO_NV                                   = 0x10,
    GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV                          = 0x11,
    GL_SMALL_CCW_ARC_TO_NV                                        = 0x12,
    GL_RELATIVE_SMALL_CCW_ARC_TO_NV                               = 0x13,
    GL_SMALL_CW_ARC_TO_NV                                         = 0x14,
    GL_RELATIVE_SMALL_CW_ARC_TO_NV                                = 0x15,
    GL_LARGE_CCW_ARC_TO_NV                                        = 0x16,
    GL_RELATIVE_LARGE_CCW_ARC_TO_NV                               = 0x17,
    GL_LARGE_CW_ARC_TO_NV                                         = 0x18,
    GL_RELATIVE_LARGE_CW_ARC_TO_NV                                = 0x19,
    GL_CONIC_CURVE_TO_NV                                          = 0x1A,
    GL_RELATIVE_CONIC_CURVE_TO_NV                                 = 0x1B,
    GL_ROUNDED_RECT_NV                                            = 0xE8,
    GL_RELATIVE_ROUNDED_RECT_NV                                   = 0xE9,
    GL_ROUNDED_RECT2_NV                                           = 0xEA,
    GL_RELATIVE_ROUNDED_RECT2_NV                                  = 0xEB,
    GL_ROUNDED_RECT4_NV                                           = 0xEC,
    GL_RELATIVE_ROUNDED_RECT4_NV                                  = 0xED,
    GL_ROUNDED_RECT8_NV                                           = 0xEE,
    GL_RELATIVE_ROUNDED_RECT8_NV                                  = 0xEF,
    GL_RESTART_PATH_NV                                            = 0xF0,
    GL_DUP_FIRST_CUBIC_CURVE_TO_NV                                = 0xF2,
    GL_DUP_LAST_CUBIC_CURVE_TO_NV                                 = 0xF4,
    GL_RECT_NV                                                    = 0xF6,
    GL_RELATIVE_RECT_NV                                           = 0xF7,
    GL_CIRCULAR_CCW_ARC_TO_NV                                     = 0xF8,
    GL_CIRCULAR_CW_ARC_TO_NV                                      = 0xFA,
    GL_CIRCULAR_TANGENT_ARC_TO_NV                                 = 0xFC,
    GL_ARC_TO_NV                                                  = 0xFE,
    GL_RELATIVE_ARC_TO_NV                                         = 0xFF,

    // PathCoverMode

//  GL_PATH_FILL_COVER_MODE_NV                                    = 0x9082, // reuse InstancedPathCoverMode
//  GL_CONVEX_HULL_NV                                             = 0x908B, // reuse InstancedPathCoverMode
//  GL_BOUNDING_BOX_NV                                            = 0x908D, // reuse InstancedPathCoverMode

    // PathElementType

    GL_UTF8_NV                                                    = 0x909A,
    GL_UTF16_NV                                                   = 0x909B,

    // PathFillMode

//  GL_INVERT                                                     = 0x150A, // reuse LogicOp
    GL_PATH_FILL_MODE_NV                                          = 0x9080,
    GL_COUNT_UP_NV                                                = 0x9088,
    GL_COUNT_DOWN_NV                                              = 0x9089,

    // PathFontTarget

    GL_STANDARD_FONT_NAME_NV                                      = 0x9072,
    GL_SYSTEM_FONT_NAME_NV                                        = 0x9073,
    GL_FILE_NAME_NV                                               = 0x9074,

    // PathGenMode

//  GL_NONE                                                       = 0, // reuse ColorBuffer
    GL_EYE_LINEAR                                                 = 0x2400,
    GL_OBJECT_LINEAR                                              = 0x2401,
    GL_CONSTANT                                                   = 0x8576,
    GL_PATH_OBJECT_BOUNDING_BOX_NV                                = 0x908A,

    // PathHandleMissingGlyphs

    GL_SKIP_MISSING_GLYPH_NV                                      = 0x90A9,
    GL_USE_MISSING_GLYPH_NV                                       = 0x90AA,

    // PathListMode

    GL_ACCUM_ADJACENT_PAIRS_NV                                    = 0x90AD,
    GL_ADJACENT_PAIRS_NV                                          = 0x90AE,
    GL_FIRST_TO_REST_NV                                           = 0x90AF,

    // PathParameter

    GL_PATH_STROKE_WIDTH_NV                                       = 0x9075,
    GL_PATH_END_CAPS_NV                                           = 0x9076,
    GL_PATH_INITIAL_END_CAP_NV                                    = 0x9077,
    GL_PATH_TERMINAL_END_CAP_NV                                   = 0x9078,
    GL_PATH_JOIN_STYLE_NV                                         = 0x9079,
    GL_PATH_MITER_LIMIT_NV                                        = 0x907A,
    GL_PATH_DASH_CAPS_NV                                          = 0x907B,
    GL_PATH_INITIAL_DASH_CAP_NV                                   = 0x907C,
    GL_PATH_TERMINAL_DASH_CAP_NV                                  = 0x907D,
    GL_PATH_DASH_OFFSET_NV                                        = 0x907E,
    GL_PATH_CLIENT_LENGTH_NV                                      = 0x907F,
//  GL_PATH_FILL_MODE_NV                                          = 0x9080, // reuse PathFillMode
    GL_PATH_FILL_MASK_NV                                          = 0x9081,
//  GL_PATH_FILL_COVER_MODE_NV                                    = 0x9082, // reuse InstancedPathCoverMode
    GL_PATH_STROKE_COVER_MODE_NV                                  = 0x9083,
    GL_PATH_STROKE_MASK_NV                                        = 0x9084,
//  GL_PATH_OBJECT_BOUNDING_BOX_NV                                = 0x908A, // reuse PathGenMode
    GL_PATH_COMMAND_COUNT_NV                                      = 0x909D,
    GL_PATH_COORD_COUNT_NV                                        = 0x909E,
    GL_PATH_DASH_ARRAY_COUNT_NV                                   = 0x909F,
    GL_PATH_COMPUTED_LENGTH_NV                                    = 0x90A0,
    GL_PATH_FILL_BOUNDING_BOX_NV                                  = 0x90A1,
    GL_PATH_STROKE_BOUNDING_BOX_NV                                = 0x90A2,
    GL_PATH_DASH_OFFSET_RESET_NV                                  = 0x90B4,

    // PathRenderingTokenNV

//  GL_CLOSE_PATH_NV                                              = 0x00, // reuse PathCoordType
//  GL_MOVE_TO_NV                                                 = 0x02, // reuse PathCoordType
//  GL_RELATIVE_MOVE_TO_NV                                        = 0x03, // reuse PathCoordType
//  GL_LINE_TO_NV                                                 = 0x04, // reuse PathCoordType
//  GL_RELATIVE_LINE_TO_NV                                        = 0x05, // reuse PathCoordType
//  GL_HORIZONTAL_LINE_TO_NV                                      = 0x06, // reuse PathCoordType
//  GL_RELATIVE_HORIZONTAL_LINE_TO_NV                             = 0x07, // reuse PathCoordType
//  GL_VERTICAL_LINE_TO_NV                                        = 0x08, // reuse PathCoordType
//  GL_RELATIVE_VERTICAL_LINE_TO_NV                               = 0x09, // reuse PathCoordType
//  GL_QUADRATIC_CURVE_TO_NV                                      = 0x0A, // reuse PathCoordType
//  GL_RELATIVE_QUADRATIC_CURVE_TO_NV                             = 0x0B, // reuse PathCoordType
//  GL_CUBIC_CURVE_TO_NV                                          = 0x0C, // reuse PathCoordType
//  GL_RELATIVE_CUBIC_CURVE_TO_NV                                 = 0x0D, // reuse PathCoordType
//  GL_SMOOTH_QUADRATIC_CURVE_TO_NV                               = 0x0E, // reuse PathCoordType
//  GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV                      = 0x0F, // reuse PathCoordType
//  GL_SMOOTH_CUBIC_CURVE_TO_NV                                   = 0x10, // reuse PathCoordType
//  GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV                          = 0x11, // reuse PathCoordType
//  GL_SMALL_CCW_ARC_TO_NV                                        = 0x12, // reuse PathCoordType
//  GL_RELATIVE_SMALL_CCW_ARC_TO_NV                               = 0x13, // reuse PathCoordType
//  GL_SMALL_CW_ARC_TO_NV                                         = 0x14, // reuse PathCoordType
//  GL_RELATIVE_SMALL_CW_ARC_TO_NV                                = 0x15, // reuse PathCoordType
//  GL_LARGE_CCW_ARC_TO_NV                                        = 0x16, // reuse PathCoordType
//  GL_RELATIVE_LARGE_CCW_ARC_TO_NV                               = 0x17, // reuse PathCoordType
//  GL_LARGE_CW_ARC_TO_NV                                         = 0x18, // reuse PathCoordType
//  GL_RELATIVE_LARGE_CW_ARC_TO_NV                                = 0x19, // reuse PathCoordType
//  GL_CONIC_CURVE_TO_NV                                          = 0x1A, // reuse PathCoordType
//  GL_RELATIVE_CONIC_CURVE_TO_NV                                 = 0x1B, // reuse PathCoordType
    GL_SHARED_EDGE_NV                                             = 0xC0,
//  GL_ROUNDED_RECT_NV                                            = 0xE8, // reuse PathCoordType
//  GL_RELATIVE_ROUNDED_RECT_NV                                   = 0xE9, // reuse PathCoordType
//  GL_ROUNDED_RECT2_NV                                           = 0xEA, // reuse PathCoordType
//  GL_RELATIVE_ROUNDED_RECT2_NV                                  = 0xEB, // reuse PathCoordType
//  GL_ROUNDED_RECT4_NV                                           = 0xEC, // reuse PathCoordType
//  GL_RELATIVE_ROUNDED_RECT4_NV                                  = 0xED, // reuse PathCoordType
//  GL_ROUNDED_RECT8_NV                                           = 0xEE, // reuse PathCoordType
//  GL_RELATIVE_ROUNDED_RECT8_NV                                  = 0xEF, // reuse PathCoordType
//  GL_RESTART_PATH_NV                                            = 0xF0, // reuse PathCoordType
//  GL_DUP_FIRST_CUBIC_CURVE_TO_NV                                = 0xF2, // reuse PathCoordType
//  GL_DUP_LAST_CUBIC_CURVE_TO_NV                                 = 0xF4, // reuse PathCoordType
//  GL_RECT_NV                                                    = 0xF6, // reuse PathCoordType
//  GL_RELATIVE_RECT_NV                                           = 0xF7, // reuse PathCoordType
//  GL_CIRCULAR_CCW_ARC_TO_NV                                     = 0xF8, // reuse PathCoordType
//  GL_CIRCULAR_CW_ARC_TO_NV                                      = 0xFA, // reuse PathCoordType
//  GL_CIRCULAR_TANGENT_ARC_TO_NV                                 = 0xFC, // reuse PathCoordType
//  GL_ARC_TO_NV                                                  = 0xFE, // reuse PathCoordType
//  GL_RELATIVE_ARC_TO_NV                                         = 0xFF, // reuse PathCoordType

    // PathStringFormat

    GL_PATH_FORMAT_SVG_NV                                         = 0x9070,
    GL_PATH_FORMAT_PS_NV                                          = 0x9071,

    // PathTransformType

//  GL_NONE                                                       = 0, // reuse ColorBuffer
    GL_TRANSLATE_X_NV                                             = 0x908E,
    GL_TRANSLATE_Y_NV                                             = 0x908F,
    GL_TRANSLATE_2D_NV                                            = 0x9090,
    GL_TRANSLATE_3D_NV                                            = 0x9091,
    GL_AFFINE_2D_NV                                               = 0x9092,
    GL_AFFINE_3D_NV                                               = 0x9094,
    GL_TRANSPOSE_AFFINE_2D_NV                                     = 0x9096,
    GL_TRANSPOSE_AFFINE_3D_NV                                     = 0x9098,

    // PerfQueryDataFlags

    GL_PERFQUERY_DONOT_FLUSH_INTEL                                = 0x83F9,
    GL_PERFQUERY_FLUSH_INTEL                                      = 0x83FA,
    GL_PERFQUERY_WAIT_INTEL                                       = 0x83FB,

    // PipelineParameterName

    GL_ACTIVE_PROGRAM                                             = 0x8259,
    GL_FRAGMENT_SHADER                                            = 0x8B30,
    GL_VERTEX_SHADER                                              = 0x8B31,
    GL_INFO_LOG_LENGTH                                            = 0x8B84,
    GL_GEOMETRY_SHADER                                            = 0x8DD9,
    GL_TESS_EVALUATION_SHADER                                     = 0x8E87,
    GL_TESS_CONTROL_SHADER                                        = 0x8E88,

    // PixelCopyType

//  GL_COLOR                                                      = 0x1800, // reuse Buffer
//  GL_DEPTH                                                      = 0x1801, // reuse Buffer
//  GL_STENCIL                                                    = 0x1802, // reuse Buffer

    // PixelDataRangeTargetNV

    GL_WRITE_PIXEL_DATA_RANGE_NV                                  = 0x8878,
    GL_READ_PIXEL_DATA_RANGE_NV                                   = 0x8879,

    // PixelFormat

//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType
    GL_COLOR_INDEX                                                = 0x1900,
//  GL_STENCIL_INDEX                                              = 0x1901, // reuse DepthStencilTextureMode
//  GL_DEPTH_COMPONENT                                            = 0x1902, // reuse DepthStencilTextureMode
//  GL_RED                                                        = 0x1903, // reuse FragmentShaderValueRepATI
//  GL_GREEN                                                      = 0x1904, // reuse FragmentShaderValueRepATI
//  GL_BLUE                                                       = 0x1905, // reuse CombinerComponentUsageNV
//  GL_ALPHA                                                      = 0x1906, // reuse CombinerComponentUsageNV
//  GL_RGB                                                        = 0x1907, // reuse CombinerComponentUsageNV
//  GL_RGBA                                                       = 0x1908, // reuse InternalFormat
//  GL_LUMINANCE                                                  = 0x1909, // reuse PathColorFormat
//  GL_LUMINANCE_ALPHA                                            = 0x190A, // reuse PathColorFormat
    GL_ABGR_EXT                                                   = 0x8000,
    GL_CMYK_EXT                                                   = 0x800C,
    GL_CMYKA_EXT                                                  = 0x800D,
    GL_BGR                                                        = 0x80E0,
    GL_BGR_EXT                                                    = 0x80E0,
    GL_BGRA                                                       = 0x80E1,
    GL_BGRA_EXT                                                   = 0x80E1,
    GL_YCRCB_422_SGIX                                             = 0x81BB,
    GL_YCRCB_444_SGIX                                             = 0x81BC,
//  GL_RG                                                         = 0x8227, // reuse InternalFormat
    GL_RG_INTEGER                                                 = 0x8228,
//  GL_DEPTH_STENCIL                                              = 0x84F9, // reuse InternalFormat
    GL_RED_INTEGER                                                = 0x8D94,
    GL_GREEN_INTEGER                                              = 0x8D95,
    GL_BLUE_INTEGER                                               = 0x8D96,
    GL_RGB_INTEGER                                                = 0x8D98,
    GL_RGBA_INTEGER                                               = 0x8D99,
    GL_BGR_INTEGER                                                = 0x8D9A,
    GL_BGRA_INTEGER                                               = 0x8D9B,

    // PixelMap

    GL_PIXEL_MAP_I_TO_I                                           = 0x0C70,
    GL_PIXEL_MAP_S_TO_S                                           = 0x0C71,
    GL_PIXEL_MAP_I_TO_R                                           = 0x0C72,
    GL_PIXEL_MAP_I_TO_G                                           = 0x0C73,
    GL_PIXEL_MAP_I_TO_B                                           = 0x0C74,
    GL_PIXEL_MAP_I_TO_A                                           = 0x0C75,
    GL_PIXEL_MAP_R_TO_R                                           = 0x0C76,
    GL_PIXEL_MAP_G_TO_G                                           = 0x0C77,
    GL_PIXEL_MAP_B_TO_B                                           = 0x0C78,
    GL_PIXEL_MAP_A_TO_A                                           = 0x0C79,

    // PixelStoreParameter

//  GL_UNPACK_SWAP_BYTES                                          = 0x0CF0, // reuse GetPName
//  GL_UNPACK_LSB_FIRST                                           = 0x0CF1, // reuse GetPName
//  GL_UNPACK_ROW_LENGTH                                          = 0x0CF2, // reuse GetPName
//  GL_UNPACK_SKIP_ROWS                                           = 0x0CF3, // reuse GetPName
//  GL_UNPACK_SKIP_PIXELS                                         = 0x0CF4, // reuse GetPName
//  GL_UNPACK_ALIGNMENT                                           = 0x0CF5, // reuse GetPName
//  GL_PACK_SWAP_BYTES                                            = 0x0D00, // reuse GetPName
//  GL_PACK_LSB_FIRST                                             = 0x0D01, // reuse GetPName
//  GL_PACK_ROW_LENGTH                                            = 0x0D02, // reuse GetPName
//  GL_PACK_SKIP_ROWS                                             = 0x0D03, // reuse GetPName
//  GL_PACK_SKIP_PIXELS                                           = 0x0D04, // reuse GetPName
//  GL_PACK_ALIGNMENT                                             = 0x0D05, // reuse GetPName
//  GL_PACK_SKIP_IMAGES                                           = 0x806B, // reuse GetPName
//  GL_PACK_SKIP_IMAGES_EXT                                       = 0x806B, // reuse GetPName
//  GL_PACK_IMAGE_HEIGHT                                          = 0x806C, // reuse GetPName
//  GL_PACK_IMAGE_HEIGHT_EXT                                      = 0x806C, // reuse GetPName
//  GL_UNPACK_SKIP_IMAGES                                         = 0x806D, // reuse GetPName
//  GL_UNPACK_SKIP_IMAGES_EXT                                     = 0x806D, // reuse GetPName
//  GL_UNPACK_IMAGE_HEIGHT                                        = 0x806E, // reuse GetPName
//  GL_UNPACK_IMAGE_HEIGHT_EXT                                    = 0x806E, // reuse GetPName
//  GL_PACK_SKIP_VOLUMES_SGIS                                     = 0x8130, // reuse GetPName
//  GL_PACK_IMAGE_DEPTH_SGIS                                      = 0x8131, // reuse GetPName
//  GL_UNPACK_SKIP_VOLUMES_SGIS                                   = 0x8132, // reuse GetPName
//  GL_UNPACK_IMAGE_DEPTH_SGIS                                    = 0x8133, // reuse GetPName
//  GL_PIXEL_TILE_WIDTH_SGIX                                      = 0x8140, // reuse GetPName
//  GL_PIXEL_TILE_HEIGHT_SGIX                                     = 0x8141, // reuse GetPName
//  GL_PIXEL_TILE_GRID_WIDTH_SGIX                                 = 0x8142, // reuse GetPName
//  GL_PIXEL_TILE_GRID_HEIGHT_SGIX                                = 0x8143, // reuse GetPName
//  GL_PIXEL_TILE_GRID_DEPTH_SGIX                                 = 0x8144, // reuse GetPName
//  GL_PIXEL_TILE_CACHE_SIZE_SGIX                                 = 0x8145, // reuse GetPName
//  GL_PACK_RESAMPLE_SGIX                                         = 0x842E, // reuse GetPName
//  GL_UNPACK_RESAMPLE_SGIX                                       = 0x842F, // reuse GetPName
//  GL_PACK_SUBSAMPLE_RATE_SGIX                                   = 0x85A0, // reuse GetPName
//  GL_UNPACK_SUBSAMPLE_RATE_SGIX                                 = 0x85A1, // reuse GetPName
    GL_PACK_RESAMPLE_OML                                          = 0x8984,
    GL_UNPACK_RESAMPLE_OML                                        = 0x8985,

    // PixelStoreResampleMode

    GL_RESAMPLE_DECIMATE_SGIX                                     = 0x8430,
    GL_RESAMPLE_REPLICATE_SGIX                                    = 0x8433,
    GL_RESAMPLE_ZERO_FILL_SGIX                                    = 0x8434,

    // PixelStoreSubsampleRate

    GL_PIXEL_SUBSAMPLE_4444_SGIX                                  = 0x85A2,
    GL_PIXEL_SUBSAMPLE_2424_SGIX                                  = 0x85A3,
    GL_PIXEL_SUBSAMPLE_4242_SGIX                                  = 0x85A4,

    // PixelTexGenModeSGIX

//  GL_NONE                                                       = 0, // reuse ColorBuffer
//  GL_ALPHA                                                      = 0x1906, // reuse CombinerComponentUsageNV
//  GL_RGB                                                        = 0x1907, // reuse CombinerComponentUsageNV
//  GL_RGBA                                                       = 0x1908, // reuse InternalFormat

    // PixelTexGenParameterNameSGIS

    GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS                             = 0x8354,
    GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS                           = 0x8355,

    // PixelTransferParameter

//  GL_MAP_COLOR                                                  = 0x0D10, // reuse GetPName
//  GL_MAP_STENCIL                                                = 0x0D11, // reuse GetPName
//  GL_INDEX_SHIFT                                                = 0x0D12, // reuse GetPName
//  GL_INDEX_OFFSET                                               = 0x0D13, // reuse GetPName
//  GL_RED_SCALE                                                  = 0x0D14, // reuse GetPName
//  GL_RED_BIAS                                                   = 0x0D15, // reuse GetPName
//  GL_GREEN_SCALE                                                = 0x0D18, // reuse GetPName
//  GL_GREEN_BIAS                                                 = 0x0D19, // reuse GetPName
//  GL_BLUE_SCALE                                                 = 0x0D1A, // reuse GetPName
//  GL_BLUE_BIAS                                                  = 0x0D1B, // reuse GetPName
//  GL_ALPHA_SCALE                                                = 0x0D1C, // reuse GetPName
//  GL_ALPHA_BIAS                                                 = 0x0D1D, // reuse GetPName
//  GL_DEPTH_SCALE                                                = 0x0D1E, // reuse GetPName
//  GL_DEPTH_BIAS                                                 = 0x0D1F, // reuse GetPName
    GL_POST_CONVOLUTION_RED_SCALE                                 = 0x801C,
//  GL_POST_CONVOLUTION_RED_SCALE_EXT                             = 0x801C, // reuse GetPName
    GL_POST_CONVOLUTION_GREEN_SCALE                               = 0x801D,
//  GL_POST_CONVOLUTION_GREEN_SCALE_EXT                           = 0x801D, // reuse GetPName
    GL_POST_CONVOLUTION_BLUE_SCALE                                = 0x801E,
//  GL_POST_CONVOLUTION_BLUE_SCALE_EXT                            = 0x801E, // reuse GetPName
    GL_POST_CONVOLUTION_ALPHA_SCALE                               = 0x801F,
//  GL_POST_CONVOLUTION_ALPHA_SCALE_EXT                           = 0x801F, // reuse GetPName
    GL_POST_CONVOLUTION_RED_BIAS                                  = 0x8020,
//  GL_POST_CONVOLUTION_RED_BIAS_EXT                              = 0x8020, // reuse GetPName
    GL_POST_CONVOLUTION_GREEN_BIAS                                = 0x8021,
//  GL_POST_CONVOLUTION_GREEN_BIAS_EXT                            = 0x8021, // reuse GetPName
    GL_POST_CONVOLUTION_BLUE_BIAS                                 = 0x8022,
//  GL_POST_CONVOLUTION_BLUE_BIAS_EXT                             = 0x8022, // reuse GetPName
    GL_POST_CONVOLUTION_ALPHA_BIAS                                = 0x8023,
//  GL_POST_CONVOLUTION_ALPHA_BIAS_EXT                            = 0x8023, // reuse GetPName
    GL_POST_COLOR_MATRIX_RED_SCALE                                = 0x80B4,
//  GL_POST_COLOR_MATRIX_RED_SCALE_SGI                            = 0x80B4, // reuse GetPName
    GL_POST_COLOR_MATRIX_GREEN_SCALE                              = 0x80B5,
//  GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI                          = 0x80B5, // reuse GetPName
    GL_POST_COLOR_MATRIX_BLUE_SCALE                               = 0x80B6,
//  GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI                           = 0x80B6, // reuse GetPName
    GL_POST_COLOR_MATRIX_ALPHA_SCALE                              = 0x80B7,
//  GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI                          = 0x80B7, // reuse GetPName
    GL_POST_COLOR_MATRIX_RED_BIAS                                 = 0x80B8,
//  GL_POST_COLOR_MATRIX_RED_BIAS_SGI                             = 0x80B8, // reuse GetPName
    GL_POST_COLOR_MATRIX_GREEN_BIAS                               = 0x80B9,
//  GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI                           = 0x80B9, // reuse GetPName
    GL_POST_COLOR_MATRIX_BLUE_BIAS                                = 0x80BA,
//  GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI                            = 0x80BA, // reuse GetPName
    GL_POST_COLOR_MATRIX_ALPHA_BIAS                               = 0x80BB,
//  GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI                           = 0x80BB, // reuse GetPName

    // PixelTransformPNameEXT

    GL_PIXEL_MAG_FILTER_EXT                                       = 0x8331,
    GL_PIXEL_MIN_FILTER_EXT                                       = 0x8332,
    GL_PIXEL_CUBIC_WEIGHT_EXT                                     = 0x8333,

    // PixelTransformTargetEXT

    GL_PIXEL_TRANSFORM_2D_EXT                                     = 0x8330,

    // PixelType

//  GL_BYTE                                                       = 0x1400, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
    GL_HALF_FLOAT                                                 = 0x140B,
    GL_HALF_FLOAT_ARB                                             = 0x140B,
    GL_HALF_FLOAT_NV                                              = 0x140B,
    GL_HALF_APPLE                                                 = 0x140B,
    GL_BITMAP                                                     = 0x1A00,
    GL_UNSIGNED_BYTE_3_3_2                                        = 0x8032,
    GL_UNSIGNED_BYTE_3_3_2_EXT                                    = 0x8032,
    GL_UNSIGNED_SHORT_4_4_4_4                                     = 0x8033,
    GL_UNSIGNED_SHORT_4_4_4_4_EXT                                 = 0x8033,
    GL_UNSIGNED_SHORT_5_5_5_1                                     = 0x8034,
    GL_UNSIGNED_SHORT_5_5_5_1_EXT                                 = 0x8034,
    GL_UNSIGNED_INT_8_8_8_8                                       = 0x8035,
    GL_UNSIGNED_INT_8_8_8_8_EXT                                   = 0x8035,
    GL_UNSIGNED_INT_10_10_10_2                                    = 0x8036,
    GL_UNSIGNED_INT_10_10_10_2_EXT                                = 0x8036,
    GL_UNSIGNED_BYTE_2_3_3_REV                                    = 0x8362,
    GL_UNSIGNED_SHORT_5_6_5                                       = 0x8363,
    GL_UNSIGNED_SHORT_5_6_5_REV                                   = 0x8364,
    GL_UNSIGNED_SHORT_4_4_4_4_REV                                 = 0x8365,
    GL_UNSIGNED_SHORT_1_5_5_5_REV                                 = 0x8366,
    GL_UNSIGNED_INT_8_8_8_8_REV                                   = 0x8367,
    GL_UNSIGNED_INT_2_10_10_10_REV                                = 0x8368,
    GL_UNSIGNED_INT_24_8                                          = 0x84FA,
    GL_UNSIGNED_INT_24_8_EXT                                      = 0x84FA,
    GL_UNSIGNED_INT_24_8_NV                                       = 0x84FA,
    GL_UNSIGNED_INT_10F_11F_11F_REV                               = 0x8C3B,
    GL_UNSIGNED_INT_10F_11F_11F_REV_EXT                           = 0x8C3B,
    GL_UNSIGNED_INT_5_9_9_9_REV                                   = 0x8C3E,
    GL_UNSIGNED_INT_5_9_9_9_REV_EXT                               = 0x8C3E,
    GL_FLOAT_32_UNSIGNED_INT_24_8_REV                             = 0x8DAD,
    GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV                          = 0x8DAD,

    // PNTrianglesPNameATI

    GL_PN_TRIANGLES_POINT_MODE_ATI                                = 0x87F2,
    GL_PN_TRIANGLES_NORMAL_MODE_ATI                               = 0x87F3,
    GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI                         = 0x87F4,

    // PointParameterNameARB

//  GL_POINT_SIZE_MIN                                             = 0x8126, // reuse GetPName
//  GL_POINT_SIZE_MIN_ARB                                         = 0x8126, // reuse GetPName
//  GL_POINT_SIZE_MIN_EXT                                         = 0x8126, // reuse GetPName
//  GL_POINT_SIZE_MIN_SGIS                                        = 0x8126, // reuse GetPName
//  GL_POINT_SIZE_MAX                                             = 0x8127, // reuse GetPName
//  GL_POINT_SIZE_MAX_ARB                                         = 0x8127, // reuse GetPName
//  GL_POINT_SIZE_MAX_EXT                                         = 0x8127, // reuse GetPName
//  GL_POINT_SIZE_MAX_SGIS                                        = 0x8127, // reuse GetPName
//  GL_POINT_FADE_THRESHOLD_SIZE                                  = 0x8128, // reuse GetPName
//  GL_POINT_FADE_THRESHOLD_SIZE_ARB                              = 0x8128, // reuse GetPName
//  GL_POINT_FADE_THRESHOLD_SIZE_EXT                              = 0x8128, // reuse GetPName
//  GL_POINT_FADE_THRESHOLD_SIZE_SGIS                             = 0x8128, // reuse GetPName
//  GL_DISTANCE_ATTENUATION_EXT                                   = 0x8129, // reuse GetPName
//  GL_DISTANCE_ATTENUATION_SGIS                                  = 0x8129, // reuse GetPName
//  GL_POINT_DISTANCE_ATTENUATION                                 = 0x8129, // reuse GetPName
//  GL_POINT_DISTANCE_ATTENUATION_ARB                             = 0x8129, // reuse GetPName

    // PolygonMode

//  GL_POINT                                                      = 0x1B00, // reuse MeshMode1
//  GL_LINE                                                       = 0x1B01, // reuse MeshMode1
//  GL_FILL                                                       = 0x1B02, // reuse MeshMode2

    // PrecisionType

    GL_LOW_FLOAT                                                  = 0x8DF0,
    GL_MEDIUM_FLOAT                                               = 0x8DF1,
    GL_HIGH_FLOAT                                                 = 0x8DF2,
    GL_LOW_INT                                                    = 0x8DF3,
    GL_MEDIUM_INT                                                 = 0x8DF4,
    GL_HIGH_INT                                                   = 0x8DF5,

    // PreserveModeATI

    GL_PRESERVE_ATI                                               = 0x8762,
    GL_DISCARD_ATI                                                = 0x8763,

    // PrimitiveType

    GL_POINTS                                                     = 0x0000,
    GL_LINES                                                      = 0x0001,
    GL_LINE_LOOP                                                  = 0x0002,
    GL_LINE_STRIP                                                 = 0x0003,
    GL_TRIANGLES                                                  = 0x0004,
    GL_TRIANGLE_STRIP                                             = 0x0005,
    GL_TRIANGLE_FAN                                               = 0x0006,
    GL_QUADS                                                      = 0x0007,
    GL_QUAD_STRIP                                                 = 0x0008,
    GL_POLYGON                                                    = 0x0009,
    GL_LINES_ADJACENCY                                            = 0x000A,
    GL_LINES_ADJACENCY_ARB                                        = 0x000A,
    GL_LINES_ADJACENCY_EXT                                        = 0x000A,
    GL_LINE_STRIP_ADJACENCY                                       = 0x000B,
    GL_LINE_STRIP_ADJACENCY_ARB                                   = 0x000B,
    GL_LINE_STRIP_ADJACENCY_EXT                                   = 0x000B,
    GL_TRIANGLES_ADJACENCY                                        = 0x000C,
    GL_TRIANGLES_ADJACENCY_ARB                                    = 0x000C,
    GL_TRIANGLES_ADJACENCY_EXT                                    = 0x000C,
    GL_TRIANGLE_STRIP_ADJACENCY                                   = 0x000D,
    GL_TRIANGLE_STRIP_ADJACENCY_ARB                               = 0x000D,
    GL_TRIANGLE_STRIP_ADJACENCY_EXT                               = 0x000D,
    GL_PATCHES                                                    = 0x000E,

    // ProgramFormat

    GL_PROGRAM_FORMAT_ASCII_ARB                                   = 0x8875,

    // ProgramInterface

//  GL_TRANSFORM_FEEDBACK_BUFFER                                  = 0x8C8E, // reuse BufferStorageTarget
    GL_UNIFORM                                                    = 0x92E1,
    GL_UNIFORM_BLOCK                                              = 0x92E2,
    GL_PROGRAM_INPUT                                              = 0x92E3,
    GL_PROGRAM_OUTPUT                                             = 0x92E4,
    GL_BUFFER_VARIABLE                                            = 0x92E5,
    GL_SHADER_STORAGE_BLOCK                                       = 0x92E6,
    GL_VERTEX_SUBROUTINE                                          = 0x92E8,
    GL_TESS_CONTROL_SUBROUTINE                                    = 0x92E9,
    GL_TESS_EVALUATION_SUBROUTINE                                 = 0x92EA,
    GL_GEOMETRY_SUBROUTINE                                        = 0x92EB,
    GL_FRAGMENT_SUBROUTINE                                        = 0x92EC,
    GL_COMPUTE_SUBROUTINE                                         = 0x92ED,
    GL_VERTEX_SUBROUTINE_UNIFORM                                  = 0x92EE,
    GL_TESS_CONTROL_SUBROUTINE_UNIFORM                            = 0x92EF,
    GL_TESS_EVALUATION_SUBROUTINE_UNIFORM                         = 0x92F0,
    GL_GEOMETRY_SUBROUTINE_UNIFORM                                = 0x92F1,
    GL_FRAGMENT_SUBROUTINE_UNIFORM                                = 0x92F2,
    GL_COMPUTE_SUBROUTINE_UNIFORM                                 = 0x92F3,
    GL_TRANSFORM_FEEDBACK_VARYING                                 = 0x92F4,

    // ProgramInterfacePName

    GL_ACTIVE_RESOURCES                                           = 0x92F5,
    GL_MAX_NAME_LENGTH                                            = 0x92F6,
    GL_MAX_NUM_ACTIVE_VARIABLES                                   = 0x92F7,
    GL_MAX_NUM_COMPATIBLE_SUBROUTINES                             = 0x92F8,

    // ProgramParameterPName

//  GL_PROGRAM_BINARY_RETRIEVABLE_HINT                            = 0x8257, // reuse HintTarget
    GL_PROGRAM_SEPARABLE                                          = 0x8258,

    // ProgramPropertyARB

    GL_COMPUTE_WORK_GROUP_SIZE                                    = 0x8267,
    GL_PROGRAM_BINARY_LENGTH                                      = 0x8741,
    GL_GEOMETRY_VERTICES_OUT                                      = 0x8916,
    GL_GEOMETRY_INPUT_TYPE                                        = 0x8917,
    GL_GEOMETRY_OUTPUT_TYPE                                       = 0x8918,
    GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH                       = 0x8A35,
    GL_ACTIVE_UNIFORM_BLOCKS                                      = 0x8A36,
    GL_DELETE_STATUS                                              = 0x8B80,
    GL_LINK_STATUS                                                = 0x8B82,
    GL_VALIDATE_STATUS                                            = 0x8B83,
//  GL_INFO_LOG_LENGTH                                            = 0x8B84, // reuse PipelineParameterName
    GL_ATTACHED_SHADERS                                           = 0x8B85,
    GL_ACTIVE_UNIFORMS                                            = 0x8B86,
    GL_ACTIVE_UNIFORM_MAX_LENGTH                                  = 0x8B87,
    GL_ACTIVE_ATTRIBUTES                                          = 0x8B89,
    GL_ACTIVE_ATTRIBUTE_MAX_LENGTH                                = 0x8B8A,
    GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH                      = 0x8C76,
    GL_TRANSFORM_FEEDBACK_BUFFER_MODE                             = 0x8C7F,
    GL_TRANSFORM_FEEDBACK_VARYINGS                                = 0x8C83,
    GL_ACTIVE_ATOMIC_COUNTER_BUFFERS                              = 0x92D9,

    // ProgramResourceProperty

    GL_NUM_COMPATIBLE_SUBROUTINES                                 = 0x8E4A,
    GL_COMPATIBLE_SUBROUTINES                                     = 0x8E4B,
//  GL_UNIFORM                                                    = 0x92E1, // reuse ProgramInterface
    GL_IS_PER_PATCH                                               = 0x92E7,
    GL_NAME_LENGTH                                                = 0x92F9,
    GL_TYPE                                                       = 0x92FA,
    GL_ARRAY_SIZE                                                 = 0x92FB,
    GL_OFFSET                                                     = 0x92FC,
    GL_BLOCK_INDEX                                                = 0x92FD,
    GL_ARRAY_STRIDE                                               = 0x92FE,
    GL_MATRIX_STRIDE                                              = 0x92FF,
    GL_IS_ROW_MAJOR                                               = 0x9300,
    GL_ATOMIC_COUNTER_BUFFER_INDEX                                = 0x9301,
    GL_BUFFER_BINDING                                             = 0x9302,
    GL_BUFFER_DATA_SIZE                                           = 0x9303,
    GL_NUM_ACTIVE_VARIABLES                                       = 0x9304,
    GL_ACTIVE_VARIABLES                                           = 0x9305,
    GL_REFERENCED_BY_VERTEX_SHADER                                = 0x9306,
    GL_REFERENCED_BY_TESS_CONTROL_SHADER                          = 0x9307,
    GL_REFERENCED_BY_TESS_EVALUATION_SHADER                       = 0x9308,
    GL_REFERENCED_BY_GEOMETRY_SHADER                              = 0x9309,
    GL_REFERENCED_BY_FRAGMENT_SHADER                              = 0x930A,
    GL_REFERENCED_BY_COMPUTE_SHADER                               = 0x930B,
    GL_TOP_LEVEL_ARRAY_SIZE                                       = 0x930C,
    GL_TOP_LEVEL_ARRAY_STRIDE                                     = 0x930D,
    GL_LOCATION                                                   = 0x930E,
    GL_LOCATION_INDEX                                             = 0x930F,
    GL_LOCATION_COMPONENT                                         = 0x934A,
    GL_TRANSFORM_FEEDBACK_BUFFER_INDEX                            = 0x934B,
    GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE                           = 0x934C,

    // ProgramStagePName

    GL_ACTIVE_SUBROUTINES                                         = 0x8DE5,
    GL_ACTIVE_SUBROUTINE_UNIFORMS                                 = 0x8DE6,
    GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS                        = 0x8E47,
    GL_ACTIVE_SUBROUTINE_MAX_LENGTH                               = 0x8E48,
    GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH                       = 0x8E49,

    // ProgramStringProperty

    GL_PROGRAM_STRING_ARB                                         = 0x8628,

    // ProgramTarget

    GL_TEXT_FRAGMENT_SHADER_ATI                                   = 0x8200,
    GL_VERTEX_PROGRAM_ARB                                         = 0x8620,
    GL_FRAGMENT_PROGRAM_ARB                                       = 0x8804,
    GL_TESS_CONTROL_PROGRAM_NV                                    = 0x891E,
    GL_TESS_EVALUATION_PROGRAM_NV                                 = 0x891F,
    GL_GEOMETRY_PROGRAM_NV                                        = 0x8C26,
    GL_COMPUTE_PROGRAM_NV                                         = 0x90FB,

    // QueryCounterTarget

//  GL_TIMESTAMP                                                  = 0x8E28, // reuse GetPName

    // QueryObjectParameterName

    GL_QUERY_TARGET                                               = 0x82EA,
    GL_QUERY_RESULT                                               = 0x8866,
    GL_QUERY_RESULT_AVAILABLE                                     = 0x8867,
    GL_QUERY_RESULT_NO_WAIT                                       = 0x9194,

    // QueryParameterName

    GL_QUERY_COUNTER_BITS                                         = 0x8864,
    GL_CURRENT_QUERY                                              = 0x8865,

    // QueryTarget

    GL_TRANSFORM_FEEDBACK_OVERFLOW                                = 0x82EC,
    GL_VERTICES_SUBMITTED                                         = 0x82EE,
    GL_PRIMITIVES_SUBMITTED                                       = 0x82EF,
    GL_VERTEX_SHADER_INVOCATIONS                                  = 0x82F0,
    GL_TIME_ELAPSED                                               = 0x88BF,
    GL_SAMPLES_PASSED                                             = 0x8914,
    GL_ANY_SAMPLES_PASSED                                         = 0x8C2F,
    GL_PRIMITIVES_GENERATED                                       = 0x8C87,
    GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN                      = 0x8C88,
    GL_ANY_SAMPLES_PASSED_CONSERVATIVE                            = 0x8D6A,

    // ReadBufferMode

//  GL_NONE                                                       = 0, // reuse ColorBuffer
//  GL_FRONT_LEFT                                                 = 0x0400, // reuse ColorBuffer
//  GL_FRONT_RIGHT                                                = 0x0401, // reuse ColorBuffer
//  GL_BACK_LEFT                                                  = 0x0402, // reuse ColorBuffer
//  GL_BACK_RIGHT                                                 = 0x0403, // reuse ColorBuffer
//  GL_FRONT                                                      = 0x0404, // reuse ColorBuffer
//  GL_BACK                                                       = 0x0405, // reuse ColorBuffer
//  GL_LEFT                                                       = 0x0406, // reuse ColorBuffer
//  GL_RIGHT                                                      = 0x0407, // reuse ColorBuffer
//  GL_AUX0                                                       = 0x0409, // reuse DrawBufferMode
//  GL_AUX1                                                       = 0x040A, // reuse DrawBufferMode
//  GL_AUX2                                                       = 0x040B, // reuse DrawBufferMode
//  GL_AUX3                                                       = 0x040C, // reuse DrawBufferMode
//  GL_COLOR_ATTACHMENT0                                          = 0x8CE0, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT1                                          = 0x8CE1, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT2                                          = 0x8CE2, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT3                                          = 0x8CE3, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT4                                          = 0x8CE4, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT5                                          = 0x8CE5, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT6                                          = 0x8CE6, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT7                                          = 0x8CE7, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT8                                          = 0x8CE8, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT9                                          = 0x8CE9, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT10                                         = 0x8CEA, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT11                                         = 0x8CEB, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT12                                         = 0x8CEC, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT13                                         = 0x8CED, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT14                                         = 0x8CEE, // reuse ColorBuffer
//  GL_COLOR_ATTACHMENT15                                         = 0x8CEF, // reuse ColorBuffer

    // RenderbufferParameterName

    GL_RENDERBUFFER_COVERAGE_SAMPLES_NV                           = 0x8CAB,
    GL_RENDERBUFFER_SAMPLES                                       = 0x8CAB,
    GL_RENDERBUFFER_SAMPLES_EXT                                   = 0x8CAB,
    GL_RENDERBUFFER_WIDTH                                         = 0x8D42,
    GL_RENDERBUFFER_WIDTH_EXT                                     = 0x8D42,
    GL_RENDERBUFFER_HEIGHT                                        = 0x8D43,
    GL_RENDERBUFFER_HEIGHT_EXT                                    = 0x8D43,
    GL_RENDERBUFFER_INTERNAL_FORMAT                               = 0x8D44,
    GL_RENDERBUFFER_INTERNAL_FORMAT_EXT                           = 0x8D44,
    GL_RENDERBUFFER_RED_SIZE                                      = 0x8D50,
    GL_RENDERBUFFER_RED_SIZE_EXT                                  = 0x8D50,
    GL_RENDERBUFFER_GREEN_SIZE                                    = 0x8D51,
    GL_RENDERBUFFER_GREEN_SIZE_EXT                                = 0x8D51,
    GL_RENDERBUFFER_BLUE_SIZE                                     = 0x8D52,
    GL_RENDERBUFFER_BLUE_SIZE_EXT                                 = 0x8D52,
    GL_RENDERBUFFER_ALPHA_SIZE                                    = 0x8D53,
    GL_RENDERBUFFER_ALPHA_SIZE_EXT                                = 0x8D53,
    GL_RENDERBUFFER_DEPTH_SIZE                                    = 0x8D54,
    GL_RENDERBUFFER_DEPTH_SIZE_EXT                                = 0x8D54,
    GL_RENDERBUFFER_STENCIL_SIZE                                  = 0x8D55,
    GL_RENDERBUFFER_STENCIL_SIZE_EXT                              = 0x8D55,
    GL_RENDERBUFFER_COLOR_SAMPLES_NV                              = 0x8E10,
    GL_RENDERBUFFER_STORAGE_SAMPLES_AMD                           = 0x91B2,

    // RenderbufferTarget

//  GL_RENDERBUFFER                                               = 0x8D41, // reuse CopyImageSubDataTarget

    // RenderingMode

    GL_RENDER                                                     = 0x1C00,
    GL_FEEDBACK                                                   = 0x1C01,
    GL_SELECT                                                     = 0x1C02,

    // ReplacementCodeTypeSUN

//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType

    // SamplePatternEXT

    GL_1PASS_EXT                                                  = 0x80A1,
    GL_2PASS_0_EXT                                                = 0x80A2,
    GL_2PASS_1_EXT                                                = 0x80A3,
    GL_4PASS_0_EXT                                                = 0x80A4,
    GL_4PASS_1_EXT                                                = 0x80A5,
    GL_4PASS_2_EXT                                                = 0x80A6,
    GL_4PASS_3_EXT                                                = 0x80A7,

    // SamplePatternSGIS

//  GL_1PASS_EXT                                                  = 0x80A1, // reuse SamplePatternEXT
    GL_1PASS_SGIS                                                 = 0x80A1,
//  GL_2PASS_0_EXT                                                = 0x80A2, // reuse SamplePatternEXT
    GL_2PASS_0_SGIS                                               = 0x80A2,
//  GL_2PASS_1_EXT                                                = 0x80A3, // reuse SamplePatternEXT
    GL_2PASS_1_SGIS                                               = 0x80A3,
//  GL_4PASS_0_EXT                                                = 0x80A4, // reuse SamplePatternEXT
    GL_4PASS_0_SGIS                                               = 0x80A4,
//  GL_4PASS_1_EXT                                                = 0x80A5, // reuse SamplePatternEXT
    GL_4PASS_1_SGIS                                               = 0x80A5,
//  GL_4PASS_2_EXT                                                = 0x80A6, // reuse SamplePatternEXT
    GL_4PASS_2_SGIS                                               = 0x80A6,
//  GL_4PASS_3_EXT                                                = 0x80A7, // reuse SamplePatternEXT
    GL_4PASS_3_SGIS                                               = 0x80A7,

    // SamplerParameterF

//  GL_TEXTURE_BORDER_COLOR                                       = 0x1004, // reuse GetTextureParameter
    GL_TEXTURE_MIN_LOD                                            = 0x813A,
    GL_TEXTURE_MAX_LOD                                            = 0x813B,
    GL_TEXTURE_MAX_ANISOTROPY                                     = 0x84FE,
    GL_TEXTURE_LOD_BIAS                                           = 0x8501,

    // SamplerParameterI

//  GL_TEXTURE_MAG_FILTER                                         = 0x2800, // reuse GetTextureParameter
//  GL_TEXTURE_MIN_FILTER                                         = 0x2801, // reuse GetTextureParameter
//  GL_TEXTURE_WRAP_S                                             = 0x2802, // reuse GetTextureParameter
//  GL_TEXTURE_WRAP_T                                             = 0x2803, // reuse GetTextureParameter
    GL_TEXTURE_WRAP_R                                             = 0x8072,
    GL_TEXTURE_COMPARE_MODE                                       = 0x884C,
    GL_TEXTURE_COMPARE_FUNC                                       = 0x884D,

    // ScalarType

//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType

    // SecondaryColorPointerTypeIBM

//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // SemaphoreParameterName

    GL_D3D12_FENCE_VALUE_EXT                                      = 0x9595,
    GL_TIMELINE_SEMAPHORE_VALUE_NV                                = 0x9595,
    GL_SEMAPHORE_TYPE_NV                                          = 0x95B3,
    GL_SEMAPHORE_TYPE_BINARY_NV                                   = 0x95B4,
    GL_SEMAPHORE_TYPE_TIMELINE_NV                                 = 0x95B5,

    // SeparableTarget

    GL_SEPARABLE_2D                                               = 0x8012,

    // SeparableTargetEXT

//  GL_SEPARABLE_2D                                               = 0x8012, // reuse SeparableTarget
//  GL_SEPARABLE_2D_EXT                                           = 0x8012, // reuse EnableCap

    // ShaderBinaryFormat

    GL_SHADER_BINARY_FORMAT_SPIR_V                                = 0x9551,

    // ShaderParameterName

    GL_SHADER_TYPE                                                = 0x8B4F,
//  GL_DELETE_STATUS                                              = 0x8B80, // reuse ProgramPropertyARB
    GL_COMPILE_STATUS                                             = 0x8B81,
//  GL_INFO_LOG_LENGTH                                            = 0x8B84, // reuse PipelineParameterName
    GL_SHADER_SOURCE_LENGTH                                       = 0x8B88,

    // ShaderType

//  GL_FRAGMENT_SHADER                                            = 0x8B30, // reuse PipelineParameterName
    GL_FRAGMENT_SHADER_ARB                                        = 0x8B30,
//  GL_VERTEX_SHADER                                              = 0x8B31, // reuse PipelineParameterName
    GL_VERTEX_SHADER_ARB                                          = 0x8B31,
//  GL_GEOMETRY_SHADER                                            = 0x8DD9, // reuse PipelineParameterName
//  GL_TESS_EVALUATION_SHADER                                     = 0x8E87, // reuse PipelineParameterName
//  GL_TESS_CONTROL_SHADER                                        = 0x8E88, // reuse PipelineParameterName
    GL_COMPUTE_SHADER                                             = 0x91B9,

    // ShadingModel

    GL_FLAT                                                       = 0x1D00,
    GL_SMOOTH                                                     = 0x1D01,

    // SizedInternalFormat

//  GL_R3_G3_B2                                                   = 0x2A10, // reuse InternalFormat
//  GL_ALPHA4                                                     = 0x803B, // reuse InternalFormat
//  GL_ALPHA4_EXT                                                 = 0x803B, // reuse InternalFormat
//  GL_ALPHA8                                                     = 0x803C, // reuse InternalFormat
//  GL_ALPHA8_EXT                                                 = 0x803C, // reuse InternalFormat
//  GL_ALPHA12                                                    = 0x803D, // reuse InternalFormat
//  GL_ALPHA12_EXT                                                = 0x803D, // reuse InternalFormat
//  GL_ALPHA16                                                    = 0x803E, // reuse InternalFormat
//  GL_ALPHA16_EXT                                                = 0x803E, // reuse InternalFormat
//  GL_LUMINANCE4                                                 = 0x803F, // reuse InternalFormat
//  GL_LUMINANCE4_EXT                                             = 0x803F, // reuse InternalFormat
//  GL_LUMINANCE8                                                 = 0x8040, // reuse InternalFormat
//  GL_LUMINANCE8_EXT                                             = 0x8040, // reuse InternalFormat
//  GL_LUMINANCE12                                                = 0x8041, // reuse InternalFormat
//  GL_LUMINANCE12_EXT                                            = 0x8041, // reuse InternalFormat
//  GL_LUMINANCE16                                                = 0x8042, // reuse InternalFormat
//  GL_LUMINANCE16_EXT                                            = 0x8042, // reuse InternalFormat
//  GL_LUMINANCE4_ALPHA4                                          = 0x8043, // reuse InternalFormat
//  GL_LUMINANCE4_ALPHA4_EXT                                      = 0x8043, // reuse InternalFormat
//  GL_LUMINANCE6_ALPHA2                                          = 0x8044, // reuse InternalFormat
//  GL_LUMINANCE6_ALPHA2_EXT                                      = 0x8044, // reuse InternalFormat
//  GL_LUMINANCE8_ALPHA8                                          = 0x8045, // reuse InternalFormat
//  GL_LUMINANCE8_ALPHA8_EXT                                      = 0x8045, // reuse InternalFormat
//  GL_LUMINANCE12_ALPHA4                                         = 0x8046, // reuse InternalFormat
//  GL_LUMINANCE12_ALPHA4_EXT                                     = 0x8046, // reuse InternalFormat
//  GL_LUMINANCE12_ALPHA12                                        = 0x8047, // reuse InternalFormat
//  GL_LUMINANCE12_ALPHA12_EXT                                    = 0x8047, // reuse InternalFormat
//  GL_LUMINANCE16_ALPHA16                                        = 0x8048, // reuse InternalFormat
//  GL_LUMINANCE16_ALPHA16_EXT                                    = 0x8048, // reuse InternalFormat
//  GL_INTENSITY4                                                 = 0x804A, // reuse InternalFormat
//  GL_INTENSITY4_EXT                                             = 0x804A, // reuse InternalFormat
//  GL_INTENSITY8                                                 = 0x804B, // reuse InternalFormat
//  GL_INTENSITY8_EXT                                             = 0x804B, // reuse InternalFormat
//  GL_INTENSITY12                                                = 0x804C, // reuse InternalFormat
//  GL_INTENSITY12_EXT                                            = 0x804C, // reuse InternalFormat
//  GL_INTENSITY16                                                = 0x804D, // reuse InternalFormat
//  GL_INTENSITY16_EXT                                            = 0x804D, // reuse InternalFormat
//  GL_RGB2_EXT                                                   = 0x804E, // reuse InternalFormat
//  GL_RGB4                                                       = 0x804F, // reuse InternalFormat
//  GL_RGB4_EXT                                                   = 0x804F, // reuse InternalFormat
//  GL_RGB5                                                       = 0x8050, // reuse InternalFormat
//  GL_RGB5_EXT                                                   = 0x8050, // reuse InternalFormat
//  GL_RGB8                                                       = 0x8051, // reuse InternalFormat
//  GL_RGB8_EXT                                                   = 0x8051, // reuse InternalFormat
//  GL_RGB10                                                      = 0x8052, // reuse InternalFormat
//  GL_RGB10_EXT                                                  = 0x8052, // reuse InternalFormat
//  GL_RGB12                                                      = 0x8053, // reuse InternalFormat
//  GL_RGB12_EXT                                                  = 0x8053, // reuse InternalFormat
//  GL_RGB16                                                      = 0x8054, // reuse InternalFormat
//  GL_RGB16_EXT                                                  = 0x8054, // reuse InternalFormat
//  GL_RGBA2                                                      = 0x8055, // reuse InternalFormat
//  GL_RGBA2_EXT                                                  = 0x8055, // reuse InternalFormat
//  GL_RGBA4                                                      = 0x8056, // reuse InternalFormat
//  GL_RGBA4_EXT                                                  = 0x8056, // reuse InternalFormat
//  GL_RGB5_A1                                                    = 0x8057, // reuse InternalFormat
//  GL_RGB5_A1_EXT                                                = 0x8057, // reuse InternalFormat
//  GL_RGBA8                                                      = 0x8058, // reuse InternalFormat
//  GL_RGBA8_EXT                                                  = 0x8058, // reuse InternalFormat
//  GL_RGB10_A2                                                   = 0x8059, // reuse InternalFormat
//  GL_RGB10_A2_EXT                                               = 0x8059, // reuse InternalFormat
//  GL_RGBA12                                                     = 0x805A, // reuse InternalFormat
//  GL_RGBA12_EXT                                                 = 0x805A, // reuse InternalFormat
//  GL_RGBA16                                                     = 0x805B, // reuse InternalFormat
//  GL_RGBA16_EXT                                                 = 0x805B, // reuse InternalFormat
//  GL_DEPTH_COMPONENT16                                          = 0x81A5, // reuse InternalFormat
//  GL_DEPTH_COMPONENT16_ARB                                      = 0x81A5, // reuse InternalFormat
//  GL_DEPTH_COMPONENT16_SGIX                                     = 0x81A5, // reuse InternalFormat
//  GL_DEPTH_COMPONENT24                                          = 0x81A6, // reuse InternalFormat
//  GL_DEPTH_COMPONENT24_ARB                                      = 0x81A6, // reuse InternalFormat
//  GL_DEPTH_COMPONENT24_SGIX                                     = 0x81A6, // reuse InternalFormat
//  GL_DEPTH_COMPONENT32                                          = 0x81A7, // reuse InternalFormat
//  GL_DEPTH_COMPONENT32_ARB                                      = 0x81A7, // reuse InternalFormat
//  GL_DEPTH_COMPONENT32_SGIX                                     = 0x81A7, // reuse InternalFormat
//  GL_R8                                                         = 0x8229, // reuse InternalFormat
//  GL_R8_EXT                                                     = 0x8229, // reuse InternalFormat
//  GL_R16                                                        = 0x822A, // reuse InternalFormat
//  GL_RG8                                                        = 0x822B, // reuse InternalFormat
//  GL_RG8_EXT                                                    = 0x822B, // reuse InternalFormat
//  GL_RG16                                                       = 0x822C, // reuse InternalFormat
//  GL_R16F                                                       = 0x822D, // reuse InternalFormat
//  GL_R16F_EXT                                                   = 0x822D, // reuse InternalFormat
//  GL_R32F                                                       = 0x822E, // reuse InternalFormat
//  GL_R32F_EXT                                                   = 0x822E, // reuse InternalFormat
//  GL_RG16F                                                      = 0x822F, // reuse InternalFormat
//  GL_RG16F_EXT                                                  = 0x822F, // reuse InternalFormat
//  GL_RG32F                                                      = 0x8230, // reuse InternalFormat
//  GL_RG32F_EXT                                                  = 0x8230, // reuse InternalFormat
//  GL_R8I                                                        = 0x8231, // reuse InternalFormat
//  GL_R8UI                                                       = 0x8232, // reuse InternalFormat
//  GL_R16I                                                       = 0x8233, // reuse InternalFormat
//  GL_R16UI                                                      = 0x8234, // reuse InternalFormat
//  GL_R32I                                                       = 0x8235, // reuse InternalFormat
//  GL_R32UI                                                      = 0x8236, // reuse InternalFormat
//  GL_RG8I                                                       = 0x8237, // reuse InternalFormat
//  GL_RG8UI                                                      = 0x8238, // reuse InternalFormat
//  GL_RG16I                                                      = 0x8239, // reuse InternalFormat
//  GL_RG16UI                                                     = 0x823A, // reuse InternalFormat
//  GL_RG32I                                                      = 0x823B, // reuse InternalFormat
//  GL_RG32UI                                                     = 0x823C, // reuse InternalFormat
//  GL_COMPRESSED_RGB_S3TC_DXT1_EXT                               = 0x83F0, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_S3TC_DXT1_EXT                              = 0x83F1, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_S3TC_DXT3_EXT                              = 0x83F2, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_S3TC_DXT5_EXT                              = 0x83F3, // reuse InternalFormat
//  GL_RGBA32F                                                    = 0x8814, // reuse InternalFormat
//  GL_RGBA32F_ARB                                                = 0x8814, // reuse InternalFormat
//  GL_RGBA32F_EXT                                                = 0x8814, // reuse InternalFormat
//  GL_RGB32F                                                     = 0x8815, // reuse InternalFormat
//  GL_RGB32F_ARB                                                 = 0x8815, // reuse InternalFormat
//  GL_RGB32F_EXT                                                 = 0x8815, // reuse InternalFormat
//  GL_RGBA16F                                                    = 0x881A, // reuse InternalFormat
//  GL_RGBA16F_ARB                                                = 0x881A, // reuse InternalFormat
//  GL_RGBA16F_EXT                                                = 0x881A, // reuse InternalFormat
//  GL_RGB16F                                                     = 0x881B, // reuse InternalFormat
//  GL_RGB16F_ARB                                                 = 0x881B, // reuse InternalFormat
//  GL_RGB16F_EXT                                                 = 0x881B, // reuse InternalFormat
//  GL_DEPTH24_STENCIL8                                           = 0x88F0, // reuse InternalFormat
//  GL_DEPTH24_STENCIL8_EXT                                       = 0x88F0, // reuse InternalFormat
//  GL_R11F_G11F_B10F                                             = 0x8C3A, // reuse InternalFormat
//  GL_R11F_G11F_B10F_EXT                                         = 0x8C3A, // reuse InternalFormat
//  GL_RGB9_E5                                                    = 0x8C3D, // reuse InternalFormat
//  GL_RGB9_E5_EXT                                                = 0x8C3D, // reuse InternalFormat
//  GL_SRGB8                                                      = 0x8C41, // reuse InternalFormat
//  GL_SRGB8_EXT                                                  = 0x8C41, // reuse InternalFormat
//  GL_SRGB8_ALPHA8                                               = 0x8C43, // reuse InternalFormat
//  GL_SRGB8_ALPHA8_EXT                                           = 0x8C43, // reuse InternalFormat
//  GL_COMPRESSED_SRGB_S3TC_DXT1_EXT                              = 0x8C4C, // reuse InternalFormat
//  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT                        = 0x8C4D, // reuse InternalFormat
//  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT                        = 0x8C4E, // reuse InternalFormat
//  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT                        = 0x8C4F, // reuse InternalFormat
//  GL_DEPTH_COMPONENT32F                                         = 0x8CAC, // reuse InternalFormat
//  GL_DEPTH32F_STENCIL8                                          = 0x8CAD, // reuse InternalFormat
//  GL_STENCIL_INDEX1                                             = 0x8D46, // reuse InternalFormat
//  GL_STENCIL_INDEX1_EXT                                         = 0x8D46, // reuse InternalFormat
//  GL_STENCIL_INDEX4                                             = 0x8D47, // reuse InternalFormat
//  GL_STENCIL_INDEX4_EXT                                         = 0x8D47, // reuse InternalFormat
//  GL_STENCIL_INDEX8                                             = 0x8D48, // reuse InternalFormat
//  GL_STENCIL_INDEX8_EXT                                         = 0x8D48, // reuse InternalFormat
//  GL_STENCIL_INDEX16                                            = 0x8D49, // reuse InternalFormat
//  GL_STENCIL_INDEX16_EXT                                        = 0x8D49, // reuse InternalFormat
//  GL_RGB565                                                     = 0x8D62, // reuse InternalFormat
//  GL_RGBA32UI                                                   = 0x8D70, // reuse InternalFormat
//  GL_RGBA32UI_EXT                                               = 0x8D70, // reuse InternalFormat
//  GL_RGB32UI                                                    = 0x8D71, // reuse InternalFormat
//  GL_RGB32UI_EXT                                                = 0x8D71, // reuse InternalFormat
//  GL_ALPHA32UI_EXT                                              = 0x8D72, // reuse InternalFormat
//  GL_INTENSITY32UI_EXT                                          = 0x8D73, // reuse InternalFormat
//  GL_LUMINANCE32UI_EXT                                          = 0x8D74, // reuse InternalFormat
//  GL_LUMINANCE_ALPHA32UI_EXT                                    = 0x8D75, // reuse InternalFormat
//  GL_RGBA16UI                                                   = 0x8D76, // reuse InternalFormat
//  GL_RGBA16UI_EXT                                               = 0x8D76, // reuse InternalFormat
//  GL_RGB16UI                                                    = 0x8D77, // reuse InternalFormat
//  GL_RGB16UI_EXT                                                = 0x8D77, // reuse InternalFormat
//  GL_ALPHA16UI_EXT                                              = 0x8D78, // reuse InternalFormat
//  GL_INTENSITY16UI_EXT                                          = 0x8D79, // reuse InternalFormat
//  GL_LUMINANCE16UI_EXT                                          = 0x8D7A, // reuse InternalFormat
//  GL_LUMINANCE_ALPHA16UI_EXT                                    = 0x8D7B, // reuse InternalFormat
//  GL_RGBA8UI                                                    = 0x8D7C, // reuse InternalFormat
//  GL_RGBA8UI_EXT                                                = 0x8D7C, // reuse InternalFormat
//  GL_RGB8UI                                                     = 0x8D7D, // reuse InternalFormat
//  GL_RGB8UI_EXT                                                 = 0x8D7D, // reuse InternalFormat
//  GL_ALPHA8UI_EXT                                               = 0x8D7E, // reuse InternalFormat
//  GL_INTENSITY8UI_EXT                                           = 0x8D7F, // reuse InternalFormat
//  GL_LUMINANCE8UI_EXT                                           = 0x8D80, // reuse InternalFormat
//  GL_LUMINANCE_ALPHA8UI_EXT                                     = 0x8D81, // reuse InternalFormat
//  GL_RGBA32I                                                    = 0x8D82, // reuse InternalFormat
//  GL_RGBA32I_EXT                                                = 0x8D82, // reuse InternalFormat
//  GL_RGB32I                                                     = 0x8D83, // reuse InternalFormat
//  GL_RGB32I_EXT                                                 = 0x8D83, // reuse InternalFormat
//  GL_ALPHA32I_EXT                                               = 0x8D84, // reuse InternalFormat
//  GL_INTENSITY32I_EXT                                           = 0x8D85, // reuse InternalFormat
//  GL_LUMINANCE32I_EXT                                           = 0x8D86, // reuse InternalFormat
//  GL_LUMINANCE_ALPHA32I_EXT                                     = 0x8D87, // reuse InternalFormat
//  GL_RGBA16I                                                    = 0x8D88, // reuse InternalFormat
//  GL_RGBA16I_EXT                                                = 0x8D88, // reuse InternalFormat
//  GL_RGB16I                                                     = 0x8D89, // reuse InternalFormat
//  GL_RGB16I_EXT                                                 = 0x8D89, // reuse InternalFormat
//  GL_ALPHA16I_EXT                                               = 0x8D8A, // reuse InternalFormat
//  GL_INTENSITY16I_EXT                                           = 0x8D8B, // reuse InternalFormat
//  GL_LUMINANCE16I_EXT                                           = 0x8D8C, // reuse InternalFormat
//  GL_LUMINANCE_ALPHA16I_EXT                                     = 0x8D8D, // reuse InternalFormat
//  GL_RGBA8I                                                     = 0x8D8E, // reuse InternalFormat
//  GL_RGBA8I_EXT                                                 = 0x8D8E, // reuse InternalFormat
//  GL_RGB8I                                                      = 0x8D8F, // reuse InternalFormat
//  GL_RGB8I_EXT                                                  = 0x8D8F, // reuse InternalFormat
//  GL_ALPHA8I_EXT                                                = 0x8D90, // reuse InternalFormat
//  GL_INTENSITY8I_EXT                                            = 0x8D91, // reuse InternalFormat
//  GL_LUMINANCE8I_EXT                                            = 0x8D92, // reuse InternalFormat
//  GL_LUMINANCE_ALPHA8I_EXT                                      = 0x8D93, // reuse InternalFormat
//  GL_DEPTH_COMPONENT32F_NV                                      = 0x8DAB, // reuse InternalFormat
//  GL_DEPTH32F_STENCIL8_NV                                       = 0x8DAC, // reuse InternalFormat
//  GL_COMPRESSED_RED_RGTC1                                       = 0x8DBB, // reuse InternalFormat
//  GL_COMPRESSED_RED_RGTC1_EXT                                   = 0x8DBB, // reuse InternalFormat
//  GL_COMPRESSED_SIGNED_RED_RGTC1                                = 0x8DBC, // reuse InternalFormat
//  GL_COMPRESSED_SIGNED_RED_RGTC1_EXT                            = 0x8DBC, // reuse InternalFormat
//  GL_COMPRESSED_RED_GREEN_RGTC2_EXT                             = 0x8DBD, // reuse InternalFormat
//  GL_COMPRESSED_RG_RGTC2                                        = 0x8DBD, // reuse InternalFormat
//  GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT                      = 0x8DBE, // reuse InternalFormat
//  GL_COMPRESSED_SIGNED_RG_RGTC2                                 = 0x8DBE, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_BPTC_UNORM                                 = 0x8E8C, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_BPTC_UNORM_ARB                             = 0x8E8C, // reuse InternalFormat
//  GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM                           = 0x8E8D, // reuse InternalFormat
//  GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB                       = 0x8E8D, // reuse InternalFormat
//  GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT                           = 0x8E8E, // reuse InternalFormat
//  GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB                       = 0x8E8E, // reuse InternalFormat
//  GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT                         = 0x8E8F, // reuse InternalFormat
//  GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB                     = 0x8E8F, // reuse InternalFormat
//  GL_R8_SNORM                                                   = 0x8F94, // reuse InternalFormat
//  GL_RG8_SNORM                                                  = 0x8F95, // reuse InternalFormat
//  GL_RGB8_SNORM                                                 = 0x8F96, // reuse InternalFormat
//  GL_RGBA8_SNORM                                                = 0x8F97, // reuse InternalFormat
//  GL_R16_SNORM                                                  = 0x8F98, // reuse InternalFormat
//  GL_RG16_SNORM                                                 = 0x8F99, // reuse InternalFormat
//  GL_RGB16_SNORM                                                = 0x8F9A, // reuse InternalFormat
//  GL_RGBA16_SNORM                                               = 0x8F9B, // reuse InternalFormat
//  GL_RGB10_A2UI                                                 = 0x906F, // reuse InternalFormat
//  GL_COMPRESSED_R11_EAC                                         = 0x9270, // reuse InternalFormat
//  GL_COMPRESSED_SIGNED_R11_EAC                                  = 0x9271, // reuse InternalFormat
//  GL_COMPRESSED_RG11_EAC                                        = 0x9272, // reuse InternalFormat
//  GL_COMPRESSED_SIGNED_RG11_EAC                                 = 0x9273, // reuse InternalFormat
//  GL_COMPRESSED_RGB8_ETC2                                       = 0x9274, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ETC2                                      = 0x9275, // reuse InternalFormat
//  GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2                   = 0x9276, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2                  = 0x9277, // reuse InternalFormat
//  GL_COMPRESSED_RGBA8_ETC2_EAC                                  = 0x9278, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC                           = 0x9279, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_4x4_KHR                               = 0x93B0, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_5x4_KHR                               = 0x93B1, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_5x5_KHR                               = 0x93B2, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_6x5_KHR                               = 0x93B3, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_6x6_KHR                               = 0x93B4, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_8x5_KHR                               = 0x93B5, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_8x6_KHR                               = 0x93B6, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_8x8_KHR                               = 0x93B7, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_10x5_KHR                              = 0x93B8, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_10x6_KHR                              = 0x93B9, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_10x8_KHR                              = 0x93BA, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_10x10_KHR                             = 0x93BB, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_12x10_KHR                             = 0x93BC, // reuse InternalFormat
//  GL_COMPRESSED_RGBA_ASTC_12x12_KHR                             = 0x93BD, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR                       = 0x93D0, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR                       = 0x93D1, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR                       = 0x93D2, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR                       = 0x93D3, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR                       = 0x93D4, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR                       = 0x93D5, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR                       = 0x93D6, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR                       = 0x93D7, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR                      = 0x93D8, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR                      = 0x93D9, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR                      = 0x93DA, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR                     = 0x93DB, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR                     = 0x93DC, // reuse InternalFormat
//  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR                     = 0x93DD, // reuse InternalFormat

    // SpriteModeSGIX

    GL_SPRITE_AXIAL_SGIX                                          = 0x814C,
    GL_SPRITE_OBJECT_ALIGNED_SGIX                                 = 0x814D,
    GL_SPRITE_EYE_ALIGNED_SGIX                                    = 0x814E,

    // SpriteParameterNameSGIX

//  GL_SPRITE_MODE_SGIX                                           = 0x8149, // reuse GetPName

    // StencilFunction

//  GL_NEVER                                                      = 0x0200, // reuse AlphaFunction
//  GL_LESS                                                       = 0x0201, // reuse AlphaFunction
//  GL_EQUAL                                                      = 0x0202, // reuse AlphaFunction
//  GL_LEQUAL                                                     = 0x0203, // reuse AlphaFunction
//  GL_GREATER                                                    = 0x0204, // reuse AlphaFunction
//  GL_NOTEQUAL                                                   = 0x0205, // reuse AlphaFunction
//  GL_GEQUAL                                                     = 0x0206, // reuse AlphaFunction
//  GL_ALWAYS                                                     = 0x0207, // reuse AlphaFunction

    // StencilOp

//  GL_ZERO                                                       = 0, // reuse BlendingFactor
//  GL_INVERT                                                     = 0x150A, // reuse LogicOp
    GL_KEEP                                                       = 0x1E00,
//  GL_REPLACE                                                    = 0x1E01, // reuse LightEnvModeSGIX
    GL_INCR                                                       = 0x1E02,
    GL_DECR                                                       = 0x1E03,
    GL_INCR_WRAP                                                  = 0x8507,
    GL_DECR_WRAP                                                  = 0x8508,

    // StringName

    GL_VENDOR                                                     = 0x1F00,
    GL_RENDERER                                                   = 0x1F01,
    GL_VERSION                                                    = 0x1F02,
    GL_EXTENSIONS                                                 = 0x1F03,
    GL_SHADING_LANGUAGE_VERSION                                   = 0x8B8C,

    // SubgroupSupportedFeatures

    GL_SUBGROUP_FEATURE_BASIC_BIT_KHR                             = 0x00000001,
    GL_SUBGROUP_FEATURE_VOTE_BIT_KHR                              = 0x00000002,
    GL_SUBGROUP_FEATURE_ARITHMETIC_BIT_KHR                        = 0x00000004,
    GL_SUBGROUP_FEATURE_BALLOT_BIT_KHR                            = 0x00000008,
    GL_SUBGROUP_FEATURE_SHUFFLE_BIT_KHR                           = 0x00000010,
    GL_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT_KHR                  = 0x00000020,
    GL_SUBGROUP_FEATURE_CLUSTERED_BIT_KHR                         = 0x00000040,
    GL_SUBGROUP_FEATURE_QUAD_BIT_KHR                              = 0x00000080,
    GL_SUBGROUP_FEATURE_PARTITIONED_BIT_NV                        = 0x00000100,

    // SubroutineParameterName

    GL_UNIFORM_SIZE                                               = 0x8A38,
    GL_UNIFORM_NAME_LENGTH                                        = 0x8A39,
//  GL_NUM_COMPATIBLE_SUBROUTINES                                 = 0x8E4A, // reuse ProgramResourceProperty
//  GL_COMPATIBLE_SUBROUTINES                                     = 0x8E4B, // reuse ProgramResourceProperty

    // SwizzleOpATI

    GL_SWIZZLE_STR_ATI                                            = 0x8976,
    GL_SWIZZLE_STQ_ATI                                            = 0x8977,
    GL_SWIZZLE_STR_DR_ATI                                         = 0x8978,
    GL_SWIZZLE_STQ_DQ_ATI                                         = 0x8979,

    // SyncBehaviorFlags

//  GL_NONE                                                       = 0, // reuse ColorBuffer

    // SyncCondition

    GL_SYNC_GPU_COMMANDS_COMPLETE                                 = 0x9117,

    // SyncParameterName

    GL_OBJECT_TYPE                                                = 0x9112,
    GL_SYNC_CONDITION                                             = 0x9113,
    GL_SYNC_STATUS                                                = 0x9114,
    GL_SYNC_FLAGS                                                 = 0x9115,

    // SyncStatus

    GL_ALREADY_SIGNALED                                           = 0x911A,
    GL_TIMEOUT_EXPIRED                                            = 0x911B,
    GL_CONDITION_SATISFIED                                        = 0x911C,
    GL_WAIT_FAILED                                                = 0x911D,

    // TangentPointerTypeEXT

//  GL_BYTE                                                       = 0x1400, // reuse BinormalPointerTypeEXT
//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // TexBumpParameterATI

//  GL_BUMP_ROT_MATRIX_ATI                                        = 0x8775, // reuse GetTexBumpParameterATI

    // TexCoordPointerType

//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // TextureCompareMode

//  GL_NONE                                                       = 0, // reuse ColorBuffer
    GL_COMPARE_R_TO_TEXTURE                                       = 0x884E,
    GL_COMPARE_REF_TO_TEXTURE                                     = 0x884E,

    // TextureCoordName

    GL_S                                                          = 0x2000,
    GL_T                                                          = 0x2001,
    GL_R                                                          = 0x2002,
    GL_Q                                                          = 0x2003,

    // TextureEnvMode

//  GL_ADD                                                        = 0x0104, // reuse AccumOp
//  GL_BLEND                                                      = 0x0BE2, // reuse EnableCap
//  GL_REPLACE                                                    = 0x1E01, // reuse LightEnvModeSGIX
//  GL_MODULATE                                                   = 0x2100, // reuse LightEnvModeSGIX
    GL_DECAL                                                      = 0x2101,
    GL_REPLACE_EXT                                                = 0x8062,
    GL_TEXTURE_ENV_BIAS_SGIX                                      = 0x80BE,
    GL_COMBINE                                                    = 0x8570,

    // TextureEnvParameter

//  GL_ALPHA_SCALE                                                = 0x0D1C, // reuse GetPName
    GL_TEXTURE_ENV_MODE                                           = 0x2200,
    GL_TEXTURE_ENV_COLOR                                          = 0x2201,
//  GL_TEXTURE_LOD_BIAS                                           = 0x8501, // reuse SamplerParameterF
//  GL_COMBINE                                                    = 0x8570, // reuse TextureEnvMode
    GL_COMBINE_ARB                                                = 0x8570,
    GL_COMBINE_EXT                                                = 0x8570,
    GL_COMBINE_RGB                                                = 0x8571,
    GL_COMBINE_RGB_ARB                                            = 0x8571,
    GL_COMBINE_RGB_EXT                                            = 0x8571,
    GL_COMBINE_ALPHA                                              = 0x8572,
    GL_COMBINE_ALPHA_ARB                                          = 0x8572,
    GL_COMBINE_ALPHA_EXT                                          = 0x8572,
    GL_RGB_SCALE                                                  = 0x8573,
    GL_RGB_SCALE_ARB                                              = 0x8573,
    GL_RGB_SCALE_EXT                                              = 0x8573,
    GL_ADD_SIGNED                                                 = 0x8574,
    GL_ADD_SIGNED_ARB                                             = 0x8574,
    GL_ADD_SIGNED_EXT                                             = 0x8574,
    GL_INTERPOLATE                                                = 0x8575,
    GL_INTERPOLATE_ARB                                            = 0x8575,
    GL_INTERPOLATE_EXT                                            = 0x8575,
//  GL_CONSTANT                                                   = 0x8576, // reuse PathGenMode
    GL_CONSTANT_ARB                                               = 0x8576,
    GL_CONSTANT_EXT                                               = 0x8576,
    GL_CONSTANT_NV                                                = 0x8576,
//  GL_PRIMARY_COLOR                                              = 0x8577, // reuse FragmentShaderGenericSourceATI
//  GL_PRIMARY_COLOR_ARB                                          = 0x8577, // reuse FragmentShaderGenericSourceATI
//  GL_PRIMARY_COLOR_EXT                                          = 0x8577, // reuse FragmentShaderGenericSourceATI
    GL_PREVIOUS                                                   = 0x8578,
    GL_PREVIOUS_ARB                                               = 0x8578,
    GL_PREVIOUS_EXT                                               = 0x8578,
    GL_SOURCE0_RGB                                                = 0x8580,
    GL_SOURCE0_RGB_ARB                                            = 0x8580,
    GL_SOURCE0_RGB_EXT                                            = 0x8580,
    GL_SRC0_RGB                                                   = 0x8580,
    GL_SOURCE1_RGB                                                = 0x8581,
    GL_SOURCE1_RGB_ARB                                            = 0x8581,
    GL_SOURCE1_RGB_EXT                                            = 0x8581,
    GL_SRC1_RGB                                                   = 0x8581,
    GL_SOURCE2_RGB                                                = 0x8582,
    GL_SOURCE2_RGB_ARB                                            = 0x8582,
    GL_SOURCE2_RGB_EXT                                            = 0x8582,
    GL_SRC2_RGB                                                   = 0x8582,
    GL_SOURCE3_RGB_NV                                             = 0x8583,
    GL_SOURCE0_ALPHA                                              = 0x8588,
    GL_SOURCE0_ALPHA_ARB                                          = 0x8588,
    GL_SOURCE0_ALPHA_EXT                                          = 0x8588,
    GL_SRC0_ALPHA                                                 = 0x8588,
    GL_SOURCE1_ALPHA                                              = 0x8589,
    GL_SOURCE1_ALPHA_ARB                                          = 0x8589,
    GL_SOURCE1_ALPHA_EXT                                          = 0x8589,
//  GL_SRC1_ALPHA                                                 = 0x8589, // reuse BlendingFactor
    GL_SOURCE2_ALPHA                                              = 0x858A,
    GL_SOURCE2_ALPHA_ARB                                          = 0x858A,
    GL_SOURCE2_ALPHA_EXT                                          = 0x858A,
    GL_SRC2_ALPHA                                                 = 0x858A,
    GL_SOURCE3_ALPHA_NV                                           = 0x858B,
    GL_OPERAND0_RGB                                               = 0x8590,
    GL_OPERAND0_RGB_ARB                                           = 0x8590,
    GL_OPERAND0_RGB_EXT                                           = 0x8590,
    GL_OPERAND1_RGB                                               = 0x8591,
    GL_OPERAND1_RGB_ARB                                           = 0x8591,
    GL_OPERAND1_RGB_EXT                                           = 0x8591,
    GL_OPERAND2_RGB                                               = 0x8592,
    GL_OPERAND2_RGB_ARB                                           = 0x8592,
    GL_OPERAND2_RGB_EXT                                           = 0x8592,
    GL_OPERAND3_RGB_NV                                            = 0x8593,
    GL_OPERAND0_ALPHA                                             = 0x8598,
    GL_OPERAND0_ALPHA_ARB                                         = 0x8598,
    GL_OPERAND0_ALPHA_EXT                                         = 0x8598,
    GL_OPERAND1_ALPHA                                             = 0x8599,
    GL_OPERAND1_ALPHA_ARB                                         = 0x8599,
    GL_OPERAND1_ALPHA_EXT                                         = 0x8599,
    GL_OPERAND2_ALPHA                                             = 0x859A,
    GL_OPERAND2_ALPHA_ARB                                         = 0x859A,
    GL_OPERAND2_ALPHA_EXT                                         = 0x859A,
    GL_OPERAND3_ALPHA_NV                                          = 0x859B,
    GL_COORD_REPLACE                                              = 0x8862,

    // TextureEnvTarget

    GL_TEXTURE_ENV                                                = 0x2300,
    GL_TEXTURE_FILTER_CONTROL                                     = 0x8500,
    GL_POINT_SPRITE                                               = 0x8861,

    // TextureFilterSGIS

    GL_FILTER4_SGIS                                               = 0x8146,

    // TextureGenMode

//  GL_EYE_LINEAR                                                 = 0x2400, // reuse PathGenMode
//  GL_OBJECT_LINEAR                                              = 0x2401, // reuse PathGenMode
    GL_SPHERE_MAP                                                 = 0x2402,
    GL_EYE_DISTANCE_TO_POINT_SGIS                                 = 0x81F0,
    GL_OBJECT_DISTANCE_TO_POINT_SGIS                              = 0x81F1,
    GL_EYE_DISTANCE_TO_LINE_SGIS                                  = 0x81F2,
    GL_OBJECT_DISTANCE_TO_LINE_SGIS                               = 0x81F3,

    // TextureGenParameter

    GL_TEXTURE_GEN_MODE                                           = 0x2500,
    GL_OBJECT_PLANE                                               = 0x2501,
    GL_EYE_PLANE                                                  = 0x2502,
    GL_EYE_POINT_SGIS                                             = 0x81F4,
    GL_OBJECT_POINT_SGIS                                          = 0x81F5,
    GL_EYE_LINE_SGIS                                              = 0x81F6,
    GL_OBJECT_LINE_SGIS                                           = 0x81F7,

    // TextureLayout

    GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT              = 0x9530,
    GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT              = 0x9531,
    GL_LAYOUT_GENERAL_EXT                                         = 0x958D,
    GL_LAYOUT_COLOR_ATTACHMENT_EXT                                = 0x958E,
    GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT                        = 0x958F,
    GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT                         = 0x9590,
    GL_LAYOUT_SHADER_READ_ONLY_EXT                                = 0x9591,
    GL_LAYOUT_TRANSFER_SRC_EXT                                    = 0x9592,
    GL_LAYOUT_TRANSFER_DST_EXT                                    = 0x9593,

    // TextureMagFilter

//  GL_NEAREST                                                    = 0x2600, // reuse BlitFramebufferFilter
//  GL_LINEAR                                                     = 0x2601, // reuse BlitFramebufferFilter
    GL_LINEAR_DETAIL_SGIS                                         = 0x8097,
    GL_LINEAR_DETAIL_ALPHA_SGIS                                   = 0x8098,
    GL_LINEAR_DETAIL_COLOR_SGIS                                   = 0x8099,
    GL_LINEAR_SHARPEN_SGIS                                        = 0x80AD,
    GL_LINEAR_SHARPEN_ALPHA_SGIS                                  = 0x80AE,
    GL_LINEAR_SHARPEN_COLOR_SGIS                                  = 0x80AF,
//  GL_FILTER4_SGIS                                               = 0x8146, // reuse TextureFilterSGIS

    // TextureMinFilter

//  GL_NEAREST                                                    = 0x2600, // reuse BlitFramebufferFilter
//  GL_LINEAR                                                     = 0x2601, // reuse BlitFramebufferFilter
    GL_NEAREST_MIPMAP_NEAREST                                     = 0x2700,
    GL_LINEAR_MIPMAP_NEAREST                                      = 0x2701,
    GL_NEAREST_MIPMAP_LINEAR                                      = 0x2702,
    GL_LINEAR_MIPMAP_LINEAR                                       = 0x2703,
//  GL_FILTER4_SGIS                                               = 0x8146, // reuse TextureFilterSGIS
    GL_LINEAR_CLIPMAP_LINEAR_SGIX                                 = 0x8170,
    GL_NEAREST_CLIPMAP_NEAREST_SGIX                               = 0x844D,
    GL_NEAREST_CLIPMAP_LINEAR_SGIX                                = 0x844E,
    GL_LINEAR_CLIPMAP_NEAREST_SGIX                                = 0x844F,

    // TextureNormalModeEXT

    GL_PERTURB_EXT                                                = 0x85AE,

    // TextureParameterName

//  GL_TEXTURE_WIDTH                                              = 0x1000, // reuse GetTextureParameter
//  GL_TEXTURE_HEIGHT                                             = 0x1001, // reuse GetTextureParameter
//  GL_TEXTURE_INTERNAL_FORMAT                                    = 0x1003, // reuse GetTextureParameter
//  GL_TEXTURE_COMPONENTS                                         = 0x1003, // reuse GetTextureParameter
//  GL_TEXTURE_BORDER_COLOR                                       = 0x1004, // reuse GetTextureParameter
//  GL_TEXTURE_BORDER                                             = 0x1005, // reuse GetTextureParameter
//  GL_TEXTURE_MAG_FILTER                                         = 0x2800, // reuse GetTextureParameter
//  GL_TEXTURE_MIN_FILTER                                         = 0x2801, // reuse GetTextureParameter
//  GL_TEXTURE_WRAP_S                                             = 0x2802, // reuse GetTextureParameter
//  GL_TEXTURE_WRAP_T                                             = 0x2803, // reuse GetTextureParameter
//  GL_TEXTURE_RED_SIZE                                           = 0x805C, // reuse GetTextureParameter
//  GL_TEXTURE_GREEN_SIZE                                         = 0x805D, // reuse GetTextureParameter
//  GL_TEXTURE_BLUE_SIZE                                          = 0x805E, // reuse GetTextureParameter
//  GL_TEXTURE_ALPHA_SIZE                                         = 0x805F, // reuse GetTextureParameter
//  GL_TEXTURE_LUMINANCE_SIZE                                     = 0x8060, // reuse GetTextureParameter
//  GL_TEXTURE_INTENSITY_SIZE                                     = 0x8061, // reuse GetTextureParameter
//  GL_TEXTURE_PRIORITY                                           = 0x8066, // reuse GetTextureParameter
    GL_TEXTURE_PRIORITY_EXT                                       = 0x8066,
//  GL_TEXTURE_RESIDENT                                           = 0x8067, // reuse GetTextureParameter
//  GL_TEXTURE_DEPTH_EXT                                          = 0x8071, // reuse GetTextureParameter
//  GL_TEXTURE_WRAP_R                                             = 0x8072, // reuse SamplerParameterI
//  GL_TEXTURE_WRAP_R_EXT                                         = 0x8072, // reuse GetTextureParameter
//  GL_DETAIL_TEXTURE_LEVEL_SGIS                                  = 0x809A, // reuse GetTextureParameter
//  GL_DETAIL_TEXTURE_MODE_SGIS                                   = 0x809B, // reuse GetTextureParameter
//  GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS                            = 0x809C, // reuse GetTextureParameter
//  GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS                           = 0x80B0, // reuse GetTextureParameter
//  GL_SHADOW_AMBIENT_SGIX                                        = 0x80BF, // reuse GetTextureParameter
//  GL_DUAL_TEXTURE_SELECT_SGIS                                   = 0x8124, // reuse GetTextureParameter
//  GL_QUAD_TEXTURE_SELECT_SGIS                                   = 0x8125, // reuse GetTextureParameter
//  GL_TEXTURE_4DSIZE_SGIS                                        = 0x8136, // reuse GetTextureParameter
//  GL_TEXTURE_WRAP_Q_SGIS                                        = 0x8137, // reuse GetTextureParameter
//  GL_TEXTURE_MIN_LOD                                            = 0x813A, // reuse SamplerParameterF
//  GL_TEXTURE_MIN_LOD_SGIS                                       = 0x813A, // reuse GetTextureParameter
//  GL_TEXTURE_MAX_LOD                                            = 0x813B, // reuse SamplerParameterF
//  GL_TEXTURE_MAX_LOD_SGIS                                       = 0x813B, // reuse GetTextureParameter
    GL_TEXTURE_BASE_LEVEL                                         = 0x813C,
//  GL_TEXTURE_BASE_LEVEL_SGIS                                    = 0x813C, // reuse GetTextureParameter
    GL_TEXTURE_MAX_LEVEL                                          = 0x813D,
//  GL_TEXTURE_MAX_LEVEL_SGIS                                     = 0x813D, // reuse GetTextureParameter
//  GL_TEXTURE_FILTER4_SIZE_SGIS                                  = 0x8147, // reuse GetTextureParameter
//  GL_TEXTURE_CLIPMAP_CENTER_SGIX                                = 0x8171, // reuse GetTextureParameter
//  GL_TEXTURE_CLIPMAP_FRAME_SGIX                                 = 0x8172, // reuse GetTextureParameter
//  GL_TEXTURE_CLIPMAP_OFFSET_SGIX                                = 0x8173, // reuse GetTextureParameter
//  GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX                         = 0x8174, // reuse GetTextureParameter
//  GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX                            = 0x8175, // reuse GetTextureParameter
//  GL_TEXTURE_CLIPMAP_DEPTH_SGIX                                 = 0x8176, // reuse GetTextureParameter
//  GL_POST_TEXTURE_FILTER_BIAS_SGIX                              = 0x8179, // reuse GetTextureParameter
//  GL_POST_TEXTURE_FILTER_SCALE_SGIX                             = 0x817A, // reuse GetTextureParameter
//  GL_TEXTURE_LOD_BIAS_S_SGIX                                    = 0x818E, // reuse GetTextureParameter
//  GL_TEXTURE_LOD_BIAS_T_SGIX                                    = 0x818F, // reuse GetTextureParameter
//  GL_TEXTURE_LOD_BIAS_R_SGIX                                    = 0x8190, // reuse GetTextureParameter
//  GL_GENERATE_MIPMAP                                            = 0x8191, // reuse InternalFormatPName
//  GL_GENERATE_MIPMAP_SGIS                                       = 0x8191, // reuse GetTextureParameter
//  GL_TEXTURE_COMPARE_SGIX                                       = 0x819A, // reuse GetTextureParameter
//  GL_TEXTURE_COMPARE_OPERATOR_SGIX                              = 0x819B, // reuse GetTextureParameter
//  GL_TEXTURE_LEQUAL_R_SGIX                                      = 0x819C, // reuse GetTextureParameter
//  GL_TEXTURE_GEQUAL_R_SGIX                                      = 0x819D, // reuse GetTextureParameter
//  GL_TEXTURE_MAX_CLAMP_S_SGIX                                   = 0x8369, // reuse GetTextureParameter
//  GL_TEXTURE_MAX_CLAMP_T_SGIX                                   = 0x836A, // reuse GetTextureParameter
//  GL_TEXTURE_MAX_CLAMP_R_SGIX                                   = 0x836B, // reuse GetTextureParameter
    GL_TEXTURE_MEMORY_LAYOUT_INTEL                                = 0x83FF,
//  GL_TEXTURE_MAX_ANISOTROPY                                     = 0x84FE, // reuse SamplerParameterF
//  GL_TEXTURE_LOD_BIAS                                           = 0x8501, // reuse SamplerParameterF
//  GL_TEXTURE_COMPARE_MODE                                       = 0x884C, // reuse SamplerParameterI
//  GL_TEXTURE_COMPARE_FUNC                                       = 0x884D, // reuse SamplerParameterI
    GL_TEXTURE_SWIZZLE_R                                          = 0x8E42,
    GL_TEXTURE_SWIZZLE_G                                          = 0x8E43,
    GL_TEXTURE_SWIZZLE_B                                          = 0x8E44,
    GL_TEXTURE_SWIZZLE_A                                          = 0x8E45,
    GL_TEXTURE_SWIZZLE_RGBA                                       = 0x8E46,
    GL_DEPTH_STENCIL_TEXTURE_MODE                                 = 0x90EA,
    GL_TEXTURE_TILING_EXT                                         = 0x9580,

    // TextureSwizzle

//  GL_ZERO                                                       = 0, // reuse BlendingFactor
//  GL_RED                                                        = 0x1903, // reuse FragmentShaderValueRepATI
//  GL_GREEN                                                      = 0x1904, // reuse FragmentShaderValueRepATI
//  GL_BLUE                                                       = 0x1905, // reuse CombinerComponentUsageNV
//  GL_ALPHA                                                      = 0x1906, // reuse CombinerComponentUsageNV
//  GL_ONE                                                        = 1, // reuse BlendingFactor

    // TextureTarget

//  GL_TEXTURE_1D                                                 = 0x0DE0, // reuse CopyImageSubDataTarget
//  GL_TEXTURE_2D                                                 = 0x0DE1, // reuse CopyImageSubDataTarget
    GL_PROXY_TEXTURE_1D                                           = 0x8063,
    GL_PROXY_TEXTURE_1D_EXT                                       = 0x8063,
    GL_PROXY_TEXTURE_2D                                           = 0x8064,
    GL_PROXY_TEXTURE_2D_EXT                                       = 0x8064,
//  GL_TEXTURE_3D                                                 = 0x806F, // reuse CopyImageSubDataTarget
//  GL_TEXTURE_3D_EXT                                             = 0x806F, // reuse EnableCap
    GL_PROXY_TEXTURE_3D                                           = 0x8070,
    GL_PROXY_TEXTURE_3D_EXT                                       = 0x8070,
    GL_DETAIL_TEXTURE_2D_SGIS                                     = 0x8095,
//  GL_TEXTURE_4D_SGIS                                            = 0x8134, // reuse EnableCap
    GL_PROXY_TEXTURE_4D_SGIS                                      = 0x8135,
//  GL_TEXTURE_RECTANGLE                                          = 0x84F5, // reuse CopyImageSubDataTarget
//  GL_TEXTURE_RECTANGLE_ARB                                      = 0x84F5, // reuse EnableCap
//  GL_TEXTURE_RECTANGLE_NV                                       = 0x84F5, // reuse EnableCap
    GL_PROXY_TEXTURE_RECTANGLE                                    = 0x84F7,
    GL_PROXY_TEXTURE_RECTANGLE_ARB                                = 0x84F7,
    GL_PROXY_TEXTURE_RECTANGLE_NV                                 = 0x84F7,
//  GL_TEXTURE_CUBE_MAP                                           = 0x8513, // reuse CopyImageSubDataTarget
//  GL_TEXTURE_CUBE_MAP_ARB                                       = 0x8513, // reuse EnableCap
//  GL_TEXTURE_CUBE_MAP_EXT                                       = 0x8513, // reuse EnableCap
    GL_TEXTURE_CUBE_MAP_POSITIVE_X                                = 0x8515,
    GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB                            = 0x8515,
    GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT                            = 0x8515,
    GL_TEXTURE_CUBE_MAP_NEGATIVE_X                                = 0x8516,
    GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB                            = 0x8516,
    GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT                            = 0x8516,
    GL_TEXTURE_CUBE_MAP_POSITIVE_Y                                = 0x8517,
    GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB                            = 0x8517,
    GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT                            = 0x8517,
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Y                                = 0x8518,
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB                            = 0x8518,
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT                            = 0x8518,
    GL_TEXTURE_CUBE_MAP_POSITIVE_Z                                = 0x8519,
    GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB                            = 0x8519,
    GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT                            = 0x8519,
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Z                                = 0x851A,
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB                            = 0x851A,
    GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT                            = 0x851A,
    GL_PROXY_TEXTURE_CUBE_MAP                                     = 0x851B,
    GL_PROXY_TEXTURE_CUBE_MAP_ARB                                 = 0x851B,
    GL_PROXY_TEXTURE_CUBE_MAP_EXT                                 = 0x851B,
//  GL_TEXTURE_1D_ARRAY                                           = 0x8C18, // reuse CopyImageSubDataTarget
    GL_PROXY_TEXTURE_1D_ARRAY                                     = 0x8C19,
    GL_PROXY_TEXTURE_1D_ARRAY_EXT                                 = 0x8C19,
//  GL_TEXTURE_2D_ARRAY                                           = 0x8C1A, // reuse CopyImageSubDataTarget
    GL_PROXY_TEXTURE_2D_ARRAY                                     = 0x8C1B,
    GL_PROXY_TEXTURE_2D_ARRAY_EXT                                 = 0x8C1B,
//  GL_TEXTURE_BUFFER                                             = 0x8C2A, // reuse BufferStorageTarget
//  GL_RENDERBUFFER                                               = 0x8D41, // reuse CopyImageSubDataTarget
//  GL_TEXTURE_CUBE_MAP_ARRAY                                     = 0x9009, // reuse CopyImageSubDataTarget
    GL_TEXTURE_CUBE_MAP_ARRAY_ARB                                 = 0x9009,
    GL_PROXY_TEXTURE_CUBE_MAP_ARRAY                               = 0x900B,
    GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB                           = 0x900B,
//  GL_TEXTURE_2D_MULTISAMPLE                                     = 0x9100, // reuse CopyImageSubDataTarget
    GL_PROXY_TEXTURE_2D_MULTISAMPLE                               = 0x9101,
//  GL_TEXTURE_2D_MULTISAMPLE_ARRAY                               = 0x9102, // reuse CopyImageSubDataTarget
    GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY                         = 0x9103,

    // TextureUnit

//  GL_TEXTURE0                                                   = 0x84C0, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE1                                                   = 0x84C1, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE2                                                   = 0x84C2, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE3                                                   = 0x84C3, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE4                                                   = 0x84C4, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE5                                                   = 0x84C5, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE6                                                   = 0x84C6, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE7                                                   = 0x84C7, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE8                                                   = 0x84C8, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE9                                                   = 0x84C9, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE10                                                  = 0x84CA, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE11                                                  = 0x84CB, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE12                                                  = 0x84CC, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE13                                                  = 0x84CD, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE14                                                  = 0x84CE, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE15                                                  = 0x84CF, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE16                                                  = 0x84D0, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE17                                                  = 0x84D1, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE18                                                  = 0x84D2, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE19                                                  = 0x84D3, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE20                                                  = 0x84D4, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE21                                                  = 0x84D5, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE22                                                  = 0x84D6, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE23                                                  = 0x84D7, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE24                                                  = 0x84D8, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE25                                                  = 0x84D9, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE26                                                  = 0x84DA, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE27                                                  = 0x84DB, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE28                                                  = 0x84DC, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE29                                                  = 0x84DD, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE30                                                  = 0x84DE, // reuse FragmentShaderTextureSourceATI
//  GL_TEXTURE31                                                  = 0x84DF, // reuse FragmentShaderTextureSourceATI

    // TextureWrapMode

    GL_CLAMP                                                      = 0x2900,
    GL_REPEAT                                                     = 0x2901,
    GL_CLAMP_TO_BORDER                                            = 0x812D,
    GL_CLAMP_TO_BORDER_ARB                                        = 0x812D,
    GL_CLAMP_TO_BORDER_SGIS                                       = 0x812D,
    GL_CLAMP_TO_EDGE                                              = 0x812F,
    GL_CLAMP_TO_EDGE_SGIS                                         = 0x812F,
    GL_MIRRORED_REPEAT                                            = 0x8370,
    GL_MIRRORED_REPEAT_ARB                                        = 0x8370,
    GL_MIRRORED_REPEAT_IBM                                        = 0x8370,

    // TransformFeedbackBufferMode

    GL_INTERLEAVED_ATTRIBS                                        = 0x8C8C,
    GL_SEPARATE_ATTRIBS                                           = 0x8C8D,

    // TransformFeedbackPName

//  GL_TRANSFORM_FEEDBACK_BUFFER_START                            = 0x8C84, // reuse GetPName
//  GL_TRANSFORM_FEEDBACK_BUFFER_SIZE                             = 0x8C85, // reuse GetPName
//  GL_TRANSFORM_FEEDBACK_BUFFER_BINDING                          = 0x8C8F, // reuse GetPName
    GL_TRANSFORM_FEEDBACK_PAUSED                                  = 0x8E23,
    GL_TRANSFORM_FEEDBACK_ACTIVE                                  = 0x8E24,

    // TransformFeedbackTokenNV

    GL_NEXT_BUFFER_NV                                             = static_cast<std::underlying_type<GLenum>::type>(-2),
    GL_SKIP_COMPONENTS4_NV                                        = static_cast<std::underlying_type<GLenum>::type>(-3),
    GL_SKIP_COMPONENTS3_NV                                        = static_cast<std::underlying_type<GLenum>::type>(-4),
    GL_SKIP_COMPONENTS2_NV                                        = static_cast<std::underlying_type<GLenum>::type>(-5),
    GL_SKIP_COMPONENTS1_NV                                        = static_cast<std::underlying_type<GLenum>::type>(-6),

    // TriangleFace

//  GL_FRONT                                                      = 0x0404, // reuse ColorBuffer
//  GL_BACK                                                       = 0x0405, // reuse ColorBuffer
//  GL_FRONT_AND_BACK                                             = 0x0408, // reuse ColorBuffer

    // TriangleListSUN

    GL_RESTART_SUN                                                = 0x0001,
    GL_REPLACE_MIDDLE_SUN                                         = 0x0002,
    GL_REPLACE_OLDEST_SUN                                         = 0x0003,

    // UNGROUPED

    GL_STACK_OVERFLOW_KHR                                         = 0x0503,
    GL_STACK_UNDERFLOW_KHR                                        = 0x0504,
    GL_CONTEXT_LOST                                               = 0x0507,
    GL_CONTEXT_LOST_KHR                                           = 0x0507,
    GL_PATH_MODELVIEW_STACK_DEPTH_NV                              = 0x0BA3,
    GL_PATH_PROJECTION_STACK_DEPTH_NV                             = 0x0BA4,
    GL_PATH_MODELVIEW_MATRIX_NV                                   = 0x0BA6,
    GL_PATH_PROJECTION_MATRIX_NV                                  = 0x0BA7,
    GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV                          = 0x0D36,
    GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV                         = 0x0D38,
    GL_TEXTURE_TARGET                                             = 0x1006,
    GL_2_BYTES_NV                                                 = 0x1407,
    GL_3_BYTES_NV                                                 = 0x1408,
    GL_4_BYTES_NV                                                 = 0x1409,
    GL_FIXED_OES                                                  = 0x140C,
    GL_XOR_NV                                                     = 0x1506,
    GL_MODELVIEW0_ARB                                             = 0x1700,
    GL_PATH_MODELVIEW_NV                                          = 0x1700,
    GL_PATH_PROJECTION_NV                                         = 0x1701,
    GL_RED_NV                                                     = 0x1903,
    GL_GREEN_NV                                                   = 0x1904,
    GL_BLUE_NV                                                    = 0x1905,
    GL_RASTER_POSITION_UNCLIPPED_IBM                              = 0x19262,
    GL_NATIVE_GRAPHICS_HANDLE_PGI                                 = 0x1A202,
    GL_EYE_LINEAR_NV                                              = 0x2400,
    GL_OBJECT_LINEAR_NV                                           = 0x2401,
    GL_CONSTANT_COLOR_EXT                                         = 0x8001,
    GL_ONE_MINUS_CONSTANT_COLOR_EXT                               = 0x8002,
    GL_CONSTANT_ALPHA_EXT                                         = 0x8003,
    GL_ONE_MINUS_CONSTANT_ALPHA_EXT                               = 0x8004,
    GL_BLEND_EQUATION_RGB_EXT                                     = 0x8009,
    GL_POLYGON_OFFSET_EXT                                         = 0x8037,
    GL_POLYGON_OFFSET_FACTOR_EXT                                  = 0x8038,
    GL_RESCALE_NORMAL                                             = 0x803A,
    GL_INTENSITY_EXT                                              = 0x8049,
    GL_TEXTURE_RED_SIZE_EXT                                       = 0x805C,
    GL_TEXTURE_GREEN_SIZE_EXT                                     = 0x805D,
    GL_TEXTURE_BLUE_SIZE_EXT                                      = 0x805E,
    GL_TEXTURE_ALPHA_SIZE_EXT                                     = 0x805F,
    GL_TEXTURE_LUMINANCE_SIZE_EXT                                 = 0x8060,
    GL_TEXTURE_INTENSITY_SIZE_EXT                                 = 0x8061,
    GL_TEXTURE_RESIDENT_EXT                                       = 0x8067,
    GL_TEXTURE_1D_BINDING_EXT                                     = 0x8068,
    GL_TEXTURE_2D_BINDING_EXT                                     = 0x8069,
    GL_TEXTURE_DEPTH                                              = 0x8071,
    GL_VERTEX_ARRAY_EXT                                           = 0x8074,
    GL_VERTEX_ARRAY_KHR                                           = 0x8074,
    GL_NORMAL_ARRAY_EXT                                           = 0x8075,
    GL_COLOR_ARRAY_EXT                                            = 0x8076,
    GL_INDEX_ARRAY_EXT                                            = 0x8077,
    GL_TEXTURE_COORD_ARRAY_EXT                                    = 0x8078,
    GL_EDGE_FLAG_ARRAY_EXT                                        = 0x8079,
    GL_VERTEX_ARRAY_SIZE_EXT                                      = 0x807A,
    GL_VERTEX_ARRAY_TYPE_EXT                                      = 0x807B,
    GL_VERTEX_ARRAY_STRIDE_EXT                                    = 0x807C,
    GL_NORMAL_ARRAY_TYPE_EXT                                      = 0x807E,
    GL_NORMAL_ARRAY_STRIDE_EXT                                    = 0x807F,
    GL_COLOR_ARRAY_SIZE_EXT                                       = 0x8081,
    GL_COLOR_ARRAY_TYPE_EXT                                       = 0x8082,
    GL_COLOR_ARRAY_STRIDE_EXT                                     = 0x8083,
    GL_INDEX_ARRAY_TYPE_EXT                                       = 0x8085,
    GL_INDEX_ARRAY_STRIDE_EXT                                     = 0x8086,
    GL_TEXTURE_COORD_ARRAY_SIZE_EXT                               = 0x8088,
    GL_TEXTURE_COORD_ARRAY_TYPE_EXT                               = 0x8089,
    GL_TEXTURE_COORD_ARRAY_STRIDE_EXT                             = 0x808A,
    GL_EDGE_FLAG_ARRAY_STRIDE_EXT                                 = 0x808C,
    GL_MULTISAMPLE_ARB                                            = 0x809D,
    GL_MULTISAMPLE_EXT                                            = 0x809D,
    GL_SAMPLE_ALPHA_TO_COVERAGE_ARB                               = 0x809E,
    GL_SAMPLE_ALPHA_TO_MASK_EXT                                   = 0x809E,
    GL_SAMPLE_ALPHA_TO_ONE_ARB                                    = 0x809F,
    GL_SAMPLE_ALPHA_TO_ONE_EXT                                    = 0x809F,
    GL_SAMPLE_COVERAGE_ARB                                        = 0x80A0,
    GL_SAMPLE_MASK_EXT                                            = 0x80A0,
    GL_SAMPLE_BUFFERS_ARB                                         = 0x80A8,
    GL_SAMPLE_BUFFERS_EXT                                         = 0x80A8,
    GL_SAMPLES_ARB                                                = 0x80A9,
    GL_SAMPLES_EXT                                                = 0x80A9,
    GL_SAMPLE_COVERAGE_VALUE_ARB                                  = 0x80AA,
    GL_SAMPLE_MASK_VALUE_EXT                                      = 0x80AA,
    GL_SAMPLE_COVERAGE_INVERT_ARB                                 = 0x80AB,
    GL_SAMPLE_MASK_INVERT_EXT                                     = 0x80AB,
    GL_SAMPLE_PATTERN_EXT                                         = 0x80AC,
    GL_COLOR_MATRIX                                               = 0x80B1,
    GL_COLOR_MATRIX_STACK_DEPTH                                   = 0x80B2,
    GL_MAX_COLOR_MATRIX_STACK_DEPTH                               = 0x80B3,
    GL_TEXTURE_COMPARE_FAIL_VALUE_ARB                             = 0x80BF,
    GL_BLEND_DST_RGB_EXT                                          = 0x80C8,
    GL_BLEND_SRC_RGB_EXT                                          = 0x80C9,
    GL_BLEND_DST_ALPHA_EXT                                        = 0x80CA,
    GL_BLEND_SRC_ALPHA_EXT                                        = 0x80CB,
    GL_422_EXT                                                    = 0x80CC,
    GL_422_REV_EXT                                                = 0x80CD,
    GL_422_AVERAGE_EXT                                            = 0x80CE,
    GL_422_REV_AVERAGE_EXT                                        = 0x80CF,
    GL_COLOR_INDEX1_EXT                                           = 0x80E2,
    GL_COLOR_INDEX2_EXT                                           = 0x80E3,
    GL_COLOR_INDEX4_EXT                                           = 0x80E4,
    GL_COLOR_INDEX8_EXT                                           = 0x80E5,
    GL_COLOR_INDEX12_EXT                                          = 0x80E6,
    GL_COLOR_INDEX16_EXT                                          = 0x80E7,
    GL_MAX_ELEMENTS_VERTICES_EXT                                  = 0x80E8,
    GL_MAX_ELEMENTS_INDICES_EXT                                   = 0x80E9,
    GL_PHONG_WIN                                                  = 0x80EA,
    GL_FOG_SPECULAR_TEXTURE_WIN                                   = 0x80EC,
    GL_TEXTURE_INDEX_SIZE_EXT                                     = 0x80ED,
    GL_PARAMETER_BUFFER_ARB                                       = 0x80EE,
    GL_PARAMETER_BUFFER_BINDING                                   = 0x80EF,
    GL_PARAMETER_BUFFER_BINDING_ARB                               = 0x80EF,
    GL_IGNORE_BORDER_HP                                           = 0x8150,
    GL_CONSTANT_BORDER                                            = 0x8151,
    GL_CONSTANT_BORDER_HP                                         = 0x8151,
    GL_REPLICATE_BORDER                                           = 0x8153,
    GL_REPLICATE_BORDER_HP                                        = 0x8153,
    GL_CONVOLUTION_BORDER_COLOR_HP                                = 0x8154,
    GL_CUBIC_HP                                                   = 0x815F,
    GL_AVERAGE_HP                                                 = 0x8160,
    GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP                        = 0x8162,
    GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP                  = 0x8163,
    GL_OCCLUSION_TEST_HP                                          = 0x8165,
    GL_OCCLUSION_TEST_RESULT_HP                                   = 0x8166,
    GL_TEXTURE_LIGHTING_MODE_HP                                   = 0x8167,
    GL_TEXTURE_POST_SPECULAR_HP                                   = 0x8168,
    GL_TEXTURE_PRE_SPECULAR_HP                                    = 0x8169,
    GL_MAX_DEFORMATION_ORDER_SGIX                                 = 0x8197,
    GL_ARRAY_ELEMENT_LOCK_FIRST_EXT                               = 0x81A8,
    GL_ARRAY_ELEMENT_LOCK_COUNT_EXT                               = 0x81A9,
    GL_CULL_VERTEX_EXT                                            = 0x81AA,
    GL_IUI_V2F_EXT                                                = 0x81AD,
    GL_IUI_V3F_EXT                                                = 0x81AE,
    GL_IUI_N3F_V2F_EXT                                            = 0x81AF,
    GL_IUI_N3F_V3F_EXT                                            = 0x81B0,
    GL_T2F_IUI_V2F_EXT                                            = 0x81B1,
    GL_T2F_IUI_V3F_EXT                                            = 0x81B2,
    GL_T2F_IUI_N3F_V2F_EXT                                        = 0x81B3,
    GL_T2F_IUI_N3F_V3F_EXT                                        = 0x81B4,
    GL_INDEX_TEST_EXT                                             = 0x81B5,
    GL_INDEX_TEST_FUNC_EXT                                        = 0x81B6,
    GL_INDEX_TEST_REF_EXT                                         = 0x81B7,
    GL_INDEX_MATERIAL_EXT                                         = 0x81B8,
    GL_INDEX_MATERIAL_PARAMETER_EXT                               = 0x81B9,
    GL_INDEX_MATERIAL_FACE_EXT                                    = 0x81BA,
    GL_WRAP_BORDER_SUN                                            = 0x81D4,
    GL_UNPACK_CONSTANT_DATA_SUNX                                  = 0x81D5,
    GL_TEXTURE_CONSTANT_DATA_SUNX                                 = 0x81D6,
    GL_TRIANGLE_LIST_SUN                                          = 0x81D7,
    GL_REPLACEMENT_CODE_SUN                                       = 0x81D8,
    GL_GLOBAL_ALPHA_SUN                                           = 0x81D9,
    GL_GLOBAL_ALPHA_FACTOR_SUN                                    = 0x81DA,
    GL_TEXTURE_COLOR_WRITEMASK_SGIS                               = 0x81EF,
    GL_FRAMEBUFFER_DEFAULT                                        = 0x8218,
    GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED                    = 0x8221,
    GL_INDEX                                                      = 0x8222,
    GL_SYNC_CL_EVENT_ARB                                          = 0x8240,
    GL_SYNC_CL_EVENT_COMPLETE_ARB                                 = 0x8241,
    GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB                               = 0x8242,
    GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR                               = 0x8242,
    GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH                           = 0x8243,
    GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB                       = 0x8243,
    GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR                       = 0x8243,
    GL_DEBUG_CALLBACK_FUNCTION_ARB                                = 0x8244,
    GL_DEBUG_CALLBACK_FUNCTION_KHR                                = 0x8244,
    GL_DEBUG_CALLBACK_USER_PARAM_ARB                              = 0x8245,
    GL_DEBUG_CALLBACK_USER_PARAM_KHR                              = 0x8245,
    GL_DEBUG_SOURCE_API_ARB                                       = 0x8246,
    GL_DEBUG_SOURCE_API_KHR                                       = 0x8246,
    GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB                             = 0x8247,
    GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR                             = 0x8247,
    GL_DEBUG_SOURCE_SHADER_COMPILER_ARB                           = 0x8248,
    GL_DEBUG_SOURCE_SHADER_COMPILER_KHR                           = 0x8248,
    GL_DEBUG_SOURCE_THIRD_PARTY_ARB                               = 0x8249,
    GL_DEBUG_SOURCE_THIRD_PARTY_KHR                               = 0x8249,
    GL_DEBUG_SOURCE_APPLICATION_ARB                               = 0x824A,
    GL_DEBUG_SOURCE_APPLICATION_KHR                               = 0x824A,
    GL_DEBUG_SOURCE_OTHER_ARB                                     = 0x824B,
    GL_DEBUG_SOURCE_OTHER_KHR                                     = 0x824B,
    GL_DEBUG_TYPE_ERROR_ARB                                       = 0x824C,
    GL_DEBUG_TYPE_ERROR_KHR                                       = 0x824C,
    GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB                         = 0x824D,
    GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR                         = 0x824D,
    GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB                          = 0x824E,
    GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR                          = 0x824E,
    GL_DEBUG_TYPE_PORTABILITY_ARB                                 = 0x824F,
    GL_DEBUG_TYPE_PORTABILITY_KHR                                 = 0x824F,
    GL_DEBUG_TYPE_PERFORMANCE_ARB                                 = 0x8250,
    GL_DEBUG_TYPE_PERFORMANCE_KHR                                 = 0x8250,
    GL_DEBUG_TYPE_OTHER_ARB                                       = 0x8251,
    GL_DEBUG_TYPE_OTHER_KHR                                       = 0x8251,
    GL_LOSE_CONTEXT_ON_RESET                                      = 0x8252,
    GL_LOSE_CONTEXT_ON_RESET_ARB                                  = 0x8252,
    GL_LOSE_CONTEXT_ON_RESET_KHR                                  = 0x8252,
    GL_GUILTY_CONTEXT_RESET_ARB                                   = 0x8253,
    GL_GUILTY_CONTEXT_RESET_KHR                                   = 0x8253,
    GL_INNOCENT_CONTEXT_RESET_ARB                                 = 0x8254,
    GL_INNOCENT_CONTEXT_RESET_KHR                                 = 0x8254,
    GL_UNKNOWN_CONTEXT_RESET_ARB                                  = 0x8255,
    GL_UNKNOWN_CONTEXT_RESET_KHR                                  = 0x8255,
    GL_RESET_NOTIFICATION_STRATEGY                                = 0x8256,
    GL_RESET_NOTIFICATION_STRATEGY_ARB                            = 0x8256,
    GL_RESET_NOTIFICATION_STRATEGY_KHR                            = 0x8256,
    GL_PROGRAM_SEPARABLE_EXT                                      = 0x8258,
    GL_ACTIVE_PROGRAM_EXT                                         = 0x8259,
    GL_PROGRAM_PIPELINE_BINDING_EXT                               = 0x825A,
    GL_UNDEFINED_VERTEX                                           = 0x8260,
    GL_NO_RESET_NOTIFICATION                                      = 0x8261,
    GL_NO_RESET_NOTIFICATION_ARB                                  = 0x8261,
    GL_NO_RESET_NOTIFICATION_KHR                                  = 0x8261,
    GL_MAX_COMPUTE_SHARED_MEMORY_SIZE                             = 0x8262,
    GL_DEBUG_TYPE_MARKER_KHR                                      = 0x8268,
    GL_DEBUG_TYPE_PUSH_GROUP_KHR                                  = 0x8269,
    GL_DEBUG_TYPE_POP_GROUP_KHR                                   = 0x826A,
    GL_DEBUG_SEVERITY_NOTIFICATION_KHR                            = 0x826B,
    GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR                            = 0x826C,
    GL_DEBUG_GROUP_STACK_DEPTH_KHR                                = 0x826D,
    GL_MAX_COMBINED_DIMENSIONS                                    = 0x8282,
    GL_DEPTH_COMPONENTS                                           = 0x8284,
    GL_STENCIL_COMPONENTS                                         = 0x8285,
    GL_MANUAL_GENERATE_MIPMAP                                     = 0x8294,
    GL_SRGB_DECODE_ARB                                            = 0x8299,
    GL_FULL_SUPPORT                                               = 0x82B7,
    GL_CAVEAT_SUPPORT                                             = 0x82B8,
    GL_IMAGE_CLASS_4_X_32                                         = 0x82B9,
    GL_IMAGE_CLASS_2_X_32                                         = 0x82BA,
    GL_IMAGE_CLASS_1_X_32                                         = 0x82BB,
    GL_IMAGE_CLASS_4_X_16                                         = 0x82BC,
    GL_IMAGE_CLASS_2_X_16                                         = 0x82BD,
    GL_IMAGE_CLASS_1_X_16                                         = 0x82BE,
    GL_IMAGE_CLASS_4_X_8                                          = 0x82BF,
    GL_IMAGE_CLASS_2_X_8                                          = 0x82C0,
    GL_IMAGE_CLASS_1_X_8                                          = 0x82C1,
    GL_IMAGE_CLASS_11_11_10                                       = 0x82C2,
    GL_IMAGE_CLASS_10_10_10_2                                     = 0x82C3,
    GL_VIEW_CLASS_128_BITS                                        = 0x82C4,
    GL_VIEW_CLASS_96_BITS                                         = 0x82C5,
    GL_VIEW_CLASS_64_BITS                                         = 0x82C6,
    GL_VIEW_CLASS_48_BITS                                         = 0x82C7,
    GL_VIEW_CLASS_32_BITS                                         = 0x82C8,
    GL_VIEW_CLASS_24_BITS                                         = 0x82C9,
    GL_VIEW_CLASS_16_BITS                                         = 0x82CA,
    GL_VIEW_CLASS_8_BITS                                          = 0x82CB,
    GL_VIEW_CLASS_S3TC_DXT1_RGB                                   = 0x82CC,
    GL_VIEW_CLASS_S3TC_DXT1_RGBA                                  = 0x82CD,
    GL_VIEW_CLASS_S3TC_DXT3_RGBA                                  = 0x82CE,
    GL_VIEW_CLASS_S3TC_DXT5_RGBA                                  = 0x82CF,
    GL_VIEW_CLASS_RGTC1_RED                                       = 0x82D0,
    GL_VIEW_CLASS_RGTC2_RG                                        = 0x82D1,
    GL_VIEW_CLASS_BPTC_UNORM                                      = 0x82D2,
    GL_VIEW_CLASS_BPTC_FLOAT                                      = 0x82D3,
    GL_TEXTURE_VIEW_MIN_LEVEL                                     = 0x82DB,
    GL_TEXTURE_VIEW_NUM_LEVELS                                    = 0x82DC,
    GL_TEXTURE_VIEW_MIN_LAYER                                     = 0x82DD,
    GL_TEXTURE_VIEW_NUM_LAYERS                                    = 0x82DE,
    GL_TEXTURE_IMMUTABLE_LEVELS                                   = 0x82DF,
    GL_BUFFER_KHR                                                 = 0x82E0,
    GL_SHADER_KHR                                                 = 0x82E1,
    GL_PROGRAM_KHR                                                = 0x82E2,
    GL_QUERY_KHR                                                  = 0x82E3,
    GL_PROGRAM_PIPELINE_KHR                                       = 0x82E4,
    GL_MAX_VERTEX_ATTRIB_STRIDE                                   = 0x82E5,
    GL_SAMPLER_KHR                                                = 0x82E6,
    GL_DISPLAY_LIST                                               = 0x82E7,
    GL_MAX_LABEL_LENGTH_KHR                                       = 0x82E8,
    GL_NUM_SHADING_LANGUAGE_VERSIONS                              = 0x82E9,
    GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB                            = 0x82EC,
    GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW                         = 0x82ED,
    GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB                     = 0x82ED,
    GL_VERTICES_SUBMITTED_ARB                                     = 0x82EE,
    GL_PRIMITIVES_SUBMITTED_ARB                                   = 0x82EF,
    GL_VERTEX_SHADER_INVOCATIONS_ARB                              = 0x82F0,
    GL_TESS_CONTROL_SHADER_PATCHES                                = 0x82F1,
    GL_TESS_CONTROL_SHADER_PATCHES_ARB                            = 0x82F1,
    GL_TESS_EVALUATION_SHADER_INVOCATIONS                         = 0x82F2,
    GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB                     = 0x82F2,
    GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED                         = 0x82F3,
    GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB                     = 0x82F3,
    GL_FRAGMENT_SHADER_INVOCATIONS                                = 0x82F4,
    GL_FRAGMENT_SHADER_INVOCATIONS_ARB                            = 0x82F4,
    GL_COMPUTE_SHADER_INVOCATIONS                                 = 0x82F5,
    GL_COMPUTE_SHADER_INVOCATIONS_ARB                             = 0x82F5,
    GL_CLIPPING_INPUT_PRIMITIVES                                  = 0x82F6,
    GL_CLIPPING_INPUT_PRIMITIVES_ARB                              = 0x82F6,
    GL_CLIPPING_OUTPUT_PRIMITIVES                                 = 0x82F7,
    GL_CLIPPING_OUTPUT_PRIMITIVES_ARB                             = 0x82F7,
    GL_SPARSE_BUFFER_PAGE_SIZE_ARB                                = 0x82F8,
    GL_MAX_CULL_DISTANCES                                         = 0x82F9,
    GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES                       = 0x82FA,
    GL_CONTEXT_RELEASE_BEHAVIOR                                   = 0x82FB,
    GL_CONTEXT_RELEASE_BEHAVIOR_KHR                               = 0x82FB,
    GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH                             = 0x82FC,
    GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR                         = 0x82FC,
    GL_YCRCB_SGIX                                                 = 0x8318,
    GL_YCRCBA_SGIX                                                = 0x8319,
    GL_CUBIC_EXT                                                  = 0x8334,
    GL_AVERAGE_EXT                                                = 0x8335,
    GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT                         = 0x8336,
    GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT                     = 0x8337,
    GL_PIXEL_TRANSFORM_2D_MATRIX_EXT                              = 0x8338,
    GL_TEXTURE_APPLICATION_MODE_EXT                               = 0x834F,
    GL_TEXTURE_LIGHT_EXT                                          = 0x8350,
    GL_TEXTURE_MATERIAL_FACE_EXT                                  = 0x8351,
    GL_TEXTURE_MATERIAL_PARAMETER_EXT                             = 0x8352,
    GL_PIXEL_GROUP_COLOR_SGIS                                     = 0x8356,
    GL_RGB_S3TC                                                   = 0x83A0,
    GL_RGB4_S3TC                                                  = 0x83A1,
    GL_RGBA_S3TC                                                  = 0x83A2,
    GL_RGBA4_S3TC                                                 = 0x83A3,
    GL_RGBA_DXT5_S3TC                                             = 0x83A4,
    GL_RGBA4_DXT5_S3TC                                            = 0x83A5,
    GL_PARALLEL_ARRAYS_INTEL                                      = 0x83F4,
    GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL                       = 0x83F5,
    GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL                       = 0x83F6,
    GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL                        = 0x83F7,
    GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL                = 0x83F8,
    GL_BLACKHOLE_RENDER_INTEL                                     = 0x83FC,
    GL_CONSERVATIVE_RASTERIZATION_INTEL                           = 0x83FE,
    GL_CURRENT_RASTER_NORMAL_SGIX                                 = 0x8406,
    GL_TANGENT_ARRAY_EXT                                          = 0x8439,
    GL_BINORMAL_ARRAY_EXT                                         = 0x843A,
    GL_CURRENT_TANGENT_EXT                                        = 0x843B,
    GL_CURRENT_BINORMAL_EXT                                       = 0x843C,
    GL_TANGENT_ARRAY_TYPE_EXT                                     = 0x843E,
    GL_TANGENT_ARRAY_STRIDE_EXT                                   = 0x843F,
    GL_BINORMAL_ARRAY_TYPE_EXT                                    = 0x8440,
    GL_BINORMAL_ARRAY_STRIDE_EXT                                  = 0x8441,
    GL_TANGENT_ARRAY_POINTER_EXT                                  = 0x8442,
    GL_BINORMAL_ARRAY_POINTER_EXT                                 = 0x8443,
    GL_MAP1_TANGENT_EXT                                           = 0x8444,
    GL_MAP2_TANGENT_EXT                                           = 0x8445,
    GL_MAP1_BINORMAL_EXT                                          = 0x8446,
    GL_MAP2_BINORMAL_EXT                                          = 0x8447,
    GL_FOG_COORDINATE_SOURCE                                      = 0x8450,
    GL_FOG_COORDINATE_SOURCE_EXT                                  = 0x8450,
    GL_CURRENT_FOG_COORDINATE                                     = 0x8453,
    GL_CURRENT_FOG_COORD                                          = 0x8453,
    GL_CURRENT_FOG_COORDINATE_EXT                                 = 0x8453,
    GL_FOG_COORDINATE_ARRAY_TYPE                                  = 0x8454,
    GL_FOG_COORDINATE_ARRAY_TYPE_EXT                              = 0x8454,
    GL_FOG_COORD_ARRAY_TYPE                                       = 0x8454,
    GL_FOG_COORDINATE_ARRAY_STRIDE                                = 0x8455,
    GL_FOG_COORDINATE_ARRAY_STRIDE_EXT                            = 0x8455,
    GL_FOG_COORD_ARRAY_STRIDE                                     = 0x8455,
    GL_FOG_COORDINATE_ARRAY_POINTER                               = 0x8456,
    GL_FOG_COORDINATE_ARRAY_POINTER_EXT                           = 0x8456,
    GL_FOG_COORD_ARRAY_POINTER                                    = 0x8456,
    GL_FOG_COORDINATE_ARRAY                                       = 0x8457,
    GL_FOG_COORDINATE_ARRAY_EXT                                   = 0x8457,
    GL_FOG_COORD_ARRAY                                            = 0x8457,
    GL_COLOR_SUM                                                  = 0x8458,
    GL_COLOR_SUM_ARB                                              = 0x8458,
    GL_COLOR_SUM_EXT                                              = 0x8458,
    GL_CURRENT_SECONDARY_COLOR                                    = 0x8459,
    GL_CURRENT_SECONDARY_COLOR_EXT                                = 0x8459,
    GL_SECONDARY_COLOR_ARRAY_SIZE                                 = 0x845A,
    GL_SECONDARY_COLOR_ARRAY_SIZE_EXT                             = 0x845A,
    GL_SECONDARY_COLOR_ARRAY_TYPE                                 = 0x845B,
    GL_SECONDARY_COLOR_ARRAY_TYPE_EXT                             = 0x845B,
    GL_SECONDARY_COLOR_ARRAY_STRIDE                               = 0x845C,
    GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT                           = 0x845C,
    GL_SECONDARY_COLOR_ARRAY_POINTER                              = 0x845D,
    GL_SECONDARY_COLOR_ARRAY_POINTER_EXT                          = 0x845D,
    GL_SECONDARY_COLOR_ARRAY                                      = 0x845E,
    GL_SECONDARY_COLOR_ARRAY_EXT                                  = 0x845E,
    GL_CURRENT_RASTER_SECONDARY_COLOR                             = 0x845F,
    GL_SCREEN_COORDINATES_REND                                    = 0x8490,
    GL_INVERTED_SCREEN_W_REND                                     = 0x8491,
    GL_TEXTURE2_ARB                                               = 0x84C2,
    GL_TEXTURE3_ARB                                               = 0x84C3,
    GL_TEXTURE4_ARB                                               = 0x84C4,
    GL_TEXTURE5_ARB                                               = 0x84C5,
    GL_TEXTURE6_ARB                                               = 0x84C6,
    GL_TEXTURE7_ARB                                               = 0x84C7,
    GL_TEXTURE8_ARB                                               = 0x84C8,
    GL_TEXTURE9_ARB                                               = 0x84C9,
    GL_TEXTURE10_ARB                                              = 0x84CA,
    GL_TEXTURE11_ARB                                              = 0x84CB,
    GL_TEXTURE12_ARB                                              = 0x84CC,
    GL_TEXTURE13_ARB                                              = 0x84CD,
    GL_TEXTURE14_ARB                                              = 0x84CE,
    GL_TEXTURE15_ARB                                              = 0x84CF,
    GL_TEXTURE16_ARB                                              = 0x84D0,
    GL_TEXTURE17_ARB                                              = 0x84D1,
    GL_TEXTURE18_ARB                                              = 0x84D2,
    GL_TEXTURE19_ARB                                              = 0x84D3,
    GL_TEXTURE20_ARB                                              = 0x84D4,
    GL_TEXTURE21_ARB                                              = 0x84D5,
    GL_TEXTURE22_ARB                                              = 0x84D6,
    GL_TEXTURE23_ARB                                              = 0x84D7,
    GL_TEXTURE24_ARB                                              = 0x84D8,
    GL_TEXTURE25_ARB                                              = 0x84D9,
    GL_TEXTURE26_ARB                                              = 0x84DA,
    GL_TEXTURE27_ARB                                              = 0x84DB,
    GL_TEXTURE28_ARB                                              = 0x84DC,
    GL_TEXTURE29_ARB                                              = 0x84DD,
    GL_TEXTURE30_ARB                                              = 0x84DE,
    GL_TEXTURE31_ARB                                              = 0x84DF,
    GL_ACTIVE_TEXTURE_ARB                                         = 0x84E0,
    GL_CLIENT_ACTIVE_TEXTURE                                      = 0x84E1,
    GL_CLIENT_ACTIVE_TEXTURE_ARB                                  = 0x84E1,
    GL_MAX_TEXTURE_UNITS                                          = 0x84E2,
    GL_MAX_TEXTURE_UNITS_ARB                                      = 0x84E2,
    GL_TRANSPOSE_MODELVIEW_MATRIX                                 = 0x84E3,
    GL_TRANSPOSE_MODELVIEW_MATRIX_ARB                             = 0x84E3,
    GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV                         = 0x84E3,
    GL_TRANSPOSE_PROJECTION_MATRIX                                = 0x84E4,
    GL_TRANSPOSE_PROJECTION_MATRIX_ARB                            = 0x84E4,
    GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV                        = 0x84E4,
    GL_TRANSPOSE_TEXTURE_MATRIX                                   = 0x84E5,
    GL_TRANSPOSE_TEXTURE_MATRIX_ARB                               = 0x84E5,
    GL_TRANSPOSE_COLOR_MATRIX                                     = 0x84E6,
    GL_TRANSPOSE_COLOR_MATRIX_ARB                                 = 0x84E6,
    GL_SUBTRACT                                                   = 0x84E7,
    GL_SUBTRACT_ARB                                               = 0x84E7,
    GL_MAX_RENDERBUFFER_SIZE_EXT                                  = 0x84E8,
    GL_COMPRESSED_ALPHA                                           = 0x84E9,
    GL_COMPRESSED_ALPHA_ARB                                       = 0x84E9,
    GL_COMPRESSED_LUMINANCE                                       = 0x84EA,
    GL_COMPRESSED_LUMINANCE_ARB                                   = 0x84EA,
    GL_COMPRESSED_LUMINANCE_ALPHA                                 = 0x84EB,
    GL_COMPRESSED_LUMINANCE_ALPHA_ARB                             = 0x84EB,
    GL_COMPRESSED_INTENSITY                                       = 0x84EC,
    GL_COMPRESSED_INTENSITY_ARB                                   = 0x84EC,
    GL_COMPRESSED_RGB_ARB                                         = 0x84ED,
    GL_COMPRESSED_RGBA_ARB                                        = 0x84EE,
    GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB                             = 0x84F8,
    GL_MAX_RECTANGLE_TEXTURE_SIZE_NV                              = 0x84F8,
    GL_MAX_TEXTURE_LOD_BIAS_EXT                                   = 0x84FD,
    GL_TEXTURE_MAX_ANISOTROPY_EXT                                 = 0x84FE,
    GL_MAX_TEXTURE_MAX_ANISOTROPY                                 = 0x84FF,
    GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT                             = 0x84FF,
    GL_TEXTURE_FILTER_CONTROL_EXT                                 = 0x8500,
    GL_TEXTURE_LOD_BIAS_EXT                                       = 0x8501,
    GL_MODELVIEW1_STACK_DEPTH_EXT                                 = 0x8502,
    GL_COMBINE4_NV                                                = 0x8503,
    GL_MAX_SHININESS_NV                                           = 0x8504,
    GL_MAX_SPOT_EXPONENT_NV                                       = 0x8505,
    GL_MODELVIEW1_MATRIX_EXT                                      = 0x8506,
    GL_INCR_WRAP_EXT                                              = 0x8507,
    GL_DECR_WRAP_EXT                                              = 0x8508,
    GL_VERTEX_WEIGHTING_EXT                                       = 0x8509,
    GL_MODELVIEW1_ARB                                             = 0x850A,
    GL_MODELVIEW1_EXT                                             = 0x850A,
    GL_CURRENT_VERTEX_WEIGHT_EXT                                  = 0x850B,
    GL_VERTEX_WEIGHT_ARRAY_EXT                                    = 0x850C,
    GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT                               = 0x850D,
    GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT                               = 0x850E,
    GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT                             = 0x850F,
    GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT                            = 0x8510,
    GL_VERTEX_ARRAY_RANGE_APPLE                                   = 0x851D,
    GL_VERTEX_ARRAY_RANGE_NV                                      = 0x851D,
    GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE                            = 0x851E,
    GL_VERTEX_ARRAY_RANGE_LENGTH_NV                               = 0x851E,
    GL_VERTEX_ARRAY_RANGE_VALID_NV                                = 0x851F,
    GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV                          = 0x8520,
    GL_VERTEX_ARRAY_RANGE_POINTER_APPLE                           = 0x8521,
    GL_VERTEX_ARRAY_RANGE_POINTER_NV                              = 0x8521,
    GL_REGISTER_COMBINERS_NV                                      = 0x8522,
    GL_CONSTANT_COLOR0_NV                                         = 0x852A,
    GL_CONSTANT_COLOR1_NV                                         = 0x852B,
    GL_E_TIMES_F_NV                                               = 0x8531,
    GL_SPARE0_PLUS_SECONDARY_COLOR_NV                             = 0x8532,
    GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV                        = 0x8533,
    GL_PER_STAGE_CONSTANTS_NV                                     = 0x8535,
    GL_COMBINER_AB_DOT_PRODUCT_NV                                 = 0x8545,
    GL_COMBINER_CD_DOT_PRODUCT_NV                                 = 0x8546,
    GL_COMBINER_MUX_SUM_NV                                        = 0x8547,
    GL_COMBINER_SCALE_NV                                          = 0x8548,
    GL_COMBINER_BIAS_NV                                           = 0x8549,
    GL_COMBINER_AB_OUTPUT_NV                                      = 0x854A,
    GL_COMBINER_CD_OUTPUT_NV                                      = 0x854B,
    GL_COMBINER_SUM_OUTPUT_NV                                     = 0x854C,
    GL_MAX_GENERAL_COMBINERS_NV                                   = 0x854D,
    GL_NUM_GENERAL_COMBINERS_NV                                   = 0x854E,
    GL_COLOR_SUM_CLAMP_NV                                         = 0x854F,
    GL_PRIMITIVE_RESTART_NV                                       = 0x8558,
    GL_PRIMITIVE_RESTART_INDEX_NV                                 = 0x8559,
    GL_FOG_DISTANCE_MODE_NV                                       = 0x855A,
    GL_EYE_RADIAL_NV                                              = 0x855B,
    GL_EYE_PLANE_ABSOLUTE_NV                                      = 0x855C,
    GL_EMBOSS_LIGHT_NV                                            = 0x855D,
    GL_EMBOSS_CONSTANT_NV                                         = 0x855E,
    GL_EMBOSS_MAP_NV                                              = 0x855F,
    GL_RED_MIN_CLAMP_INGR                                         = 0x8560,
    GL_GREEN_MIN_CLAMP_INGR                                       = 0x8561,
    GL_BLUE_MIN_CLAMP_INGR                                        = 0x8562,
    GL_ALPHA_MIN_CLAMP_INGR                                       = 0x8563,
    GL_RED_MAX_CLAMP_INGR                                         = 0x8564,
    GL_GREEN_MAX_CLAMP_INGR                                       = 0x8565,
    GL_BLUE_MAX_CLAMP_INGR                                        = 0x8566,
    GL_ALPHA_MAX_CLAMP_INGR                                       = 0x8567,
    GL_INTERLACE_READ_INGR                                        = 0x8568,
    GL_TEXTURE_NORMAL_EXT                                         = 0x85AF,
    GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE                          = 0x85B0,
    GL_UNPACK_CLIENT_STORAGE_APPLE                                = 0x85B2,
    GL_BUFFER_OBJECT_APPLE                                        = 0x85B3,
    GL_VERTEX_ARRAY_BINDING_APPLE                                 = 0x85B5,
    GL_TEXTURE_RANGE_LENGTH_APPLE                                 = 0x85B7,
    GL_TEXTURE_RANGE_POINTER_APPLE                                = 0x85B8,
    GL_YCBCR_422_APPLE                                            = 0x85B9,
    GL_UNSIGNED_SHORT_8_8_APPLE                                   = 0x85BA,
    GL_UNSIGNED_SHORT_8_8_MESA                                    = 0x85BA,
    GL_UNSIGNED_SHORT_8_8_REV_APPLE                               = 0x85BB,
    GL_UNSIGNED_SHORT_8_8_REV_MESA                                = 0x85BB,
    GL_STORAGE_PRIVATE_APPLE                                      = 0x85BD,
    GL_REPLACEMENT_CODE_ARRAY_SUN                                 = 0x85C0,
    GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN                            = 0x85C1,
    GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN                          = 0x85C2,
    GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN                         = 0x85C3,
    GL_R1UI_V3F_SUN                                               = 0x85C4,
    GL_R1UI_C4UB_V3F_SUN                                          = 0x85C5,
    GL_R1UI_C3F_V3F_SUN                                           = 0x85C6,
    GL_R1UI_N3F_V3F_SUN                                           = 0x85C7,
    GL_R1UI_C4F_N3F_V3F_SUN                                       = 0x85C8,
    GL_R1UI_T2F_V3F_SUN                                           = 0x85C9,
    GL_R1UI_T2F_N3F_V3F_SUN                                       = 0x85CA,
    GL_R1UI_T2F_C4F_N3F_V3F_SUN                                   = 0x85CB,
    GL_SLICE_ACCUM_SUN                                            = 0x85CC,
    GL_QUAD_MESH_SUN                                              = 0x8614,
    GL_TRIANGLE_MESH_SUN                                          = 0x8615,
    GL_VERTEX_PROGRAM_NV                                          = 0x8620,
    GL_VERTEX_STATE_PROGRAM_NV                                    = 0x8621,
    GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB                            = 0x8622,
    GL_ATTRIB_ARRAY_SIZE_NV                                       = 0x8623,
    GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB                               = 0x8623,
    GL_ATTRIB_ARRAY_STRIDE_NV                                     = 0x8624,
    GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB                             = 0x8624,
    GL_ATTRIB_ARRAY_TYPE_NV                                       = 0x8625,
    GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB                               = 0x8625,
    GL_CURRENT_ATTRIB_NV                                          = 0x8626,
    GL_CURRENT_VERTEX_ATTRIB_ARB                                  = 0x8626,
    GL_PROGRAM_LENGTH_ARB                                         = 0x8627,
    GL_PROGRAM_LENGTH_NV                                          = 0x8627,
    GL_PROGRAM_STRING_NV                                          = 0x8628,
    GL_MODELVIEW_PROJECTION_NV                                    = 0x8629,
    GL_IDENTITY_NV                                                = 0x862A,
    GL_INVERSE_NV                                                 = 0x862B,
    GL_TRANSPOSE_NV                                               = 0x862C,
    GL_INVERSE_TRANSPOSE_NV                                       = 0x862D,
    GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB                         = 0x862E,
    GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV                            = 0x862E,
    GL_MAX_PROGRAM_MATRICES_ARB                                   = 0x862F,
    GL_MAX_TRACK_MATRICES_NV                                      = 0x862F,
    GL_MATRIX0_NV                                                 = 0x8630,
    GL_MATRIX1_NV                                                 = 0x8631,
    GL_MATRIX2_NV                                                 = 0x8632,
    GL_MATRIX3_NV                                                 = 0x8633,
    GL_MATRIX4_NV                                                 = 0x8634,
    GL_MATRIX5_NV                                                 = 0x8635,
    GL_MATRIX6_NV                                                 = 0x8636,
    GL_MATRIX7_NV                                                 = 0x8637,
    GL_CURRENT_MATRIX_STACK_DEPTH_ARB                             = 0x8640,
    GL_CURRENT_MATRIX_STACK_DEPTH_NV                              = 0x8640,
    GL_CURRENT_MATRIX_ARB                                         = 0x8641,
    GL_CURRENT_MATRIX_NV                                          = 0x8641,
    GL_VERTEX_PROGRAM_POINT_SIZE                                  = 0x8642,
    GL_VERTEX_PROGRAM_POINT_SIZE_ARB                              = 0x8642,
    GL_VERTEX_PROGRAM_POINT_SIZE_NV                               = 0x8642,
    GL_PROGRAM_POINT_SIZE_ARB                                     = 0x8642,
    GL_PROGRAM_POINT_SIZE_EXT                                     = 0x8642,
    GL_VERTEX_PROGRAM_TWO_SIDE                                    = 0x8643,
    GL_VERTEX_PROGRAM_TWO_SIDE_ARB                                = 0x8643,
    GL_VERTEX_PROGRAM_TWO_SIDE_NV                                 = 0x8643,
    GL_ATTRIB_ARRAY_POINTER_NV                                    = 0x8645,
    GL_PROGRAM_TARGET_NV                                          = 0x8646,
    GL_PROGRAM_RESIDENT_NV                                        = 0x8647,
    GL_TRACK_MATRIX_NV                                            = 0x8648,
    GL_TRACK_MATRIX_TRANSFORM_NV                                  = 0x8649,
    GL_VERTEX_PROGRAM_BINDING_NV                                  = 0x864A,
    GL_PROGRAM_ERROR_POSITION_ARB                                 = 0x864B,
    GL_PROGRAM_ERROR_POSITION_NV                                  = 0x864B,
    GL_OFFSET_TEXTURE_RECTANGLE_NV                                = 0x864C,
    GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV                          = 0x864D,
    GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV                           = 0x864E,
    GL_DEPTH_CLAMP_NV                                             = 0x864F,
    GL_VERTEX_ATTRIB_ARRAY0_NV                                    = 0x8650,
    GL_VERTEX_ATTRIB_ARRAY1_NV                                    = 0x8651,
    GL_VERTEX_ATTRIB_ARRAY2_NV                                    = 0x8652,
    GL_VERTEX_ATTRIB_ARRAY3_NV                                    = 0x8653,
    GL_VERTEX_ATTRIB_ARRAY4_NV                                    = 0x8654,
    GL_VERTEX_ATTRIB_ARRAY5_NV                                    = 0x8655,
    GL_VERTEX_ATTRIB_ARRAY6_NV                                    = 0x8656,
    GL_VERTEX_ATTRIB_ARRAY7_NV                                    = 0x8657,
    GL_VERTEX_ATTRIB_ARRAY8_NV                                    = 0x8658,
    GL_VERTEX_ATTRIB_ARRAY9_NV                                    = 0x8659,
    GL_VERTEX_ATTRIB_ARRAY10_NV                                   = 0x865A,
    GL_VERTEX_ATTRIB_ARRAY11_NV                                   = 0x865B,
    GL_VERTEX_ATTRIB_ARRAY12_NV                                   = 0x865C,
    GL_VERTEX_ATTRIB_ARRAY13_NV                                   = 0x865D,
    GL_VERTEX_ATTRIB_ARRAY14_NV                                   = 0x865E,
    GL_VERTEX_ATTRIB_ARRAY15_NV                                   = 0x865F,
    GL_MAP1_VERTEX_ATTRIB0_4_NV                                   = 0x8660,
    GL_MAP1_VERTEX_ATTRIB1_4_NV                                   = 0x8661,
    GL_MAP1_VERTEX_ATTRIB2_4_NV                                   = 0x8662,
    GL_MAP1_VERTEX_ATTRIB3_4_NV                                   = 0x8663,
    GL_MAP1_VERTEX_ATTRIB4_4_NV                                   = 0x8664,
    GL_MAP1_VERTEX_ATTRIB5_4_NV                                   = 0x8665,
    GL_MAP1_VERTEX_ATTRIB6_4_NV                                   = 0x8666,
    GL_MAP1_VERTEX_ATTRIB7_4_NV                                   = 0x8667,
    GL_MAP1_VERTEX_ATTRIB8_4_NV                                   = 0x8668,
    GL_MAP1_VERTEX_ATTRIB9_4_NV                                   = 0x8669,
    GL_MAP1_VERTEX_ATTRIB10_4_NV                                  = 0x866A,
    GL_MAP1_VERTEX_ATTRIB11_4_NV                                  = 0x866B,
    GL_MAP1_VERTEX_ATTRIB12_4_NV                                  = 0x866C,
    GL_MAP1_VERTEX_ATTRIB13_4_NV                                  = 0x866D,
    GL_MAP1_VERTEX_ATTRIB14_4_NV                                  = 0x866E,
    GL_MAP1_VERTEX_ATTRIB15_4_NV                                  = 0x866F,
    GL_MAP2_VERTEX_ATTRIB0_4_NV                                   = 0x8670,
    GL_MAP2_VERTEX_ATTRIB1_4_NV                                   = 0x8671,
    GL_MAP2_VERTEX_ATTRIB2_4_NV                                   = 0x8672,
    GL_MAP2_VERTEX_ATTRIB3_4_NV                                   = 0x8673,
    GL_MAP2_VERTEX_ATTRIB4_4_NV                                   = 0x8674,
    GL_MAP2_VERTEX_ATTRIB5_4_NV                                   = 0x8675,
    GL_MAP2_VERTEX_ATTRIB6_4_NV                                   = 0x8676,
    GL_MAP2_VERTEX_ATTRIB7_4_NV                                   = 0x8677,
    GL_PROGRAM_BINDING_ARB                                        = 0x8677,
    GL_MAP2_VERTEX_ATTRIB8_4_NV                                   = 0x8678,
    GL_MAP2_VERTEX_ATTRIB9_4_NV                                   = 0x8679,
    GL_MAP2_VERTEX_ATTRIB10_4_NV                                  = 0x867A,
    GL_MAP2_VERTEX_ATTRIB11_4_NV                                  = 0x867B,
    GL_MAP2_VERTEX_ATTRIB12_4_NV                                  = 0x867C,
    GL_MAP2_VERTEX_ATTRIB13_4_NV                                  = 0x867D,
    GL_MAP2_VERTEX_ATTRIB14_4_NV                                  = 0x867E,
    GL_MAP2_VERTEX_ATTRIB15_4_NV                                  = 0x867F,
    GL_TEXTURE_COMPRESSED_IMAGE_SIZE                              = 0x86A0,
    GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB                          = 0x86A0,
    GL_TEXTURE_COMPRESSED_ARB                                     = 0x86A1,
    GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB                         = 0x86A2,
    GL_COMPRESSED_TEXTURE_FORMATS_ARB                             = 0x86A3,
    GL_MAX_VERTEX_UNITS_ARB                                       = 0x86A4,
    GL_ACTIVE_VERTEX_UNITS_ARB                                    = 0x86A5,
    GL_WEIGHT_SUM_UNITY_ARB                                       = 0x86A6,
    GL_VERTEX_BLEND_ARB                                           = 0x86A7,
    GL_CURRENT_WEIGHT_ARB                                         = 0x86A8,
    GL_WEIGHT_ARRAY_TYPE_ARB                                      = 0x86A9,
    GL_WEIGHT_ARRAY_STRIDE_ARB                                    = 0x86AA,
    GL_WEIGHT_ARRAY_SIZE_ARB                                      = 0x86AB,
    GL_WEIGHT_ARRAY_POINTER_ARB                                   = 0x86AC,
    GL_WEIGHT_ARRAY_ARB                                           = 0x86AD,
    GL_DOT3_RGB                                                   = 0x86AE,
    GL_DOT3_RGB_ARB                                               = 0x86AE,
    GL_DOT3_RGBA                                                  = 0x86AF,
    GL_DOT3_RGBA_ARB                                              = 0x86AF,
    GL_COMPRESSED_RGB_FXT1_3DFX                                   = 0x86B0,
    GL_COMPRESSED_RGBA_FXT1_3DFX                                  = 0x86B1,
    GL_MULTISAMPLE_3DFX                                           = 0x86B2,
    GL_SAMPLE_BUFFERS_3DFX                                        = 0x86B3,
    GL_SAMPLES_3DFX                                               = 0x86B4,
    GL_EVAL_FRACTIONAL_TESSELLATION_NV                            = 0x86C5,
    GL_EVAL_VERTEX_ATTRIB0_NV                                     = 0x86C6,
    GL_EVAL_VERTEX_ATTRIB1_NV                                     = 0x86C7,
    GL_EVAL_VERTEX_ATTRIB2_NV                                     = 0x86C8,
    GL_EVAL_VERTEX_ATTRIB3_NV                                     = 0x86C9,
    GL_EVAL_VERTEX_ATTRIB4_NV                                     = 0x86CA,
    GL_EVAL_VERTEX_ATTRIB5_NV                                     = 0x86CB,
    GL_EVAL_VERTEX_ATTRIB6_NV                                     = 0x86CC,
    GL_EVAL_VERTEX_ATTRIB7_NV                                     = 0x86CD,
    GL_EVAL_VERTEX_ATTRIB8_NV                                     = 0x86CE,
    GL_EVAL_VERTEX_ATTRIB9_NV                                     = 0x86CF,
    GL_EVAL_VERTEX_ATTRIB10_NV                                    = 0x86D0,
    GL_EVAL_VERTEX_ATTRIB11_NV                                    = 0x86D1,
    GL_EVAL_VERTEX_ATTRIB12_NV                                    = 0x86D2,
    GL_EVAL_VERTEX_ATTRIB13_NV                                    = 0x86D3,
    GL_EVAL_VERTEX_ATTRIB14_NV                                    = 0x86D4,
    GL_EVAL_VERTEX_ATTRIB15_NV                                    = 0x86D5,
    GL_MAX_MAP_TESSELLATION_NV                                    = 0x86D6,
    GL_MAX_RATIONAL_EVAL_ORDER_NV                                 = 0x86D7,
    GL_MAX_PROGRAM_PATCH_ATTRIBS_NV                               = 0x86D8,
    GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV                       = 0x86D9,
    GL_UNSIGNED_INT_S8_S8_8_8_NV                                  = 0x86DA,
    GL_UNSIGNED_INT_8_8_S8_S8_REV_NV                              = 0x86DB,
    GL_DSDT_MAG_INTENSITY_NV                                      = 0x86DC,
    GL_SHADER_CONSISTENT_NV                                       = 0x86DD,
    GL_TEXTURE_SHADER_NV                                          = 0x86DE,
    GL_SHADER_OPERATION_NV                                        = 0x86DF,
    GL_CULL_MODES_NV                                              = 0x86E0,
    GL_OFFSET_TEXTURE_MATRIX_NV                                   = 0x86E1,
    GL_OFFSET_TEXTURE_2D_MATRIX_NV                                = 0x86E1,
    GL_OFFSET_TEXTURE_SCALE_NV                                    = 0x86E2,
    GL_OFFSET_TEXTURE_2D_SCALE_NV                                 = 0x86E2,
    GL_OFFSET_TEXTURE_BIAS_NV                                     = 0x86E3,
    GL_OFFSET_TEXTURE_2D_BIAS_NV                                  = 0x86E3,
    GL_PREVIOUS_TEXTURE_INPUT_NV                                  = 0x86E4,
    GL_CONST_EYE_NV                                               = 0x86E5,
    GL_PASS_THROUGH_NV                                            = 0x86E6,
    GL_CULL_FRAGMENT_NV                                           = 0x86E7,
    GL_OFFSET_TEXTURE_2D_NV                                       = 0x86E8,
    GL_DEPENDENT_AR_TEXTURE_2D_NV                                 = 0x86E9,
    GL_DEPENDENT_GB_TEXTURE_2D_NV                                 = 0x86EA,
    GL_SURFACE_STATE_NV                                           = 0x86EB,
    GL_DOT_PRODUCT_NV                                             = 0x86EC,
    GL_DOT_PRODUCT_DEPTH_REPLACE_NV                               = 0x86ED,
    GL_DOT_PRODUCT_TEXTURE_2D_NV                                  = 0x86EE,
    GL_DOT_PRODUCT_TEXTURE_3D_NV                                  = 0x86EF,
    GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV                            = 0x86F0,
    GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV                            = 0x86F1,
    GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV                            = 0x86F2,
    GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV                  = 0x86F3,
    GL_HILO_NV                                                    = 0x86F4,
    GL_DSDT_NV                                                    = 0x86F5,
    GL_DSDT_MAG_NV                                                = 0x86F6,
    GL_DSDT_MAG_VIB_NV                                            = 0x86F7,
    GL_HILO16_NV                                                  = 0x86F8,
    GL_SIGNED_HILO_NV                                             = 0x86F9,
    GL_SIGNED_HILO16_NV                                           = 0x86FA,
    GL_SIGNED_RGBA_NV                                             = 0x86FB,
    GL_SIGNED_RGBA8_NV                                            = 0x86FC,
    GL_SURFACE_REGISTERED_NV                                      = 0x86FD,
    GL_SIGNED_RGB_NV                                              = 0x86FE,
    GL_SIGNED_RGB8_NV                                             = 0x86FF,
    GL_SURFACE_MAPPED_NV                                          = 0x8700,
    GL_SIGNED_LUMINANCE_NV                                        = 0x8701,
    GL_SIGNED_LUMINANCE8_NV                                       = 0x8702,
    GL_SIGNED_LUMINANCE_ALPHA_NV                                  = 0x8703,
    GL_SIGNED_LUMINANCE8_ALPHA8_NV                                = 0x8704,
    GL_SIGNED_ALPHA_NV                                            = 0x8705,
    GL_SIGNED_ALPHA8_NV                                           = 0x8706,
    GL_SIGNED_INTENSITY_NV                                        = 0x8707,
    GL_SIGNED_INTENSITY8_NV                                       = 0x8708,
    GL_DSDT8_NV                                                   = 0x8709,
    GL_DSDT8_MAG8_NV                                              = 0x870A,
    GL_DSDT8_MAG8_INTENSITY8_NV                                   = 0x870B,
    GL_SIGNED_RGB_UNSIGNED_ALPHA_NV                               = 0x870C,
    GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV                             = 0x870D,
    GL_HI_SCALE_NV                                                = 0x870E,
    GL_LO_SCALE_NV                                                = 0x870F,
    GL_DS_SCALE_NV                                                = 0x8710,
    GL_DT_SCALE_NV                                                = 0x8711,
    GL_MAGNITUDE_SCALE_NV                                         = 0x8712,
    GL_VIBRANCE_SCALE_NV                                          = 0x8713,
    GL_HI_BIAS_NV                                                 = 0x8714,
    GL_LO_BIAS_NV                                                 = 0x8715,
    GL_DS_BIAS_NV                                                 = 0x8716,
    GL_DT_BIAS_NV                                                 = 0x8717,
    GL_MAGNITUDE_BIAS_NV                                          = 0x8718,
    GL_VIBRANCE_BIAS_NV                                           = 0x8719,
    GL_TEXTURE_BORDER_VALUES_NV                                   = 0x871A,
    GL_TEXTURE_HI_SIZE_NV                                         = 0x871B,
    GL_TEXTURE_LO_SIZE_NV                                         = 0x871C,
    GL_TEXTURE_DS_SIZE_NV                                         = 0x871D,
    GL_TEXTURE_DT_SIZE_NV                                         = 0x871E,
    GL_TEXTURE_MAG_SIZE_NV                                        = 0x871F,
    GL_MODELVIEW2_ARB                                             = 0x8722,
    GL_MODELVIEW3_ARB                                             = 0x8723,
    GL_MODELVIEW4_ARB                                             = 0x8724,
    GL_MODELVIEW5_ARB                                             = 0x8725,
    GL_MODELVIEW6_ARB                                             = 0x8726,
    GL_MODELVIEW7_ARB                                             = 0x8727,
    GL_MODELVIEW8_ARB                                             = 0x8728,
    GL_MODELVIEW9_ARB                                             = 0x8729,
    GL_MODELVIEW10_ARB                                            = 0x872A,
    GL_MODELVIEW11_ARB                                            = 0x872B,
    GL_MODELVIEW12_ARB                                            = 0x872C,
    GL_MODELVIEW13_ARB                                            = 0x872D,
    GL_MODELVIEW14_ARB                                            = 0x872E,
    GL_MODELVIEW15_ARB                                            = 0x872F,
    GL_MODELVIEW16_ARB                                            = 0x8730,
    GL_MODELVIEW17_ARB                                            = 0x8731,
    GL_MODELVIEW18_ARB                                            = 0x8732,
    GL_MODELVIEW19_ARB                                            = 0x8733,
    GL_MODELVIEW20_ARB                                            = 0x8734,
    GL_MODELVIEW21_ARB                                            = 0x8735,
    GL_MODELVIEW22_ARB                                            = 0x8736,
    GL_MODELVIEW23_ARB                                            = 0x8737,
    GL_MODELVIEW24_ARB                                            = 0x8738,
    GL_MODELVIEW25_ARB                                            = 0x8739,
    GL_MODELVIEW26_ARB                                            = 0x873A,
    GL_MODELVIEW27_ARB                                            = 0x873B,
    GL_MODELVIEW28_ARB                                            = 0x873C,
    GL_MODELVIEW29_ARB                                            = 0x873D,
    GL_MODELVIEW30_ARB                                            = 0x873E,
    GL_MODELVIEW31_ARB                                            = 0x873F,
    GL_DOT3_RGB_EXT                                               = 0x8740,
    GL_DOT3_RGBA_EXT                                              = 0x8741,
    GL_MIRROR_CLAMP_ATI                                           = 0x8742,
    GL_MIRROR_CLAMP_EXT                                           = 0x8742,
    GL_MIRROR_CLAMP_TO_EDGE                                       = 0x8743,
    GL_MIRROR_CLAMP_TO_EDGE_ATI                                   = 0x8743,
    GL_MIRROR_CLAMP_TO_EDGE_EXT                                   = 0x8743,
    GL_MODULATE_ADD_ATI                                           = 0x8744,
    GL_MODULATE_SIGNED_ADD_ATI                                    = 0x8745,
    GL_MODULATE_SUBTRACT_ATI                                      = 0x8746,
    GL_SET_AMD                                                    = 0x874A,
    GL_REPLACE_VALUE_AMD                                          = 0x874B,
    GL_STENCIL_OP_VALUE_AMD                                       = 0x874C,
    GL_STENCIL_BACK_OP_VALUE_AMD                                  = 0x874D,
    GL_OCCLUSION_QUERY_EVENT_MASK_AMD                             = 0x874F,
    GL_YCBCR_MESA                                                 = 0x8757,
    GL_PACK_INVERT_MESA                                           = 0x8758,
    GL_TEXTURE_1D_STACK_MESAX                                     = 0x8759,
    GL_TEXTURE_2D_STACK_MESAX                                     = 0x875A,
    GL_PROXY_TEXTURE_1D_STACK_MESAX                               = 0x875B,
    GL_PROXY_TEXTURE_2D_STACK_MESAX                               = 0x875C,
    GL_TEXTURE_1D_STACK_BINDING_MESAX                             = 0x875D,
    GL_TEXTURE_2D_STACK_BINDING_MESAX                             = 0x875E,
    GL_PROGRAM_BINARY_FORMAT_MESA                                 = 0x875F,
    GL_ARRAY_OBJECT_BUFFER_ATI                                    = 0x8766,
    GL_ARRAY_OBJECT_OFFSET_ATI                                    = 0x8767,
    GL_ELEMENT_ARRAY_ATI                                          = 0x8768,
    GL_ELEMENT_ARRAY_TYPE_ATI                                     = 0x8769,
    GL_ELEMENT_ARRAY_POINTER_ATI                                  = 0x876A,
    GL_MAX_VERTEX_STREAMS_ATI                                     = 0x876B,
    GL_VERTEX_SOURCE_ATI                                          = 0x8774,
    GL_DUDV_ATI                                                   = 0x8779,
    GL_DU8DV8_ATI                                                 = 0x877A,
    GL_BUMP_ENVMAP_ATI                                            = 0x877B,
    GL_BUMP_TARGET_ATI                                            = 0x877C,
    GL_VERTEX_SHADER_EXT                                          = 0x8780,
    GL_VERTEX_SHADER_BINDING_EXT                                  = 0x8781,
    GL_OUTPUT_VERTEX_EXT                                          = 0x879A,
    GL_OUTPUT_COLOR0_EXT                                          = 0x879B,
    GL_OUTPUT_COLOR1_EXT                                          = 0x879C,
    GL_OUTPUT_TEXTURE_COORD0_EXT                                  = 0x879D,
    GL_OUTPUT_TEXTURE_COORD1_EXT                                  = 0x879E,
    GL_OUTPUT_TEXTURE_COORD2_EXT                                  = 0x879F,
    GL_OUTPUT_TEXTURE_COORD3_EXT                                  = 0x87A0,
    GL_OUTPUT_TEXTURE_COORD4_EXT                                  = 0x87A1,
    GL_OUTPUT_TEXTURE_COORD5_EXT                                  = 0x87A2,
    GL_OUTPUT_TEXTURE_COORD6_EXT                                  = 0x87A3,
    GL_OUTPUT_TEXTURE_COORD7_EXT                                  = 0x87A4,
    GL_OUTPUT_TEXTURE_COORD8_EXT                                  = 0x87A5,
    GL_OUTPUT_TEXTURE_COORD9_EXT                                  = 0x87A6,
    GL_OUTPUT_TEXTURE_COORD10_EXT                                 = 0x87A7,
    GL_OUTPUT_TEXTURE_COORD11_EXT                                 = 0x87A8,
    GL_OUTPUT_TEXTURE_COORD12_EXT                                 = 0x87A9,
    GL_OUTPUT_TEXTURE_COORD13_EXT                                 = 0x87AA,
    GL_OUTPUT_TEXTURE_COORD14_EXT                                 = 0x87AB,
    GL_OUTPUT_TEXTURE_COORD15_EXT                                 = 0x87AC,
    GL_OUTPUT_TEXTURE_COORD16_EXT                                 = 0x87AD,
    GL_OUTPUT_TEXTURE_COORD17_EXT                                 = 0x87AE,
    GL_OUTPUT_TEXTURE_COORD18_EXT                                 = 0x87AF,
    GL_OUTPUT_TEXTURE_COORD19_EXT                                 = 0x87B0,
    GL_OUTPUT_TEXTURE_COORD20_EXT                                 = 0x87B1,
    GL_OUTPUT_TEXTURE_COORD21_EXT                                 = 0x87B2,
    GL_OUTPUT_TEXTURE_COORD22_EXT                                 = 0x87B3,
    GL_OUTPUT_TEXTURE_COORD23_EXT                                 = 0x87B4,
    GL_OUTPUT_TEXTURE_COORD24_EXT                                 = 0x87B5,
    GL_OUTPUT_TEXTURE_COORD25_EXT                                 = 0x87B6,
    GL_OUTPUT_TEXTURE_COORD26_EXT                                 = 0x87B7,
    GL_OUTPUT_TEXTURE_COORD27_EXT                                 = 0x87B8,
    GL_OUTPUT_TEXTURE_COORD28_EXT                                 = 0x87B9,
    GL_OUTPUT_TEXTURE_COORD29_EXT                                 = 0x87BA,
    GL_OUTPUT_TEXTURE_COORD30_EXT                                 = 0x87BB,
    GL_OUTPUT_TEXTURE_COORD31_EXT                                 = 0x87BC,
    GL_OUTPUT_FOG_EXT                                             = 0x87BD,
    GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT                         = 0x87C5,
    GL_MAX_VERTEX_SHADER_VARIANTS_EXT                             = 0x87C6,
    GL_MAX_VERTEX_SHADER_INVARIANTS_EXT                           = 0x87C7,
    GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT                      = 0x87C8,
    GL_MAX_VERTEX_SHADER_LOCALS_EXT                               = 0x87C9,
    GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT               = 0x87CA,
    GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT                   = 0x87CB,
    GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT            = 0x87CC,
    GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT                 = 0x87CD,
    GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT                     = 0x87CE,
    GL_VERTEX_SHADER_INSTRUCTIONS_EXT                             = 0x87CF,
    GL_VERTEX_SHADER_VARIANTS_EXT                                 = 0x87D0,
    GL_VERTEX_SHADER_INVARIANTS_EXT                               = 0x87D1,
    GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT                          = 0x87D2,
    GL_VERTEX_SHADER_LOCALS_EXT                                   = 0x87D3,
    GL_VERTEX_SHADER_OPTIMIZED_EXT                                = 0x87D4,
    GL_VARIANT_ARRAY_POINTER_EXT                                  = 0x87E9,
    GL_INVARIANT_VALUE_EXT                                        = 0x87EA,
    GL_INVARIANT_DATATYPE_EXT                                     = 0x87EB,
    GL_LOCAL_CONSTANT_VALUE_EXT                                   = 0x87EC,
    GL_LOCAL_CONSTANT_DATATYPE_EXT                                = 0x87ED,
    GL_PN_TRIANGLES_ATI                                           = 0x87F0,
    GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI                     = 0x87F1,
    GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI                         = 0x87F5,
    GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI                          = 0x87F6,
    GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI                        = 0x87F7,
    GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI                     = 0x87F8,
    GL_VBO_FREE_MEMORY_ATI                                        = 0x87FB,
    GL_TEXTURE_FREE_MEMORY_ATI                                    = 0x87FC,
    GL_RENDERBUFFER_FREE_MEMORY_ATI                               = 0x87FD,
    GL_STENCIL_BACK_FUNC_ATI                                      = 0x8800,
    GL_STENCIL_BACK_FAIL_ATI                                      = 0x8801,
    GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI                           = 0x8802,
    GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI                           = 0x8803,
    GL_PROGRAM_ALU_INSTRUCTIONS_ARB                               = 0x8805,
    GL_PROGRAM_TEX_INSTRUCTIONS_ARB                               = 0x8806,
    GL_PROGRAM_TEX_INDIRECTIONS_ARB                               = 0x8807,
    GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB                        = 0x8808,
    GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB                        = 0x8809,
    GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB                        = 0x880A,
    GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB                           = 0x880B,
    GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB                           = 0x880C,
    GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB                           = 0x880D,
    GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB                    = 0x880E,
    GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB                    = 0x880F,
    GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB                    = 0x8810,
    GL_RGBA_FLOAT32_APPLE                                         = 0x8814,
    GL_RGBA_FLOAT32_ATI                                           = 0x8814,
    GL_RGB_FLOAT32_APPLE                                          = 0x8815,
    GL_RGB_FLOAT32_ATI                                            = 0x8815,
    GL_ALPHA32F_ARB                                               = 0x8816,
    GL_ALPHA32F_EXT                                               = 0x8816,
    GL_ALPHA_FLOAT32_APPLE                                        = 0x8816,
    GL_ALPHA_FLOAT32_ATI                                          = 0x8816,
    GL_INTENSITY32F_ARB                                           = 0x8817,
    GL_INTENSITY_FLOAT32_APPLE                                    = 0x8817,
    GL_INTENSITY_FLOAT32_ATI                                      = 0x8817,
    GL_LUMINANCE32F_ARB                                           = 0x8818,
    GL_LUMINANCE32F_EXT                                           = 0x8818,
    GL_LUMINANCE_FLOAT32_APPLE                                    = 0x8818,
    GL_LUMINANCE_FLOAT32_ATI                                      = 0x8818,
    GL_LUMINANCE_ALPHA32F_ARB                                     = 0x8819,
    GL_LUMINANCE_ALPHA32F_EXT                                     = 0x8819,
    GL_LUMINANCE_ALPHA_FLOAT32_APPLE                              = 0x8819,
    GL_LUMINANCE_ALPHA_FLOAT32_ATI                                = 0x8819,
    GL_RGBA_FLOAT16_APPLE                                         = 0x881A,
    GL_RGBA_FLOAT16_ATI                                           = 0x881A,
    GL_RGB_FLOAT16_APPLE                                          = 0x881B,
    GL_RGB_FLOAT16_ATI                                            = 0x881B,
    GL_ALPHA16F_ARB                                               = 0x881C,
    GL_ALPHA16F_EXT                                               = 0x881C,
    GL_ALPHA_FLOAT16_APPLE                                        = 0x881C,
    GL_ALPHA_FLOAT16_ATI                                          = 0x881C,
    GL_INTENSITY16F_ARB                                           = 0x881D,
    GL_INTENSITY_FLOAT16_APPLE                                    = 0x881D,
    GL_INTENSITY_FLOAT16_ATI                                      = 0x881D,
    GL_LUMINANCE16F_ARB                                           = 0x881E,
    GL_LUMINANCE16F_EXT                                           = 0x881E,
    GL_LUMINANCE_FLOAT16_APPLE                                    = 0x881E,
    GL_LUMINANCE_FLOAT16_ATI                                      = 0x881E,
    GL_LUMINANCE_ALPHA16F_ARB                                     = 0x881F,
    GL_LUMINANCE_ALPHA16F_EXT                                     = 0x881F,
    GL_LUMINANCE_ALPHA_FLOAT16_APPLE                              = 0x881F,
    GL_LUMINANCE_ALPHA_FLOAT16_ATI                                = 0x881F,
    GL_RGBA_FLOAT_MODE_ARB                                        = 0x8820,
    GL_RGBA_FLOAT_MODE_ATI                                        = 0x8820,
    GL_MAX_DRAW_BUFFERS_ARB                                       = 0x8824,
    GL_MAX_DRAW_BUFFERS_ATI                                       = 0x8824,
    GL_DRAW_BUFFER0                                               = 0x8825,
    GL_DRAW_BUFFER0_ARB                                           = 0x8825,
    GL_DRAW_BUFFER0_ATI                                           = 0x8825,
    GL_DRAW_BUFFER1                                               = 0x8826,
    GL_DRAW_BUFFER1_ARB                                           = 0x8826,
    GL_DRAW_BUFFER1_ATI                                           = 0x8826,
    GL_DRAW_BUFFER2                                               = 0x8827,
    GL_DRAW_BUFFER2_ARB                                           = 0x8827,
    GL_DRAW_BUFFER2_ATI                                           = 0x8827,
    GL_DRAW_BUFFER3                                               = 0x8828,
    GL_DRAW_BUFFER3_ARB                                           = 0x8828,
    GL_DRAW_BUFFER3_ATI                                           = 0x8828,
    GL_DRAW_BUFFER4                                               = 0x8829,
    GL_DRAW_BUFFER4_ARB                                           = 0x8829,
    GL_DRAW_BUFFER4_ATI                                           = 0x8829,
    GL_DRAW_BUFFER5                                               = 0x882A,
    GL_DRAW_BUFFER5_ARB                                           = 0x882A,
    GL_DRAW_BUFFER5_ATI                                           = 0x882A,
    GL_DRAW_BUFFER6                                               = 0x882B,
    GL_DRAW_BUFFER6_ARB                                           = 0x882B,
    GL_DRAW_BUFFER6_ATI                                           = 0x882B,
    GL_DRAW_BUFFER7                                               = 0x882C,
    GL_DRAW_BUFFER7_ARB                                           = 0x882C,
    GL_DRAW_BUFFER7_ATI                                           = 0x882C,
    GL_DRAW_BUFFER8                                               = 0x882D,
    GL_DRAW_BUFFER8_ARB                                           = 0x882D,
    GL_DRAW_BUFFER8_ATI                                           = 0x882D,
    GL_DRAW_BUFFER9                                               = 0x882E,
    GL_DRAW_BUFFER9_ARB                                           = 0x882E,
    GL_DRAW_BUFFER9_ATI                                           = 0x882E,
    GL_DRAW_BUFFER10                                              = 0x882F,
    GL_DRAW_BUFFER10_ARB                                          = 0x882F,
    GL_DRAW_BUFFER10_ATI                                          = 0x882F,
    GL_DRAW_BUFFER11                                              = 0x8830,
    GL_DRAW_BUFFER11_ARB                                          = 0x8830,
    GL_DRAW_BUFFER11_ATI                                          = 0x8830,
    GL_DRAW_BUFFER12                                              = 0x8831,
    GL_DRAW_BUFFER12_ARB                                          = 0x8831,
    GL_DRAW_BUFFER12_ATI                                          = 0x8831,
    GL_DRAW_BUFFER13                                              = 0x8832,
    GL_DRAW_BUFFER13_ARB                                          = 0x8832,
    GL_DRAW_BUFFER13_ATI                                          = 0x8832,
    GL_DRAW_BUFFER14                                              = 0x8833,
    GL_DRAW_BUFFER14_ARB                                          = 0x8833,
    GL_DRAW_BUFFER14_ATI                                          = 0x8833,
    GL_DRAW_BUFFER15                                              = 0x8834,
    GL_DRAW_BUFFER15_ARB                                          = 0x8834,
    GL_DRAW_BUFFER15_ATI                                          = 0x8834,
    GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI                            = 0x8835,
    GL_BLEND_EQUATION_ALPHA_EXT                                   = 0x883D,
    GL_SUBSAMPLE_DISTANCE_AMD                                     = 0x883F,
    GL_MATRIX_PALETTE_ARB                                         = 0x8840,
    GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB                         = 0x8841,
    GL_MAX_PALETTE_MATRICES_ARB                                   = 0x8842,
    GL_CURRENT_PALETTE_MATRIX_ARB                                 = 0x8843,
    GL_MATRIX_INDEX_ARRAY_ARB                                     = 0x8844,
    GL_CURRENT_MATRIX_INDEX_ARB                                   = 0x8845,
    GL_MATRIX_INDEX_ARRAY_SIZE_ARB                                = 0x8846,
    GL_MATRIX_INDEX_ARRAY_TYPE_ARB                                = 0x8847,
    GL_MATRIX_INDEX_ARRAY_STRIDE_ARB                              = 0x8848,
    GL_MATRIX_INDEX_ARRAY_POINTER_ARB                             = 0x8849,
    GL_TEXTURE_DEPTH_SIZE                                         = 0x884A,
    GL_TEXTURE_DEPTH_SIZE_ARB                                     = 0x884A,
    GL_DEPTH_TEXTURE_MODE                                         = 0x884B,
    GL_DEPTH_TEXTURE_MODE_ARB                                     = 0x884B,
    GL_TEXTURE_COMPARE_MODE_ARB                                   = 0x884C,
    GL_TEXTURE_COMPARE_FUNC_ARB                                   = 0x884D,
    GL_COMPARE_R_TO_TEXTURE_ARB                                   = 0x884E,
    GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT                           = 0x884E,
    GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV                            = 0x8850,
    GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV                      = 0x8851,
    GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV                     = 0x8852,
    GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV               = 0x8853,
    GL_OFFSET_HILO_TEXTURE_2D_NV                                  = 0x8854,
    GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV                           = 0x8855,
    GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV                       = 0x8856,
    GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV                = 0x8857,
    GL_DEPENDENT_HILO_TEXTURE_2D_NV                               = 0x8858,
    GL_DEPENDENT_RGB_TEXTURE_3D_NV                                = 0x8859,
    GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV                          = 0x885A,
    GL_DOT_PRODUCT_PASS_THROUGH_NV                                = 0x885B,
    GL_DOT_PRODUCT_TEXTURE_1D_NV                                  = 0x885C,
    GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV                        = 0x885D,
    GL_HILO8_NV                                                   = 0x885E,
    GL_SIGNED_HILO8_NV                                            = 0x885F,
    GL_FORCE_BLUE_TO_ONE_NV                                       = 0x8860,
    GL_POINT_SPRITE_ARB                                           = 0x8861,
    GL_POINT_SPRITE_NV                                            = 0x8861,
    GL_COORD_REPLACE_ARB                                          = 0x8862,
    GL_COORD_REPLACE_NV                                           = 0x8862,
    GL_POINT_SPRITE_R_MODE_NV                                     = 0x8863,
    GL_PIXEL_COUNTER_BITS_NV                                      = 0x8864,
    GL_QUERY_COUNTER_BITS_ARB                                     = 0x8864,
    GL_CURRENT_OCCLUSION_QUERY_ID_NV                              = 0x8865,
    GL_CURRENT_QUERY_ARB                                          = 0x8865,
    GL_QUERY_RESULT_ARB                                           = 0x8866,
    GL_QUERY_RESULT_AVAILABLE_ARB                                 = 0x8867,
    GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV                   = 0x8868,
    GL_MAX_VERTEX_ATTRIBS_ARB                                     = 0x8869,
    GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB                         = 0x886A,
    GL_MAX_TESS_CONTROL_INPUT_COMPONENTS                          = 0x886C,
    GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS                       = 0x886D,
    GL_DEPTH_STENCIL_TO_RGBA_NV                                   = 0x886E,
    GL_DEPTH_STENCIL_TO_BGRA_NV                                   = 0x886F,
    GL_FRAGMENT_PROGRAM_NV                                        = 0x8870,
    GL_MAX_TEXTURE_COORDS                                         = 0x8871,
    GL_MAX_TEXTURE_COORDS_ARB                                     = 0x8871,
    GL_MAX_TEXTURE_COORDS_NV                                      = 0x8871,
    GL_MAX_TEXTURE_IMAGE_UNITS_ARB                                = 0x8872,
    GL_MAX_TEXTURE_IMAGE_UNITS_NV                                 = 0x8872,
    GL_FRAGMENT_PROGRAM_BINDING_NV                                = 0x8873,
    GL_PROGRAM_ERROR_STRING_ARB                                   = 0x8874,
    GL_PROGRAM_ERROR_STRING_NV                                    = 0x8874,
    GL_PROGRAM_FORMAT_ARB                                         = 0x8876,
    GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV                           = 0x887A,
    GL_READ_PIXEL_DATA_RANGE_LENGTH_NV                            = 0x887B,
    GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV                          = 0x887C,
    GL_READ_PIXEL_DATA_RANGE_POINTER_NV                           = 0x887D,
    GL_GEOMETRY_SHADER_INVOCATIONS                                = 0x887F,
    GL_FLOAT_R_NV                                                 = 0x8880,
    GL_FLOAT_RG_NV                                                = 0x8881,
    GL_FLOAT_RGB_NV                                               = 0x8882,
    GL_FLOAT_RGBA_NV                                              = 0x8883,
    GL_FLOAT_R16_NV                                               = 0x8884,
    GL_FLOAT_R32_NV                                               = 0x8885,
    GL_FLOAT_RG16_NV                                              = 0x8886,
    GL_FLOAT_RG32_NV                                              = 0x8887,
    GL_FLOAT_RGB16_NV                                             = 0x8888,
    GL_FLOAT_RGB32_NV                                             = 0x8889,
    GL_FLOAT_RGBA16_NV                                            = 0x888A,
    GL_FLOAT_RGBA32_NV                                            = 0x888B,
    GL_TEXTURE_FLOAT_COMPONENTS_NV                                = 0x888C,
    GL_FLOAT_CLEAR_COLOR_VALUE_NV                                 = 0x888D,
    GL_FLOAT_RGBA_MODE_NV                                         = 0x888E,
    GL_TEXTURE_UNSIGNED_REMAP_MODE_NV                             = 0x888F,
    GL_DEPTH_BOUNDS_TEST_EXT                                      = 0x8890,
    GL_DEPTH_BOUNDS_EXT                                           = 0x8891,
    GL_ARRAY_BUFFER_ARB                                           = 0x8892,
    GL_ELEMENT_ARRAY_BUFFER_ARB                                   = 0x8893,
    GL_ARRAY_BUFFER_BINDING_ARB                                   = 0x8894,
    GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB                           = 0x8895,
    GL_VERTEX_ARRAY_BUFFER_BINDING                                = 0x8896,
    GL_VERTEX_ARRAY_BUFFER_BINDING_ARB                            = 0x8896,
    GL_NORMAL_ARRAY_BUFFER_BINDING                                = 0x8897,
    GL_NORMAL_ARRAY_BUFFER_BINDING_ARB                            = 0x8897,
    GL_COLOR_ARRAY_BUFFER_BINDING                                 = 0x8898,
    GL_COLOR_ARRAY_BUFFER_BINDING_ARB                             = 0x8898,
    GL_INDEX_ARRAY_BUFFER_BINDING                                 = 0x8899,
    GL_INDEX_ARRAY_BUFFER_BINDING_ARB                             = 0x8899,
    GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING                         = 0x889A,
    GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB                     = 0x889A,
    GL_EDGE_FLAG_ARRAY_BUFFER_BINDING                             = 0x889B,
    GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB                         = 0x889B,
    GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING                       = 0x889C,
    GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB                   = 0x889C,
    GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB                    = 0x889D,
    GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING                        = 0x889D,
    GL_FOG_COORD_ARRAY_BUFFER_BINDING                             = 0x889D,
    GL_WEIGHT_ARRAY_BUFFER_BINDING                                = 0x889E,
    GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB                            = 0x889E,
    GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB                     = 0x889F,
    GL_PROGRAM_INSTRUCTIONS_ARB                                   = 0x88A0,
    GL_MAX_PROGRAM_INSTRUCTIONS_ARB                               = 0x88A1,
    GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB                            = 0x88A2,
    GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB                        = 0x88A3,
    GL_PROGRAM_TEMPORARIES_ARB                                    = 0x88A4,
    GL_MAX_PROGRAM_TEMPORARIES_ARB                                = 0x88A5,
    GL_PROGRAM_NATIVE_TEMPORARIES_ARB                             = 0x88A6,
    GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB                         = 0x88A7,
    GL_PROGRAM_PARAMETERS_ARB                                     = 0x88A8,
    GL_MAX_PROGRAM_PARAMETERS_ARB                                 = 0x88A9,
    GL_PROGRAM_NATIVE_PARAMETERS_ARB                              = 0x88AA,
    GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB                          = 0x88AB,
    GL_PROGRAM_ATTRIBS_ARB                                        = 0x88AC,
    GL_MAX_PROGRAM_ATTRIBS_ARB                                    = 0x88AD,
    GL_PROGRAM_NATIVE_ATTRIBS_ARB                                 = 0x88AE,
    GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                             = 0x88AF,
    GL_PROGRAM_ADDRESS_REGISTERS_ARB                              = 0x88B0,
    GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB                          = 0x88B1,
    GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB                       = 0x88B2,
    GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB                   = 0x88B3,
    GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB                           = 0x88B4,
    GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                             = 0x88B5,
    GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB                            = 0x88B6,
    GL_TRANSPOSE_CURRENT_MATRIX_ARB                               = 0x88B7,
    GL_READ_ONLY_ARB                                              = 0x88B8,
    GL_WRITE_ONLY_ARB                                             = 0x88B9,
    GL_READ_WRITE_ARB                                             = 0x88BA,
    GL_WRITE_DISCARD_NV                                           = 0x88BE,
    GL_TIME_ELAPSED_EXT                                           = 0x88BF,
    GL_MATRIX0_ARB                                                = 0x88C0,
    GL_MATRIX1_ARB                                                = 0x88C1,
    GL_MATRIX2_ARB                                                = 0x88C2,
    GL_MATRIX3_ARB                                                = 0x88C3,
    GL_MATRIX4_ARB                                                = 0x88C4,
    GL_MATRIX5_ARB                                                = 0x88C5,
    GL_MATRIX6_ARB                                                = 0x88C6,
    GL_MATRIX7_ARB                                                = 0x88C7,
    GL_MATRIX8_ARB                                                = 0x88C8,
    GL_MATRIX9_ARB                                                = 0x88C9,
    GL_MATRIX10_ARB                                               = 0x88CA,
    GL_MATRIX11_ARB                                               = 0x88CB,
    GL_MATRIX12_ARB                                               = 0x88CC,
    GL_MATRIX13_ARB                                               = 0x88CD,
    GL_MATRIX14_ARB                                               = 0x88CE,
    GL_MATRIX15_ARB                                               = 0x88CF,
    GL_MATRIX16_ARB                                               = 0x88D0,
    GL_MATRIX17_ARB                                               = 0x88D1,
    GL_MATRIX18_ARB                                               = 0x88D2,
    GL_MATRIX19_ARB                                               = 0x88D3,
    GL_MATRIX20_ARB                                               = 0x88D4,
    GL_MATRIX21_ARB                                               = 0x88D5,
    GL_MATRIX22_ARB                                               = 0x88D6,
    GL_MATRIX23_ARB                                               = 0x88D7,
    GL_MATRIX24_ARB                                               = 0x88D8,
    GL_MATRIX25_ARB                                               = 0x88D9,
    GL_MATRIX26_ARB                                               = 0x88DA,
    GL_MATRIX27_ARB                                               = 0x88DB,
    GL_MATRIX28_ARB                                               = 0x88DC,
    GL_MATRIX29_ARB                                               = 0x88DD,
    GL_MATRIX30_ARB                                               = 0x88DE,
    GL_MATRIX31_ARB                                               = 0x88DF,
    GL_STREAM_DRAW_ARB                                            = 0x88E0,
    GL_STREAM_READ_ARB                                            = 0x88E1,
    GL_STREAM_COPY_ARB                                            = 0x88E2,
    GL_STATIC_DRAW_ARB                                            = 0x88E4,
    GL_STATIC_READ_ARB                                            = 0x88E5,
    GL_STATIC_COPY_ARB                                            = 0x88E6,
    GL_DYNAMIC_DRAW_ARB                                           = 0x88E8,
    GL_DYNAMIC_READ_ARB                                           = 0x88E9,
    GL_DYNAMIC_COPY_ARB                                           = 0x88EA,
    GL_PIXEL_PACK_BUFFER_ARB                                      = 0x88EB,
    GL_PIXEL_PACK_BUFFER_EXT                                      = 0x88EB,
    GL_PIXEL_UNPACK_BUFFER_ARB                                    = 0x88EC,
    GL_PIXEL_UNPACK_BUFFER_EXT                                    = 0x88EC,
    GL_PIXEL_PACK_BUFFER_BINDING_ARB                              = 0x88ED,
    GL_PIXEL_PACK_BUFFER_BINDING_EXT                              = 0x88ED,
    GL_PIXEL_UNPACK_BUFFER_BINDING_ARB                            = 0x88EF,
    GL_PIXEL_UNPACK_BUFFER_BINDING_EXT                            = 0x88EF,
    GL_TEXTURE_STENCIL_SIZE                                       = 0x88F1,
    GL_TEXTURE_STENCIL_SIZE_EXT                                   = 0x88F1,
    GL_STENCIL_TAG_BITS_EXT                                       = 0x88F2,
    GL_STENCIL_CLEAR_TAG_VALUE_EXT                                = 0x88F3,
    GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV                           = 0x88F4,
    GL_MAX_PROGRAM_CALL_DEPTH_NV                                  = 0x88F5,
    GL_MAX_PROGRAM_IF_DEPTH_NV                                    = 0x88F6,
    GL_MAX_PROGRAM_LOOP_DEPTH_NV                                  = 0x88F7,
    GL_MAX_PROGRAM_LOOP_COUNT_NV                                  = 0x88F8,
    GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV                             = 0x88FD,
    GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB                            = 0x88FE,
    GL_MAX_ARRAY_TEXTURE_LAYERS_EXT                               = 0x88FF,
    GL_MIN_PROGRAM_TEXEL_OFFSET_EXT                               = 0x8904,
    GL_MIN_PROGRAM_TEXEL_OFFSET_NV                                = 0x8904,
    GL_MAX_PROGRAM_TEXEL_OFFSET_EXT                               = 0x8905,
    GL_MAX_PROGRAM_TEXEL_OFFSET_NV                                = 0x8905,
    GL_PROGRAM_ATTRIB_COMPONENTS_NV                               = 0x8906,
    GL_PROGRAM_RESULT_COMPONENTS_NV                               = 0x8907,
    GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV                           = 0x8908,
    GL_MAX_PROGRAM_RESULT_COMPONENTS_NV                           = 0x8909,
    GL_STENCIL_TEST_TWO_SIDE_EXT                                  = 0x8910,
    GL_ACTIVE_STENCIL_FACE_EXT                                    = 0x8911,
    GL_MIRROR_CLAMP_TO_BORDER_EXT                                 = 0x8912,
    GL_SAMPLES_PASSED_ARB                                         = 0x8914,
    GL_CLAMP_VERTEX_COLOR                                         = 0x891A,
    GL_CLAMP_FRAGMENT_COLOR                                       = 0x891B,
    GL_NUM_FRAGMENT_REGISTERS_ATI                                 = 0x896E,
    GL_NUM_FRAGMENT_CONSTANTS_ATI                                 = 0x896F,
    GL_NUM_PASSES_ATI                                             = 0x8970,
    GL_NUM_INSTRUCTIONS_PER_PASS_ATI                              = 0x8971,
    GL_NUM_INSTRUCTIONS_TOTAL_ATI                                 = 0x8972,
    GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI                      = 0x8973,
    GL_NUM_LOOPBACK_COMPONENTS_ATI                                = 0x8974,
    GL_COLOR_ALPHA_PAIRING_ATI                                    = 0x8975,
    GL_SWIZZLE_STRQ_ATI                                           = 0x897A,
    GL_SWIZZLE_STRQ_DQ_ATI                                        = 0x897B,
    GL_INTERLACE_OML                                              = 0x8980,
    GL_INTERLACE_READ_OML                                         = 0x8981,
    GL_FORMAT_SUBSAMPLE_24_24_OML                                 = 0x8982,
    GL_FORMAT_SUBSAMPLE_244_244_OML                               = 0x8983,
    GL_RESAMPLE_REPLICATE_OML                                     = 0x8986,
    GL_RESAMPLE_ZERO_FILL_OML                                     = 0x8987,
    GL_RESAMPLE_AVERAGE_OML                                       = 0x8988,
    GL_RESAMPLE_DECIMATE_OML                                      = 0x8989,
    GL_VERTEX_ATTRIB_MAP1_APPLE                                   = 0x8A00,
    GL_VERTEX_ATTRIB_MAP2_APPLE                                   = 0x8A01,
    GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE                              = 0x8A02,
    GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE                             = 0x8A03,
    GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE                             = 0x8A04,
    GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE                            = 0x8A05,
    GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE                              = 0x8A06,
    GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE                             = 0x8A07,
    GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE                             = 0x8A08,
    GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE                            = 0x8A09,
    GL_ELEMENT_ARRAY_APPLE                                        = 0x8A0C,
    GL_ELEMENT_ARRAY_TYPE_APPLE                                   = 0x8A0D,
    GL_ELEMENT_ARRAY_POINTER_APPLE                                = 0x8A0E,
    GL_COLOR_FLOAT_APPLE                                          = 0x8A0F,
    GL_BUFFER_SERIALIZED_MODIFY_APPLE                             = 0x8A12,
    GL_BUFFER_FLUSHING_UNMAP_APPLE                                = 0x8A13,
    GL_AUX_DEPTH_STENCIL_APPLE                                    = 0x8A14,
    GL_PACK_ROW_BYTES_APPLE                                       = 0x8A15,
    GL_UNPACK_ROW_BYTES_APPLE                                     = 0x8A16,
    GL_RELEASED_APPLE                                             = 0x8A19,
    GL_VOLATILE_APPLE                                             = 0x8A1A,
    GL_RETAINED_APPLE                                             = 0x8A1B,
    GL_UNDEFINED_APPLE                                            = 0x8A1C,
    GL_PURGEABLE_APPLE                                            = 0x8A1D,
    GL_RGB_422_APPLE                                              = 0x8A1F,
    GL_TEXTURE_SRGB_DECODE_EXT                                    = 0x8A48,
    GL_DECODE_EXT                                                 = 0x8A49,
    GL_SKIP_DECODE_EXT                                            = 0x8A4A,
    GL_PROGRAM_PIPELINE_OBJECT_EXT                                = 0x8A4F,
    GL_RGB_RAW_422_APPLE                                          = 0x8A51,
    GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT                       = 0x8A52,
    GL_SHADER_OBJECT_ARB                                          = 0x8B48,
    GL_SHADER_OBJECT_EXT                                          = 0x8B48,
    GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB                        = 0x8B49,
    GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB                          = 0x8B4A,
    GL_MAX_VARYING_COMPONENTS_EXT                                 = 0x8B4B,
    GL_MAX_VARYING_FLOATS_ARB                                     = 0x8B4B,
    GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB                         = 0x8B4C,
    GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB                       = 0x8B4D,
    GL_OBJECT_TYPE_ARB                                            = 0x8B4E,
    GL_OBJECT_SUBTYPE_ARB                                         = 0x8B4F,
    GL_OBJECT_DELETE_STATUS_ARB                                   = 0x8B80,
    GL_OBJECT_COMPILE_STATUS_ARB                                  = 0x8B81,
    GL_OBJECT_LINK_STATUS_ARB                                     = 0x8B82,
    GL_OBJECT_VALIDATE_STATUS_ARB                                 = 0x8B83,
    GL_OBJECT_INFO_LOG_LENGTH_ARB                                 = 0x8B84,
    GL_OBJECT_ATTACHED_OBJECTS_ARB                                = 0x8B85,
    GL_OBJECT_ACTIVE_UNIFORMS_ARB                                 = 0x8B86,
    GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB                       = 0x8B87,
    GL_OBJECT_SHADER_SOURCE_LENGTH_ARB                            = 0x8B88,
    GL_OBJECT_ACTIVE_ATTRIBUTES_ARB                               = 0x8B89,
    GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB                     = 0x8B8A,
    GL_SHADING_LANGUAGE_VERSION_ARB                               = 0x8B8C,
    GL_PALETTE4_RGB8_OES                                          = 0x8B90,
    GL_PALETTE4_RGBA8_OES                                         = 0x8B91,
    GL_PALETTE4_R5_G6_B5_OES                                      = 0x8B92,
    GL_PALETTE4_RGBA4_OES                                         = 0x8B93,
    GL_PALETTE4_RGB5_A1_OES                                       = 0x8B94,
    GL_PALETTE8_RGB8_OES                                          = 0x8B95,
    GL_PALETTE8_RGBA8_OES                                         = 0x8B96,
    GL_PALETTE8_R5_G6_B5_OES                                      = 0x8B97,
    GL_PALETTE8_RGBA4_OES                                         = 0x8B98,
    GL_PALETTE8_RGB5_A1_OES                                       = 0x8B99,
    GL_IMPLEMENTATION_COLOR_READ_TYPE_OES                         = 0x8B9A,
    GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES                       = 0x8B9B,
    GL_TILE_RASTER_ORDER_FIXED_MESA                               = 0x8BB8,
    GL_TILE_RASTER_ORDER_INCREASING_X_MESA                        = 0x8BB9,
    GL_TILE_RASTER_ORDER_INCREASING_Y_MESA                        = 0x8BBA,
    GL_FRAMEBUFFER_FLIP_Y_MESA                                    = 0x8BBB,
    GL_FRAMEBUFFER_FLIP_X_MESA                                    = 0x8BBC,
    GL_FRAMEBUFFER_SWAP_XY_MESA                                   = 0x8BBD,
    GL_CONST_BW_TILING_MESA                                       = 0x8BBE,
    GL_COUNTER_TYPE_AMD                                           = 0x8BC0,
    GL_COUNTER_RANGE_AMD                                          = 0x8BC1,
    GL_UNSIGNED_INT64_AMD                                         = 0x8BC2,
    GL_PERCENTAGE_AMD                                             = 0x8BC3,
    GL_PERFMON_RESULT_AVAILABLE_AMD                               = 0x8BC4,
    GL_PERFMON_RESULT_SIZE_AMD                                    = 0x8BC5,
    GL_PERFMON_RESULT_AMD                                         = 0x8BC6,
    GL_TEXTURE_RED_TYPE                                           = 0x8C10,
    GL_TEXTURE_RED_TYPE_ARB                                       = 0x8C10,
    GL_TEXTURE_GREEN_TYPE                                         = 0x8C11,
    GL_TEXTURE_GREEN_TYPE_ARB                                     = 0x8C11,
    GL_TEXTURE_BLUE_TYPE                                          = 0x8C12,
    GL_TEXTURE_BLUE_TYPE_ARB                                      = 0x8C12,
    GL_TEXTURE_ALPHA_TYPE                                         = 0x8C13,
    GL_TEXTURE_ALPHA_TYPE_ARB                                     = 0x8C13,
    GL_TEXTURE_LUMINANCE_TYPE                                     = 0x8C14,
    GL_TEXTURE_LUMINANCE_TYPE_ARB                                 = 0x8C14,
    GL_TEXTURE_INTENSITY_TYPE                                     = 0x8C15,
    GL_TEXTURE_INTENSITY_TYPE_ARB                                 = 0x8C15,
    GL_TEXTURE_DEPTH_TYPE                                         = 0x8C16,
    GL_TEXTURE_DEPTH_TYPE_ARB                                     = 0x8C16,
    GL_UNSIGNED_NORMALIZED                                        = 0x8C17,
    GL_UNSIGNED_NORMALIZED_ARB                                    = 0x8C17,
    GL_TEXTURE_1D_ARRAY_EXT                                       = 0x8C18,
    GL_TEXTURE_2D_ARRAY_EXT                                       = 0x8C1A,
    GL_TEXTURE_BINDING_1D_ARRAY_EXT                               = 0x8C1C,
    GL_TEXTURE_BINDING_2D_ARRAY_EXT                               = 0x8C1D,
    GL_MAX_PROGRAM_OUTPUT_VERTICES_NV                             = 0x8C27,
    GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV                     = 0x8C28,
    GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB                       = 0x8C29,
    GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT                       = 0x8C29,
    GL_TEXTURE_BUFFER_ARB                                         = 0x8C2A,
    GL_TEXTURE_BUFFER_EXT                                         = 0x8C2A,
    GL_TEXTURE_BUFFER_BINDING                                     = 0x8C2A,
    GL_MAX_TEXTURE_BUFFER_SIZE_ARB                                = 0x8C2B,
    GL_MAX_TEXTURE_BUFFER_SIZE_EXT                                = 0x8C2B,
    GL_TEXTURE_BINDING_BUFFER_ARB                                 = 0x8C2C,
    GL_TEXTURE_BINDING_BUFFER_EXT                                 = 0x8C2C,
    GL_TEXTURE_BUFFER_DATA_STORE_BINDING                          = 0x8C2D,
    GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB                      = 0x8C2D,
    GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT                      = 0x8C2D,
    GL_TEXTURE_BUFFER_FORMAT_ARB                                  = 0x8C2E,
    GL_TEXTURE_BUFFER_FORMAT_EXT                                  = 0x8C2E,
    GL_SAMPLE_SHADING_ARB                                         = 0x8C36,
    GL_MIN_SAMPLE_SHADING_VALUE                                   = 0x8C37,
    GL_MIN_SAMPLE_SHADING_VALUE_ARB                               = 0x8C37,
    GL_RGBA_SIGNED_COMPONENTS_EXT                                 = 0x8C3C,
    GL_TEXTURE_SHARED_SIZE                                        = 0x8C3F,
    GL_TEXTURE_SHARED_SIZE_EXT                                    = 0x8C3F,
    GL_SLUMINANCE_ALPHA                                           = 0x8C44,
    GL_SLUMINANCE_ALPHA_EXT                                       = 0x8C44,
    GL_SLUMINANCE8_ALPHA8                                         = 0x8C45,
    GL_SLUMINANCE8_ALPHA8_EXT                                     = 0x8C45,
    GL_SLUMINANCE                                                 = 0x8C46,
    GL_SLUMINANCE_EXT                                             = 0x8C46,
    GL_SLUMINANCE8                                                = 0x8C47,
    GL_SLUMINANCE8_EXT                                            = 0x8C47,
    GL_COMPRESSED_SRGB_EXT                                        = 0x8C48,
    GL_COMPRESSED_SRGB_ALPHA_EXT                                  = 0x8C49,
    GL_COMPRESSED_SLUMINANCE                                      = 0x8C4A,
    GL_COMPRESSED_SLUMINANCE_EXT                                  = 0x8C4A,
    GL_COMPRESSED_SLUMINANCE_ALPHA                                = 0x8C4B,
    GL_COMPRESSED_SLUMINANCE_ALPHA_EXT                            = 0x8C4B,
    GL_COMPRESSED_LUMINANCE_LATC1_EXT                             = 0x8C70,
    GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT                      = 0x8C71,
    GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT                       = 0x8C72,
    GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT                = 0x8C73,
    GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV                   = 0x8C74,
    GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV                = 0x8C75,
    GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT                  = 0x8C76,
    GL_BACK_PRIMARY_COLOR_NV                                      = 0x8C77,
    GL_BACK_SECONDARY_COLOR_NV                                    = 0x8C78,
    GL_TEXTURE_COORD_NV                                           = 0x8C79,
    GL_CLIP_DISTANCE_NV                                           = 0x8C7A,
    GL_VERTEX_ID_NV                                               = 0x8C7B,
    GL_PRIMITIVE_ID_NV                                            = 0x8C7C,
    GL_GENERIC_ATTRIB_NV                                          = 0x8C7D,
    GL_TRANSFORM_FEEDBACK_ATTRIBS_NV                              = 0x8C7E,
    GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT                         = 0x8C7F,
    GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV                          = 0x8C7F,
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS                 = 0x8C80,
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT             = 0x8C80,
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV              = 0x8C80,
    GL_ACTIVE_VARYINGS_NV                                         = 0x8C81,
    GL_ACTIVE_VARYING_MAX_LENGTH_NV                               = 0x8C82,
    GL_TRANSFORM_FEEDBACK_VARYINGS_EXT                            = 0x8C83,
    GL_TRANSFORM_FEEDBACK_VARYINGS_NV                             = 0x8C83,
    GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT                        = 0x8C84,
    GL_TRANSFORM_FEEDBACK_BUFFER_START_NV                         = 0x8C84,
    GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT                         = 0x8C85,
    GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV                          = 0x8C85,
    GL_TRANSFORM_FEEDBACK_RECORD_NV                               = 0x8C86,
    GL_PRIMITIVES_GENERATED_EXT                                   = 0x8C87,
    GL_PRIMITIVES_GENERATED_NV                                    = 0x8C87,
    GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT                  = 0x8C88,
    GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV                   = 0x8C88,
    GL_RASTERIZER_DISCARD_EXT                                     = 0x8C89,
    GL_RASTERIZER_DISCARD_NV                                      = 0x8C89,
    GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS              = 0x8C8A,
    GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT          = 0x8C8A,
    GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV           = 0x8C8A,
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS                    = 0x8C8B,
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT                = 0x8C8B,
    GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV                 = 0x8C8B,
    GL_INTERLEAVED_ATTRIBS_EXT                                    = 0x8C8C,
    GL_INTERLEAVED_ATTRIBS_NV                                     = 0x8C8C,
    GL_SEPARATE_ATTRIBS_EXT                                       = 0x8C8D,
    GL_SEPARATE_ATTRIBS_NV                                        = 0x8C8D,
    GL_TRANSFORM_FEEDBACK_BUFFER_EXT                              = 0x8C8E,
    GL_TRANSFORM_FEEDBACK_BUFFER_NV                               = 0x8C8E,
    GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT                      = 0x8C8F,
    GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV                       = 0x8C8F,
    GL_POINT_SPRITE_COORD_ORIGIN                                  = 0x8CA0,
    GL_DRAW_FRAMEBUFFER_BINDING_EXT                               = 0x8CA6,
    GL_FRAMEBUFFER_BINDING                                        = 0x8CA6,
    GL_FRAMEBUFFER_BINDING_EXT                                    = 0x8CA6,
    GL_RENDERBUFFER_BINDING_EXT                                   = 0x8CA7,
    GL_READ_FRAMEBUFFER_EXT                                       = 0x8CA8,
    GL_DRAW_FRAMEBUFFER_EXT                                       = 0x8CA9,
    GL_READ_FRAMEBUFFER_BINDING_EXT                               = 0x8CAA,
    GL_FRAMEBUFFER_COMPLETE_EXT                                   = 0x8CD5,
    GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT                      = 0x8CD6,
    GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT              = 0x8CD7,
    GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT                      = 0x8CD9,
    GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT                         = 0x8CDA,
    GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT                     = 0x8CDB,
    GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT                     = 0x8CDC,
    GL_FRAMEBUFFER_UNSUPPORTED_EXT                                = 0x8CDD,
    GL_FRAMEBUFFER_EXT                                            = 0x8D40,
    GL_RENDERBUFFER_EXT                                           = 0x8D41,
    GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT                     = 0x8D56,
    GL_MAX_SAMPLES                                                = 0x8D57,
    GL_MAX_SAMPLES_EXT                                            = 0x8D57,
    GL_RED_INTEGER_EXT                                            = 0x8D94,
    GL_GREEN_INTEGER_EXT                                          = 0x8D95,
    GL_BLUE_INTEGER_EXT                                           = 0x8D96,
    GL_ALPHA_INTEGER                                              = 0x8D97,
    GL_ALPHA_INTEGER_EXT                                          = 0x8D97,
    GL_RGB_INTEGER_EXT                                            = 0x8D98,
    GL_RGBA_INTEGER_EXT                                           = 0x8D99,
    GL_BGR_INTEGER_EXT                                            = 0x8D9A,
    GL_BGRA_INTEGER_EXT                                           = 0x8D9B,
    GL_LUMINANCE_INTEGER_EXT                                      = 0x8D9C,
    GL_LUMINANCE_ALPHA_INTEGER_EXT                                = 0x8D9D,
    GL_RGBA_INTEGER_MODE_EXT                                      = 0x8D9E,
    GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV                   = 0x8DA0,
    GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV                       = 0x8DA1,
    GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV                         = 0x8DA2,
    GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV                       = 0x8DA3,
    GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV                       = 0x8DA4,
    GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV                             = 0x8DA5,
    GL_MAX_PROGRAM_GENERIC_RESULTS_NV                             = 0x8DA6,
    GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB                   = 0x8DA8,
    GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT                   = 0x8DA8,
    GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB                     = 0x8DA9,
    GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT                     = 0x8DA9,
    GL_LAYER_NV                                                   = 0x8DAA,
    GL_SHADER_INCLUDE_ARB                                         = 0x8DAE,
    GL_DEPTH_BUFFER_FLOAT_MODE_NV                                 = 0x8DAF,
    GL_FRAMEBUFFER_SRGB_EXT                                       = 0x8DB9,
    GL_FRAMEBUFFER_SRGB_CAPABLE_EXT                               = 0x8DBA,
    GL_SAMPLER_1D_ARRAY_EXT                                       = 0x8DC0,
    GL_SAMPLER_2D_ARRAY_EXT                                       = 0x8DC1,
    GL_SAMPLER_BUFFER_EXT                                         = 0x8DC2,
    GL_SAMPLER_1D_ARRAY_SHADOW_EXT                                = 0x8DC3,
    GL_SAMPLER_2D_ARRAY_SHADOW_EXT                                = 0x8DC4,
    GL_SAMPLER_CUBE_SHADOW_EXT                                    = 0x8DC5,
    GL_UNSIGNED_INT_VEC2_EXT                                      = 0x8DC6,
    GL_UNSIGNED_INT_VEC3_EXT                                      = 0x8DC7,
    GL_UNSIGNED_INT_VEC4_EXT                                      = 0x8DC8,
    GL_INT_SAMPLER_1D_EXT                                         = 0x8DC9,
    GL_INT_SAMPLER_2D_EXT                                         = 0x8DCA,
    GL_INT_SAMPLER_3D_EXT                                         = 0x8DCB,
    GL_INT_SAMPLER_CUBE_EXT                                       = 0x8DCC,
    GL_INT_SAMPLER_2D_RECT_EXT                                    = 0x8DCD,
    GL_INT_SAMPLER_1D_ARRAY_EXT                                   = 0x8DCE,
    GL_INT_SAMPLER_2D_ARRAY_EXT                                   = 0x8DCF,
    GL_INT_SAMPLER_BUFFER_EXT                                     = 0x8DD0,
    GL_UNSIGNED_INT_SAMPLER_1D_EXT                                = 0x8DD1,
    GL_UNSIGNED_INT_SAMPLER_2D_EXT                                = 0x8DD2,
    GL_UNSIGNED_INT_SAMPLER_3D_EXT                                = 0x8DD3,
    GL_UNSIGNED_INT_SAMPLER_CUBE_EXT                              = 0x8DD4,
    GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT                           = 0x8DD5,
    GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT                          = 0x8DD6,
    GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT                          = 0x8DD7,
    GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT                            = 0x8DD8,
    GL_GEOMETRY_SHADER_ARB                                        = 0x8DD9,
    GL_GEOMETRY_SHADER_EXT                                        = 0x8DD9,
    GL_GEOMETRY_VERTICES_OUT_ARB                                  = 0x8DDA,
    GL_GEOMETRY_VERTICES_OUT_EXT                                  = 0x8DDA,
    GL_GEOMETRY_INPUT_TYPE_ARB                                    = 0x8DDB,
    GL_GEOMETRY_INPUT_TYPE_EXT                                    = 0x8DDB,
    GL_GEOMETRY_OUTPUT_TYPE_ARB                                   = 0x8DDC,
    GL_GEOMETRY_OUTPUT_TYPE_EXT                                   = 0x8DDC,
    GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB                        = 0x8DDD,
    GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT                        = 0x8DDD,
    GL_MAX_VERTEX_VARYING_COMPONENTS_ARB                          = 0x8DDE,
    GL_MAX_VERTEX_VARYING_COMPONENTS_EXT                          = 0x8DDE,
    GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB                        = 0x8DDF,
    GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT                        = 0x8DDF,
    GL_MAX_GEOMETRY_OUTPUT_VERTICES                               = 0x8DE0,
    GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB                           = 0x8DE0,
    GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT                           = 0x8DE0,
    GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS                       = 0x8DE1,
    GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB                   = 0x8DE1,
    GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT                   = 0x8DE1,
    GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT                           = 0x8DE2,
    GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT                         = 0x8DE3,
    GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT                         = 0x8DE4,
    GL_MAX_SUBROUTINES                                            = 0x8DE7,
    GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS                           = 0x8DE8,
    GL_NAMED_STRING_LENGTH_ARB                                    = 0x8DE9,
    GL_NAMED_STRING_TYPE_ARB                                      = 0x8DEA,
    GL_MAX_BINDABLE_UNIFORM_SIZE_EXT                              = 0x8DED,
    GL_UNIFORM_BUFFER_EXT                                         = 0x8DEE,
    GL_UNIFORM_BUFFER_BINDING_EXT                                 = 0x8DEF,
    GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV                          = 0x8E11,
    GL_MULTISAMPLE_COVERAGE_MODES_NV                              = 0x8E12,
    GL_QUERY_WAIT_NV                                              = 0x8E13,
    GL_QUERY_NO_WAIT_NV                                           = 0x8E14,
    GL_QUERY_BY_REGION_WAIT_NV                                    = 0x8E15,
    GL_QUERY_BY_REGION_NO_WAIT_NV                                 = 0x8E16,
    GL_POLYGON_OFFSET_CLAMP                                       = 0x8E1B,
    GL_POLYGON_OFFSET_CLAMP_EXT                                   = 0x8E1B,
    GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS               = 0x8E1E,
    GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS            = 0x8E1F,
    GL_COLOR_SAMPLES_NV                                           = 0x8E20,
    GL_TRANSFORM_FEEDBACK_NV                                      = 0x8E22,
    GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED                           = 0x8E23,
    GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV                        = 0x8E23,
    GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE                           = 0x8E24,
    GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV                        = 0x8E24,
    GL_TRANSFORM_FEEDBACK_BINDING                                 = 0x8E25,
    GL_TRANSFORM_FEEDBACK_BINDING_NV                              = 0x8E25,
    GL_FRAME_NV                                                   = 0x8E26,
    GL_FIELDS_NV                                                  = 0x8E27,
    GL_CURRENT_TIME_NV                                            = 0x8E28,
    GL_NUM_FILL_STREAMS_NV                                        = 0x8E29,
    GL_PRESENT_TIME_NV                                            = 0x8E2A,
    GL_PRESENT_DURATION_NV                                        = 0x8E2B,
    GL_PROGRAM_MATRIX_EXT                                         = 0x8E2D,
    GL_TRANSPOSE_PROGRAM_MATRIX_EXT                               = 0x8E2E,
    GL_PROGRAM_MATRIX_STACK_DEPTH_EXT                             = 0x8E2F,
    GL_TEXTURE_SWIZZLE_R_EXT                                      = 0x8E42,
    GL_TEXTURE_SWIZZLE_G_EXT                                      = 0x8E43,
    GL_TEXTURE_SWIZZLE_B_EXT                                      = 0x8E44,
    GL_TEXTURE_SWIZZLE_A_EXT                                      = 0x8E45,
    GL_TEXTURE_SWIZZLE_RGBA_EXT                                   = 0x8E46,
    GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION                   = 0x8E4C,
    GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT               = 0x8E4C,
    GL_FIRST_VERTEX_CONVENTION_EXT                                = 0x8E4D,
    GL_LAST_VERTEX_CONVENTION_EXT                                 = 0x8E4E,
    GL_PROVOKING_VERTEX_EXT                                       = 0x8E4F,
    GL_SAMPLE_POSITION_NV                                         = 0x8E50,
    GL_SAMPLE_LOCATION_NV                                         = 0x8E50,
    GL_SAMPLE_MASK_NV                                             = 0x8E51,
    GL_SAMPLE_MASK_VALUE                                          = 0x8E52,
    GL_SAMPLE_MASK_VALUE_NV                                       = 0x8E52,
    GL_TEXTURE_BINDING_RENDERBUFFER_NV                            = 0x8E53,
    GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV                 = 0x8E54,
    GL_TEXTURE_RENDERBUFFER_NV                                    = 0x8E55,
    GL_SAMPLER_RENDERBUFFER_NV                                    = 0x8E56,
    GL_INT_SAMPLER_RENDERBUFFER_NV                                = 0x8E57,
    GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV                       = 0x8E58,
    GL_MAX_SAMPLE_MASK_WORDS_NV                                   = 0x8E59,
    GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV                        = 0x8E5A,
    GL_MAX_GEOMETRY_SHADER_INVOCATIONS                            = 0x8E5A,
    GL_MIN_FRAGMENT_INTERPOLATION_OFFSET                          = 0x8E5B,
    GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV                       = 0x8E5B,
    GL_MAX_FRAGMENT_INTERPOLATION_OFFSET                          = 0x8E5C,
    GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV                       = 0x8E5C,
    GL_FRAGMENT_INTERPOLATION_OFFSET_BITS                         = 0x8E5D,
    GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV              = 0x8E5D,
    GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET                          = 0x8E5E,
    GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB                      = 0x8E5E,
    GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV                       = 0x8E5E,
    GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET                          = 0x8E5F,
    GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB                      = 0x8E5F,
    GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV                       = 0x8E5F,
    GL_MAX_MESH_UNIFORM_BLOCKS_NV                                 = 0x8E60,
    GL_MAX_MESH_TEXTURE_IMAGE_UNITS_NV                            = 0x8E61,
    GL_MAX_MESH_IMAGE_UNIFORMS_NV                                 = 0x8E62,
    GL_MAX_MESH_UNIFORM_COMPONENTS_NV                             = 0x8E63,
    GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_NV                         = 0x8E64,
    GL_MAX_MESH_ATOMIC_COUNTERS_NV                                = 0x8E65,
    GL_MAX_MESH_SHADER_STORAGE_BLOCKS_NV                          = 0x8E66,
    GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_NV                    = 0x8E67,
    GL_MAX_TASK_UNIFORM_BLOCKS_NV                                 = 0x8E68,
    GL_MAX_TASK_TEXTURE_IMAGE_UNITS_NV                            = 0x8E69,
    GL_MAX_TASK_IMAGE_UNIFORMS_NV                                 = 0x8E6A,
    GL_MAX_TASK_UNIFORM_COMPONENTS_NV                             = 0x8E6B,
    GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_NV                         = 0x8E6C,
    GL_MAX_TASK_ATOMIC_COUNTERS_NV                                = 0x8E6D,
    GL_MAX_TASK_SHADER_STORAGE_BLOCKS_NV                          = 0x8E6E,
    GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_NV                    = 0x8E6F,
    GL_MAX_TRANSFORM_FEEDBACK_BUFFERS                             = 0x8E70,
    GL_MAX_VERTEX_STREAMS                                         = 0x8E71,
    GL_TESS_CONTROL_OUTPUT_VERTICES                               = 0x8E75,
    GL_TESS_GEN_MODE                                              = 0x8E76,
    GL_TESS_GEN_SPACING                                           = 0x8E77,
    GL_TESS_GEN_VERTEX_ORDER                                      = 0x8E78,
    GL_TESS_GEN_POINT_MODE                                        = 0x8E79,
    GL_ISOLINES                                                   = 0x8E7A,
    GL_FRACTIONAL_ODD                                             = 0x8E7B,
    GL_FRACTIONAL_EVEN                                            = 0x8E7C,
    GL_MAX_PATCH_VERTICES                                         = 0x8E7D,
    GL_MAX_TESS_GEN_LEVEL                                         = 0x8E7E,
    GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS                        = 0x8E7F,
    GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS                     = 0x8E80,
    GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS                       = 0x8E81,
    GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS                    = 0x8E82,
    GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS                         = 0x8E83,
    GL_MAX_TESS_PATCH_COMPONENTS                                  = 0x8E84,
    GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS                   = 0x8E85,
    GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS                      = 0x8E86,
    GL_INCLUSIVE_EXT                                              = 0x8F10,
    GL_EXCLUSIVE_EXT                                              = 0x8F11,
    GL_WINDOW_RECTANGLE_EXT                                       = 0x8F12,
    GL_WINDOW_RECTANGLE_MODE_EXT                                  = 0x8F13,
    GL_MAX_WINDOW_RECTANGLES_EXT                                  = 0x8F14,
    GL_NUM_WINDOW_RECTANGLES_EXT                                  = 0x8F15,
    GL_BUFFER_GPU_ADDRESS_NV                                      = 0x8F1D,
    GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV                             = 0x8F1E,
    GL_ELEMENT_ARRAY_UNIFIED_NV                                   = 0x8F1F,
    GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV                             = 0x8F20,
    GL_VERTEX_ARRAY_ADDRESS_NV                                    = 0x8F21,
    GL_NORMAL_ARRAY_ADDRESS_NV                                    = 0x8F22,
    GL_COLOR_ARRAY_ADDRESS_NV                                     = 0x8F23,
    GL_INDEX_ARRAY_ADDRESS_NV                                     = 0x8F24,
    GL_TEXTURE_COORD_ARRAY_ADDRESS_NV                             = 0x8F25,
    GL_EDGE_FLAG_ARRAY_ADDRESS_NV                                 = 0x8F26,
    GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV                           = 0x8F27,
    GL_FOG_COORD_ARRAY_ADDRESS_NV                                 = 0x8F28,
    GL_ELEMENT_ARRAY_ADDRESS_NV                                   = 0x8F29,
    GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV                              = 0x8F2A,
    GL_VERTEX_ARRAY_LENGTH_NV                                     = 0x8F2B,
    GL_NORMAL_ARRAY_LENGTH_NV                                     = 0x8F2C,
    GL_COLOR_ARRAY_LENGTH_NV                                      = 0x8F2D,
    GL_INDEX_ARRAY_LENGTH_NV                                      = 0x8F2E,
    GL_TEXTURE_COORD_ARRAY_LENGTH_NV                              = 0x8F2F,
    GL_EDGE_FLAG_ARRAY_LENGTH_NV                                  = 0x8F30,
    GL_SECONDARY_COLOR_ARRAY_LENGTH_NV                            = 0x8F31,
    GL_FOG_COORD_ARRAY_LENGTH_NV                                  = 0x8F32,
    GL_ELEMENT_ARRAY_LENGTH_NV                                    = 0x8F33,
    GL_GPU_ADDRESS_NV                                             = 0x8F34,
    GL_MAX_SHADER_BUFFER_ADDRESS_NV                               = 0x8F35,
    GL_COPY_READ_BUFFER_BINDING                                   = 0x8F36,
    GL_COPY_WRITE_BUFFER_BINDING                                  = 0x8F37,
    GL_MAX_IMAGE_UNITS                                            = 0x8F38,
    GL_MAX_IMAGE_UNITS_EXT                                        = 0x8F38,
    GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS              = 0x8F39,
    GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT          = 0x8F39,
    GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES                       = 0x8F39,
    GL_IMAGE_BINDING_NAME                                         = 0x8F3A,
    GL_IMAGE_BINDING_NAME_EXT                                     = 0x8F3A,
    GL_IMAGE_BINDING_LEVEL                                        = 0x8F3B,
    GL_IMAGE_BINDING_LEVEL_EXT                                    = 0x8F3B,
    GL_IMAGE_BINDING_LAYERED                                      = 0x8F3C,
    GL_IMAGE_BINDING_LAYERED_EXT                                  = 0x8F3C,
    GL_IMAGE_BINDING_LAYER                                        = 0x8F3D,
    GL_IMAGE_BINDING_LAYER_EXT                                    = 0x8F3D,
    GL_IMAGE_BINDING_ACCESS                                       = 0x8F3E,
    GL_IMAGE_BINDING_ACCESS_EXT                                   = 0x8F3E,
    GL_DRAW_INDIRECT_UNIFIED_NV                                   = 0x8F40,
    GL_DRAW_INDIRECT_ADDRESS_NV                                   = 0x8F41,
    GL_DRAW_INDIRECT_LENGTH_NV                                    = 0x8F42,
    GL_DRAW_INDIRECT_BUFFER_BINDING                               = 0x8F43,
    GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV                       = 0x8F44,
    GL_MAX_PROGRAM_SUBROUTINE_NUM_NV                              = 0x8F45,
    GL_DOUBLE_MAT2_EXT                                            = 0x8F46,
    GL_DOUBLE_MAT3_EXT                                            = 0x8F47,
    GL_DOUBLE_MAT4_EXT                                            = 0x8F48,
    GL_DOUBLE_MAT2x3_EXT                                          = 0x8F49,
    GL_DOUBLE_MAT2x4_EXT                                          = 0x8F4A,
    GL_DOUBLE_MAT3x2_EXT                                          = 0x8F4B,
    GL_DOUBLE_MAT3x4_EXT                                          = 0x8F4C,
    GL_DOUBLE_MAT4x2_EXT                                          = 0x8F4D,
    GL_DOUBLE_MAT4x3_EXT                                          = 0x8F4E,
    GL_VERTEX_BINDING_BUFFER                                      = 0x8F4F,
    GL_RED_SNORM                                                  = 0x8F90,
    GL_RG_SNORM                                                   = 0x8F91,
    GL_RGB_SNORM                                                  = 0x8F92,
    GL_RGBA_SNORM                                                 = 0x8F93,
    GL_SIGNED_NORMALIZED                                          = 0x8F9C,
    GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB                  = 0x8F9F,
    GL_INT8_NV                                                    = 0x8FE0,
    GL_INT8_VEC2_NV                                               = 0x8FE1,
    GL_INT8_VEC3_NV                                               = 0x8FE2,
    GL_INT8_VEC4_NV                                               = 0x8FE3,
    GL_INT16_NV                                                   = 0x8FE4,
    GL_INT16_VEC2_NV                                              = 0x8FE5,
    GL_INT16_VEC3_NV                                              = 0x8FE6,
    GL_INT16_VEC4_NV                                              = 0x8FE7,
    GL_INT64_VEC2_NV                                              = 0x8FE9,
    GL_INT64_VEC3_NV                                              = 0x8FEA,
    GL_INT64_VEC4_NV                                              = 0x8FEB,
    GL_UNSIGNED_INT8_NV                                           = 0x8FEC,
    GL_UNSIGNED_INT8_VEC2_NV                                      = 0x8FED,
    GL_UNSIGNED_INT8_VEC3_NV                                      = 0x8FEE,
    GL_UNSIGNED_INT8_VEC4_NV                                      = 0x8FEF,
    GL_UNSIGNED_INT16_NV                                          = 0x8FF0,
    GL_UNSIGNED_INT16_VEC2_NV                                     = 0x8FF1,
    GL_UNSIGNED_INT16_VEC3_NV                                     = 0x8FF2,
    GL_UNSIGNED_INT16_VEC4_NV                                     = 0x8FF3,
    GL_UNSIGNED_INT64_VEC2_NV                                     = 0x8FF5,
    GL_UNSIGNED_INT64_VEC3_NV                                     = 0x8FF6,
    GL_UNSIGNED_INT64_VEC4_NV                                     = 0x8FF7,
    GL_FLOAT16_NV                                                 = 0x8FF8,
    GL_FLOAT16_VEC2_NV                                            = 0x8FF9,
    GL_FLOAT16_VEC3_NV                                            = 0x8FFA,
    GL_FLOAT16_VEC4_NV                                            = 0x8FFB,
    GL_DOUBLE_VEC2_EXT                                            = 0x8FFC,
    GL_DOUBLE_VEC3_EXT                                            = 0x8FFD,
    GL_DOUBLE_VEC4_EXT                                            = 0x8FFE,
    GL_SAMPLER_BUFFER_AMD                                         = 0x9001,
    GL_INT_SAMPLER_BUFFER_AMD                                     = 0x9002,
    GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD                            = 0x9003,
    GL_TESSELLATION_MODE_AMD                                      = 0x9004,
    GL_TESSELLATION_FACTOR_AMD                                    = 0x9005,
    GL_DISCRETE_AMD                                               = 0x9006,
    GL_CONTINUOUS_AMD                                             = 0x9007,
    GL_TEXTURE_BINDING_CUBE_MAP_ARRAY                             = 0x900A,
    GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB                         = 0x900A,
    GL_SAMPLER_CUBE_MAP_ARRAY_ARB                                 = 0x900C,
    GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB                          = 0x900D,
    GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB                             = 0x900E,
    GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB                    = 0x900F,
    GL_ALPHA_SNORM                                                = 0x9010,
    GL_LUMINANCE_SNORM                                            = 0x9011,
    GL_LUMINANCE_ALPHA_SNORM                                      = 0x9012,
    GL_INTENSITY_SNORM                                            = 0x9013,
    GL_ALPHA8_SNORM                                               = 0x9014,
    GL_LUMINANCE8_SNORM                                           = 0x9015,
    GL_LUMINANCE8_ALPHA8_SNORM                                    = 0x9016,
    GL_INTENSITY8_SNORM                                           = 0x9017,
    GL_ALPHA16_SNORM                                              = 0x9018,
    GL_LUMINANCE16_SNORM                                          = 0x9019,
    GL_LUMINANCE16_ALPHA16_SNORM                                  = 0x901A,
    GL_INTENSITY16_SNORM                                          = 0x901B,
    GL_FACTOR_MIN_AMD                                             = 0x901C,
    GL_FACTOR_MAX_AMD                                             = 0x901D,
    GL_DEPTH_CLAMP_NEAR_AMD                                       = 0x901E,
    GL_DEPTH_CLAMP_FAR_AMD                                        = 0x901F,
    GL_VIDEO_BUFFER_NV                                            = 0x9020,
    GL_VIDEO_BUFFER_BINDING_NV                                    = 0x9021,
    GL_FIELD_UPPER_NV                                             = 0x9022,
    GL_FIELD_LOWER_NV                                             = 0x9023,
    GL_NUM_VIDEO_CAPTURE_STREAMS_NV                               = 0x9024,
    GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV                        = 0x9025,
    GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV                          = 0x9026,
    GL_LAST_VIDEO_CAPTURE_STATUS_NV                               = 0x9027,
    GL_VIDEO_BUFFER_PITCH_NV                                      = 0x9028,
    GL_VIDEO_COLOR_CONVERSION_MATRIX_NV                           = 0x9029,
    GL_VIDEO_COLOR_CONVERSION_MAX_NV                              = 0x902A,
    GL_VIDEO_COLOR_CONVERSION_MIN_NV                              = 0x902B,
    GL_VIDEO_COLOR_CONVERSION_OFFSET_NV                           = 0x902C,
    GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV                            = 0x902D,
    GL_PARTIAL_SUCCESS_NV                                         = 0x902E,
    GL_SUCCESS_NV                                                 = 0x902F,
    GL_FAILURE_NV                                                 = 0x9030,
    GL_YCBYCR8_422_NV                                             = 0x9031,
    GL_YCBAYCR8A_4224_NV                                          = 0x9032,
    GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV                              = 0x9033,
    GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV                   = 0x9034,
    GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV                              = 0x9035,
    GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV                   = 0x9036,
    GL_Z4Y12Z4CB12Z4CR12_444_NV                                   = 0x9037,
    GL_VIDEO_CAPTURE_FRAME_WIDTH_NV                               = 0x9038,
    GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV                              = 0x9039,
    GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV                        = 0x903A,
    GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV                        = 0x903B,
    GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV                            = 0x903C,
    GL_TEXTURE_COVERAGE_SAMPLES_NV                                = 0x9045,
    GL_TEXTURE_COLOR_SAMPLES_NV                                   = 0x9046,
    GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX                       = 0x9047,
    GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX                 = 0x9048,
    GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX               = 0x9049,
    GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX                         = 0x904A,
    GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX                         = 0x904B,
    GL_IMAGE_1D_EXT                                               = 0x904C,
    GL_IMAGE_2D_EXT                                               = 0x904D,
    GL_IMAGE_3D_EXT                                               = 0x904E,
    GL_IMAGE_2D_RECT_EXT                                          = 0x904F,
    GL_IMAGE_CUBE_EXT                                             = 0x9050,
    GL_IMAGE_BUFFER_EXT                                           = 0x9051,
    GL_IMAGE_1D_ARRAY_EXT                                         = 0x9052,
    GL_IMAGE_2D_ARRAY_EXT                                         = 0x9053,
    GL_IMAGE_CUBE_MAP_ARRAY_EXT                                   = 0x9054,
    GL_IMAGE_2D_MULTISAMPLE_EXT                                   = 0x9055,
    GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT                             = 0x9056,
    GL_INT_IMAGE_1D_EXT                                           = 0x9057,
    GL_INT_IMAGE_2D_EXT                                           = 0x9058,
    GL_INT_IMAGE_3D_EXT                                           = 0x9059,
    GL_INT_IMAGE_2D_RECT_EXT                                      = 0x905A,
    GL_INT_IMAGE_CUBE_EXT                                         = 0x905B,
    GL_INT_IMAGE_BUFFER_EXT                                       = 0x905C,
    GL_INT_IMAGE_1D_ARRAY_EXT                                     = 0x905D,
    GL_INT_IMAGE_2D_ARRAY_EXT                                     = 0x905E,
    GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT                               = 0x905F,
    GL_INT_IMAGE_2D_MULTISAMPLE_EXT                               = 0x9060,
    GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT                         = 0x9061,
    GL_UNSIGNED_INT_IMAGE_1D_EXT                                  = 0x9062,
    GL_UNSIGNED_INT_IMAGE_2D_EXT                                  = 0x9063,
    GL_UNSIGNED_INT_IMAGE_3D_EXT                                  = 0x9064,
    GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT                             = 0x9065,
    GL_UNSIGNED_INT_IMAGE_CUBE_EXT                                = 0x9066,
    GL_UNSIGNED_INT_IMAGE_BUFFER_EXT                              = 0x9067,
    GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT                            = 0x9068,
    GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT                            = 0x9069,
    GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT                      = 0x906A,
    GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT                      = 0x906B,
    GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT                = 0x906C,
    GL_MAX_IMAGE_SAMPLES                                          = 0x906D,
    GL_MAX_IMAGE_SAMPLES_EXT                                      = 0x906D,
    GL_IMAGE_BINDING_FORMAT                                       = 0x906E,
    GL_IMAGE_BINDING_FORMAT_EXT                                   = 0x906E,
    GL_SQUARE_NV                                                  = 0x90A3,
    GL_ROUND_NV                                                   = 0x90A4,
    GL_TRIANGULAR_NV                                              = 0x90A5,
    GL_BEVEL_NV                                                   = 0x90A6,
    GL_MITER_REVERT_NV                                            = 0x90A7,
    GL_MITER_TRUNCATE_NV                                          = 0x90A8,
    GL_PATH_ERROR_POSITION_NV                                     = 0x90AB,
    GL_PATH_FOG_GEN_MODE_NV                                       = 0x90AC,
    GL_PATH_GEN_MODE_NV                                           = 0x90B0,
    GL_PATH_GEN_COEFF_NV                                          = 0x90B1,
    GL_PATH_GEN_COLOR_FORMAT_NV                                   = 0x90B2,
    GL_PATH_GEN_COMPONENTS_NV                                     = 0x90B3,
    GL_MOVE_TO_RESETS_NV                                          = 0x90B5,
    GL_MOVE_TO_CONTINUES_NV                                       = 0x90B6,
    GL_PATH_STENCIL_FUNC_NV                                       = 0x90B7,
    GL_PATH_STENCIL_REF_NV                                        = 0x90B8,
    GL_PATH_STENCIL_VALUE_MASK_NV                                 = 0x90B9,
    GL_SCALED_RESOLVE_FASTEST_EXT                                 = 0x90BA,
    GL_SCALED_RESOLVE_NICEST_EXT                                  = 0x90BB,
    GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV                        = 0x90BD,
    GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV                         = 0x90BE,
    GL_PATH_COVER_DEPTH_FUNC_NV                                   = 0x90BF,
    GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE                         = 0x90C8,
    GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS                        = 0x90C9,
    GL_MAX_VERTEX_IMAGE_UNIFORMS                                  = 0x90CA,
    GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS                            = 0x90CB,
    GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS                         = 0x90CC,
    GL_MAX_GEOMETRY_IMAGE_UNIFORMS                                = 0x90CD,
    GL_MAX_FRAGMENT_IMAGE_UNIFORMS                                = 0x90CE,
    GL_MAX_COMBINED_IMAGE_UNIFORMS                                = 0x90CF,
    GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV                        = 0x90D0,
    GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV                               = 0x90D1,
    GL_MAX_SHADER_STORAGE_BLOCK_SIZE                              = 0x90DE,
    GL_SYNC_X11_FENCE_EXT                                         = 0x90E1,
    GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB                    = 0x90EB,
    GL_CONTEXT_ROBUST_ACCESS                                      = 0x90F3,
    GL_CONTEXT_ROBUST_ACCESS_KHR                                  = 0x90F3,
    GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV                        = 0x90FC,
    GL_TEXTURE_SAMPLES                                            = 0x9106,
    GL_TEXTURE_FIXED_SAMPLE_LOCATIONS                             = 0x9107,
    GL_SYNC_FENCE                                                 = 0x9116,
    GL_UNSIGNALED                                                 = 0x9118,
    GL_SIGNALED                                                   = 0x9119,
    GL_UNPACK_COMPRESSED_BLOCK_WIDTH                              = 0x9127,
    GL_UNPACK_COMPRESSED_BLOCK_HEIGHT                             = 0x9128,
    GL_UNPACK_COMPRESSED_BLOCK_DEPTH                              = 0x9129,
    GL_UNPACK_COMPRESSED_BLOCK_SIZE                               = 0x912A,
    GL_PACK_COMPRESSED_BLOCK_WIDTH                                = 0x912B,
    GL_PACK_COMPRESSED_BLOCK_HEIGHT                               = 0x912C,
    GL_PACK_COMPRESSED_BLOCK_DEPTH                                = 0x912D,
    GL_PACK_COMPRESSED_BLOCK_SIZE                                 = 0x912E,
    GL_TEXTURE_IMMUTABLE_FORMAT                                   = 0x912F,
    GL_TEXTURE_IMMUTABLE_FORMAT_EXT                               = 0x912F,
    GL_MAX_DEBUG_MESSAGE_LENGTH                                   = 0x9143,
    GL_MAX_DEBUG_MESSAGE_LENGTH_AMD                               = 0x9143,
    GL_MAX_DEBUG_MESSAGE_LENGTH_ARB                               = 0x9143,
    GL_MAX_DEBUG_MESSAGE_LENGTH_KHR                               = 0x9143,
    GL_MAX_DEBUG_LOGGED_MESSAGES                                  = 0x9144,
    GL_MAX_DEBUG_LOGGED_MESSAGES_AMD                              = 0x9144,
    GL_MAX_DEBUG_LOGGED_MESSAGES_ARB                              = 0x9144,
    GL_MAX_DEBUG_LOGGED_MESSAGES_KHR                              = 0x9144,
    GL_DEBUG_LOGGED_MESSAGES                                      = 0x9145,
    GL_DEBUG_LOGGED_MESSAGES_AMD                                  = 0x9145,
    GL_DEBUG_LOGGED_MESSAGES_ARB                                  = 0x9145,
    GL_DEBUG_LOGGED_MESSAGES_KHR                                  = 0x9145,
    GL_DEBUG_SEVERITY_HIGH_AMD                                    = 0x9146,
    GL_DEBUG_SEVERITY_HIGH_ARB                                    = 0x9146,
    GL_DEBUG_SEVERITY_HIGH_KHR                                    = 0x9146,
    GL_DEBUG_SEVERITY_MEDIUM_AMD                                  = 0x9147,
    GL_DEBUG_SEVERITY_MEDIUM_ARB                                  = 0x9147,
    GL_DEBUG_SEVERITY_MEDIUM_KHR                                  = 0x9147,
    GL_DEBUG_SEVERITY_LOW_AMD                                     = 0x9148,
    GL_DEBUG_SEVERITY_LOW_ARB                                     = 0x9148,
    GL_DEBUG_SEVERITY_LOW_KHR                                     = 0x9148,
    GL_DEBUG_CATEGORY_API_ERROR_AMD                               = 0x9149,
    GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD                           = 0x914A,
    GL_DEBUG_CATEGORY_DEPRECATION_AMD                             = 0x914B,
    GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD                      = 0x914C,
    GL_DEBUG_CATEGORY_PERFORMANCE_AMD                             = 0x914D,
    GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD                         = 0x914E,
    GL_DEBUG_CATEGORY_APPLICATION_AMD                             = 0x914F,
    GL_DEBUG_CATEGORY_OTHER_AMD                                   = 0x9150,
    GL_BUFFER_OBJECT_EXT                                          = 0x9151,
    GL_DATA_BUFFER_AMD                                            = 0x9151,
    GL_PERFORMANCE_MONITOR_AMD                                    = 0x9152,
    GL_QUERY_OBJECT_AMD                                           = 0x9153,
    GL_QUERY_OBJECT_EXT                                           = 0x9153,
    GL_VERTEX_ARRAY_OBJECT_AMD                                    = 0x9154,
    GL_VERTEX_ARRAY_OBJECT_EXT                                    = 0x9154,
    GL_SAMPLER_OBJECT_AMD                                         = 0x9155,
    GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD                         = 0x9160,
    GL_QUERY_BUFFER_AMD                                           = 0x9192,
    GL_QUERY_BUFFER_BINDING                                       = 0x9193,
    GL_QUERY_BUFFER_BINDING_AMD                                   = 0x9193,
    GL_QUERY_RESULT_NO_WAIT_AMD                                   = 0x9194,
    GL_VIRTUAL_PAGE_SIZE_X_ARB                                    = 0x9195,
    GL_VIRTUAL_PAGE_SIZE_X_AMD                                    = 0x9195,
    GL_VIRTUAL_PAGE_SIZE_Y_ARB                                    = 0x9196,
    GL_VIRTUAL_PAGE_SIZE_Y_AMD                                    = 0x9196,
    GL_VIRTUAL_PAGE_SIZE_Z_ARB                                    = 0x9197,
    GL_VIRTUAL_PAGE_SIZE_Z_AMD                                    = 0x9197,
    GL_MAX_SPARSE_TEXTURE_SIZE_ARB                                = 0x9198,
    GL_MAX_SPARSE_TEXTURE_SIZE_AMD                                = 0x9198,
    GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB                             = 0x9199,
    GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD                             = 0x9199,
    GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS                            = 0x919A,
    GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB                        = 0x919A,
    GL_MIN_SPARSE_LEVEL_AMD                                       = 0x919B,
    GL_MIN_LOD_WARNING_AMD                                        = 0x919C,
    GL_TEXTURE_BUFFER_OFFSET                                      = 0x919D,
    GL_TEXTURE_BUFFER_SIZE                                        = 0x919E,
    GL_STREAM_RASTERIZATION_AMD                                   = 0x91A0,
    GL_VERTEX_ELEMENT_SWIZZLE_AMD                                 = 0x91A4,
    GL_VERTEX_ID_SWIZZLE_AMD                                      = 0x91A5,
    GL_TEXTURE_SPARSE_ARB                                         = 0x91A6,
    GL_VIRTUAL_PAGE_SIZE_INDEX_ARB                                = 0x91A7,
    GL_NUM_VIRTUAL_PAGE_SIZES_ARB                                 = 0x91A8,
    GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB                 = 0x91A9,
    GL_NUM_SPARSE_LEVELS_ARB                                      = 0x91AA,
    GL_PIXELS_PER_SAMPLE_PATTERN_X_AMD                            = 0x91AE,
    GL_PIXELS_PER_SAMPLE_PATTERN_Y_AMD                            = 0x91AF,
    GL_MAX_SHADER_COMPILER_THREADS_KHR                            = 0x91B0,
    GL_MAX_SHADER_COMPILER_THREADS_ARB                            = 0x91B0,
    GL_COMPLETION_STATUS_KHR                                      = 0x91B1,
    GL_COMPLETION_STATUS_ARB                                      = 0x91B1,
    GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD                          = 0x91B3,
    GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD                  = 0x91B4,
    GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD                  = 0x91B5,
    GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD                        = 0x91B6,
    GL_SUPPORTED_MULTISAMPLE_MODES_AMD                            = 0x91B7,
    GL_MAX_COMPUTE_IMAGE_UNIFORMS                                 = 0x91BD,
    GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB                           = 0x91BF,
    GL_FLOAT16_MAT2_AMD                                           = 0x91C5,
    GL_FLOAT16_MAT3_AMD                                           = 0x91C6,
    GL_FLOAT16_MAT4_AMD                                           = 0x91C7,
    GL_FLOAT16_MAT2x3_AMD                                         = 0x91C8,
    GL_FLOAT16_MAT2x4_AMD                                         = 0x91C9,
    GL_FLOAT16_MAT3x2_AMD                                         = 0x91CA,
    GL_FLOAT16_MAT3x4_AMD                                         = 0x91CB,
    GL_FLOAT16_MAT4x2_AMD                                         = 0x91CC,
    GL_FLOAT16_MAT4x3_AMD                                         = 0x91CD,
    GL_BLEND_PREMULTIPLIED_SRC_NV                                 = 0x9280,
    GL_BLEND_OVERLAP_NV                                           = 0x9281,
    GL_UNCORRELATED_NV                                            = 0x9282,
    GL_DISJOINT_NV                                                = 0x9283,
    GL_CONJOINT_NV                                                = 0x9284,
    GL_BLEND_ADVANCED_COHERENT_KHR                                = 0x9285,
    GL_BLEND_ADVANCED_COHERENT_NV                                 = 0x9285,
    GL_SRC_NV                                                     = 0x9286,
    GL_DST_NV                                                     = 0x9287,
    GL_SRC_OVER_NV                                                = 0x9288,
    GL_DST_OVER_NV                                                = 0x9289,
    GL_SRC_IN_NV                                                  = 0x928A,
    GL_DST_IN_NV                                                  = 0x928B,
    GL_SRC_OUT_NV                                                 = 0x928C,
    GL_DST_OUT_NV                                                 = 0x928D,
    GL_SRC_ATOP_NV                                                = 0x928E,
    GL_DST_ATOP_NV                                                = 0x928F,
    GL_PLUS_NV                                                    = 0x9291,
    GL_PLUS_DARKER_NV                                             = 0x9292,
    GL_MULTIPLY_KHR                                               = 0x9294,
    GL_MULTIPLY_NV                                                = 0x9294,
    GL_SCREEN_KHR                                                 = 0x9295,
    GL_SCREEN_NV                                                  = 0x9295,
    GL_OVERLAY_KHR                                                = 0x9296,
    GL_OVERLAY_NV                                                 = 0x9296,
    GL_DARKEN_KHR                                                 = 0x9297,
    GL_DARKEN_NV                                                  = 0x9297,
    GL_LIGHTEN_KHR                                                = 0x9298,
    GL_LIGHTEN_NV                                                 = 0x9298,
    GL_COLORDODGE_KHR                                             = 0x9299,
    GL_COLORDODGE_NV                                              = 0x9299,
    GL_COLORBURN_KHR                                              = 0x929A,
    GL_COLORBURN_NV                                               = 0x929A,
    GL_HARDLIGHT_KHR                                              = 0x929B,
    GL_HARDLIGHT_NV                                               = 0x929B,
    GL_SOFTLIGHT_KHR                                              = 0x929C,
    GL_SOFTLIGHT_NV                                               = 0x929C,
    GL_DIFFERENCE_KHR                                             = 0x929E,
    GL_DIFFERENCE_NV                                              = 0x929E,
    GL_MINUS_NV                                                   = 0x929F,
    GL_EXCLUSION_KHR                                              = 0x92A0,
    GL_EXCLUSION_NV                                               = 0x92A0,
    GL_CONTRAST_NV                                                = 0x92A1,
    GL_INVERT_RGB_NV                                              = 0x92A3,
    GL_LINEARDODGE_NV                                             = 0x92A4,
    GL_LINEARBURN_NV                                              = 0x92A5,
    GL_VIVIDLIGHT_NV                                              = 0x92A6,
    GL_LINEARLIGHT_NV                                             = 0x92A7,
    GL_PINLIGHT_NV                                                = 0x92A8,
    GL_HARDMIX_NV                                                 = 0x92A9,
    GL_HSL_HUE_KHR                                                = 0x92AD,
    GL_HSL_HUE_NV                                                 = 0x92AD,
    GL_HSL_SATURATION_KHR                                         = 0x92AE,
    GL_HSL_SATURATION_NV                                          = 0x92AE,
    GL_HSL_COLOR_KHR                                              = 0x92AF,
    GL_HSL_COLOR_NV                                               = 0x92AF,
    GL_HSL_LUMINOSITY_KHR                                         = 0x92B0,
    GL_HSL_LUMINOSITY_NV                                          = 0x92B0,
    GL_PLUS_CLAMPED_NV                                            = 0x92B1,
    GL_PLUS_CLAMPED_ALPHA_NV                                      = 0x92B2,
    GL_MINUS_CLAMPED_NV                                           = 0x92B3,
    GL_INVERT_OVG_NV                                              = 0x92B4,
    GL_MAX_LGPU_GPUS_NVX                                          = 0x92BA,
    GL_MULTICAST_GPUS_NV                                          = 0x92BA,
    GL_PURGED_CONTEXT_RESET_NV                                    = 0x92BB,
    GL_PRIMITIVE_BOUNDING_BOX_ARB                                 = 0x92BE,
    GL_ALPHA_TO_COVERAGE_DITHER_MODE_NV                           = 0x92BF,
    GL_ATOMIC_COUNTER_BUFFER_START                                = 0x92C2,
    GL_ATOMIC_COUNTER_BUFFER_SIZE                                 = 0x92C3,
    GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS                          = 0x92CC,
    GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS                    = 0x92CD,
    GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS                 = 0x92CE,
    GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS                        = 0x92CF,
    GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS                        = 0x92D0,
    GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS                        = 0x92D1,
    GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE                             = 0x92D8,
    GL_UNSIGNED_INT_ATOMIC_COUNTER                                = 0x92DB,
    GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS                         = 0x92DC,
    GL_FRAGMENT_COVERAGE_TO_COLOR_NV                              = 0x92DD,
    GL_FRAGMENT_COVERAGE_COLOR_NV                                 = 0x92DE,
    GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_NV                      = 0x92DF,
    GL_DEBUG_OUTPUT_KHR                                           = 0x92E0,
    GL_RASTER_MULTISAMPLE_EXT                                     = 0x9327,
    GL_RASTER_SAMPLES_EXT                                         = 0x9328,
    GL_MAX_RASTER_SAMPLES_EXT                                     = 0x9329,
    GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT                          = 0x932A,
    GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT                      = 0x932B,
    GL_EFFECTIVE_RASTER_SAMPLES_EXT                               = 0x932C,
    GL_DEPTH_SAMPLES_NV                                           = 0x932D,
    GL_STENCIL_SAMPLES_NV                                         = 0x932E,
    GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV                           = 0x932F,
    GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV                         = 0x9330,
    GL_COVERAGE_MODULATION_TABLE_NV                               = 0x9331,
    GL_COVERAGE_MODULATION_NV                                     = 0x9332,
    GL_COVERAGE_MODULATION_TABLE_SIZE_NV                          = 0x9333,
    GL_WARP_SIZE_NV                                               = 0x9339,
    GL_WARPS_PER_SM_NV                                            = 0x933A,
    GL_SM_COUNT_NV                                                = 0x933B,
    GL_FILL_RECTANGLE_NV                                          = 0x933C,
    GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB                          = 0x933D,
    GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV                           = 0x933D,
    GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB                       = 0x933E,
    GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV                        = 0x933E,
    GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB                      = 0x933F,
    GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV                       = 0x933F,
    GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB                = 0x9340,
    GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV                 = 0x9340,
    GL_PROGRAMMABLE_SAMPLE_LOCATION_NV                            = 0x9341,
    GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB              = 0x9342,
    GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV               = 0x9342,
    GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB                 = 0x9343,
    GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV                  = 0x9343,
    GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB                 = 0x9344,
    GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB                        = 0x9345,
    GL_CONSERVATIVE_RASTERIZATION_NV                              = 0x9346,
    GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV                          = 0x9347,
    GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV                          = 0x9348,
    GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV                        = 0x9349,
    GL_ALPHA_TO_COVERAGE_DITHER_DEFAULT_NV                        = 0x934D,
    GL_ALPHA_TO_COVERAGE_DITHER_ENABLE_NV                         = 0x934E,
    GL_ALPHA_TO_COVERAGE_DITHER_DISABLE_NV                        = 0x934F,
    GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV                             = 0x9350,
    GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV                             = 0x9351,
    GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV                             = 0x9352,
    GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV                             = 0x9353,
    GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV                             = 0x9354,
    GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV                             = 0x9355,
    GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV                             = 0x9356,
    GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV                             = 0x9357,
    GL_VIEWPORT_SWIZZLE_X_NV                                      = 0x9358,
    GL_VIEWPORT_SWIZZLE_Y_NV                                      = 0x9359,
    GL_VIEWPORT_SWIZZLE_Z_NV                                      = 0x935A,
    GL_VIEWPORT_SWIZZLE_W_NV                                      = 0x935B,
    GL_CLIP_ORIGIN                                                = 0x935C,
    GL_CLIP_DEPTH_MODE                                            = 0x935D,
    GL_TEXTURE_REDUCTION_MODE_ARB                                 = 0x9366,
    GL_TEXTURE_REDUCTION_MODE_EXT                                 = 0x9366,
    GL_WEIGHTED_AVERAGE_ARB                                       = 0x9367,
    GL_WEIGHTED_AVERAGE_EXT                                       = 0x9367,
    GL_FONT_GLYPHS_AVAILABLE_NV                                   = 0x9368,
    GL_FONT_TARGET_UNAVAILABLE_NV                                 = 0x9369,
    GL_FONT_UNAVAILABLE_NV                                        = 0x936A,
    GL_FONT_UNINTELLIGIBLE_NV                                     = 0x936B,
    GL_STANDARD_FONT_FORMAT_NV                                    = 0x936C,
    GL_FRAGMENT_INPUT_NV                                          = 0x936D,
    GL_UNIFORM_BUFFER_UNIFIED_NV                                  = 0x936E,
    GL_UNIFORM_BUFFER_ADDRESS_NV                                  = 0x936F,
    GL_UNIFORM_BUFFER_LENGTH_NV                                   = 0x9370,
    GL_MULTISAMPLES_NV                                            = 0x9371,
    GL_SUPERSAMPLE_SCALE_X_NV                                     = 0x9372,
    GL_SUPERSAMPLE_SCALE_Y_NV                                     = 0x9373,
    GL_CONFORMANT_NV                                              = 0x9374,
    GL_CONSERVATIVE_RASTER_DILATE_NV                              = 0x9379,
    GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV                        = 0x937A,
    GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV                  = 0x937B,
    GL_VIEWPORT_POSITION_W_SCALE_NV                               = 0x937C,
    GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV                       = 0x937D,
    GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV                       = 0x937E,
    GL_REPRESENTATIVE_FRAGMENT_TEST_NV                            = 0x937F,
    GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB                           = 0x9381,
    GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB                     = 0x9382,
    GL_VIEW_CLASS_EAC_R11                                         = 0x9383,
    GL_VIEW_CLASS_EAC_RG11                                        = 0x9384,
    GL_VIEW_CLASS_ETC2_RGB                                        = 0x9385,
    GL_VIEW_CLASS_ETC2_RGBA                                       = 0x9386,
    GL_VIEW_CLASS_ETC2_EAC_RGBA                                   = 0x9387,
    GL_VIEW_CLASS_ASTC_4x4_RGBA                                   = 0x9388,
    GL_VIEW_CLASS_ASTC_5x4_RGBA                                   = 0x9389,
    GL_VIEW_CLASS_ASTC_5x5_RGBA                                   = 0x938A,
    GL_VIEW_CLASS_ASTC_6x5_RGBA                                   = 0x938B,
    GL_VIEW_CLASS_ASTC_6x6_RGBA                                   = 0x938C,
    GL_VIEW_CLASS_ASTC_8x5_RGBA                                   = 0x938D,
    GL_VIEW_CLASS_ASTC_8x6_RGBA                                   = 0x938E,
    GL_VIEW_CLASS_ASTC_8x8_RGBA                                   = 0x938F,
    GL_VIEW_CLASS_ASTC_10x5_RGBA                                  = 0x9390,
    GL_VIEW_CLASS_ASTC_10x6_RGBA                                  = 0x9391,
    GL_VIEW_CLASS_ASTC_10x8_RGBA                                  = 0x9392,
    GL_VIEW_CLASS_ASTC_10x10_RGBA                                 = 0x9393,
    GL_VIEW_CLASS_ASTC_12x10_RGBA                                 = 0x9394,
    GL_VIEW_CLASS_ASTC_12x12_RGBA                                 = 0x9395,
    GL_BGRA8_EXT                                                  = 0x93A1,
    GL_PERFQUERY_COUNTER_EVENT_INTEL                              = 0x94F0,
    GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL                      = 0x94F1,
    GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL                       = 0x94F2,
    GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL                         = 0x94F3,
    GL_PERFQUERY_COUNTER_RAW_INTEL                                = 0x94F4,
    GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL                          = 0x94F5,
    GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL                        = 0x94F8,
    GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL                        = 0x94F9,
    GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL                         = 0x94FA,
    GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL                        = 0x94FB,
    GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL                        = 0x94FC,
    GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL                      = 0x94FD,
    GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL                    = 0x94FE,
    GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL                    = 0x94FF,
    GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL                      = 0x9500,
    GL_SUBGROUP_SIZE_KHR                                          = 0x9532,
    GL_SUBGROUP_SUPPORTED_STAGES_KHR                              = 0x9533,
    GL_SUBGROUP_SUPPORTED_FEATURES_KHR                            = 0x9534,
    GL_SUBGROUP_QUAD_ALL_STAGES_KHR                               = 0x9535,
    GL_MAX_MESH_TOTAL_MEMORY_SIZE_NV                              = 0x9536,
    GL_MAX_TASK_TOTAL_MEMORY_SIZE_NV                              = 0x9537,
    GL_MAX_MESH_OUTPUT_VERTICES_NV                                = 0x9538,
    GL_MAX_MESH_OUTPUT_PRIMITIVES_NV                              = 0x9539,
    GL_MAX_TASK_OUTPUT_COUNT_NV                                   = 0x953A,
    GL_MAX_MESH_WORK_GROUP_SIZE_NV                                = 0x953B,
    GL_MAX_TASK_WORK_GROUP_SIZE_NV                                = 0x953C,
    GL_MAX_DRAW_MESH_TASKS_COUNT_NV                               = 0x953D,
    GL_MESH_WORK_GROUP_SIZE_NV                                    = 0x953E,
    GL_TASK_WORK_GROUP_SIZE_NV                                    = 0x953F,
    GL_QUERY_RESOURCE_TYPE_VIDMEM_ALLOC_NV                        = 0x9540,
    GL_QUERY_RESOURCE_MEMTYPE_VIDMEM_NV                           = 0x9542,
    GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_NV                   = 0x9543,
    GL_QUERY_RESOURCE_SYS_RESERVED_NV                             = 0x9544,
    GL_QUERY_RESOURCE_TEXTURE_NV                                  = 0x9545,
    GL_QUERY_RESOURCE_RENDERBUFFER_NV                             = 0x9546,
    GL_QUERY_RESOURCE_BUFFEROBJECT_NV                             = 0x9547,
    GL_PER_GPU_STORAGE_NV                                         = 0x9548,
    GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV                  = 0x9549,
    GL_UPLOAD_GPU_MASK_NVX                                        = 0x954A,
    GL_CONSERVATIVE_RASTER_MODE_NV                                = 0x954D,
    GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV                      = 0x954E,
    GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV             = 0x954F,
    GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV                       = 0x9550,
    GL_SHADER_BINARY_FORMAT_SPIR_V_ARB                            = 0x9551,
    GL_SPIR_V_BINARY                                              = 0x9552,
    GL_SPIR_V_BINARY_ARB                                          = 0x9552,
    GL_SPIR_V_EXTENSIONS                                          = 0x9553,
    GL_NUM_SPIR_V_EXTENSIONS                                      = 0x9554,
    GL_SCISSOR_TEST_EXCLUSIVE_NV                                  = 0x9555,
    GL_SCISSOR_BOX_EXCLUSIVE_NV                                   = 0x9556,
    GL_MAX_MESH_VIEWS_NV                                          = 0x9557,
    GL_RENDER_GPU_MASK_NV                                         = 0x9558,
    GL_MESH_SHADER_NV                                             = 0x9559,
    GL_TASK_SHADER_NV                                             = 0x955A,
    GL_SHADING_RATE_IMAGE_BINDING_NV                              = 0x955B,
    GL_SHADING_RATE_IMAGE_TEXEL_WIDTH_NV                          = 0x955C,
    GL_SHADING_RATE_IMAGE_TEXEL_HEIGHT_NV                         = 0x955D,
    GL_SHADING_RATE_IMAGE_PALETTE_SIZE_NV                         = 0x955E,
    GL_MAX_COARSE_FRAGMENT_SAMPLES_NV                             = 0x955F,
    GL_SHADING_RATE_IMAGE_NV                                      = 0x9563,
    GL_SHADING_RATE_NO_INVOCATIONS_NV                             = 0x9564,
    GL_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV                     = 0x9565,
    GL_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV                = 0x9566,
    GL_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV                = 0x9567,
    GL_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV                = 0x9568,
    GL_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV                = 0x9569,
    GL_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV                = 0x956A,
    GL_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV                = 0x956B,
    GL_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV                    = 0x956C,
    GL_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV                    = 0x956D,
    GL_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV                    = 0x956E,
    GL_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV                   = 0x956F,
    GL_MESH_VERTICES_OUT_NV                                       = 0x9579,
    GL_MESH_PRIMITIVES_OUT_NV                                     = 0x957A,
    GL_MESH_OUTPUT_TYPE_NV                                        = 0x957B,
    GL_MESH_SUBROUTINE_NV                                         = 0x957C,
    GL_TASK_SUBROUTINE_NV                                         = 0x957D,
    GL_MESH_SUBROUTINE_UNIFORM_NV                                 = 0x957E,
    GL_TASK_SUBROUTINE_UNIFORM_NV                                 = 0x957F,
    GL_NUM_TILING_TYPES_EXT                                       = 0x9582,
    GL_TILING_TYPES_EXT                                           = 0x9583,
    GL_OPTIMAL_TILING_EXT                                         = 0x9584,
    GL_LINEAR_TILING_EXT                                          = 0x9585,
    GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_NV                 = 0x959C,
    GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_NV                 = 0x959D,
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_NV         = 0x959E,
    GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_NV         = 0x959F,
    GL_REFERENCED_BY_MESH_SHADER_NV                               = 0x95A0,
    GL_REFERENCED_BY_TASK_SHADER_NV                               = 0x95A1,
    GL_MAX_MESH_WORK_GROUP_INVOCATIONS_NV                         = 0x95A2,
    GL_MAX_TASK_WORK_GROUP_INVOCATIONS_NV                         = 0x95A3,
    GL_ATTACHED_MEMORY_OBJECT_NV                                  = 0x95A4,
    GL_ATTACHED_MEMORY_OFFSET_NV                                  = 0x95A5,
    GL_MEMORY_ATTACHABLE_ALIGNMENT_NV                             = 0x95A6,
    GL_MEMORY_ATTACHABLE_SIZE_NV                                  = 0x95A7,
    GL_MEMORY_ATTACHABLE_NV                                       = 0x95A8,
    GL_DETACHED_MEMORY_INCARNATION_NV                             = 0x95A9,
    GL_DETACHED_TEXTURES_NV                                       = 0x95AA,
    GL_DETACHED_BUFFERS_NV                                        = 0x95AB,
    GL_MAX_DETACHED_TEXTURES_NV                                   = 0x95AC,
    GL_MAX_DETACHED_BUFFERS_NV                                    = 0x95AD,
    GL_SHADING_RATE_SAMPLE_ORDER_DEFAULT_NV                       = 0x95AE,
    GL_SHADING_RATE_SAMPLE_ORDER_PIXEL_MAJOR_NV                   = 0x95AF,
    GL_SHADING_RATE_SAMPLE_ORDER_SAMPLE_MAJOR_NV                  = 0x95B0,
    GL_MAX_VIEWS_OVR                                              = 0x9631,
    GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR                    = 0x9633,
    GL_CULL_VERTEX_IBM                                            = 103050,
    GL_ALL_STATIC_DATA_IBM                                        = 103060,
    GL_STATIC_VERTEX_ARRAY_IBM                                    = 103061,
    GL_VERTEX_ARRAY_LIST_IBM                                      = 103070,
    GL_NORMAL_ARRAY_LIST_IBM                                      = 103071,
    GL_COLOR_ARRAY_LIST_IBM                                       = 103072,
    GL_INDEX_ARRAY_LIST_IBM                                       = 103073,
    GL_TEXTURE_COORD_ARRAY_LIST_IBM                               = 103074,
    GL_EDGE_FLAG_ARRAY_LIST_IBM                                   = 103075,
    GL_FOG_COORDINATE_ARRAY_LIST_IBM                              = 103076,
    GL_SECONDARY_COLOR_ARRAY_LIST_IBM                             = 103077,
    GL_VERTEX_ARRAY_LIST_STRIDE_IBM                               = 103080,
    GL_NORMAL_ARRAY_LIST_STRIDE_IBM                               = 103081,
    GL_COLOR_ARRAY_LIST_STRIDE_IBM                                = 103082,
    GL_INDEX_ARRAY_LIST_STRIDE_IBM                                = 103083,
    GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM                        = 103084,
    GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM                            = 103085,
    GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM                       = 103086,
    GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM                      = 103087,

    // UniformBlockPName

    GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER            = 0x84F0,
    GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER         = 0x84F1,
    GL_UNIFORM_BLOCK_BINDING                                      = 0x8A3F,
    GL_UNIFORM_BLOCK_DATA_SIZE                                    = 0x8A40,
    GL_UNIFORM_BLOCK_NAME_LENGTH                                  = 0x8A41,
    GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS                              = 0x8A42,
    GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES                       = 0x8A43,
    GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER                  = 0x8A44,
    GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER                = 0x8A45,
    GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER                = 0x8A46,
    GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER                 = 0x90EC,

    // UniformPName

    GL_UNIFORM_TYPE                                               = 0x8A37,
//  GL_UNIFORM_SIZE                                               = 0x8A38, // reuse SubroutineParameterName
//  GL_UNIFORM_NAME_LENGTH                                        = 0x8A39, // reuse SubroutineParameterName
    GL_UNIFORM_BLOCK_INDEX                                        = 0x8A3A,
    GL_UNIFORM_OFFSET                                             = 0x8A3B,
    GL_UNIFORM_ARRAY_STRIDE                                       = 0x8A3C,
    GL_UNIFORM_MATRIX_STRIDE                                      = 0x8A3D,
    GL_UNIFORM_IS_ROW_MAJOR                                       = 0x8A3E,
    GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX                        = 0x92DA,

    // UniformType

//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType
//  GL_FLOAT_VEC2                                                 = 0x8B50, // reuse AttributeType
//  GL_FLOAT_VEC3                                                 = 0x8B51, // reuse AttributeType
//  GL_FLOAT_VEC4                                                 = 0x8B52, // reuse AttributeType
//  GL_INT_VEC2                                                   = 0x8B53, // reuse AttributeType
//  GL_INT_VEC3                                                   = 0x8B54, // reuse AttributeType
//  GL_INT_VEC4                                                   = 0x8B55, // reuse AttributeType
//  GL_BOOL                                                       = 0x8B56, // reuse AttributeType
//  GL_BOOL_VEC2                                                  = 0x8B57, // reuse AttributeType
//  GL_BOOL_VEC3                                                  = 0x8B58, // reuse AttributeType
//  GL_BOOL_VEC4                                                  = 0x8B59, // reuse AttributeType
//  GL_FLOAT_MAT2                                                 = 0x8B5A, // reuse AttributeType
//  GL_FLOAT_MAT3                                                 = 0x8B5B, // reuse AttributeType
//  GL_FLOAT_MAT4                                                 = 0x8B5C, // reuse AttributeType
//  GL_SAMPLER_1D                                                 = 0x8B5D, // reuse AttributeType
//  GL_SAMPLER_2D                                                 = 0x8B5E, // reuse AttributeType
//  GL_SAMPLER_3D                                                 = 0x8B5F, // reuse AttributeType
//  GL_SAMPLER_CUBE                                               = 0x8B60, // reuse AttributeType
//  GL_SAMPLER_1D_SHADOW                                          = 0x8B61, // reuse AttributeType
//  GL_SAMPLER_2D_SHADOW                                          = 0x8B62, // reuse AttributeType
//  GL_SAMPLER_2D_RECT                                            = 0x8B63, // reuse AttributeType
//  GL_SAMPLER_2D_RECT_SHADOW                                     = 0x8B64, // reuse AttributeType
//  GL_FLOAT_MAT2x3                                               = 0x8B65, // reuse AttributeType
//  GL_FLOAT_MAT2x4                                               = 0x8B66, // reuse AttributeType
//  GL_FLOAT_MAT3x2                                               = 0x8B67, // reuse AttributeType
//  GL_FLOAT_MAT3x4                                               = 0x8B68, // reuse AttributeType
//  GL_FLOAT_MAT4x2                                               = 0x8B69, // reuse AttributeType
//  GL_FLOAT_MAT4x3                                               = 0x8B6A, // reuse AttributeType
    GL_SAMPLER_1D_ARRAY                                           = 0x8DC0,
    GL_SAMPLER_2D_ARRAY                                           = 0x8DC1,
//  GL_SAMPLER_BUFFER                                             = 0x8DC2, // reuse AttributeType
//  GL_SAMPLER_1D_ARRAY_SHADOW                                    = 0x8DC3, // reuse AttributeType
//  GL_SAMPLER_2D_ARRAY_SHADOW                                    = 0x8DC4, // reuse AttributeType
//  GL_SAMPLER_CUBE_SHADOW                                        = 0x8DC5, // reuse AttributeType
//  GL_UNSIGNED_INT_VEC2                                          = 0x8DC6, // reuse AttributeType
//  GL_UNSIGNED_INT_VEC3                                          = 0x8DC7, // reuse AttributeType
//  GL_UNSIGNED_INT_VEC4                                          = 0x8DC8, // reuse AttributeType
//  GL_INT_SAMPLER_1D                                             = 0x8DC9, // reuse AttributeType
//  GL_INT_SAMPLER_2D                                             = 0x8DCA, // reuse AttributeType
//  GL_INT_SAMPLER_3D                                             = 0x8DCB, // reuse AttributeType
//  GL_INT_SAMPLER_CUBE                                           = 0x8DCC, // reuse AttributeType
//  GL_INT_SAMPLER_2D_RECT                                        = 0x8DCD, // reuse AttributeType
//  GL_INT_SAMPLER_1D_ARRAY                                       = 0x8DCE, // reuse AttributeType
//  GL_INT_SAMPLER_2D_ARRAY                                       = 0x8DCF, // reuse AttributeType
//  GL_INT_SAMPLER_BUFFER                                         = 0x8DD0, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_1D                                    = 0x8DD1, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_2D                                    = 0x8DD2, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_3D                                    = 0x8DD3, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_CUBE                                  = 0x8DD4, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_2D_RECT                               = 0x8DD5, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_1D_ARRAY                              = 0x8DD6, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_2D_ARRAY                              = 0x8DD7, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_BUFFER                                = 0x8DD8, // reuse AttributeType
//  GL_DOUBLE_MAT2                                                = 0x8F46, // reuse AttributeType
//  GL_DOUBLE_MAT3                                                = 0x8F47, // reuse AttributeType
//  GL_DOUBLE_MAT4                                                = 0x8F48, // reuse AttributeType
//  GL_DOUBLE_MAT2x3                                              = 0x8F49, // reuse AttributeType
//  GL_DOUBLE_MAT2x4                                              = 0x8F4A, // reuse AttributeType
//  GL_DOUBLE_MAT3x2                                              = 0x8F4B, // reuse AttributeType
//  GL_DOUBLE_MAT3x4                                              = 0x8F4C, // reuse AttributeType
//  GL_DOUBLE_MAT4x2                                              = 0x8F4D, // reuse AttributeType
//  GL_DOUBLE_MAT4x3                                              = 0x8F4E, // reuse AttributeType
//  GL_DOUBLE_VEC2                                                = 0x8FFC, // reuse AttributeType
//  GL_DOUBLE_VEC3                                                = 0x8FFD, // reuse AttributeType
//  GL_DOUBLE_VEC4                                                = 0x8FFE, // reuse AttributeType
//  GL_SAMPLER_CUBE_MAP_ARRAY                                     = 0x900C, // reuse AttributeType
//  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW                              = 0x900D, // reuse AttributeType
//  GL_INT_SAMPLER_CUBE_MAP_ARRAY                                 = 0x900E, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY                        = 0x900F, // reuse AttributeType
//  GL_SAMPLER_2D_MULTISAMPLE                                     = 0x9108, // reuse AttributeType
//  GL_INT_SAMPLER_2D_MULTISAMPLE                                 = 0x9109, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE                        = 0x910A, // reuse AttributeType
//  GL_SAMPLER_2D_MULTISAMPLE_ARRAY                               = 0x910B, // reuse AttributeType
//  GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                           = 0x910C, // reuse AttributeType
//  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                  = 0x910D, // reuse AttributeType

    // VariantCapEXT

    GL_VARIANT_ARRAY_EXT                                          = 0x87E8,

    // VertexArrayPName

    GL_VERTEX_ATTRIB_RELATIVE_OFFSET                              = 0x82D5,
    GL_VERTEX_ATTRIB_ARRAY_ENABLED                                = 0x8622,
    GL_VERTEX_ATTRIB_ARRAY_SIZE                                   = 0x8623,
    GL_VERTEX_ATTRIB_ARRAY_STRIDE                                 = 0x8624,
    GL_VERTEX_ATTRIB_ARRAY_TYPE                                   = 0x8625,
    GL_VERTEX_ATTRIB_ARRAY_LONG                                   = 0x874E,
    GL_VERTEX_ATTRIB_ARRAY_NORMALIZED                             = 0x886A,
    GL_VERTEX_ATTRIB_ARRAY_INTEGER                                = 0x88FD,
    GL_VERTEX_ATTRIB_ARRAY_DIVISOR                                = 0x88FE,

    // VertexArrayPNameAPPLE

    GL_STORAGE_CLIENT_APPLE                                       = 0x85B4,
    GL_STORAGE_CACHED_APPLE                                       = 0x85BE,
    GL_STORAGE_SHARED_APPLE                                       = 0x85BF,

    // VertexAttribEnum

//  GL_VERTEX_ATTRIB_ARRAY_ENABLED                                = 0x8622, // reuse VertexArrayPName
//  GL_VERTEX_ATTRIB_ARRAY_SIZE                                   = 0x8623, // reuse VertexArrayPName
//  GL_VERTEX_ATTRIB_ARRAY_STRIDE                                 = 0x8624, // reuse VertexArrayPName
//  GL_VERTEX_ATTRIB_ARRAY_TYPE                                   = 0x8625, // reuse VertexArrayPName
    GL_CURRENT_VERTEX_ATTRIB                                      = 0x8626,
//  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED                             = 0x886A, // reuse VertexArrayPName
    GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING                         = 0x889F,
//  GL_VERTEX_ATTRIB_ARRAY_INTEGER                                = 0x88FD, // reuse VertexArrayPName
//  GL_VERTEX_ATTRIB_ARRAY_DIVISOR                                = 0x88FE, // reuse VertexArrayPName

    // VertexAttribEnumNV

    GL_PROGRAM_PARAMETER_NV                                       = 0x8644,

    // VertexAttribIType

//  GL_BYTE                                                       = 0x1400, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType

    // VertexAttribLType

//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // VertexAttribPointerPropertyARB

    GL_VERTEX_ATTRIB_ARRAY_POINTER                                = 0x8645,
    GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB                            = 0x8645,

    // VertexAttribPointerType

//  GL_BYTE                                                       = 0x1400, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType
//  GL_HALF_FLOAT                                                 = 0x140B, // reuse PixelType
    GL_FIXED                                                      = 0x140C,
//  GL_INT64_ARB                                                  = 0x140E, // reuse AttributeType
//  GL_INT64_NV                                                   = 0x140E, // reuse AttributeType
//  GL_UNSIGNED_INT64_ARB                                         = 0x140F, // reuse AttributeType
//  GL_UNSIGNED_INT64_NV                                          = 0x140F, // reuse AttributeType
//  GL_UNSIGNED_INT_2_10_10_10_REV                                = 0x8368, // reuse PixelType
//  GL_UNSIGNED_INT_10F_11F_11F_REV                               = 0x8C3B, // reuse PixelType
    GL_INT_2_10_10_10_REV                                         = 0x8D9F,

    // VertexAttribPropertyARB

    GL_VERTEX_ATTRIB_BINDING                                      = 0x82D4,
//  GL_VERTEX_ATTRIB_RELATIVE_OFFSET                              = 0x82D5, // reuse VertexArrayPName
//  GL_VERTEX_ATTRIB_ARRAY_ENABLED                                = 0x8622, // reuse VertexArrayPName
//  GL_VERTEX_ATTRIB_ARRAY_SIZE                                   = 0x8623, // reuse VertexArrayPName
//  GL_VERTEX_ATTRIB_ARRAY_STRIDE                                 = 0x8624, // reuse VertexArrayPName
//  GL_VERTEX_ATTRIB_ARRAY_TYPE                                   = 0x8625, // reuse VertexArrayPName
//  GL_CURRENT_VERTEX_ATTRIB                                      = 0x8626, // reuse VertexAttribEnum
//  GL_VERTEX_ATTRIB_ARRAY_LONG                                   = 0x874E, // reuse VertexArrayPName
//  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED                             = 0x886A, // reuse VertexArrayPName
//  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING                         = 0x889F, // reuse VertexAttribEnum
//  GL_VERTEX_ATTRIB_ARRAY_INTEGER                                = 0x88FD, // reuse VertexArrayPName
    GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT                            = 0x88FD,
//  GL_VERTEX_ATTRIB_ARRAY_DIVISOR                                = 0x88FE, // reuse VertexArrayPName

    // VertexAttribType

//  GL_BYTE                                                       = 0x1400, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType
//  GL_HALF_FLOAT                                                 = 0x140B, // reuse PixelType
//  GL_FIXED                                                      = 0x140C, // reuse VertexAttribPointerType
//  GL_UNSIGNED_INT_2_10_10_10_REV                                = 0x8368, // reuse PixelType
//  GL_UNSIGNED_INT_10F_11F_11F_REV                               = 0x8C3B, // reuse PixelType
//  GL_INT_2_10_10_10_REV                                         = 0x8D9F, // reuse VertexAttribPointerType

    // VertexBufferObjectUsage

//  GL_STREAM_DRAW                                                = 0x88E0, // reuse BufferUsageARB
//  GL_STREAM_READ                                                = 0x88E1, // reuse BufferUsageARB
//  GL_STREAM_COPY                                                = 0x88E2, // reuse BufferUsageARB
//  GL_STATIC_DRAW                                                = 0x88E4, // reuse BufferUsageARB
//  GL_STATIC_READ                                                = 0x88E5, // reuse BufferUsageARB
//  GL_STATIC_COPY                                                = 0x88E6, // reuse BufferUsageARB
//  GL_DYNAMIC_DRAW                                               = 0x88E8, // reuse BufferUsageARB
//  GL_DYNAMIC_READ                                               = 0x88E9, // reuse BufferUsageARB
//  GL_DYNAMIC_COPY                                               = 0x88EA, // reuse BufferUsageARB

    // VertexPointerType

//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

    // VertexProvokingMode

    GL_FIRST_VERTEX_CONVENTION                                    = 0x8E4D,
    GL_LAST_VERTEX_CONVENTION                                     = 0x8E4E,

    // VertexShaderCoordOutEXT

    GL_X_EXT                                                      = 0x87D5,
    GL_Y_EXT                                                      = 0x87D6,
    GL_Z_EXT                                                      = 0x87D7,
    GL_W_EXT                                                      = 0x87D8,
    GL_NEGATIVE_X_EXT                                             = 0x87D9,
    GL_NEGATIVE_Y_EXT                                             = 0x87DA,
    GL_NEGATIVE_Z_EXT                                             = 0x87DB,
    GL_NEGATIVE_W_EXT                                             = 0x87DC,
    GL_ZERO_EXT                                                   = 0x87DD,
    GL_ONE_EXT                                                    = 0x87DE,
    GL_NEGATIVE_ONE_EXT                                           = 0x87DF,

    // VertexShaderOpEXT

    GL_OP_INDEX_EXT                                               = 0x8782,
    GL_OP_NEGATE_EXT                                              = 0x8783,
    GL_OP_DOT3_EXT                                                = 0x8784,
    GL_OP_DOT4_EXT                                                = 0x8785,
    GL_OP_MUL_EXT                                                 = 0x8786,
    GL_OP_ADD_EXT                                                 = 0x8787,
    GL_OP_MADD_EXT                                                = 0x8788,
    GL_OP_FRAC_EXT                                                = 0x8789,
    GL_OP_MAX_EXT                                                 = 0x878A,
    GL_OP_MIN_EXT                                                 = 0x878B,
    GL_OP_SET_GE_EXT                                              = 0x878C,
    GL_OP_SET_LT_EXT                                              = 0x878D,
    GL_OP_CLAMP_EXT                                               = 0x878E,
    GL_OP_FLOOR_EXT                                               = 0x878F,
    GL_OP_ROUND_EXT                                               = 0x8790,
    GL_OP_EXP_BASE_2_EXT                                          = 0x8791,
    GL_OP_LOG_BASE_2_EXT                                          = 0x8792,
    GL_OP_POWER_EXT                                               = 0x8793,
    GL_OP_RECIP_EXT                                               = 0x8794,
    GL_OP_RECIP_SQRT_EXT                                          = 0x8795,
    GL_OP_SUB_EXT                                                 = 0x8796,
    GL_OP_CROSS_PRODUCT_EXT                                       = 0x8797,
    GL_OP_MULTIPLY_MATRIX_EXT                                     = 0x8798,
    GL_OP_MOV_EXT                                                 = 0x8799,

    // VertexShaderParameterEXT

    GL_CURRENT_VERTEX_EXT                                         = 0x87E2,
    GL_MVP_MATRIX_EXT                                             = 0x87E3,

    // VertexShaderStorageTypeEXT

    GL_VARIANT_EXT                                                = 0x87C1,
    GL_INVARIANT_EXT                                              = 0x87C2,
    GL_LOCAL_CONSTANT_EXT                                         = 0x87C3,
    GL_LOCAL_EXT                                                  = 0x87C4,

    // VertexShaderTextureUnitParameter

//  GL_CURRENT_TEXTURE_COORDS                                     = 0x0B03, // reuse GetPName
//  GL_TEXTURE_MATRIX                                             = 0x0BA8, // reuse GetPName

    // VertexStreamATI

    GL_VERTEX_STREAM0_ATI                                         = 0x876C,
    GL_VERTEX_STREAM1_ATI                                         = 0x876D,
    GL_VERTEX_STREAM2_ATI                                         = 0x876E,
    GL_VERTEX_STREAM3_ATI                                         = 0x876F,
    GL_VERTEX_STREAM4_ATI                                         = 0x8770,
    GL_VERTEX_STREAM5_ATI                                         = 0x8771,
    GL_VERTEX_STREAM6_ATI                                         = 0x8772,
    GL_VERTEX_STREAM7_ATI                                         = 0x8773,

    // VertexWeightPointerTypeEXT

//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType

    // WeightPointerTypeARB

//  GL_BYTE                                                       = 0x1400, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_BYTE                                              = 0x1401, // reuse ColorPointerType
//  GL_SHORT                                                      = 0x1402, // reuse BinormalPointerTypeEXT
//  GL_UNSIGNED_SHORT                                             = 0x1403, // reuse ColorPointerType
//  GL_INT                                                        = 0x1404, // reuse AttributeType
//  GL_UNSIGNED_INT                                               = 0x1405, // reuse AttributeType
//  GL_FLOAT                                                      = 0x1406, // reuse AttributeType
//  GL_DOUBLE                                                     = 0x140A, // reuse AttributeType

};


// import enums to namespace

// AccumOp

GLBINDING_CONSTEXPR static const GLenum GL_ACCUM = GLenum::GL_ACCUM;
GLBINDING_CONSTEXPR static const GLenum GL_LOAD = GLenum::GL_LOAD;
GLBINDING_CONSTEXPR static const GLenum GL_RETURN = GLenum::GL_RETURN;
GLBINDING_CONSTEXPR static const GLenum GL_MULT = GLenum::GL_MULT;
GLBINDING_CONSTEXPR static const GLenum GL_ADD = GLenum::GL_ADD;

// AlphaFunction

GLBINDING_CONSTEXPR static const GLenum GL_NEVER = GLenum::GL_NEVER;
GLBINDING_CONSTEXPR static const GLenum GL_LESS = GLenum::GL_LESS;
GLBINDING_CONSTEXPR static const GLenum GL_EQUAL = GLenum::GL_EQUAL;
GLBINDING_CONSTEXPR static const GLenum GL_LEQUAL = GLenum::GL_LEQUAL;
GLBINDING_CONSTEXPR static const GLenum GL_GREATER = GLenum::GL_GREATER;
GLBINDING_CONSTEXPR static const GLenum GL_NOTEQUAL = GLenum::GL_NOTEQUAL;
GLBINDING_CONSTEXPR static const GLenum GL_GEQUAL = GLenum::GL_GEQUAL;
GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS = GLenum::GL_ALWAYS;

// ArrayObjectPNameATI

GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_BUFFER_SIZE_ATI = GLenum::GL_OBJECT_BUFFER_SIZE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_BUFFER_USAGE_ATI = GLenum::GL_OBJECT_BUFFER_USAGE_ATI;

// ArrayObjectUsageATI

GLBINDING_CONSTEXPR static const GLenum GL_STATIC_ATI = GLenum::GL_STATIC_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_ATI = GLenum::GL_DYNAMIC_ATI;

// AtomicCounterBufferPName

GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_BINDING = GLenum::GL_ATOMIC_COUNTER_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE = GLenum::GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = GLenum::GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = GLenum::GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER;

// AttributeType

GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE;
GLBINDING_CONSTEXPR static const GLenum GL_INT64_ARB = GLenum::GL_INT64_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INT64_NV = GLenum::GL_INT64_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT64_ARB = GLenum::GL_UNSIGNED_INT64_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT64_NV = GLenum::GL_UNSIGNED_INT64_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC2 = GLenum::GL_FLOAT_VEC2;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC2_ARB = GLenum::GL_FLOAT_VEC2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC3 = GLenum::GL_FLOAT_VEC3;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC3_ARB = GLenum::GL_FLOAT_VEC3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC4 = GLenum::GL_FLOAT_VEC4;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_VEC4_ARB = GLenum::GL_FLOAT_VEC4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC2 = GLenum::GL_INT_VEC2;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC2_ARB = GLenum::GL_INT_VEC2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC3 = GLenum::GL_INT_VEC3;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC3_ARB = GLenum::GL_INT_VEC3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC4 = GLenum::GL_INT_VEC4;
GLBINDING_CONSTEXPR static const GLenum GL_INT_VEC4_ARB = GLenum::GL_INT_VEC4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL = GLenum::GL_BOOL;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_ARB = GLenum::GL_BOOL_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC2 = GLenum::GL_BOOL_VEC2;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC2_ARB = GLenum::GL_BOOL_VEC2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC3 = GLenum::GL_BOOL_VEC3;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC3_ARB = GLenum::GL_BOOL_VEC3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC4 = GLenum::GL_BOOL_VEC4;
GLBINDING_CONSTEXPR static const GLenum GL_BOOL_VEC4_ARB = GLenum::GL_BOOL_VEC4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT2 = GLenum::GL_FLOAT_MAT2;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT2_ARB = GLenum::GL_FLOAT_MAT2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT3 = GLenum::GL_FLOAT_MAT3;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT3_ARB = GLenum::GL_FLOAT_MAT3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT4 = GLenum::GL_FLOAT_MAT4;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT4_ARB = GLenum::GL_FLOAT_MAT4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D = GLenum::GL_SAMPLER_1D;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_ARB = GLenum::GL_SAMPLER_1D_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D = GLenum::GL_SAMPLER_2D;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_ARB = GLenum::GL_SAMPLER_2D_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_3D = GLenum::GL_SAMPLER_3D;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_3D_ARB = GLenum::GL_SAMPLER_3D_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_CUBE = GLenum::GL_SAMPLER_CUBE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_CUBE_ARB = GLenum::GL_SAMPLER_CUBE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_SHADOW = GLenum::GL_SAMPLER_1D_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_SHADOW_ARB = GLenum::GL_SAMPLER_1D_SHADOW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_SHADOW = GLenum::GL_SAMPLER_2D_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_SHADOW_ARB = GLenum::GL_SAMPLER_2D_SHADOW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_RECT = GLenum::GL_SAMPLER_2D_RECT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_RECT_ARB = GLenum::GL_SAMPLER_2D_RECT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_RECT_SHADOW = GLenum::GL_SAMPLER_2D_RECT_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_RECT_SHADOW_ARB = GLenum::GL_SAMPLER_2D_RECT_SHADOW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT2x3 = GLenum::GL_FLOAT_MAT2x3;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT2x4 = GLenum::GL_FLOAT_MAT2x4;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT3x2 = GLenum::GL_FLOAT_MAT3x2;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT3x4 = GLenum::GL_FLOAT_MAT3x4;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT4x2 = GLenum::GL_FLOAT_MAT4x2;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_MAT4x3 = GLenum::GL_FLOAT_MAT4x3;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_BUFFER = GLenum::GL_SAMPLER_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_1D_ARRAY_SHADOW = GLenum::GL_SAMPLER_1D_ARRAY_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_ARRAY_SHADOW = GLenum::GL_SAMPLER_2D_ARRAY_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_CUBE_SHADOW = GLenum::GL_SAMPLER_CUBE_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_VEC2 = GLenum::GL_UNSIGNED_INT_VEC2;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_VEC3 = GLenum::GL_UNSIGNED_INT_VEC3;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_VEC4 = GLenum::GL_UNSIGNED_INT_VEC4;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_1D = GLenum::GL_INT_SAMPLER_1D;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D = GLenum::GL_INT_SAMPLER_2D;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_3D = GLenum::GL_INT_SAMPLER_3D;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_CUBE = GLenum::GL_INT_SAMPLER_CUBE;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D_RECT = GLenum::GL_INT_SAMPLER_2D_RECT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_1D_ARRAY = GLenum::GL_INT_SAMPLER_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D_ARRAY = GLenum::GL_INT_SAMPLER_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_BUFFER = GLenum::GL_INT_SAMPLER_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_1D = GLenum::GL_UNSIGNED_INT_SAMPLER_1D;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D = GLenum::GL_UNSIGNED_INT_SAMPLER_2D;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_3D = GLenum::GL_UNSIGNED_INT_SAMPLER_3D;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_CUBE = GLenum::GL_UNSIGNED_INT_SAMPLER_CUBE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D_RECT = GLenum::GL_UNSIGNED_INT_SAMPLER_2D_RECT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = GLenum::GL_UNSIGNED_INT_SAMPLER_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = GLenum::GL_UNSIGNED_INT_SAMPLER_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_BUFFER = GLenum::GL_UNSIGNED_INT_SAMPLER_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_MAT2 = GLenum::GL_DOUBLE_MAT2;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_MAT3 = GLenum::GL_DOUBLE_MAT3;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_MAT4 = GLenum::GL_DOUBLE_MAT4;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_MAT2x3 = GLenum::GL_DOUBLE_MAT2x3;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_MAT2x4 = GLenum::GL_DOUBLE_MAT2x4;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_MAT3x2 = GLenum::GL_DOUBLE_MAT3x2;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_MAT3x4 = GLenum::GL_DOUBLE_MAT3x4;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_MAT4x2 = GLenum::GL_DOUBLE_MAT4x2;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_MAT4x3 = GLenum::GL_DOUBLE_MAT4x3;
GLBINDING_CONSTEXPR static const GLenum GL_INT64_VEC2_ARB = GLenum::GL_INT64_VEC2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INT64_VEC3_ARB = GLenum::GL_INT64_VEC3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INT64_VEC4_ARB = GLenum::GL_INT64_VEC4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT64_VEC2_ARB = GLenum::GL_UNSIGNED_INT64_VEC2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT64_VEC3_ARB = GLenum::GL_UNSIGNED_INT64_VEC3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT64_VEC4_ARB = GLenum::GL_UNSIGNED_INT64_VEC4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_VEC2 = GLenum::GL_DOUBLE_VEC2;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_VEC3 = GLenum::GL_DOUBLE_VEC3;
GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE_VEC4 = GLenum::GL_DOUBLE_VEC4;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_CUBE_MAP_ARRAY = GLenum::GL_SAMPLER_CUBE_MAP_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = GLenum::GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_CUBE_MAP_ARRAY = GLenum::GL_INT_SAMPLER_CUBE_MAP_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = GLenum::GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_1D = GLenum::GL_IMAGE_1D;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_2D = GLenum::GL_IMAGE_2D;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_3D = GLenum::GL_IMAGE_3D;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_2D_RECT = GLenum::GL_IMAGE_2D_RECT;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CUBE = GLenum::GL_IMAGE_CUBE;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_BUFFER = GLenum::GL_IMAGE_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_1D_ARRAY = GLenum::GL_IMAGE_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_2D_ARRAY = GLenum::GL_IMAGE_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CUBE_MAP_ARRAY = GLenum::GL_IMAGE_CUBE_MAP_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_2D_MULTISAMPLE = GLenum::GL_IMAGE_2D_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_2D_MULTISAMPLE_ARRAY = GLenum::GL_IMAGE_2D_MULTISAMPLE_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_1D = GLenum::GL_INT_IMAGE_1D;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_2D = GLenum::GL_INT_IMAGE_2D;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_3D = GLenum::GL_INT_IMAGE_3D;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_2D_RECT = GLenum::GL_INT_IMAGE_2D_RECT;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_CUBE = GLenum::GL_INT_IMAGE_CUBE;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_BUFFER = GLenum::GL_INT_IMAGE_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_1D_ARRAY = GLenum::GL_INT_IMAGE_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_2D_ARRAY = GLenum::GL_INT_IMAGE_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_CUBE_MAP_ARRAY = GLenum::GL_INT_IMAGE_CUBE_MAP_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_2D_MULTISAMPLE = GLenum::GL_INT_IMAGE_2D_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY = GLenum::GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_1D = GLenum::GL_UNSIGNED_INT_IMAGE_1D;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_2D = GLenum::GL_UNSIGNED_INT_IMAGE_2D;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_3D = GLenum::GL_UNSIGNED_INT_IMAGE_3D;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_2D_RECT = GLenum::GL_UNSIGNED_INT_IMAGE_2D_RECT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_CUBE = GLenum::GL_UNSIGNED_INT_IMAGE_CUBE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_BUFFER = GLenum::GL_UNSIGNED_INT_IMAGE_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_1D_ARRAY = GLenum::GL_UNSIGNED_INT_IMAGE_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_2D_ARRAY = GLenum::GL_UNSIGNED_INT_IMAGE_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = GLenum::GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = GLenum::GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = GLenum::GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_MULTISAMPLE = GLenum::GL_SAMPLER_2D_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D_MULTISAMPLE = GLenum::GL_INT_SAMPLER_2D_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = GLenum::GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_2D_MULTISAMPLE_ARRAY = GLenum::GL_SAMPLER_2D_MULTISAMPLE_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = GLenum::GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = GLenum::GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY;

// BindTransformFeedbackTarget

GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK = GLenum::GL_TRANSFORM_FEEDBACK;

// BinormalPointerTypeEXT

GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE;
GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT;
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// BlendEquationModeEXT

GLBINDING_CONSTEXPR static const GLenum GL_FUNC_ADD = GLenum::GL_FUNC_ADD;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_ADD_EXT = GLenum::GL_FUNC_ADD_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MIN = GLenum::GL_MIN;
GLBINDING_CONSTEXPR static const GLenum GL_MIN_EXT = GLenum::GL_MIN_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX = GLenum::GL_MAX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_EXT = GLenum::GL_MAX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_SUBTRACT = GLenum::GL_FUNC_SUBTRACT;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_SUBTRACT_EXT = GLenum::GL_FUNC_SUBTRACT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_REVERSE_SUBTRACT = GLenum::GL_FUNC_REVERSE_SUBTRACT;
GLBINDING_CONSTEXPR static const GLenum GL_FUNC_REVERSE_SUBTRACT_EXT = GLenum::GL_FUNC_REVERSE_SUBTRACT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_MIN_SGIX = GLenum::GL_ALPHA_MIN_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_MAX_SGIX = GLenum::GL_ALPHA_MAX_SGIX;

// BlendingFactor

GLBINDING_CONSTEXPR static const GLenum GL_ZERO = GLenum::GL_ZERO;
GLBINDING_CONSTEXPR static const GLenum GL_SRC_COLOR = GLenum::GL_SRC_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_SRC_COLOR = GLenum::GL_ONE_MINUS_SRC_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_SRC_ALPHA = GLenum::GL_SRC_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_SRC_ALPHA = GLenum::GL_ONE_MINUS_SRC_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_DST_ALPHA = GLenum::GL_DST_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_DST_ALPHA = GLenum::GL_ONE_MINUS_DST_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_DST_COLOR = GLenum::GL_DST_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_DST_COLOR = GLenum::GL_ONE_MINUS_DST_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_SRC_ALPHA_SATURATE = GLenum::GL_SRC_ALPHA_SATURATE;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_COLOR = GLenum::GL_CONSTANT_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_CONSTANT_COLOR = GLenum::GL_ONE_MINUS_CONSTANT_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_ALPHA = GLenum::GL_CONSTANT_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_CONSTANT_ALPHA = GLenum::GL_ONE_MINUS_CONSTANT_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SRC1_ALPHA = GLenum::GL_SRC1_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SRC1_COLOR = GLenum::GL_SRC1_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_SRC1_COLOR = GLenum::GL_ONE_MINUS_SRC1_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_SRC1_ALPHA = GLenum::GL_ONE_MINUS_SRC1_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_ONE = GLenum::GL_ONE;

// BlitFramebufferFilter

GLBINDING_CONSTEXPR static const GLenum GL_NEAREST = GLenum::GL_NEAREST;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR = GLenum::GL_LINEAR;

// Buffer

GLBINDING_CONSTEXPR static const GLenum GL_COLOR = GLenum::GL_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH = GLenum::GL_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL = GLenum::GL_STENCIL;

// BufferAccessARB

GLBINDING_CONSTEXPR static const GLenum GL_READ_ONLY = GLenum::GL_READ_ONLY;
GLBINDING_CONSTEXPR static const GLenum GL_WRITE_ONLY = GLenum::GL_WRITE_ONLY;
GLBINDING_CONSTEXPR static const GLenum GL_READ_WRITE = GLenum::GL_READ_WRITE;

// BufferPNameARB

GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_IMMUTABLE_STORAGE = GLenum::GL_BUFFER_IMMUTABLE_STORAGE;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_STORAGE_FLAGS = GLenum::GL_BUFFER_STORAGE_FLAGS;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_SIZE = GLenum::GL_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_SIZE_ARB = GLenum::GL_BUFFER_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_USAGE = GLenum::GL_BUFFER_USAGE;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_USAGE_ARB = GLenum::GL_BUFFER_USAGE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_ACCESS = GLenum::GL_BUFFER_ACCESS;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_ACCESS_ARB = GLenum::GL_BUFFER_ACCESS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAPPED = GLenum::GL_BUFFER_MAPPED;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAPPED_ARB = GLenum::GL_BUFFER_MAPPED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_ACCESS_FLAGS = GLenum::GL_BUFFER_ACCESS_FLAGS;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAP_LENGTH = GLenum::GL_BUFFER_MAP_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAP_OFFSET = GLenum::GL_BUFFER_MAP_OFFSET;

// BufferPointerNameARB

GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAP_POINTER = GLenum::GL_BUFFER_MAP_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_MAP_POINTER_ARB = GLenum::GL_BUFFER_MAP_POINTER_ARB;

// BufferStorageTarget

GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_BUFFER = GLenum::GL_ARRAY_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_BUFFER = GLenum::GL_ELEMENT_ARRAY_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER = GLenum::GL_PIXEL_PACK_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER = GLenum::GL_PIXEL_UNPACK_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER = GLenum::GL_UNIFORM_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER = GLenum::GL_TEXTURE_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_COPY_READ_BUFFER = GLenum::GL_COPY_READ_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_COPY_WRITE_BUFFER = GLenum::GL_COPY_WRITE_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_INDIRECT_BUFFER = GLenum::GL_DRAW_INDIRECT_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BUFFER = GLenum::GL_SHADER_STORAGE_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_DISPATCH_INDIRECT_BUFFER = GLenum::GL_DISPATCH_INDIRECT_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BUFFER = GLenum::GL_QUERY_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER = GLenum::GL_ATOMIC_COUNTER_BUFFER;

// BufferTargetARB

GLBINDING_CONSTEXPR static const GLenum GL_PARAMETER_BUFFER = GLenum::GL_PARAMETER_BUFFER;
// GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_BUFFER = GLenum::GL_ARRAY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_BUFFER = GLenum::GL_ELEMENT_ARRAY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER = GLenum::GL_PIXEL_PACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER = GLenum::GL_PIXEL_UNPACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER = GLenum::GL_UNIFORM_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER = GLenum::GL_TEXTURE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_COPY_READ_BUFFER = GLenum::GL_COPY_READ_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_COPY_WRITE_BUFFER = GLenum::GL_COPY_WRITE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_DRAW_INDIRECT_BUFFER = GLenum::GL_DRAW_INDIRECT_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BUFFER = GLenum::GL_SHADER_STORAGE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_DISPATCH_INDIRECT_BUFFER = GLenum::GL_DISPATCH_INDIRECT_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BUFFER = GLenum::GL_QUERY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER = GLenum::GL_ATOMIC_COUNTER_BUFFER; // reuse BufferStorageTarget

// BufferUsageARB

GLBINDING_CONSTEXPR static const GLenum GL_STREAM_DRAW = GLenum::GL_STREAM_DRAW;
GLBINDING_CONSTEXPR static const GLenum GL_STREAM_READ = GLenum::GL_STREAM_READ;
GLBINDING_CONSTEXPR static const GLenum GL_STREAM_COPY = GLenum::GL_STREAM_COPY;
GLBINDING_CONSTEXPR static const GLenum GL_STATIC_DRAW = GLenum::GL_STATIC_DRAW;
GLBINDING_CONSTEXPR static const GLenum GL_STATIC_READ = GLenum::GL_STATIC_READ;
GLBINDING_CONSTEXPR static const GLenum GL_STATIC_COPY = GLenum::GL_STATIC_COPY;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_DRAW = GLenum::GL_DYNAMIC_DRAW;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_READ = GLenum::GL_DYNAMIC_READ;
GLBINDING_CONSTEXPR static const GLenum GL_DYNAMIC_COPY = GLenum::GL_DYNAMIC_COPY;

// ClampColorModeARB

GLBINDING_CONSTEXPR static const GLenum GL_FIXED_ONLY = GLenum::GL_FIXED_ONLY;
GLBINDING_CONSTEXPR static const GLenum GL_FIXED_ONLY_ARB = GLenum::GL_FIXED_ONLY_ARB;

// ClampColorTargetARB

GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_VERTEX_COLOR_ARB = GLenum::GL_CLAMP_VERTEX_COLOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_FRAGMENT_COLOR_ARB = GLenum::GL_CLAMP_FRAGMENT_COLOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_READ_COLOR = GLenum::GL_CLAMP_READ_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_READ_COLOR_ARB = GLenum::GL_CLAMP_READ_COLOR_ARB;

// ClipControlDepth

GLBINDING_CONSTEXPR static const GLenum GL_NEGATIVE_ONE_TO_ONE = GLenum::GL_NEGATIVE_ONE_TO_ONE;
GLBINDING_CONSTEXPR static const GLenum GL_ZERO_TO_ONE = GLenum::GL_ZERO_TO_ONE;

// ClipControlOrigin

GLBINDING_CONSTEXPR static const GLenum GL_LOWER_LEFT = GLenum::GL_LOWER_LEFT;
GLBINDING_CONSTEXPR static const GLenum GL_UPPER_LEFT = GLenum::GL_UPPER_LEFT;

// ClipPlaneName

GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE0 = GLenum::GL_CLIP_PLANE0;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE0 = GLenum::GL_CLIP_DISTANCE0;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE1 = GLenum::GL_CLIP_PLANE1;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE1 = GLenum::GL_CLIP_DISTANCE1;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE2 = GLenum::GL_CLIP_PLANE2;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE2 = GLenum::GL_CLIP_DISTANCE2;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE3 = GLenum::GL_CLIP_PLANE3;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE3 = GLenum::GL_CLIP_DISTANCE3;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE4 = GLenum::GL_CLIP_PLANE4;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE4 = GLenum::GL_CLIP_DISTANCE4;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE5 = GLenum::GL_CLIP_PLANE5;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE5 = GLenum::GL_CLIP_DISTANCE5;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE6 = GLenum::GL_CLIP_DISTANCE6;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE7 = GLenum::GL_CLIP_DISTANCE7;

// ColorBuffer

GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT_LEFT = GLenum::GL_FRONT_LEFT;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT_RIGHT = GLenum::GL_FRONT_RIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_BACK_LEFT = GLenum::GL_BACK_LEFT;
GLBINDING_CONSTEXPR static const GLenum GL_BACK_RIGHT = GLenum::GL_BACK_RIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT;
GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK;
GLBINDING_CONSTEXPR static const GLenum GL_LEFT = GLenum::GL_LEFT;
GLBINDING_CONSTEXPR static const GLenum GL_RIGHT = GLenum::GL_RIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT_AND_BACK = GLenum::GL_FRONT_AND_BACK;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT0 = GLenum::GL_COLOR_ATTACHMENT0;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT1 = GLenum::GL_COLOR_ATTACHMENT1;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT2 = GLenum::GL_COLOR_ATTACHMENT2;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT3 = GLenum::GL_COLOR_ATTACHMENT3;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT4 = GLenum::GL_COLOR_ATTACHMENT4;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT5 = GLenum::GL_COLOR_ATTACHMENT5;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT6 = GLenum::GL_COLOR_ATTACHMENT6;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT7 = GLenum::GL_COLOR_ATTACHMENT7;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT8 = GLenum::GL_COLOR_ATTACHMENT8;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT9 = GLenum::GL_COLOR_ATTACHMENT9;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT10 = GLenum::GL_COLOR_ATTACHMENT10;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT11 = GLenum::GL_COLOR_ATTACHMENT11;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT12 = GLenum::GL_COLOR_ATTACHMENT12;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT13 = GLenum::GL_COLOR_ATTACHMENT13;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT14 = GLenum::GL_COLOR_ATTACHMENT14;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT15 = GLenum::GL_COLOR_ATTACHMENT15;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT16 = GLenum::GL_COLOR_ATTACHMENT16;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT17 = GLenum::GL_COLOR_ATTACHMENT17;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT18 = GLenum::GL_COLOR_ATTACHMENT18;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT19 = GLenum::GL_COLOR_ATTACHMENT19;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT20 = GLenum::GL_COLOR_ATTACHMENT20;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT21 = GLenum::GL_COLOR_ATTACHMENT21;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT22 = GLenum::GL_COLOR_ATTACHMENT22;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT23 = GLenum::GL_COLOR_ATTACHMENT23;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT24 = GLenum::GL_COLOR_ATTACHMENT24;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT25 = GLenum::GL_COLOR_ATTACHMENT25;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT26 = GLenum::GL_COLOR_ATTACHMENT26;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT27 = GLenum::GL_COLOR_ATTACHMENT27;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT28 = GLenum::GL_COLOR_ATTACHMENT28;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT29 = GLenum::GL_COLOR_ATTACHMENT29;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT30 = GLenum::GL_COLOR_ATTACHMENT30;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT31 = GLenum::GL_COLOR_ATTACHMENT31;

// ColorMaterialParameter

GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT = GLenum::GL_AMBIENT;
GLBINDING_CONSTEXPR static const GLenum GL_DIFFUSE = GLenum::GL_DIFFUSE;
GLBINDING_CONSTEXPR static const GLenum GL_SPECULAR = GLenum::GL_SPECULAR;
GLBINDING_CONSTEXPR static const GLenum GL_EMISSION = GLenum::GL_EMISSION;
GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT_AND_DIFFUSE = GLenum::GL_AMBIENT_AND_DIFFUSE;

// ColorPointerType

// GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE; // reuse BinormalPointerTypeEXT
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE;
// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse BinormalPointerTypeEXT
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT;
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// ColorTableParameterPName

GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SCALE = GLenum::GL_COLOR_TABLE_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SCALE_SGI = GLenum::GL_COLOR_TABLE_SCALE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_BIAS = GLenum::GL_COLOR_TABLE_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_BIAS_SGI = GLenum::GL_COLOR_TABLE_BIAS_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_FORMAT = GLenum::GL_COLOR_TABLE_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_FORMAT_SGI = GLenum::GL_COLOR_TABLE_FORMAT_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_WIDTH = GLenum::GL_COLOR_TABLE_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_WIDTH_SGI = GLenum::GL_COLOR_TABLE_WIDTH_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_RED_SIZE = GLenum::GL_COLOR_TABLE_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_RED_SIZE_SGI = GLenum::GL_COLOR_TABLE_RED_SIZE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_GREEN_SIZE = GLenum::GL_COLOR_TABLE_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_GREEN_SIZE_SGI = GLenum::GL_COLOR_TABLE_GREEN_SIZE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_BLUE_SIZE = GLenum::GL_COLOR_TABLE_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_BLUE_SIZE_SGI = GLenum::GL_COLOR_TABLE_BLUE_SIZE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_ALPHA_SIZE = GLenum::GL_COLOR_TABLE_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_ALPHA_SIZE_SGI = GLenum::GL_COLOR_TABLE_ALPHA_SIZE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_LUMINANCE_SIZE = GLenum::GL_COLOR_TABLE_LUMINANCE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_LUMINANCE_SIZE_SGI = GLenum::GL_COLOR_TABLE_LUMINANCE_SIZE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_INTENSITY_SIZE = GLenum::GL_COLOR_TABLE_INTENSITY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_INTENSITY_SIZE_SGI = GLenum::GL_COLOR_TABLE_INTENSITY_SIZE_SGI;

// ColorTableTarget

GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE = GLenum::GL_COLOR_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_COLOR_TABLE = GLenum::GL_PROXY_COLOR_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = GLenum::GL_PROXY_POST_CONVOLUTION_COLOR_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = GLenum::GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE;

// ColorTableTargetSGI

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COLOR_TABLE_SGI = GLenum::GL_TEXTURE_COLOR_TABLE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_COLOR_TABLE_SGI = GLenum::GL_PROXY_TEXTURE_COLOR_TABLE_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE = GLenum::GL_COLOR_TABLE; // reuse ColorTableTarget
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SGI = GLenum::GL_COLOR_TABLE_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE; // reuse ColorTableTarget
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE_SGI = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE; // reuse ColorTableTarget
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_PROXY_COLOR_TABLE = GLenum::GL_PROXY_COLOR_TABLE; // reuse ColorTableTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_COLOR_TABLE_SGI = GLenum::GL_PROXY_COLOR_TABLE_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = GLenum::GL_PROXY_POST_CONVOLUTION_COLOR_TABLE; // reuse ColorTableTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = GLenum::GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = GLenum::GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE; // reuse ColorTableTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = GLenum::GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI;

// CombinerBiasNV

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_BIAS_BY_NEGATIVE_ONE_HALF_NV = GLenum::GL_BIAS_BY_NEGATIVE_ONE_HALF_NV;

// CombinerComponentUsageNV

GLBINDING_CONSTEXPR static const GLenum GL_BLUE = GLenum::GL_BLUE;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA = GLenum::GL_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_RGB = GLenum::GL_RGB;

// CombinerMappingNV

GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_IDENTITY_NV = GLenum::GL_UNSIGNED_IDENTITY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INVERT_NV = GLenum::GL_UNSIGNED_INVERT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EXPAND_NORMAL_NV = GLenum::GL_EXPAND_NORMAL_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EXPAND_NEGATE_NV = GLenum::GL_EXPAND_NEGATE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HALF_BIAS_NORMAL_NV = GLenum::GL_HALF_BIAS_NORMAL_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HALF_BIAS_NEGATE_NV = GLenum::GL_HALF_BIAS_NEGATE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_IDENTITY_NV = GLenum::GL_SIGNED_IDENTITY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_NEGATE_NV = GLenum::GL_SIGNED_NEGATE_NV;

// CombinerParameterNV

GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_INPUT_NV = GLenum::GL_COMBINER_INPUT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_MAPPING_NV = GLenum::GL_COMBINER_MAPPING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_COMPONENT_USAGE_NV = GLenum::GL_COMBINER_COMPONENT_USAGE_NV;

// CombinerPortionNV

// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA = GLenum::GL_ALPHA; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_RGB = GLenum::GL_RGB; // reuse CombinerComponentUsageNV

// CombinerRegisterNV

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE0_ARB = GLenum::GL_TEXTURE0_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE1_ARB = GLenum::GL_TEXTURE1_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR_NV = GLenum::GL_PRIMARY_COLOR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_NV = GLenum::GL_SECONDARY_COLOR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SPARE0_NV = GLenum::GL_SPARE0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SPARE1_NV = GLenum::GL_SPARE1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DISCARD_NV = GLenum::GL_DISCARD_NV;

// CombinerScaleNV

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_SCALE_BY_TWO_NV = GLenum::GL_SCALE_BY_TWO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SCALE_BY_FOUR_NV = GLenum::GL_SCALE_BY_FOUR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SCALE_BY_ONE_HALF_NV = GLenum::GL_SCALE_BY_ONE_HALF_NV;

// CombinerStageNV

GLBINDING_CONSTEXPR static const GLenum GL_COMBINER0_NV = GLenum::GL_COMBINER0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER1_NV = GLenum::GL_COMBINER1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER2_NV = GLenum::GL_COMBINER2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER3_NV = GLenum::GL_COMBINER3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER4_NV = GLenum::GL_COMBINER4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER5_NV = GLenum::GL_COMBINER5_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER6_NV = GLenum::GL_COMBINER6_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER7_NV = GLenum::GL_COMBINER7_NV;

// CombinerVariableNV

GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_A_NV = GLenum::GL_VARIABLE_A_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_B_NV = GLenum::GL_VARIABLE_B_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_C_NV = GLenum::GL_VARIABLE_C_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_D_NV = GLenum::GL_VARIABLE_D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_E_NV = GLenum::GL_VARIABLE_E_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_F_NV = GLenum::GL_VARIABLE_F_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VARIABLE_G_NV = GLenum::GL_VARIABLE_G_NV;

// CommandOpcodesNV

GLBINDING_CONSTEXPR static const GLenum GL_TERMINATE_SEQUENCE_COMMAND_NV = GLenum::GL_TERMINATE_SEQUENCE_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_NOP_COMMAND_NV = GLenum::GL_NOP_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ELEMENTS_COMMAND_NV = GLenum::GL_DRAW_ELEMENTS_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ARRAYS_COMMAND_NV = GLenum::GL_DRAW_ARRAYS_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ELEMENTS_STRIP_COMMAND_NV = GLenum::GL_DRAW_ELEMENTS_STRIP_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ARRAYS_STRIP_COMMAND_NV = GLenum::GL_DRAW_ARRAYS_STRIP_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV = GLenum::GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV = GLenum::GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ADDRESS_COMMAND_NV = GLenum::GL_ELEMENT_ADDRESS_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIBUTE_ADDRESS_COMMAND_NV = GLenum::GL_ATTRIBUTE_ADDRESS_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_ADDRESS_COMMAND_NV = GLenum::GL_UNIFORM_ADDRESS_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_COLOR_COMMAND_NV = GLenum::GL_BLEND_COLOR_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_REF_COMMAND_NV = GLenum::GL_STENCIL_REF_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_WIDTH_COMMAND_NV = GLenum::GL_LINE_WIDTH_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_COMMAND_NV = GLenum::GL_POLYGON_OFFSET_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_REF_COMMAND_NV = GLenum::GL_ALPHA_REF_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VIEWPORT_COMMAND_NV = GLenum::GL_VIEWPORT_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SCISSOR_COMMAND_NV = GLenum::GL_SCISSOR_COMMAND_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT_FACE_COMMAND_NV = GLenum::GL_FRONT_FACE_COMMAND_NV;

// ConditionalRenderMode

GLBINDING_CONSTEXPR static const GLenum GL_QUERY_WAIT = GLenum::GL_QUERY_WAIT;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_NO_WAIT = GLenum::GL_QUERY_NO_WAIT;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BY_REGION_WAIT = GLenum::GL_QUERY_BY_REGION_WAIT;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BY_REGION_NO_WAIT = GLenum::GL_QUERY_BY_REGION_NO_WAIT;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_WAIT_INVERTED = GLenum::GL_QUERY_WAIT_INVERTED;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_NO_WAIT_INVERTED = GLenum::GL_QUERY_NO_WAIT_INVERTED;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BY_REGION_WAIT_INVERTED = GLenum::GL_QUERY_BY_REGION_WAIT_INVERTED;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BY_REGION_NO_WAIT_INVERTED = GLenum::GL_QUERY_BY_REGION_NO_WAIT_INVERTED;

// ContainerType

GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_OBJECT_ARB = GLenum::GL_PROGRAM_OBJECT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_OBJECT_EXT = GLenum::GL_PROGRAM_OBJECT_EXT;

// ConvolutionBorderModeEXT

GLBINDING_CONSTEXPR static const GLenum GL_REDUCE = GLenum::GL_REDUCE;
GLBINDING_CONSTEXPR static const GLenum GL_REDUCE_EXT = GLenum::GL_REDUCE_EXT;

// ConvolutionParameter

GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_BORDER_MODE = GLenum::GL_CONVOLUTION_BORDER_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_BORDER_MODE_EXT = GLenum::GL_CONVOLUTION_BORDER_MODE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_SCALE = GLenum::GL_CONVOLUTION_FILTER_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_SCALE_EXT = GLenum::GL_CONVOLUTION_FILTER_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_BIAS = GLenum::GL_CONVOLUTION_FILTER_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FILTER_BIAS_EXT = GLenum::GL_CONVOLUTION_FILTER_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FORMAT = GLenum::GL_CONVOLUTION_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_FORMAT_EXT = GLenum::GL_CONVOLUTION_FORMAT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_WIDTH = GLenum::GL_CONVOLUTION_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_WIDTH_EXT = GLenum::GL_CONVOLUTION_WIDTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_HEIGHT = GLenum::GL_CONVOLUTION_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_HEIGHT_EXT = GLenum::GL_CONVOLUTION_HEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CONVOLUTION_WIDTH = GLenum::GL_MAX_CONVOLUTION_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CONVOLUTION_WIDTH_EXT = GLenum::GL_MAX_CONVOLUTION_WIDTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CONVOLUTION_HEIGHT = GLenum::GL_MAX_CONVOLUTION_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CONVOLUTION_HEIGHT_EXT = GLenum::GL_MAX_CONVOLUTION_HEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_BORDER_COLOR = GLenum::GL_CONVOLUTION_BORDER_COLOR;

// ConvolutionTarget

GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_1D = GLenum::GL_CONVOLUTION_1D;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_2D = GLenum::GL_CONVOLUTION_2D;

// ConvolutionTargetEXT

// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_1D = GLenum::GL_CONVOLUTION_1D; // reuse ConvolutionTarget
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_1D_EXT = GLenum::GL_CONVOLUTION_1D_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_2D = GLenum::GL_CONVOLUTION_2D; // reuse ConvolutionTarget
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_2D_EXT = GLenum::GL_CONVOLUTION_2D_EXT;

// CopyBufferSubDataTarget

// GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_BUFFER = GLenum::GL_ARRAY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_BUFFER = GLenum::GL_ELEMENT_ARRAY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER = GLenum::GL_PIXEL_PACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER = GLenum::GL_PIXEL_UNPACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER = GLenum::GL_UNIFORM_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER = GLenum::GL_TEXTURE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_COPY_READ_BUFFER = GLenum::GL_COPY_READ_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_COPY_WRITE_BUFFER = GLenum::GL_COPY_WRITE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_DRAW_INDIRECT_BUFFER = GLenum::GL_DRAW_INDIRECT_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BUFFER = GLenum::GL_SHADER_STORAGE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_DISPATCH_INDIRECT_BUFFER = GLenum::GL_DISPATCH_INDIRECT_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_QUERY_BUFFER = GLenum::GL_QUERY_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER = GLenum::GL_ATOMIC_COUNTER_BUFFER; // reuse BufferStorageTarget

// CopyImageSubDataTarget

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D = GLenum::GL_TEXTURE_1D;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D = GLenum::GL_TEXTURE_2D;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D = GLenum::GL_TEXTURE_3D;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RECTANGLE = GLenum::GL_TEXTURE_RECTANGLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP = GLenum::GL_TEXTURE_CUBE_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D_ARRAY = GLenum::GL_TEXTURE_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_ARRAY = GLenum::GL_TEXTURE_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER = GLenum::GL_RENDERBUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_ARRAY = GLenum::GL_TEXTURE_CUBE_MAP_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_MULTISAMPLE = GLenum::GL_TEXTURE_2D_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_MULTISAMPLE_ARRAY = GLenum::GL_TEXTURE_2D_MULTISAMPLE_ARRAY;

// CullParameterEXT

GLBINDING_CONSTEXPR static const GLenum GL_CULL_VERTEX_EYE_POSITION_EXT = GLenum::GL_CULL_VERTEX_EYE_POSITION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_VERTEX_OBJECT_POSITION_EXT = GLenum::GL_CULL_VERTEX_OBJECT_POSITION_EXT;

// DataTypeEXT

GLBINDING_CONSTEXPR static const GLenum GL_SCALAR_EXT = GLenum::GL_SCALAR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VECTOR_EXT = GLenum::GL_VECTOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_EXT = GLenum::GL_MATRIX_EXT;

// DebugSeverity

GLBINDING_CONSTEXPR static const GLenum GL_DONT_CARE = GLenum::GL_DONT_CARE;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SEVERITY_NOTIFICATION = GLenum::GL_DEBUG_SEVERITY_NOTIFICATION;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SEVERITY_HIGH = GLenum::GL_DEBUG_SEVERITY_HIGH;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SEVERITY_MEDIUM = GLenum::GL_DEBUG_SEVERITY_MEDIUM;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SEVERITY_LOW = GLenum::GL_DEBUG_SEVERITY_LOW;

// DebugSource

// GLBINDING_CONSTEXPR static const GLenum GL_DONT_CARE = GLenum::GL_DONT_CARE; // reuse DebugSeverity
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_API = GLenum::GL_DEBUG_SOURCE_API;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_WINDOW_SYSTEM = GLenum::GL_DEBUG_SOURCE_WINDOW_SYSTEM;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_SHADER_COMPILER = GLenum::GL_DEBUG_SOURCE_SHADER_COMPILER;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_THIRD_PARTY = GLenum::GL_DEBUG_SOURCE_THIRD_PARTY;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_APPLICATION = GLenum::GL_DEBUG_SOURCE_APPLICATION;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_OTHER = GLenum::GL_DEBUG_SOURCE_OTHER;

// DebugType

// GLBINDING_CONSTEXPR static const GLenum GL_DONT_CARE = GLenum::GL_DONT_CARE; // reuse DebugSeverity
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_ERROR = GLenum::GL_DEBUG_TYPE_ERROR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = GLenum::GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = GLenum::GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PORTABILITY = GLenum::GL_DEBUG_TYPE_PORTABILITY;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PERFORMANCE = GLenum::GL_DEBUG_TYPE_PERFORMANCE;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_OTHER = GLenum::GL_DEBUG_TYPE_OTHER;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_MARKER = GLenum::GL_DEBUG_TYPE_MARKER;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PUSH_GROUP = GLenum::GL_DEBUG_TYPE_PUSH_GROUP;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_POP_GROUP = GLenum::GL_DEBUG_TYPE_POP_GROUP;

// DepthFunction

// GLBINDING_CONSTEXPR static const GLenum GL_NEVER = GLenum::GL_NEVER; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_LESS = GLenum::GL_LESS; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_EQUAL = GLenum::GL_EQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_LEQUAL = GLenum::GL_LEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_GREATER = GLenum::GL_GREATER; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_NOTEQUAL = GLenum::GL_NOTEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_GEQUAL = GLenum::GL_GEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS = GLenum::GL_ALWAYS; // reuse AlphaFunction

// DepthStencilTextureMode

GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX = GLenum::GL_STENCIL_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT = GLenum::GL_DEPTH_COMPONENT;

// DrawBufferMode

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_LEFT = GLenum::GL_FRONT_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_RIGHT = GLenum::GL_FRONT_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK_LEFT = GLenum::GL_BACK_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK_RIGHT = GLenum::GL_BACK_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_LEFT = GLenum::GL_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_RIGHT = GLenum::GL_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_AND_BACK = GLenum::GL_FRONT_AND_BACK; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_AUX0 = GLenum::GL_AUX0;
GLBINDING_CONSTEXPR static const GLenum GL_AUX1 = GLenum::GL_AUX1;
GLBINDING_CONSTEXPR static const GLenum GL_AUX2 = GLenum::GL_AUX2;
GLBINDING_CONSTEXPR static const GLenum GL_AUX3 = GLenum::GL_AUX3;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT0 = GLenum::GL_COLOR_ATTACHMENT0; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT1 = GLenum::GL_COLOR_ATTACHMENT1; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT2 = GLenum::GL_COLOR_ATTACHMENT2; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT3 = GLenum::GL_COLOR_ATTACHMENT3; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT4 = GLenum::GL_COLOR_ATTACHMENT4; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT5 = GLenum::GL_COLOR_ATTACHMENT5; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT6 = GLenum::GL_COLOR_ATTACHMENT6; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT7 = GLenum::GL_COLOR_ATTACHMENT7; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT8 = GLenum::GL_COLOR_ATTACHMENT8; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT9 = GLenum::GL_COLOR_ATTACHMENT9; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT10 = GLenum::GL_COLOR_ATTACHMENT10; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT11 = GLenum::GL_COLOR_ATTACHMENT11; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT12 = GLenum::GL_COLOR_ATTACHMENT12; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT13 = GLenum::GL_COLOR_ATTACHMENT13; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT14 = GLenum::GL_COLOR_ATTACHMENT14; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT15 = GLenum::GL_COLOR_ATTACHMENT15; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT16 = GLenum::GL_COLOR_ATTACHMENT16; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT17 = GLenum::GL_COLOR_ATTACHMENT17; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT18 = GLenum::GL_COLOR_ATTACHMENT18; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT19 = GLenum::GL_COLOR_ATTACHMENT19; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT20 = GLenum::GL_COLOR_ATTACHMENT20; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT21 = GLenum::GL_COLOR_ATTACHMENT21; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT22 = GLenum::GL_COLOR_ATTACHMENT22; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT23 = GLenum::GL_COLOR_ATTACHMENT23; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT24 = GLenum::GL_COLOR_ATTACHMENT24; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT25 = GLenum::GL_COLOR_ATTACHMENT25; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT26 = GLenum::GL_COLOR_ATTACHMENT26; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT27 = GLenum::GL_COLOR_ATTACHMENT27; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT28 = GLenum::GL_COLOR_ATTACHMENT28; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT29 = GLenum::GL_COLOR_ATTACHMENT29; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT30 = GLenum::GL_COLOR_ATTACHMENT30; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT31 = GLenum::GL_COLOR_ATTACHMENT31; // reuse ColorBuffer

// DrawElementsType

// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse AttributeType

// ElementPointerTypeATI

// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse AttributeType

// EnableCap

GLBINDING_CONSTEXPR static const GLenum GL_POINT_SMOOTH = GLenum::GL_POINT_SMOOTH;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_SMOOTH = GLenum::GL_LINE_SMOOTH;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STIPPLE = GLenum::GL_LINE_STIPPLE;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_SMOOTH = GLenum::GL_POLYGON_SMOOTH;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_STIPPLE = GLenum::GL_POLYGON_STIPPLE;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_FACE = GLenum::GL_CULL_FACE;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHTING = GLenum::GL_LIGHTING;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATERIAL = GLenum::GL_COLOR_MATERIAL;
GLBINDING_CONSTEXPR static const GLenum GL_FOG = GLenum::GL_FOG;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_TEST = GLenum::GL_DEPTH_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_TEST = GLenum::GL_STENCIL_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_NORMALIZE = GLenum::GL_NORMALIZE;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_TEST = GLenum::GL_ALPHA_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_DITHER = GLenum::GL_DITHER;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND = GLenum::GL_BLEND;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_LOGIC_OP = GLenum::GL_INDEX_LOGIC_OP;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_LOGIC_OP = GLenum::GL_COLOR_LOGIC_OP;
GLBINDING_CONSTEXPR static const GLenum GL_SCISSOR_TEST = GLenum::GL_SCISSOR_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_S = GLenum::GL_TEXTURE_GEN_S;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_T = GLenum::GL_TEXTURE_GEN_T;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_R = GLenum::GL_TEXTURE_GEN_R;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_Q = GLenum::GL_TEXTURE_GEN_Q;
GLBINDING_CONSTEXPR static const GLenum GL_AUTO_NORMAL = GLenum::GL_AUTO_NORMAL;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_COLOR_4 = GLenum::GL_MAP1_COLOR_4;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_INDEX = GLenum::GL_MAP1_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_NORMAL = GLenum::GL_MAP1_NORMAL;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_1 = GLenum::GL_MAP1_TEXTURE_COORD_1;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_2 = GLenum::GL_MAP1_TEXTURE_COORD_2;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_3 = GLenum::GL_MAP1_TEXTURE_COORD_3;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_4 = GLenum::GL_MAP1_TEXTURE_COORD_4;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_3 = GLenum::GL_MAP1_VERTEX_3;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_4 = GLenum::GL_MAP1_VERTEX_4;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_COLOR_4 = GLenum::GL_MAP2_COLOR_4;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_INDEX = GLenum::GL_MAP2_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_NORMAL = GLenum::GL_MAP2_NORMAL;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_1 = GLenum::GL_MAP2_TEXTURE_COORD_1;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_2 = GLenum::GL_MAP2_TEXTURE_COORD_2;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_3 = GLenum::GL_MAP2_TEXTURE_COORD_3;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_4 = GLenum::GL_MAP2_TEXTURE_COORD_4;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_3 = GLenum::GL_MAP2_VERTEX_3;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_4 = GLenum::GL_MAP2_VERTEX_4;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D = GLenum::GL_TEXTURE_1D; // reuse CopyImageSubDataTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D = GLenum::GL_TEXTURE_2D; // reuse CopyImageSubDataTarget
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_POINT = GLenum::GL_POLYGON_OFFSET_POINT;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_LINE = GLenum::GL_POLYGON_OFFSET_LINE;
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE0 = GLenum::GL_CLIP_PLANE0; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE0 = GLenum::GL_CLIP_DISTANCE0; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE1 = GLenum::GL_CLIP_PLANE1; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE1 = GLenum::GL_CLIP_DISTANCE1; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE2 = GLenum::GL_CLIP_PLANE2; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE2 = GLenum::GL_CLIP_DISTANCE2; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE3 = GLenum::GL_CLIP_PLANE3; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE3 = GLenum::GL_CLIP_DISTANCE3; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE4 = GLenum::GL_CLIP_PLANE4; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE4 = GLenum::GL_CLIP_DISTANCE4; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE5 = GLenum::GL_CLIP_PLANE5; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE5 = GLenum::GL_CLIP_DISTANCE5; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE6 = GLenum::GL_CLIP_DISTANCE6; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_DISTANCE7 = GLenum::GL_CLIP_DISTANCE7; // reuse ClipPlaneName
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT0 = GLenum::GL_LIGHT0;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT1 = GLenum::GL_LIGHT1;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT2 = GLenum::GL_LIGHT2;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT3 = GLenum::GL_LIGHT3;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT4 = GLenum::GL_LIGHT4;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT5 = GLenum::GL_LIGHT5;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT6 = GLenum::GL_LIGHT6;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT7 = GLenum::GL_LIGHT7;
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_1D_EXT = GLenum::GL_CONVOLUTION_1D_EXT; // reuse ConvolutionTargetEXT
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_2D_EXT = GLenum::GL_CONVOLUTION_2D_EXT; // reuse ConvolutionTargetEXT
GLBINDING_CONSTEXPR static const GLenum GL_SEPARABLE_2D_EXT = GLenum::GL_SEPARABLE_2D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_EXT = GLenum::GL_HISTOGRAM_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_EXT = GLenum::GL_MINMAX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_FILL = GLenum::GL_POLYGON_OFFSET_FILL;
GLBINDING_CONSTEXPR static const GLenum GL_RESCALE_NORMAL_EXT = GLenum::GL_RESCALE_NORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D_EXT = GLenum::GL_TEXTURE_3D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY = GLenum::GL_VERTEX_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY = GLenum::GL_NORMAL_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY = GLenum::GL_COLOR_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY = GLenum::GL_INDEX_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY = GLenum::GL_TEXTURE_COORD_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY = GLenum::GL_EDGE_FLAG_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_INTERLACE_SGIX = GLenum::GL_INTERLACE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE = GLenum::GL_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_SGIS = GLenum::GL_MULTISAMPLE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_COVERAGE = GLenum::GL_SAMPLE_ALPHA_TO_COVERAGE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_MASK_SGIS = GLenum::GL_SAMPLE_ALPHA_TO_MASK_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_ONE = GLenum::GL_SAMPLE_ALPHA_TO_ONE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_ONE_SGIS = GLenum::GL_SAMPLE_ALPHA_TO_ONE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE = GLenum::GL_SAMPLE_COVERAGE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_SGIS = GLenum::GL_SAMPLE_MASK_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COLOR_TABLE_SGI = GLenum::GL_TEXTURE_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE = GLenum::GL_COLOR_TABLE; // reuse ColorTableTarget
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SGI = GLenum::GL_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE; // reuse ColorTableTarget
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE_SGI = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE; // reuse ColorTableTarget
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4D_SGIS = GLenum::GL_TEXTURE_4D_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TEX_GEN_SGIX = GLenum::GL_PIXEL_TEX_GEN_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_SGIX = GLenum::GL_SPRITE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_REFERENCE_PLANE_SGIX = GLenum::GL_REFERENCE_PLANE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_IR_INSTRUMENT1_SGIX = GLenum::GL_IR_INSTRUMENT1_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_CALLIGRAPHIC_FRAGMENT_SGIX = GLenum::GL_CALLIGRAPHIC_FRAGMENT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEZOOM_SGIX = GLenum::GL_FRAMEZOOM_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_OFFSET_SGIX = GLenum::GL_FOG_OFFSET_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SHARED_TEXTURE_PALETTE_EXT = GLenum::GL_SHARED_TEXTURE_PALETTE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_OUTPUT_SYNCHRONOUS = GLenum::GL_DEBUG_OUTPUT_SYNCHRONOUS;
GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_HISTOGRAM_SGIX = GLenum::GL_ASYNC_HISTOGRAM_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TEXTURE_SGIS = GLenum::GL_PIXEL_TEXTURE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_TEX_IMAGE_SGIX = GLenum::GL_ASYNC_TEX_IMAGE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_DRAW_PIXELS_SGIX = GLenum::GL_ASYNC_DRAW_PIXELS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_READ_PIXELS_SGIX = GLenum::GL_ASYNC_READ_PIXELS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHTING_SGIX = GLenum::GL_FRAGMENT_LIGHTING_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_COLOR_MATERIAL_SGIX = GLenum::GL_FRAGMENT_COLOR_MATERIAL_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT0_SGIX = GLenum::GL_FRAGMENT_LIGHT0_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT1_SGIX = GLenum::GL_FRAGMENT_LIGHT1_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT2_SGIX = GLenum::GL_FRAGMENT_LIGHT2_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT3_SGIX = GLenum::GL_FRAGMENT_LIGHT3_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT4_SGIX = GLenum::GL_FRAGMENT_LIGHT4_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT5_SGIX = GLenum::GL_FRAGMENT_LIGHT5_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT6_SGIX = GLenum::GL_FRAGMENT_LIGHT6_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT7_SGIX = GLenum::GL_FRAGMENT_LIGHT7_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RECTANGLE = GLenum::GL_TEXTURE_RECTANGLE; // reuse CopyImageSubDataTarget
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RECTANGLE_ARB = GLenum::GL_TEXTURE_RECTANGLE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RECTANGLE_NV = GLenum::GL_TEXTURE_RECTANGLE_NV;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP = GLenum::GL_TEXTURE_CUBE_MAP; // reuse CopyImageSubDataTarget
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_ARB = GLenum::GL_TEXTURE_CUBE_MAP_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_EXT = GLenum::GL_TEXTURE_CUBE_MAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_POINT_SIZE = GLenum::GL_PROGRAM_POINT_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_CLAMP = GLenum::GL_DEPTH_CLAMP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_SEAMLESS = GLenum::GL_TEXTURE_CUBE_MAP_SEAMLESS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_SHADING = GLenum::GL_SAMPLE_SHADING;
GLBINDING_CONSTEXPR static const GLenum GL_RASTERIZER_DISCARD = GLenum::GL_RASTERIZER_DISCARD;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_RESTART_FIXED_INDEX = GLenum::GL_PRIMITIVE_RESTART_FIXED_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_SRGB = GLenum::GL_FRAMEBUFFER_SRGB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK = GLenum::GL_SAMPLE_MASK;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_RESTART = GLenum::GL_PRIMITIVE_RESTART;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_OUTPUT = GLenum::GL_DEBUG_OUTPUT;
GLBINDING_CONSTEXPR static const GLenum GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV = GLenum::GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV;

// ErrorCode

GLBINDING_CONSTEXPR static const GLenum GL_NO_ERROR = GLenum::GL_NO_ERROR;
GLBINDING_CONSTEXPR static const GLenum GL_INVALID_ENUM = GLenum::GL_INVALID_ENUM;
GLBINDING_CONSTEXPR static const GLenum GL_INVALID_VALUE = GLenum::GL_INVALID_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_INVALID_OPERATION = GLenum::GL_INVALID_OPERATION;
GLBINDING_CONSTEXPR static const GLenum GL_STACK_OVERFLOW = GLenum::GL_STACK_OVERFLOW;
GLBINDING_CONSTEXPR static const GLenum GL_STACK_UNDERFLOW = GLenum::GL_STACK_UNDERFLOW;
GLBINDING_CONSTEXPR static const GLenum GL_OUT_OF_MEMORY = GLenum::GL_OUT_OF_MEMORY;
GLBINDING_CONSTEXPR static const GLenum GL_INVALID_FRAMEBUFFER_OPERATION = GLenum::GL_INVALID_FRAMEBUFFER_OPERATION;
GLBINDING_CONSTEXPR static const GLenum GL_INVALID_FRAMEBUFFER_OPERATION_EXT = GLenum::GL_INVALID_FRAMEBUFFER_OPERATION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TABLE_TOO_LARGE_EXT = GLenum::GL_TABLE_TOO_LARGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TABLE_TOO_LARGE = GLenum::GL_TABLE_TOO_LARGE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_TOO_LARGE_EXT = GLenum::GL_TEXTURE_TOO_LARGE_EXT;

// EvalTargetNV

GLBINDING_CONSTEXPR static const GLenum GL_EVAL_2D_NV = GLenum::GL_EVAL_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_TRIANGULAR_2D_NV = GLenum::GL_EVAL_TRIANGULAR_2D_NV;

// ExternalHandleType

GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_OPAQUE_FD_EXT = GLenum::GL_HANDLE_TYPE_OPAQUE_FD_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_OPAQUE_WIN32_EXT = GLenum::GL_HANDLE_TYPE_OPAQUE_WIN32_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT = GLenum::GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT = GLenum::GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_D3D12_RESOURCE_EXT = GLenum::GL_HANDLE_TYPE_D3D12_RESOURCE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_D3D11_IMAGE_EXT = GLenum::GL_HANDLE_TYPE_D3D11_IMAGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT = GLenum::GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HANDLE_TYPE_D3D12_FENCE_EXT = GLenum::GL_HANDLE_TYPE_D3D12_FENCE_EXT;

// FeedBackToken

GLBINDING_CONSTEXPR static const GLenum GL_PASS_THROUGH_TOKEN = GLenum::GL_PASS_THROUGH_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_TOKEN = GLenum::GL_POINT_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_TOKEN = GLenum::GL_LINE_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_TOKEN = GLenum::GL_POLYGON_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_BITMAP_TOKEN = GLenum::GL_BITMAP_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_PIXEL_TOKEN = GLenum::GL_DRAW_PIXEL_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_COPY_PIXEL_TOKEN = GLenum::GL_COPY_PIXEL_TOKEN;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_RESET_TOKEN = GLenum::GL_LINE_RESET_TOKEN;

// FeedbackType

GLBINDING_CONSTEXPR static const GLenum GL_2D = GLenum::GL_2D;
GLBINDING_CONSTEXPR static const GLenum GL_3D = GLenum::GL_3D;
GLBINDING_CONSTEXPR static const GLenum GL_3D_COLOR = GLenum::GL_3D_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_3D_COLOR_TEXTURE = GLenum::GL_3D_COLOR_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_4D_COLOR_TEXTURE = GLenum::GL_4D_COLOR_TEXTURE;

// FenceConditionNV

GLBINDING_CONSTEXPR static const GLenum GL_ALL_COMPLETED_NV = GLenum::GL_ALL_COMPLETED_NV;

// FenceParameterNameNV

GLBINDING_CONSTEXPR static const GLenum GL_FENCE_STATUS_NV = GLenum::GL_FENCE_STATUS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FENCE_CONDITION_NV = GLenum::GL_FENCE_CONDITION_NV;

// FfdTargetSGIX

GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_DEFORMATION_SGIX = GLenum::GL_GEOMETRY_DEFORMATION_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEFORMATION_SGIX = GLenum::GL_TEXTURE_DEFORMATION_SGIX;

// FogCoordinatePointerType

// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// FogCoordSrc

GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE = GLenum::GL_FOG_COORDINATE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_EXT = GLenum::GL_FOG_COORDINATE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD = GLenum::GL_FOG_COORD;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_DEPTH = GLenum::GL_FRAGMENT_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_DEPTH_EXT = GLenum::GL_FRAGMENT_DEPTH_EXT;

// FogMode

GLBINDING_CONSTEXPR static const GLenum GL_EXP = GLenum::GL_EXP;
GLBINDING_CONSTEXPR static const GLenum GL_EXP2 = GLenum::GL_EXP2;
// GLBINDING_CONSTEXPR static const GLenum GL_LINEAR = GLenum::GL_LINEAR; // reuse BlitFramebufferFilter
GLBINDING_CONSTEXPR static const GLenum GL_FOG_FUNC_SGIS = GLenum::GL_FOG_FUNC_SGIS;

// FogParameter

GLBINDING_CONSTEXPR static const GLenum GL_FOG_INDEX = GLenum::GL_FOG_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_DENSITY = GLenum::GL_FOG_DENSITY;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_START = GLenum::GL_FOG_START;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_END = GLenum::GL_FOG_END;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_MODE = GLenum::GL_FOG_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COLOR = GLenum::GL_FOG_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_OFFSET_VALUE_SGIX = GLenum::GL_FOG_OFFSET_VALUE_SGIX;

// FogPName

// GLBINDING_CONSTEXPR static const GLenum GL_FOG_INDEX = GLenum::GL_FOG_INDEX; // reuse FogParameter
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_DENSITY = GLenum::GL_FOG_DENSITY; // reuse FogParameter
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_START = GLenum::GL_FOG_START; // reuse FogParameter
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_END = GLenum::GL_FOG_END; // reuse FogParameter
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_MODE = GLenum::GL_FOG_MODE; // reuse FogParameter
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_SRC = GLenum::GL_FOG_COORD_SRC;

// FogPointerTypeEXT

// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// FogPointerTypeIBM

// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// FragmentLightModelParameterSGIX

GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX;

// FragmentLightNameSGIX

// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT0_SGIX = GLenum::GL_FRAGMENT_LIGHT0_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT1_SGIX = GLenum::GL_FRAGMENT_LIGHT1_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT2_SGIX = GLenum::GL_FRAGMENT_LIGHT2_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT3_SGIX = GLenum::GL_FRAGMENT_LIGHT3_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT4_SGIX = GLenum::GL_FRAGMENT_LIGHT4_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT5_SGIX = GLenum::GL_FRAGMENT_LIGHT5_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT6_SGIX = GLenum::GL_FRAGMENT_LIGHT6_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT7_SGIX = GLenum::GL_FRAGMENT_LIGHT7_SGIX; // reuse EnableCap

// FragmentLightParameterSGIX

// GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT = GLenum::GL_AMBIENT; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DIFFUSE = GLenum::GL_DIFFUSE; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_SPECULAR = GLenum::GL_SPECULAR; // reuse ColorMaterialParameter
GLBINDING_CONSTEXPR static const GLenum GL_POSITION = GLenum::GL_POSITION;
GLBINDING_CONSTEXPR static const GLenum GL_SPOT_DIRECTION = GLenum::GL_SPOT_DIRECTION;
GLBINDING_CONSTEXPR static const GLenum GL_SPOT_EXPONENT = GLenum::GL_SPOT_EXPONENT;
GLBINDING_CONSTEXPR static const GLenum GL_SPOT_CUTOFF = GLenum::GL_SPOT_CUTOFF;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_ATTENUATION = GLenum::GL_CONSTANT_ATTENUATION;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_ATTENUATION = GLenum::GL_LINEAR_ATTENUATION;
GLBINDING_CONSTEXPR static const GLenum GL_QUADRATIC_ATTENUATION = GLenum::GL_QUADRATIC_ATTENUATION;

// FragmentOp1ATI

GLBINDING_CONSTEXPR static const GLenum GL_MOV_ATI = GLenum::GL_MOV_ATI;

// FragmentOp2ATI

GLBINDING_CONSTEXPR static const GLenum GL_ADD_ATI = GLenum::GL_ADD_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MUL_ATI = GLenum::GL_MUL_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SUB_ATI = GLenum::GL_SUB_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_ATI = GLenum::GL_DOT3_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DOT4_ATI = GLenum::GL_DOT4_ATI;

// FragmentOp3ATI

GLBINDING_CONSTEXPR static const GLenum GL_MAD_ATI = GLenum::GL_MAD_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_LERP_ATI = GLenum::GL_LERP_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CND_ATI = GLenum::GL_CND_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CND0_ATI = GLenum::GL_CND0_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DOT2_ADD_ATI = GLenum::GL_DOT2_ADD_ATI;

// FragmentShaderConATI

GLBINDING_CONSTEXPR static const GLenum GL_CON_0_ATI = GLenum::GL_CON_0_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_1_ATI = GLenum::GL_CON_1_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_2_ATI = GLenum::GL_CON_2_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_3_ATI = GLenum::GL_CON_3_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_4_ATI = GLenum::GL_CON_4_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_5_ATI = GLenum::GL_CON_5_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_6_ATI = GLenum::GL_CON_6_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_7_ATI = GLenum::GL_CON_7_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_8_ATI = GLenum::GL_CON_8_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_9_ATI = GLenum::GL_CON_9_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_10_ATI = GLenum::GL_CON_10_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_11_ATI = GLenum::GL_CON_11_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_12_ATI = GLenum::GL_CON_12_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_13_ATI = GLenum::GL_CON_13_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_14_ATI = GLenum::GL_CON_14_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_15_ATI = GLenum::GL_CON_15_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_16_ATI = GLenum::GL_CON_16_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_17_ATI = GLenum::GL_CON_17_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_18_ATI = GLenum::GL_CON_18_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_19_ATI = GLenum::GL_CON_19_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_20_ATI = GLenum::GL_CON_20_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_21_ATI = GLenum::GL_CON_21_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_22_ATI = GLenum::GL_CON_22_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_23_ATI = GLenum::GL_CON_23_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_24_ATI = GLenum::GL_CON_24_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_25_ATI = GLenum::GL_CON_25_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_26_ATI = GLenum::GL_CON_26_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_27_ATI = GLenum::GL_CON_27_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_28_ATI = GLenum::GL_CON_28_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_29_ATI = GLenum::GL_CON_29_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_30_ATI = GLenum::GL_CON_30_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_CON_31_ATI = GLenum::GL_CON_31_ATI;

// FragmentShaderGenericSourceATI

// GLBINDING_CONSTEXPR static const GLenum GL_ZERO = GLenum::GL_ZERO; // reuse BlendingFactor
GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR = GLenum::GL_PRIMARY_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR_ARB = GLenum::GL_PRIMARY_COLOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR_EXT = GLenum::GL_PRIMARY_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_REG_0_ATI = GLenum::GL_REG_0_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_1_ATI = GLenum::GL_REG_1_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_2_ATI = GLenum::GL_REG_2_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_3_ATI = GLenum::GL_REG_3_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_4_ATI = GLenum::GL_REG_4_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_5_ATI = GLenum::GL_REG_5_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_6_ATI = GLenum::GL_REG_6_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_7_ATI = GLenum::GL_REG_7_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_8_ATI = GLenum::GL_REG_8_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_9_ATI = GLenum::GL_REG_9_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_10_ATI = GLenum::GL_REG_10_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_11_ATI = GLenum::GL_REG_11_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_12_ATI = GLenum::GL_REG_12_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_13_ATI = GLenum::GL_REG_13_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_14_ATI = GLenum::GL_REG_14_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_15_ATI = GLenum::GL_REG_15_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_16_ATI = GLenum::GL_REG_16_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_17_ATI = GLenum::GL_REG_17_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_18_ATI = GLenum::GL_REG_18_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_19_ATI = GLenum::GL_REG_19_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_20_ATI = GLenum::GL_REG_20_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_21_ATI = GLenum::GL_REG_21_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_22_ATI = GLenum::GL_REG_22_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_23_ATI = GLenum::GL_REG_23_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_24_ATI = GLenum::GL_REG_24_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_25_ATI = GLenum::GL_REG_25_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_26_ATI = GLenum::GL_REG_26_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_27_ATI = GLenum::GL_REG_27_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_28_ATI = GLenum::GL_REG_28_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_29_ATI = GLenum::GL_REG_29_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_30_ATI = GLenum::GL_REG_30_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_REG_31_ATI = GLenum::GL_REG_31_ATI;
// GLBINDING_CONSTEXPR static const GLenum GL_CON_0_ATI = GLenum::GL_CON_0_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_1_ATI = GLenum::GL_CON_1_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_2_ATI = GLenum::GL_CON_2_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_3_ATI = GLenum::GL_CON_3_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_4_ATI = GLenum::GL_CON_4_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_5_ATI = GLenum::GL_CON_5_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_6_ATI = GLenum::GL_CON_6_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_7_ATI = GLenum::GL_CON_7_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_8_ATI = GLenum::GL_CON_8_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_9_ATI = GLenum::GL_CON_9_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_10_ATI = GLenum::GL_CON_10_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_11_ATI = GLenum::GL_CON_11_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_12_ATI = GLenum::GL_CON_12_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_13_ATI = GLenum::GL_CON_13_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_14_ATI = GLenum::GL_CON_14_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_15_ATI = GLenum::GL_CON_15_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_16_ATI = GLenum::GL_CON_16_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_17_ATI = GLenum::GL_CON_17_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_18_ATI = GLenum::GL_CON_18_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_19_ATI = GLenum::GL_CON_19_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_20_ATI = GLenum::GL_CON_20_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_21_ATI = GLenum::GL_CON_21_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_22_ATI = GLenum::GL_CON_22_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_23_ATI = GLenum::GL_CON_23_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_24_ATI = GLenum::GL_CON_24_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_25_ATI = GLenum::GL_CON_25_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_26_ATI = GLenum::GL_CON_26_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_27_ATI = GLenum::GL_CON_27_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_28_ATI = GLenum::GL_CON_28_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_29_ATI = GLenum::GL_CON_29_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_30_ATI = GLenum::GL_CON_30_ATI; // reuse FragmentShaderConATI
// GLBINDING_CONSTEXPR static const GLenum GL_CON_31_ATI = GLenum::GL_CON_31_ATI; // reuse FragmentShaderConATI
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_INTERPOLATOR_ATI = GLenum::GL_SECONDARY_INTERPOLATOR_ATI;
// GLBINDING_CONSTEXPR static const GLenum GL_ONE = GLenum::GL_ONE; // reuse BlendingFactor

// FragmentShaderRegATI

// GLBINDING_CONSTEXPR static const GLenum GL_REG_0_ATI = GLenum::GL_REG_0_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_1_ATI = GLenum::GL_REG_1_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_2_ATI = GLenum::GL_REG_2_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_3_ATI = GLenum::GL_REG_3_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_4_ATI = GLenum::GL_REG_4_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_5_ATI = GLenum::GL_REG_5_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_6_ATI = GLenum::GL_REG_6_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_7_ATI = GLenum::GL_REG_7_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_8_ATI = GLenum::GL_REG_8_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_9_ATI = GLenum::GL_REG_9_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_10_ATI = GLenum::GL_REG_10_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_11_ATI = GLenum::GL_REG_11_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_12_ATI = GLenum::GL_REG_12_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_13_ATI = GLenum::GL_REG_13_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_14_ATI = GLenum::GL_REG_14_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_15_ATI = GLenum::GL_REG_15_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_16_ATI = GLenum::GL_REG_16_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_17_ATI = GLenum::GL_REG_17_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_18_ATI = GLenum::GL_REG_18_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_19_ATI = GLenum::GL_REG_19_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_20_ATI = GLenum::GL_REG_20_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_21_ATI = GLenum::GL_REG_21_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_22_ATI = GLenum::GL_REG_22_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_23_ATI = GLenum::GL_REG_23_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_24_ATI = GLenum::GL_REG_24_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_25_ATI = GLenum::GL_REG_25_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_26_ATI = GLenum::GL_REG_26_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_27_ATI = GLenum::GL_REG_27_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_28_ATI = GLenum::GL_REG_28_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_29_ATI = GLenum::GL_REG_29_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_30_ATI = GLenum::GL_REG_30_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_31_ATI = GLenum::GL_REG_31_ATI; // reuse FragmentShaderGenericSourceATI

// FragmentShaderTextureSourceATI

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE0 = GLenum::GL_TEXTURE0;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE1 = GLenum::GL_TEXTURE1;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE2 = GLenum::GL_TEXTURE2;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE3 = GLenum::GL_TEXTURE3;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE4 = GLenum::GL_TEXTURE4;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE5 = GLenum::GL_TEXTURE5;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE6 = GLenum::GL_TEXTURE6;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE7 = GLenum::GL_TEXTURE7;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE8 = GLenum::GL_TEXTURE8;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE9 = GLenum::GL_TEXTURE9;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE10 = GLenum::GL_TEXTURE10;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE11 = GLenum::GL_TEXTURE11;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE12 = GLenum::GL_TEXTURE12;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE13 = GLenum::GL_TEXTURE13;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE14 = GLenum::GL_TEXTURE14;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE15 = GLenum::GL_TEXTURE15;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE16 = GLenum::GL_TEXTURE16;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE17 = GLenum::GL_TEXTURE17;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE18 = GLenum::GL_TEXTURE18;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE19 = GLenum::GL_TEXTURE19;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE20 = GLenum::GL_TEXTURE20;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE21 = GLenum::GL_TEXTURE21;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE22 = GLenum::GL_TEXTURE22;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE23 = GLenum::GL_TEXTURE23;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE24 = GLenum::GL_TEXTURE24;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE25 = GLenum::GL_TEXTURE25;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE26 = GLenum::GL_TEXTURE26;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE27 = GLenum::GL_TEXTURE27;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE28 = GLenum::GL_TEXTURE28;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE29 = GLenum::GL_TEXTURE29;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE30 = GLenum::GL_TEXTURE30;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE31 = GLenum::GL_TEXTURE31;
// GLBINDING_CONSTEXPR static const GLenum GL_REG_0_ATI = GLenum::GL_REG_0_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_1_ATI = GLenum::GL_REG_1_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_2_ATI = GLenum::GL_REG_2_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_3_ATI = GLenum::GL_REG_3_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_4_ATI = GLenum::GL_REG_4_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_5_ATI = GLenum::GL_REG_5_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_6_ATI = GLenum::GL_REG_6_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_7_ATI = GLenum::GL_REG_7_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_8_ATI = GLenum::GL_REG_8_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_9_ATI = GLenum::GL_REG_9_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_10_ATI = GLenum::GL_REG_10_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_11_ATI = GLenum::GL_REG_11_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_12_ATI = GLenum::GL_REG_12_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_13_ATI = GLenum::GL_REG_13_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_14_ATI = GLenum::GL_REG_14_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_15_ATI = GLenum::GL_REG_15_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_16_ATI = GLenum::GL_REG_16_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_17_ATI = GLenum::GL_REG_17_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_18_ATI = GLenum::GL_REG_18_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_19_ATI = GLenum::GL_REG_19_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_20_ATI = GLenum::GL_REG_20_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_21_ATI = GLenum::GL_REG_21_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_22_ATI = GLenum::GL_REG_22_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_23_ATI = GLenum::GL_REG_23_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_24_ATI = GLenum::GL_REG_24_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_25_ATI = GLenum::GL_REG_25_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_26_ATI = GLenum::GL_REG_26_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_27_ATI = GLenum::GL_REG_27_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_28_ATI = GLenum::GL_REG_28_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_29_ATI = GLenum::GL_REG_29_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_30_ATI = GLenum::GL_REG_30_ATI; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_REG_31_ATI = GLenum::GL_REG_31_ATI; // reuse FragmentShaderGenericSourceATI

// FragmentShaderValueRepATI

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_RED = GLenum::GL_RED;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN = GLenum::GL_GREEN;
// GLBINDING_CONSTEXPR static const GLenum GL_BLUE = GLenum::GL_BLUE; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA = GLenum::GL_ALPHA; // reuse CombinerComponentUsageNV

// FramebufferAttachment

GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_ATTACHMENT = GLenum::GL_DEPTH_STENCIL_ATTACHMENT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT0 = GLenum::GL_COLOR_ATTACHMENT0; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT1 = GLenum::GL_COLOR_ATTACHMENT1; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT2 = GLenum::GL_COLOR_ATTACHMENT2; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT3 = GLenum::GL_COLOR_ATTACHMENT3; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT4 = GLenum::GL_COLOR_ATTACHMENT4; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT5 = GLenum::GL_COLOR_ATTACHMENT5; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT6 = GLenum::GL_COLOR_ATTACHMENT6; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT7 = GLenum::GL_COLOR_ATTACHMENT7; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT8 = GLenum::GL_COLOR_ATTACHMENT8; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT9 = GLenum::GL_COLOR_ATTACHMENT9; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT10 = GLenum::GL_COLOR_ATTACHMENT10; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT11 = GLenum::GL_COLOR_ATTACHMENT11; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT12 = GLenum::GL_COLOR_ATTACHMENT12; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT13 = GLenum::GL_COLOR_ATTACHMENT13; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT14 = GLenum::GL_COLOR_ATTACHMENT14; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT15 = GLenum::GL_COLOR_ATTACHMENT15; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT16 = GLenum::GL_COLOR_ATTACHMENT16; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT17 = GLenum::GL_COLOR_ATTACHMENT17; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT18 = GLenum::GL_COLOR_ATTACHMENT18; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT19 = GLenum::GL_COLOR_ATTACHMENT19; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT20 = GLenum::GL_COLOR_ATTACHMENT20; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT21 = GLenum::GL_COLOR_ATTACHMENT21; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT22 = GLenum::GL_COLOR_ATTACHMENT22; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT23 = GLenum::GL_COLOR_ATTACHMENT23; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT24 = GLenum::GL_COLOR_ATTACHMENT24; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT25 = GLenum::GL_COLOR_ATTACHMENT25; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT26 = GLenum::GL_COLOR_ATTACHMENT26; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT27 = GLenum::GL_COLOR_ATTACHMENT27; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT28 = GLenum::GL_COLOR_ATTACHMENT28; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT29 = GLenum::GL_COLOR_ATTACHMENT29; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT30 = GLenum::GL_COLOR_ATTACHMENT30; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT31 = GLenum::GL_COLOR_ATTACHMENT31; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_ATTACHMENT = GLenum::GL_DEPTH_ATTACHMENT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_ATTACHMENT = GLenum::GL_STENCIL_ATTACHMENT;

// FramebufferAttachmentParameterName

GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = GLenum::GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = GLenum::GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_LAYERED = GLenum::GL_FRAMEBUFFER_ATTACHMENT_LAYERED;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB = GLenum::GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT = GLenum::GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR = GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR;

// FramebufferParameterName

GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_WIDTH = GLenum::GL_FRAMEBUFFER_DEFAULT_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_HEIGHT = GLenum::GL_FRAMEBUFFER_DEFAULT_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_LAYERS = GLenum::GL_FRAMEBUFFER_DEFAULT_LAYERS;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_SAMPLES = GLenum::GL_FRAMEBUFFER_DEFAULT_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = GLenum::GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS;

// FramebufferStatus

GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_UNDEFINED = GLenum::GL_FRAMEBUFFER_UNDEFINED;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_COMPLETE = GLenum::GL_FRAMEBUFFER_COMPLETE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = GLenum::GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = GLenum::GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = GLenum::GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_UNSUPPORTED = GLenum::GL_FRAMEBUFFER_UNSUPPORTED;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = GLenum::GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = GLenum::GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS;

// FramebufferTarget

GLBINDING_CONSTEXPR static const GLenum GL_READ_FRAMEBUFFER = GLenum::GL_READ_FRAMEBUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_FRAMEBUFFER = GLenum::GL_DRAW_FRAMEBUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER = GLenum::GL_FRAMEBUFFER;

// FrontFaceDirection

GLBINDING_CONSTEXPR static const GLenum GL_CW = GLenum::GL_CW;
GLBINDING_CONSTEXPR static const GLenum GL_CCW = GLenum::GL_CCW;

// GetFramebufferParameter

GLBINDING_CONSTEXPR static const GLenum GL_DOUBLEBUFFER = GLenum::GL_DOUBLEBUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_STEREO = GLenum::GL_STEREO;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS = GLenum::GL_SAMPLE_BUFFERS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES = GLenum::GL_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_IMPLEMENTATION_COLOR_READ_TYPE = GLenum::GL_IMPLEMENTATION_COLOR_READ_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_IMPLEMENTATION_COLOR_READ_FORMAT = GLenum::GL_IMPLEMENTATION_COLOR_READ_FORMAT;
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_WIDTH = GLenum::GL_FRAMEBUFFER_DEFAULT_WIDTH; // reuse FramebufferParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_HEIGHT = GLenum::GL_FRAMEBUFFER_DEFAULT_HEIGHT; // reuse FramebufferParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_LAYERS = GLenum::GL_FRAMEBUFFER_DEFAULT_LAYERS; // reuse FramebufferParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_SAMPLES = GLenum::GL_FRAMEBUFFER_DEFAULT_SAMPLES; // reuse FramebufferParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = GLenum::GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS; // reuse FramebufferParameterName

// GetHistogramParameterPNameEXT

GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_WIDTH = GLenum::GL_HISTOGRAM_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_WIDTH_EXT = GLenum::GL_HISTOGRAM_WIDTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_FORMAT = GLenum::GL_HISTOGRAM_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_FORMAT_EXT = GLenum::GL_HISTOGRAM_FORMAT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_RED_SIZE = GLenum::GL_HISTOGRAM_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_RED_SIZE_EXT = GLenum::GL_HISTOGRAM_RED_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_GREEN_SIZE = GLenum::GL_HISTOGRAM_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_GREEN_SIZE_EXT = GLenum::GL_HISTOGRAM_GREEN_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_BLUE_SIZE = GLenum::GL_HISTOGRAM_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_BLUE_SIZE_EXT = GLenum::GL_HISTOGRAM_BLUE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_ALPHA_SIZE = GLenum::GL_HISTOGRAM_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_ALPHA_SIZE_EXT = GLenum::GL_HISTOGRAM_ALPHA_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_LUMINANCE_SIZE = GLenum::GL_HISTOGRAM_LUMINANCE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_LUMINANCE_SIZE_EXT = GLenum::GL_HISTOGRAM_LUMINANCE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_SINK = GLenum::GL_HISTOGRAM_SINK;
GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_SINK_EXT = GLenum::GL_HISTOGRAM_SINK_EXT;

// GetMapQuery

GLBINDING_CONSTEXPR static const GLenum GL_COEFF = GLenum::GL_COEFF;
GLBINDING_CONSTEXPR static const GLenum GL_ORDER = GLenum::GL_ORDER;
GLBINDING_CONSTEXPR static const GLenum GL_DOMAIN = GLenum::GL_DOMAIN;

// GetMinmaxParameterPNameEXT

GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_FORMAT = GLenum::GL_MINMAX_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_FORMAT_EXT = GLenum::GL_MINMAX_FORMAT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_SINK = GLenum::GL_MINMAX_SINK;
GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_SINK_EXT = GLenum::GL_MINMAX_SINK_EXT;

// GetMultisamplePNameNV

GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_POSITION = GLenum::GL_SAMPLE_POSITION;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_LOCATION_ARB = GLenum::GL_SAMPLE_LOCATION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB = GLenum::GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB;

// GetPName

GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_COLOR = GLenum::GL_CURRENT_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_INDEX = GLenum::GL_CURRENT_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_NORMAL = GLenum::GL_CURRENT_NORMAL;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_TEXTURE_COORDS = GLenum::GL_CURRENT_TEXTURE_COORDS;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_COLOR = GLenum::GL_CURRENT_RASTER_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_INDEX = GLenum::GL_CURRENT_RASTER_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_TEXTURE_COORDS = GLenum::GL_CURRENT_RASTER_TEXTURE_COORDS;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_POSITION = GLenum::GL_CURRENT_RASTER_POSITION;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_POSITION_VALID = GLenum::GL_CURRENT_RASTER_POSITION_VALID;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_DISTANCE = GLenum::GL_CURRENT_RASTER_DISTANCE;
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SMOOTH = GLenum::GL_POINT_SMOOTH; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE = GLenum::GL_POINT_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_RANGE = GLenum::GL_POINT_SIZE_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_POINT_SIZE_RANGE = GLenum::GL_SMOOTH_POINT_SIZE_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_GRANULARITY = GLenum::GL_POINT_SIZE_GRANULARITY;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_POINT_SIZE_GRANULARITY = GLenum::GL_SMOOTH_POINT_SIZE_GRANULARITY;
// GLBINDING_CONSTEXPR static const GLenum GL_LINE_SMOOTH = GLenum::GL_LINE_SMOOTH; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_LINE_WIDTH = GLenum::GL_LINE_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_WIDTH_RANGE = GLenum::GL_LINE_WIDTH_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_LINE_WIDTH_RANGE = GLenum::GL_SMOOTH_LINE_WIDTH_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_WIDTH_GRANULARITY = GLenum::GL_LINE_WIDTH_GRANULARITY;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_LINE_WIDTH_GRANULARITY = GLenum::GL_SMOOTH_LINE_WIDTH_GRANULARITY;
// GLBINDING_CONSTEXPR static const GLenum GL_LINE_STIPPLE = GLenum::GL_LINE_STIPPLE; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STIPPLE_PATTERN = GLenum::GL_LINE_STIPPLE_PATTERN;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STIPPLE_REPEAT = GLenum::GL_LINE_STIPPLE_REPEAT;
GLBINDING_CONSTEXPR static const GLenum GL_LIST_MODE = GLenum::GL_LIST_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_LIST_NESTING = GLenum::GL_MAX_LIST_NESTING;
GLBINDING_CONSTEXPR static const GLenum GL_LIST_BASE = GLenum::GL_LIST_BASE;
GLBINDING_CONSTEXPR static const GLenum GL_LIST_INDEX = GLenum::GL_LIST_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_MODE = GLenum::GL_POLYGON_MODE;
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_SMOOTH = GLenum::GL_POLYGON_SMOOTH; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_STIPPLE = GLenum::GL_POLYGON_STIPPLE; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG = GLenum::GL_EDGE_FLAG;
// GLBINDING_CONSTEXPR static const GLenum GL_CULL_FACE = GLenum::GL_CULL_FACE; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_CULL_FACE_MODE = GLenum::GL_CULL_FACE_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_FRONT_FACE = GLenum::GL_FRONT_FACE;
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHTING = GLenum::GL_LIGHTING; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_LOCAL_VIEWER = GLenum::GL_LIGHT_MODEL_LOCAL_VIEWER;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_TWO_SIDE = GLenum::GL_LIGHT_MODEL_TWO_SIDE;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_AMBIENT = GLenum::GL_LIGHT_MODEL_AMBIENT;
GLBINDING_CONSTEXPR static const GLenum GL_SHADE_MODEL = GLenum::GL_SHADE_MODEL;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATERIAL_FACE = GLenum::GL_COLOR_MATERIAL_FACE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATERIAL_PARAMETER = GLenum::GL_COLOR_MATERIAL_PARAMETER;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATERIAL = GLenum::GL_COLOR_MATERIAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FOG = GLenum::GL_FOG; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_INDEX = GLenum::GL_FOG_INDEX; // reuse FogParameter
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_DENSITY = GLenum::GL_FOG_DENSITY; // reuse FogParameter
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_START = GLenum::GL_FOG_START; // reuse FogParameter
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_END = GLenum::GL_FOG_END; // reuse FogParameter
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_MODE = GLenum::GL_FOG_MODE; // reuse FogParameter
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_COLOR = GLenum::GL_FOG_COLOR; // reuse FogParameter
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_RANGE = GLenum::GL_DEPTH_RANGE;
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_TEST = GLenum::GL_DEPTH_TEST; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_WRITEMASK = GLenum::GL_DEPTH_WRITEMASK;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_CLEAR_VALUE = GLenum::GL_DEPTH_CLEAR_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_FUNC = GLenum::GL_DEPTH_FUNC;
GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_CLEAR_VALUE = GLenum::GL_ACCUM_CLEAR_VALUE;
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_TEST = GLenum::GL_STENCIL_TEST; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_CLEAR_VALUE = GLenum::GL_STENCIL_CLEAR_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_FUNC = GLenum::GL_STENCIL_FUNC;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_VALUE_MASK = GLenum::GL_STENCIL_VALUE_MASK;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_FAIL = GLenum::GL_STENCIL_FAIL;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_PASS_DEPTH_FAIL = GLenum::GL_STENCIL_PASS_DEPTH_FAIL;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_PASS_DEPTH_PASS = GLenum::GL_STENCIL_PASS_DEPTH_PASS;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_REF = GLenum::GL_STENCIL_REF;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_WRITEMASK = GLenum::GL_STENCIL_WRITEMASK;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_MODE = GLenum::GL_MATRIX_MODE;
// GLBINDING_CONSTEXPR static const GLenum GL_NORMALIZE = GLenum::GL_NORMALIZE; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_VIEWPORT = GLenum::GL_VIEWPORT;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW_STACK_DEPTH = GLenum::GL_MODELVIEW_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW0_STACK_DEPTH_EXT = GLenum::GL_MODELVIEW0_STACK_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROJECTION_STACK_DEPTH = GLenum::GL_PROJECTION_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_STACK_DEPTH = GLenum::GL_TEXTURE_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW_MATRIX = GLenum::GL_MODELVIEW_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW0_MATRIX_EXT = GLenum::GL_MODELVIEW0_MATRIX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROJECTION_MATRIX = GLenum::GL_PROJECTION_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MATRIX = GLenum::GL_TEXTURE_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIB_STACK_DEPTH = GLenum::GL_ATTRIB_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_CLIENT_ATTRIB_STACK_DEPTH = GLenum::GL_CLIENT_ATTRIB_STACK_DEPTH;
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_TEST = GLenum::GL_ALPHA_TEST; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_TEST_FUNC = GLenum::GL_ALPHA_TEST_FUNC;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_TEST_REF = GLenum::GL_ALPHA_TEST_REF;
// GLBINDING_CONSTEXPR static const GLenum GL_DITHER = GLenum::GL_DITHER; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_DST = GLenum::GL_BLEND_DST;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_SRC = GLenum::GL_BLEND_SRC;
// GLBINDING_CONSTEXPR static const GLenum GL_BLEND = GLenum::GL_BLEND; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_LOGIC_OP_MODE = GLenum::GL_LOGIC_OP_MODE;
// GLBINDING_CONSTEXPR static const GLenum GL_INDEX_LOGIC_OP = GLenum::GL_INDEX_LOGIC_OP; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_LOGIC_OP = GLenum::GL_LOGIC_OP;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_LOGIC_OP = GLenum::GL_COLOR_LOGIC_OP; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_AUX_BUFFERS = GLenum::GL_AUX_BUFFERS;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_BUFFER = GLenum::GL_DRAW_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_READ_BUFFER = GLenum::GL_READ_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_SCISSOR_BOX = GLenum::GL_SCISSOR_BOX;
// GLBINDING_CONSTEXPR static const GLenum GL_SCISSOR_TEST = GLenum::GL_SCISSOR_TEST; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_CLEAR_VALUE = GLenum::GL_INDEX_CLEAR_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_WRITEMASK = GLenum::GL_INDEX_WRITEMASK;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_CLEAR_VALUE = GLenum::GL_COLOR_CLEAR_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_WRITEMASK = GLenum::GL_COLOR_WRITEMASK;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_MODE = GLenum::GL_INDEX_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_MODE = GLenum::GL_RGBA_MODE;
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLEBUFFER = GLenum::GL_DOUBLEBUFFER; // reuse GetFramebufferParameter
// GLBINDING_CONSTEXPR static const GLenum GL_STEREO = GLenum::GL_STEREO; // reuse GetFramebufferParameter
GLBINDING_CONSTEXPR static const GLenum GL_RENDER_MODE = GLenum::GL_RENDER_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_PERSPECTIVE_CORRECTION_HINT = GLenum::GL_PERSPECTIVE_CORRECTION_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SMOOTH_HINT = GLenum::GL_POINT_SMOOTH_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_SMOOTH_HINT = GLenum::GL_LINE_SMOOTH_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_SMOOTH_HINT = GLenum::GL_POLYGON_SMOOTH_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_HINT = GLenum::GL_FOG_HINT;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_S = GLenum::GL_TEXTURE_GEN_S; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_T = GLenum::GL_TEXTURE_GEN_T; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_R = GLenum::GL_TEXTURE_GEN_R; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_Q = GLenum::GL_TEXTURE_GEN_Q; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_I_SIZE = GLenum::GL_PIXEL_MAP_I_TO_I_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_S_TO_S_SIZE = GLenum::GL_PIXEL_MAP_S_TO_S_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_R_SIZE = GLenum::GL_PIXEL_MAP_I_TO_R_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_G_SIZE = GLenum::GL_PIXEL_MAP_I_TO_G_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_B_SIZE = GLenum::GL_PIXEL_MAP_I_TO_B_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_A_SIZE = GLenum::GL_PIXEL_MAP_I_TO_A_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_R_TO_R_SIZE = GLenum::GL_PIXEL_MAP_R_TO_R_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_G_TO_G_SIZE = GLenum::GL_PIXEL_MAP_G_TO_G_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_B_TO_B_SIZE = GLenum::GL_PIXEL_MAP_B_TO_B_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_A_TO_A_SIZE = GLenum::GL_PIXEL_MAP_A_TO_A_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SWAP_BYTES = GLenum::GL_UNPACK_SWAP_BYTES;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_LSB_FIRST = GLenum::GL_UNPACK_LSB_FIRST;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_ROW_LENGTH = GLenum::GL_UNPACK_ROW_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_ROWS = GLenum::GL_UNPACK_SKIP_ROWS;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_PIXELS = GLenum::GL_UNPACK_SKIP_PIXELS;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_ALIGNMENT = GLenum::GL_UNPACK_ALIGNMENT;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SWAP_BYTES = GLenum::GL_PACK_SWAP_BYTES;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_LSB_FIRST = GLenum::GL_PACK_LSB_FIRST;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_ROW_LENGTH = GLenum::GL_PACK_ROW_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_ROWS = GLenum::GL_PACK_SKIP_ROWS;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_PIXELS = GLenum::GL_PACK_SKIP_PIXELS;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_ALIGNMENT = GLenum::GL_PACK_ALIGNMENT;
GLBINDING_CONSTEXPR static const GLenum GL_MAP_COLOR = GLenum::GL_MAP_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_MAP_STENCIL = GLenum::GL_MAP_STENCIL;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_SHIFT = GLenum::GL_INDEX_SHIFT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_OFFSET = GLenum::GL_INDEX_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_RED_SCALE = GLenum::GL_RED_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_RED_BIAS = GLenum::GL_RED_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_ZOOM_X = GLenum::GL_ZOOM_X;
GLBINDING_CONSTEXPR static const GLenum GL_ZOOM_Y = GLenum::GL_ZOOM_Y;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_SCALE = GLenum::GL_GREEN_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_BIAS = GLenum::GL_GREEN_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_SCALE = GLenum::GL_BLUE_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_BIAS = GLenum::GL_BLUE_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_SCALE = GLenum::GL_ALPHA_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_BIAS = GLenum::GL_ALPHA_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_SCALE = GLenum::GL_DEPTH_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_BIAS = GLenum::GL_DEPTH_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_EVAL_ORDER = GLenum::GL_MAX_EVAL_ORDER;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_LIGHTS = GLenum::GL_MAX_LIGHTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CLIP_PLANES = GLenum::GL_MAX_CLIP_PLANES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CLIP_DISTANCES = GLenum::GL_MAX_CLIP_DISTANCES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_SIZE = GLenum::GL_MAX_TEXTURE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PIXEL_MAP_TABLE = GLenum::GL_MAX_PIXEL_MAP_TABLE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ATTRIB_STACK_DEPTH = GLenum::GL_MAX_ATTRIB_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_MODELVIEW_STACK_DEPTH = GLenum::GL_MAX_MODELVIEW_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_NAME_STACK_DEPTH = GLenum::GL_MAX_NAME_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROJECTION_STACK_DEPTH = GLenum::GL_MAX_PROJECTION_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_STACK_DEPTH = GLenum::GL_MAX_TEXTURE_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VIEWPORT_DIMS = GLenum::GL_MAX_VIEWPORT_DIMS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = GLenum::GL_MAX_CLIENT_ATTRIB_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_SUBPIXEL_BITS = GLenum::GL_SUBPIXEL_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_BITS = GLenum::GL_INDEX_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_RED_BITS = GLenum::GL_RED_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_BITS = GLenum::GL_GREEN_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_BITS = GLenum::GL_BLUE_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_BITS = GLenum::GL_ALPHA_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_BITS = GLenum::GL_DEPTH_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BITS = GLenum::GL_STENCIL_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_RED_BITS = GLenum::GL_ACCUM_RED_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_GREEN_BITS = GLenum::GL_ACCUM_GREEN_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_BLUE_BITS = GLenum::GL_ACCUM_BLUE_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_ALPHA_BITS = GLenum::GL_ACCUM_ALPHA_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_NAME_STACK_DEPTH = GLenum::GL_NAME_STACK_DEPTH;
// GLBINDING_CONSTEXPR static const GLenum GL_AUTO_NORMAL = GLenum::GL_AUTO_NORMAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_COLOR_4 = GLenum::GL_MAP1_COLOR_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_INDEX = GLenum::GL_MAP1_INDEX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_NORMAL = GLenum::GL_MAP1_NORMAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_1 = GLenum::GL_MAP1_TEXTURE_COORD_1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_2 = GLenum::GL_MAP1_TEXTURE_COORD_2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_3 = GLenum::GL_MAP1_TEXTURE_COORD_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_4 = GLenum::GL_MAP1_TEXTURE_COORD_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_3 = GLenum::GL_MAP1_VERTEX_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_4 = GLenum::GL_MAP1_VERTEX_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_COLOR_4 = GLenum::GL_MAP2_COLOR_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_INDEX = GLenum::GL_MAP2_INDEX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_NORMAL = GLenum::GL_MAP2_NORMAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_1 = GLenum::GL_MAP2_TEXTURE_COORD_1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_2 = GLenum::GL_MAP2_TEXTURE_COORD_2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_3 = GLenum::GL_MAP2_TEXTURE_COORD_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_4 = GLenum::GL_MAP2_TEXTURE_COORD_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_3 = GLenum::GL_MAP2_VERTEX_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_4 = GLenum::GL_MAP2_VERTEX_4; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_GRID_DOMAIN = GLenum::GL_MAP1_GRID_DOMAIN;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_GRID_SEGMENTS = GLenum::GL_MAP1_GRID_SEGMENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_GRID_DOMAIN = GLenum::GL_MAP2_GRID_DOMAIN;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_GRID_SEGMENTS = GLenum::GL_MAP2_GRID_SEGMENTS;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D = GLenum::GL_TEXTURE_1D; // reuse CopyImageSubDataTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D = GLenum::GL_TEXTURE_2D; // reuse CopyImageSubDataTarget
GLBINDING_CONSTEXPR static const GLenum GL_FEEDBACK_BUFFER_SIZE = GLenum::GL_FEEDBACK_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_FEEDBACK_BUFFER_TYPE = GLenum::GL_FEEDBACK_BUFFER_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_SELECTION_BUFFER_SIZE = GLenum::GL_SELECTION_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_UNITS = GLenum::GL_POLYGON_OFFSET_UNITS;
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_POINT = GLenum::GL_POLYGON_OFFSET_POINT; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_LINE = GLenum::GL_POLYGON_OFFSET_LINE; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE0 = GLenum::GL_CLIP_PLANE0; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE1 = GLenum::GL_CLIP_PLANE1; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE2 = GLenum::GL_CLIP_PLANE2; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE3 = GLenum::GL_CLIP_PLANE3; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE4 = GLenum::GL_CLIP_PLANE4; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_CLIP_PLANE5 = GLenum::GL_CLIP_PLANE5; // reuse ClipPlaneName
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT0 = GLenum::GL_LIGHT0; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT1 = GLenum::GL_LIGHT1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT2 = GLenum::GL_LIGHT2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT3 = GLenum::GL_LIGHT3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT4 = GLenum::GL_LIGHT4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT5 = GLenum::GL_LIGHT5; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT6 = GLenum::GL_LIGHT6; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT7 = GLenum::GL_LIGHT7; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_COLOR = GLenum::GL_BLEND_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_COLOR_EXT = GLenum::GL_BLEND_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION = GLenum::GL_BLEND_EQUATION;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION_EXT = GLenum::GL_BLEND_EQUATION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION_RGB = GLenum::GL_BLEND_EQUATION_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_CMYK_HINT_EXT = GLenum::GL_PACK_CMYK_HINT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_CMYK_HINT_EXT = GLenum::GL_UNPACK_CMYK_HINT_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_1D_EXT = GLenum::GL_CONVOLUTION_1D_EXT; // reuse ConvolutionTargetEXT
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_2D_EXT = GLenum::GL_CONVOLUTION_2D_EXT; // reuse ConvolutionTargetEXT
// GLBINDING_CONSTEXPR static const GLenum GL_SEPARABLE_2D_EXT = GLenum::GL_SEPARABLE_2D_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_RED_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_GREEN_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_BLUE_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_ALPHA_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_RED_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_GREEN_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_BLUE_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_ALPHA_BIAS_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_EXT = GLenum::GL_HISTOGRAM_EXT; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_EXT = GLenum::GL_MINMAX_EXT; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_FILL = GLenum::GL_POLYGON_OFFSET_FILL; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_FACTOR = GLenum::GL_POLYGON_OFFSET_FACTOR;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_BIAS_EXT = GLenum::GL_POLYGON_OFFSET_BIAS_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_RESCALE_NORMAL_EXT = GLenum::GL_RESCALE_NORMAL_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_1D = GLenum::GL_TEXTURE_BINDING_1D;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_2D = GLenum::GL_TEXTURE_BINDING_2D;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D_BINDING_EXT = GLenum::GL_TEXTURE_3D_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_3D = GLenum::GL_TEXTURE_BINDING_3D;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_IMAGES = GLenum::GL_PACK_SKIP_IMAGES;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_IMAGES_EXT = GLenum::GL_PACK_SKIP_IMAGES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_HEIGHT = GLenum::GL_PACK_IMAGE_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_HEIGHT_EXT = GLenum::GL_PACK_IMAGE_HEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_IMAGES = GLenum::GL_UNPACK_SKIP_IMAGES;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_IMAGES_EXT = GLenum::GL_UNPACK_SKIP_IMAGES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_HEIGHT = GLenum::GL_UNPACK_IMAGE_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_HEIGHT_EXT = GLenum::GL_UNPACK_IMAGE_HEIGHT_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D_EXT = GLenum::GL_TEXTURE_3D_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAX_3D_TEXTURE_SIZE = GLenum::GL_MAX_3D_TEXTURE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_3D_TEXTURE_SIZE_EXT = GLenum::GL_MAX_3D_TEXTURE_SIZE_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY = GLenum::GL_VERTEX_ARRAY; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY = GLenum::GL_NORMAL_ARRAY; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY = GLenum::GL_COLOR_ARRAY; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY = GLenum::GL_INDEX_ARRAY; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY = GLenum::GL_TEXTURE_COORD_ARRAY; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY = GLenum::GL_EDGE_FLAG_ARRAY; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_SIZE = GLenum::GL_VERTEX_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_TYPE = GLenum::GL_VERTEX_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_STRIDE = GLenum::GL_VERTEX_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_COUNT_EXT = GLenum::GL_VERTEX_ARRAY_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_TYPE = GLenum::GL_NORMAL_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_STRIDE = GLenum::GL_NORMAL_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_COUNT_EXT = GLenum::GL_NORMAL_ARRAY_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_SIZE = GLenum::GL_COLOR_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_TYPE = GLenum::GL_COLOR_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_STRIDE = GLenum::GL_COLOR_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_COUNT_EXT = GLenum::GL_COLOR_ARRAY_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_TYPE = GLenum::GL_INDEX_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_STRIDE = GLenum::GL_INDEX_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_COUNT_EXT = GLenum::GL_INDEX_ARRAY_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_SIZE = GLenum::GL_TEXTURE_COORD_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_TYPE = GLenum::GL_TEXTURE_COORD_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_STRIDE = GLenum::GL_TEXTURE_COORD_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_COUNT_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_STRIDE = GLenum::GL_EDGE_FLAG_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_COUNT_EXT = GLenum::GL_EDGE_FLAG_ARRAY_COUNT_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_INTERLACE_SGIX = GLenum::GL_INTERLACE_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_2D_BINDING_SGIS = GLenum::GL_DETAIL_TEXTURE_2D_BINDING_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_SGIS = GLenum::GL_MULTISAMPLE_SGIS; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_MASK_SGIS = GLenum::GL_SAMPLE_ALPHA_TO_MASK_SGIS; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_ONE_SGIS = GLenum::GL_SAMPLE_ALPHA_TO_ONE_SGIS; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_SGIS = GLenum::GL_SAMPLE_MASK_SGIS; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS = GLenum::GL_SAMPLE_BUFFERS; // reuse GetFramebufferParameter
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS_SGIS = GLenum::GL_SAMPLE_BUFFERS_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES = GLenum::GL_SAMPLES; // reuse GetFramebufferParameter
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_SGIS = GLenum::GL_SAMPLES_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE_VALUE = GLenum::GL_SAMPLE_COVERAGE_VALUE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_VALUE_SGIS = GLenum::GL_SAMPLE_MASK_VALUE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE_INVERT = GLenum::GL_SAMPLE_COVERAGE_INVERT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_INVERT_SGIS = GLenum::GL_SAMPLE_MASK_INVERT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_PATTERN_SGIS = GLenum::GL_SAMPLE_PATTERN_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATRIX_SGI = GLenum::GL_COLOR_MATRIX_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATRIX_STACK_DEPTH_SGI = GLenum::GL_COLOR_MATRIX_STACK_DEPTH_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI = GLenum::GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_RED_SCALE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_RED_BIAS_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI;
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COLOR_TABLE_SGI = GLenum::GL_TEXTURE_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_DST_RGB = GLenum::GL_BLEND_DST_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_SRC_RGB = GLenum::GL_BLEND_SRC_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_DST_ALPHA = GLenum::GL_BLEND_DST_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_SRC_ALPHA = GLenum::GL_BLEND_SRC_ALPHA;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_TABLE_SGI = GLenum::GL_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_COLOR_TABLE_SGI = GLenum::GL_POST_CONVOLUTION_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI; // reuse ColorTableTargetSGI
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ELEMENTS_VERTICES = GLenum::GL_MAX_ELEMENTS_VERTICES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ELEMENTS_INDICES = GLenum::GL_MAX_ELEMENTS_INDICES;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN = GLenum::GL_POINT_SIZE_MIN;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN_ARB = GLenum::GL_POINT_SIZE_MIN_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN_EXT = GLenum::GL_POINT_SIZE_MIN_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN_SGIS = GLenum::GL_POINT_SIZE_MIN_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX = GLenum::GL_POINT_SIZE_MAX;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX_ARB = GLenum::GL_POINT_SIZE_MAX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX_EXT = GLenum::GL_POINT_SIZE_MAX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX_SGIS = GLenum::GL_POINT_SIZE_MAX_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE = GLenum::GL_POINT_FADE_THRESHOLD_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE_ARB = GLenum::GL_POINT_FADE_THRESHOLD_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE_EXT = GLenum::GL_POINT_FADE_THRESHOLD_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE_SGIS = GLenum::GL_POINT_FADE_THRESHOLD_SIZE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DISTANCE_ATTENUATION_EXT = GLenum::GL_DISTANCE_ATTENUATION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DISTANCE_ATTENUATION_SGIS = GLenum::GL_DISTANCE_ATTENUATION_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_DISTANCE_ATTENUATION = GLenum::GL_POINT_DISTANCE_ATTENUATION;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_DISTANCE_ATTENUATION_ARB = GLenum::GL_POINT_DISTANCE_ATTENUATION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_FUNC_POINTS_SGIS = GLenum::GL_FOG_FUNC_POINTS_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FOG_FUNC_POINTS_SGIS = GLenum::GL_MAX_FOG_FUNC_POINTS_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_VOLUMES_SGIS = GLenum::GL_PACK_SKIP_VOLUMES_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_DEPTH_SGIS = GLenum::GL_PACK_IMAGE_DEPTH_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_VOLUMES_SGIS = GLenum::GL_UNPACK_SKIP_VOLUMES_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_DEPTH_SGIS = GLenum::GL_UNPACK_IMAGE_DEPTH_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4D_SGIS = GLenum::GL_TEXTURE_4D_SGIS; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAX_4D_TEXTURE_SIZE_SGIS = GLenum::GL_MAX_4D_TEXTURE_SIZE_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TEX_GEN_SGIX = GLenum::GL_PIXEL_TEX_GEN_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX = GLenum::GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_CACHE_INCREMENT_SGIX = GLenum::GL_PIXEL_TILE_CACHE_INCREMENT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_WIDTH_SGIX = GLenum::GL_PIXEL_TILE_WIDTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_HEIGHT_SGIX = GLenum::GL_PIXEL_TILE_HEIGHT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_WIDTH_SGIX = GLenum::GL_PIXEL_TILE_GRID_WIDTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_HEIGHT_SGIX = GLenum::GL_PIXEL_TILE_GRID_HEIGHT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_DEPTH_SGIX = GLenum::GL_PIXEL_TILE_GRID_DEPTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_CACHE_SIZE_SGIX = GLenum::GL_PIXEL_TILE_CACHE_SIZE_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_SGIX = GLenum::GL_SPRITE_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_MODE_SGIX = GLenum::GL_SPRITE_MODE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_AXIS_SGIX = GLenum::GL_SPRITE_AXIS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_TRANSLATION_SGIX = GLenum::GL_SPRITE_TRANSLATION_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4D_BINDING_SGIS = GLenum::GL_TEXTURE_4D_BINDING_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CLIPMAP_DEPTH_SGIX = GLenum::GL_MAX_CLIPMAP_DEPTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX = GLenum::GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX = GLenum::GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX = GLenum::GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_REFERENCE_PLANE_SGIX = GLenum::GL_REFERENCE_PLANE_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_REFERENCE_PLANE_EQUATION_SGIX = GLenum::GL_REFERENCE_PLANE_EQUATION_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_IR_INSTRUMENT1_SGIX = GLenum::GL_IR_INSTRUMENT1_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_INSTRUMENT_MEASUREMENTS_SGIX = GLenum::GL_INSTRUMENT_MEASUREMENTS_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_CALLIGRAPHIC_FRAGMENT_SGIX = GLenum::GL_CALLIGRAPHIC_FRAGMENT_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEZOOM_SGIX = GLenum::GL_FRAMEZOOM_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEZOOM_FACTOR_SGIX = GLenum::GL_FRAMEZOOM_FACTOR_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAMEZOOM_FACTOR_SGIX = GLenum::GL_MAX_FRAMEZOOM_FACTOR_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP_HINT_SGIS = GLenum::GL_GENERATE_MIPMAP_HINT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DEFORMATIONS_MASK_SGIX = GLenum::GL_DEFORMATIONS_MASK_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_OFFSET_SGIX = GLenum::GL_FOG_OFFSET_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_OFFSET_VALUE_SGIX = GLenum::GL_FOG_OFFSET_VALUE_SGIX; // reuse FogParameter
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_COLOR_CONTROL = GLenum::GL_LIGHT_MODEL_COLOR_CONTROL;
// GLBINDING_CONSTEXPR static const GLenum GL_SHARED_TEXTURE_PALETTE_EXT = GLenum::GL_SHARED_TEXTURE_PALETTE_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAJOR_VERSION = GLenum::GL_MAJOR_VERSION;
GLBINDING_CONSTEXPR static const GLenum GL_MINOR_VERSION = GLenum::GL_MINOR_VERSION;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_EXTENSIONS = GLenum::GL_NUM_EXTENSIONS;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_FLAGS = GLenum::GL_CONTEXT_FLAGS;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_PIPELINE_BINDING = GLenum::GL_PROGRAM_PIPELINE_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VIEWPORTS = GLenum::GL_MAX_VIEWPORTS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEWPORT_SUBPIXEL_BITS = GLenum::GL_VIEWPORT_SUBPIXEL_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEWPORT_BOUNDS_RANGE = GLenum::GL_VIEWPORT_BOUNDS_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_LAYER_PROVOKING_VERTEX = GLenum::GL_LAYER_PROVOKING_VERTEX;
GLBINDING_CONSTEXPR static const GLenum GL_VIEWPORT_INDEX_PROVOKING_VERTEX = GLenum::GL_VIEWPORT_INDEX_PROVOKING_VERTEX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_UNIFORM_COMPONENTS = GLenum::GL_MAX_COMPUTE_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = GLenum::GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_ATOMIC_COUNTERS = GLenum::GL_MAX_COMPUTE_ATOMIC_COUNTERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = GLenum::GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DEBUG_GROUP_STACK_DEPTH = GLenum::GL_MAX_DEBUG_GROUP_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_GROUP_STACK_DEPTH = GLenum::GL_DEBUG_GROUP_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_UNIFORM_LOCATIONS = GLenum::GL_MAX_UNIFORM_LOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_BINDING_DIVISOR = GLenum::GL_VERTEX_BINDING_DIVISOR;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_BINDING_OFFSET = GLenum::GL_VERTEX_BINDING_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_BINDING_STRIDE = GLenum::GL_VERTEX_BINDING_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = GLenum::GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ATTRIB_BINDINGS = GLenum::GL_MAX_VERTEX_ATTRIB_BINDINGS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_LABEL_LENGTH = GLenum::GL_MAX_LABEL_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_HINT_SGIX = GLenum::GL_CONVOLUTION_HINT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_MARKER_SGIX = GLenum::GL_ASYNC_MARKER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TEX_GEN_MODE_SGIX = GLenum::GL_PIXEL_TEX_GEN_MODE_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_HISTOGRAM_SGIX = GLenum::GL_ASYNC_HISTOGRAM_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ASYNC_HISTOGRAM_SGIX = GLenum::GL_MAX_ASYNC_HISTOGRAM_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TEXTURE_SGIS = GLenum::GL_PIXEL_TEXTURE_SGIS; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_TEX_IMAGE_SGIX = GLenum::GL_ASYNC_TEX_IMAGE_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_DRAW_PIXELS_SGIX = GLenum::GL_ASYNC_DRAW_PIXELS_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_ASYNC_READ_PIXELS_SGIX = GLenum::GL_ASYNC_READ_PIXELS_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ASYNC_TEX_IMAGE_SGIX = GLenum::GL_MAX_ASYNC_TEX_IMAGE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ASYNC_DRAW_PIXELS_SGIX = GLenum::GL_MAX_ASYNC_DRAW_PIXELS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ASYNC_READ_PIXELS_SGIX = GLenum::GL_MAX_ASYNC_READ_PIXELS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PRECLIP_SGIX = GLenum::GL_VERTEX_PRECLIP_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PRECLIP_HINT_SGIX = GLenum::GL_VERTEX_PRECLIP_HINT_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHTING_SGIX = GLenum::GL_FRAGMENT_LIGHTING_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_COLOR_MATERIAL_SGIX = GLenum::GL_FRAGMENT_COLOR_MATERIAL_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX = GLenum::GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX = GLenum::GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_LIGHTS_SGIX = GLenum::GL_MAX_FRAGMENT_LIGHTS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ACTIVE_LIGHTS_SGIX = GLenum::GL_MAX_ACTIVE_LIGHTS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_ENV_MODE_SGIX = GLenum::GL_LIGHT_ENV_MODE_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX; // reuse FragmentLightModelParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX; // reuse FragmentLightModelParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX; // reuse FragmentLightModelParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX = GLenum::GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX; // reuse FragmentLightModelParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT0_SGIX = GLenum::GL_FRAGMENT_LIGHT0_SGIX; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PACK_RESAMPLE_SGIX = GLenum::GL_PACK_RESAMPLE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_RESAMPLE_SGIX = GLenum::GL_UNPACK_RESAMPLE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ALIASED_POINT_SIZE_RANGE = GLenum::GL_ALIASED_POINT_SIZE_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_ALIASED_LINE_WIDTH_RANGE = GLenum::GL_ALIASED_LINE_WIDTH_RANGE;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_TEXTURE = GLenum::GL_ACTIVE_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RENDERBUFFER_SIZE = GLenum::GL_MAX_RENDERBUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSION_HINT = GLenum::GL_TEXTURE_COMPRESSION_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_RECTANGLE = GLenum::GL_TEXTURE_BINDING_RECTANGLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_RECTANGLE_ARB = GLenum::GL_TEXTURE_BINDING_RECTANGLE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_RECTANGLE_NV = GLenum::GL_TEXTURE_BINDING_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RECTANGLE_TEXTURE_SIZE = GLenum::GL_MAX_RECTANGLE_TEXTURE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_LOD_BIAS = GLenum::GL_MAX_TEXTURE_LOD_BIAS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_CUBE_MAP = GLenum::GL_TEXTURE_BINDING_CUBE_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_CUBE_MAP_ARB = GLenum::GL_TEXTURE_BINDING_CUBE_MAP_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_CUBE_MAP_EXT = GLenum::GL_TEXTURE_BINDING_CUBE_MAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CUBE_MAP_TEXTURE_SIZE = GLenum::GL_MAX_CUBE_MAP_TEXTURE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = GLenum::GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT = GLenum::GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_SUBSAMPLE_RATE_SGIX = GLenum::GL_PACK_SUBSAMPLE_RATE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SUBSAMPLE_RATE_SGIX = GLenum::GL_UNPACK_SUBSAMPLE_RATE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_BINDING = GLenum::GL_VERTEX_ARRAY_BINDING;
// GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_POINT_SIZE = GLenum::GL_PROGRAM_POINT_SIZE; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_NUM_COMPRESSED_TEXTURE_FORMATS = GLenum::GL_NUM_COMPRESSED_TEXTURE_FORMATS;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_TEXTURE_FORMATS = GLenum::GL_COMPRESSED_TEXTURE_FORMATS;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_PROGRAM_BINARY_FORMATS = GLenum::GL_NUM_PROGRAM_BINARY_FORMATS;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINARY_FORMATS = GLenum::GL_PROGRAM_BINARY_FORMATS;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_FUNC = GLenum::GL_STENCIL_BACK_FUNC;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_FAIL = GLenum::GL_STENCIL_BACK_FAIL;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_PASS_DEPTH_FAIL = GLenum::GL_STENCIL_BACK_PASS_DEPTH_FAIL;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_PASS_DEPTH_PASS = GLenum::GL_STENCIL_BACK_PASS_DEPTH_PASS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DRAW_BUFFERS = GLenum::GL_MAX_DRAW_BUFFERS;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION_ALPHA = GLenum::GL_BLEND_EQUATION_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ATTRIBS = GLenum::GL_MAX_VERTEX_ATTRIBS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_IMAGE_UNITS = GLenum::GL_MAX_TEXTURE_IMAGE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_BUFFER_BINDING = GLenum::GL_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_BUFFER_BINDING = GLenum::GL_ELEMENT_ARRAY_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_PACK_BUFFER_BINDING = GLenum::GL_PIXEL_PACK_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_UNPACK_BUFFER_BINDING = GLenum::GL_PIXEL_UNPACK_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = GLenum::GL_MAX_DUAL_SOURCE_DRAW_BUFFERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ARRAY_TEXTURE_LAYERS = GLenum::GL_MAX_ARRAY_TEXTURE_LAYERS;
GLBINDING_CONSTEXPR static const GLenum GL_MIN_PROGRAM_TEXEL_OFFSET = GLenum::GL_MIN_PROGRAM_TEXEL_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_TEXEL_OFFSET = GLenum::GL_MAX_PROGRAM_TEXEL_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_BINDING = GLenum::GL_SAMPLER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_ATI = GLenum::GL_FRAGMENT_SHADER_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER_BINDING = GLenum::GL_UNIFORM_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER_START = GLenum::GL_UNIFORM_BUFFER_START;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER_SIZE = GLenum::GL_UNIFORM_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_UNIFORM_BLOCKS = GLenum::GL_MAX_VERTEX_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_UNIFORM_BLOCKS = GLenum::GL_MAX_GEOMETRY_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_UNIFORM_BLOCKS = GLenum::GL_MAX_FRAGMENT_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_UNIFORM_BLOCKS = GLenum::GL_MAX_COMBINED_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_UNIFORM_BUFFER_BINDINGS = GLenum::GL_MAX_UNIFORM_BUFFER_BINDINGS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_UNIFORM_BLOCK_SIZE = GLenum::GL_MAX_UNIFORM_BLOCK_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = GLenum::GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = GLenum::GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = GLenum::GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = GLenum::GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = GLenum::GL_MAX_FRAGMENT_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_UNIFORM_COMPONENTS = GLenum::GL_MAX_VERTEX_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VARYING_FLOATS = GLenum::GL_MAX_VARYING_FLOATS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VARYING_COMPONENTS = GLenum::GL_MAX_VARYING_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = GLenum::GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = GLenum::GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_DERIVATIVE_HINT = GLenum::GL_FRAGMENT_SHADER_DERIVATIVE_HINT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_PROGRAM = GLenum::GL_CURRENT_PROGRAM;
// GLBINDING_CONSTEXPR static const GLenum GL_IMPLEMENTATION_COLOR_READ_TYPE = GLenum::GL_IMPLEMENTATION_COLOR_READ_TYPE; // reuse GetFramebufferParameter
// GLBINDING_CONSTEXPR static const GLenum GL_IMPLEMENTATION_COLOR_READ_FORMAT = GLenum::GL_IMPLEMENTATION_COLOR_READ_FORMAT; // reuse GetFramebufferParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_1D_ARRAY = GLenum::GL_TEXTURE_BINDING_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_2D_ARRAY = GLenum::GL_TEXTURE_BINDING_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = GLenum::GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_BUFFER_SIZE = GLenum::GL_MAX_TEXTURE_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_BUFFER = GLenum::GL_TEXTURE_BINDING_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_START = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_START;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_REF = GLenum::GL_STENCIL_BACK_REF;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_VALUE_MASK = GLenum::GL_STENCIL_BACK_VALUE_MASK;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_WRITEMASK = GLenum::GL_STENCIL_BACK_WRITEMASK;
GLBINDING_CONSTEXPR static const GLenum GL_DRAW_FRAMEBUFFER_BINDING = GLenum::GL_DRAW_FRAMEBUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_BINDING = GLenum::GL_RENDERBUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_READ_FRAMEBUFFER_BINDING = GLenum::GL_READ_FRAMEBUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COLOR_ATTACHMENTS = GLenum::GL_MAX_COLOR_ATTACHMENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COLOR_ATTACHMENTS_EXT = GLenum::GL_MAX_COLOR_ATTACHMENTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ELEMENT_INDEX = GLenum::GL_MAX_ELEMENT_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = GLenum::GL_MAX_GEOMETRY_UNIFORM_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_BINARY_FORMATS = GLenum::GL_SHADER_BINARY_FORMATS;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_SHADER_BINARY_FORMATS = GLenum::GL_NUM_SHADER_BINARY_FORMATS;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_COMPILER = GLenum::GL_SHADER_COMPILER;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_UNIFORM_VECTORS = GLenum::GL_MAX_VERTEX_UNIFORM_VECTORS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VARYING_VECTORS = GLenum::GL_MAX_VARYING_VECTORS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_UNIFORM_VECTORS = GLenum::GL_MAX_FRAGMENT_UNIFORM_VECTORS;
GLBINDING_CONSTEXPR static const GLenum GL_TIMESTAMP = GLenum::GL_TIMESTAMP;
GLBINDING_CONSTEXPR static const GLenum GL_PROVOKING_VERTEX = GLenum::GL_PROVOKING_VERTEX;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SAMPLE_MASK_WORDS = GLenum::GL_MAX_SAMPLE_MASK_WORDS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = GLenum::GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = GLenum::GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_RESTART_INDEX = GLenum::GL_PRIMITIVE_RESTART_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_MIN_MAP_BUFFER_ALIGNMENT = GLenum::GL_MIN_MAP_BUFFER_ALIGNMENT;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BUFFER_BINDING = GLenum::GL_SHADER_STORAGE_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BUFFER_START = GLenum::GL_SHADER_STORAGE_BUFFER_START;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BUFFER_SIZE = GLenum::GL_SHADER_STORAGE_BUFFER_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = GLenum::GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = GLenum::GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = GLenum::GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = GLenum::GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = GLenum::GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = GLenum::GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = GLenum::GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = GLenum::GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = GLenum::GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = GLenum::GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_DISPATCH_INDIRECT_BUFFER_BINDING = GLenum::GL_DISPATCH_INDIRECT_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_2D_MULTISAMPLE = GLenum::GL_TEXTURE_BINDING_2D_MULTISAMPLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = GLenum::GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COLOR_TEXTURE_SAMPLES = GLenum::GL_MAX_COLOR_TEXTURE_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DEPTH_TEXTURE_SAMPLES = GLenum::GL_MAX_DEPTH_TEXTURE_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_INTEGER_SAMPLES = GLenum::GL_MAX_INTEGER_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SERVER_WAIT_TIMEOUT = GLenum::GL_MAX_SERVER_WAIT_TIMEOUT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_OUTPUT_COMPONENTS = GLenum::GL_MAX_VERTEX_OUTPUT_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_INPUT_COMPONENTS = GLenum::GL_MAX_GEOMETRY_INPUT_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = GLenum::GL_MAX_GEOMETRY_OUTPUT_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_INPUT_COMPONENTS = GLenum::GL_MAX_FRAGMENT_INPUT_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_PROFILE_MASK = GLenum::GL_CONTEXT_PROFILE_MASK;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = GLenum::GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_UNIFORM_BLOCKS = GLenum::GL_MAX_COMPUTE_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = GLenum::GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_WORK_GROUP_COUNT = GLenum::GL_MAX_COMPUTE_WORK_GROUP_COUNT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_WORK_GROUP_SIZE = GLenum::GL_MAX_COMPUTE_WORK_GROUP_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ATOMIC_COUNTERS = GLenum::GL_MAX_VERTEX_ATOMIC_COUNTERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = GLenum::GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = GLenum::GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GEOMETRY_ATOMIC_COUNTERS = GLenum::GL_MAX_GEOMETRY_ATOMIC_COUNTERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAGMENT_ATOMIC_COUNTERS = GLenum::GL_MAX_FRAGMENT_ATOMIC_COUNTERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_ATOMIC_COUNTERS = GLenum::GL_MAX_COMBINED_ATOMIC_COUNTERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAMEBUFFER_WIDTH = GLenum::GL_MAX_FRAMEBUFFER_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAMEBUFFER_HEIGHT = GLenum::GL_MAX_FRAMEBUFFER_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAMEBUFFER_LAYERS = GLenum::GL_MAX_FRAMEBUFFER_LAYERS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_FRAMEBUFFER_SAMPLES = GLenum::GL_MAX_FRAMEBUFFER_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_DEVICE_UUIDS_EXT = GLenum::GL_NUM_DEVICE_UUIDS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEVICE_UUID_EXT = GLenum::GL_DEVICE_UUID_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DRIVER_UUID_EXT = GLenum::GL_DRIVER_UUID_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEVICE_LUID_EXT = GLenum::GL_DEVICE_LUID_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEVICE_NODE_MASK_EXT = GLenum::GL_DEVICE_NODE_MASK_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV = GLenum::GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_SHADING_RATE_IMAGE_PALETTE_COUNT_NV = GLenum::GL_SHADING_RATE_IMAGE_PALETTE_COUNT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TIMELINE_SEMAPHORE_VALUE_DIFFERENCE_NV = GLenum::GL_MAX_TIMELINE_SEMAPHORE_VALUE_DIFFERENCE_NV;

// GetPointervPName

GLBINDING_CONSTEXPR static const GLenum GL_FEEDBACK_BUFFER_POINTER = GLenum::GL_FEEDBACK_BUFFER_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_SELECTION_BUFFER_POINTER = GLenum::GL_SELECTION_BUFFER_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_POINTER = GLenum::GL_VERTEX_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_POINTER_EXT = GLenum::GL_VERTEX_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_POINTER = GLenum::GL_NORMAL_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_POINTER_EXT = GLenum::GL_NORMAL_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_POINTER = GLenum::GL_COLOR_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_POINTER_EXT = GLenum::GL_COLOR_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_POINTER = GLenum::GL_INDEX_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_POINTER_EXT = GLenum::GL_INDEX_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_POINTER = GLenum::GL_TEXTURE_COORD_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_POINTER_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_POINTER = GLenum::GL_EDGE_FLAG_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_POINTER_EXT = GLenum::GL_EDGE_FLAG_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INSTRUMENT_BUFFER_POINTER_SGIX = GLenum::GL_INSTRUMENT_BUFFER_POINTER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_CALLBACK_FUNCTION = GLenum::GL_DEBUG_CALLBACK_FUNCTION;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_CALLBACK_USER_PARAM = GLenum::GL_DEBUG_CALLBACK_USER_PARAM;

// GetTexBumpParameterATI

GLBINDING_CONSTEXPR static const GLenum GL_BUMP_ROT_MATRIX_ATI = GLenum::GL_BUMP_ROT_MATRIX_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_ROT_MATRIX_SIZE_ATI = GLenum::GL_BUMP_ROT_MATRIX_SIZE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_NUM_TEX_UNITS_ATI = GLenum::GL_BUMP_NUM_TEX_UNITS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_TEX_UNITS_ATI = GLenum::GL_BUMP_TEX_UNITS_ATI;

// GetTextureParameter

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WIDTH = GLenum::GL_TEXTURE_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_HEIGHT = GLenum::GL_TEXTURE_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTERNAL_FORMAT = GLenum::GL_TEXTURE_INTERNAL_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPONENTS = GLenum::GL_TEXTURE_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER_COLOR = GLenum::GL_TEXTURE_BORDER_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER = GLenum::GL_TEXTURE_BORDER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAG_FILTER = GLenum::GL_TEXTURE_MAG_FILTER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_FILTER = GLenum::GL_TEXTURE_MIN_FILTER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_S = GLenum::GL_TEXTURE_WRAP_S;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_T = GLenum::GL_TEXTURE_WRAP_T;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RED_SIZE = GLenum::GL_TEXTURE_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GREEN_SIZE = GLenum::GL_TEXTURE_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BLUE_SIZE = GLenum::GL_TEXTURE_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ALPHA_SIZE = GLenum::GL_TEXTURE_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LUMINANCE_SIZE = GLenum::GL_TEXTURE_LUMINANCE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTENSITY_SIZE = GLenum::GL_TEXTURE_INTENSITY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_PRIORITY = GLenum::GL_TEXTURE_PRIORITY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RESIDENT = GLenum::GL_TEXTURE_RESIDENT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEPTH_EXT = GLenum::GL_TEXTURE_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_R_EXT = GLenum::GL_TEXTURE_WRAP_R_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_LEVEL_SGIS = GLenum::GL_DETAIL_TEXTURE_LEVEL_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_MODE_SGIS = GLenum::GL_DETAIL_TEXTURE_MODE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS = GLenum::GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = GLenum::GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_SHADOW_AMBIENT_SGIX = GLenum::GL_SHADOW_AMBIENT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_TEXTURE_SELECT_SGIS = GLenum::GL_DUAL_TEXTURE_SELECT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_TEXTURE_SELECT_SGIS = GLenum::GL_QUAD_TEXTURE_SELECT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4DSIZE_SGIS = GLenum::GL_TEXTURE_4DSIZE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_Q_SGIS = GLenum::GL_TEXTURE_WRAP_Q_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_LOD_SGIS = GLenum::GL_TEXTURE_MIN_LOD_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LOD_SGIS = GLenum::GL_TEXTURE_MAX_LOD_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BASE_LEVEL_SGIS = GLenum::GL_TEXTURE_BASE_LEVEL_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LEVEL_SGIS = GLenum::GL_TEXTURE_MAX_LEVEL_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_FILTER4_SIZE_SGIS = GLenum::GL_TEXTURE_FILTER4_SIZE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_CENTER_SGIX = GLenum::GL_TEXTURE_CLIPMAP_CENTER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_FRAME_SGIX = GLenum::GL_TEXTURE_CLIPMAP_FRAME_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_OFFSET_SGIX = GLenum::GL_TEXTURE_CLIPMAP_OFFSET_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX = GLenum::GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX = GLenum::GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_DEPTH_SGIX = GLenum::GL_TEXTURE_CLIPMAP_DEPTH_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_BIAS_SGIX = GLenum::GL_POST_TEXTURE_FILTER_BIAS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_SCALE_SGIX = GLenum::GL_POST_TEXTURE_FILTER_SCALE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_S_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_S_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_T_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_T_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_R_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_R_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP_SGIS = GLenum::GL_GENERATE_MIPMAP_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_SGIX = GLenum::GL_TEXTURE_COMPARE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_OPERATOR_SGIX = GLenum::GL_TEXTURE_COMPARE_OPERATOR_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LEQUAL_R_SGIX = GLenum::GL_TEXTURE_LEQUAL_R_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEQUAL_R_SGIX = GLenum::GL_TEXTURE_GEQUAL_R_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_S_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_S_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_T_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_T_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_R_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_R_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_MAP = GLenum::GL_NORMAL_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_MAP_ARB = GLenum::GL_NORMAL_MAP_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_MAP_EXT = GLenum::GL_NORMAL_MAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_MAP_NV = GLenum::GL_NORMAL_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_REFLECTION_MAP = GLenum::GL_REFLECTION_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_REFLECTION_MAP_ARB = GLenum::GL_REFLECTION_MAP_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_REFLECTION_MAP_EXT = GLenum::GL_REFLECTION_MAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_REFLECTION_MAP_NV = GLenum::GL_REFLECTION_MAP_NV;

// GetVariantValueEXT

GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_VALUE_EXT = GLenum::GL_VARIANT_VALUE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_DATATYPE_EXT = GLenum::GL_VARIANT_DATATYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_ARRAY_STRIDE_EXT = GLenum::GL_VARIANT_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VARIANT_ARRAY_TYPE_EXT = GLenum::GL_VARIANT_ARRAY_TYPE_EXT;

// GraphicsResetStatus

// GLBINDING_CONSTEXPR static const GLenum GL_NO_ERROR = GLenum::GL_NO_ERROR; // reuse ErrorCode
GLBINDING_CONSTEXPR static const GLenum GL_GUILTY_CONTEXT_RESET = GLenum::GL_GUILTY_CONTEXT_RESET;
GLBINDING_CONSTEXPR static const GLenum GL_INNOCENT_CONTEXT_RESET = GLenum::GL_INNOCENT_CONTEXT_RESET;
GLBINDING_CONSTEXPR static const GLenum GL_UNKNOWN_CONTEXT_RESET = GLenum::GL_UNKNOWN_CONTEXT_RESET;

// HintMode

// GLBINDING_CONSTEXPR static const GLenum GL_DONT_CARE = GLenum::GL_DONT_CARE; // reuse DebugSeverity
GLBINDING_CONSTEXPR static const GLenum GL_FASTEST = GLenum::GL_FASTEST;
GLBINDING_CONSTEXPR static const GLenum GL_NICEST = GLenum::GL_NICEST;

// HintTarget

// GLBINDING_CONSTEXPR static const GLenum GL_PERSPECTIVE_CORRECTION_HINT = GLenum::GL_PERSPECTIVE_CORRECTION_HINT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SMOOTH_HINT = GLenum::GL_POINT_SMOOTH_HINT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_LINE_SMOOTH_HINT = GLenum::GL_LINE_SMOOTH_HINT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_SMOOTH_HINT = GLenum::GL_POLYGON_SMOOTH_HINT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_FOG_HINT = GLenum::GL_FOG_HINT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_PREFER_DOUBLEBUFFER_HINT_PGI = GLenum::GL_PREFER_DOUBLEBUFFER_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_CONSERVE_MEMORY_HINT_PGI = GLenum::GL_CONSERVE_MEMORY_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_RECLAIM_MEMORY_HINT_PGI = GLenum::GL_RECLAIM_MEMORY_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI = GLenum::GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_NATIVE_GRAPHICS_END_HINT_PGI = GLenum::GL_NATIVE_GRAPHICS_END_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS_FAST_HINT_PGI = GLenum::GL_ALWAYS_FAST_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS_SOFT_HINT_PGI = GLenum::GL_ALWAYS_SOFT_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALLOW_DRAW_OBJ_HINT_PGI = GLenum::GL_ALLOW_DRAW_OBJ_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALLOW_DRAW_WIN_HINT_PGI = GLenum::GL_ALLOW_DRAW_WIN_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALLOW_DRAW_FRG_HINT_PGI = GLenum::GL_ALLOW_DRAW_FRG_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_ALLOW_DRAW_MEM_HINT_PGI = GLenum::GL_ALLOW_DRAW_MEM_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_STRICT_DEPTHFUNC_HINT_PGI = GLenum::GL_STRICT_DEPTHFUNC_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_STRICT_LIGHTING_HINT_PGI = GLenum::GL_STRICT_LIGHTING_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_STRICT_SCISSOR_HINT_PGI = GLenum::GL_STRICT_SCISSOR_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_FULL_STIPPLE_HINT_PGI = GLenum::GL_FULL_STIPPLE_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_NEAR_HINT_PGI = GLenum::GL_CLIP_NEAR_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_FAR_HINT_PGI = GLenum::GL_CLIP_FAR_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_WIDE_LINE_HINT_PGI = GLenum::GL_WIDE_LINE_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_BACK_NORMALS_HINT_PGI = GLenum::GL_BACK_NORMALS_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_DATA_HINT_PGI = GLenum::GL_VERTEX_DATA_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_CONSISTENT_HINT_PGI = GLenum::GL_VERTEX_CONSISTENT_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_MATERIAL_SIDE_HINT_PGI = GLenum::GL_MATERIAL_SIDE_HINT_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_HINT_PGI = GLenum::GL_MAX_VERTEX_HINT_PGI;
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_CMYK_HINT_EXT = GLenum::GL_PACK_CMYK_HINT_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_CMYK_HINT_EXT = GLenum::GL_UNPACK_CMYK_HINT_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_PHONG_HINT_WIN = GLenum::GL_PHONG_HINT_WIN;
GLBINDING_CONSTEXPR static const GLenum GL_CLIP_VOLUME_CLIPPING_HINT_EXT = GLenum::GL_CLIP_VOLUME_CLIPPING_HINT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MULTI_BUFFER_HINT_SGIX = GLenum::GL_TEXTURE_MULTI_BUFFER_HINT_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP_HINT = GLenum::GL_GENERATE_MIPMAP_HINT;
// GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP_HINT_SGIS = GLenum::GL_GENERATE_MIPMAP_HINT_SGIS; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINARY_RETRIEVABLE_HINT = GLenum::GL_PROGRAM_BINARY_RETRIEVABLE_HINT;
// GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_HINT_SGIX = GLenum::GL_CONVOLUTION_HINT_SGIX; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_SCALEBIAS_HINT_SGIX = GLenum::GL_SCALEBIAS_HINT_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PRECLIP_SGIX = GLenum::GL_VERTEX_PRECLIP_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PRECLIP_HINT_SGIX = GLenum::GL_VERTEX_PRECLIP_HINT_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSION_HINT = GLenum::GL_TEXTURE_COMPRESSION_HINT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSION_HINT_ARB = GLenum::GL_TEXTURE_COMPRESSION_HINT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_STORAGE_HINT_APPLE = GLenum::GL_VERTEX_ARRAY_STORAGE_HINT_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_FILTER_HINT_NV = GLenum::GL_MULTISAMPLE_FILTER_HINT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_HINT_APPLE = GLenum::GL_TRANSFORM_HINT_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_STORAGE_HINT_APPLE = GLenum::GL_TEXTURE_STORAGE_HINT_APPLE;
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_DERIVATIVE_HINT = GLenum::GL_FRAGMENT_SHADER_DERIVATIVE_HINT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = GLenum::GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB;

// HintTargetPGI

// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_DATA_HINT_PGI = GLenum::GL_VERTEX_DATA_HINT_PGI; // reuse HintTarget
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_CONSISTENT_HINT_PGI = GLenum::GL_VERTEX_CONSISTENT_HINT_PGI; // reuse HintTarget
// GLBINDING_CONSTEXPR static const GLenum GL_MATERIAL_SIDE_HINT_PGI = GLenum::GL_MATERIAL_SIDE_HINT_PGI; // reuse HintTarget
// GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_HINT_PGI = GLenum::GL_MAX_VERTEX_HINT_PGI; // reuse HintTarget

// HistogramTarget

GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM = GLenum::GL_HISTOGRAM;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_HISTOGRAM = GLenum::GL_PROXY_HISTOGRAM;

// HistogramTargetEXT

// GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM = GLenum::GL_HISTOGRAM; // reuse HistogramTarget
// GLBINDING_CONSTEXPR static const GLenum GL_HISTOGRAM_EXT = GLenum::GL_HISTOGRAM_EXT; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_PROXY_HISTOGRAM = GLenum::GL_PROXY_HISTOGRAM; // reuse HistogramTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_HISTOGRAM_EXT = GLenum::GL_PROXY_HISTOGRAM_EXT;

// ImageTransformPNameHP

GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_SCALE_X_HP = GLenum::GL_IMAGE_SCALE_X_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_SCALE_Y_HP = GLenum::GL_IMAGE_SCALE_Y_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_TRANSLATE_X_HP = GLenum::GL_IMAGE_TRANSLATE_X_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_TRANSLATE_Y_HP = GLenum::GL_IMAGE_TRANSLATE_Y_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_ROTATE_ANGLE_HP = GLenum::GL_IMAGE_ROTATE_ANGLE_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_ROTATE_ORIGIN_X_HP = GLenum::GL_IMAGE_ROTATE_ORIGIN_X_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_ROTATE_ORIGIN_Y_HP = GLenum::GL_IMAGE_ROTATE_ORIGIN_Y_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_MAG_FILTER_HP = GLenum::GL_IMAGE_MAG_FILTER_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_MIN_FILTER_HP = GLenum::GL_IMAGE_MIN_FILTER_HP;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CUBIC_WEIGHT_HP = GLenum::GL_IMAGE_CUBIC_WEIGHT_HP;

// ImageTransformTargetHP

GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_TRANSFORM_2D_HP = GLenum::GL_IMAGE_TRANSFORM_2D_HP;

// IndexFunctionEXT

// GLBINDING_CONSTEXPR static const GLenum GL_NEVER = GLenum::GL_NEVER; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_LESS = GLenum::GL_LESS; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_EQUAL = GLenum::GL_EQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_LEQUAL = GLenum::GL_LEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_GREATER = GLenum::GL_GREATER; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_NOTEQUAL = GLenum::GL_NOTEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_GEQUAL = GLenum::GL_GEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS = GLenum::GL_ALWAYS; // reuse AlphaFunction

// IndexMaterialParameterEXT

// GLBINDING_CONSTEXPR static const GLenum GL_INDEX_OFFSET = GLenum::GL_INDEX_OFFSET; // reuse GetPName

// IndexPointerType

// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// InstancedPathCoverMode

GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_COVER_MODE_NV = GLenum::GL_PATH_FILL_COVER_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONVEX_HULL_NV = GLenum::GL_CONVEX_HULL_NV;
GLBINDING_CONSTEXPR static const GLenum GL_BOUNDING_BOX_NV = GLenum::GL_BOUNDING_BOX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = GLenum::GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV;

// InterleavedArrayFormat

GLBINDING_CONSTEXPR static const GLenum GL_V2F = GLenum::GL_V2F;
GLBINDING_CONSTEXPR static const GLenum GL_V3F = GLenum::GL_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_C4UB_V2F = GLenum::GL_C4UB_V2F;
GLBINDING_CONSTEXPR static const GLenum GL_C4UB_V3F = GLenum::GL_C4UB_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_C3F_V3F = GLenum::GL_C3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_N3F_V3F = GLenum::GL_N3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_C4F_N3F_V3F = GLenum::GL_C4F_N3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_V3F = GLenum::GL_T2F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T4F_V4F = GLenum::GL_T4F_V4F;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_C4UB_V3F = GLenum::GL_T2F_C4UB_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_C3F_V3F = GLenum::GL_T2F_C3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_N3F_V3F = GLenum::GL_T2F_N3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_C4F_N3F_V3F = GLenum::GL_T2F_C4F_N3F_V3F;
GLBINDING_CONSTEXPR static const GLenum GL_T4F_C4F_N3F_V4F = GLenum::GL_T4F_C4F_N3F_V4F;

// InternalFormat

// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX = GLenum::GL_STENCIL_INDEX; // reuse DepthStencilTextureMode
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT = GLenum::GL_DEPTH_COMPONENT; // reuse DepthStencilTextureMode
// GLBINDING_CONSTEXPR static const GLenum GL_RED = GLenum::GL_RED; // reuse FragmentShaderValueRepATI
// GLBINDING_CONSTEXPR static const GLenum GL_RGB = GLenum::GL_RGB; // reuse CombinerComponentUsageNV
GLBINDING_CONSTEXPR static const GLenum GL_RGBA = GLenum::GL_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_R3_G3_B2 = GLenum::GL_R3_G3_B2;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA4 = GLenum::GL_ALPHA4;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA4_EXT = GLenum::GL_ALPHA4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8 = GLenum::GL_ALPHA8;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8_EXT = GLenum::GL_ALPHA8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA12 = GLenum::GL_ALPHA12;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA12_EXT = GLenum::GL_ALPHA12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16 = GLenum::GL_ALPHA16;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16_EXT = GLenum::GL_ALPHA16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4 = GLenum::GL_LUMINANCE4;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4_EXT = GLenum::GL_LUMINANCE4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8 = GLenum::GL_LUMINANCE8;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8_EXT = GLenum::GL_LUMINANCE8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12 = GLenum::GL_LUMINANCE12;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_EXT = GLenum::GL_LUMINANCE12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16 = GLenum::GL_LUMINANCE16;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16_EXT = GLenum::GL_LUMINANCE16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4_ALPHA4 = GLenum::GL_LUMINANCE4_ALPHA4;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4_ALPHA4_EXT = GLenum::GL_LUMINANCE4_ALPHA4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE6_ALPHA2 = GLenum::GL_LUMINANCE6_ALPHA2;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE6_ALPHA2_EXT = GLenum::GL_LUMINANCE6_ALPHA2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8_ALPHA8 = GLenum::GL_LUMINANCE8_ALPHA8;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8_ALPHA8_EXT = GLenum::GL_LUMINANCE8_ALPHA8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA4 = GLenum::GL_LUMINANCE12_ALPHA4;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA4_EXT = GLenum::GL_LUMINANCE12_ALPHA4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA12 = GLenum::GL_LUMINANCE12_ALPHA12;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA12_EXT = GLenum::GL_LUMINANCE12_ALPHA12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16_ALPHA16 = GLenum::GL_LUMINANCE16_ALPHA16;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16_ALPHA16_EXT = GLenum::GL_LUMINANCE16_ALPHA16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY = GLenum::GL_INTENSITY;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY4 = GLenum::GL_INTENSITY4;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY4_EXT = GLenum::GL_INTENSITY4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8 = GLenum::GL_INTENSITY8;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8_EXT = GLenum::GL_INTENSITY8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY12 = GLenum::GL_INTENSITY12;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY12_EXT = GLenum::GL_INTENSITY12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16 = GLenum::GL_INTENSITY16;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16_EXT = GLenum::GL_INTENSITY16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB2_EXT = GLenum::GL_RGB2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB4 = GLenum::GL_RGB4;
GLBINDING_CONSTEXPR static const GLenum GL_RGB4_EXT = GLenum::GL_RGB4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB5 = GLenum::GL_RGB5;
GLBINDING_CONSTEXPR static const GLenum GL_RGB5_EXT = GLenum::GL_RGB5_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8 = GLenum::GL_RGB8;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8_EXT = GLenum::GL_RGB8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB10 = GLenum::GL_RGB10;
GLBINDING_CONSTEXPR static const GLenum GL_RGB10_EXT = GLenum::GL_RGB10_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB12 = GLenum::GL_RGB12;
GLBINDING_CONSTEXPR static const GLenum GL_RGB12_EXT = GLenum::GL_RGB12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16 = GLenum::GL_RGB16;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16_EXT = GLenum::GL_RGB16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA2 = GLenum::GL_RGBA2;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA2_EXT = GLenum::GL_RGBA2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA4 = GLenum::GL_RGBA4;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA4_EXT = GLenum::GL_RGBA4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB5_A1 = GLenum::GL_RGB5_A1;
GLBINDING_CONSTEXPR static const GLenum GL_RGB5_A1_EXT = GLenum::GL_RGB5_A1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8 = GLenum::GL_RGBA8;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8_EXT = GLenum::GL_RGBA8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB10_A2 = GLenum::GL_RGB10_A2;
GLBINDING_CONSTEXPR static const GLenum GL_RGB10_A2_EXT = GLenum::GL_RGB10_A2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA12 = GLenum::GL_RGBA12;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA12_EXT = GLenum::GL_RGBA12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16 = GLenum::GL_RGBA16;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16_EXT = GLenum::GL_RGBA16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_ALPHA4_SGIS = GLenum::GL_DUAL_ALPHA4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_ALPHA8_SGIS = GLenum::GL_DUAL_ALPHA8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_ALPHA12_SGIS = GLenum::GL_DUAL_ALPHA12_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_ALPHA16_SGIS = GLenum::GL_DUAL_ALPHA16_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE4_SGIS = GLenum::GL_DUAL_LUMINANCE4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE8_SGIS = GLenum::GL_DUAL_LUMINANCE8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE12_SGIS = GLenum::GL_DUAL_LUMINANCE12_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE16_SGIS = GLenum::GL_DUAL_LUMINANCE16_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_INTENSITY4_SGIS = GLenum::GL_DUAL_INTENSITY4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_INTENSITY8_SGIS = GLenum::GL_DUAL_INTENSITY8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_INTENSITY12_SGIS = GLenum::GL_DUAL_INTENSITY12_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_INTENSITY16_SGIS = GLenum::GL_DUAL_INTENSITY16_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE_ALPHA4_SGIS = GLenum::GL_DUAL_LUMINANCE_ALPHA4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DUAL_LUMINANCE_ALPHA8_SGIS = GLenum::GL_DUAL_LUMINANCE_ALPHA8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_ALPHA4_SGIS = GLenum::GL_QUAD_ALPHA4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_ALPHA8_SGIS = GLenum::GL_QUAD_ALPHA8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_LUMINANCE4_SGIS = GLenum::GL_QUAD_LUMINANCE4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_LUMINANCE8_SGIS = GLenum::GL_QUAD_LUMINANCE8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_INTENSITY4_SGIS = GLenum::GL_QUAD_INTENSITY4_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_INTENSITY8_SGIS = GLenum::GL_QUAD_INTENSITY8_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT16 = GLenum::GL_DEPTH_COMPONENT16;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT16_ARB = GLenum::GL_DEPTH_COMPONENT16_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT16_SGIX = GLenum::GL_DEPTH_COMPONENT16_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT24 = GLenum::GL_DEPTH_COMPONENT24;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT24_ARB = GLenum::GL_DEPTH_COMPONENT24_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT24_SGIX = GLenum::GL_DEPTH_COMPONENT24_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32 = GLenum::GL_DEPTH_COMPONENT32;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32_ARB = GLenum::GL_DEPTH_COMPONENT32_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32_SGIX = GLenum::GL_DEPTH_COMPONENT32_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED = GLenum::GL_COMPRESSED_RED;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RG = GLenum::GL_COMPRESSED_RG;
GLBINDING_CONSTEXPR static const GLenum GL_RG = GLenum::GL_RG;
GLBINDING_CONSTEXPR static const GLenum GL_R8 = GLenum::GL_R8;
GLBINDING_CONSTEXPR static const GLenum GL_R8_EXT = GLenum::GL_R8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_R16 = GLenum::GL_R16;
GLBINDING_CONSTEXPR static const GLenum GL_RG8 = GLenum::GL_RG8;
GLBINDING_CONSTEXPR static const GLenum GL_RG8_EXT = GLenum::GL_RG8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RG16 = GLenum::GL_RG16;
GLBINDING_CONSTEXPR static const GLenum GL_R16F = GLenum::GL_R16F;
GLBINDING_CONSTEXPR static const GLenum GL_R16F_EXT = GLenum::GL_R16F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_R32F = GLenum::GL_R32F;
GLBINDING_CONSTEXPR static const GLenum GL_R32F_EXT = GLenum::GL_R32F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RG16F = GLenum::GL_RG16F;
GLBINDING_CONSTEXPR static const GLenum GL_RG16F_EXT = GLenum::GL_RG16F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RG32F = GLenum::GL_RG32F;
GLBINDING_CONSTEXPR static const GLenum GL_RG32F_EXT = GLenum::GL_RG32F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_R8I = GLenum::GL_R8I;
GLBINDING_CONSTEXPR static const GLenum GL_R8UI = GLenum::GL_R8UI;
GLBINDING_CONSTEXPR static const GLenum GL_R16I = GLenum::GL_R16I;
GLBINDING_CONSTEXPR static const GLenum GL_R16UI = GLenum::GL_R16UI;
GLBINDING_CONSTEXPR static const GLenum GL_R32I = GLenum::GL_R32I;
GLBINDING_CONSTEXPR static const GLenum GL_R32UI = GLenum::GL_R32UI;
GLBINDING_CONSTEXPR static const GLenum GL_RG8I = GLenum::GL_RG8I;
GLBINDING_CONSTEXPR static const GLenum GL_RG8UI = GLenum::GL_RG8UI;
GLBINDING_CONSTEXPR static const GLenum GL_RG16I = GLenum::GL_RG16I;
GLBINDING_CONSTEXPR static const GLenum GL_RG16UI = GLenum::GL_RG16UI;
GLBINDING_CONSTEXPR static const GLenum GL_RG32I = GLenum::GL_RG32I;
GLBINDING_CONSTEXPR static const GLenum GL_RG32UI = GLenum::GL_RG32UI;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_RGB_S3TC_DXT1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_RGBA_S3TC_DXT1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = GLenum::GL_COMPRESSED_RGBA_S3TC_DXT3_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = GLenum::GL_COMPRESSED_RGBA_S3TC_DXT5_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB = GLenum::GL_COMPRESSED_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA = GLenum::GL_COMPRESSED_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL = GLenum::GL_DEPTH_STENCIL;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_EXT = GLenum::GL_DEPTH_STENCIL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_NV = GLenum::GL_DEPTH_STENCIL_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32F = GLenum::GL_RGBA32F;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32F_ARB = GLenum::GL_RGBA32F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32F_EXT = GLenum::GL_RGBA32F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32F = GLenum::GL_RGB32F;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32F_ARB = GLenum::GL_RGB32F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32F_EXT = GLenum::GL_RGB32F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16F = GLenum::GL_RGBA16F;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16F_ARB = GLenum::GL_RGBA16F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16F_EXT = GLenum::GL_RGBA16F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16F = GLenum::GL_RGB16F;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16F_ARB = GLenum::GL_RGB16F_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16F_EXT = GLenum::GL_RGB16F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH24_STENCIL8 = GLenum::GL_DEPTH24_STENCIL8;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH24_STENCIL8_EXT = GLenum::GL_DEPTH24_STENCIL8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_R11F_G11F_B10F = GLenum::GL_R11F_G11F_B10F;
GLBINDING_CONSTEXPR static const GLenum GL_R11F_G11F_B10F_EXT = GLenum::GL_R11F_G11F_B10F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB9_E5 = GLenum::GL_RGB9_E5;
GLBINDING_CONSTEXPR static const GLenum GL_RGB9_E5_EXT = GLenum::GL_RGB9_E5_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB = GLenum::GL_SRGB;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_EXT = GLenum::GL_SRGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB8 = GLenum::GL_SRGB8;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB8_EXT = GLenum::GL_SRGB8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_ALPHA = GLenum::GL_SRGB_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_ALPHA_EXT = GLenum::GL_SRGB_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB8_ALPHA8 = GLenum::GL_SRGB8_ALPHA8;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB8_ALPHA8_EXT = GLenum::GL_SRGB8_ALPHA8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB = GLenum::GL_COMPRESSED_SRGB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA = GLenum::GL_COMPRESSED_SRGB_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_SRGB_S3TC_DXT1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32F = GLenum::GL_DEPTH_COMPONENT32F;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH32F_STENCIL8 = GLenum::GL_DEPTH32F_STENCIL8;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX1 = GLenum::GL_STENCIL_INDEX1;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX1_EXT = GLenum::GL_STENCIL_INDEX1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX4 = GLenum::GL_STENCIL_INDEX4;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX4_EXT = GLenum::GL_STENCIL_INDEX4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX8 = GLenum::GL_STENCIL_INDEX8;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX8_EXT = GLenum::GL_STENCIL_INDEX8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX16 = GLenum::GL_STENCIL_INDEX16;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX16_EXT = GLenum::GL_STENCIL_INDEX16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB565 = GLenum::GL_RGB565;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32UI = GLenum::GL_RGBA32UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32UI_EXT = GLenum::GL_RGBA32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32UI = GLenum::GL_RGB32UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32UI_EXT = GLenum::GL_RGB32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA32UI_EXT = GLenum::GL_ALPHA32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY32UI_EXT = GLenum::GL_INTENSITY32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE32UI_EXT = GLenum::GL_LUMINANCE32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA32UI_EXT = GLenum::GL_LUMINANCE_ALPHA32UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16UI = GLenum::GL_RGBA16UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16UI_EXT = GLenum::GL_RGBA16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16UI = GLenum::GL_RGB16UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16UI_EXT = GLenum::GL_RGB16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16UI_EXT = GLenum::GL_ALPHA16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16UI_EXT = GLenum::GL_INTENSITY16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16UI_EXT = GLenum::GL_LUMINANCE16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA16UI_EXT = GLenum::GL_LUMINANCE_ALPHA16UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8UI = GLenum::GL_RGBA8UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8UI_EXT = GLenum::GL_RGBA8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8UI = GLenum::GL_RGB8UI;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8UI_EXT = GLenum::GL_RGB8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8UI_EXT = GLenum::GL_ALPHA8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8UI_EXT = GLenum::GL_INTENSITY8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8UI_EXT = GLenum::GL_LUMINANCE8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA8UI_EXT = GLenum::GL_LUMINANCE_ALPHA8UI_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32I = GLenum::GL_RGBA32I;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA32I_EXT = GLenum::GL_RGBA32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32I = GLenum::GL_RGB32I;
GLBINDING_CONSTEXPR static const GLenum GL_RGB32I_EXT = GLenum::GL_RGB32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA32I_EXT = GLenum::GL_ALPHA32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY32I_EXT = GLenum::GL_INTENSITY32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE32I_EXT = GLenum::GL_LUMINANCE32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA32I_EXT = GLenum::GL_LUMINANCE_ALPHA32I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16I = GLenum::GL_RGBA16I;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16I_EXT = GLenum::GL_RGBA16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16I = GLenum::GL_RGB16I;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16I_EXT = GLenum::GL_RGB16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16I_EXT = GLenum::GL_ALPHA16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16I_EXT = GLenum::GL_INTENSITY16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16I_EXT = GLenum::GL_LUMINANCE16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA16I_EXT = GLenum::GL_LUMINANCE_ALPHA16I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8I = GLenum::GL_RGBA8I;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8I_EXT = GLenum::GL_RGBA8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8I = GLenum::GL_RGB8I;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8I_EXT = GLenum::GL_RGB8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8I_EXT = GLenum::GL_ALPHA8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8I_EXT = GLenum::GL_INTENSITY8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8I_EXT = GLenum::GL_LUMINANCE8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA8I_EXT = GLenum::GL_LUMINANCE_ALPHA8I_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32F_NV = GLenum::GL_DEPTH_COMPONENT32F_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH32F_STENCIL8_NV = GLenum::GL_DEPTH32F_STENCIL8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED_RGTC1 = GLenum::GL_COMPRESSED_RED_RGTC1;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED_RGTC1_EXT = GLenum::GL_COMPRESSED_RED_RGTC1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RED_RGTC1 = GLenum::GL_COMPRESSED_SIGNED_RED_RGTC1;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RED_RGTC1_EXT = GLenum::GL_COMPRESSED_SIGNED_RED_RGTC1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED_GREEN_RGTC2_EXT = GLenum::GL_COMPRESSED_RED_GREEN_RGTC2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RG_RGTC2 = GLenum::GL_COMPRESSED_RG_RGTC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT = GLenum::GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RG_RGTC2 = GLenum::GL_COMPRESSED_SIGNED_RG_RGTC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_BPTC_UNORM = GLenum::GL_COMPRESSED_RGBA_BPTC_UNORM;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_BPTC_UNORM_ARB = GLenum::GL_COMPRESSED_RGBA_BPTC_UNORM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = GLenum::GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = GLenum::GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = GLenum::GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = GLenum::GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = GLenum::GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = GLenum::GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_R8_SNORM = GLenum::GL_R8_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RG8_SNORM = GLenum::GL_RG8_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RGB8_SNORM = GLenum::GL_RGB8_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA8_SNORM = GLenum::GL_RGBA8_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_R16_SNORM = GLenum::GL_R16_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RG16_SNORM = GLenum::GL_RG16_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RGB16_SNORM = GLenum::GL_RGB16_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA16_SNORM = GLenum::GL_RGBA16_SNORM;
GLBINDING_CONSTEXPR static const GLenum GL_SR8_EXT = GLenum::GL_SR8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRG8_EXT = GLenum::GL_SRG8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB10_A2UI = GLenum::GL_RGB10_A2UI;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_R11_EAC = GLenum::GL_COMPRESSED_R11_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_R11_EAC = GLenum::GL_COMPRESSED_SIGNED_R11_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RG11_EAC = GLenum::GL_COMPRESSED_RG11_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RG11_EAC = GLenum::GL_COMPRESSED_SIGNED_RG11_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB8_ETC2 = GLenum::GL_COMPRESSED_RGB8_ETC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ETC2 = GLenum::GL_COMPRESSED_SRGB8_ETC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = GLenum::GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = GLenum::GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA8_ETC2_EAC = GLenum::GL_COMPRESSED_RGBA8_ETC2_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_4x4_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_4x4_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_5x4_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_5x4_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_5x5_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_5x5_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_6x5_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_6x5_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_6x6_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_6x6_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_8x5_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_8x5_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_8x6_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_8x6_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_8x8_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_8x8_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_10x5_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_10x5_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_10x6_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_10x6_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_10x8_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_10x8_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_10x10_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_10x10_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_12x10_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_12x10_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_12x12_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_12x12_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR;

// InternalFormatPName

// GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES = GLenum::GL_SAMPLES; // reuse GetFramebufferParameter
GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP = GLenum::GL_GENERATE_MIPMAP;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_SUPPORTED = GLenum::GL_INTERNALFORMAT_SUPPORTED;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_PREFERRED = GLenum::GL_INTERNALFORMAT_PREFERRED;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_RED_SIZE = GLenum::GL_INTERNALFORMAT_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_GREEN_SIZE = GLenum::GL_INTERNALFORMAT_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_BLUE_SIZE = GLenum::GL_INTERNALFORMAT_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_ALPHA_SIZE = GLenum::GL_INTERNALFORMAT_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_DEPTH_SIZE = GLenum::GL_INTERNALFORMAT_DEPTH_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_STENCIL_SIZE = GLenum::GL_INTERNALFORMAT_STENCIL_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_SHARED_SIZE = GLenum::GL_INTERNALFORMAT_SHARED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_RED_TYPE = GLenum::GL_INTERNALFORMAT_RED_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_GREEN_TYPE = GLenum::GL_INTERNALFORMAT_GREEN_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_BLUE_TYPE = GLenum::GL_INTERNALFORMAT_BLUE_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_ALPHA_TYPE = GLenum::GL_INTERNALFORMAT_ALPHA_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_DEPTH_TYPE = GLenum::GL_INTERNALFORMAT_DEPTH_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERNALFORMAT_STENCIL_TYPE = GLenum::GL_INTERNALFORMAT_STENCIL_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_WIDTH = GLenum::GL_MAX_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_HEIGHT = GLenum::GL_MAX_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DEPTH = GLenum::GL_MAX_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_LAYERS = GLenum::GL_MAX_LAYERS;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_COMPONENTS = GLenum::GL_COLOR_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_RENDERABLE = GLenum::GL_COLOR_RENDERABLE;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_RENDERABLE = GLenum::GL_DEPTH_RENDERABLE;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_RENDERABLE = GLenum::GL_STENCIL_RENDERABLE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_RENDERABLE = GLenum::GL_FRAMEBUFFER_RENDERABLE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_RENDERABLE_LAYERED = GLenum::GL_FRAMEBUFFER_RENDERABLE_LAYERED;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_BLEND = GLenum::GL_FRAMEBUFFER_BLEND;
GLBINDING_CONSTEXPR static const GLenum GL_READ_PIXELS = GLenum::GL_READ_PIXELS;
GLBINDING_CONSTEXPR static const GLenum GL_READ_PIXELS_FORMAT = GLenum::GL_READ_PIXELS_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_READ_PIXELS_TYPE = GLenum::GL_READ_PIXELS_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_IMAGE_FORMAT = GLenum::GL_TEXTURE_IMAGE_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_IMAGE_TYPE = GLenum::GL_TEXTURE_IMAGE_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_GET_TEXTURE_IMAGE_FORMAT = GLenum::GL_GET_TEXTURE_IMAGE_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_GET_TEXTURE_IMAGE_TYPE = GLenum::GL_GET_TEXTURE_IMAGE_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_MIPMAP = GLenum::GL_MIPMAP;
GLBINDING_CONSTEXPR static const GLenum GL_AUTO_GENERATE_MIPMAP = GLenum::GL_AUTO_GENERATE_MIPMAP;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ENCODING = GLenum::GL_COLOR_ENCODING;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_READ = GLenum::GL_SRGB_READ;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_WRITE = GLenum::GL_SRGB_WRITE;
GLBINDING_CONSTEXPR static const GLenum GL_FILTER = GLenum::GL_FILTER;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_TEXTURE = GLenum::GL_VERTEX_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_TEXTURE = GLenum::GL_TESS_CONTROL_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_TEXTURE = GLenum::GL_TESS_EVALUATION_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_TEXTURE = GLenum::GL_GEOMETRY_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_TEXTURE = GLenum::GL_FRAGMENT_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_TEXTURE = GLenum::GL_COMPUTE_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SHADOW = GLenum::GL_TEXTURE_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GATHER = GLenum::GL_TEXTURE_GATHER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GATHER_SHADOW = GLenum::GL_TEXTURE_GATHER_SHADOW;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_IMAGE_LOAD = GLenum::GL_SHADER_IMAGE_LOAD;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_IMAGE_STORE = GLenum::GL_SHADER_IMAGE_STORE;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_IMAGE_ATOMIC = GLenum::GL_SHADER_IMAGE_ATOMIC;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_TEXEL_SIZE = GLenum::GL_IMAGE_TEXEL_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_COMPATIBILITY_CLASS = GLenum::GL_IMAGE_COMPATIBILITY_CLASS;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_PIXEL_FORMAT = GLenum::GL_IMAGE_PIXEL_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_PIXEL_TYPE = GLenum::GL_IMAGE_PIXEL_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = GLenum::GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = GLenum::GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST;
GLBINDING_CONSTEXPR static const GLenum GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = GLenum::GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE;
GLBINDING_CONSTEXPR static const GLenum GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = GLenum::GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_BLOCK_WIDTH = GLenum::GL_TEXTURE_COMPRESSED_BLOCK_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = GLenum::GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_BLOCK_SIZE = GLenum::GL_TEXTURE_COMPRESSED_BLOCK_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_CLEAR_BUFFER = GLenum::GL_CLEAR_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_VIEW = GLenum::GL_TEXTURE_VIEW;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_COMPATIBILITY_CLASS = GLenum::GL_VIEW_COMPATIBILITY_CLASS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED = GLenum::GL_TEXTURE_COMPRESSED;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = GLenum::GL_IMAGE_FORMAT_COMPATIBILITY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_CLEAR_TEXTURE = GLenum::GL_CLEAR_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_SAMPLE_COUNTS = GLenum::GL_NUM_SAMPLE_COUNTS;

// InvalidateFramebufferAttachment

// GLBINDING_CONSTEXPR static const GLenum GL_COLOR = GLenum::GL_COLOR; // reuse Buffer
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH = GLenum::GL_DEPTH; // reuse Buffer
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL = GLenum::GL_STENCIL; // reuse Buffer
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_ATTACHMENT = GLenum::GL_DEPTH_STENCIL_ATTACHMENT; // reuse FramebufferAttachment
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT0 = GLenum::GL_COLOR_ATTACHMENT0; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT0_EXT = GLenum::GL_COLOR_ATTACHMENT0_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT1 = GLenum::GL_COLOR_ATTACHMENT1; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT1_EXT = GLenum::GL_COLOR_ATTACHMENT1_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT2 = GLenum::GL_COLOR_ATTACHMENT2; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT2_EXT = GLenum::GL_COLOR_ATTACHMENT2_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT3 = GLenum::GL_COLOR_ATTACHMENT3; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT3_EXT = GLenum::GL_COLOR_ATTACHMENT3_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT4 = GLenum::GL_COLOR_ATTACHMENT4; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT4_EXT = GLenum::GL_COLOR_ATTACHMENT4_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT5 = GLenum::GL_COLOR_ATTACHMENT5; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT5_EXT = GLenum::GL_COLOR_ATTACHMENT5_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT6 = GLenum::GL_COLOR_ATTACHMENT6; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT6_EXT = GLenum::GL_COLOR_ATTACHMENT6_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT7 = GLenum::GL_COLOR_ATTACHMENT7; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT7_EXT = GLenum::GL_COLOR_ATTACHMENT7_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT8 = GLenum::GL_COLOR_ATTACHMENT8; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT8_EXT = GLenum::GL_COLOR_ATTACHMENT8_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT9 = GLenum::GL_COLOR_ATTACHMENT9; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT9_EXT = GLenum::GL_COLOR_ATTACHMENT9_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT10 = GLenum::GL_COLOR_ATTACHMENT10; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT10_EXT = GLenum::GL_COLOR_ATTACHMENT10_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT11 = GLenum::GL_COLOR_ATTACHMENT11; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT11_EXT = GLenum::GL_COLOR_ATTACHMENT11_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT12 = GLenum::GL_COLOR_ATTACHMENT12; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT12_EXT = GLenum::GL_COLOR_ATTACHMENT12_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT13 = GLenum::GL_COLOR_ATTACHMENT13; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT13_EXT = GLenum::GL_COLOR_ATTACHMENT13_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT14 = GLenum::GL_COLOR_ATTACHMENT14; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT14_EXT = GLenum::GL_COLOR_ATTACHMENT14_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT15 = GLenum::GL_COLOR_ATTACHMENT15; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT15_EXT = GLenum::GL_COLOR_ATTACHMENT15_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT16 = GLenum::GL_COLOR_ATTACHMENT16; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT17 = GLenum::GL_COLOR_ATTACHMENT17; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT18 = GLenum::GL_COLOR_ATTACHMENT18; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT19 = GLenum::GL_COLOR_ATTACHMENT19; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT20 = GLenum::GL_COLOR_ATTACHMENT20; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT21 = GLenum::GL_COLOR_ATTACHMENT21; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT22 = GLenum::GL_COLOR_ATTACHMENT22; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT23 = GLenum::GL_COLOR_ATTACHMENT23; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT24 = GLenum::GL_COLOR_ATTACHMENT24; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT25 = GLenum::GL_COLOR_ATTACHMENT25; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT26 = GLenum::GL_COLOR_ATTACHMENT26; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT27 = GLenum::GL_COLOR_ATTACHMENT27; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT28 = GLenum::GL_COLOR_ATTACHMENT28; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT29 = GLenum::GL_COLOR_ATTACHMENT29; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT30 = GLenum::GL_COLOR_ATTACHMENT30; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT31 = GLenum::GL_COLOR_ATTACHMENT31; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_ATTACHMENT = GLenum::GL_DEPTH_ATTACHMENT; // reuse FramebufferAttachment
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_ATTACHMENT_EXT = GLenum::GL_DEPTH_ATTACHMENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_ATTACHMENT_EXT = GLenum::GL_STENCIL_ATTACHMENT_EXT;

// LightEnvModeSGIX

// GLBINDING_CONSTEXPR static const GLenum GL_ADD = GLenum::GL_ADD; // reuse AccumOp
GLBINDING_CONSTEXPR static const GLenum GL_REPLACE = GLenum::GL_REPLACE;
GLBINDING_CONSTEXPR static const GLenum GL_MODULATE = GLenum::GL_MODULATE;

// LightEnvParameterSGIX

// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_ENV_MODE_SGIX = GLenum::GL_LIGHT_ENV_MODE_SGIX; // reuse GetPName

// LightModelColorControl

GLBINDING_CONSTEXPR static const GLenum GL_SINGLE_COLOR = GLenum::GL_SINGLE_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_SINGLE_COLOR_EXT = GLenum::GL_SINGLE_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SEPARATE_SPECULAR_COLOR = GLenum::GL_SEPARATE_SPECULAR_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_SEPARATE_SPECULAR_COLOR_EXT = GLenum::GL_SEPARATE_SPECULAR_COLOR_EXT;

// LightModelParameter

// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_LOCAL_VIEWER = GLenum::GL_LIGHT_MODEL_LOCAL_VIEWER; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_TWO_SIDE = GLenum::GL_LIGHT_MODEL_TWO_SIDE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_AMBIENT = GLenum::GL_LIGHT_MODEL_AMBIENT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_COLOR_CONTROL = GLenum::GL_LIGHT_MODEL_COLOR_CONTROL; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_COLOR_CONTROL_EXT = GLenum::GL_LIGHT_MODEL_COLOR_CONTROL_EXT;

// LightName

// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT0 = GLenum::GL_LIGHT0; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT1 = GLenum::GL_LIGHT1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT2 = GLenum::GL_LIGHT2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT3 = GLenum::GL_LIGHT3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT4 = GLenum::GL_LIGHT4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT5 = GLenum::GL_LIGHT5; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT6 = GLenum::GL_LIGHT6; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_LIGHT7 = GLenum::GL_LIGHT7; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT0_SGIX = GLenum::GL_FRAGMENT_LIGHT0_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT1_SGIX = GLenum::GL_FRAGMENT_LIGHT1_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT2_SGIX = GLenum::GL_FRAGMENT_LIGHT2_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT3_SGIX = GLenum::GL_FRAGMENT_LIGHT3_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT4_SGIX = GLenum::GL_FRAGMENT_LIGHT4_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT5_SGIX = GLenum::GL_FRAGMENT_LIGHT5_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT6_SGIX = GLenum::GL_FRAGMENT_LIGHT6_SGIX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_LIGHT7_SGIX = GLenum::GL_FRAGMENT_LIGHT7_SGIX; // reuse EnableCap

// LightParameter

// GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT = GLenum::GL_AMBIENT; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DIFFUSE = GLenum::GL_DIFFUSE; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_SPECULAR = GLenum::GL_SPECULAR; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_POSITION = GLenum::GL_POSITION; // reuse FragmentLightParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_SPOT_DIRECTION = GLenum::GL_SPOT_DIRECTION; // reuse FragmentLightParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_SPOT_EXPONENT = GLenum::GL_SPOT_EXPONENT; // reuse FragmentLightParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_SPOT_CUTOFF = GLenum::GL_SPOT_CUTOFF; // reuse FragmentLightParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_ATTENUATION = GLenum::GL_CONSTANT_ATTENUATION; // reuse FragmentLightParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_ATTENUATION = GLenum::GL_LINEAR_ATTENUATION; // reuse FragmentLightParameterSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_QUADRATIC_ATTENUATION = GLenum::GL_QUADRATIC_ATTENUATION; // reuse FragmentLightParameterSGIX

// LightTextureModeEXT

GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_MATERIAL_EXT = GLenum::GL_FRAGMENT_MATERIAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_NORMAL_EXT = GLenum::GL_FRAGMENT_NORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_COLOR_EXT = GLenum::GL_FRAGMENT_COLOR_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_DEPTH = GLenum::GL_FRAGMENT_DEPTH; // reuse FogCoordSrc
// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_DEPTH_EXT = GLenum::GL_FRAGMENT_DEPTH_EXT; // reuse FogCoordSrc

// LightTexturePNameEXT

GLBINDING_CONSTEXPR static const GLenum GL_ATTENUATION_EXT = GLenum::GL_ATTENUATION_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SHADOW_ATTENUATION_EXT = GLenum::GL_SHADOW_ATTENUATION_EXT;

// ListMode

GLBINDING_CONSTEXPR static const GLenum GL_COMPILE = GLenum::GL_COMPILE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPILE_AND_EXECUTE = GLenum::GL_COMPILE_AND_EXECUTE;

// ListNameType

// GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
GLBINDING_CONSTEXPR static const GLenum GL_2_BYTES = GLenum::GL_2_BYTES;
GLBINDING_CONSTEXPR static const GLenum GL_3_BYTES = GLenum::GL_3_BYTES;
GLBINDING_CONSTEXPR static const GLenum GL_4_BYTES = GLenum::GL_4_BYTES;

// ListParameterName

GLBINDING_CONSTEXPR static const GLenum GL_LIST_PRIORITY_SGIX = GLenum::GL_LIST_PRIORITY_SGIX;

// LogicOp

GLBINDING_CONSTEXPR static const GLenum GL_CLEAR = GLenum::GL_CLEAR;
GLBINDING_CONSTEXPR static const GLenum GL_AND = GLenum::GL_AND;
GLBINDING_CONSTEXPR static const GLenum GL_AND_REVERSE = GLenum::GL_AND_REVERSE;
GLBINDING_CONSTEXPR static const GLenum GL_COPY = GLenum::GL_COPY;
GLBINDING_CONSTEXPR static const GLenum GL_AND_INVERTED = GLenum::GL_AND_INVERTED;
GLBINDING_CONSTEXPR static const GLenum GL_NOOP = GLenum::GL_NOOP;
GLBINDING_CONSTEXPR static const GLenum GL_XOR = GLenum::GL_XOR;
GLBINDING_CONSTEXPR static const GLenum GL_OR = GLenum::GL_OR;
GLBINDING_CONSTEXPR static const GLenum GL_NOR = GLenum::GL_NOR;
GLBINDING_CONSTEXPR static const GLenum GL_EQUIV = GLenum::GL_EQUIV;
GLBINDING_CONSTEXPR static const GLenum GL_INVERT = GLenum::GL_INVERT;
GLBINDING_CONSTEXPR static const GLenum GL_OR_REVERSE = GLenum::GL_OR_REVERSE;
GLBINDING_CONSTEXPR static const GLenum GL_COPY_INVERTED = GLenum::GL_COPY_INVERTED;
GLBINDING_CONSTEXPR static const GLenum GL_OR_INVERTED = GLenum::GL_OR_INVERTED;
GLBINDING_CONSTEXPR static const GLenum GL_NAND = GLenum::GL_NAND;
GLBINDING_CONSTEXPR static const GLenum GL_SET = GLenum::GL_SET;

// MapAttribParameterNV

GLBINDING_CONSTEXPR static const GLenum GL_MAP_ATTRIB_U_ORDER_NV = GLenum::GL_MAP_ATTRIB_U_ORDER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP_ATTRIB_V_ORDER_NV = GLenum::GL_MAP_ATTRIB_V_ORDER_NV;

// MapParameterNV

GLBINDING_CONSTEXPR static const GLenum GL_MAP_TESSELLATION_NV = GLenum::GL_MAP_TESSELLATION_NV;

// MapQuery

// GLBINDING_CONSTEXPR static const GLenum GL_COEFF = GLenum::GL_COEFF; // reuse GetMapQuery
// GLBINDING_CONSTEXPR static const GLenum GL_ORDER = GLenum::GL_ORDER; // reuse GetMapQuery
// GLBINDING_CONSTEXPR static const GLenum GL_DOMAIN = GLenum::GL_DOMAIN; // reuse GetMapQuery

// MapTarget

// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_COLOR_4 = GLenum::GL_MAP1_COLOR_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_INDEX = GLenum::GL_MAP1_INDEX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_NORMAL = GLenum::GL_MAP1_NORMAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_1 = GLenum::GL_MAP1_TEXTURE_COORD_1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_2 = GLenum::GL_MAP1_TEXTURE_COORD_2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_3 = GLenum::GL_MAP1_TEXTURE_COORD_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TEXTURE_COORD_4 = GLenum::GL_MAP1_TEXTURE_COORD_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_3 = GLenum::GL_MAP1_VERTEX_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_4 = GLenum::GL_MAP1_VERTEX_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_COLOR_4 = GLenum::GL_MAP2_COLOR_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_INDEX = GLenum::GL_MAP2_INDEX; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_NORMAL = GLenum::GL_MAP2_NORMAL; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_1 = GLenum::GL_MAP2_TEXTURE_COORD_1; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_2 = GLenum::GL_MAP2_TEXTURE_COORD_2; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_3 = GLenum::GL_MAP2_TEXTURE_COORD_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TEXTURE_COORD_4 = GLenum::GL_MAP2_TEXTURE_COORD_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_3 = GLenum::GL_MAP2_VERTEX_3; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_4 = GLenum::GL_MAP2_VERTEX_4; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_DEFORMATION_SGIX = GLenum::GL_GEOMETRY_DEFORMATION_SGIX; // reuse FfdTargetSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEFORMATION_SGIX = GLenum::GL_TEXTURE_DEFORMATION_SGIX; // reuse FfdTargetSGIX

// MapTextureFormatINTEL

GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_DEFAULT_INTEL = GLenum::GL_LAYOUT_DEFAULT_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_LINEAR_INTEL = GLenum::GL_LAYOUT_LINEAR_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = GLenum::GL_LAYOUT_LINEAR_CPU_CACHED_INTEL;

// MapTypeNV

// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// MaterialParameter

// GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT = GLenum::GL_AMBIENT; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DIFFUSE = GLenum::GL_DIFFUSE; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_SPECULAR = GLenum::GL_SPECULAR; // reuse ColorMaterialParameter
// GLBINDING_CONSTEXPR static const GLenum GL_EMISSION = GLenum::GL_EMISSION; // reuse ColorMaterialParameter
GLBINDING_CONSTEXPR static const GLenum GL_SHININESS = GLenum::GL_SHININESS;
// GLBINDING_CONSTEXPR static const GLenum GL_AMBIENT_AND_DIFFUSE = GLenum::GL_AMBIENT_AND_DIFFUSE; // reuse ColorMaterialParameter
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEXES = GLenum::GL_COLOR_INDEXES;

// MatrixIndexPointerTypeARB

// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse AttributeType

// MatrixMode

GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW = GLenum::GL_MODELVIEW;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW0_EXT = GLenum::GL_MODELVIEW0_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROJECTION = GLenum::GL_PROJECTION;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE = GLenum::GL_TEXTURE;

// MemoryObjectParameterName

GLBINDING_CONSTEXPR static const GLenum GL_DEDICATED_MEMORY_OBJECT_EXT = GLenum::GL_DEDICATED_MEMORY_OBJECT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROTECTED_MEMORY_OBJECT_EXT = GLenum::GL_PROTECTED_MEMORY_OBJECT_EXT;

// MeshMode1

GLBINDING_CONSTEXPR static const GLenum GL_POINT = GLenum::GL_POINT;
GLBINDING_CONSTEXPR static const GLenum GL_LINE = GLenum::GL_LINE;

// MeshMode2

// GLBINDING_CONSTEXPR static const GLenum GL_POINT = GLenum::GL_POINT; // reuse MeshMode1
// GLBINDING_CONSTEXPR static const GLenum GL_LINE = GLenum::GL_LINE; // reuse MeshMode1
GLBINDING_CONSTEXPR static const GLenum GL_FILL = GLenum::GL_FILL;

// MinmaxTarget

GLBINDING_CONSTEXPR static const GLenum GL_MINMAX = GLenum::GL_MINMAX;

// MinmaxTargetEXT

// GLBINDING_CONSTEXPR static const GLenum GL_MINMAX = GLenum::GL_MINMAX; // reuse MinmaxTarget
// GLBINDING_CONSTEXPR static const GLenum GL_MINMAX_EXT = GLenum::GL_MINMAX_EXT; // reuse EnableCap

// NormalPointerType

// GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// ObjectIdentifier

// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE = GLenum::GL_TEXTURE; // reuse MatrixMode
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY = GLenum::GL_VERTEX_ARRAY; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER = GLenum::GL_BUFFER;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER = GLenum::GL_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM = GLenum::GL_PROGRAM;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY = GLenum::GL_QUERY;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_PIPELINE = GLenum::GL_PROGRAM_PIPELINE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER = GLenum::GL_SAMPLER;
// GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER = GLenum::GL_FRAMEBUFFER; // reuse FramebufferTarget
// GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER = GLenum::GL_RENDERBUFFER; // reuse CopyImageSubDataTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK = GLenum::GL_TRANSFORM_FEEDBACK; // reuse BindTransformFeedbackTarget

// ObjectTypeAPPLE

GLBINDING_CONSTEXPR static const GLenum GL_DRAW_PIXELS_APPLE = GLenum::GL_DRAW_PIXELS_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_FENCE_APPLE = GLenum::GL_FENCE_APPLE;

// OcclusionQueryParameterNameNV

GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_COUNT_NV = GLenum::GL_PIXEL_COUNT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_COUNT_AVAILABLE_NV = GLenum::GL_PIXEL_COUNT_AVAILABLE_NV;

// ParameterRangeEXT

GLBINDING_CONSTEXPR static const GLenum GL_NORMALIZED_RANGE_EXT = GLenum::GL_NORMALIZED_RANGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FULL_RANGE_EXT = GLenum::GL_FULL_RANGE_EXT;

// PatchParameterName

GLBINDING_CONSTEXPR static const GLenum GL_PATCH_VERTICES = GLenum::GL_PATCH_VERTICES;
GLBINDING_CONSTEXPR static const GLenum GL_PATCH_DEFAULT_INNER_LEVEL = GLenum::GL_PATCH_DEFAULT_INNER_LEVEL;
GLBINDING_CONSTEXPR static const GLenum GL_PATCH_DEFAULT_OUTER_LEVEL = GLenum::GL_PATCH_DEFAULT_OUTER_LEVEL;

// PathColor

// GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR_NV = GLenum::GL_PRIMARY_COLOR_NV; // reuse CombinerRegisterNV
// GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_NV = GLenum::GL_SECONDARY_COLOR_NV; // reuse CombinerRegisterNV
// GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR = GLenum::GL_PRIMARY_COLOR; // reuse FragmentShaderGenericSourceATI

// PathColorFormat

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA = GLenum::GL_ALPHA; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_RGB = GLenum::GL_RGB; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA = GLenum::GL_RGBA; // reuse InternalFormat
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE = GLenum::GL_LUMINANCE;
GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA = GLenum::GL_LUMINANCE_ALPHA;
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY = GLenum::GL_INTENSITY; // reuse InternalFormat

// PathCoordType

GLBINDING_CONSTEXPR static const GLenum GL_CLOSE_PATH_NV = GLenum::GL_CLOSE_PATH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MOVE_TO_NV = GLenum::GL_MOVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_MOVE_TO_NV = GLenum::GL_RELATIVE_MOVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_TO_NV = GLenum::GL_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_LINE_TO_NV = GLenum::GL_RELATIVE_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HORIZONTAL_LINE_TO_NV = GLenum::GL_HORIZONTAL_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_HORIZONTAL_LINE_TO_NV = GLenum::GL_RELATIVE_HORIZONTAL_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTICAL_LINE_TO_NV = GLenum::GL_VERTICAL_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_VERTICAL_LINE_TO_NV = GLenum::GL_RELATIVE_VERTICAL_LINE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_QUADRATIC_CURVE_TO_NV = GLenum::GL_QUADRATIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_QUADRATIC_CURVE_TO_NV = GLenum::GL_RELATIVE_QUADRATIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CUBIC_CURVE_TO_NV = GLenum::GL_CUBIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_CUBIC_CURVE_TO_NV = GLenum::GL_RELATIVE_CUBIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_QUADRATIC_CURVE_TO_NV = GLenum::GL_SMOOTH_QUADRATIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = GLenum::GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_CUBIC_CURVE_TO_NV = GLenum::GL_SMOOTH_CUBIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = GLenum::GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SMALL_CCW_ARC_TO_NV = GLenum::GL_SMALL_CCW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMALL_CCW_ARC_TO_NV = GLenum::GL_RELATIVE_SMALL_CCW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SMALL_CW_ARC_TO_NV = GLenum::GL_SMALL_CW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMALL_CW_ARC_TO_NV = GLenum::GL_RELATIVE_SMALL_CW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LARGE_CCW_ARC_TO_NV = GLenum::GL_LARGE_CCW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_LARGE_CCW_ARC_TO_NV = GLenum::GL_RELATIVE_LARGE_CCW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LARGE_CW_ARC_TO_NV = GLenum::GL_LARGE_CW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_LARGE_CW_ARC_TO_NV = GLenum::GL_RELATIVE_LARGE_CW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONIC_CURVE_TO_NV = GLenum::GL_CONIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_CONIC_CURVE_TO_NV = GLenum::GL_RELATIVE_CONIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ROUNDED_RECT_NV = GLenum::GL_ROUNDED_RECT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_ROUNDED_RECT_NV = GLenum::GL_RELATIVE_ROUNDED_RECT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ROUNDED_RECT2_NV = GLenum::GL_ROUNDED_RECT2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_ROUNDED_RECT2_NV = GLenum::GL_RELATIVE_ROUNDED_RECT2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ROUNDED_RECT4_NV = GLenum::GL_ROUNDED_RECT4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_ROUNDED_RECT4_NV = GLenum::GL_RELATIVE_ROUNDED_RECT4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ROUNDED_RECT8_NV = GLenum::GL_ROUNDED_RECT8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_ROUNDED_RECT8_NV = GLenum::GL_RELATIVE_ROUNDED_RECT8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RESTART_PATH_NV = GLenum::GL_RESTART_PATH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DUP_FIRST_CUBIC_CURVE_TO_NV = GLenum::GL_DUP_FIRST_CUBIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DUP_LAST_CUBIC_CURVE_TO_NV = GLenum::GL_DUP_LAST_CUBIC_CURVE_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RECT_NV = GLenum::GL_RECT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_RECT_NV = GLenum::GL_RELATIVE_RECT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CIRCULAR_CCW_ARC_TO_NV = GLenum::GL_CIRCULAR_CCW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CIRCULAR_CW_ARC_TO_NV = GLenum::GL_CIRCULAR_CW_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CIRCULAR_TANGENT_ARC_TO_NV = GLenum::GL_CIRCULAR_TANGENT_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ARC_TO_NV = GLenum::GL_ARC_TO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_ARC_TO_NV = GLenum::GL_RELATIVE_ARC_TO_NV;

// PathCoverMode

// GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_COVER_MODE_NV = GLenum::GL_PATH_FILL_COVER_MODE_NV; // reuse InstancedPathCoverMode
// GLBINDING_CONSTEXPR static const GLenum GL_CONVEX_HULL_NV = GLenum::GL_CONVEX_HULL_NV; // reuse InstancedPathCoverMode
// GLBINDING_CONSTEXPR static const GLenum GL_BOUNDING_BOX_NV = GLenum::GL_BOUNDING_BOX_NV; // reuse InstancedPathCoverMode

// PathElementType

GLBINDING_CONSTEXPR static const GLenum GL_UTF8_NV = GLenum::GL_UTF8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UTF16_NV = GLenum::GL_UTF16_NV;

// PathFillMode

// GLBINDING_CONSTEXPR static const GLenum GL_INVERT = GLenum::GL_INVERT; // reuse LogicOp
GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_MODE_NV = GLenum::GL_PATH_FILL_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COUNT_UP_NV = GLenum::GL_COUNT_UP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COUNT_DOWN_NV = GLenum::GL_COUNT_DOWN_NV;

// PathFontTarget

GLBINDING_CONSTEXPR static const GLenum GL_STANDARD_FONT_NAME_NV = GLenum::GL_STANDARD_FONT_NAME_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SYSTEM_FONT_NAME_NV = GLenum::GL_SYSTEM_FONT_NAME_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FILE_NAME_NV = GLenum::GL_FILE_NAME_NV;

// PathGenMode

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_EYE_LINEAR = GLenum::GL_EYE_LINEAR;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_LINEAR = GLenum::GL_OBJECT_LINEAR;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT = GLenum::GL_CONSTANT;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_OBJECT_BOUNDING_BOX_NV = GLenum::GL_PATH_OBJECT_BOUNDING_BOX_NV;

// PathHandleMissingGlyphs

GLBINDING_CONSTEXPR static const GLenum GL_SKIP_MISSING_GLYPH_NV = GLenum::GL_SKIP_MISSING_GLYPH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_USE_MISSING_GLYPH_NV = GLenum::GL_USE_MISSING_GLYPH_NV;

// PathListMode

GLBINDING_CONSTEXPR static const GLenum GL_ACCUM_ADJACENT_PAIRS_NV = GLenum::GL_ACCUM_ADJACENT_PAIRS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ADJACENT_PAIRS_NV = GLenum::GL_ADJACENT_PAIRS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FIRST_TO_REST_NV = GLenum::GL_FIRST_TO_REST_NV;

// PathParameter

GLBINDING_CONSTEXPR static const GLenum GL_PATH_STROKE_WIDTH_NV = GLenum::GL_PATH_STROKE_WIDTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_END_CAPS_NV = GLenum::GL_PATH_END_CAPS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_INITIAL_END_CAP_NV = GLenum::GL_PATH_INITIAL_END_CAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_TERMINAL_END_CAP_NV = GLenum::GL_PATH_TERMINAL_END_CAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_JOIN_STYLE_NV = GLenum::GL_PATH_JOIN_STYLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MITER_LIMIT_NV = GLenum::GL_PATH_MITER_LIMIT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_DASH_CAPS_NV = GLenum::GL_PATH_DASH_CAPS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_INITIAL_DASH_CAP_NV = GLenum::GL_PATH_INITIAL_DASH_CAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_TERMINAL_DASH_CAP_NV = GLenum::GL_PATH_TERMINAL_DASH_CAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_DASH_OFFSET_NV = GLenum::GL_PATH_DASH_OFFSET_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_CLIENT_LENGTH_NV = GLenum::GL_PATH_CLIENT_LENGTH_NV;
// GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_MODE_NV = GLenum::GL_PATH_FILL_MODE_NV; // reuse PathFillMode
GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_MASK_NV = GLenum::GL_PATH_FILL_MASK_NV;
// GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_COVER_MODE_NV = GLenum::GL_PATH_FILL_COVER_MODE_NV; // reuse InstancedPathCoverMode
GLBINDING_CONSTEXPR static const GLenum GL_PATH_STROKE_COVER_MODE_NV = GLenum::GL_PATH_STROKE_COVER_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_STROKE_MASK_NV = GLenum::GL_PATH_STROKE_MASK_NV;
// GLBINDING_CONSTEXPR static const GLenum GL_PATH_OBJECT_BOUNDING_BOX_NV = GLenum::GL_PATH_OBJECT_BOUNDING_BOX_NV; // reuse PathGenMode
GLBINDING_CONSTEXPR static const GLenum GL_PATH_COMMAND_COUNT_NV = GLenum::GL_PATH_COMMAND_COUNT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_COORD_COUNT_NV = GLenum::GL_PATH_COORD_COUNT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_DASH_ARRAY_COUNT_NV = GLenum::GL_PATH_DASH_ARRAY_COUNT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_COMPUTED_LENGTH_NV = GLenum::GL_PATH_COMPUTED_LENGTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_FILL_BOUNDING_BOX_NV = GLenum::GL_PATH_FILL_BOUNDING_BOX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_STROKE_BOUNDING_BOX_NV = GLenum::GL_PATH_STROKE_BOUNDING_BOX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_DASH_OFFSET_RESET_NV = GLenum::GL_PATH_DASH_OFFSET_RESET_NV;

// PathRenderingTokenNV

// GLBINDING_CONSTEXPR static const GLenum GL_CLOSE_PATH_NV = GLenum::GL_CLOSE_PATH_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_MOVE_TO_NV = GLenum::GL_MOVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_MOVE_TO_NV = GLenum::GL_RELATIVE_MOVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_LINE_TO_NV = GLenum::GL_LINE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_LINE_TO_NV = GLenum::GL_RELATIVE_LINE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_HORIZONTAL_LINE_TO_NV = GLenum::GL_HORIZONTAL_LINE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_HORIZONTAL_LINE_TO_NV = GLenum::GL_RELATIVE_HORIZONTAL_LINE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_VERTICAL_LINE_TO_NV = GLenum::GL_VERTICAL_LINE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_VERTICAL_LINE_TO_NV = GLenum::GL_RELATIVE_VERTICAL_LINE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_QUADRATIC_CURVE_TO_NV = GLenum::GL_QUADRATIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_QUADRATIC_CURVE_TO_NV = GLenum::GL_RELATIVE_QUADRATIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_CUBIC_CURVE_TO_NV = GLenum::GL_CUBIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_CUBIC_CURVE_TO_NV = GLenum::GL_RELATIVE_CUBIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_QUADRATIC_CURVE_TO_NV = GLenum::GL_SMOOTH_QUADRATIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = GLenum::GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH_CUBIC_CURVE_TO_NV = GLenum::GL_SMOOTH_CUBIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = GLenum::GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_SMALL_CCW_ARC_TO_NV = GLenum::GL_SMALL_CCW_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMALL_CCW_ARC_TO_NV = GLenum::GL_RELATIVE_SMALL_CCW_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_SMALL_CW_ARC_TO_NV = GLenum::GL_SMALL_CW_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_SMALL_CW_ARC_TO_NV = GLenum::GL_RELATIVE_SMALL_CW_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_LARGE_CCW_ARC_TO_NV = GLenum::GL_LARGE_CCW_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_LARGE_CCW_ARC_TO_NV = GLenum::GL_RELATIVE_LARGE_CCW_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_LARGE_CW_ARC_TO_NV = GLenum::GL_LARGE_CW_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_LARGE_CW_ARC_TO_NV = GLenum::GL_RELATIVE_LARGE_CW_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_CONIC_CURVE_TO_NV = GLenum::GL_CONIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_CONIC_CURVE_TO_NV = GLenum::GL_RELATIVE_CONIC_CURVE_TO_NV; // reuse PathCoordType
GLBINDING_CONSTEXPR static const GLenum GL_SHARED_EDGE_NV = GLenum::GL_SHARED_EDGE_NV;
// GLBINDING_CONSTEXPR static const GLenum GL_ROUNDED_RECT_NV = GLenum::GL_ROUNDED_RECT_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_ROUNDED_RECT_NV = GLenum::GL_RELATIVE_ROUNDED_RECT_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_ROUNDED_RECT2_NV = GLenum::GL_ROUNDED_RECT2_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_ROUNDED_RECT2_NV = GLenum::GL_RELATIVE_ROUNDED_RECT2_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_ROUNDED_RECT4_NV = GLenum::GL_ROUNDED_RECT4_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_ROUNDED_RECT4_NV = GLenum::GL_RELATIVE_ROUNDED_RECT4_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_ROUNDED_RECT8_NV = GLenum::GL_ROUNDED_RECT8_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_ROUNDED_RECT8_NV = GLenum::GL_RELATIVE_ROUNDED_RECT8_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RESTART_PATH_NV = GLenum::GL_RESTART_PATH_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_DUP_FIRST_CUBIC_CURVE_TO_NV = GLenum::GL_DUP_FIRST_CUBIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_DUP_LAST_CUBIC_CURVE_TO_NV = GLenum::GL_DUP_LAST_CUBIC_CURVE_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RECT_NV = GLenum::GL_RECT_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_RECT_NV = GLenum::GL_RELATIVE_RECT_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_CIRCULAR_CCW_ARC_TO_NV = GLenum::GL_CIRCULAR_CCW_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_CIRCULAR_CW_ARC_TO_NV = GLenum::GL_CIRCULAR_CW_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_CIRCULAR_TANGENT_ARC_TO_NV = GLenum::GL_CIRCULAR_TANGENT_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_ARC_TO_NV = GLenum::GL_ARC_TO_NV; // reuse PathCoordType
// GLBINDING_CONSTEXPR static const GLenum GL_RELATIVE_ARC_TO_NV = GLenum::GL_RELATIVE_ARC_TO_NV; // reuse PathCoordType

// PathStringFormat

GLBINDING_CONSTEXPR static const GLenum GL_PATH_FORMAT_SVG_NV = GLenum::GL_PATH_FORMAT_SVG_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_FORMAT_PS_NV = GLenum::GL_PATH_FORMAT_PS_NV;

// PathTransformType

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_TRANSLATE_X_NV = GLenum::GL_TRANSLATE_X_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSLATE_Y_NV = GLenum::GL_TRANSLATE_Y_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSLATE_2D_NV = GLenum::GL_TRANSLATE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSLATE_3D_NV = GLenum::GL_TRANSLATE_3D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_AFFINE_2D_NV = GLenum::GL_AFFINE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_AFFINE_3D_NV = GLenum::GL_AFFINE_3D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_AFFINE_2D_NV = GLenum::GL_TRANSPOSE_AFFINE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_AFFINE_3D_NV = GLenum::GL_TRANSPOSE_AFFINE_3D_NV;

// PerfQueryDataFlags

GLBINDING_CONSTEXPR static const GLenum GL_PERFQUERY_DONOT_FLUSH_INTEL = GLenum::GL_PERFQUERY_DONOT_FLUSH_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_PERFQUERY_FLUSH_INTEL = GLenum::GL_PERFQUERY_FLUSH_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_PERFQUERY_WAIT_INTEL = GLenum::GL_PERFQUERY_WAIT_INTEL;

// PipelineParameterName

GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_PROGRAM = GLenum::GL_ACTIVE_PROGRAM;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER = GLenum::GL_FRAGMENT_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER = GLenum::GL_VERTEX_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_INFO_LOG_LENGTH = GLenum::GL_INFO_LOG_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER = GLenum::GL_GEOMETRY_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SHADER = GLenum::GL_TESS_EVALUATION_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SHADER = GLenum::GL_TESS_CONTROL_SHADER;

// PixelCopyType

// GLBINDING_CONSTEXPR static const GLenum GL_COLOR = GLenum::GL_COLOR; // reuse Buffer
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH = GLenum::GL_DEPTH; // reuse Buffer
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL = GLenum::GL_STENCIL; // reuse Buffer

// PixelDataRangeTargetNV

GLBINDING_CONSTEXPR static const GLenum GL_WRITE_PIXEL_DATA_RANGE_NV = GLenum::GL_WRITE_PIXEL_DATA_RANGE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_READ_PIXEL_DATA_RANGE_NV = GLenum::GL_READ_PIXEL_DATA_RANGE_NV;

// PixelFormat

// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse AttributeType
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX = GLenum::GL_COLOR_INDEX;
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX = GLenum::GL_STENCIL_INDEX; // reuse DepthStencilTextureMode
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT = GLenum::GL_DEPTH_COMPONENT; // reuse DepthStencilTextureMode
// GLBINDING_CONSTEXPR static const GLenum GL_RED = GLenum::GL_RED; // reuse FragmentShaderValueRepATI
// GLBINDING_CONSTEXPR static const GLenum GL_GREEN = GLenum::GL_GREEN; // reuse FragmentShaderValueRepATI
// GLBINDING_CONSTEXPR static const GLenum GL_BLUE = GLenum::GL_BLUE; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA = GLenum::GL_ALPHA; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_RGB = GLenum::GL_RGB; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA = GLenum::GL_RGBA; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE = GLenum::GL_LUMINANCE; // reuse PathColorFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA = GLenum::GL_LUMINANCE_ALPHA; // reuse PathColorFormat
GLBINDING_CONSTEXPR static const GLenum GL_ABGR_EXT = GLenum::GL_ABGR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CMYK_EXT = GLenum::GL_CMYK_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CMYKA_EXT = GLenum::GL_CMYKA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BGR = GLenum::GL_BGR;
GLBINDING_CONSTEXPR static const GLenum GL_BGR_EXT = GLenum::GL_BGR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BGRA = GLenum::GL_BGRA;
GLBINDING_CONSTEXPR static const GLenum GL_BGRA_EXT = GLenum::GL_BGRA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_YCRCB_422_SGIX = GLenum::GL_YCRCB_422_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_YCRCB_444_SGIX = GLenum::GL_YCRCB_444_SGIX;
// GLBINDING_CONSTEXPR static const GLenum GL_RG = GLenum::GL_RG; // reuse InternalFormat
GLBINDING_CONSTEXPR static const GLenum GL_RG_INTEGER = GLenum::GL_RG_INTEGER;
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL = GLenum::GL_DEPTH_STENCIL; // reuse InternalFormat
GLBINDING_CONSTEXPR static const GLenum GL_RED_INTEGER = GLenum::GL_RED_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_INTEGER = GLenum::GL_GREEN_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_INTEGER = GLenum::GL_BLUE_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_INTEGER = GLenum::GL_RGB_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_INTEGER = GLenum::GL_RGBA_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_BGR_INTEGER = GLenum::GL_BGR_INTEGER;
GLBINDING_CONSTEXPR static const GLenum GL_BGRA_INTEGER = GLenum::GL_BGRA_INTEGER;

// PixelMap

GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_I = GLenum::GL_PIXEL_MAP_I_TO_I;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_S_TO_S = GLenum::GL_PIXEL_MAP_S_TO_S;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_R = GLenum::GL_PIXEL_MAP_I_TO_R;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_G = GLenum::GL_PIXEL_MAP_I_TO_G;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_B = GLenum::GL_PIXEL_MAP_I_TO_B;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_I_TO_A = GLenum::GL_PIXEL_MAP_I_TO_A;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_R_TO_R = GLenum::GL_PIXEL_MAP_R_TO_R;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_G_TO_G = GLenum::GL_PIXEL_MAP_G_TO_G;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_B_TO_B = GLenum::GL_PIXEL_MAP_B_TO_B;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAP_A_TO_A = GLenum::GL_PIXEL_MAP_A_TO_A;

// PixelStoreParameter

// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SWAP_BYTES = GLenum::GL_UNPACK_SWAP_BYTES; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_LSB_FIRST = GLenum::GL_UNPACK_LSB_FIRST; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_ROW_LENGTH = GLenum::GL_UNPACK_ROW_LENGTH; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_ROWS = GLenum::GL_UNPACK_SKIP_ROWS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_PIXELS = GLenum::GL_UNPACK_SKIP_PIXELS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_ALIGNMENT = GLenum::GL_UNPACK_ALIGNMENT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SWAP_BYTES = GLenum::GL_PACK_SWAP_BYTES; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_LSB_FIRST = GLenum::GL_PACK_LSB_FIRST; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_ROW_LENGTH = GLenum::GL_PACK_ROW_LENGTH; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_ROWS = GLenum::GL_PACK_SKIP_ROWS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_PIXELS = GLenum::GL_PACK_SKIP_PIXELS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_ALIGNMENT = GLenum::GL_PACK_ALIGNMENT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_IMAGES = GLenum::GL_PACK_SKIP_IMAGES; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_IMAGES_EXT = GLenum::GL_PACK_SKIP_IMAGES_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_HEIGHT = GLenum::GL_PACK_IMAGE_HEIGHT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_HEIGHT_EXT = GLenum::GL_PACK_IMAGE_HEIGHT_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_IMAGES = GLenum::GL_UNPACK_SKIP_IMAGES; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_IMAGES_EXT = GLenum::GL_UNPACK_SKIP_IMAGES_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_HEIGHT = GLenum::GL_UNPACK_IMAGE_HEIGHT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_HEIGHT_EXT = GLenum::GL_UNPACK_IMAGE_HEIGHT_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SKIP_VOLUMES_SGIS = GLenum::GL_PACK_SKIP_VOLUMES_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_IMAGE_DEPTH_SGIS = GLenum::GL_PACK_IMAGE_DEPTH_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SKIP_VOLUMES_SGIS = GLenum::GL_UNPACK_SKIP_VOLUMES_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_IMAGE_DEPTH_SGIS = GLenum::GL_UNPACK_IMAGE_DEPTH_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_WIDTH_SGIX = GLenum::GL_PIXEL_TILE_WIDTH_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_HEIGHT_SGIX = GLenum::GL_PIXEL_TILE_HEIGHT_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_WIDTH_SGIX = GLenum::GL_PIXEL_TILE_GRID_WIDTH_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_HEIGHT_SGIX = GLenum::GL_PIXEL_TILE_GRID_HEIGHT_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_GRID_DEPTH_SGIX = GLenum::GL_PIXEL_TILE_GRID_DEPTH_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TILE_CACHE_SIZE_SGIX = GLenum::GL_PIXEL_TILE_CACHE_SIZE_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_RESAMPLE_SGIX = GLenum::GL_PACK_RESAMPLE_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_RESAMPLE_SGIX = GLenum::GL_UNPACK_RESAMPLE_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_PACK_SUBSAMPLE_RATE_SGIX = GLenum::GL_PACK_SUBSAMPLE_RATE_SGIX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_SUBSAMPLE_RATE_SGIX = GLenum::GL_UNPACK_SUBSAMPLE_RATE_SGIX; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_PACK_RESAMPLE_OML = GLenum::GL_PACK_RESAMPLE_OML;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_RESAMPLE_OML = GLenum::GL_UNPACK_RESAMPLE_OML;

// PixelStoreResampleMode

GLBINDING_CONSTEXPR static const GLenum GL_RESAMPLE_DECIMATE_SGIX = GLenum::GL_RESAMPLE_DECIMATE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_RESAMPLE_REPLICATE_SGIX = GLenum::GL_RESAMPLE_REPLICATE_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_RESAMPLE_ZERO_FILL_SGIX = GLenum::GL_RESAMPLE_ZERO_FILL_SGIX;

// PixelStoreSubsampleRate

GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_SUBSAMPLE_4444_SGIX = GLenum::GL_PIXEL_SUBSAMPLE_4444_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_SUBSAMPLE_2424_SGIX = GLenum::GL_PIXEL_SUBSAMPLE_2424_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_SUBSAMPLE_4242_SGIX = GLenum::GL_PIXEL_SUBSAMPLE_4242_SGIX;

// PixelTexGenModeSGIX

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA = GLenum::GL_ALPHA; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_RGB = GLenum::GL_RGB; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA = GLenum::GL_RGBA; // reuse InternalFormat

// PixelTexGenParameterNameSGIS

GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = GLenum::GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = GLenum::GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS;

// PixelTransferParameter

// GLBINDING_CONSTEXPR static const GLenum GL_MAP_COLOR = GLenum::GL_MAP_COLOR; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_MAP_STENCIL = GLenum::GL_MAP_STENCIL; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_INDEX_SHIFT = GLenum::GL_INDEX_SHIFT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_INDEX_OFFSET = GLenum::GL_INDEX_OFFSET; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_RED_SCALE = GLenum::GL_RED_SCALE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_RED_BIAS = GLenum::GL_RED_BIAS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_GREEN_SCALE = GLenum::GL_GREEN_SCALE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_GREEN_BIAS = GLenum::GL_GREEN_BIAS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_BLUE_SCALE = GLenum::GL_BLUE_SCALE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_BLUE_BIAS = GLenum::GL_BLUE_BIAS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_SCALE = GLenum::GL_ALPHA_SCALE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_BIAS = GLenum::GL_ALPHA_BIAS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_SCALE = GLenum::GL_DEPTH_SCALE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_BIAS = GLenum::GL_DEPTH_BIAS; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_SCALE = GLenum::GL_POST_CONVOLUTION_RED_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_RED_SCALE_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_SCALE = GLenum::GL_POST_CONVOLUTION_GREEN_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_GREEN_SCALE_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_SCALE = GLenum::GL_POST_CONVOLUTION_BLUE_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_BLUE_SCALE_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_SCALE = GLenum::GL_POST_CONVOLUTION_ALPHA_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = GLenum::GL_POST_CONVOLUTION_ALPHA_SCALE_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_BIAS = GLenum::GL_POST_CONVOLUTION_RED_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_RED_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_RED_BIAS_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_BIAS = GLenum::GL_POST_CONVOLUTION_GREEN_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_GREEN_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_GREEN_BIAS_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_BIAS = GLenum::GL_POST_CONVOLUTION_BLUE_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_BLUE_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_BLUE_BIAS_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_BIAS = GLenum::GL_POST_CONVOLUTION_ALPHA_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = GLenum::GL_POST_CONVOLUTION_ALPHA_BIAS_EXT; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_SCALE = GLenum::GL_POST_COLOR_MATRIX_RED_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_RED_SCALE_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_SCALE = GLenum::GL_POST_COLOR_MATRIX_GREEN_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_SCALE = GLenum::GL_POST_COLOR_MATRIX_BLUE_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_SCALE = GLenum::GL_POST_COLOR_MATRIX_ALPHA_SCALE;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = GLenum::GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_BIAS = GLenum::GL_POST_COLOR_MATRIX_RED_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_RED_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_RED_BIAS_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_BIAS = GLenum::GL_POST_COLOR_MATRIX_GREEN_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_BIAS = GLenum::GL_POST_COLOR_MATRIX_BLUE_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_BIAS = GLenum::GL_POST_COLOR_MATRIX_ALPHA_BIAS;
// GLBINDING_CONSTEXPR static const GLenum GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = GLenum::GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI; // reuse GetPName

// PixelTransformPNameEXT

GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MAG_FILTER_EXT = GLenum::GL_PIXEL_MAG_FILTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_MIN_FILTER_EXT = GLenum::GL_PIXEL_MIN_FILTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_CUBIC_WEIGHT_EXT = GLenum::GL_PIXEL_CUBIC_WEIGHT_EXT;

// PixelTransformTargetEXT

GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TRANSFORM_2D_EXT = GLenum::GL_PIXEL_TRANSFORM_2D_EXT;

// PixelType

// GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
GLBINDING_CONSTEXPR static const GLenum GL_HALF_FLOAT = GLenum::GL_HALF_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_HALF_FLOAT_ARB = GLenum::GL_HALF_FLOAT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_HALF_FLOAT_NV = GLenum::GL_HALF_FLOAT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HALF_APPLE = GLenum::GL_HALF_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_BITMAP = GLenum::GL_BITMAP;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE_3_3_2 = GLenum::GL_UNSIGNED_BYTE_3_3_2;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE_3_3_2_EXT = GLenum::GL_UNSIGNED_BYTE_3_3_2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_4_4_4_4 = GLenum::GL_UNSIGNED_SHORT_4_4_4_4;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_4_4_4_4_EXT = GLenum::GL_UNSIGNED_SHORT_4_4_4_4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_5_5_5_1 = GLenum::GL_UNSIGNED_SHORT_5_5_5_1;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_5_5_5_1_EXT = GLenum::GL_UNSIGNED_SHORT_5_5_5_1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_8_8_8_8 = GLenum::GL_UNSIGNED_INT_8_8_8_8;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_8_8_8_8_EXT = GLenum::GL_UNSIGNED_INT_8_8_8_8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_10_10_10_2 = GLenum::GL_UNSIGNED_INT_10_10_10_2;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_10_10_10_2_EXT = GLenum::GL_UNSIGNED_INT_10_10_10_2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE_2_3_3_REV = GLenum::GL_UNSIGNED_BYTE_2_3_3_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_5_6_5 = GLenum::GL_UNSIGNED_SHORT_5_6_5;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_5_6_5_REV = GLenum::GL_UNSIGNED_SHORT_5_6_5_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_4_4_4_4_REV = GLenum::GL_UNSIGNED_SHORT_4_4_4_4_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_1_5_5_5_REV = GLenum::GL_UNSIGNED_SHORT_1_5_5_5_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_8_8_8_8_REV = GLenum::GL_UNSIGNED_INT_8_8_8_8_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_2_10_10_10_REV = GLenum::GL_UNSIGNED_INT_2_10_10_10_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_24_8 = GLenum::GL_UNSIGNED_INT_24_8;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_24_8_EXT = GLenum::GL_UNSIGNED_INT_24_8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_24_8_NV = GLenum::GL_UNSIGNED_INT_24_8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_10F_11F_11F_REV = GLenum::GL_UNSIGNED_INT_10F_11F_11F_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_10F_11F_11F_REV_EXT = GLenum::GL_UNSIGNED_INT_10F_11F_11F_REV_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_5_9_9_9_REV = GLenum::GL_UNSIGNED_INT_5_9_9_9_REV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_5_9_9_9_REV_EXT = GLenum::GL_UNSIGNED_INT_5_9_9_9_REV_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_32_UNSIGNED_INT_24_8_REV = GLenum::GL_FLOAT_32_UNSIGNED_INT_24_8_REV;
GLBINDING_CONSTEXPR static const GLenum GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV = GLenum::GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV;

// PNTrianglesPNameATI

GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_POINT_MODE_ATI = GLenum::GL_PN_TRIANGLES_POINT_MODE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_NORMAL_MODE_ATI = GLenum::GL_PN_TRIANGLES_NORMAL_MODE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI = GLenum::GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI;

// PointParameterNameARB

// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN = GLenum::GL_POINT_SIZE_MIN; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN_ARB = GLenum::GL_POINT_SIZE_MIN_ARB; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN_EXT = GLenum::GL_POINT_SIZE_MIN_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MIN_SGIS = GLenum::GL_POINT_SIZE_MIN_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX = GLenum::GL_POINT_SIZE_MAX; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX_ARB = GLenum::GL_POINT_SIZE_MAX_ARB; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX_EXT = GLenum::GL_POINT_SIZE_MAX_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_SIZE_MAX_SGIS = GLenum::GL_POINT_SIZE_MAX_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE = GLenum::GL_POINT_FADE_THRESHOLD_SIZE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE_ARB = GLenum::GL_POINT_FADE_THRESHOLD_SIZE_ARB; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE_EXT = GLenum::GL_POINT_FADE_THRESHOLD_SIZE_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_FADE_THRESHOLD_SIZE_SGIS = GLenum::GL_POINT_FADE_THRESHOLD_SIZE_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_DISTANCE_ATTENUATION_EXT = GLenum::GL_DISTANCE_ATTENUATION_EXT; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_DISTANCE_ATTENUATION_SGIS = GLenum::GL_DISTANCE_ATTENUATION_SGIS; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_DISTANCE_ATTENUATION = GLenum::GL_POINT_DISTANCE_ATTENUATION; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_POINT_DISTANCE_ATTENUATION_ARB = GLenum::GL_POINT_DISTANCE_ATTENUATION_ARB; // reuse GetPName

// PolygonMode

// GLBINDING_CONSTEXPR static const GLenum GL_POINT = GLenum::GL_POINT; // reuse MeshMode1
// GLBINDING_CONSTEXPR static const GLenum GL_LINE = GLenum::GL_LINE; // reuse MeshMode1
// GLBINDING_CONSTEXPR static const GLenum GL_FILL = GLenum::GL_FILL; // reuse MeshMode2

// PrecisionType

GLBINDING_CONSTEXPR static const GLenum GL_LOW_FLOAT = GLenum::GL_LOW_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_MEDIUM_FLOAT = GLenum::GL_MEDIUM_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_HIGH_FLOAT = GLenum::GL_HIGH_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_LOW_INT = GLenum::GL_LOW_INT;
GLBINDING_CONSTEXPR static const GLenum GL_MEDIUM_INT = GLenum::GL_MEDIUM_INT;
GLBINDING_CONSTEXPR static const GLenum GL_HIGH_INT = GLenum::GL_HIGH_INT;

// PreserveModeATI

GLBINDING_CONSTEXPR static const GLenum GL_PRESERVE_ATI = GLenum::GL_PRESERVE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DISCARD_ATI = GLenum::GL_DISCARD_ATI;

// PrimitiveType

GLBINDING_CONSTEXPR static const GLenum GL_POINTS = GLenum::GL_POINTS;
GLBINDING_CONSTEXPR static const GLenum GL_LINES = GLenum::GL_LINES;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_LOOP = GLenum::GL_LINE_LOOP;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STRIP = GLenum::GL_LINE_STRIP;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLES = GLenum::GL_TRIANGLES;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_STRIP = GLenum::GL_TRIANGLE_STRIP;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_FAN = GLenum::GL_TRIANGLE_FAN;
GLBINDING_CONSTEXPR static const GLenum GL_QUADS = GLenum::GL_QUADS;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_STRIP = GLenum::GL_QUAD_STRIP;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON = GLenum::GL_POLYGON;
GLBINDING_CONSTEXPR static const GLenum GL_LINES_ADJACENCY = GLenum::GL_LINES_ADJACENCY;
GLBINDING_CONSTEXPR static const GLenum GL_LINES_ADJACENCY_ARB = GLenum::GL_LINES_ADJACENCY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_LINES_ADJACENCY_EXT = GLenum::GL_LINES_ADJACENCY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STRIP_ADJACENCY = GLenum::GL_LINE_STRIP_ADJACENCY;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STRIP_ADJACENCY_ARB = GLenum::GL_LINE_STRIP_ADJACENCY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_LINE_STRIP_ADJACENCY_EXT = GLenum::GL_LINE_STRIP_ADJACENCY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLES_ADJACENCY = GLenum::GL_TRIANGLES_ADJACENCY;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLES_ADJACENCY_ARB = GLenum::GL_TRIANGLES_ADJACENCY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLES_ADJACENCY_EXT = GLenum::GL_TRIANGLES_ADJACENCY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_STRIP_ADJACENCY = GLenum::GL_TRIANGLE_STRIP_ADJACENCY;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_STRIP_ADJACENCY_ARB = GLenum::GL_TRIANGLE_STRIP_ADJACENCY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_STRIP_ADJACENCY_EXT = GLenum::GL_TRIANGLE_STRIP_ADJACENCY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PATCHES = GLenum::GL_PATCHES;

// ProgramFormat

GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_FORMAT_ASCII_ARB = GLenum::GL_PROGRAM_FORMAT_ASCII_ARB;

// ProgramInterface

// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER; // reuse BufferStorageTarget
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM = GLenum::GL_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_BLOCK = GLenum::GL_UNIFORM_BLOCK;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_INPUT = GLenum::GL_PROGRAM_INPUT;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_OUTPUT = GLenum::GL_PROGRAM_OUTPUT;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_VARIABLE = GLenum::GL_BUFFER_VARIABLE;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_STORAGE_BLOCK = GLenum::GL_SHADER_STORAGE_BLOCK;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SUBROUTINE = GLenum::GL_VERTEX_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SUBROUTINE = GLenum::GL_TESS_CONTROL_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SUBROUTINE = GLenum::GL_TESS_EVALUATION_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SUBROUTINE = GLenum::GL_GEOMETRY_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SUBROUTINE = GLenum::GL_FRAGMENT_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_SUBROUTINE = GLenum::GL_COMPUTE_SUBROUTINE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SUBROUTINE_UNIFORM = GLenum::GL_VERTEX_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SUBROUTINE_UNIFORM = GLenum::GL_TESS_CONTROL_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = GLenum::GL_TESS_EVALUATION_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SUBROUTINE_UNIFORM = GLenum::GL_GEOMETRY_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SUBROUTINE_UNIFORM = GLenum::GL_FRAGMENT_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_SUBROUTINE_UNIFORM = GLenum::GL_COMPUTE_SUBROUTINE_UNIFORM;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_VARYING = GLenum::GL_TRANSFORM_FEEDBACK_VARYING;

// ProgramInterfacePName

GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_RESOURCES = GLenum::GL_ACTIVE_RESOURCES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_NAME_LENGTH = GLenum::GL_MAX_NAME_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_NUM_ACTIVE_VARIABLES = GLenum::GL_MAX_NUM_ACTIVE_VARIABLES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_NUM_COMPATIBLE_SUBROUTINES = GLenum::GL_MAX_NUM_COMPATIBLE_SUBROUTINES;

// ProgramParameterPName

// GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINARY_RETRIEVABLE_HINT = GLenum::GL_PROGRAM_BINARY_RETRIEVABLE_HINT; // reuse HintTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_SEPARABLE = GLenum::GL_PROGRAM_SEPARABLE;

// ProgramPropertyARB

GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_WORK_GROUP_SIZE = GLenum::GL_COMPUTE_WORK_GROUP_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINARY_LENGTH = GLenum::GL_PROGRAM_BINARY_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_VERTICES_OUT = GLenum::GL_GEOMETRY_VERTICES_OUT;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_INPUT_TYPE = GLenum::GL_GEOMETRY_INPUT_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_OUTPUT_TYPE = GLenum::GL_GEOMETRY_OUTPUT_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = GLenum::GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_UNIFORM_BLOCKS = GLenum::GL_ACTIVE_UNIFORM_BLOCKS;
GLBINDING_CONSTEXPR static const GLenum GL_DELETE_STATUS = GLenum::GL_DELETE_STATUS;
GLBINDING_CONSTEXPR static const GLenum GL_LINK_STATUS = GLenum::GL_LINK_STATUS;
GLBINDING_CONSTEXPR static const GLenum GL_VALIDATE_STATUS = GLenum::GL_VALIDATE_STATUS;
// GLBINDING_CONSTEXPR static const GLenum GL_INFO_LOG_LENGTH = GLenum::GL_INFO_LOG_LENGTH; // reuse PipelineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_ATTACHED_SHADERS = GLenum::GL_ATTACHED_SHADERS;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_UNIFORMS = GLenum::GL_ACTIVE_UNIFORMS;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_UNIFORM_MAX_LENGTH = GLenum::GL_ACTIVE_UNIFORM_MAX_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_ATTRIBUTES = GLenum::GL_ACTIVE_ATTRIBUTES;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = GLenum::GL_ACTIVE_ATTRIBUTE_MAX_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = GLenum::GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_MODE = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_VARYINGS = GLenum::GL_TRANSFORM_FEEDBACK_VARYINGS;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = GLenum::GL_ACTIVE_ATOMIC_COUNTER_BUFFERS;

// ProgramResourceProperty

GLBINDING_CONSTEXPR static const GLenum GL_NUM_COMPATIBLE_SUBROUTINES = GLenum::GL_NUM_COMPATIBLE_SUBROUTINES;
GLBINDING_CONSTEXPR static const GLenum GL_COMPATIBLE_SUBROUTINES = GLenum::GL_COMPATIBLE_SUBROUTINES;
// GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM = GLenum::GL_UNIFORM; // reuse ProgramInterface
GLBINDING_CONSTEXPR static const GLenum GL_IS_PER_PATCH = GLenum::GL_IS_PER_PATCH;
GLBINDING_CONSTEXPR static const GLenum GL_NAME_LENGTH = GLenum::GL_NAME_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_TYPE = GLenum::GL_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_SIZE = GLenum::GL_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET = GLenum::GL_OFFSET;
GLBINDING_CONSTEXPR static const GLenum GL_BLOCK_INDEX = GLenum::GL_BLOCK_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_STRIDE = GLenum::GL_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX_STRIDE = GLenum::GL_MATRIX_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_IS_ROW_MAJOR = GLenum::GL_IS_ROW_MAJOR;
GLBINDING_CONSTEXPR static const GLenum GL_ATOMIC_COUNTER_BUFFER_INDEX = GLenum::GL_ATOMIC_COUNTER_BUFFER_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_BINDING = GLenum::GL_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_DATA_SIZE = GLenum::GL_BUFFER_DATA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_ACTIVE_VARIABLES = GLenum::GL_NUM_ACTIVE_VARIABLES;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_VARIABLES = GLenum::GL_ACTIVE_VARIABLES;
GLBINDING_CONSTEXPR static const GLenum GL_REFERENCED_BY_VERTEX_SHADER = GLenum::GL_REFERENCED_BY_VERTEX_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_REFERENCED_BY_TESS_CONTROL_SHADER = GLenum::GL_REFERENCED_BY_TESS_CONTROL_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_REFERENCED_BY_TESS_EVALUATION_SHADER = GLenum::GL_REFERENCED_BY_TESS_EVALUATION_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_REFERENCED_BY_GEOMETRY_SHADER = GLenum::GL_REFERENCED_BY_GEOMETRY_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_REFERENCED_BY_FRAGMENT_SHADER = GLenum::GL_REFERENCED_BY_FRAGMENT_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_REFERENCED_BY_COMPUTE_SHADER = GLenum::GL_REFERENCED_BY_COMPUTE_SHADER;
GLBINDING_CONSTEXPR static const GLenum GL_TOP_LEVEL_ARRAY_SIZE = GLenum::GL_TOP_LEVEL_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TOP_LEVEL_ARRAY_STRIDE = GLenum::GL_TOP_LEVEL_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_LOCATION = GLenum::GL_LOCATION;
GLBINDING_CONSTEXPR static const GLenum GL_LOCATION_INDEX = GLenum::GL_LOCATION_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_LOCATION_COMPONENT = GLenum::GL_LOCATION_COMPONENT;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_INDEX = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE;

// ProgramStagePName

GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_SUBROUTINES = GLenum::GL_ACTIVE_SUBROUTINES;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_SUBROUTINE_UNIFORMS = GLenum::GL_ACTIVE_SUBROUTINE_UNIFORMS;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = GLenum::GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_SUBROUTINE_MAX_LENGTH = GLenum::GL_ACTIVE_SUBROUTINE_MAX_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = GLenum::GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH;

// ProgramStringProperty

GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_STRING_ARB = GLenum::GL_PROGRAM_STRING_ARB;

// ProgramTarget

GLBINDING_CONSTEXPR static const GLenum GL_TEXT_FRAGMENT_SHADER_ATI = GLenum::GL_TEXT_FRAGMENT_SHADER_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_ARB = GLenum::GL_VERTEX_PROGRAM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_PROGRAM_ARB = GLenum::GL_FRAGMENT_PROGRAM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_PROGRAM_NV = GLenum::GL_TESS_CONTROL_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_PROGRAM_NV = GLenum::GL_TESS_EVALUATION_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_PROGRAM_NV = GLenum::GL_GEOMETRY_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_PROGRAM_NV = GLenum::GL_COMPUTE_PROGRAM_NV;

// QueryCounterTarget

// GLBINDING_CONSTEXPR static const GLenum GL_TIMESTAMP = GLenum::GL_TIMESTAMP; // reuse GetPName

// QueryObjectParameterName

GLBINDING_CONSTEXPR static const GLenum GL_QUERY_TARGET = GLenum::GL_QUERY_TARGET;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_RESULT = GLenum::GL_QUERY_RESULT;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_RESULT_AVAILABLE = GLenum::GL_QUERY_RESULT_AVAILABLE;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_RESULT_NO_WAIT = GLenum::GL_QUERY_RESULT_NO_WAIT;

// QueryParameterName

GLBINDING_CONSTEXPR static const GLenum GL_QUERY_COUNTER_BITS = GLenum::GL_QUERY_COUNTER_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_QUERY = GLenum::GL_CURRENT_QUERY;

// QueryTarget

GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_OVERFLOW = GLenum::GL_TRANSFORM_FEEDBACK_OVERFLOW;
GLBINDING_CONSTEXPR static const GLenum GL_VERTICES_SUBMITTED = GLenum::GL_VERTICES_SUBMITTED;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVES_SUBMITTED = GLenum::GL_PRIMITIVES_SUBMITTED;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_INVOCATIONS = GLenum::GL_VERTEX_SHADER_INVOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_TIME_ELAPSED = GLenum::GL_TIME_ELAPSED;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_PASSED = GLenum::GL_SAMPLES_PASSED;
GLBINDING_CONSTEXPR static const GLenum GL_ANY_SAMPLES_PASSED = GLenum::GL_ANY_SAMPLES_PASSED;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVES_GENERATED = GLenum::GL_PRIMITIVES_GENERATED;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = GLenum::GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN;
GLBINDING_CONSTEXPR static const GLenum GL_ANY_SAMPLES_PASSED_CONSERVATIVE = GLenum::GL_ANY_SAMPLES_PASSED_CONSERVATIVE;

// ReadBufferMode

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_LEFT = GLenum::GL_FRONT_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_RIGHT = GLenum::GL_FRONT_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK_LEFT = GLenum::GL_BACK_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK_RIGHT = GLenum::GL_BACK_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_LEFT = GLenum::GL_LEFT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_RIGHT = GLenum::GL_RIGHT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_AUX0 = GLenum::GL_AUX0; // reuse DrawBufferMode
// GLBINDING_CONSTEXPR static const GLenum GL_AUX1 = GLenum::GL_AUX1; // reuse DrawBufferMode
// GLBINDING_CONSTEXPR static const GLenum GL_AUX2 = GLenum::GL_AUX2; // reuse DrawBufferMode
// GLBINDING_CONSTEXPR static const GLenum GL_AUX3 = GLenum::GL_AUX3; // reuse DrawBufferMode
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT0 = GLenum::GL_COLOR_ATTACHMENT0; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT1 = GLenum::GL_COLOR_ATTACHMENT1; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT2 = GLenum::GL_COLOR_ATTACHMENT2; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT3 = GLenum::GL_COLOR_ATTACHMENT3; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT4 = GLenum::GL_COLOR_ATTACHMENT4; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT5 = GLenum::GL_COLOR_ATTACHMENT5; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT6 = GLenum::GL_COLOR_ATTACHMENT6; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT7 = GLenum::GL_COLOR_ATTACHMENT7; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT8 = GLenum::GL_COLOR_ATTACHMENT8; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT9 = GLenum::GL_COLOR_ATTACHMENT9; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT10 = GLenum::GL_COLOR_ATTACHMENT10; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT11 = GLenum::GL_COLOR_ATTACHMENT11; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT12 = GLenum::GL_COLOR_ATTACHMENT12; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT13 = GLenum::GL_COLOR_ATTACHMENT13; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT14 = GLenum::GL_COLOR_ATTACHMENT14; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ATTACHMENT15 = GLenum::GL_COLOR_ATTACHMENT15; // reuse ColorBuffer

// RenderbufferParameterName

GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_COVERAGE_SAMPLES_NV = GLenum::GL_RENDERBUFFER_COVERAGE_SAMPLES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_SAMPLES = GLenum::GL_RENDERBUFFER_SAMPLES;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_SAMPLES_EXT = GLenum::GL_RENDERBUFFER_SAMPLES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_WIDTH = GLenum::GL_RENDERBUFFER_WIDTH;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_WIDTH_EXT = GLenum::GL_RENDERBUFFER_WIDTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_HEIGHT = GLenum::GL_RENDERBUFFER_HEIGHT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_HEIGHT_EXT = GLenum::GL_RENDERBUFFER_HEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_INTERNAL_FORMAT = GLenum::GL_RENDERBUFFER_INTERNAL_FORMAT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_INTERNAL_FORMAT_EXT = GLenum::GL_RENDERBUFFER_INTERNAL_FORMAT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_RED_SIZE = GLenum::GL_RENDERBUFFER_RED_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_RED_SIZE_EXT = GLenum::GL_RENDERBUFFER_RED_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_GREEN_SIZE = GLenum::GL_RENDERBUFFER_GREEN_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_GREEN_SIZE_EXT = GLenum::GL_RENDERBUFFER_GREEN_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_BLUE_SIZE = GLenum::GL_RENDERBUFFER_BLUE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_BLUE_SIZE_EXT = GLenum::GL_RENDERBUFFER_BLUE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_ALPHA_SIZE = GLenum::GL_RENDERBUFFER_ALPHA_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_ALPHA_SIZE_EXT = GLenum::GL_RENDERBUFFER_ALPHA_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_DEPTH_SIZE = GLenum::GL_RENDERBUFFER_DEPTH_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_DEPTH_SIZE_EXT = GLenum::GL_RENDERBUFFER_DEPTH_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_STENCIL_SIZE = GLenum::GL_RENDERBUFFER_STENCIL_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_STENCIL_SIZE_EXT = GLenum::GL_RENDERBUFFER_STENCIL_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_COLOR_SAMPLES_NV = GLenum::GL_RENDERBUFFER_COLOR_SAMPLES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER_STORAGE_SAMPLES_AMD = GLenum::GL_RENDERBUFFER_STORAGE_SAMPLES_AMD;

// RenderbufferTarget

// GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER = GLenum::GL_RENDERBUFFER; // reuse CopyImageSubDataTarget

// RenderingMode

GLBINDING_CONSTEXPR static const GLenum GL_RENDER = GLenum::GL_RENDER;
GLBINDING_CONSTEXPR static const GLenum GL_FEEDBACK = GLenum::GL_FEEDBACK;
GLBINDING_CONSTEXPR static const GLenum GL_SELECT = GLenum::GL_SELECT;

// ReplacementCodeTypeSUN

// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse AttributeType

// SamplePatternEXT

GLBINDING_CONSTEXPR static const GLenum GL_1PASS_EXT = GLenum::GL_1PASS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_2PASS_0_EXT = GLenum::GL_2PASS_0_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_2PASS_1_EXT = GLenum::GL_2PASS_1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_0_EXT = GLenum::GL_4PASS_0_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_1_EXT = GLenum::GL_4PASS_1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_2_EXT = GLenum::GL_4PASS_2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_3_EXT = GLenum::GL_4PASS_3_EXT;

// SamplePatternSGIS

// GLBINDING_CONSTEXPR static const GLenum GL_1PASS_EXT = GLenum::GL_1PASS_EXT; // reuse SamplePatternEXT
GLBINDING_CONSTEXPR static const GLenum GL_1PASS_SGIS = GLenum::GL_1PASS_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_2PASS_0_EXT = GLenum::GL_2PASS_0_EXT; // reuse SamplePatternEXT
GLBINDING_CONSTEXPR static const GLenum GL_2PASS_0_SGIS = GLenum::GL_2PASS_0_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_2PASS_1_EXT = GLenum::GL_2PASS_1_EXT; // reuse SamplePatternEXT
GLBINDING_CONSTEXPR static const GLenum GL_2PASS_1_SGIS = GLenum::GL_2PASS_1_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_4PASS_0_EXT = GLenum::GL_4PASS_0_EXT; // reuse SamplePatternEXT
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_0_SGIS = GLenum::GL_4PASS_0_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_4PASS_1_EXT = GLenum::GL_4PASS_1_EXT; // reuse SamplePatternEXT
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_1_SGIS = GLenum::GL_4PASS_1_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_4PASS_2_EXT = GLenum::GL_4PASS_2_EXT; // reuse SamplePatternEXT
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_2_SGIS = GLenum::GL_4PASS_2_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_4PASS_3_EXT = GLenum::GL_4PASS_3_EXT; // reuse SamplePatternEXT
GLBINDING_CONSTEXPR static const GLenum GL_4PASS_3_SGIS = GLenum::GL_4PASS_3_SGIS;

// SamplerParameterF

// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER_COLOR = GLenum::GL_TEXTURE_BORDER_COLOR; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_LOD = GLenum::GL_TEXTURE_MIN_LOD;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LOD = GLenum::GL_TEXTURE_MAX_LOD;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_ANISOTROPY = GLenum::GL_TEXTURE_MAX_ANISOTROPY;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS = GLenum::GL_TEXTURE_LOD_BIAS;

// SamplerParameterI

// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAG_FILTER = GLenum::GL_TEXTURE_MAG_FILTER; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_FILTER = GLenum::GL_TEXTURE_MIN_FILTER; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_S = GLenum::GL_TEXTURE_WRAP_S; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_T = GLenum::GL_TEXTURE_WRAP_T; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_R = GLenum::GL_TEXTURE_WRAP_R;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_MODE = GLenum::GL_TEXTURE_COMPARE_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_FUNC = GLenum::GL_TEXTURE_COMPARE_FUNC;

// ScalarType

// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_BYTE = GLenum::GL_UNSIGNED_BYTE; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT = GLenum::GL_UNSIGNED_SHORT; // reuse ColorPointerType
// GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT = GLenum::GL_UNSIGNED_INT; // reuse AttributeType

// SecondaryColorPointerTypeIBM

// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// SemaphoreParameterName

GLBINDING_CONSTEXPR static const GLenum GL_D3D12_FENCE_VALUE_EXT = GLenum::GL_D3D12_FENCE_VALUE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TIMELINE_SEMAPHORE_VALUE_NV = GLenum::GL_TIMELINE_SEMAPHORE_VALUE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SEMAPHORE_TYPE_NV = GLenum::GL_SEMAPHORE_TYPE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SEMAPHORE_TYPE_BINARY_NV = GLenum::GL_SEMAPHORE_TYPE_BINARY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SEMAPHORE_TYPE_TIMELINE_NV = GLenum::GL_SEMAPHORE_TYPE_TIMELINE_NV;

// SeparableTarget

GLBINDING_CONSTEXPR static const GLenum GL_SEPARABLE_2D = GLenum::GL_SEPARABLE_2D;

// SeparableTargetEXT

// GLBINDING_CONSTEXPR static const GLenum GL_SEPARABLE_2D = GLenum::GL_SEPARABLE_2D; // reuse SeparableTarget
// GLBINDING_CONSTEXPR static const GLenum GL_SEPARABLE_2D_EXT = GLenum::GL_SEPARABLE_2D_EXT; // reuse EnableCap

// ShaderBinaryFormat

GLBINDING_CONSTEXPR static const GLenum GL_SHADER_BINARY_FORMAT_SPIR_V = GLenum::GL_SHADER_BINARY_FORMAT_SPIR_V;

// ShaderParameterName

GLBINDING_CONSTEXPR static const GLenum GL_SHADER_TYPE = GLenum::GL_SHADER_TYPE;
// GLBINDING_CONSTEXPR static const GLenum GL_DELETE_STATUS = GLenum::GL_DELETE_STATUS; // reuse ProgramPropertyARB
GLBINDING_CONSTEXPR static const GLenum GL_COMPILE_STATUS = GLenum::GL_COMPILE_STATUS;
// GLBINDING_CONSTEXPR static const GLenum GL_INFO_LOG_LENGTH = GLenum::GL_INFO_LOG_LENGTH; // reuse PipelineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_SOURCE_LENGTH = GLenum::GL_SHADER_SOURCE_LENGTH;

// ShaderType

// GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER = GLenum::GL_FRAGMENT_SHADER; // reuse PipelineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_ARB = GLenum::GL_FRAGMENT_SHADER_ARB;
// GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER = GLenum::GL_VERTEX_SHADER; // reuse PipelineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_ARB = GLenum::GL_VERTEX_SHADER_ARB;
// GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER = GLenum::GL_GEOMETRY_SHADER; // reuse PipelineParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SHADER = GLenum::GL_TESS_EVALUATION_SHADER; // reuse PipelineParameterName
// GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SHADER = GLenum::GL_TESS_CONTROL_SHADER; // reuse PipelineParameterName
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_SHADER = GLenum::GL_COMPUTE_SHADER;

// ShadingModel

GLBINDING_CONSTEXPR static const GLenum GL_FLAT = GLenum::GL_FLAT;
GLBINDING_CONSTEXPR static const GLenum GL_SMOOTH = GLenum::GL_SMOOTH;

// SizedInternalFormat

// GLBINDING_CONSTEXPR static const GLenum GL_R3_G3_B2 = GLenum::GL_R3_G3_B2; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA4 = GLenum::GL_ALPHA4; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA4_EXT = GLenum::GL_ALPHA4_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8 = GLenum::GL_ALPHA8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8_EXT = GLenum::GL_ALPHA8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA12 = GLenum::GL_ALPHA12; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA12_EXT = GLenum::GL_ALPHA12_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16 = GLenum::GL_ALPHA16; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16_EXT = GLenum::GL_ALPHA16_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4 = GLenum::GL_LUMINANCE4; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4_EXT = GLenum::GL_LUMINANCE4_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8 = GLenum::GL_LUMINANCE8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8_EXT = GLenum::GL_LUMINANCE8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12 = GLenum::GL_LUMINANCE12; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_EXT = GLenum::GL_LUMINANCE12_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16 = GLenum::GL_LUMINANCE16; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16_EXT = GLenum::GL_LUMINANCE16_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4_ALPHA4 = GLenum::GL_LUMINANCE4_ALPHA4; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE4_ALPHA4_EXT = GLenum::GL_LUMINANCE4_ALPHA4_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE6_ALPHA2 = GLenum::GL_LUMINANCE6_ALPHA2; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE6_ALPHA2_EXT = GLenum::GL_LUMINANCE6_ALPHA2_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8_ALPHA8 = GLenum::GL_LUMINANCE8_ALPHA8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8_ALPHA8_EXT = GLenum::GL_LUMINANCE8_ALPHA8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA4 = GLenum::GL_LUMINANCE12_ALPHA4; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA4_EXT = GLenum::GL_LUMINANCE12_ALPHA4_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA12 = GLenum::GL_LUMINANCE12_ALPHA12; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE12_ALPHA12_EXT = GLenum::GL_LUMINANCE12_ALPHA12_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16_ALPHA16 = GLenum::GL_LUMINANCE16_ALPHA16; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16_ALPHA16_EXT = GLenum::GL_LUMINANCE16_ALPHA16_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY4 = GLenum::GL_INTENSITY4; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY4_EXT = GLenum::GL_INTENSITY4_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8 = GLenum::GL_INTENSITY8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8_EXT = GLenum::GL_INTENSITY8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY12 = GLenum::GL_INTENSITY12; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY12_EXT = GLenum::GL_INTENSITY12_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16 = GLenum::GL_INTENSITY16; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16_EXT = GLenum::GL_INTENSITY16_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB2_EXT = GLenum::GL_RGB2_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB4 = GLenum::GL_RGB4; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB4_EXT = GLenum::GL_RGB4_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB5 = GLenum::GL_RGB5; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB5_EXT = GLenum::GL_RGB5_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB8 = GLenum::GL_RGB8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB8_EXT = GLenum::GL_RGB8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB10 = GLenum::GL_RGB10; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB10_EXT = GLenum::GL_RGB10_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB12 = GLenum::GL_RGB12; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB12_EXT = GLenum::GL_RGB12_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB16 = GLenum::GL_RGB16; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB16_EXT = GLenum::GL_RGB16_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA2 = GLenum::GL_RGBA2; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA2_EXT = GLenum::GL_RGBA2_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA4 = GLenum::GL_RGBA4; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA4_EXT = GLenum::GL_RGBA4_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB5_A1 = GLenum::GL_RGB5_A1; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB5_A1_EXT = GLenum::GL_RGB5_A1_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA8 = GLenum::GL_RGBA8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA8_EXT = GLenum::GL_RGBA8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB10_A2 = GLenum::GL_RGB10_A2; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB10_A2_EXT = GLenum::GL_RGB10_A2_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA12 = GLenum::GL_RGBA12; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA12_EXT = GLenum::GL_RGBA12_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA16 = GLenum::GL_RGBA16; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA16_EXT = GLenum::GL_RGBA16_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT16 = GLenum::GL_DEPTH_COMPONENT16; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT16_ARB = GLenum::GL_DEPTH_COMPONENT16_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT16_SGIX = GLenum::GL_DEPTH_COMPONENT16_SGIX; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT24 = GLenum::GL_DEPTH_COMPONENT24; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT24_ARB = GLenum::GL_DEPTH_COMPONENT24_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT24_SGIX = GLenum::GL_DEPTH_COMPONENT24_SGIX; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32 = GLenum::GL_DEPTH_COMPONENT32; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32_ARB = GLenum::GL_DEPTH_COMPONENT32_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32_SGIX = GLenum::GL_DEPTH_COMPONENT32_SGIX; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R8 = GLenum::GL_R8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R8_EXT = GLenum::GL_R8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R16 = GLenum::GL_R16; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG8 = GLenum::GL_RG8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG8_EXT = GLenum::GL_RG8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG16 = GLenum::GL_RG16; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R16F = GLenum::GL_R16F; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R16F_EXT = GLenum::GL_R16F_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R32F = GLenum::GL_R32F; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R32F_EXT = GLenum::GL_R32F_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG16F = GLenum::GL_RG16F; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG16F_EXT = GLenum::GL_RG16F_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG32F = GLenum::GL_RG32F; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG32F_EXT = GLenum::GL_RG32F_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R8I = GLenum::GL_R8I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R8UI = GLenum::GL_R8UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R16I = GLenum::GL_R16I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R16UI = GLenum::GL_R16UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R32I = GLenum::GL_R32I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R32UI = GLenum::GL_R32UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG8I = GLenum::GL_RG8I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG8UI = GLenum::GL_RG8UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG16I = GLenum::GL_RG16I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG16UI = GLenum::GL_RG16UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG32I = GLenum::GL_RG32I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG32UI = GLenum::GL_RG32UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_RGB_S3TC_DXT1_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_RGBA_S3TC_DXT1_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = GLenum::GL_COMPRESSED_RGBA_S3TC_DXT3_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = GLenum::GL_COMPRESSED_RGBA_S3TC_DXT5_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA32F = GLenum::GL_RGBA32F; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA32F_ARB = GLenum::GL_RGBA32F_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA32F_EXT = GLenum::GL_RGBA32F_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB32F = GLenum::GL_RGB32F; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB32F_ARB = GLenum::GL_RGB32F_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB32F_EXT = GLenum::GL_RGB32F_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA16F = GLenum::GL_RGBA16F; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA16F_ARB = GLenum::GL_RGBA16F_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA16F_EXT = GLenum::GL_RGBA16F_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB16F = GLenum::GL_RGB16F; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB16F_ARB = GLenum::GL_RGB16F_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB16F_EXT = GLenum::GL_RGB16F_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH24_STENCIL8 = GLenum::GL_DEPTH24_STENCIL8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH24_STENCIL8_EXT = GLenum::GL_DEPTH24_STENCIL8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R11F_G11F_B10F = GLenum::GL_R11F_G11F_B10F; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R11F_G11F_B10F_EXT = GLenum::GL_R11F_G11F_B10F_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB9_E5 = GLenum::GL_RGB9_E5; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB9_E5_EXT = GLenum::GL_RGB9_E5_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_SRGB8 = GLenum::GL_SRGB8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_SRGB8_EXT = GLenum::GL_SRGB8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_SRGB8_ALPHA8 = GLenum::GL_SRGB8_ALPHA8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_SRGB8_ALPHA8_EXT = GLenum::GL_SRGB8_ALPHA8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_SRGB_S3TC_DXT1_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32F = GLenum::GL_DEPTH_COMPONENT32F; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH32F_STENCIL8 = GLenum::GL_DEPTH32F_STENCIL8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX1 = GLenum::GL_STENCIL_INDEX1; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX1_EXT = GLenum::GL_STENCIL_INDEX1_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX4 = GLenum::GL_STENCIL_INDEX4; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX4_EXT = GLenum::GL_STENCIL_INDEX4_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX8 = GLenum::GL_STENCIL_INDEX8; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX8_EXT = GLenum::GL_STENCIL_INDEX8_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX16 = GLenum::GL_STENCIL_INDEX16; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_INDEX16_EXT = GLenum::GL_STENCIL_INDEX16_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB565 = GLenum::GL_RGB565; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA32UI = GLenum::GL_RGBA32UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA32UI_EXT = GLenum::GL_RGBA32UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB32UI = GLenum::GL_RGB32UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB32UI_EXT = GLenum::GL_RGB32UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA32UI_EXT = GLenum::GL_ALPHA32UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY32UI_EXT = GLenum::GL_INTENSITY32UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE32UI_EXT = GLenum::GL_LUMINANCE32UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA32UI_EXT = GLenum::GL_LUMINANCE_ALPHA32UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA16UI = GLenum::GL_RGBA16UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA16UI_EXT = GLenum::GL_RGBA16UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB16UI = GLenum::GL_RGB16UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB16UI_EXT = GLenum::GL_RGB16UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16UI_EXT = GLenum::GL_ALPHA16UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16UI_EXT = GLenum::GL_INTENSITY16UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16UI_EXT = GLenum::GL_LUMINANCE16UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA16UI_EXT = GLenum::GL_LUMINANCE_ALPHA16UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA8UI = GLenum::GL_RGBA8UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA8UI_EXT = GLenum::GL_RGBA8UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB8UI = GLenum::GL_RGB8UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB8UI_EXT = GLenum::GL_RGB8UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8UI_EXT = GLenum::GL_ALPHA8UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8UI_EXT = GLenum::GL_INTENSITY8UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8UI_EXT = GLenum::GL_LUMINANCE8UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA8UI_EXT = GLenum::GL_LUMINANCE_ALPHA8UI_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA32I = GLenum::GL_RGBA32I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA32I_EXT = GLenum::GL_RGBA32I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB32I = GLenum::GL_RGB32I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB32I_EXT = GLenum::GL_RGB32I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA32I_EXT = GLenum::GL_ALPHA32I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY32I_EXT = GLenum::GL_INTENSITY32I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE32I_EXT = GLenum::GL_LUMINANCE32I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA32I_EXT = GLenum::GL_LUMINANCE_ALPHA32I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA16I = GLenum::GL_RGBA16I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA16I_EXT = GLenum::GL_RGBA16I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB16I = GLenum::GL_RGB16I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB16I_EXT = GLenum::GL_RGB16I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA16I_EXT = GLenum::GL_ALPHA16I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY16I_EXT = GLenum::GL_INTENSITY16I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE16I_EXT = GLenum::GL_LUMINANCE16I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA16I_EXT = GLenum::GL_LUMINANCE_ALPHA16I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA8I = GLenum::GL_RGBA8I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA8I_EXT = GLenum::GL_RGBA8I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB8I = GLenum::GL_RGB8I; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB8I_EXT = GLenum::GL_RGB8I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA8I_EXT = GLenum::GL_ALPHA8I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY8I_EXT = GLenum::GL_INTENSITY8I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE8I_EXT = GLenum::GL_LUMINANCE8I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_LUMINANCE_ALPHA8I_EXT = GLenum::GL_LUMINANCE_ALPHA8I_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENT32F_NV = GLenum::GL_DEPTH_COMPONENT32F_NV; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_DEPTH32F_STENCIL8_NV = GLenum::GL_DEPTH32F_STENCIL8_NV; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED_RGTC1 = GLenum::GL_COMPRESSED_RED_RGTC1; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED_RGTC1_EXT = GLenum::GL_COMPRESSED_RED_RGTC1_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RED_RGTC1 = GLenum::GL_COMPRESSED_SIGNED_RED_RGTC1; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RED_RGTC1_EXT = GLenum::GL_COMPRESSED_SIGNED_RED_RGTC1_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RED_GREEN_RGTC2_EXT = GLenum::GL_COMPRESSED_RED_GREEN_RGTC2_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RG_RGTC2 = GLenum::GL_COMPRESSED_RG_RGTC2; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT = GLenum::GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RG_RGTC2 = GLenum::GL_COMPRESSED_SIGNED_RG_RGTC2; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_BPTC_UNORM = GLenum::GL_COMPRESSED_RGBA_BPTC_UNORM; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_BPTC_UNORM_ARB = GLenum::GL_COMPRESSED_RGBA_BPTC_UNORM_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = GLenum::GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = GLenum::GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = GLenum::GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = GLenum::GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = GLenum::GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = GLenum::GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R8_SNORM = GLenum::GL_R8_SNORM; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG8_SNORM = GLenum::GL_RG8_SNORM; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB8_SNORM = GLenum::GL_RGB8_SNORM; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA8_SNORM = GLenum::GL_RGBA8_SNORM; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_R16_SNORM = GLenum::GL_R16_SNORM; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RG16_SNORM = GLenum::GL_RG16_SNORM; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB16_SNORM = GLenum::GL_RGB16_SNORM; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGBA16_SNORM = GLenum::GL_RGBA16_SNORM; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_RGB10_A2UI = GLenum::GL_RGB10_A2UI; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_R11_EAC = GLenum::GL_COMPRESSED_R11_EAC; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_R11_EAC = GLenum::GL_COMPRESSED_SIGNED_R11_EAC; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RG11_EAC = GLenum::GL_COMPRESSED_RG11_EAC; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SIGNED_RG11_EAC = GLenum::GL_COMPRESSED_SIGNED_RG11_EAC; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB8_ETC2 = GLenum::GL_COMPRESSED_RGB8_ETC2; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ETC2 = GLenum::GL_COMPRESSED_SRGB8_ETC2; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = GLenum::GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = GLenum::GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA8_ETC2_EAC = GLenum::GL_COMPRESSED_RGBA8_ETC2_EAC; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_4x4_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_4x4_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_5x4_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_5x4_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_5x5_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_5x5_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_6x5_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_6x5_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_6x6_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_6x6_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_8x5_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_8x5_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_8x6_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_8x6_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_8x8_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_8x8_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_10x5_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_10x5_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_10x6_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_10x6_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_10x8_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_10x8_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_10x10_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_10x10_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_12x10_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_12x10_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ASTC_12x12_KHR = GLenum::GL_COMPRESSED_RGBA_ASTC_12x12_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR; // reuse InternalFormat
// GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR; // reuse InternalFormat

// SpriteModeSGIX

GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_AXIAL_SGIX = GLenum::GL_SPRITE_AXIAL_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_OBJECT_ALIGNED_SGIX = GLenum::GL_SPRITE_OBJECT_ALIGNED_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_EYE_ALIGNED_SGIX = GLenum::GL_SPRITE_EYE_ALIGNED_SGIX;

// SpriteParameterNameSGIX

// GLBINDING_CONSTEXPR static const GLenum GL_SPRITE_MODE_SGIX = GLenum::GL_SPRITE_MODE_SGIX; // reuse GetPName

// StencilFunction

// GLBINDING_CONSTEXPR static const GLenum GL_NEVER = GLenum::GL_NEVER; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_LESS = GLenum::GL_LESS; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_EQUAL = GLenum::GL_EQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_LEQUAL = GLenum::GL_LEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_GREATER = GLenum::GL_GREATER; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_NOTEQUAL = GLenum::GL_NOTEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_GEQUAL = GLenum::GL_GEQUAL; // reuse AlphaFunction
// GLBINDING_CONSTEXPR static const GLenum GL_ALWAYS = GLenum::GL_ALWAYS; // reuse AlphaFunction

// StencilOp

// GLBINDING_CONSTEXPR static const GLenum GL_ZERO = GLenum::GL_ZERO; // reuse BlendingFactor
// GLBINDING_CONSTEXPR static const GLenum GL_INVERT = GLenum::GL_INVERT; // reuse LogicOp
GLBINDING_CONSTEXPR static const GLenum GL_KEEP = GLenum::GL_KEEP;
// GLBINDING_CONSTEXPR static const GLenum GL_REPLACE = GLenum::GL_REPLACE; // reuse LightEnvModeSGIX
GLBINDING_CONSTEXPR static const GLenum GL_INCR = GLenum::GL_INCR;
GLBINDING_CONSTEXPR static const GLenum GL_DECR = GLenum::GL_DECR;
GLBINDING_CONSTEXPR static const GLenum GL_INCR_WRAP = GLenum::GL_INCR_WRAP;
GLBINDING_CONSTEXPR static const GLenum GL_DECR_WRAP = GLenum::GL_DECR_WRAP;

// StringName

GLBINDING_CONSTEXPR static const GLenum GL_VENDOR = GLenum::GL_VENDOR;
GLBINDING_CONSTEXPR static const GLenum GL_RENDERER = GLenum::GL_RENDERER;
GLBINDING_CONSTEXPR static const GLenum GL_VERSION = GLenum::GL_VERSION;
GLBINDING_CONSTEXPR static const GLenum GL_EXTENSIONS = GLenum::GL_EXTENSIONS;
GLBINDING_CONSTEXPR static const GLenum GL_SHADING_LANGUAGE_VERSION = GLenum::GL_SHADING_LANGUAGE_VERSION;

// SubgroupSupportedFeatures

GLBINDING_CONSTEXPR static const GLenum GL_SUBGROUP_FEATURE_BASIC_BIT_KHR = GLenum::GL_SUBGROUP_FEATURE_BASIC_BIT_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_SUBGROUP_FEATURE_VOTE_BIT_KHR = GLenum::GL_SUBGROUP_FEATURE_VOTE_BIT_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_SUBGROUP_FEATURE_ARITHMETIC_BIT_KHR = GLenum::GL_SUBGROUP_FEATURE_ARITHMETIC_BIT_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_SUBGROUP_FEATURE_BALLOT_BIT_KHR = GLenum::GL_SUBGROUP_FEATURE_BALLOT_BIT_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_SUBGROUP_FEATURE_SHUFFLE_BIT_KHR = GLenum::GL_SUBGROUP_FEATURE_SHUFFLE_BIT_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT_KHR = GLenum::GL_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_SUBGROUP_FEATURE_CLUSTERED_BIT_KHR = GLenum::GL_SUBGROUP_FEATURE_CLUSTERED_BIT_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_SUBGROUP_FEATURE_QUAD_BIT_KHR = GLenum::GL_SUBGROUP_FEATURE_QUAD_BIT_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_SUBGROUP_FEATURE_PARTITIONED_BIT_NV = GLenum::GL_SUBGROUP_FEATURE_PARTITIONED_BIT_NV;

// SubroutineParameterName

GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_SIZE = GLenum::GL_UNIFORM_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_UNIFORM_NAME_LENGTH = GLenum::GL_UNIFORM_NAME_LENGTH;
// GLBINDING_CONSTEXPR static const GLenum GL_NUM_COMPATIBLE_SUBROUTINES = GLenum::GL_NUM_COMPATIBLE_SUBROUTINES; // reuse ProgramResourceProperty
// GLBINDING_CONSTEXPR static const GLenum GL_COMPATIBLE_SUBROUTINES = GLenum::GL_COMPATIBLE_SUBROUTINES; // reuse ProgramResourceProperty

// SwizzleOpATI

GLBINDING_CONSTEXPR static const GLenum GL_SWIZZLE_STR_ATI = GLenum::GL_SWIZZLE_STR_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SWIZZLE_STQ_ATI = GLenum::GL_SWIZZLE_STQ_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SWIZZLE_STR_DR_ATI = GLenum::GL_SWIZZLE_STR_DR_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SWIZZLE_STQ_DQ_ATI = GLenum::GL_SWIZZLE_STQ_DQ_ATI;

// SyncBehaviorFlags

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer

// SyncCondition

GLBINDING_CONSTEXPR static const GLenum GL_SYNC_GPU_COMMANDS_COMPLETE = GLenum::GL_SYNC_GPU_COMMANDS_COMPLETE;

// SyncParameterName

GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_TYPE = GLenum::GL_OBJECT_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_SYNC_CONDITION = GLenum::GL_SYNC_CONDITION;
GLBINDING_CONSTEXPR static const GLenum GL_SYNC_STATUS = GLenum::GL_SYNC_STATUS;
GLBINDING_CONSTEXPR static const GLenum GL_SYNC_FLAGS = GLenum::GL_SYNC_FLAGS;

// SyncStatus

GLBINDING_CONSTEXPR static const GLenum GL_ALREADY_SIGNALED = GLenum::GL_ALREADY_SIGNALED;
GLBINDING_CONSTEXPR static const GLenum GL_TIMEOUT_EXPIRED = GLenum::GL_TIMEOUT_EXPIRED;
GLBINDING_CONSTEXPR static const GLenum GL_CONDITION_SATISFIED = GLenum::GL_CONDITION_SATISFIED;
GLBINDING_CONSTEXPR static const GLenum GL_WAIT_FAILED = GLenum::GL_WAIT_FAILED;

// TangentPointerTypeEXT

// GLBINDING_CONSTEXPR static const GLenum GL_BYTE = GLenum::GL_BYTE; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// TexBumpParameterATI

// GLBINDING_CONSTEXPR static const GLenum GL_BUMP_ROT_MATRIX_ATI = GLenum::GL_BUMP_ROT_MATRIX_ATI; // reuse GetTexBumpParameterATI

// TexCoordPointerType

// GLBINDING_CONSTEXPR static const GLenum GL_SHORT = GLenum::GL_SHORT; // reuse BinormalPointerTypeEXT
// GLBINDING_CONSTEXPR static const GLenum GL_INT = GLenum::GL_INT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_FLOAT = GLenum::GL_FLOAT; // reuse AttributeType
// GLBINDING_CONSTEXPR static const GLenum GL_DOUBLE = GLenum::GL_DOUBLE; // reuse AttributeType

// TextureCompareMode

// GLBINDING_CONSTEXPR static const GLenum GL_NONE = GLenum::GL_NONE; // reuse ColorBuffer
GLBINDING_CONSTEXPR static const GLenum GL_COMPARE_R_TO_TEXTURE = GLenum::GL_COMPARE_R_TO_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPARE_REF_TO_TEXTURE = GLenum::GL_COMPARE_REF_TO_TEXTURE;

// TextureCoordName

GLBINDING_CONSTEXPR static const GLenum GL_S = GLenum::GL_S;
GLBINDING_CONSTEXPR static const GLenum GL_T = GLenum::GL_T;
GLBINDING_CONSTEXPR static const GLenum GL_R = GLenum::GL_R;
GLBINDING_CONSTEXPR static const GLenum GL_Q = GLenum::GL_Q;

// TextureEnvMode

// GLBINDING_CONSTEXPR static const GLenum GL_ADD = GLenum::GL_ADD; // reuse AccumOp
// GLBINDING_CONSTEXPR static const GLenum GL_BLEND = GLenum::GL_BLEND; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_REPLACE = GLenum::GL_REPLACE; // reuse LightEnvModeSGIX
// GLBINDING_CONSTEXPR static const GLenum GL_MODULATE = GLenum::GL_MODULATE; // reuse LightEnvModeSGIX
GLBINDING_CONSTEXPR static const GLenum GL_DECAL = GLenum::GL_DECAL;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACE_EXT = GLenum::GL_REPLACE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ENV_BIAS_SGIX = GLenum::GL_TEXTURE_ENV_BIAS_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE = GLenum::GL_COMBINE;

// TextureEnvParameter

// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_SCALE = GLenum::GL_ALPHA_SCALE; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ENV_MODE = GLenum::GL_TEXTURE_ENV_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ENV_COLOR = GLenum::GL_TEXTURE_ENV_COLOR;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS = GLenum::GL_TEXTURE_LOD_BIAS; // reuse SamplerParameterF
// GLBINDING_CONSTEXPR static const GLenum GL_COMBINE = GLenum::GL_COMBINE; // reuse TextureEnvMode
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_ARB = GLenum::GL_COMBINE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_EXT = GLenum::GL_COMBINE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_RGB = GLenum::GL_COMBINE_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_RGB_ARB = GLenum::GL_COMBINE_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_RGB_EXT = GLenum::GL_COMBINE_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_ALPHA = GLenum::GL_COMBINE_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_ALPHA_ARB = GLenum::GL_COMBINE_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE_ALPHA_EXT = GLenum::GL_COMBINE_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_SCALE = GLenum::GL_RGB_SCALE;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_SCALE_ARB = GLenum::GL_RGB_SCALE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_SCALE_EXT = GLenum::GL_RGB_SCALE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ADD_SIGNED = GLenum::GL_ADD_SIGNED;
GLBINDING_CONSTEXPR static const GLenum GL_ADD_SIGNED_ARB = GLenum::GL_ADD_SIGNED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ADD_SIGNED_EXT = GLenum::GL_ADD_SIGNED_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INTERPOLATE = GLenum::GL_INTERPOLATE;
GLBINDING_CONSTEXPR static const GLenum GL_INTERPOLATE_ARB = GLenum::GL_INTERPOLATE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INTERPOLATE_EXT = GLenum::GL_INTERPOLATE_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT = GLenum::GL_CONSTANT; // reuse PathGenMode
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_ARB = GLenum::GL_CONSTANT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_EXT = GLenum::GL_CONSTANT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_NV = GLenum::GL_CONSTANT_NV;
// GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR = GLenum::GL_PRIMARY_COLOR; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR_ARB = GLenum::GL_PRIMARY_COLOR_ARB; // reuse FragmentShaderGenericSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_PRIMARY_COLOR_EXT = GLenum::GL_PRIMARY_COLOR_EXT; // reuse FragmentShaderGenericSourceATI
GLBINDING_CONSTEXPR static const GLenum GL_PREVIOUS = GLenum::GL_PREVIOUS;
GLBINDING_CONSTEXPR static const GLenum GL_PREVIOUS_ARB = GLenum::GL_PREVIOUS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PREVIOUS_EXT = GLenum::GL_PREVIOUS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_RGB = GLenum::GL_SOURCE0_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_RGB_ARB = GLenum::GL_SOURCE0_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_RGB_EXT = GLenum::GL_SOURCE0_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRC0_RGB = GLenum::GL_SRC0_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_RGB = GLenum::GL_SOURCE1_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_RGB_ARB = GLenum::GL_SOURCE1_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_RGB_EXT = GLenum::GL_SOURCE1_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRC1_RGB = GLenum::GL_SRC1_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_RGB = GLenum::GL_SOURCE2_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_RGB_ARB = GLenum::GL_SOURCE2_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_RGB_EXT = GLenum::GL_SOURCE2_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRC2_RGB = GLenum::GL_SRC2_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE3_RGB_NV = GLenum::GL_SOURCE3_RGB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_ALPHA = GLenum::GL_SOURCE0_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_ALPHA_ARB = GLenum::GL_SOURCE0_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE0_ALPHA_EXT = GLenum::GL_SOURCE0_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRC0_ALPHA = GLenum::GL_SRC0_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_ALPHA = GLenum::GL_SOURCE1_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_ALPHA_ARB = GLenum::GL_SOURCE1_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE1_ALPHA_EXT = GLenum::GL_SOURCE1_ALPHA_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_SRC1_ALPHA = GLenum::GL_SRC1_ALPHA; // reuse BlendingFactor
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_ALPHA = GLenum::GL_SOURCE2_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_ALPHA_ARB = GLenum::GL_SOURCE2_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE2_ALPHA_EXT = GLenum::GL_SOURCE2_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SRC2_ALPHA = GLenum::GL_SRC2_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_SOURCE3_ALPHA_NV = GLenum::GL_SOURCE3_ALPHA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_RGB = GLenum::GL_OPERAND0_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_RGB_ARB = GLenum::GL_OPERAND0_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_RGB_EXT = GLenum::GL_OPERAND0_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_RGB = GLenum::GL_OPERAND1_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_RGB_ARB = GLenum::GL_OPERAND1_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_RGB_EXT = GLenum::GL_OPERAND1_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_RGB = GLenum::GL_OPERAND2_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_RGB_ARB = GLenum::GL_OPERAND2_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_RGB_EXT = GLenum::GL_OPERAND2_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND3_RGB_NV = GLenum::GL_OPERAND3_RGB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_ALPHA = GLenum::GL_OPERAND0_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_ALPHA_ARB = GLenum::GL_OPERAND0_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND0_ALPHA_EXT = GLenum::GL_OPERAND0_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_ALPHA = GLenum::GL_OPERAND1_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_ALPHA_ARB = GLenum::GL_OPERAND1_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND1_ALPHA_EXT = GLenum::GL_OPERAND1_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_ALPHA = GLenum::GL_OPERAND2_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_ALPHA_ARB = GLenum::GL_OPERAND2_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND2_ALPHA_EXT = GLenum::GL_OPERAND2_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OPERAND3_ALPHA_NV = GLenum::GL_OPERAND3_ALPHA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COORD_REPLACE = GLenum::GL_COORD_REPLACE;

// TextureEnvTarget

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ENV = GLenum::GL_TEXTURE_ENV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_FILTER_CONTROL = GLenum::GL_TEXTURE_FILTER_CONTROL;
GLBINDING_CONSTEXPR static const GLenum GL_POINT_SPRITE = GLenum::GL_POINT_SPRITE;

// TextureFilterSGIS

GLBINDING_CONSTEXPR static const GLenum GL_FILTER4_SGIS = GLenum::GL_FILTER4_SGIS;

// TextureGenMode

// GLBINDING_CONSTEXPR static const GLenum GL_EYE_LINEAR = GLenum::GL_EYE_LINEAR; // reuse PathGenMode
// GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_LINEAR = GLenum::GL_OBJECT_LINEAR; // reuse PathGenMode
GLBINDING_CONSTEXPR static const GLenum GL_SPHERE_MAP = GLenum::GL_SPHERE_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_DISTANCE_TO_POINT_SGIS = GLenum::GL_EYE_DISTANCE_TO_POINT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_DISTANCE_TO_POINT_SGIS = GLenum::GL_OBJECT_DISTANCE_TO_POINT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_DISTANCE_TO_LINE_SGIS = GLenum::GL_EYE_DISTANCE_TO_LINE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_DISTANCE_TO_LINE_SGIS = GLenum::GL_OBJECT_DISTANCE_TO_LINE_SGIS;

// TextureGenParameter

GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEN_MODE = GLenum::GL_TEXTURE_GEN_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_PLANE = GLenum::GL_OBJECT_PLANE;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_PLANE = GLenum::GL_EYE_PLANE;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_POINT_SGIS = GLenum::GL_EYE_POINT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_POINT_SGIS = GLenum::GL_OBJECT_POINT_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_LINE_SGIS = GLenum::GL_EYE_LINE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_LINE_SGIS = GLenum::GL_OBJECT_LINE_SGIS;

// TextureLayout

GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT = GLenum::GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT = GLenum::GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_GENERAL_EXT = GLenum::GL_LAYOUT_GENERAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_COLOR_ATTACHMENT_EXT = GLenum::GL_LAYOUT_COLOR_ATTACHMENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT = GLenum::GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT = GLenum::GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_SHADER_READ_ONLY_EXT = GLenum::GL_LAYOUT_SHADER_READ_ONLY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_TRANSFER_SRC_EXT = GLenum::GL_LAYOUT_TRANSFER_SRC_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LAYOUT_TRANSFER_DST_EXT = GLenum::GL_LAYOUT_TRANSFER_DST_EXT;

// TextureMagFilter

// GLBINDING_CONSTEXPR static const GLenum GL_NEAREST = GLenum::GL_NEAREST; // reuse BlitFramebufferFilter
// GLBINDING_CONSTEXPR static const GLenum GL_LINEAR = GLenum::GL_LINEAR; // reuse BlitFramebufferFilter
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_DETAIL_SGIS = GLenum::GL_LINEAR_DETAIL_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_DETAIL_ALPHA_SGIS = GLenum::GL_LINEAR_DETAIL_ALPHA_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_DETAIL_COLOR_SGIS = GLenum::GL_LINEAR_DETAIL_COLOR_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_SHARPEN_SGIS = GLenum::GL_LINEAR_SHARPEN_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_SHARPEN_ALPHA_SGIS = GLenum::GL_LINEAR_SHARPEN_ALPHA_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_SHARPEN_COLOR_SGIS = GLenum::GL_LINEAR_SHARPEN_COLOR_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_FILTER4_SGIS = GLenum::GL_FILTER4_SGIS; // reuse TextureFilterSGIS

// TextureMinFilter

// GLBINDING_CONSTEXPR static const GLenum GL_NEAREST = GLenum::GL_NEAREST; // reuse BlitFramebufferFilter
// GLBINDING_CONSTEXPR static const GLenum GL_LINEAR = GLenum::GL_LINEAR; // reuse BlitFramebufferFilter
GLBINDING_CONSTEXPR static const GLenum GL_NEAREST_MIPMAP_NEAREST = GLenum::GL_NEAREST_MIPMAP_NEAREST;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_MIPMAP_NEAREST = GLenum::GL_LINEAR_MIPMAP_NEAREST;
GLBINDING_CONSTEXPR static const GLenum GL_NEAREST_MIPMAP_LINEAR = GLenum::GL_NEAREST_MIPMAP_LINEAR;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_MIPMAP_LINEAR = GLenum::GL_LINEAR_MIPMAP_LINEAR;
// GLBINDING_CONSTEXPR static const GLenum GL_FILTER4_SGIS = GLenum::GL_FILTER4_SGIS; // reuse TextureFilterSGIS
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_CLIPMAP_LINEAR_SGIX = GLenum::GL_LINEAR_CLIPMAP_LINEAR_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_NEAREST_CLIPMAP_NEAREST_SGIX = GLenum::GL_NEAREST_CLIPMAP_NEAREST_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_NEAREST_CLIPMAP_LINEAR_SGIX = GLenum::GL_NEAREST_CLIPMAP_LINEAR_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_LINEAR_CLIPMAP_NEAREST_SGIX = GLenum::GL_LINEAR_CLIPMAP_NEAREST_SGIX;

// TextureNormalModeEXT

GLBINDING_CONSTEXPR static const GLenum GL_PERTURB_EXT = GLenum::GL_PERTURB_EXT;

// TextureParameterName

// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WIDTH = GLenum::GL_TEXTURE_WIDTH; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_HEIGHT = GLenum::GL_TEXTURE_HEIGHT; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTERNAL_FORMAT = GLenum::GL_TEXTURE_INTERNAL_FORMAT; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPONENTS = GLenum::GL_TEXTURE_COMPONENTS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER_COLOR = GLenum::GL_TEXTURE_BORDER_COLOR; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER = GLenum::GL_TEXTURE_BORDER; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAG_FILTER = GLenum::GL_TEXTURE_MAG_FILTER; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_FILTER = GLenum::GL_TEXTURE_MIN_FILTER; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_S = GLenum::GL_TEXTURE_WRAP_S; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_T = GLenum::GL_TEXTURE_WRAP_T; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RED_SIZE = GLenum::GL_TEXTURE_RED_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GREEN_SIZE = GLenum::GL_TEXTURE_GREEN_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BLUE_SIZE = GLenum::GL_TEXTURE_BLUE_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ALPHA_SIZE = GLenum::GL_TEXTURE_ALPHA_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LUMINANCE_SIZE = GLenum::GL_TEXTURE_LUMINANCE_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTENSITY_SIZE = GLenum::GL_TEXTURE_INTENSITY_SIZE; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_PRIORITY = GLenum::GL_TEXTURE_PRIORITY; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_PRIORITY_EXT = GLenum::GL_TEXTURE_PRIORITY_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RESIDENT = GLenum::GL_TEXTURE_RESIDENT; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEPTH_EXT = GLenum::GL_TEXTURE_DEPTH_EXT; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_R = GLenum::GL_TEXTURE_WRAP_R; // reuse SamplerParameterI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_R_EXT = GLenum::GL_TEXTURE_WRAP_R_EXT; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_LEVEL_SGIS = GLenum::GL_DETAIL_TEXTURE_LEVEL_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_MODE_SGIS = GLenum::GL_DETAIL_TEXTURE_MODE_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS = GLenum::GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = GLenum::GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_SHADOW_AMBIENT_SGIX = GLenum::GL_SHADOW_AMBIENT_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_DUAL_TEXTURE_SELECT_SGIS = GLenum::GL_DUAL_TEXTURE_SELECT_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_QUAD_TEXTURE_SELECT_SGIS = GLenum::GL_QUAD_TEXTURE_SELECT_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4DSIZE_SGIS = GLenum::GL_TEXTURE_4DSIZE_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_WRAP_Q_SGIS = GLenum::GL_TEXTURE_WRAP_Q_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_LOD = GLenum::GL_TEXTURE_MIN_LOD; // reuse SamplerParameterF
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MIN_LOD_SGIS = GLenum::GL_TEXTURE_MIN_LOD_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LOD = GLenum::GL_TEXTURE_MAX_LOD; // reuse SamplerParameterF
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LOD_SGIS = GLenum::GL_TEXTURE_MAX_LOD_SGIS; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BASE_LEVEL = GLenum::GL_TEXTURE_BASE_LEVEL;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BASE_LEVEL_SGIS = GLenum::GL_TEXTURE_BASE_LEVEL_SGIS; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LEVEL = GLenum::GL_TEXTURE_MAX_LEVEL;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_LEVEL_SGIS = GLenum::GL_TEXTURE_MAX_LEVEL_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_FILTER4_SIZE_SGIS = GLenum::GL_TEXTURE_FILTER4_SIZE_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_CENTER_SGIX = GLenum::GL_TEXTURE_CLIPMAP_CENTER_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_FRAME_SGIX = GLenum::GL_TEXTURE_CLIPMAP_FRAME_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_OFFSET_SGIX = GLenum::GL_TEXTURE_CLIPMAP_OFFSET_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX = GLenum::GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX = GLenum::GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CLIPMAP_DEPTH_SGIX = GLenum::GL_TEXTURE_CLIPMAP_DEPTH_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_BIAS_SGIX = GLenum::GL_POST_TEXTURE_FILTER_BIAS_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_POST_TEXTURE_FILTER_SCALE_SGIX = GLenum::GL_POST_TEXTURE_FILTER_SCALE_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_S_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_S_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_T_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_T_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_R_SGIX = GLenum::GL_TEXTURE_LOD_BIAS_R_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP = GLenum::GL_GENERATE_MIPMAP; // reuse InternalFormatPName
// GLBINDING_CONSTEXPR static const GLenum GL_GENERATE_MIPMAP_SGIS = GLenum::GL_GENERATE_MIPMAP_SGIS; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_SGIX = GLenum::GL_TEXTURE_COMPARE_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_OPERATOR_SGIX = GLenum::GL_TEXTURE_COMPARE_OPERATOR_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LEQUAL_R_SGIX = GLenum::GL_TEXTURE_LEQUAL_R_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GEQUAL_R_SGIX = GLenum::GL_TEXTURE_GEQUAL_R_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_S_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_S_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_T_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_T_SGIX; // reuse GetTextureParameter
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_CLAMP_R_SGIX = GLenum::GL_TEXTURE_MAX_CLAMP_R_SGIX; // reuse GetTextureParameter
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MEMORY_LAYOUT_INTEL = GLenum::GL_TEXTURE_MEMORY_LAYOUT_INTEL;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_ANISOTROPY = GLenum::GL_TEXTURE_MAX_ANISOTROPY; // reuse SamplerParameterF
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS = GLenum::GL_TEXTURE_LOD_BIAS; // reuse SamplerParameterF
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_MODE = GLenum::GL_TEXTURE_COMPARE_MODE; // reuse SamplerParameterI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_FUNC = GLenum::GL_TEXTURE_COMPARE_FUNC; // reuse SamplerParameterI
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SWIZZLE_R = GLenum::GL_TEXTURE_SWIZZLE_R;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SWIZZLE_G = GLenum::GL_TEXTURE_SWIZZLE_G;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SWIZZLE_B = GLenum::GL_TEXTURE_SWIZZLE_B;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SWIZZLE_A = GLenum::GL_TEXTURE_SWIZZLE_A;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SWIZZLE_RGBA = GLenum::GL_TEXTURE_SWIZZLE_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_STENCIL_TEXTURE_MODE = GLenum::GL_DEPTH_STENCIL_TEXTURE_MODE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_TILING_EXT = GLenum::GL_TEXTURE_TILING_EXT;

// TextureSwizzle

// GLBINDING_CONSTEXPR static const GLenum GL_ZERO = GLenum::GL_ZERO; // reuse BlendingFactor
// GLBINDING_CONSTEXPR static const GLenum GL_RED = GLenum::GL_RED; // reuse FragmentShaderValueRepATI
// GLBINDING_CONSTEXPR static const GLenum GL_GREEN = GLenum::GL_GREEN; // reuse FragmentShaderValueRepATI
// GLBINDING_CONSTEXPR static const GLenum GL_BLUE = GLenum::GL_BLUE; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_ALPHA = GLenum::GL_ALPHA; // reuse CombinerComponentUsageNV
// GLBINDING_CONSTEXPR static const GLenum GL_ONE = GLenum::GL_ONE; // reuse BlendingFactor

// TextureTarget

// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D = GLenum::GL_TEXTURE_1D; // reuse CopyImageSubDataTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D = GLenum::GL_TEXTURE_2D; // reuse CopyImageSubDataTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_1D = GLenum::GL_PROXY_TEXTURE_1D;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_1D_EXT = GLenum::GL_PROXY_TEXTURE_1D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D = GLenum::GL_PROXY_TEXTURE_2D;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_EXT = GLenum::GL_PROXY_TEXTURE_2D_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D = GLenum::GL_TEXTURE_3D; // reuse CopyImageSubDataTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_3D_EXT = GLenum::GL_TEXTURE_3D_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_3D = GLenum::GL_PROXY_TEXTURE_3D;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_3D_EXT = GLenum::GL_PROXY_TEXTURE_3D_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DETAIL_TEXTURE_2D_SGIS = GLenum::GL_DETAIL_TEXTURE_2D_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_4D_SGIS = GLenum::GL_TEXTURE_4D_SGIS; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_4D_SGIS = GLenum::GL_PROXY_TEXTURE_4D_SGIS;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RECTANGLE = GLenum::GL_TEXTURE_RECTANGLE; // reuse CopyImageSubDataTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RECTANGLE_ARB = GLenum::GL_TEXTURE_RECTANGLE_ARB; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RECTANGLE_NV = GLenum::GL_TEXTURE_RECTANGLE_NV; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_RECTANGLE = GLenum::GL_PROXY_TEXTURE_RECTANGLE;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_RECTANGLE_ARB = GLenum::GL_PROXY_TEXTURE_RECTANGLE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_RECTANGLE_NV = GLenum::GL_PROXY_TEXTURE_RECTANGLE_NV;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP = GLenum::GL_TEXTURE_CUBE_MAP; // reuse CopyImageSubDataTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_ARB = GLenum::GL_TEXTURE_CUBE_MAP_ARB; // reuse EnableCap
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_EXT = GLenum::GL_TEXTURE_CUBE_MAP_EXT; // reuse EnableCap
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_X = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_X;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_X = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_X;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Y = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Y;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Y;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Z = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Z;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT = GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Z;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT = GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_CUBE_MAP = GLenum::GL_PROXY_TEXTURE_CUBE_MAP;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_CUBE_MAP_ARB = GLenum::GL_PROXY_TEXTURE_CUBE_MAP_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_CUBE_MAP_EXT = GLenum::GL_PROXY_TEXTURE_CUBE_MAP_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D_ARRAY = GLenum::GL_TEXTURE_1D_ARRAY; // reuse CopyImageSubDataTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_1D_ARRAY = GLenum::GL_PROXY_TEXTURE_1D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_1D_ARRAY_EXT = GLenum::GL_PROXY_TEXTURE_1D_ARRAY_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_ARRAY = GLenum::GL_TEXTURE_2D_ARRAY; // reuse CopyImageSubDataTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_ARRAY = GLenum::GL_PROXY_TEXTURE_2D_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_ARRAY_EXT = GLenum::GL_PROXY_TEXTURE_2D_ARRAY_EXT;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BUFFER = GLenum::GL_TEXTURE_BUFFER; // reuse BufferStorageTarget
// GLBINDING_CONSTEXPR static const GLenum GL_RENDERBUFFER = GLenum::GL_RENDERBUFFER; // reuse CopyImageSubDataTarget
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_ARRAY = GLenum::GL_TEXTURE_CUBE_MAP_ARRAY; // reuse CopyImageSubDataTarget
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CUBE_MAP_ARRAY_ARB = GLenum::GL_TEXTURE_CUBE_MAP_ARRAY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = GLenum::GL_PROXY_TEXTURE_CUBE_MAP_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB = GLenum::GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_MULTISAMPLE = GLenum::GL_TEXTURE_2D_MULTISAMPLE; // reuse CopyImageSubDataTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_MULTISAMPLE = GLenum::GL_PROXY_TEXTURE_2D_MULTISAMPLE;
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_MULTISAMPLE_ARRAY = GLenum::GL_TEXTURE_2D_MULTISAMPLE_ARRAY; // reuse CopyImageSubDataTarget
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = GLenum::GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY;

// TextureUnit

// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE0 = GLenum::GL_TEXTURE0; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE1 = GLenum::GL_TEXTURE1; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE2 = GLenum::GL_TEXTURE2; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE3 = GLenum::GL_TEXTURE3; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE4 = GLenum::GL_TEXTURE4; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE5 = GLenum::GL_TEXTURE5; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE6 = GLenum::GL_TEXTURE6; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE7 = GLenum::GL_TEXTURE7; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE8 = GLenum::GL_TEXTURE8; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE9 = GLenum::GL_TEXTURE9; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE10 = GLenum::GL_TEXTURE10; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE11 = GLenum::GL_TEXTURE11; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE12 = GLenum::GL_TEXTURE12; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE13 = GLenum::GL_TEXTURE13; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE14 = GLenum::GL_TEXTURE14; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE15 = GLenum::GL_TEXTURE15; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE16 = GLenum::GL_TEXTURE16; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE17 = GLenum::GL_TEXTURE17; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE18 = GLenum::GL_TEXTURE18; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE19 = GLenum::GL_TEXTURE19; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE20 = GLenum::GL_TEXTURE20; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE21 = GLenum::GL_TEXTURE21; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE22 = GLenum::GL_TEXTURE22; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE23 = GLenum::GL_TEXTURE23; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE24 = GLenum::GL_TEXTURE24; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE25 = GLenum::GL_TEXTURE25; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE26 = GLenum::GL_TEXTURE26; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE27 = GLenum::GL_TEXTURE27; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE28 = GLenum::GL_TEXTURE28; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE29 = GLenum::GL_TEXTURE29; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE30 = GLenum::GL_TEXTURE30; // reuse FragmentShaderTextureSourceATI
// GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE31 = GLenum::GL_TEXTURE31; // reuse FragmentShaderTextureSourceATI

// TextureWrapMode

GLBINDING_CONSTEXPR static const GLenum GL_CLAMP = GLenum::GL_CLAMP;
GLBINDING_CONSTEXPR static const GLenum GL_REPEAT = GLenum::GL_REPEAT;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_TO_BORDER = GLenum::GL_CLAMP_TO_BORDER;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_TO_BORDER_ARB = GLenum::GL_CLAMP_TO_BORDER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_TO_BORDER_SGIS = GLenum::GL_CLAMP_TO_BORDER_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_TO_EDGE = GLenum::GL_CLAMP_TO_EDGE;
GLBINDING_CONSTEXPR static const GLenum GL_CLAMP_TO_EDGE_SGIS = GLenum::GL_CLAMP_TO_EDGE_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_MIRRORED_REPEAT = GLenum::GL_MIRRORED_REPEAT;
GLBINDING_CONSTEXPR static const GLenum GL_MIRRORED_REPEAT_ARB = GLenum::GL_MIRRORED_REPEAT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MIRRORED_REPEAT_IBM = GLenum::GL_MIRRORED_REPEAT_IBM;

// TransformFeedbackBufferMode

GLBINDING_CONSTEXPR static const GLenum GL_INTERLEAVED_ATTRIBS = GLenum::GL_INTERLEAVED_ATTRIBS;
GLBINDING_CONSTEXPR static const GLenum GL_SEPARATE_ATTRIBS = GLenum::GL_SEPARATE_ATTRIBS;

// TransformFeedbackPName

// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_START = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_START; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_SIZE; // reuse GetPName
// GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_BINDING; // reuse GetPName
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_PAUSED = GLenum::GL_TRANSFORM_FEEDBACK_PAUSED;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_ACTIVE = GLenum::GL_TRANSFORM_FEEDBACK_ACTIVE;

// TransformFeedbackTokenNV

GLBINDING_CONSTEXPR static const GLenum GL_NEXT_BUFFER_NV = GLenum::GL_NEXT_BUFFER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SKIP_COMPONENTS4_NV = GLenum::GL_SKIP_COMPONENTS4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SKIP_COMPONENTS3_NV = GLenum::GL_SKIP_COMPONENTS3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SKIP_COMPONENTS2_NV = GLenum::GL_SKIP_COMPONENTS2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SKIP_COMPONENTS1_NV = GLenum::GL_SKIP_COMPONENTS1_NV;

// TriangleFace

// GLBINDING_CONSTEXPR static const GLenum GL_FRONT = GLenum::GL_FRONT; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_BACK = GLenum::GL_BACK; // reuse ColorBuffer
// GLBINDING_CONSTEXPR static const GLenum GL_FRONT_AND_BACK = GLenum::GL_FRONT_AND_BACK; // reuse ColorBuffer

// TriangleListSUN

GLBINDING_CONSTEXPR static const GLenum GL_RESTART_SUN = GLenum::GL_RESTART_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACE_MIDDLE_SUN = GLenum::GL_REPLACE_MIDDLE_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACE_OLDEST_SUN = GLenum::GL_REPLACE_OLDEST_SUN;

// UNGROUPED

GLBINDING_CONSTEXPR static const GLenum GL_STACK_OVERFLOW_KHR = GLenum::GL_STACK_OVERFLOW_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_STACK_UNDERFLOW_KHR = GLenum::GL_STACK_UNDERFLOW_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_LOST = GLenum::GL_CONTEXT_LOST;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_LOST_KHR = GLenum::GL_CONTEXT_LOST_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MODELVIEW_STACK_DEPTH_NV = GLenum::GL_PATH_MODELVIEW_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_PROJECTION_STACK_DEPTH_NV = GLenum::GL_PATH_PROJECTION_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MODELVIEW_MATRIX_NV = GLenum::GL_PATH_MODELVIEW_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_PROJECTION_MATRIX_NV = GLenum::GL_PATH_PROJECTION_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV = GLenum::GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV = GLenum::GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_TARGET = GLenum::GL_TEXTURE_TARGET;
GLBINDING_CONSTEXPR static const GLenum GL_2_BYTES_NV = GLenum::GL_2_BYTES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_3_BYTES_NV = GLenum::GL_3_BYTES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_4_BYTES_NV = GLenum::GL_4_BYTES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FIXED_OES = GLenum::GL_FIXED_OES;
GLBINDING_CONSTEXPR static const GLenum GL_XOR_NV = GLenum::GL_XOR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW0_ARB = GLenum::GL_MODELVIEW0_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_MODELVIEW_NV = GLenum::GL_PATH_MODELVIEW_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_PROJECTION_NV = GLenum::GL_PATH_PROJECTION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RED_NV = GLenum::GL_RED_NV;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_NV = GLenum::GL_GREEN_NV;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_NV = GLenum::GL_BLUE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RASTER_POSITION_UNCLIPPED_IBM = GLenum::GL_RASTER_POSITION_UNCLIPPED_IBM;
GLBINDING_CONSTEXPR static const GLenum GL_NATIVE_GRAPHICS_HANDLE_PGI = GLenum::GL_NATIVE_GRAPHICS_HANDLE_PGI;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_LINEAR_NV = GLenum::GL_EYE_LINEAR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OBJECT_LINEAR_NV = GLenum::GL_OBJECT_LINEAR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_COLOR_EXT = GLenum::GL_CONSTANT_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_CONSTANT_COLOR_EXT = GLenum::GL_ONE_MINUS_CONSTANT_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_ALPHA_EXT = GLenum::GL_CONSTANT_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ONE_MINUS_CONSTANT_ALPHA_EXT = GLenum::GL_ONE_MINUS_CONSTANT_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_EQUATION_RGB_EXT = GLenum::GL_BLEND_EQUATION_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_EXT = GLenum::GL_POLYGON_OFFSET_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_POLYGON_OFFSET_FACTOR_EXT = GLenum::GL_POLYGON_OFFSET_FACTOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_RESCALE_NORMAL = GLenum::GL_RESCALE_NORMAL;
GLBINDING_CONSTEXPR static const GLenum GL_INTENSITY_EXT = GLenum::GL_INTENSITY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RED_SIZE_EXT = GLenum::GL_TEXTURE_RED_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_GREEN_SIZE_EXT = GLenum::GL_TEXTURE_GREEN_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BLUE_SIZE_EXT = GLenum::GL_TEXTURE_BLUE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_ALPHA_SIZE_EXT = GLenum::GL_TEXTURE_ALPHA_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LUMINANCE_SIZE_EXT = GLenum::GL_TEXTURE_LUMINANCE_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INTENSITY_SIZE_EXT = GLenum::GL_TEXTURE_INTENSITY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RESIDENT_EXT = GLenum::GL_TEXTURE_RESIDENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D_BINDING_EXT = GLenum::GL_TEXTURE_1D_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_BINDING_EXT = GLenum::GL_TEXTURE_2D_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DEPTH = GLenum::GL_TEXTURE_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_EXT = GLenum::GL_VERTEX_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_KHR = GLenum::GL_VERTEX_ARRAY_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_EXT = GLenum::GL_NORMAL_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_EXT = GLenum::GL_COLOR_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_EXT = GLenum::GL_INDEX_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_EXT = GLenum::GL_EDGE_FLAG_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_SIZE_EXT = GLenum::GL_VERTEX_ARRAY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_TYPE_EXT = GLenum::GL_VERTEX_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_STRIDE_EXT = GLenum::GL_VERTEX_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_TYPE_EXT = GLenum::GL_NORMAL_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_STRIDE_EXT = GLenum::GL_NORMAL_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_SIZE_EXT = GLenum::GL_COLOR_ARRAY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_TYPE_EXT = GLenum::GL_COLOR_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_STRIDE_EXT = GLenum::GL_COLOR_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_TYPE_EXT = GLenum::GL_INDEX_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_ARRAY_STRIDE_EXT = GLenum::GL_INDEX_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_SIZE_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_TYPE_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_STRIDE_EXT = GLenum::GL_TEXTURE_COORD_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_EDGE_FLAG_ARRAY_STRIDE_EXT = GLenum::GL_EDGE_FLAG_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_ARB = GLenum::GL_MULTISAMPLE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_EXT = GLenum::GL_MULTISAMPLE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_COVERAGE_ARB = GLenum::GL_SAMPLE_ALPHA_TO_COVERAGE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_MASK_EXT = GLenum::GL_SAMPLE_ALPHA_TO_MASK_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_ONE_ARB = GLenum::GL_SAMPLE_ALPHA_TO_ONE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_ALPHA_TO_ONE_EXT = GLenum::GL_SAMPLE_ALPHA_TO_ONE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE_ARB = GLenum::GL_SAMPLE_COVERAGE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_EXT = GLenum::GL_SAMPLE_MASK_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS_ARB = GLenum::GL_SAMPLE_BUFFERS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS_EXT = GLenum::GL_SAMPLE_BUFFERS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_ARB = GLenum::GL_SAMPLES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_EXT = GLenum::GL_SAMPLES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE_VALUE_ARB = GLenum::GL_SAMPLE_COVERAGE_VALUE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_VALUE_EXT = GLenum::GL_SAMPLE_MASK_VALUE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_COVERAGE_INVERT_ARB = GLenum::GL_SAMPLE_COVERAGE_INVERT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_MASK_INVERT_EXT = GLenum::GL_SAMPLE_MASK_INVERT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_PATTERN_EXT = GLenum::GL_SAMPLE_PATTERN_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATRIX = GLenum::GL_COLOR_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_MATRIX_STACK_DEPTH = GLenum::GL_COLOR_MATRIX_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COLOR_MATRIX_STACK_DEPTH = GLenum::GL_MAX_COLOR_MATRIX_STACK_DEPTH;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = GLenum::GL_TEXTURE_COMPARE_FAIL_VALUE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_DST_RGB_EXT = GLenum::GL_BLEND_DST_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_SRC_RGB_EXT = GLenum::GL_BLEND_SRC_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_DST_ALPHA_EXT = GLenum::GL_BLEND_DST_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BLEND_SRC_ALPHA_EXT = GLenum::GL_BLEND_SRC_ALPHA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_422_EXT = GLenum::GL_422_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_422_REV_EXT = GLenum::GL_422_REV_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_422_AVERAGE_EXT = GLenum::GL_422_AVERAGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_422_REV_AVERAGE_EXT = GLenum::GL_422_REV_AVERAGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX1_EXT = GLenum::GL_COLOR_INDEX1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX2_EXT = GLenum::GL_COLOR_INDEX2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX4_EXT = GLenum::GL_COLOR_INDEX4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX8_EXT = GLenum::GL_COLOR_INDEX8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX12_EXT = GLenum::GL_COLOR_INDEX12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_INDEX16_EXT = GLenum::GL_COLOR_INDEX16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ELEMENTS_VERTICES_EXT = GLenum::GL_MAX_ELEMENTS_VERTICES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_ELEMENTS_INDICES_EXT = GLenum::GL_MAX_ELEMENTS_INDICES_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PHONG_WIN = GLenum::GL_PHONG_WIN;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_SPECULAR_TEXTURE_WIN = GLenum::GL_FOG_SPECULAR_TEXTURE_WIN;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_INDEX_SIZE_EXT = GLenum::GL_TEXTURE_INDEX_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PARAMETER_BUFFER_ARB = GLenum::GL_PARAMETER_BUFFER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PARAMETER_BUFFER_BINDING = GLenum::GL_PARAMETER_BUFFER_BINDING;
GLBINDING_CONSTEXPR static const GLenum GL_PARAMETER_BUFFER_BINDING_ARB = GLenum::GL_PARAMETER_BUFFER_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_IGNORE_BORDER_HP = GLenum::GL_IGNORE_BORDER_HP;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_BORDER = GLenum::GL_CONSTANT_BORDER;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_BORDER_HP = GLenum::GL_CONSTANT_BORDER_HP;
GLBINDING_CONSTEXPR static const GLenum GL_REPLICATE_BORDER = GLenum::GL_REPLICATE_BORDER;
GLBINDING_CONSTEXPR static const GLenum GL_REPLICATE_BORDER_HP = GLenum::GL_REPLICATE_BORDER_HP;
GLBINDING_CONSTEXPR static const GLenum GL_CONVOLUTION_BORDER_COLOR_HP = GLenum::GL_CONVOLUTION_BORDER_COLOR_HP;
GLBINDING_CONSTEXPR static const GLenum GL_CUBIC_HP = GLenum::GL_CUBIC_HP;
GLBINDING_CONSTEXPR static const GLenum GL_AVERAGE_HP = GLenum::GL_AVERAGE_HP;
GLBINDING_CONSTEXPR static const GLenum GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = GLenum::GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = GLenum::GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP;
GLBINDING_CONSTEXPR static const GLenum GL_OCCLUSION_TEST_HP = GLenum::GL_OCCLUSION_TEST_HP;
GLBINDING_CONSTEXPR static const GLenum GL_OCCLUSION_TEST_RESULT_HP = GLenum::GL_OCCLUSION_TEST_RESULT_HP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LIGHTING_MODE_HP = GLenum::GL_TEXTURE_LIGHTING_MODE_HP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_POST_SPECULAR_HP = GLenum::GL_TEXTURE_POST_SPECULAR_HP;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_PRE_SPECULAR_HP = GLenum::GL_TEXTURE_PRE_SPECULAR_HP;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DEFORMATION_ORDER_SGIX = GLenum::GL_MAX_DEFORMATION_ORDER_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_ELEMENT_LOCK_FIRST_EXT = GLenum::GL_ARRAY_ELEMENT_LOCK_FIRST_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_ELEMENT_LOCK_COUNT_EXT = GLenum::GL_ARRAY_ELEMENT_LOCK_COUNT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_VERTEX_EXT = GLenum::GL_CULL_VERTEX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_IUI_V2F_EXT = GLenum::GL_IUI_V2F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_IUI_V3F_EXT = GLenum::GL_IUI_V3F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_IUI_N3F_V2F_EXT = GLenum::GL_IUI_N3F_V2F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_IUI_N3F_V3F_EXT = GLenum::GL_IUI_N3F_V3F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_IUI_V2F_EXT = GLenum::GL_T2F_IUI_V2F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_IUI_V3F_EXT = GLenum::GL_T2F_IUI_V3F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_IUI_N3F_V2F_EXT = GLenum::GL_T2F_IUI_N3F_V2F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_T2F_IUI_N3F_V3F_EXT = GLenum::GL_T2F_IUI_N3F_V3F_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_TEST_EXT = GLenum::GL_INDEX_TEST_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_TEST_FUNC_EXT = GLenum::GL_INDEX_TEST_FUNC_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_TEST_REF_EXT = GLenum::GL_INDEX_TEST_REF_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_MATERIAL_EXT = GLenum::GL_INDEX_MATERIAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_MATERIAL_PARAMETER_EXT = GLenum::GL_INDEX_MATERIAL_PARAMETER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX_MATERIAL_FACE_EXT = GLenum::GL_INDEX_MATERIAL_FACE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_WRAP_BORDER_SUN = GLenum::GL_WRAP_BORDER_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_CONSTANT_DATA_SUNX = GLenum::GL_UNPACK_CONSTANT_DATA_SUNX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_CONSTANT_DATA_SUNX = GLenum::GL_TEXTURE_CONSTANT_DATA_SUNX;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_LIST_SUN = GLenum::GL_TRIANGLE_LIST_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACEMENT_CODE_SUN = GLenum::GL_REPLACEMENT_CODE_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_GLOBAL_ALPHA_SUN = GLenum::GL_GLOBAL_ALPHA_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_GLOBAL_ALPHA_FACTOR_SUN = GLenum::GL_GLOBAL_ALPHA_FACTOR_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COLOR_WRITEMASK_SGIS = GLenum::GL_TEXTURE_COLOR_WRITEMASK_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_FRAMEBUFFER_DEFAULT = GLenum::GL_FRAMEBUFFER_DEFAULT;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = GLenum::GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED;
GLBINDING_CONSTEXPR static const GLenum GL_INDEX = GLenum::GL_INDEX;
GLBINDING_CONSTEXPR static const GLenum GL_SYNC_CL_EVENT_ARB = GLenum::GL_SYNC_CL_EVENT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SYNC_CL_EVENT_COMPLETE_ARB = GLenum::GL_SYNC_CL_EVENT_COMPLETE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = GLenum::GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = GLenum::GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = GLenum::GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = GLenum::GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = GLenum::GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_CALLBACK_FUNCTION_ARB = GLenum::GL_DEBUG_CALLBACK_FUNCTION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_CALLBACK_FUNCTION_KHR = GLenum::GL_DEBUG_CALLBACK_FUNCTION_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_CALLBACK_USER_PARAM_ARB = GLenum::GL_DEBUG_CALLBACK_USER_PARAM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_CALLBACK_USER_PARAM_KHR = GLenum::GL_DEBUG_CALLBACK_USER_PARAM_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_API_ARB = GLenum::GL_DEBUG_SOURCE_API_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_API_KHR = GLenum::GL_DEBUG_SOURCE_API_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = GLenum::GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = GLenum::GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = GLenum::GL_DEBUG_SOURCE_SHADER_COMPILER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_SHADER_COMPILER_KHR = GLenum::GL_DEBUG_SOURCE_SHADER_COMPILER_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_THIRD_PARTY_ARB = GLenum::GL_DEBUG_SOURCE_THIRD_PARTY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_THIRD_PARTY_KHR = GLenum::GL_DEBUG_SOURCE_THIRD_PARTY_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_APPLICATION_ARB = GLenum::GL_DEBUG_SOURCE_APPLICATION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_APPLICATION_KHR = GLenum::GL_DEBUG_SOURCE_APPLICATION_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_OTHER_ARB = GLenum::GL_DEBUG_SOURCE_OTHER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SOURCE_OTHER_KHR = GLenum::GL_DEBUG_SOURCE_OTHER_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_ERROR_ARB = GLenum::GL_DEBUG_TYPE_ERROR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_ERROR_KHR = GLenum::GL_DEBUG_TYPE_ERROR_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = GLenum::GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = GLenum::GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = GLenum::GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = GLenum::GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PORTABILITY_ARB = GLenum::GL_DEBUG_TYPE_PORTABILITY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PORTABILITY_KHR = GLenum::GL_DEBUG_TYPE_PORTABILITY_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PERFORMANCE_ARB = GLenum::GL_DEBUG_TYPE_PERFORMANCE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PERFORMANCE_KHR = GLenum::GL_DEBUG_TYPE_PERFORMANCE_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_OTHER_ARB = GLenum::GL_DEBUG_TYPE_OTHER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_OTHER_KHR = GLenum::GL_DEBUG_TYPE_OTHER_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_LOSE_CONTEXT_ON_RESET = GLenum::GL_LOSE_CONTEXT_ON_RESET;
GLBINDING_CONSTEXPR static const GLenum GL_LOSE_CONTEXT_ON_RESET_ARB = GLenum::GL_LOSE_CONTEXT_ON_RESET_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_LOSE_CONTEXT_ON_RESET_KHR = GLenum::GL_LOSE_CONTEXT_ON_RESET_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_GUILTY_CONTEXT_RESET_ARB = GLenum::GL_GUILTY_CONTEXT_RESET_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_GUILTY_CONTEXT_RESET_KHR = GLenum::GL_GUILTY_CONTEXT_RESET_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_INNOCENT_CONTEXT_RESET_ARB = GLenum::GL_INNOCENT_CONTEXT_RESET_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_INNOCENT_CONTEXT_RESET_KHR = GLenum::GL_INNOCENT_CONTEXT_RESET_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_UNKNOWN_CONTEXT_RESET_ARB = GLenum::GL_UNKNOWN_CONTEXT_RESET_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_UNKNOWN_CONTEXT_RESET_KHR = GLenum::GL_UNKNOWN_CONTEXT_RESET_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_RESET_NOTIFICATION_STRATEGY = GLenum::GL_RESET_NOTIFICATION_STRATEGY;
GLBINDING_CONSTEXPR static const GLenum GL_RESET_NOTIFICATION_STRATEGY_ARB = GLenum::GL_RESET_NOTIFICATION_STRATEGY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_RESET_NOTIFICATION_STRATEGY_KHR = GLenum::GL_RESET_NOTIFICATION_STRATEGY_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_SEPARABLE_EXT = GLenum::GL_PROGRAM_SEPARABLE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_PROGRAM_EXT = GLenum::GL_ACTIVE_PROGRAM_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_PIPELINE_BINDING_EXT = GLenum::GL_PROGRAM_PIPELINE_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_UNDEFINED_VERTEX = GLenum::GL_UNDEFINED_VERTEX;
GLBINDING_CONSTEXPR static const GLenum GL_NO_RESET_NOTIFICATION = GLenum::GL_NO_RESET_NOTIFICATION;
GLBINDING_CONSTEXPR static const GLenum GL_NO_RESET_NOTIFICATION_ARB = GLenum::GL_NO_RESET_NOTIFICATION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_NO_RESET_NOTIFICATION_KHR = GLenum::GL_NO_RESET_NOTIFICATION_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = GLenum::GL_MAX_COMPUTE_SHARED_MEMORY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_MARKER_KHR = GLenum::GL_DEBUG_TYPE_MARKER_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_PUSH_GROUP_KHR = GLenum::GL_DEBUG_TYPE_PUSH_GROUP_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_TYPE_POP_GROUP_KHR = GLenum::GL_DEBUG_TYPE_POP_GROUP_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_SEVERITY_NOTIFICATION_KHR = GLenum::GL_DEBUG_SEVERITY_NOTIFICATION_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = GLenum::GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DEBUG_GROUP_STACK_DEPTH_KHR = GLenum::GL_DEBUG_GROUP_STACK_DEPTH_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_DIMENSIONS = GLenum::GL_MAX_COMBINED_DIMENSIONS;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_COMPONENTS = GLenum::GL_DEPTH_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_COMPONENTS = GLenum::GL_STENCIL_COMPONENTS;
GLBINDING_CONSTEXPR static const GLenum GL_MANUAL_GENERATE_MIPMAP = GLenum::GL_MANUAL_GENERATE_MIPMAP;
GLBINDING_CONSTEXPR static const GLenum GL_SRGB_DECODE_ARB = GLenum::GL_SRGB_DECODE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FULL_SUPPORT = GLenum::GL_FULL_SUPPORT;
GLBINDING_CONSTEXPR static const GLenum GL_CAVEAT_SUPPORT = GLenum::GL_CAVEAT_SUPPORT;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_4_X_32 = GLenum::GL_IMAGE_CLASS_4_X_32;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_2_X_32 = GLenum::GL_IMAGE_CLASS_2_X_32;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_1_X_32 = GLenum::GL_IMAGE_CLASS_1_X_32;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_4_X_16 = GLenum::GL_IMAGE_CLASS_4_X_16;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_2_X_16 = GLenum::GL_IMAGE_CLASS_2_X_16;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_1_X_16 = GLenum::GL_IMAGE_CLASS_1_X_16;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_4_X_8 = GLenum::GL_IMAGE_CLASS_4_X_8;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_2_X_8 = GLenum::GL_IMAGE_CLASS_2_X_8;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_1_X_8 = GLenum::GL_IMAGE_CLASS_1_X_8;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_11_11_10 = GLenum::GL_IMAGE_CLASS_11_11_10;
GLBINDING_CONSTEXPR static const GLenum GL_IMAGE_CLASS_10_10_10_2 = GLenum::GL_IMAGE_CLASS_10_10_10_2;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_128_BITS = GLenum::GL_VIEW_CLASS_128_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_96_BITS = GLenum::GL_VIEW_CLASS_96_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_64_BITS = GLenum::GL_VIEW_CLASS_64_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_48_BITS = GLenum::GL_VIEW_CLASS_48_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_32_BITS = GLenum::GL_VIEW_CLASS_32_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_24_BITS = GLenum::GL_VIEW_CLASS_24_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_16_BITS = GLenum::GL_VIEW_CLASS_16_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_8_BITS = GLenum::GL_VIEW_CLASS_8_BITS;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_S3TC_DXT1_RGB = GLenum::GL_VIEW_CLASS_S3TC_DXT1_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_S3TC_DXT1_RGBA = GLenum::GL_VIEW_CLASS_S3TC_DXT1_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_S3TC_DXT3_RGBA = GLenum::GL_VIEW_CLASS_S3TC_DXT3_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_S3TC_DXT5_RGBA = GLenum::GL_VIEW_CLASS_S3TC_DXT5_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_RGTC1_RED = GLenum::GL_VIEW_CLASS_RGTC1_RED;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_RGTC2_RG = GLenum::GL_VIEW_CLASS_RGTC2_RG;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_BPTC_UNORM = GLenum::GL_VIEW_CLASS_BPTC_UNORM;
GLBINDING_CONSTEXPR static const GLenum GL_VIEW_CLASS_BPTC_FLOAT = GLenum::GL_VIEW_CLASS_BPTC_FLOAT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_VIEW_MIN_LEVEL = GLenum::GL_TEXTURE_VIEW_MIN_LEVEL;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_VIEW_NUM_LEVELS = GLenum::GL_TEXTURE_VIEW_NUM_LEVELS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_VIEW_MIN_LAYER = GLenum::GL_TEXTURE_VIEW_MIN_LAYER;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_VIEW_NUM_LAYERS = GLenum::GL_TEXTURE_VIEW_NUM_LAYERS;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_IMMUTABLE_LEVELS = GLenum::GL_TEXTURE_IMMUTABLE_LEVELS;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_KHR = GLenum::GL_BUFFER_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_KHR = GLenum::GL_SHADER_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_KHR = GLenum::GL_PROGRAM_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_QUERY_KHR = GLenum::GL_QUERY_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_PIPELINE_KHR = GLenum::GL_PROGRAM_PIPELINE_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ATTRIB_STRIDE = GLenum::GL_MAX_VERTEX_ATTRIB_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLER_KHR = GLenum::GL_SAMPLER_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_DISPLAY_LIST = GLenum::GL_DISPLAY_LIST;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_LABEL_LENGTH_KHR = GLenum::GL_MAX_LABEL_LENGTH_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_SHADING_LANGUAGE_VERSIONS = GLenum::GL_NUM_SHADING_LANGUAGE_VERSIONS;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB = GLenum::GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW = GLenum::GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB = GLenum::GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTICES_SUBMITTED_ARB = GLenum::GL_VERTICES_SUBMITTED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVES_SUBMITTED_ARB = GLenum::GL_PRIMITIVES_SUBMITTED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_INVOCATIONS_ARB = GLenum::GL_VERTEX_SHADER_INVOCATIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SHADER_PATCHES = GLenum::GL_TESS_CONTROL_SHADER_PATCHES;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_CONTROL_SHADER_PATCHES_ARB = GLenum::GL_TESS_CONTROL_SHADER_PATCHES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SHADER_INVOCATIONS = GLenum::GL_TESS_EVALUATION_SHADER_INVOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB = GLenum::GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED = GLenum::GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED;
GLBINDING_CONSTEXPR static const GLenum GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB = GLenum::GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_INVOCATIONS = GLenum::GL_FRAGMENT_SHADER_INVOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_FRAGMENT_SHADER_INVOCATIONS_ARB = GLenum::GL_FRAGMENT_SHADER_INVOCATIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_SHADER_INVOCATIONS = GLenum::GL_COMPUTE_SHADER_INVOCATIONS;
GLBINDING_CONSTEXPR static const GLenum GL_COMPUTE_SHADER_INVOCATIONS_ARB = GLenum::GL_COMPUTE_SHADER_INVOCATIONS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLIPPING_INPUT_PRIMITIVES = GLenum::GL_CLIPPING_INPUT_PRIMITIVES;
GLBINDING_CONSTEXPR static const GLenum GL_CLIPPING_INPUT_PRIMITIVES_ARB = GLenum::GL_CLIPPING_INPUT_PRIMITIVES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLIPPING_OUTPUT_PRIMITIVES = GLenum::GL_CLIPPING_OUTPUT_PRIMITIVES;
GLBINDING_CONSTEXPR static const GLenum GL_CLIPPING_OUTPUT_PRIMITIVES_ARB = GLenum::GL_CLIPPING_OUTPUT_PRIMITIVES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SPARSE_BUFFER_PAGE_SIZE_ARB = GLenum::GL_SPARSE_BUFFER_PAGE_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_CULL_DISTANCES = GLenum::GL_MAX_CULL_DISTANCES;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = GLenum::GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_RELEASE_BEHAVIOR = GLenum::GL_CONTEXT_RELEASE_BEHAVIOR;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_RELEASE_BEHAVIOR_KHR = GLenum::GL_CONTEXT_RELEASE_BEHAVIOR_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = GLenum::GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH;
GLBINDING_CONSTEXPR static const GLenum GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR = GLenum::GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR;
GLBINDING_CONSTEXPR static const GLenum GL_YCRCB_SGIX = GLenum::GL_YCRCB_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_YCRCBA_SGIX = GLenum::GL_YCRCBA_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_CUBIC_EXT = GLenum::GL_CUBIC_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_AVERAGE_EXT = GLenum::GL_AVERAGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = GLenum::GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = GLenum::GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_TRANSFORM_2D_MATRIX_EXT = GLenum::GL_PIXEL_TRANSFORM_2D_MATRIX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_APPLICATION_MODE_EXT = GLenum::GL_TEXTURE_APPLICATION_MODE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LIGHT_EXT = GLenum::GL_TEXTURE_LIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MATERIAL_FACE_EXT = GLenum::GL_TEXTURE_MATERIAL_FACE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MATERIAL_PARAMETER_EXT = GLenum::GL_TEXTURE_MATERIAL_PARAMETER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_PIXEL_GROUP_COLOR_SGIS = GLenum::GL_PIXEL_GROUP_COLOR_SGIS;
GLBINDING_CONSTEXPR static const GLenum GL_RGB_S3TC = GLenum::GL_RGB_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_RGB4_S3TC = GLenum::GL_RGB4_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_S3TC = GLenum::GL_RGBA_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA4_S3TC = GLenum::GL_RGBA4_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_DXT5_S3TC = GLenum::GL_RGBA_DXT5_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA4_DXT5_S3TC = GLenum::GL_RGBA4_DXT5_S3TC;
GLBINDING_CONSTEXPR static const GLenum GL_PARALLEL_ARRAYS_INTEL = GLenum::GL_PARALLEL_ARRAYS_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL = GLenum::GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL = GLenum::GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL = GLenum::GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL = GLenum::GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_BLACKHOLE_RENDER_INTEL = GLenum::GL_BLACKHOLE_RENDER_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_CONSERVATIVE_RASTERIZATION_INTEL = GLenum::GL_CONSERVATIVE_RASTERIZATION_INTEL;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_NORMAL_SGIX = GLenum::GL_CURRENT_RASTER_NORMAL_SGIX;
GLBINDING_CONSTEXPR static const GLenum GL_TANGENT_ARRAY_EXT = GLenum::GL_TANGENT_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BINORMAL_ARRAY_EXT = GLenum::GL_BINORMAL_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_TANGENT_EXT = GLenum::GL_CURRENT_TANGENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_BINORMAL_EXT = GLenum::GL_CURRENT_BINORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TANGENT_ARRAY_TYPE_EXT = GLenum::GL_TANGENT_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TANGENT_ARRAY_STRIDE_EXT = GLenum::GL_TANGENT_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BINORMAL_ARRAY_TYPE_EXT = GLenum::GL_BINORMAL_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BINORMAL_ARRAY_STRIDE_EXT = GLenum::GL_BINORMAL_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TANGENT_ARRAY_POINTER_EXT = GLenum::GL_TANGENT_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_BINORMAL_ARRAY_POINTER_EXT = GLenum::GL_BINORMAL_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_TANGENT_EXT = GLenum::GL_MAP1_TANGENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_TANGENT_EXT = GLenum::GL_MAP2_TANGENT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_BINORMAL_EXT = GLenum::GL_MAP1_BINORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_BINORMAL_EXT = GLenum::GL_MAP2_BINORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_SOURCE = GLenum::GL_FOG_COORDINATE_SOURCE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_SOURCE_EXT = GLenum::GL_FOG_COORDINATE_SOURCE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_FOG_COORDINATE = GLenum::GL_CURRENT_FOG_COORDINATE;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_FOG_COORD = GLenum::GL_CURRENT_FOG_COORD;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_FOG_COORDINATE_EXT = GLenum::GL_CURRENT_FOG_COORDINATE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_TYPE = GLenum::GL_FOG_COORDINATE_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_TYPE_EXT = GLenum::GL_FOG_COORDINATE_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_ARRAY_TYPE = GLenum::GL_FOG_COORD_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_STRIDE = GLenum::GL_FOG_COORDINATE_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_STRIDE_EXT = GLenum::GL_FOG_COORDINATE_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_ARRAY_STRIDE = GLenum::GL_FOG_COORD_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_POINTER = GLenum::GL_FOG_COORDINATE_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_POINTER_EXT = GLenum::GL_FOG_COORDINATE_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_ARRAY_POINTER = GLenum::GL_FOG_COORD_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY = GLenum::GL_FOG_COORDINATE_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORDINATE_ARRAY_EXT = GLenum::GL_FOG_COORDINATE_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_COORD_ARRAY = GLenum::GL_FOG_COORD_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_SUM = GLenum::GL_COLOR_SUM;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_SUM_ARB = GLenum::GL_COLOR_SUM_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_SUM_EXT = GLenum::GL_COLOR_SUM_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_SECONDARY_COLOR = GLenum::GL_CURRENT_SECONDARY_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_SECONDARY_COLOR_EXT = GLenum::GL_CURRENT_SECONDARY_COLOR_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_SIZE = GLenum::GL_SECONDARY_COLOR_ARRAY_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_SIZE_EXT = GLenum::GL_SECONDARY_COLOR_ARRAY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_TYPE = GLenum::GL_SECONDARY_COLOR_ARRAY_TYPE;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_TYPE_EXT = GLenum::GL_SECONDARY_COLOR_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_STRIDE = GLenum::GL_SECONDARY_COLOR_ARRAY_STRIDE;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT = GLenum::GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_POINTER = GLenum::GL_SECONDARY_COLOR_ARRAY_POINTER;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_POINTER_EXT = GLenum::GL_SECONDARY_COLOR_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY = GLenum::GL_SECONDARY_COLOR_ARRAY;
GLBINDING_CONSTEXPR static const GLenum GL_SECONDARY_COLOR_ARRAY_EXT = GLenum::GL_SECONDARY_COLOR_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_RASTER_SECONDARY_COLOR = GLenum::GL_CURRENT_RASTER_SECONDARY_COLOR;
GLBINDING_CONSTEXPR static const GLenum GL_SCREEN_COORDINATES_REND = GLenum::GL_SCREEN_COORDINATES_REND;
GLBINDING_CONSTEXPR static const GLenum GL_INVERTED_SCREEN_W_REND = GLenum::GL_INVERTED_SCREEN_W_REND;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE2_ARB = GLenum::GL_TEXTURE2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE3_ARB = GLenum::GL_TEXTURE3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE4_ARB = GLenum::GL_TEXTURE4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE5_ARB = GLenum::GL_TEXTURE5_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE6_ARB = GLenum::GL_TEXTURE6_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE7_ARB = GLenum::GL_TEXTURE7_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE8_ARB = GLenum::GL_TEXTURE8_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE9_ARB = GLenum::GL_TEXTURE9_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE10_ARB = GLenum::GL_TEXTURE10_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE11_ARB = GLenum::GL_TEXTURE11_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE12_ARB = GLenum::GL_TEXTURE12_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE13_ARB = GLenum::GL_TEXTURE13_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE14_ARB = GLenum::GL_TEXTURE14_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE15_ARB = GLenum::GL_TEXTURE15_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE16_ARB = GLenum::GL_TEXTURE16_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE17_ARB = GLenum::GL_TEXTURE17_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE18_ARB = GLenum::GL_TEXTURE18_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE19_ARB = GLenum::GL_TEXTURE19_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE20_ARB = GLenum::GL_TEXTURE20_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE21_ARB = GLenum::GL_TEXTURE21_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE22_ARB = GLenum::GL_TEXTURE22_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE23_ARB = GLenum::GL_TEXTURE23_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE24_ARB = GLenum::GL_TEXTURE24_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE25_ARB = GLenum::GL_TEXTURE25_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE26_ARB = GLenum::GL_TEXTURE26_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE27_ARB = GLenum::GL_TEXTURE27_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE28_ARB = GLenum::GL_TEXTURE28_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE29_ARB = GLenum::GL_TEXTURE29_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE30_ARB = GLenum::GL_TEXTURE30_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE31_ARB = GLenum::GL_TEXTURE31_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_TEXTURE_ARB = GLenum::GL_ACTIVE_TEXTURE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CLIENT_ACTIVE_TEXTURE = GLenum::GL_CLIENT_ACTIVE_TEXTURE;
GLBINDING_CONSTEXPR static const GLenum GL_CLIENT_ACTIVE_TEXTURE_ARB = GLenum::GL_CLIENT_ACTIVE_TEXTURE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_UNITS = GLenum::GL_MAX_TEXTURE_UNITS;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_UNITS_ARB = GLenum::GL_MAX_TEXTURE_UNITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_MODELVIEW_MATRIX = GLenum::GL_TRANSPOSE_MODELVIEW_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = GLenum::GL_TRANSPOSE_MODELVIEW_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV = GLenum::GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_PROJECTION_MATRIX = GLenum::GL_TRANSPOSE_PROJECTION_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_PROJECTION_MATRIX_ARB = GLenum::GL_TRANSPOSE_PROJECTION_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV = GLenum::GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_TEXTURE_MATRIX = GLenum::GL_TRANSPOSE_TEXTURE_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_TEXTURE_MATRIX_ARB = GLenum::GL_TRANSPOSE_TEXTURE_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_COLOR_MATRIX = GLenum::GL_TRANSPOSE_COLOR_MATRIX;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_COLOR_MATRIX_ARB = GLenum::GL_TRANSPOSE_COLOR_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_SUBTRACT = GLenum::GL_SUBTRACT;
GLBINDING_CONSTEXPR static const GLenum GL_SUBTRACT_ARB = GLenum::GL_SUBTRACT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RENDERBUFFER_SIZE_EXT = GLenum::GL_MAX_RENDERBUFFER_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_ALPHA = GLenum::GL_COMPRESSED_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_ALPHA_ARB = GLenum::GL_COMPRESSED_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_LUMINANCE = GLenum::GL_COMPRESSED_LUMINANCE;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_LUMINANCE_ARB = GLenum::GL_COMPRESSED_LUMINANCE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_LUMINANCE_ALPHA = GLenum::GL_COMPRESSED_LUMINANCE_ALPHA;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_LUMINANCE_ALPHA_ARB = GLenum::GL_COMPRESSED_LUMINANCE_ALPHA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_INTENSITY = GLenum::GL_COMPRESSED_INTENSITY;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_INTENSITY_ARB = GLenum::GL_COMPRESSED_INTENSITY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_ARB = GLenum::GL_COMPRESSED_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_ARB = GLenum::GL_COMPRESSED_RGBA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB = GLenum::GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RECTANGLE_TEXTURE_SIZE_NV = GLenum::GL_MAX_RECTANGLE_TEXTURE_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_LOD_BIAS_EXT = GLenum::GL_MAX_TEXTURE_LOD_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAX_ANISOTROPY_EXT = GLenum::GL_TEXTURE_MAX_ANISOTROPY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_MAX_ANISOTROPY = GLenum::GL_MAX_TEXTURE_MAX_ANISOTROPY;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = GLenum::GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_FILTER_CONTROL_EXT = GLenum::GL_TEXTURE_FILTER_CONTROL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LOD_BIAS_EXT = GLenum::GL_TEXTURE_LOD_BIAS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW1_STACK_DEPTH_EXT = GLenum::GL_MODELVIEW1_STACK_DEPTH_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINE4_NV = GLenum::GL_COMBINE4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SHININESS_NV = GLenum::GL_MAX_SHININESS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_SPOT_EXPONENT_NV = GLenum::GL_MAX_SPOT_EXPONENT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW1_MATRIX_EXT = GLenum::GL_MODELVIEW1_MATRIX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_INCR_WRAP_EXT = GLenum::GL_INCR_WRAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DECR_WRAP_EXT = GLenum::GL_DECR_WRAP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHTING_EXT = GLenum::GL_VERTEX_WEIGHTING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW1_ARB = GLenum::GL_MODELVIEW1_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW1_EXT = GLenum::GL_MODELVIEW1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_VERTEX_WEIGHT_EXT = GLenum::GL_CURRENT_VERTEX_WEIGHT_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHT_ARRAY_EXT = GLenum::GL_VERTEX_WEIGHT_ARRAY_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT = GLenum::GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT = GLenum::GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT = GLenum::GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT = GLenum::GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_APPLE = GLenum::GL_VERTEX_ARRAY_RANGE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_NV = GLenum::GL_VERTEX_ARRAY_RANGE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE = GLenum::GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_LENGTH_NV = GLenum::GL_VERTEX_ARRAY_RANGE_LENGTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_VALID_NV = GLenum::GL_VERTEX_ARRAY_RANGE_VALID_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = GLenum::GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_POINTER_APPLE = GLenum::GL_VERTEX_ARRAY_RANGE_POINTER_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_POINTER_NV = GLenum::GL_VERTEX_ARRAY_RANGE_POINTER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_REGISTER_COMBINERS_NV = GLenum::GL_REGISTER_COMBINERS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_COLOR0_NV = GLenum::GL_CONSTANT_COLOR0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONSTANT_COLOR1_NV = GLenum::GL_CONSTANT_COLOR1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_E_TIMES_F_NV = GLenum::GL_E_TIMES_F_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SPARE0_PLUS_SECONDARY_COLOR_NV = GLenum::GL_SPARE0_PLUS_SECONDARY_COLOR_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = GLenum::GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PER_STAGE_CONSTANTS_NV = GLenum::GL_PER_STAGE_CONSTANTS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_AB_DOT_PRODUCT_NV = GLenum::GL_COMBINER_AB_DOT_PRODUCT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_CD_DOT_PRODUCT_NV = GLenum::GL_COMBINER_CD_DOT_PRODUCT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_MUX_SUM_NV = GLenum::GL_COMBINER_MUX_SUM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_SCALE_NV = GLenum::GL_COMBINER_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_BIAS_NV = GLenum::GL_COMBINER_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_AB_OUTPUT_NV = GLenum::GL_COMBINER_AB_OUTPUT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_CD_OUTPUT_NV = GLenum::GL_COMBINER_CD_OUTPUT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COMBINER_SUM_OUTPUT_NV = GLenum::GL_COMBINER_SUM_OUTPUT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_GENERAL_COMBINERS_NV = GLenum::GL_MAX_GENERAL_COMBINERS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_GENERAL_COMBINERS_NV = GLenum::GL_NUM_GENERAL_COMBINERS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_COLOR_SUM_CLAMP_NV = GLenum::GL_COLOR_SUM_CLAMP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_RESTART_NV = GLenum::GL_PRIMITIVE_RESTART_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PRIMITIVE_RESTART_INDEX_NV = GLenum::GL_PRIMITIVE_RESTART_INDEX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_FOG_DISTANCE_MODE_NV = GLenum::GL_FOG_DISTANCE_MODE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_RADIAL_NV = GLenum::GL_EYE_RADIAL_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EYE_PLANE_ABSOLUTE_NV = GLenum::GL_EYE_PLANE_ABSOLUTE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EMBOSS_LIGHT_NV = GLenum::GL_EMBOSS_LIGHT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EMBOSS_CONSTANT_NV = GLenum::GL_EMBOSS_CONSTANT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EMBOSS_MAP_NV = GLenum::GL_EMBOSS_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RED_MIN_CLAMP_INGR = GLenum::GL_RED_MIN_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_MIN_CLAMP_INGR = GLenum::GL_GREEN_MIN_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_MIN_CLAMP_INGR = GLenum::GL_BLUE_MIN_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_MIN_CLAMP_INGR = GLenum::GL_ALPHA_MIN_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_RED_MAX_CLAMP_INGR = GLenum::GL_RED_MAX_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_GREEN_MAX_CLAMP_INGR = GLenum::GL_GREEN_MAX_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_BLUE_MAX_CLAMP_INGR = GLenum::GL_BLUE_MAX_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_ALPHA_MAX_CLAMP_INGR = GLenum::GL_ALPHA_MAX_CLAMP_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_INTERLACE_READ_INGR = GLenum::GL_INTERLACE_READ_INGR;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_NORMAL_EXT = GLenum::GL_TEXTURE_NORMAL_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE = GLenum::GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNPACK_CLIENT_STORAGE_APPLE = GLenum::GL_UNPACK_CLIENT_STORAGE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_BUFFER_OBJECT_APPLE = GLenum::GL_BUFFER_OBJECT_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ARRAY_BINDING_APPLE = GLenum::GL_VERTEX_ARRAY_BINDING_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RANGE_LENGTH_APPLE = GLenum::GL_TEXTURE_RANGE_LENGTH_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_RANGE_POINTER_APPLE = GLenum::GL_TEXTURE_RANGE_POINTER_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_YCBCR_422_APPLE = GLenum::GL_YCBCR_422_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_8_8_APPLE = GLenum::GL_UNSIGNED_SHORT_8_8_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_8_8_MESA = GLenum::GL_UNSIGNED_SHORT_8_8_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_8_8_REV_APPLE = GLenum::GL_UNSIGNED_SHORT_8_8_REV_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_SHORT_8_8_REV_MESA = GLenum::GL_UNSIGNED_SHORT_8_8_REV_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_STORAGE_PRIVATE_APPLE = GLenum::GL_STORAGE_PRIVATE_APPLE;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACEMENT_CODE_ARRAY_SUN = GLenum::GL_REPLACEMENT_CODE_ARRAY_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN = GLenum::GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN = GLenum::GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN = GLenum::GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_V3F_SUN = GLenum::GL_R1UI_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_C4UB_V3F_SUN = GLenum::GL_R1UI_C4UB_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_C3F_V3F_SUN = GLenum::GL_R1UI_C3F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_N3F_V3F_SUN = GLenum::GL_R1UI_N3F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_C4F_N3F_V3F_SUN = GLenum::GL_R1UI_C4F_N3F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_T2F_V3F_SUN = GLenum::GL_R1UI_T2F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_T2F_N3F_V3F_SUN = GLenum::GL_R1UI_T2F_N3F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_R1UI_T2F_C4F_N3F_V3F_SUN = GLenum::GL_R1UI_T2F_C4F_N3F_V3F_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_SLICE_ACCUM_SUN = GLenum::GL_SLICE_ACCUM_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_QUAD_MESH_SUN = GLenum::GL_QUAD_MESH_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_TRIANGLE_MESH_SUN = GLenum::GL_TRIANGLE_MESH_SUN;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_NV = GLenum::GL_VERTEX_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_STATE_PROGRAM_NV = GLenum::GL_VERTEX_STATE_PROGRAM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIB_ARRAY_SIZE_NV = GLenum::GL_ATTRIB_ARRAY_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIB_ARRAY_STRIDE_NV = GLenum::GL_ATTRIB_ARRAY_STRIDE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIB_ARRAY_TYPE_NV = GLenum::GL_ATTRIB_ARRAY_TYPE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB = GLenum::GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_ATTRIB_NV = GLenum::GL_CURRENT_ATTRIB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_VERTEX_ATTRIB_ARB = GLenum::GL_CURRENT_VERTEX_ATTRIB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_LENGTH_ARB = GLenum::GL_PROGRAM_LENGTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_LENGTH_NV = GLenum::GL_PROGRAM_LENGTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_STRING_NV = GLenum::GL_PROGRAM_STRING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW_PROJECTION_NV = GLenum::GL_MODELVIEW_PROJECTION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_IDENTITY_NV = GLenum::GL_IDENTITY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_INVERSE_NV = GLenum::GL_INVERSE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRANSPOSE_NV = GLenum::GL_TRANSPOSE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_INVERSE_TRANSPOSE_NV = GLenum::GL_INVERSE_TRANSPOSE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = GLenum::GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV = GLenum::GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_MATRICES_ARB = GLenum::GL_MAX_PROGRAM_MATRICES_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_TRACK_MATRICES_NV = GLenum::GL_MAX_TRACK_MATRICES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX0_NV = GLenum::GL_MATRIX0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX1_NV = GLenum::GL_MATRIX1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX2_NV = GLenum::GL_MATRIX2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX3_NV = GLenum::GL_MATRIX3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX4_NV = GLenum::GL_MATRIX4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX5_NV = GLenum::GL_MATRIX5_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX6_NV = GLenum::GL_MATRIX6_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MATRIX7_NV = GLenum::GL_MATRIX7_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_MATRIX_STACK_DEPTH_ARB = GLenum::GL_CURRENT_MATRIX_STACK_DEPTH_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_MATRIX_STACK_DEPTH_NV = GLenum::GL_CURRENT_MATRIX_STACK_DEPTH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_MATRIX_ARB = GLenum::GL_CURRENT_MATRIX_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_MATRIX_NV = GLenum::GL_CURRENT_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_POINT_SIZE = GLenum::GL_VERTEX_PROGRAM_POINT_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_POINT_SIZE_ARB = GLenum::GL_VERTEX_PROGRAM_POINT_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_POINT_SIZE_NV = GLenum::GL_VERTEX_PROGRAM_POINT_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_POINT_SIZE_ARB = GLenum::GL_PROGRAM_POINT_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_POINT_SIZE_EXT = GLenum::GL_PROGRAM_POINT_SIZE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_TWO_SIDE = GLenum::GL_VERTEX_PROGRAM_TWO_SIDE;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_TWO_SIDE_ARB = GLenum::GL_VERTEX_PROGRAM_TWO_SIDE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_TWO_SIDE_NV = GLenum::GL_VERTEX_PROGRAM_TWO_SIDE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_ATTRIB_ARRAY_POINTER_NV = GLenum::GL_ATTRIB_ARRAY_POINTER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_TARGET_NV = GLenum::GL_PROGRAM_TARGET_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_RESIDENT_NV = GLenum::GL_PROGRAM_RESIDENT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRACK_MATRIX_NV = GLenum::GL_TRACK_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TRACK_MATRIX_TRANSFORM_NV = GLenum::GL_TRACK_MATRIX_TRANSFORM_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_PROGRAM_BINDING_NV = GLenum::GL_VERTEX_PROGRAM_BINDING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_ERROR_POSITION_ARB = GLenum::GL_PROGRAM_ERROR_POSITION_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_ERROR_POSITION_NV = GLenum::GL_PROGRAM_ERROR_POSITION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_RECTANGLE_NV = GLenum::GL_OFFSET_TEXTURE_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = GLenum::GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = GLenum::GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPTH_CLAMP_NV = GLenum::GL_DEPTH_CLAMP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY0_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY1_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY2_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY3_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY4_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY5_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY5_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY6_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY6_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY7_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY7_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY8_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY9_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY9_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY10_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY10_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY11_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY11_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY12_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY12_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY13_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY13_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY14_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY14_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_ATTRIB_ARRAY15_NV = GLenum::GL_VERTEX_ATTRIB_ARRAY15_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB0_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB0_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB1_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB1_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB2_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB2_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB3_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB3_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB4_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB4_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB5_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB5_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB6_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB6_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB7_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB7_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB8_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB8_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB9_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB9_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB10_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB10_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB11_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB11_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB12_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB12_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB13_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB13_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB14_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB14_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP1_VERTEX_ATTRIB15_4_NV = GLenum::GL_MAP1_VERTEX_ATTRIB15_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB0_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB0_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB1_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB1_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB2_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB2_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB3_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB3_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB4_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB4_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB5_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB5_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB6_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB6_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB7_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB7_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINDING_ARB = GLenum::GL_PROGRAM_BINDING_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB8_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB8_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB9_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB9_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB10_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB10_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB11_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB11_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB12_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB12_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB13_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB13_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB14_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB14_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAP2_VERTEX_ATTRIB15_4_NV = GLenum::GL_MAP2_VERTEX_ATTRIB15_4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_IMAGE_SIZE = GLenum::GL_TEXTURE_COMPRESSED_IMAGE_SIZE;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = GLenum::GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_COMPRESSED_ARB = GLenum::GL_TEXTURE_COMPRESSED_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = GLenum::GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_TEXTURE_FORMATS_ARB = GLenum::GL_COMPRESSED_TEXTURE_FORMATS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_UNITS_ARB = GLenum::GL_MAX_VERTEX_UNITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_ACTIVE_VERTEX_UNITS_ARB = GLenum::GL_ACTIVE_VERTEX_UNITS_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_SUM_UNITY_ARB = GLenum::GL_WEIGHT_SUM_UNITY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_BLEND_ARB = GLenum::GL_VERTEX_BLEND_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_CURRENT_WEIGHT_ARB = GLenum::GL_CURRENT_WEIGHT_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_TYPE_ARB = GLenum::GL_WEIGHT_ARRAY_TYPE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_STRIDE_ARB = GLenum::GL_WEIGHT_ARRAY_STRIDE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_SIZE_ARB = GLenum::GL_WEIGHT_ARRAY_SIZE_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_POINTER_ARB = GLenum::GL_WEIGHT_ARRAY_POINTER_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_WEIGHT_ARRAY_ARB = GLenum::GL_WEIGHT_ARRAY_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGB = GLenum::GL_DOT3_RGB;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGB_ARB = GLenum::GL_DOT3_RGB_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGBA = GLenum::GL_DOT3_RGBA;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGBA_ARB = GLenum::GL_DOT3_RGBA_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGB_FXT1_3DFX = GLenum::GL_COMPRESSED_RGB_FXT1_3DFX;
GLBINDING_CONSTEXPR static const GLenum GL_COMPRESSED_RGBA_FXT1_3DFX = GLenum::GL_COMPRESSED_RGBA_FXT1_3DFX;
GLBINDING_CONSTEXPR static const GLenum GL_MULTISAMPLE_3DFX = GLenum::GL_MULTISAMPLE_3DFX;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLE_BUFFERS_3DFX = GLenum::GL_SAMPLE_BUFFERS_3DFX;
GLBINDING_CONSTEXPR static const GLenum GL_SAMPLES_3DFX = GLenum::GL_SAMPLES_3DFX;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_FRACTIONAL_TESSELLATION_NV = GLenum::GL_EVAL_FRACTIONAL_TESSELLATION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB0_NV = GLenum::GL_EVAL_VERTEX_ATTRIB0_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB1_NV = GLenum::GL_EVAL_VERTEX_ATTRIB1_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB2_NV = GLenum::GL_EVAL_VERTEX_ATTRIB2_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB3_NV = GLenum::GL_EVAL_VERTEX_ATTRIB3_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB4_NV = GLenum::GL_EVAL_VERTEX_ATTRIB4_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB5_NV = GLenum::GL_EVAL_VERTEX_ATTRIB5_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB6_NV = GLenum::GL_EVAL_VERTEX_ATTRIB6_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB7_NV = GLenum::GL_EVAL_VERTEX_ATTRIB7_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB8_NV = GLenum::GL_EVAL_VERTEX_ATTRIB8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB9_NV = GLenum::GL_EVAL_VERTEX_ATTRIB9_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB10_NV = GLenum::GL_EVAL_VERTEX_ATTRIB10_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB11_NV = GLenum::GL_EVAL_VERTEX_ATTRIB11_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB12_NV = GLenum::GL_EVAL_VERTEX_ATTRIB12_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB13_NV = GLenum::GL_EVAL_VERTEX_ATTRIB13_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB14_NV = GLenum::GL_EVAL_VERTEX_ATTRIB14_NV;
GLBINDING_CONSTEXPR static const GLenum GL_EVAL_VERTEX_ATTRIB15_NV = GLenum::GL_EVAL_VERTEX_ATTRIB15_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_MAP_TESSELLATION_NV = GLenum::GL_MAX_MAP_TESSELLATION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_RATIONAL_EVAL_ORDER_NV = GLenum::GL_MAX_RATIONAL_EVAL_ORDER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_PROGRAM_PATCH_ATTRIBS_NV = GLenum::GL_MAX_PROGRAM_PATCH_ATTRIBS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = GLenum::GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_S8_S8_8_8_NV = GLenum::GL_UNSIGNED_INT_S8_S8_8_8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_UNSIGNED_INT_8_8_S8_S8_REV_NV = GLenum::GL_UNSIGNED_INT_8_8_S8_S8_REV_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT_MAG_INTENSITY_NV = GLenum::GL_DSDT_MAG_INTENSITY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_CONSISTENT_NV = GLenum::GL_SHADER_CONSISTENT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_SHADER_NV = GLenum::GL_TEXTURE_SHADER_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SHADER_OPERATION_NV = GLenum::GL_SHADER_OPERATION_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_MODES_NV = GLenum::GL_CULL_MODES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_MATRIX_NV = GLenum::GL_OFFSET_TEXTURE_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_2D_MATRIX_NV = GLenum::GL_OFFSET_TEXTURE_2D_MATRIX_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_SCALE_NV = GLenum::GL_OFFSET_TEXTURE_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_2D_SCALE_NV = GLenum::GL_OFFSET_TEXTURE_2D_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_BIAS_NV = GLenum::GL_OFFSET_TEXTURE_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_2D_BIAS_NV = GLenum::GL_OFFSET_TEXTURE_2D_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PREVIOUS_TEXTURE_INPUT_NV = GLenum::GL_PREVIOUS_TEXTURE_INPUT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CONST_EYE_NV = GLenum::GL_CONST_EYE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_PASS_THROUGH_NV = GLenum::GL_PASS_THROUGH_NV;
GLBINDING_CONSTEXPR static const GLenum GL_CULL_FRAGMENT_NV = GLenum::GL_CULL_FRAGMENT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_OFFSET_TEXTURE_2D_NV = GLenum::GL_OFFSET_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPENDENT_AR_TEXTURE_2D_NV = GLenum::GL_DEPENDENT_AR_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DEPENDENT_GB_TEXTURE_2D_NV = GLenum::GL_DEPENDENT_GB_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SURFACE_STATE_NV = GLenum::GL_SURFACE_STATE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_NV = GLenum::GL_DOT_PRODUCT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_DEPTH_REPLACE_NV = GLenum::GL_DOT_PRODUCT_DEPTH_REPLACE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_TEXTURE_2D_NV = GLenum::GL_DOT_PRODUCT_TEXTURE_2D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_TEXTURE_3D_NV = GLenum::GL_DOT_PRODUCT_TEXTURE_3D_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = GLenum::GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = GLenum::GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = GLenum::GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = GLenum::GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HILO_NV = GLenum::GL_HILO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT_NV = GLenum::GL_DSDT_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT_MAG_NV = GLenum::GL_DSDT_MAG_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT_MAG_VIB_NV = GLenum::GL_DSDT_MAG_VIB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HILO16_NV = GLenum::GL_HILO16_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_HILO_NV = GLenum::GL_SIGNED_HILO_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_HILO16_NV = GLenum::GL_SIGNED_HILO16_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGBA_NV = GLenum::GL_SIGNED_RGBA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGBA8_NV = GLenum::GL_SIGNED_RGBA8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SURFACE_REGISTERED_NV = GLenum::GL_SURFACE_REGISTERED_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGB_NV = GLenum::GL_SIGNED_RGB_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGB8_NV = GLenum::GL_SIGNED_RGB8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SURFACE_MAPPED_NV = GLenum::GL_SURFACE_MAPPED_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_LUMINANCE_NV = GLenum::GL_SIGNED_LUMINANCE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_LUMINANCE8_NV = GLenum::GL_SIGNED_LUMINANCE8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_LUMINANCE_ALPHA_NV = GLenum::GL_SIGNED_LUMINANCE_ALPHA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_LUMINANCE8_ALPHA8_NV = GLenum::GL_SIGNED_LUMINANCE8_ALPHA8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_ALPHA_NV = GLenum::GL_SIGNED_ALPHA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_ALPHA8_NV = GLenum::GL_SIGNED_ALPHA8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_INTENSITY_NV = GLenum::GL_SIGNED_INTENSITY_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_INTENSITY8_NV = GLenum::GL_SIGNED_INTENSITY8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT8_NV = GLenum::GL_DSDT8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT8_MAG8_NV = GLenum::GL_DSDT8_MAG8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DSDT8_MAG8_INTENSITY8_NV = GLenum::GL_DSDT8_MAG8_INTENSITY8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGB_UNSIGNED_ALPHA_NV = GLenum::GL_SIGNED_RGB_UNSIGNED_ALPHA_NV;
GLBINDING_CONSTEXPR static const GLenum GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = GLenum::GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HI_SCALE_NV = GLenum::GL_HI_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LO_SCALE_NV = GLenum::GL_LO_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DS_SCALE_NV = GLenum::GL_DS_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DT_SCALE_NV = GLenum::GL_DT_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAGNITUDE_SCALE_NV = GLenum::GL_MAGNITUDE_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VIBRANCE_SCALE_NV = GLenum::GL_VIBRANCE_SCALE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_HI_BIAS_NV = GLenum::GL_HI_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_LO_BIAS_NV = GLenum::GL_LO_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DS_BIAS_NV = GLenum::GL_DS_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_DT_BIAS_NV = GLenum::GL_DT_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MAGNITUDE_BIAS_NV = GLenum::GL_MAGNITUDE_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_VIBRANCE_BIAS_NV = GLenum::GL_VIBRANCE_BIAS_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_BORDER_VALUES_NV = GLenum::GL_TEXTURE_BORDER_VALUES_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_HI_SIZE_NV = GLenum::GL_TEXTURE_HI_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_LO_SIZE_NV = GLenum::GL_TEXTURE_LO_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DS_SIZE_NV = GLenum::GL_TEXTURE_DS_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_DT_SIZE_NV = GLenum::GL_TEXTURE_DT_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_MAG_SIZE_NV = GLenum::GL_TEXTURE_MAG_SIZE_NV;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW2_ARB = GLenum::GL_MODELVIEW2_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW3_ARB = GLenum::GL_MODELVIEW3_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW4_ARB = GLenum::GL_MODELVIEW4_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW5_ARB = GLenum::GL_MODELVIEW5_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW6_ARB = GLenum::GL_MODELVIEW6_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW7_ARB = GLenum::GL_MODELVIEW7_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW8_ARB = GLenum::GL_MODELVIEW8_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW9_ARB = GLenum::GL_MODELVIEW9_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW10_ARB = GLenum::GL_MODELVIEW10_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW11_ARB = GLenum::GL_MODELVIEW11_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW12_ARB = GLenum::GL_MODELVIEW12_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW13_ARB = GLenum::GL_MODELVIEW13_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW14_ARB = GLenum::GL_MODELVIEW14_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW15_ARB = GLenum::GL_MODELVIEW15_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW16_ARB = GLenum::GL_MODELVIEW16_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW17_ARB = GLenum::GL_MODELVIEW17_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW18_ARB = GLenum::GL_MODELVIEW18_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW19_ARB = GLenum::GL_MODELVIEW19_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW20_ARB = GLenum::GL_MODELVIEW20_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW21_ARB = GLenum::GL_MODELVIEW21_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW22_ARB = GLenum::GL_MODELVIEW22_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW23_ARB = GLenum::GL_MODELVIEW23_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW24_ARB = GLenum::GL_MODELVIEW24_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW25_ARB = GLenum::GL_MODELVIEW25_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW26_ARB = GLenum::GL_MODELVIEW26_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW27_ARB = GLenum::GL_MODELVIEW27_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW28_ARB = GLenum::GL_MODELVIEW28_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW29_ARB = GLenum::GL_MODELVIEW29_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW30_ARB = GLenum::GL_MODELVIEW30_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_MODELVIEW31_ARB = GLenum::GL_MODELVIEW31_ARB;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGB_EXT = GLenum::GL_DOT3_RGB_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_DOT3_RGBA_EXT = GLenum::GL_DOT3_RGBA_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_ATI = GLenum::GL_MIRROR_CLAMP_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_EXT = GLenum::GL_MIRROR_CLAMP_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_TO_EDGE = GLenum::GL_MIRROR_CLAMP_TO_EDGE;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_TO_EDGE_ATI = GLenum::GL_MIRROR_CLAMP_TO_EDGE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MIRROR_CLAMP_TO_EDGE_EXT = GLenum::GL_MIRROR_CLAMP_TO_EDGE_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MODULATE_ADD_ATI = GLenum::GL_MODULATE_ADD_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MODULATE_SIGNED_ADD_ATI = GLenum::GL_MODULATE_SIGNED_ADD_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MODULATE_SUBTRACT_ATI = GLenum::GL_MODULATE_SUBTRACT_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_SET_AMD = GLenum::GL_SET_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_REPLACE_VALUE_AMD = GLenum::GL_REPLACE_VALUE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_OP_VALUE_AMD = GLenum::GL_STENCIL_OP_VALUE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_STENCIL_BACK_OP_VALUE_AMD = GLenum::GL_STENCIL_BACK_OP_VALUE_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_OCCLUSION_QUERY_EVENT_MASK_AMD = GLenum::GL_OCCLUSION_QUERY_EVENT_MASK_AMD;
GLBINDING_CONSTEXPR static const GLenum GL_YCBCR_MESA = GLenum::GL_YCBCR_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_PACK_INVERT_MESA = GLenum::GL_PACK_INVERT_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D_STACK_MESAX = GLenum::GL_TEXTURE_1D_STACK_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_STACK_MESAX = GLenum::GL_TEXTURE_2D_STACK_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_1D_STACK_MESAX = GLenum::GL_PROXY_TEXTURE_1D_STACK_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_PROXY_TEXTURE_2D_STACK_MESAX = GLenum::GL_PROXY_TEXTURE_2D_STACK_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_1D_STACK_BINDING_MESAX = GLenum::GL_TEXTURE_1D_STACK_BINDING_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_TEXTURE_2D_STACK_BINDING_MESAX = GLenum::GL_TEXTURE_2D_STACK_BINDING_MESAX;
GLBINDING_CONSTEXPR static const GLenum GL_PROGRAM_BINARY_FORMAT_MESA = GLenum::GL_PROGRAM_BINARY_FORMAT_MESA;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_OBJECT_BUFFER_ATI = GLenum::GL_ARRAY_OBJECT_BUFFER_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ARRAY_OBJECT_OFFSET_ATI = GLenum::GL_ARRAY_OBJECT_OFFSET_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_ATI = GLenum::GL_ELEMENT_ARRAY_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_TYPE_ATI = GLenum::GL_ELEMENT_ARRAY_TYPE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_ELEMENT_ARRAY_POINTER_ATI = GLenum::GL_ELEMENT_ARRAY_POINTER_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_STREAMS_ATI = GLenum::GL_MAX_VERTEX_STREAMS_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SOURCE_ATI = GLenum::GL_VERTEX_SOURCE_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DUDV_ATI = GLenum::GL_DUDV_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_DU8DV8_ATI = GLenum::GL_DU8DV8_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_ENVMAP_ATI = GLenum::GL_BUMP_ENVMAP_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_BUMP_TARGET_ATI = GLenum::GL_BUMP_TARGET_ATI;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_EXT = GLenum::GL_VERTEX_SHADER_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_VERTEX_SHADER_BINDING_EXT = GLenum::GL_VERTEX_SHADER_BINDING_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_VERTEX_EXT = GLenum::GL_OUTPUT_VERTEX_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_COLOR0_EXT = GLenum::GL_OUTPUT_COLOR0_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_COLOR1_EXT = GLenum::GL_OUTPUT_COLOR1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD0_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD0_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD1_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD1_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD2_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD2_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD3_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD3_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD4_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD4_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD5_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD5_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD6_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD6_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD7_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD7_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD8_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD8_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD9_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD9_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD10_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD10_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD11_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD11_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD12_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD12_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD13_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD13_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD14_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD14_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD15_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD15_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD16_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD16_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD17_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD17_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD18_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD18_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD19_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD19_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD20_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD20_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD21_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD21_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD22_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD22_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD23_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD23_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD24_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD24_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD25_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD25_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD26_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD26_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD27_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD27_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD28_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD28_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD29_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD29_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD30_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD30_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_TEXTURE_COORD31_EXT = GLenum::GL_OUTPUT_TEXTURE_COORD31_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_OUTPUT_FOG_EXT = GLenum::GL_OUTPUT_FOG_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT = GLenum::GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_SHADER_VARIANTS_EXT = GLenum::GL_MAX_VERTEX_SHADER_VARIANTS_EXT;
GLBINDING_CONSTEXPR static const GLenum GL_MAX_VERTEX_SHADER_INVARIANTS_EXT = GLenum::GL_MAX_VERTEX_SHADER_IN