/*******************************************************************************
* Copyright 2003-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!    vdRngCauchy  Example Program Text
!******************************************************************************/

#include <stdio.h>

#include "mkl_vsl.h"
#include "errcheck.inc"

#define SEED    777
#define BRNG    VSL_BRNG_R250
#define METHOD  VSL_RNG_METHOD_CAUCHY_ICDF
#define N       1000
#define NN      10

int main(void)
{
    double r[N];
    VSLStreamStatePtr stream;
    int i, errcode = VSL_ERROR_OK, status = 0;
    double a = 0.0, beta = 1.0;

    /***** Initialize *****/
    errcode = vslNewStream( &stream, BRNG,  SEED );
    CheckVslError( errcode );

    /***** Call RNG *****/
    errcode = vdRngCauchy( METHOD, stream, N, r, a, beta );
    CheckVslError( errcode );

    /***** Printing results *****/
    printf("Sample of vdRngCauchy.\n");
    printf("----------------------\n\n");
    printf("Parameters:\n");
    printf("    a=%.4f\n",a);
    printf("    beta=%.4f\n\n",beta);

    printf("Results (first 10 of 1000):\n");
    printf("---------------------------\n");
    for( i = 0; i < NN; i++ )
    {
        printf("r[%d]=%.4f\n",i,r[i]);
    }

    printf("\n");

    /***** Deinitialize *****/
    errcode = vslDeleteStream( &stream );
    CheckVslError( errcode );

    return status;
}
