/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Lines;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java2d.Surface;

public class Dash
extends Surface {
    public Dash() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        FontRenderContext frc = g2.getFontRenderContext();
        Font font = g2.getFont();
        TextLayout tl = new TextLayout("Dashes", font, frc);
        float sw = (float)tl.getBounds().getWidth();
        float sh = tl.getAscent() + tl.getDescent();
        g2.setColor(Color.BLACK);
        tl.draw(g2, (float)(w / 2) - sw / 2.0f, sh + 5.0f);
        BasicStroke dotted = new BasicStroke(3.0f, 1, 1, 0.0f, new float[]{0.0f, 6.0f, 0.0f, 6.0f}, 0.0f);
        g2.setStroke(dotted);
        g2.drawRect(3, 3, w - 6, h - 6);
        int x = 0;
        int y = h - 34;
        BasicStroke[] bs = new BasicStroke[6];
        float j = 1.1f;
        int i = 0;
        while (i < bs.length) {
            float[] dash = new float[]{j};
            BasicStroke b = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
            g2.setStroke(b);
            g2.drawLine(20, y, w - 20, y);
            bs[i] = new BasicStroke(3.0f, 0, 0, 10.0f, dash, 0.0f);
            y += 5;
            ++i;
            j += 1.0f;
        }
        Shape shape = null;
        y = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            x = i2 == 0 || i2 == 3 ? (w / 3 - w / 5) / 2 : x + w / 3;
            y = i2 <= 2 ? (int)sh + h / 12 : h / 2;
            g2.setStroke(bs[i2]);
            g2.translate(x, y);
            switch (i2) {
                case 0: {
                    shape = new Arc2D.Float(0.0f, 0.0f, w / 5, h / 4, 45.0f, 270.0f, 2);
                    break;
                }
                case 1: {
                    shape = new Ellipse2D.Float(0.0f, 0.0f, w / 5, h / 4);
                    break;
                }
                case 2: {
                    shape = new RoundRectangle2D.Float(0.0f, 0.0f, w / 5, h / 4, 10.0f, 10.0f);
                    break;
                }
                case 3: {
                    shape = new Rectangle2D.Float(0.0f, 0.0f, w / 5, h / 4);
                    break;
                }
                case 4: {
                    shape = new QuadCurve2D.Float(0.0f, 0.0f, w / 10, h / 2, w / 5, 0.0f);
                    break;
                }
                case 5: {
                    shape = new CubicCurve2D.Float(0.0f, 0.0f, w / 15, h / 2, w / 10, h / 4, w / 5, 0.0f);
                }
            }
            g2.draw(shape);
            g2.translate(-x, -y);
        }
    }

    public static void main(String[] argv) {
        Dash.createDemoFrame(new Dash());
    }
}

