/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.management.OperatingSystemMXBean;
import java.awt.BorderLayout;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.HTMLPane;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;

class SummaryTab
extends Tab {
    private static final String cpuUsageKey = "cpu";
    private static final String newDivider = "<tr><td colspan=4><font size =-1><hr>";
    private static final String newTable = "<tr><td colspan=4 align=left><table cellpadding=1>";
    private static final String newLeftTable = "<tr><td colspan=2 align=left><table cellpadding=1>";
    private static final String newRightTable = "<td colspan=2 align=left><table cellpadding=1>";
    private static final String endTable = "</table>";
    private static final int CPU_DECIMALS = 1;
    private CPUOverviewPanel overviewPanel;
    private DateFormat headerDateTimeFormat;
    private String pathSeparator = null;
    HTMLPane info;
    StringBuilder buf;

    public static String getTabName() {
        return Messages.SUMMARY_TAB_TAB_NAME;
    }

    public SummaryTab(VMPanel vmPanel) {
        super(vmPanel, SummaryTab.getTabName());
        this.setLayout(new BorderLayout());
        this.info = new HTMLPane();
        Utilities.setAccessibleName(this.info, SummaryTab.getTabName());
        this.add(new JScrollPane(this.info));
        this.headerDateTimeFormat = Formatter.getDateTimeFormat(Messages.SUMMARY_TAB_HEADER_DATE_TIME_FORMAT);
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return new SwingWorker<Result, Object>(){

            @Override
            public Result doInBackground() {
                return SummaryTab.this.formatSummary();
            }

            @Override
            protected void done() {
                block5: {
                    try {
                        Result result = (Result)this.get();
                        if (result != null) {
                            SummaryTab.this.info.setText(result.summary);
                            if (SummaryTab.this.overviewPanel != null && result.upTime > 0L && result.processCpuTime >= 0L) {
                                SummaryTab.this.overviewPanel.updateCPUInfo(result);
                            }
                        }
                    }
                    catch (InterruptedException result) {
                    }
                    catch (ExecutionException ex) {
                        if (!JConsole.isDebug()) break block5;
                        ex.printStackTrace();
                    }
                }
            }
        };
    }

    synchronized Result formatSummary() {
        Result result = new Result();
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (proxyClient.isDead()) {
            return null;
        }
        this.buf = new StringBuilder();
        this.append("<table cellpadding=1>");
        try {
            RuntimeMXBean rmBean = proxyClient.getRuntimeMXBean();
            CompilationMXBean cmpMBean = proxyClient.getCompilationMXBean();
            ThreadMXBean tmBean = proxyClient.getThreadMXBean();
            MemoryMXBean memoryBean = proxyClient.getMemoryMXBean();
            ClassLoadingMXBean clMBean = proxyClient.getClassLoadingMXBean();
            java.lang.management.OperatingSystemMXBean osMBean = proxyClient.getOperatingSystemMXBean();
            OperatingSystemMXBean sunOSMBean = proxyClient.getSunOperatingSystemMXBean();
            this.append("<tr><td colspan=4>");
            this.append("<center><b>" + Messages.SUMMARY_TAB_TAB_NAME + "</b></center>");
            String dateTime = this.headerDateTimeFormat.format(System.currentTimeMillis());
            this.append("<center>" + dateTime + "</center>");
            this.append(newDivider);
            this.append(newLeftTable);
            this.append(Messages.CONNECTION_NAME, this.vmPanel.getDisplayName());
            this.append(Messages.VIRTUAL_MACHINE, Resources.format(Messages.SUMMARY_TAB_VM_VERSION, rmBean.getVmName(), rmBean.getVmVersion()));
            this.append(Messages.VENDOR, rmBean.getVmVendor());
            this.append(Messages.NAME, rmBean.getName());
            this.append(endTable);
            this.append(newRightTable);
            result.upTime = rmBean.getUptime();
            this.append(Messages.UPTIME, Formatter.formatTime(result.upTime));
            if (sunOSMBean != null) {
                result.processCpuTime = sunOSMBean.getProcessCpuTime();
                this.append(Messages.PROCESS_CPU_TIME, Formatter.formatNanoTime(result.processCpuTime));
            }
            if (cmpMBean != null) {
                this.append(Messages.JIT_COMPILER, cmpMBean.getName());
                this.append(Messages.TOTAL_COMPILE_TIME, cmpMBean.isCompilationTimeMonitoringSupported() ? Formatter.formatTime(cmpMBean.getTotalCompilationTime()) : Messages.UNAVAILABLE);
            } else {
                this.append(Messages.JIT_COMPILER, Messages.UNAVAILABLE);
            }
            this.append(endTable);
            this.append(newDivider);
            this.append(newLeftTable);
            int tlCount = tmBean.getThreadCount();
            int tdCount = tmBean.getDaemonThreadCount();
            int tpCount = tmBean.getPeakThreadCount();
            long ttCount = tmBean.getTotalStartedThreadCount();
            String[] strings1 = Formatter.formatLongs(tlCount, tpCount, tdCount, ttCount);
            this.append(Messages.LIVE_THREADS, strings1[0]);
            this.append(Messages.PEAK, strings1[1]);
            this.append(Messages.DAEMON_THREADS, strings1[2]);
            this.append(Messages.TOTAL_THREADS_STARTED, strings1[3]);
            this.append(endTable);
            this.append(newRightTable);
            long clCount = clMBean.getLoadedClassCount();
            long cuCount = clMBean.getUnloadedClassCount();
            long ctCount = clMBean.getTotalLoadedClassCount();
            String[] strings2 = Formatter.formatLongs(clCount, cuCount, ctCount);
            this.append(Messages.CURRENT_CLASSES_LOADED, strings2[0]);
            this.append(Messages.TOTAL_CLASSES_LOADED, strings2[2]);
            this.append(Messages.TOTAL_CLASSES_UNLOADED, strings2[1]);
            this.append(null, "");
            this.append(endTable);
            this.append(newDivider);
            MemoryUsage u = memoryBean.getHeapMemoryUsage();
            this.append(newLeftTable);
            String[] strings12 = Formatter.formatKByteStrings(u.getUsed(), u.getMax());
            this.append(Messages.CURRENT_HEAP_SIZE, strings12[0]);
            this.append(Messages.MAXIMUM_HEAP_SIZE, strings12[1]);
            this.append(endTable);
            this.append(newRightTable);
            String[] strings22 = Formatter.formatKByteStrings(u.getCommitted());
            this.append(Messages.COMMITTED_MEMORY, strings22[0]);
            this.append(Messages.SUMMARY_TAB_PENDING_FINALIZATION_LABEL, Resources.format(Messages.SUMMARY_TAB_PENDING_FINALIZATION_VALUE, memoryBean.getObjectPendingFinalizationCount()));
            this.append(endTable);
            this.append(newTable);
            Collection<GarbageCollectorMXBean> garbageCollectors = proxyClient.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMBean : garbageCollectors) {
                String gcName = garbageCollectorMBean.getName();
                long gcCount = garbageCollectorMBean.getCollectionCount();
                long gcTime = garbageCollectorMBean.getCollectionTime();
                this.append(Messages.GARBAGE_COLLECTOR, Resources.format(Messages.GC_INFO, gcName, gcCount, gcTime >= 0L ? Formatter.formatTime(gcTime) : Messages.UNAVAILABLE), 4);
            }
            this.append(endTable);
            this.append(newDivider);
            this.append(newLeftTable);
            String osName = osMBean.getName();
            String osVersion = osMBean.getVersion();
            String osArch = osMBean.getArch();
            result.nCPUs = osMBean.getAvailableProcessors();
            this.append(Messages.OPERATING_SYSTEM, osName + " " + osVersion);
            this.append(Messages.ARCHITECTURE, osArch);
            this.append(Messages.NUMBER_OF_PROCESSORS, result.nCPUs + "");
            if (this.pathSeparator == null) {
                String string = this.pathSeparator = osName.startsWith("Windows ") ? ";" : ":";
            }
            if (sunOSMBean != null) {
                String[] kbStrings1 = Formatter.formatKByteStrings(sunOSMBean.getCommittedVirtualMemorySize());
                String[] kbStrings2 = Formatter.formatKByteStrings(sunOSMBean.getTotalPhysicalMemorySize(), sunOSMBean.getFreePhysicalMemorySize(), sunOSMBean.getTotalSwapSpaceSize(), sunOSMBean.getFreeSwapSpaceSize());
                this.append(Messages.COMMITTED_VIRTUAL_MEMORY, kbStrings1[0]);
                this.append(endTable);
                this.append(newRightTable);
                this.append(Messages.TOTAL_PHYSICAL_MEMORY, kbStrings2[0]);
                this.append(Messages.FREE_PHYSICAL_MEMORY, kbStrings2[1]);
                this.append(Messages.TOTAL_SWAP_SPACE, kbStrings2[2]);
                this.append(Messages.FREE_SWAP_SPACE, kbStrings2[3]);
            }
            this.append(endTable);
            this.append(newDivider);
            this.append(newTable);
            String args = "";
            List<String> inputArguments = rmBean.getInputArguments();
            for (String arg : inputArguments) {
                args = args + arg + " ";
            }
            this.append(Messages.VM_ARGUMENTS, args, 4);
            this.append(Messages.CLASS_PATH, rmBean.getClassPath(), 4);
            this.append(Messages.LIBRARY_PATH, rmBean.getLibraryPath(), 4);
            this.append(Messages.BOOT_CLASS_PATH, rmBean.isBootClassPathSupported() ? rmBean.getBootClassPath() : Messages.UNAVAILABLE, 4);
            this.append(endTable);
        }
        catch (IOException e) {
            if (JConsole.isDebug()) {
                e.printStackTrace();
            }
            proxyClient.markAsDead();
            return null;
        }
        catch (UndeclaredThrowableException e) {
            if (JConsole.isDebug()) {
                e.printStackTrace();
            }
            proxyClient.markAsDead();
            return null;
        }
        this.append(endTable);
        result.timeStamp = System.currentTimeMillis();
        result.summary = this.buf.toString();
        return result;
    }

    private synchronized void append(String str) {
        this.buf.append(str);
    }

    void append(String label, String value) {
        this.append(Formatter.newRow(label, value));
    }

    private void append(String label, String value, int columnPerRow) {
        if (columnPerRow == 4 && this.pathSeparator != null) {
            value = value.replace(this.pathSeparator, "<b></b>" + this.pathSeparator);
        }
        this.append(Formatter.newRow(label, value, columnPerRow));
    }

    @Override
    OverviewPanel[] getOverviewPanels() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new CPUOverviewPanel();
        }
        return new OverviewPanel[]{this.overviewPanel};
    }

    private static class CPUOverviewPanel
    extends OverviewPanel {
        private long prevUpTime;
        private long prevProcessCpuTime;

        CPUOverviewPanel() {
            super(Messages.CPU_USAGE, SummaryTab.cpuUsageKey, Messages.CPU_USAGE, Plotter.Unit.PERCENT);
            this.getPlotter().setDecimals(1);
        }

        public void updateCPUInfo(Result result) {
            if (this.prevUpTime > 0L && result.upTime > this.prevUpTime) {
                long elapsedCpu = result.processCpuTime - this.prevProcessCpuTime;
                long elapsedTime = result.upTime - this.prevUpTime;
                float cpuUsage = Math.min(99.0f, (float)elapsedCpu / ((float)elapsedTime * 10000.0f * (float)result.nCPUs));
                this.getPlotter().addValues(result.timeStamp, Math.round((double)cpuUsage * Math.pow(10.0, 1.0)));
                this.getInfoLabel().setText(Resources.format(Messages.CPU_USAGE_FORMAT, String.format("%.1f", Float.valueOf(cpuUsage))));
            }
            this.prevUpTime = result.upTime;
            this.prevProcessCpuTime = result.processCpuTime;
        }
    }

    private static class Result {
        long upTime = -1L;
        long processCpuTime = -1L;
        long timeStamp;
        int nCPUs;
        String summary;

        private Result() {
        }
    }
}

