/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.vector;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.josm.data.IQuadBucketType;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.vectortile.VectorTile;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Feature;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.GeometryTypes;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Layer;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.UniqueIdGenerator;
import org.openstreetmap.josm.data.vector.DataStore;
import org.openstreetmap.josm.data.vector.VectorNode;
import org.openstreetmap.josm.data.vector.VectorPrimitive;
import org.openstreetmap.josm.data.vector.VectorRelation;
import org.openstreetmap.josm.data.vector.VectorRelationMember;
import org.openstreetmap.josm.data.vector.VectorWay;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class VectorDataStore
extends DataStore<VectorPrimitive, VectorNode, VectorWay, VectorRelation>
implements Destroyable {
    private static final String JOSM_MERGE_TYPE_KEY = "josm_merge_type";
    private static final String ORIGINAL_ID = "original_id";
    private static final String MULTIPOLYGON_TYPE = "multipolygon";
    private static final String RELATION_TYPE = "type";

    @Override
    protected void addPrimitive(VectorPrimitive primitive) {
        if (primitive.getUniqueId() == 0L) {
            long id;
            UniqueIdGenerator generator = primitive.getIdGenerator();
            while (this.primitivesMap.containsKey(new SimplePrimitiveId(id = generator.generateUniqueId(), primitive.getType()))) {
            }
            primitive.setId(primitive.getIdGenerator().generateUniqueId());
        }
        if (primitive instanceof VectorRelation && !primitive.isMultipolygon()) {
            primitive = VectorDataStore.mergeWays((VectorRelation)primitive);
        }
        VectorPrimitive alreadyAdded = (VectorPrimitive)this.primitivesMap.get(primitive.getPrimitiveId());
        VectorRelation mergedRelation = (VectorRelation)this.primitivesMap.get(new SimplePrimitiveId(primitive.getPrimitiveId().getUniqueId(), OsmPrimitiveType.RELATION));
        if (alreadyAdded == null || alreadyAdded.equals(primitive)) {
            super.addPrimitive(primitive);
        } else if (mergedRelation != null && mergedRelation.get(JOSM_MERGE_TYPE_KEY) != null) {
            mergedRelation.addRelationMember(new VectorRelationMember("", primitive));
            super.addPrimitive(primitive);
            if (mergedRelation.getMemberPrimitivesList().stream().allMatch(IWay.class::isInstance)) {
                VectorDataStore.mergeWays(mergedRelation);
            } else if (!(primitive instanceof IWay)) {
                mergedRelation.remove(JOSM_MERGE_TYPE_KEY);
            }
        } else if (mergedRelation != null && primitive instanceof VectorRelation) {
            ((VectorRelation)primitive).getMembers().forEach(mergedRelation::addRelationMember);
        } else if (alreadyAdded instanceof VectorWay && primitive instanceof VectorWay) {
            VectorRelation temporaryRelation;
            VectorRelation vectorRelation = temporaryRelation = mergedRelation == null ? new VectorRelation(primitive.getLayer()) : mergedRelation;
            if (mergedRelation == null) {
                temporaryRelation.put(JOSM_MERGE_TYPE_KEY, "merge");
                temporaryRelation.addRelationMember(new VectorRelationMember("", alreadyAdded));
            }
            temporaryRelation.addRelationMember(new VectorRelationMember("", primitive));
            super.addPrimitive(primitive);
            super.addPrimitive(temporaryRelation);
        }
    }

    private static VectorPrimitive mergeWays(VectorRelation relation) {
        List<VectorRelationMember> members = RelationSorter.sortMembersByConnectivity(relation.getMembers());
        Collection relationWayList = members.stream().map(VectorRelationMember::getMember).filter(VectorWay.class::isInstance).map(VectorWay.class::cast).collect(Collectors.toCollection(ArrayList::new));
        if (relationWayList.size() != relation.getMemberPrimitivesList().size()) {
            return relation;
        }
        ArrayList<VectorWay> wayList = new ArrayList<VectorWay>(relation.getMembersCount());
        int maxIteration = relationWayList.size();
        for (int iteration = 0; iteration < maxIteration && wayList.size() < relationWayList.size(); ++iteration) {
            for (VectorWay way : relationWayList) {
                if (wayList.isEmpty()) {
                    wayList.add(way);
                    continue;
                }
                if (VectorDataStore.canMergeWays((VectorWay)wayList.get(wayList.size() - 1), way, false)) {
                    wayList.add(way);
                    continue;
                }
                if (!VectorDataStore.canMergeWays((VectorWay)wayList.get(0), way, false)) continue;
                wayList.add(0, way);
            }
            relationWayList.removeIf(wayList::contains);
        }
        return relation;
    }

    private static <N extends INode, W extends IWay<N>> boolean canMergeWays(W old, W toAdd, boolean allowReverse) {
        ArrayList<N> nodes = new ArrayList<N>(old.getNodes());
        boolean added = true;
        if (allowReverse && old.firstNode().equals(toAdd.firstNode())) {
            Collections.reverse(nodes);
            nodes.addAll(toAdd.getNodes());
        } else if (old.firstNode().equals(toAdd.lastNode())) {
            nodes.addAll(0, toAdd.getNodes());
        } else if (old.lastNode().equals(toAdd.firstNode())) {
            nodes.addAll(toAdd.getNodes());
        } else if (allowReverse && old.lastNode().equals(toAdd.lastNode())) {
            ArrayList<N> toAddNodes = new ArrayList<N>(toAdd.getNodes());
            Collections.reverse(toAddNodes);
            nodes.addAll(toAddNodes);
        } else {
            added = false;
        }
        if (added) {
            old.setNodes(nodes);
        }
        return added;
    }

    private synchronized <T extends Tile> VectorNode pointToNode(T tile, Layer layer, Collection<VectorPrimitive> featureObjects, int x, int y) {
        VectorNode node;
        BBox tileBbox;
        if (tile instanceof IQuadBucketType) {
            tileBbox = ((IQuadBucketType)((Object)tile)).getBBox();
        } else {
            ICoordinate upperLeft = tile.getTileSource().tileXYToLatLon(tile);
            ICoordinate lowerRight = tile.getTileSource().tileXYToLatLon(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
            tileBbox = new BBox(upperLeft.getLon(), upperLeft.getLat(), lowerRight.getLon(), lowerRight.getLat());
        }
        int layerExtent = layer.getExtent();
        LatLon coords = new LatLon(tileBbox.getMaxLat() - (tileBbox.getMaxLat() - tileBbox.getMinLat()) * (double)y / (double)layerExtent, tileBbox.getMinLon() + (tileBbox.getMaxLon() - tileBbox.getMinLon()) * (double)x / (double)layerExtent);
        List nodes = this.store.searchNodes(new BBox(coords.lon(), coords.lat(), 1.0E-7f));
        if (!nodes.isEmpty()) {
            VectorNode first = (VectorNode)nodes.iterator().next();
            if (first.isDisabled() || !first.isVisible()) {
                node = new VectorNode(layer.getName());
                node.setCoor(node.getCoor());
                first.getReferrers(true).forEach(primitive -> {
                    if (primitive instanceof VectorWay) {
                        ArrayList<VectorNode> nodeList = new ArrayList<VectorNode>(((VectorWay)primitive).getNodes());
                        nodeList.replaceAll(vnode -> vnode.equals(first) ? node : vnode);
                        ((VectorWay)primitive).setNodes((List<VectorNode>)nodeList);
                    } else if (primitive instanceof VectorRelation) {
                        ArrayList<VectorRelationMember> members = new ArrayList<VectorRelationMember>(((VectorRelation)primitive).getMembers());
                        members.replaceAll(member -> member.getMember().equals(first) ? new VectorRelationMember(member.getRole(), node) : member);
                        ((VectorRelation)primitive).setMembers((List<VectorRelationMember>)members);
                    }
                });
                this.removePrimitive(first);
            } else {
                node = first;
            }
        } else {
            node = new VectorNode(layer.getName());
        }
        node.setCoor(coords);
        featureObjects.add(node);
        return node;
    }

    private <T extends Tile> List<VectorWay> pathToWay(T tile, Layer layer, Collection<VectorPrimitive> featureObjects, Path2D shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        ArrayList<VectorWay> ways = new ArrayList<VectorWay>(Utils.filteredCollection(this.pathIteratorToObjects(tile, layer, featureObjects, pathIterator), VectorWay.class));
        for (VectorWay way : ways) {
            for (VectorNode node : way.getNodes()) {
                if (node.hasKeys() || node.getReferrers(true).size() != 1 || node.getId() > 0L) continue;
                node.setDisabled(true);
                node.setVisible(false);
            }
        }
        return ways;
    }

    private <T extends Tile> List<VectorPrimitive> pathIteratorToObjects(T tile, Layer layer, Collection<VectorPrimitive> featureObjects, PathIterator pathIterator) {
        ArrayList<VectorNode> nodes = new ArrayList<VectorNode>();
        double[] coords = new double[6];
        ArrayList<VectorPrimitive> ways = new ArrayList<VectorPrimitive>();
        do {
            int type = pathIterator.currentSegment(coords);
            pathIterator.next();
            if (!(0 != type && 4 != type || nodes.isEmpty())) {
                if (4 == type) {
                    nodes.add((VectorNode)nodes.get(0));
                }
                if (!nodes.isEmpty()) {
                    VectorWay way = new VectorWay(layer.getName());
                    way.setNodes((List<VectorNode>)nodes);
                    featureObjects.add(way);
                    ways.add(way);
                }
                nodes.clear();
            }
            if (0 == type || 1 == type) {
                VectorNode node = this.pointToNode(tile, layer, featureObjects, (int)coords[0], (int)coords[1]);
                nodes.add(node);
                continue;
            }
            if (4 == type) continue;
            throw new UnsupportedOperationException();
        } while (!pathIterator.isDone());
        if (!nodes.isEmpty()) {
            VectorWay way = new VectorWay(layer.getName());
            way.setNodes((List<VectorNode>)nodes);
            featureObjects.add(way);
            ways.add(way);
        }
        return ways;
    }

    private <T extends Tile> VectorRelation areaToRelation(T tile, Layer layer, Collection<VectorPrimitive> featureObjects, Area area) {
        VectorRelation vectorRelation = new VectorRelation(layer.getName());
        PathIterator pathIterator = area.getPathIterator(null);
        int windingRule = pathIterator.getWindingRule();
        for (VectorPrimitive member : this.pathIteratorToObjects(tile, layer, featureObjects, pathIterator)) {
            String role;
            if (member instanceof VectorWay && ((VectorWay)member).isClosed()) {
                if (windingRule == 1) {
                    VectorWay vectorWay = (VectorWay)member;
                    ArrayList<VectorNode> nodes = new ArrayList<VectorNode>(vectorWay.getNodes());
                    Collections.reverse(nodes);
                    vectorWay.setNodes((List<VectorNode>)nodes);
                }
                role = Geometry.isClockwise(((VectorWay)member).getNodes()) ? "outer" : "inner";
            } else {
                role = "";
            }
            vectorRelation.addRelationMember(new VectorRelationMember(role, member));
        }
        return vectorRelation;
    }

    public <T extends Tile> void addDataTile(T tile) {
        for (Layer layer : ((VectorTile)((Object)tile)).getLayers()) {
            Map<GeometryTypes, List<Feature>> grouped = layer.getFeatures().stream().collect(Collectors.groupingBy(Feature::getGeometryType));
            for (GeometryTypes type : GeometryTypes.values()) {
                if (!grouped.containsKey((Object)type)) continue;
                this.addFeatureData(tile, layer, (Collection<Feature>)grouped.get((Object)type));
            }
        }
        Collection primitives = this.getAllPrimitives().stream().filter(p -> p.hasKey(ORIGINAL_ID)).collect(Collectors.toList());
        List toReplace = primitives.stream().map(p -> p.get(ORIGINAL_ID)).filter(Objects::nonNull).collect(Collectors.toList());
        primitives.stream().filter(p -> toReplace.contains(p.get(ORIGINAL_ID))).forEach(p -> p.put(ORIGINAL_ID, toReplace.stream().filter(shared -> shared.equals(p.get(ORIGINAL_ID))).findAny().orElse(null)));
    }

    private <T extends Tile> void addFeatureData(T tile, Layer layer, Collection<Feature> features) {
        for (Feature feature : features) {
            try {
                this.addFeatureData(tile, layer, feature);
            }
            catch (IllegalArgumentException e) {
                Logging.error("Cannot add vector data for feature {0} of tile {1}: {2}", feature, tile, e.getMessage());
                Logging.error(e);
            }
        }
    }

    private <T extends Tile> void addFeatureData(T tile, Layer layer, Feature feature) {
        Object primitive;
        ArrayList<VectorPrimitive> featureObjects = new ArrayList<VectorPrimitive>(feature.getGeometryObject().getShapes().size());
        ArrayList<VectorPrimitive> primaryFeatureObjects = new ArrayList<VectorPrimitive>(feature.getGeometryObject().getShapes().size());
        for (Shape shape : feature.getGeometryObject().getShapes()) {
            primaryFeatureObjects.add(this.shapeToPrimaryFeatureObject(tile, layer, shape, featureObjects));
        }
        if (primaryFeatureObjects.size() == 1) {
            primitive = (VectorPrimitive)primaryFeatureObjects.get(0);
            if (primitive instanceof IRelation && !primitive.isMultipolygon()) {
                ((AbstractPrimitive)primitive).put(JOSM_MERGE_TYPE_KEY, "merge");
            }
        } else if (!primaryFeatureObjects.isEmpty()) {
            Iterator relation = new VectorRelation(layer.getName());
            ArrayList<VectorRelationMember> members = new ArrayList<VectorRelationMember>(primaryFeatureObjects.size());
            for (VectorPrimitive prim : primaryFeatureObjects) {
                members.add(new VectorRelationMember("", prim));
            }
            ((VectorRelation)((Object)relation)).setMembers((List<VectorRelationMember>)members);
            primitive = relation;
        } else {
            return;
        }
        ((VectorPrimitive)primitive).setId(feature.getId());
        if (feature.getId() != 0L && this.primitivesMap.containsKey(primitive.getPrimitiveId())) {
            ((AbstractPrimitive)primitive).put(ORIGINAL_ID, Long.toString(feature.getId()));
            ((VectorPrimitive)primitive).setId(((AbstractPrimitive)primitive).getIdGenerator().generateUniqueId());
        }
        if (feature.getTags() != null) {
            ((AbstractPrimitive)primitive).putAll(feature.getTags());
        }
        for (VectorPrimitive prim : featureObjects) {
            this.addPrimitive(prim);
        }
        for (VectorPrimitive prim : primaryFeatureObjects) {
            this.addPrimitive(prim);
        }
        try {
            this.addPrimitive((VectorPrimitive)primitive);
        }
        catch (JosmRuntimeException e) {
            Logging.error("{0}/{1}/{2}: {3}", tile.getZoom(), tile.getXtile(), tile.getYtile(), ((AbstractPrimitive)primitive).get("key"));
            throw e;
        }
    }

    private <T extends Tile> VectorPrimitive shapeToPrimaryFeatureObject(T tile, Layer layer, Shape shape, List<VectorPrimitive> featureObjects) {
        VectorPrimitive primitive;
        if (shape instanceof Ellipse2D) {
            primitive = this.pointToNode(tile, layer, featureObjects, (int)((Ellipse2D)shape).getCenterX(), (int)((Ellipse2D)shape).getCenterY());
        } else if (shape instanceof Path2D) {
            primitive = this.pathToWay(tile, layer, featureObjects, (Path2D)shape).stream().findFirst().orElse(null);
        } else if (shape instanceof Area) {
            VectorRelation vectorRelation = this.areaToRelation(tile, layer, featureObjects, (Area)shape);
            if (vectorRelation.getMembersCount() != 1) {
                primitive = vectorRelation;
                primitive.put(RELATION_TYPE, MULTIPOLYGON_TYPE);
            } else {
                primitive = vectorRelation.getMember(0).getMember();
            }
        } else {
            throw new UnsupportedOperationException(Objects.toString(shape));
        }
        return primitive;
    }

    @Override
    public void destroy() {
        this.addedTiles.forEach(tile -> tile.setLoaded(false));
        this.addedTiles.forEach(tile -> tile.setImage(null));
        this.addedTiles.clear();
        this.store.clear();
        this.allPrimitives.clear();
        this.primitivesMap.clear();
    }
}

