#include "box_surface_area.h"


template <typename DerivedCorner>
IGL_INLINE typename DerivedCorner::Scalar igl::box_surface_area(
  const Eigen::MatrixBase<DerivedCorner> & min_corner,
  const Eigen::MatrixBase<DerivedCorner> & max_corner)
{
  using Scalar = typename DerivedCorner::Scalar;
  const auto dimensions = (max_corner - min_corner).eval();
  const auto num_dimensions = dimensions.size();
    
  Scalar surface_area = 0;
  for (int i = 0; i < num_dimensions; ++i) {
      for (int j = i + 1; j < num_dimensions; ++j) {
          surface_area += 2 * dimensions[i] * dimensions[j];
      }
  }
    
  return surface_area;
}

template <typename Scalar, int AmbientDim>
IGL_INLINE Scalar igl::box_surface_area(
  const Eigen::AlignedBox<Scalar,AmbientDim> & box)
{
  return igl::box_surface_area(box.min(),box.max());
}

#ifdef IGL_STATIC_LIBRARY
// Explicit template instantiation
// generated by autoexplicit.sh
template double igl::box_surface_area<double, 2>(Eigen::AlignedBox<double, 2> const&);
template double igl::box_surface_area<double, 3>(Eigen::AlignedBox<double, 3> const&);
#endif
