/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.alert;

import com.install4j.runtime.util.AlertLafHelper;
import com.install4j.runtime.util.IconHelper;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AlertType {
    INFORMATION(1),
    QUESTION(3),
    WARNING(2),
    ERROR(0);

    private Icon icon;
    private final int optionType;

    @NotNull
    public static AlertType fromOptionType(int optionType, @NotNull AlertType defaultValue) {
        AlertType alertType = AlertType.fromOptionType(optionType);
        if (alertType != null) {
            return alertType;
        }
        return defaultValue;
    }

    @Nullable
    public static AlertType fromOptionType(int optionType) {
        for (AlertType alertType : AlertType.values()) {
            if (alertType.optionType != optionType) continue;
            return alertType;
        }
        return null;
    }

    private AlertType(int optionType) {
        this.optionType = optionType;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = IconHelper.loadIcon("alert_" + (AlertLafHelper.isUseWindowsIcons() || UIManager.getLookAndFeel().getID().toLowerCase().contains("win") ? "windows_" : "") + this.name().toLowerCase(Locale.ENGLISH) + ".png");
        }
        return this.icon;
    }

    public int getOptionType() {
        return this.optionType;
    }
}

