/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.runtime.installer.helper.content.AbstractHttpConnectionWrapper;
import com.install4j.runtime.installer.helper.content.HttpAuthenticator;
import com.install4j.runtime.installer.helper.content.JavaHttpConnection;
import com.install4j.runtime.installer.helper.content.UserNameAndPassword;
import com.install4j.runtime.installer.platform.win32.wininet.IgnoreCaseString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.jetbrains.annotations.NotNull;

public class HttpClientWrapper
extends AbstractHttpConnectionWrapper
implements JavaHttpConnection {
    private Proxy proxy;
    private HttpResponse<InputStream> response;
    private PostOutputStream outputStream;
    private boolean followRedirects = true;

    public HttpClientWrapper(URL url, Proxy proxy, boolean acceptAllCertificates) {
        super(url, acceptAllCertificates);
        this.proxy = proxy;
    }

    @Override
    public void connect() throws IOException {
        int connectTimeout;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(this.getUri());
        int readTimeout = this.getReadTimeout();
        if (readTimeout >= 0) {
            requestBuilder.timeout(Duration.ofMillis(readTimeout));
        }
        requestBuilder.method(this.getRequestMethod(), this.createBodyPublisher());
        for (Map.Entry<IgnoreCaseString, List<String>> entry : this.getRequestHeaders().entrySet()) {
            List<String> values2 = entry.getValue();
            for (String value : values2) {
                try {
                    requestBuilder.header(entry.getKey().toString(), value);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        HttpRequest request = requestBuilder.build();
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().proxy(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.singletonList(HttpClientWrapper.this.proxy);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        }).authenticator(new AuthenticatorWrapper(HttpAuthenticator.getInstance()));
        if (this.isAcceptAllCertificates()) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{HttpClientWrapper.createAcceptAllTrustManager()}, new SecureRandom());
                clientBuilder.sslContext(sslContext);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        if ((connectTimeout = this.getConnectTimeout()) >= 0) {
            clientBuilder.connectTimeout(Duration.ofMillis(connectTimeout));
        }
        clientBuilder.followRedirects(this.followRedirects ? HttpClient.Redirect.NORMAL : HttpClient.Redirect.NEVER);
        HttpClient client = clientBuilder.build();
        try {
            this.response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    private HttpRequest.BodyPublisher createBodyPublisher() {
        if (this.getPostContentLength() > 0L) {
            if (this.outputStream == null) {
                throw new IllegalStateException("No output was written");
            }
            return HttpRequest.BodyPublishers.ofInputStream(() -> new ByteArrayInputStream(this.outputStream.toByteArray()));
        }
        return HttpRequest.BodyPublishers.noBody();
    }

    private static TrustManager createAcceptAllTrustManager() {
        return new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }
        };
    }

    private URI getUri() throws IOException {
        try {
            return this.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    @NotNull
    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.checkConnectedAndFound();
        return this.response.body();
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        this.checkConnected();
        return this.response.body();
    }

    @Override
    public int getResponseCode() throws IOException {
        this.checkConnected();
        return this.response.statusCode();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        this.checkConnected();
        return this.response.headers().map();
    }

    @Override
    public String getHeaderField(String key) {
        this.checkConnected();
        return this.response.headers().firstValue(key).orElse(null);
    }

    @Override
    public void setFollowRedirects(boolean value) {
        this.followRedirects = value;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new PostOutputStream();
        }
        return this.outputStream;
    }

    @Override
    public void close() {
        if (this.response != null) {
            try {
                InputStream body = this.response.body();
                if (body != null) {
                    body.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void checkConnected() {
        if (this.response == null) {
            throw new IllegalStateException();
        }
    }

    private static int getByteArrayLength(long contentLength) throws IOException {
        if (contentLength > Integer.MAX_VALUE) {
            throw new IOException("maximum content length is 2147483647");
        }
        return (int)contentLength;
    }

    private static class AuthenticatorWrapper
    extends Authenticator {
        private static final Object LOCK = new Object();
        private final HttpAuthenticator authenticator;
        private ThreadLocal<Boolean> firstRequest = ThreadLocal.withInitial(() -> true);

        public AuthenticatorWrapper(HttpAuthenticator authenticator) {
            this.authenticator = authenticator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PasswordAuthentication requestPasswordAuthenticationInstance(String host, InetAddress addr, int port, String protocol, String prompt, String scheme, URL url, Authenticator.RequestorType reqType) {
            Object object = LOCK;
            synchronized (object) {
                if (this.firstRequest.get().booleanValue()) {
                    UserNameAndPassword lastServerCredentials;
                    this.firstRequest.set(false);
                    if (reqType == Authenticator.RequestorType.PROXY) {
                        UserNameAndPassword lastProxyCredentials = this.authenticator.getLastProxyCredentials();
                        if (lastProxyCredentials != null) {
                            return lastProxyCredentials.toPasswordAuthentication();
                        }
                    } else if (reqType == Authenticator.RequestorType.SERVER && (lastServerCredentials = this.authenticator.getLastServerCredentials(host)) != null) {
                        return lastServerCredentials.toPasswordAuthentication();
                    }
                }
                return this.authenticator.requestPasswordAuthenticationInstance(host, addr, port, protocol, prompt, scheme, url, reqType);
            }
        }
    }

    private class PostOutputStream
    extends ByteArrayOutputStream {
        public PostOutputStream() throws IOException {
            super(HttpClientWrapper.getByteArrayLength(HttpClientWrapper.this.getPostContentLength()));
        }
    }
}

