/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.runtime.installer.platform.win32.Common;
import java.io.File;
import java.io.IOException;

public class Win32Exec {
    private static final char[] ESCAPE_VERIFICATION;

    private static native int launch0(String var0, String var1);

    private static boolean needsEscaping(String arg) {
        for (char escapeChar : ESCAPE_VERIFICATION) {
            if (arg.indexOf(escapeChar) < 0) continue;
            return true;
        }
        return false;
    }

    public static void launch(String ... command) throws IOException {
        StringBuilder commandLine = new StringBuilder();
        for (int i = 0; i < command.length; ++i) {
            String currentArg = command[i];
            if (commandLine.length() > 0) {
                commandLine.append(" ");
            }
            if (i == 0 || Win32Exec.needsEscaping(currentArg)) {
                commandLine.append("\"").append(currentArg).append("\"");
                continue;
            }
            commandLine.append(currentArg);
        }
        if (!new File(command[0]).isFile()) {
            throw new IOException("not a file " + command[0]);
        }
        int ret = Win32Exec.launch0(command[0], commandLine.toString());
        if (ret != 0) {
            throw new IOException("error launching " + command[0] + ", commandLine: " + commandLine + ", error " + ret);
        }
    }

    static {
        Common.init();
        ESCAPE_VERIFICATION = new char[]{' ', '\t', '<', '>'};
    }
}

