/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import mediathek.config.Daten;
import mediathek.config.MVColor;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.cellrenderer.CellRendererBaseWithStart;
import mediathek.tool.table.MVTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CellRendererFilme
extends CellRendererBaseWithStart {
    private static final Logger logger = LogManager.getLogger(CellRendererFilme.class);
    private final FlatSVGIcon selectedStopIcon;
    private final FlatSVGIcon normalStopIcon;
    private final SeenHistoryController history = new SeenHistoryController();
    private final FlatSVGIcon selectedDownloadIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/download.svg");
    private final FlatSVGIcon normalDownloadIcon;
    private final FlatSVGIcon selectedPlayIcon;
    private final FlatSVGIcon normalPlayIcon;
    private final FlatSVGIcon selectedBookmarkIcon;
    private final FlatSVGIcon normalBookmarkIcon;
    private final FlatSVGIcon selectedBookmarkIconHighlighted;

    public CellRendererFilme() {
        this.selectedDownloadIcon.setColorFilter(this.whiteColorFilter);
        this.normalDownloadIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/download.svg");
        this.selectedPlayIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/play.svg");
        this.selectedPlayIcon.setColorFilter(this.whiteColorFilter);
        this.normalPlayIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/play.svg");
        this.selectedStopIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/stop.svg");
        this.selectedStopIcon.setColorFilter(this.whiteColorFilter);
        this.normalStopIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/stop.svg");
        this.selectedBookmarkIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/bookmark.svg");
        this.selectedBookmarkIcon.setColorFilter(this.whiteColorFilter);
        this.selectedBookmarkIconHighlighted = SVGIconUtilities.createSVGIcon("icons/fontawesome/bookmark.svg");
        this.selectedBookmarkIconHighlighted.setColorFilter(new FlatSVGIcon.ColorFilter(color -> Color.ORANGE));
        this.normalBookmarkIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/bookmark.svg");
    }

    private JTextArea createTextArea(String content) {
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setText(content);
        textArea.setForeground(this.getForeground());
        textArea.setBackground(this.getBackground());
        float fontSize = textArea.getFont().getSize2D();
        Font labelFont = UIManager.getFont("Label.font");
        textArea.setFont(labelFont.deriveFont(fontSize));
        return textArea;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.resetComponent();
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int rowModelIndex = table.convertRowIndexToModel(row);
            int columnModelIndex = table.convertColumnIndexToModel(column);
            DatenFilm datenFilm = (DatenFilm)table.getModel().getValueAt(rowModelIndex, 16);
            DatenDownload datenDownload = Daten.getInstance().getListeDownloadsButton().getDownloadUrlFilm(datenFilm.getUrlNormalQuality());
            boolean isBookMarked = datenFilm.isBookmarked();
            MVTable mvTable = (MVTable)table;
            if (mvTable.isLineBreak()) {
                switch (columnModelIndex) {
                    case 2: 
                    case 3: 
                    case 14: {
                        JTextArea textArea = this.createTextArea(value.toString());
                        this.applyColorSettings(textArea, datenFilm, datenDownload, isSelected, isBookMarked);
                        return textArea;
                    }
                }
            }
            this.applyHorizontalAlignment(columnModelIndex);
            switch (columnModelIndex) {
                case 9: {
                    this.setText(datenFilm.getFilmLengthAsString());
                    break;
                }
                case 4: {
                    this.handleButtonStartColumn(datenDownload, isSelected);
                    break;
                }
                case 5: {
                    this.handleButtonDownloadColumn(isSelected);
                    break;
                }
                case 6: {
                    this.handleButtonBookmarkColumn(isBookMarked, isSelected, datenFilm.isLivestream());
                    break;
                }
                case 1: {
                    if (!mvTable.showSenderIcons()) break;
                    Dimension targetDim = this.getSenderCellDimension(table, row, columnModelIndex);
                    this.setSenderIcon(value.toString(), targetDim);
                    break;
                }
                case 3: {
                    this.setText(datenFilm.getTitle());
                    this.setIndicatorIcons(table, datenFilm, isSelected);
                    break;
                }
                case 13: {
                    this.drawGeolocationIcons(datenFilm, isSelected);
                }
            }
            this.applyColorSettings(this, datenFilm, datenDownload, isSelected, isBookMarked);
        }
        catch (Exception ex) {
            logger.error("Fehler", (Throwable)ex);
        }
        return this;
    }

    private void applyHorizontalAlignment(int columnModelIndex) {
        switch (columnModelIndex) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.setHorizontalAlignment(0);
                break;
            }
            case 10: {
                this.setHorizontalAlignment(4);
            }
        }
    }

    private void applyColorSettings(Component c, @NotNull DatenFilm datenFilm, DatenDownload datenDownload, boolean isSelected, boolean isBookMarked) {
        boolean start = datenDownload != null && datenDownload.start != null;
        boolean hasBeenSeen = this.history.hasBeenSeen(datenFilm);
        if (start) {
            this.setBackgroundColor(c, datenDownload.start, isSelected);
        } else if (hasBeenSeen) {
            if (!isSelected) {
                c.setBackground(MVColor.FILM_HISTORY.color);
            }
        } else if (datenFilm.isNew()) {
            if (!isSelected) {
                c.setForeground(MVColor.getNewColor());
            }
        } else if (isBookMarked && !isSelected) {
            c.setBackground(MVColor.FILM_BOOKMARKED.color);
        }
    }

    private void handleButtonStartColumn(DatenDownload datenDownload, boolean isSelected) {
        if (datenDownload != null && datenDownload.start != null && datenDownload.start.status == 2) {
            this.setIconAndToolTip(isSelected, this.normalStopIcon, this.selectedStopIcon, "Film stoppen");
        }
        if (this.getIcon() == null) {
            this.setIconAndToolTip(isSelected, this.normalPlayIcon, this.selectedPlayIcon, "Film abspielen");
        }
    }

    private void setIconAndToolTip(boolean isSelected, Icon normal, Icon selected, String text) {
        this.setToolTipText(text);
        Icon icon = isSelected ? selected : normal;
        this.setIcon(icon);
    }

    private void handleButtonDownloadColumn(boolean isSelected) {
        this.setIconAndToolTip(isSelected, this.normalDownloadIcon, this.selectedDownloadIcon, "Film aufzeichnen");
    }

    private void handleButtonBookmarkColumn(boolean isBookMarked, boolean isSelected, boolean isLivestream) {
        if (isLivestream) {
            this.setIcon(null);
            this.setToolTipText("");
        } else {
            this.setToolTipText(isBookMarked ? "Film aus Merkliste entfernen" : "Film merken");
            if (isBookMarked) {
                if (isSelected) {
                    this.setIcon(this.selectedBookmarkIconHighlighted);
                } else {
                    this.setIcon(this.selectedBookmarkIconHighlighted);
                }
            } else if (isSelected) {
                this.setIcon(this.selectedBookmarkIcon);
            } else {
                this.setIcon(this.normalBookmarkIcon);
            }
        }
    }
}

