/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsFormat;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFieldsConsumer;
import org.apache.lucene.index.TrackingTmpOutputDirectoryWrapper;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

final class SortingStoredFieldsConsumer
extends StoredFieldsConsumer {
    static final CompressionMode NO_COMPRESSION = new CompressionMode(){

        @Override
        public Compressor newCompressor() {
            return new Compressor(){

                @Override
                public void close() throws IOException {
                }

                @Override
                public void compress(ByteBuffersDataInput buffersInput, DataOutput out) throws IOException {
                    out.copyBytes(buffersInput, buffersInput.size());
                }
            };
        }

        @Override
        public Decompressor newDecompressor() {
            return new Decompressor(){

                @Override
                public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
                    bytes.bytes = ArrayUtil.grow(bytes.bytes, length);
                    in.skipBytes(offset);
                    in.readBytes(bytes.bytes, 0, length);
                    bytes.offset = 0;
                    bytes.length = length;
                }

                @Override
                public Decompressor clone() {
                    return this;
                }
            };
        }
    };
    private static final StoredFieldsFormat TEMP_STORED_FIELDS_FORMAT = new Lucene90CompressingStoredFieldsFormat("TempStoredFields", NO_COMPRESSION, 131072, 1, 10);
    TrackingTmpOutputDirectoryWrapper tmpDirectory;

    SortingStoredFieldsConsumer(Codec codec, Directory directory, SegmentInfo info) {
        super(codec, directory, info);
    }

    @Override
    protected void initStoredFieldsWriter() throws IOException {
        if (this.writer == null) {
            this.tmpDirectory = new TrackingTmpOutputDirectoryWrapper(this.directory);
            this.writer = TEMP_STORED_FIELDS_FORMAT.fieldsWriter(this.tmpDirectory, this.info, IOContext.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flush(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        super.flush(state, sortMap);
        StoredFieldsReader reader = TEMP_STORED_FIELDS_FORMAT.fieldsReader(this.tmpDirectory, state.segmentInfo, state.fieldInfos, IOContext.DEFAULT);
        StoredFieldsWriter sortWriter = this.codec.storedFieldsFormat().fieldsWriter(state.directory, state.segmentInfo, IOContext.DEFAULT);
        try {
            reader.checkIntegrity();
            CopyVisitor visitor = new CopyVisitor(sortWriter);
            for (int docID = 0; docID < state.segmentInfo.maxDoc(); ++docID) {
                sortWriter.startDocument();
                reader.document(sortMap == null ? docID : sortMap.newToOld(docID), visitor);
                sortWriter.finishDocument();
            }
            sortWriter.finish(state.segmentInfo.maxDoc());
        }
        catch (Throwable throwable) {
            IOUtils.close(reader, sortWriter);
            IOUtils.deleteFiles(this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
            throw throwable;
        }
        IOUtils.close(reader, sortWriter);
        IOUtils.deleteFiles(this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
    }

    @Override
    void abort() {
        try {
            super.abort();
        }
        finally {
            if (this.tmpDirectory != null) {
                IOUtils.deleteFilesIgnoringExceptions((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
            }
        }
    }

    private static class CopyVisitor
    extends StoredFieldVisitor
    implements IndexableField {
        final StoredFieldsWriter writer;
        BytesRef binaryValue;
        String stringValue;
        Number numericValue;
        FieldInfo currentField;

        CopyVisitor(StoredFieldsWriter writer) {
            this.writer = writer;
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.reset(fieldInfo);
            this.binaryValue = new BytesRef(value);
            this.write();
        }

        @Override
        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            this.reset(fieldInfo);
            this.stringValue = Objects.requireNonNull(value, "String value should not be null");
            this.write();
        }

        @Override
        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = value;
            this.write();
        }

        @Override
        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = value;
            this.write();
        }

        @Override
        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = Float.valueOf(value);
            this.write();
        }

        @Override
        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = value;
            this.write();
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return StoredFieldVisitor.Status.YES;
        }

        @Override
        public String name() {
            return this.currentField.name;
        }

        @Override
        public IndexableFieldType fieldType() {
            return StoredField.TYPE;
        }

        @Override
        public BytesRef binaryValue() {
            return this.binaryValue;
        }

        @Override
        public String stringValue() {
            return this.stringValue;
        }

        @Override
        public Number numericValue() {
            return this.numericValue;
        }

        @Override
        public Reader readerValue() {
            return null;
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
            return null;
        }

        void reset(FieldInfo field) {
            this.currentField = field;
            this.binaryValue = null;
            this.stringValue = null;
            this.numericValue = null;
        }

        void write() throws IOException {
            this.writer.writeField(this.currentField, this);
        }
    }
}

