/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.view;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.admin.indices.view.ViewService;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.View;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

@ExperimentalApi
public class GetViewAction
extends ActionType<Response> {
    public static final GetViewAction INSTANCE = new GetViewAction();
    public static final String NAME = "views:data/read/get";

    public GetViewAction() {
        super(NAME, Response::new);
    }

    public static class TransportAction
    extends TransportClusterManagerNodeAction<Request, Response> {
        private final ViewService viewService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ViewService viewService) {
            super(GetViewAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver);
            this.viewService = viewService;
        }

        @Override
        protected String executor() {
            return "management";
        }

        @Override
        protected Response read(StreamInput in) throws IOException {
            return new Response(in);
        }

        @Override
        protected void clusterManagerOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            this.viewService.getView(request, listener);
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        }
    }

    @ExperimentalApi
    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final View view;
        private static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser("view_response", args -> new Response((View)args[0]));

        public Response(View view) {
            this.view = view;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.view = new View(in);
        }

        public View getView() {
            return this.view;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.getView().equals(that.getView());
        }

        public int hashCode() {
            return Objects.hash(this.getView());
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.view.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("view", (ToXContent)this.view);
            builder.endObject();
            return builder;
        }

        public static Response fromXContent(XContentParser parser) throws IOException {
            return (Response)((Object)PARSER.parse(parser, null));
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), View.PARSER, new ParseField("view", new String[0]));
        }
    }

    @ExperimentalApi
    public static class Request
    extends ClusterManagerNodeRequest<Request> {
        private final String name;
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("get_view_request", args -> new Request((String)args[0]));

        public Request(String name) {
            this.name = name;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.name)) {
                validationException = ValidateActions.addValidationError("name cannot be empty or null", validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
        }

        public static Request fromXContent(XContentParser parser) throws IOException {
            return (Request)PARSER.parse(parser, null);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), View.NAME_FIELD);
        }
    }
}

