/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.snapshots;

import java.io.IOException;
import java.util.List;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.remote.RemoteStoreEnums;
import org.opensearch.repositories.IndexId;

public class SnapshotShardPaths
implements ToXContent {
    public static final String DIR = "snapshot_shard_paths";
    public static final String DELIMITER = ".";
    public static final String FILE_PREFIX = "snapshot_path_";
    public static final String FILE_NAME_FORMAT = "snapshot_path_%s";
    private static final String PATHS_FIELD = "paths";
    private static final String INDEX_ID_FIELD = "indexId";
    private static final String INDEX_NAME_FIELD = "indexName";
    private static final String NUMBER_OF_SHARDS_FIELD = "number_of_shards";
    private static final String SHARD_PATH_TYPE_FIELD = "shard_path_type";
    private static final String SHARD_PATH_HASH_ALGORITHM_FIELD = "shard_path_hash_algorithm";
    private final List<String> paths;
    private final String indexId;
    private final String indexName;
    private final int numberOfShards;
    private final RemoteStoreEnums.PathType shardPathType;
    private final RemoteStoreEnums.PathHashAlgorithm shardPathHashAlgorithm;

    public SnapshotShardPaths(List<String> paths, String indexId, String indexName, int numberOfShards, RemoteStoreEnums.PathType shardPathType, RemoteStoreEnums.PathHashAlgorithm shardPathHashAlgorithm) {
        assert (!paths.isEmpty()) : "paths must not be empty";
        assert (indexId != null && !indexId.isEmpty()) : "indexId must not be empty";
        assert (indexName != null && !indexName.isEmpty()) : "indexName must not be empty";
        assert (numberOfShards > 0) : "numberOfShards must be > 0";
        assert (shardPathType != null) : "shardPathType must not be null";
        assert (shardPathHashAlgorithm != null) : "shardPathHashAlgorithm must not be null";
        this.paths = paths;
        this.indexId = indexId;
        this.indexName = indexName;
        this.numberOfShards = numberOfShards;
        this.shardPathType = shardPathType;
        this.shardPathHashAlgorithm = shardPathHashAlgorithm;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(INDEX_ID_FIELD, this.indexId);
        builder.field(INDEX_NAME_FIELD, this.indexName);
        builder.field(NUMBER_OF_SHARDS_FIELD, this.numberOfShards);
        builder.field(SHARD_PATH_TYPE_FIELD, this.shardPathType.getCode());
        builder.field(SHARD_PATH_HASH_ALGORITHM_FIELD, this.shardPathHashAlgorithm.getCode());
        builder.startArray(PATHS_FIELD);
        for (String path : this.paths) {
            builder.value(path);
        }
        builder.endArray();
        return builder;
    }

    public static SnapshotShardPaths fromXContent(XContentParser ignored) {
        throw new UnsupportedOperationException("SnapshotShardPaths.fromXContent() is not supported");
    }

    public static ShardInfo parseShardPath(String shardPath) {
        String[] parts = shardPath.split("\\.");
        int len = parts.length;
        if (len < 5) {
            throw new IllegalArgumentException("Invalid shard path format: " + shardPath);
        }
        try {
            String indexName = shardPath.substring(shardPath.indexOf(DELIMITER) + 1, shardPath.lastIndexOf(DELIMITER, shardPath.lastIndexOf(DELIMITER, shardPath.lastIndexOf(DELIMITER) - 1) - 1));
            IndexId indexId = new IndexId(indexName, SnapshotShardPaths.getIndexId(parts[0]), Integer.parseInt(parts[len - 2]));
            int shardCount = Integer.parseInt(parts[len - 3]);
            return new ShardInfo(indexId, shardCount);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid shard path format: " + shardPath, e);
        }
    }

    public static String getIndexId(String indexIdField) {
        if (indexIdField.startsWith(FILE_PREFIX)) {
            return indexIdField.substring(FILE_PREFIX.length());
        }
        return indexIdField;
    }

    public static class ShardInfo {
        private final IndexId indexId;
        private final int shardCount;

        public ShardInfo(IndexId indexId, int shardCount) {
            this.indexId = indexId;
            this.shardCount = shardCount;
        }

        public IndexId getIndexId() {
            return this.indexId;
        }

        public int getShardCount() {
            return this.shardCount;
        }
    }
}

