/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.set.Sets;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractCharFilterFactory;

public class HtmlStripCharFilterFactory
extends AbstractCharFilterFactory {
    private final Set<String> escapedTags;

    HtmlStripCharFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name);
        List escapedTags = settings.getAsList("escaped_tags");
        this.escapedTags = escapedTags.size() > 0 ? Collections.unmodifiableSet(Sets.newHashSet((Iterable)escapedTags)) : null;
    }

    public Reader create(Reader tokenStream) {
        return new HTMLStripCharFilter(tokenStream, this.escapedTags);
    }
}

