/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.util.ParseUtils;

public class AnomalyDetectorExecutionInput
implements ToXContentObject {
    private static final String DETECTOR_ID_FIELD = "detector_id";
    private static final String PERIOD_START_FIELD = "period_start";
    private static final String PERIOD_END_FIELD = "period_end";
    private static final String DETECTOR_FIELD = "detector";
    private Instant periodStart;
    private Instant periodEnd;
    private String detectorId;
    private AnomalyDetector detector;

    public AnomalyDetectorExecutionInput(String detectorId, Instant periodStart, Instant periodEnd, AnomalyDetector detector) {
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.detectorId = detectorId;
        this.detector = detector;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(DETECTOR_ID_FIELD, this.detectorId).field(PERIOD_START_FIELD, this.periodStart.toEpochMilli()).field(PERIOD_END_FIELD, this.periodEnd.toEpochMilli()).field(DETECTOR_FIELD, (ToXContent)this.detector);
        return xContentBuilder.endObject();
    }

    public static AnomalyDetectorExecutionInput parse(XContentParser parser) throws IOException {
        return AnomalyDetectorExecutionInput.parse(parser, null);
    }

    public static AnomalyDetectorExecutionInput parse(XContentParser parser, String adId) throws IOException {
        Instant periodStart = null;
        Instant periodEnd = null;
        AnomalyDetector detector = null;
        String detectorId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "detector_id": {
                    detectorId = parser.text();
                    break;
                }
                case "period_start": {
                    periodStart = ParseUtils.toInstant(parser);
                    break;
                }
                case "period_end": {
                    periodEnd = ParseUtils.toInstant(parser);
                    break;
                }
                case "detector": {
                    if (!parser.currentToken().equals((Object)XContentParser.Token.START_OBJECT)) break;
                    detector = AnomalyDetector.parse(parser, detectorId);
                    break;
                }
            }
        }
        if (!Strings.isNullOrEmpty((String)adId)) {
            detectorId = adId;
        }
        return new AnomalyDetectorExecutionInput(detectorId, periodStart, periodEnd, detector);
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnomalyDetectorExecutionInput that = (AnomalyDetectorExecutionInput)o;
        return Objects.equal((Object)this.getPeriodStart(), (Object)that.getPeriodStart()) && Objects.equal((Object)this.getPeriodEnd(), (Object)that.getPeriodEnd()) && Objects.equal((Object)this.getDetectorId(), (Object)that.getDetectorId()) && Objects.equal((Object)this.getDetector(), (Object)that.getDetector());
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.periodStart, this.periodEnd, this.detectorId});
    }

    public Instant getPeriodStart() {
        return this.periodStart;
    }

    public Instant getPeriodEnd() {
        return this.periodEnd;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public AnomalyDetector getDetector() {
        return this.detector;
    }

    public void setDetectorId(String detectorId) {
        this.detectorId = detectorId;
    }

    @Generated
    public String toString() {
        return super.toString() + ", " + new ToStringBuilder((Object)this).append("periodStart", (Object)this.periodStart).append("periodEnd", (Object)this.periodEnd).append("detectorId", (Object)this.detectorId).append(DETECTOR_FIELD, (Object)this.detector).toString();
    }
}

