/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.util.Collection;
import java.util.Set;
import org.opensearch.timeseries.Name;

public enum SuggestName implements Name
{
    INTERVAL("forecast_interval"),
    HORIZON("horizon"),
    HISTORY("history"),
    WINDOW_DELAY("window_delay");

    private String name;

    private SuggestName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static SuggestName getName(String name) {
        switch (name) {
            case "forecast_interval": {
                return INTERVAL;
            }
            case "horizon": {
                return HORIZON;
            }
            case "history": {
                return HISTORY;
            }
            case "window_delay": {
                return WINDOW_DELAY;
            }
        }
        throw new IllegalArgumentException("The given suggest type doesn't exist");
    }

    public static Set<SuggestName> getNames(Collection<String> names) {
        return Name.getNameFromCollection(names, SuggestName::getName);
    }
}

