"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.registerAlertingRoutes = registerAlertingRoutes;
var _lodash = require("lodash");
var _constants = require("../utils/constants");
var _adHelpers = require("./utils/adHelpers");
var _helpers = require("../utils/helpers");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                          * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                          * compatible open source license.
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                          * GitHub history for details.
                                                                                                                                                                                                                                                                                                                          */ //@ts-ignore
function registerAlertingRoutes(apiRouter, alertingService) {
  apiRouter.post('/monitors/_search', alertingService.searchMonitors);
  apiRouter.post('/monitors/_search/{dataSourceId}', alertingService.searchMonitors);
  apiRouter.get('/monitors/alerts', alertingService.searchAlerts);
  apiRouter.get('/monitors/alerts/{dataSourceId}', alertingService.searchAlerts);
}
class AlertingService {
  constructor(client, dataSourceEnabled) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "searchMonitors", async (context, request, opensearchDashboardsResponse) => {
      try {
        const {
          dataSourceId = ''
        } = request.params;
        const requestBody = {
          size: _constants.MAX_MONITORS,
          query: {
            nested: {
              path: 'monitor.inputs',
              query: {
                bool: {
                  should: [{
                    term: {
                      'monitor.inputs.search.indices.keyword': {
                        value: '.opendistro-anomaly-results*'
                      }
                    }
                  }, {
                    match_phrase_prefix: {
                      'monitor.inputs.search.indices': 'opensearch-ad-plugin-result-'
                    }
                  }]
                }
              }
            }
          }
        };
        const callWithRequest = (0, _helpers.getClientBasedOnDataSource)(context, this.dataSourceEnabled, request, dataSourceId, this.client);
        const response = await callWithRequest('adAlerting.searchMonitors', {
          body: requestBody
        });
        const totalMonitors = (0, _lodash.get)(response, 'hits.total.value', 0);
        const allMonitors = (0, _lodash.get)(response, 'hits.hits', []).reduce((acc, monitor) => ({
          ...acc,
          [monitor._id]: {
            id: monitor._id,
            name: (0, _lodash.get)(monitor, '_source.name'),
            enabled: (0, _lodash.get)(monitor, '_source.enabled', false),
            enabledTime: (0, _lodash.get)(monitor, '_source.enabled_time'),
            schedule: (0, _lodash.get)(monitor, '_source.schedule'),
            inputs: (0, _lodash.get)(monitor, '_source.inputs'),
            triggers: (0, _lodash.get)(monitor, '_source.triggers'),
            lastUpdateTime: (0, _lodash.get)(monitor, '_source.last_update_time')
          }
        }), {});
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true,
            response: {
              totalMonitors,
              monitors: Object.values(allMonitors)
            }
          }
        });
      } catch (err) {
        console.log('Unable to get monitor on top of detector', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: (0, _adHelpers.getErrorMessage)(err)
          }
        });
      }
    });
    _defineProperty(this, "searchAlerts", async (context, request, opensearchDashboardsResponse) => {
      try {
        const {
          monitorId,
          startTime,
          endTime
        } = request.query;
        const {
          dataSourceId = ''
        } = request.params;
        const callWithRequest = (0, _helpers.getClientBasedOnDataSource)(context, this.dataSourceEnabled, request, dataSourceId, this.client);
        const response = callWithRequest('adAlerting.searchAlerts', {
          monitorId: monitorId,
          startTime: startTime,
          endTime: endTime
        });
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true,
            response
          }
        });
      } catch (err) {
        console.log('Unable to search alerts', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: (0, _adHelpers.getErrorMessage)(err)
          }
        });
      }
    });
    this.client = client;
    this.dataSourceEnabled = dataSourceEnabled;
  }
}
exports.default = AlertingService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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