"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConfig$ = createConfig$;
var _operators = require("rxjs/operators");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 * Set up dynamic config defaults
 */
function createConfig$(core, config$, logger) {
  return config$.pipe((0, _operators.map)(config => {
    const {
      osd_server: reportingServer
    } = config;
    const serverInfo = core.http.getServerInfo();
    // osd_server.hostname, default to server.host
    const osdServerHostname = reportingServer.hostname ? reportingServer.hostname : serverInfo.hostname;

    // osd_server.port, default to server.port
    const osdServerPort = reportingServer.port ? reportingServer.port : serverInfo.port;
    // osd_server.protocol, default to server.protocol
    const osdServerProtocol = reportingServer.protocol ? reportingServer.protocol : serverInfo.protocol;
    return {
      ...config,
      osd_server: {
        hostname: osdServerHostname,
        port: osdServerPort,
        protocol: osdServerProtocol
      }
    };
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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