"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INVALID_NEXT_URL_PARAMETER_MESSAGE = void 0;
exports.composeNextUrlQueryParam = composeNextUrlQueryParam;
exports.validateNextUrl = validateNextUrl;
var _url = require("url");
var _encode_uri_query = require("../../../../src/plugins/opensearch_dashboards_utils/common/url/encode_uri_query");
var _http = require("../../../../src/core/server/http");
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

function composeNextUrlQueryParam(request, basePath) {
  try {
    const currentUrl = request.url.toString();
    const parsedUrl = (0, _url.parse)(currentUrl, true);
    const nextUrl = parsedUrl === null || parsedUrl === void 0 ? void 0 : parsedUrl.path;
    if (!!nextUrl && nextUrl !== '/') {
      return `nextUrl=${(0, _encode_uri_query.encodeUriQuery)((0, _http.getRedirectUrl)({
        request,
        basePath,
        nextUrl
      }))}`;
    }
  } catch (error) {
    /* Ignore errors from parsing */
  }
  return '';
}
const INVALID_NEXT_URL_PARAMETER_MESSAGE = exports.INVALID_NEXT_URL_PARAMETER_MESSAGE = 'Invalid nextUrl parameter.';

/**
 * We require the nextUrl parameter to be an relative url.
 *
 * Here we validate the nextUrl parameter by checking if it meets the following criteria:
 *   - nextUrl starts with the basePath (/ if no serverBasePath is set)
 *   - If nextUrl is longer than 2 chars then the second character must be alphabetical or underscore
 *   - The following characters must be alphanumeric, dash or underscore
 * Note: url has been decoded by OpenSearchDashboards.
 *
 * @param url url string.
 * @returns error message if nextUrl is invalid, otherwise void.
 */
function validateNextUrl(url, basePath) {
  if (url) {
    const path = url.split(/\?|#/)[0];
    const bp = basePath || '';
    if (!path.startsWith(bp)) {
      return INVALID_NEXT_URL_PARAMETER_MESSAGE;
    }
    const pathMinusBase = path.replace(bp, '');
    if (pathMinusBase && !pathMinusBase.startsWith('/') || pathMinusBase.length >= 2 && !/^\/[a-zA-Z_][\/a-zA-Z0-9-_]+$/.test(pathMinusBase)) {
      return INVALID_NEXT_URL_PARAMETER_MESSAGE;
    }
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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