/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceBootModeValues {
    LEGACY_BIOS("legacy-bios"),
    UEFI("uefi"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceBootModeValues> VALUE_MAP;
    private final String value;

    private InstanceBootModeValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceBootModeValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceBootModeValues> knownValues() {
        EnumSet<InstanceBootModeValues> knownValues = EnumSet.allOf(InstanceBootModeValues.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceBootModeValues.class, InstanceBootModeValues::toString);
    }
}

