/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.conversation.Interaction;

public class GetTracesResponse
extends ActionResponse
implements ToXContentObject {
    @NonNull
    private List<Interaction> traces;
    private int nextToken;
    private boolean hasMoreTokens;

    public GetTracesResponse(StreamInput in) throws IOException {
        super(in);
        this.traces = in.readList(Interaction::fromStream);
        this.nextToken = in.readInt();
        this.hasMoreTokens = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.traces);
        out.writeInt(this.nextToken);
        out.writeBoolean(this.hasMoreTokens);
    }

    public boolean hasMorePages() {
        return this.hasMoreTokens;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("traces");
        for (Interaction trace : this.traces) {
            trace.toXContent(builder, params);
        }
        builder.endArray();
        if (this.hasMoreTokens) {
            builder.field("next_token", this.nextToken);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public GetTracesResponse(@NonNull List<Interaction> traces, int nextToken, boolean hasMoreTokens) {
        Objects.requireNonNull(traces, "traces is marked non-null but is null");
        this.traces = traces;
        this.nextToken = nextToken;
        this.hasMoreTokens = hasMoreTokens;
    }

    @NonNull
    @Generated
    public List<Interaction> getTraces() {
        return this.traces;
    }

    @Generated
    public int getNextToken() {
        return this.nextToken;
    }
}

