/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.time.Duration;
import org.ldaptive.AbstractConfig;

public class PoolConfig
extends AbstractConfig {
    public static final int DEFAULT_MIN_POOL_SIZE = 3;
    public static final int DEFAULT_MAX_POOL_SIZE = 10;
    public static final boolean DEFAULT_VALIDATE_ON_CHECKIN = false;
    public static final boolean DEFAULT_VALIDATE_ON_CHECKOUT = false;
    public static final boolean DEFAULT_VALIDATE_PERIODICALLY = false;
    public static final Duration DEFAULT_VALIDATE_PERIOD = Duration.ofMinutes(30L);
    public static final Duration DEFAULT_VALIDATE_TIMEOUT = Duration.ofSeconds(5L);
    private int minPoolSize = 3;
    private int maxPoolSize = 10;
    private boolean validateOnCheckIn = false;
    private boolean validateOnCheckOut = false;
    private boolean validatePeriodically = false;
    private Duration validatePeriod = DEFAULT_VALIDATE_PERIOD;
    private Duration validateTimeout = DEFAULT_VALIDATE_TIMEOUT;

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int size) {
        this.checkImmutable();
        if (size >= 0) {
            this.logger.trace("setting minPoolSize: {}", (Object)size);
            this.minPoolSize = size;
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int size) {
        this.checkImmutable();
        if (size >= 0) {
            this.logger.trace("setting maxPoolSize: {}", (Object)size);
            this.maxPoolSize = size;
        }
    }

    public boolean isValidateOnCheckIn() {
        return this.validateOnCheckIn;
    }

    public void setValidateOnCheckIn(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting validateOnCheckIn: {}", (Object)b);
        this.validateOnCheckIn = b;
    }

    public boolean isValidateOnCheckOut() {
        return this.validateOnCheckOut;
    }

    public void setValidateOnCheckOut(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting validateOnCheckOut: {}", (Object)b);
        this.validateOnCheckOut = b;
    }

    public boolean isValidatePeriodically() {
        return this.validatePeriodically;
    }

    public void setValidatePeriodically(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting validatePeriodically: {}", (Object)b);
        this.validatePeriodically = b;
    }

    public Duration getValidatePeriod() {
        return this.validatePeriod;
    }

    public void setValidatePeriod(Duration time) {
        this.checkImmutable();
        if (time == null || time.isNegative()) {
            throw new IllegalArgumentException("Validate period cannot be null or negative");
        }
        this.logger.trace("setting validatePeriod: {}", (Object)time);
        this.validatePeriod = time;
    }

    public Duration getValidateTimeout() {
        return this.validateTimeout;
    }

    public void setValidateTimeout(Duration time) {
        this.checkImmutable();
        if (time != null && time.isNegative()) {
            throw new IllegalArgumentException("Validate timeout cannot be negative");
        }
        this.logger.trace("setting validateTimeout: {}", (Object)time);
        this.validateTimeout = time;
    }

    public String toString() {
        return String.format("[%s@%d::minPoolSize=%s, maxPoolSize=%s, validateOnCheckIn=%s, validateOnCheckOut=%s, validatePeriodically=%s, validatePeriod=%s, validateTimeout=%s]", this.getClass().getName(), this.hashCode(), this.minPoolSize, this.maxPoolSize, this.validateOnCheckIn, this.validateOnCheckOut, this.validatePeriodically, this.validatePeriod, this.validateTimeout);
    }
}

