/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.brotli;

import net.sourceforge.plantuml.brotli.BrotliRuntimeException;
import net.sourceforge.plantuml.brotli.State;
import net.sourceforge.plantuml.brotli.Utils;

final class BitReader {
    private static final boolean CHECK_UNUSED_BYTES_AFTER_END = false;
    private static final int LOG_BITNESS = 6;
    private static final int BITNESS = 64;
    private static final int BYTENESS = 8;
    private static final int CAPACITY = 4096;
    private static final int SLACK = 64;
    private static final int BUFFER_SIZE = 4160;
    private static final int SAFEGUARD = 36;
    private static final int WATERLINE = 4060;
    private static final int HALF_BITNESS = 32;
    private static final int HALF_SIZE = 4;
    private static final int HALVES_CAPACITY = 1024;
    private static final int HALF_BUFFER_SIZE = 1040;
    private static final int HALF_WATERLINE = 1015;
    private static final int LOG_HALF_SIZE = 2;

    BitReader() {
    }

    static void readMoreInput(State s2) {
        if (s2.halfOffset > 1015) {
            BitReader.doReadMoreInput(s2);
        }
    }

    static void doReadMoreInput(State s2) {
        int bytesInBuffer;
        int len;
        if (s2.endOfStreamReached != 0) {
            if (BitReader.halfAvailable(s2) >= -2) {
                return;
            }
            throw new BrotliRuntimeException("No more input");
        }
        int readOffset = s2.halfOffset << 2;
        Utils.copyBytesWithin(s2.byteBuffer, 0, readOffset, 4096);
        s2.halfOffset = 0;
        for (bytesInBuffer = 4096 - readOffset; bytesInBuffer < 4096; bytesInBuffer += len) {
            int spaceLeft = 4096 - bytesInBuffer;
            len = Utils.readInput(s2.input, s2.byteBuffer, bytesInBuffer, spaceLeft);
            if (len > 0) continue;
            s2.endOfStreamReached = 1;
            s2.tailBytes = bytesInBuffer;
            bytesInBuffer += 3;
            break;
        }
        BitReader.bytesToNibbles(s2, bytesInBuffer);
    }

    static void checkHealth(State s2, int endOfStream) {
        if (s2.endOfStreamReached == 0) {
            return;
        }
        int byteOffset = (s2.halfOffset << 2) + (s2.bitOffset + 7 >> 3) - 8;
        if (byteOffset > s2.tailBytes) {
            throw new BrotliRuntimeException("Read after end");
        }
    }

    static void fillBitWindow(State s2) {
        if (s2.bitOffset >= 32) {
            s2.accumulator64 = (long)s2.intBuffer[s2.halfOffset++] << 32 | s2.accumulator64 >>> 32;
            s2.bitOffset -= 32;
        }
    }

    private static void doFillBitWindow(State s2) {
        s2.accumulator64 = (long)s2.intBuffer[s2.halfOffset++] << 32 | s2.accumulator64 >>> 32;
        s2.bitOffset -= 32;
    }

    static int peekBits(State s2) {
        return (int)(s2.accumulator64 >>> s2.bitOffset);
    }

    static int readFewBits(State s2, int n) {
        int val = BitReader.peekBits(s2) & (1 << n) - 1;
        s2.bitOffset += n;
        return val;
    }

    static int readBits(State s2, int n) {
        return BitReader.readFewBits(s2, n);
    }

    private static int readManyBits(State s2, int n) {
        int low = BitReader.readFewBits(s2, 16);
        BitReader.doFillBitWindow(s2);
        return low | BitReader.readFewBits(s2, n - 16) << 16;
    }

    static void initBitReader(State s2) {
        s2.byteBuffer = new byte[4160];
        s2.accumulator64 = 0L;
        s2.intBuffer = new int[1040];
        s2.bitOffset = 64;
        s2.halfOffset = 1024;
        s2.endOfStreamReached = 0;
        BitReader.prepare(s2);
    }

    private static void prepare(State s2) {
        BitReader.readMoreInput(s2);
        BitReader.checkHealth(s2, 0);
        BitReader.doFillBitWindow(s2);
        BitReader.doFillBitWindow(s2);
    }

    static void reload(State s2) {
        if (s2.bitOffset == 64) {
            BitReader.prepare(s2);
        }
    }

    static void jumpToByteBoundary(State s2) {
        int paddingBits;
        int padding = 64 - s2.bitOffset & 7;
        if (padding != 0 && (paddingBits = BitReader.readFewBits(s2, padding)) != 0) {
            throw new BrotliRuntimeException("Corrupted padding bits");
        }
    }

    static int halfAvailable(State s2) {
        int limit = 1024;
        if (s2.endOfStreamReached != 0) {
            limit = s2.tailBytes + 3 >> 2;
        }
        return limit - s2.halfOffset;
    }

    static void copyBytes(State s2, byte[] data, int offset, int length) {
        if ((s2.bitOffset & 7) != 0) {
            throw new BrotliRuntimeException("Unaligned copyBytes");
        }
        while (s2.bitOffset != 64 && length != 0) {
            data[offset++] = (byte)BitReader.peekBits(s2);
            s2.bitOffset += 8;
            --length;
        }
        if (length == 0) {
            return;
        }
        int copyNibbles = Math.min(BitReader.halfAvailable(s2), length >> 2);
        if (copyNibbles > 0) {
            int readOffset = s2.halfOffset << 2;
            int delta = copyNibbles << 2;
            System.arraycopy(s2.byteBuffer, readOffset, data, offset, delta);
            offset += delta;
            length -= delta;
            s2.halfOffset += copyNibbles;
        }
        if (length == 0) {
            return;
        }
        if (BitReader.halfAvailable(s2) > 0) {
            BitReader.fillBitWindow(s2);
            while (length != 0) {
                data[offset++] = (byte)BitReader.peekBits(s2);
                s2.bitOffset += 8;
                --length;
            }
            BitReader.checkHealth(s2, 0);
            return;
        }
        while (length > 0) {
            int len = Utils.readInput(s2.input, data, offset, length);
            if (len == -1) {
                throw new BrotliRuntimeException("Unexpected end of input");
            }
            offset += len;
            length -= len;
        }
    }

    static void bytesToNibbles(State s2, int byteLen) {
        byte[] byteBuffer = s2.byteBuffer;
        int halfLen = byteLen >> 2;
        int[] intBuffer = s2.intBuffer;
        for (int i = 0; i < halfLen; ++i) {
            intBuffer[i] = byteBuffer[i * 4] & 0xFF | (byteBuffer[i * 4 + 1] & 0xFF) << 8 | (byteBuffer[i * 4 + 2] & 0xFF) << 16 | (byteBuffer[i * 4 + 3] & 0xFF) << 24;
        }
    }
}

