/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.Position;

public class CommandNoteLong
extends CommandMultilines2<TimingDiagram> {
    public CommandNoteLong() {
        super(CommandNoteLong.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    @Override
    public String getPatternEnd() {
        return "^end[%s]?note$";
    }

    @Override
    protected CommandExecutionResult executeNow(TimingDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        String code = line0.get("CODE", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("Unkown \"" + code + "\"");
        }
        Display note = lines.toDisplay();
        TimeTick now = diagram.getNow();
        String stereotypeString = line0.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereotypeString != null) {
            stereotype = Stereotype.build(stereotypeString);
        }
        player.addNote(now, note, Position.fromString(line0.get("POSITION", 0)), stereotype);
        return CommandExecutionResult.ok();
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNoteLong.class.getName(), RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(top|bottom)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([\\p{L}_][%pLN_.]*)"), RegexLeaf.spaceZeroOrMore(), StereotypePattern.optional("STEREO"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }
}

