/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.yaml.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.yaml.parser.YamlLineType;

public class YamlLine {
    private final int indent;
    private final String key;
    private final String value;
    private final List<String> values;
    private final boolean listItem;
    private final YamlLineType type;

    public static YamlLine build(String line) {
        int colonIndex;
        int count;
        line = line.replaceAll("\t", "    ");
        for (count = 0; count < line.length() && line.charAt(count) == ' '; ++count) {
        }
        String trimmedLine = YamlLine.removeYamlComment(line.substring(count).trim());
        if (trimmedLine.isEmpty()) {
            return new YamlLine(YamlLineType.EMPTY_LINE, 0, null, null, null, false);
        }
        if (trimmedLine.equals("-")) {
            return new YamlLine(YamlLineType.PLAIN_DASH, count + 1, null, null, null, true);
        }
        boolean listItem = trimmedLine.startsWith("- ");
        if (listItem) {
            count += 2;
            trimmedLine = trimmedLine.substring(2);
        }
        if ((colonIndex = trimmedLine.indexOf(58)) == -1) {
            if (listItem) {
                return new YamlLine(YamlLineType.PLAIN_ELEMENT_LIST, count, null, YamlLine.unquote(trimmedLine), null, listItem);
            }
            return new YamlLine(YamlLineType.NO_KEY_ONLY_TEXT, count, null, YamlLine.unquote(trimmedLine), null, false);
        }
        String rawKey = trimmedLine.substring(0, colonIndex).trim();
        String rawValue = trimmedLine.substring(colonIndex + 1).trim();
        YamlLineType type = YamlLineType.KEY_AND_VALUE;
        if (rawValue.isEmpty()) {
            type = YamlLineType.KEY_ONLY;
        } else if (rawValue.equals("|")) {
            type = YamlLineType.KEY_AND_BLOCK_STYLE;
        } else if (rawValue.equals(">")) {
            type = YamlLineType.KEY_AND_FOLDED_STYLE;
        } else if (rawValue.startsWith("[") && rawValue.endsWith("]")) {
            return new YamlLine(YamlLineType.KEY_AND_FLOW_SEQUENCE, count, YamlLine.unquote(rawKey), null, YamlLine.toList(rawValue.substring(1, rawValue.length() - 1)), listItem);
        }
        return new YamlLine(type, count, YamlLine.unquote(rawKey), YamlLine.unquote(rawValue), null, listItem);
    }

    private static List<String> toList(String rawValue) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        char inQuotedString = '\u0000';
        boolean fieldStartWithQuote = false;
        for (int i = 0; i < rawValue.length(); ++i) {
            char c = rawValue.charAt(i);
            if (inQuotedString != '\u0000') {
                if (c == '\\') {
                    if (i + 1 >= rawValue.length()) continue;
                    current.append(rawValue.charAt(i + 1));
                    ++i;
                    continue;
                }
                if (c == inQuotedString) {
                    inQuotedString = '\u0000';
                    continue;
                }
                current.append(c);
                continue;
            }
            if (!fieldStartWithQuote && current.toString().trim().isEmpty() && (c == '\'' || c == '\"')) {
                inQuotedString = c;
                fieldStartWithQuote = true;
                current.setLength(0);
                continue;
            }
            if (c == ',') {
                result.add(fieldStartWithQuote ? current.toString() : current.toString().trim());
                current.setLength(0);
                fieldStartWithQuote = false;
                continue;
            }
            if (c == '\\') {
                if (i + 1 >= rawValue.length()) continue;
                current.append(rawValue.charAt(i + 1));
                ++i;
                continue;
            }
            current.append(c);
        }
        result.add(fieldStartWithQuote ? current.toString() : current.toString().trim());
        return result;
    }

    private YamlLine(YamlLineType type, int indent, String key, String value, List<String> values, boolean listItem) {
        this.type = type;
        this.indent = indent;
        this.key = key;
        this.value = value;
        this.values = values;
        this.listItem = listItem;
    }

    private static String unquote(String str) {
        if (str == null || str.length() < 2) {
            return str;
        }
        char first = str.charAt(0);
        char last = str.charAt(str.length() - 1);
        if (first == '\"' && last == '\"' || first == '\'' && last == '\'') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public int getIndent() {
        return this.indent;
    }

    private static String removeYamlComment(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return s2;
        }
        char inQuoteChar = '\u0000';
        if (s2.charAt(0) == '#') {
            return "";
        }
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\'' || c == '\"') {
                if (inQuoteChar == '\u0000') {
                    inQuoteChar = c;
                } else if (c == inQuoteChar) {
                    inQuoteChar = '\u0000';
                }
            }
            if (inQuoteChar != '\u0000' || i >= s2.length() - 1 || c != ' ' || s2.charAt(i + 1) != '#') continue;
            return s2.substring(0, i);
        }
        return s2;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        if (this.type == YamlLineType.KEY_AND_VALUE || this.type == YamlLineType.KEY_AND_FLOW_SEQUENCE || this.type == YamlLineType.PLAIN_ELEMENT_LIST || this.type == YamlLineType.NO_KEY_ONLY_TEXT) {
            return this.value;
        }
        throw new IllegalStateException(this.type.name());
    }

    public boolean isListItem() {
        return this.listItem;
    }

    public YamlLineType getType() {
        return this.type;
    }

    public List<String> getValues() {
        if (this.type == YamlLineType.KEY_AND_FLOW_SEQUENCE) {
            return Collections.unmodifiableList(this.values);
        }
        throw new IllegalStateException(this.type.name());
    }

    public String toString() {
        return "YamlLine(" + (Object)((Object)this.type) + " indent=" + this.indent + ", key=" + this.key + ", value=" + this.value + ")";
    }
}

