/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.EnumMap;
import java.util.Set;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.AtomicCell;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.ContainerArea;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.GridContainerCell;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.LabelCell;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.StripContainerCell;
import org.eclipse.elk.alg.common.nodespacing.internal.NodeLabelLocation;
import org.eclipse.elk.alg.common.nodespacing.internal.PortContext;
import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortAlignment;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.IndividualSpacings;
import org.eclipse.elk.core.util.adapters.GraphAdapters;

public final class NodeContext {
    public final GraphAdapters.NodeAdapter<?> node;
    public final KVector nodeSize;
    public final boolean treatAsCompoundNode;
    public final Set<SizeConstraint> sizeConstraints;
    public final Set<SizeOptions> sizeOptions;
    public final PortConstraints portConstraints;
    public final Set<PortLabelPlacement> portLabelsPlacement;
    public final boolean portLabelsTreatAsGroup;
    public final Set<NodeLabelPlacement> nodeLabelPlacement;
    public final ElkPadding nodeLabelsPadding;
    public final double nodeLabelSpacing;
    public final double labelLabelSpacing;
    public final double labelCellSpacing;
    public final double portPortSpacing;
    public final double portLabelSpacingHorizontal;
    public final double portLabelSpacingVertical;
    public final ElkMargin surroundingPortMargins;
    public final Multimap<PortSide, PortContext> portContexts = TreeMultimap.create(NodeContext::comparePortSides, NodeContext::comparePortContexts);
    public final StripContainerCell nodeContainer;
    public final StripContainerCell nodeContainerMiddleRow;
    public GridContainerCell insideNodeLabelContainer;
    public final EnumMap<PortSide, AtomicCell> insidePortLabelCells = Maps.newEnumMap(PortSide.class);
    public final EnumMap<PortSide, StripContainerCell> outsideNodeLabelContainers = Maps.newEnumMap(PortSide.class);
    public final EnumMap<NodeLabelLocation, LabelCell> nodeLabelCells = Maps.newEnumMap(NodeLabelLocation.class);

    public NodeContext(GraphAdapters.GraphAdapter<?> parentGraph, GraphAdapters.NodeAdapter<?> node) {
        this.node = node;
        this.nodeSize = new KVector(node.getSize());
        this.treatAsCompoundNode = node.isCompoundNode() || node.getProperty(CoreOptions.INSIDE_SELF_LOOPS_ACTIVATE) != false;
        this.sizeConstraints = node.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS);
        this.sizeOptions = node.getProperty(CoreOptions.NODE_SIZE_OPTIONS);
        this.portConstraints = node.getProperty(CoreOptions.PORT_CONSTRAINTS);
        this.portLabelsPlacement = node.getProperty(CoreOptions.PORT_LABELS_PLACEMENT);
        if (!PortLabelPlacement.isValid(this.portLabelsPlacement)) {
            throw new UnsupportedConfigurationException("Invalid port label placement: " + this.portLabelsPlacement);
        }
        this.portLabelsTreatAsGroup = node.getProperty(CoreOptions.PORT_LABELS_TREAT_AS_GROUP);
        this.nodeLabelPlacement = node.getProperty(CoreOptions.NODE_LABELS_PLACEMENT);
        if (!NodeLabelPlacement.isValid(this.nodeLabelPlacement)) {
            throw new UnsupportedConfigurationException("Invalid node label placement: " + this.nodeLabelPlacement);
        }
        this.nodeLabelsPadding = IndividualSpacings.getIndividualOrInherited(node, CoreOptions.NODE_LABELS_PADDING);
        this.nodeLabelSpacing = IndividualSpacings.getIndividualOrInherited(node, CoreOptions.SPACING_LABEL_NODE);
        this.labelLabelSpacing = IndividualSpacings.getIndividualOrInherited(node, CoreOptions.SPACING_LABEL_LABEL);
        this.portPortSpacing = IndividualSpacings.getIndividualOrInherited(node, CoreOptions.SPACING_PORT_PORT);
        this.portLabelSpacingHorizontal = IndividualSpacings.getIndividualOrInherited(node, CoreOptions.SPACING_LABEL_PORT_HORIZONTAL);
        this.portLabelSpacingVertical = IndividualSpacings.getIndividualOrInherited(node, CoreOptions.SPACING_LABEL_PORT_VERTICAL);
        this.surroundingPortMargins = IndividualSpacings.getIndividualOrInherited(node, CoreOptions.SPACING_PORTS_SURROUNDING);
        this.labelCellSpacing = 2.0 * this.labelLabelSpacing;
        boolean symmetry = !this.sizeOptions.contains((Object)SizeOptions.ASYMMETRICAL);
        this.nodeContainer = new StripContainerCell(StripContainerCell.Strip.VERTICAL, symmetry, 0.0);
        this.nodeContainerMiddleRow = new StripContainerCell(StripContainerCell.Strip.HORIZONTAL, symmetry, 0.0);
        this.nodeContainer.setCell(ContainerArea.CENTER, this.nodeContainerMiddleRow);
    }

    public void applyNodeSize() {
        this.node.setSize(this.nodeSize);
    }

    public PortAlignment getPortAlignment(PortSide portSide) {
        PortAlignment alignment = null;
        switch (portSide) {
            case NORTH: {
                if (!this.node.hasProperty(CoreOptions.PORT_ALIGNMENT_NORTH)) break;
                alignment = this.node.getProperty(CoreOptions.PORT_ALIGNMENT_NORTH);
                break;
            }
            case SOUTH: {
                if (!this.node.hasProperty(CoreOptions.PORT_ALIGNMENT_SOUTH)) break;
                alignment = this.node.getProperty(CoreOptions.PORT_ALIGNMENT_SOUTH);
                break;
            }
            case EAST: {
                if (!this.node.hasProperty(CoreOptions.PORT_ALIGNMENT_EAST)) break;
                alignment = this.node.getProperty(CoreOptions.PORT_ALIGNMENT_EAST);
                break;
            }
            case WEST: {
                if (!this.node.hasProperty(CoreOptions.PORT_ALIGNMENT_WEST)) break;
                alignment = this.node.getProperty(CoreOptions.PORT_ALIGNMENT_WEST);
            }
        }
        if (alignment == null) {
            alignment = this.node.getProperty(CoreOptions.PORT_ALIGNMENT_DEFAULT);
        }
        return alignment;
    }

    public static int comparePortSides(PortSide portSide1, PortSide portSide2) {
        return Integer.compare(portSide1.ordinal(), portSide2.ordinal());
    }

    public static int comparePortContexts(PortContext portContext1, PortContext portContext2) {
        int portSideComparison = NodeContext.comparePortSides(portContext1.port.getSide(), portContext2.port.getSide());
        if (portSideComparison != 0) {
            return portSideComparison;
        }
        switch (portContext1.port.getSide()) {
            case NORTH: 
            case EAST: {
                return Integer.compare(portContext1.port.getVolatileId(), portContext2.port.getVolatileId());
            }
            case SOUTH: 
            case WEST: {
                return Integer.compare(portContext2.port.getVolatileId(), portContext1.port.getVolatileId());
            }
        }
        assert (false);
        return 0;
    }
}

