/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.batik.anim.timing.InstanceTime;
import org.apache.batik.anim.timing.TimedElement;

public class Interval {
    protected float begin;
    protected float end;
    protected InstanceTime beginInstanceTime;
    protected InstanceTime endInstanceTime;
    protected LinkedList beginDependents = new LinkedList();
    protected LinkedList endDependents = new LinkedList();

    public Interval(float f, float f2, InstanceTime instanceTime, InstanceTime instanceTime2) {
        this.begin = f;
        this.end = f2;
        this.beginInstanceTime = instanceTime;
        this.endInstanceTime = instanceTime2;
    }

    public String toString() {
        return TimedElement.toString(this.begin) + ".." + TimedElement.toString(this.end);
    }

    public float getBegin() {
        return this.begin;
    }

    public float getEnd() {
        return this.end;
    }

    public InstanceTime getBeginInstanceTime() {
        return this.beginInstanceTime;
    }

    public InstanceTime getEndInstanceTime() {
        return this.endInstanceTime;
    }

    void addDependent(InstanceTime instanceTime, boolean bl) {
        if (bl) {
            this.beginDependents.add(instanceTime);
        } else {
            this.endDependents.add(instanceTime);
        }
    }

    void removeDependent(InstanceTime instanceTime, boolean bl) {
        if (bl) {
            this.beginDependents.remove(instanceTime);
        } else {
            this.endDependents.remove(instanceTime);
        }
    }

    float setBegin(float f) {
        float f2 = Float.POSITIVE_INFINITY;
        this.begin = f;
        Iterator iterator = this.beginDependents.iterator();
        while (iterator.hasNext()) {
            InstanceTime instanceTime = (InstanceTime)iterator.next();
            float f3 = instanceTime.dependentUpdate(f);
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    float setEnd(float f, InstanceTime instanceTime) {
        float f2 = Float.POSITIVE_INFINITY;
        this.end = f;
        this.endInstanceTime = instanceTime;
        Iterator iterator = this.endDependents.iterator();
        while (iterator.hasNext()) {
            InstanceTime instanceTime2 = (InstanceTime)iterator.next();
            float f3 = instanceTime2.dependentUpdate(f);
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }
}

