/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebListenerAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = LoggerFactory.getLogger(WebListenerAnnotation.class);

    public WebListenerAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public WebListenerAnnotation(WebAppContext context, String className, Resource resource) {
        super(context, className, resource);
    }

    @Override
    public void apply() {
        Class<?> clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn("{} cannot be loaded", (Object)this._className);
            return;
        }
        try {
            if (ServletContextListener.class.isAssignableFrom(clazz) || ServletContextAttributeListener.class.isAssignableFrom(clazz) || ServletRequestListener.class.isAssignableFrom(clazz) || ServletRequestAttributeListener.class.isAssignableFrom(clazz) || HttpSessionListener.class.isAssignableFrom(clazz) || HttpSessionAttributeListener.class.isAssignableFrom(clazz) || HttpSessionIdListener.class.isAssignableFrom(clazz)) {
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOrigin(clazz.getName() + ".listener") == Origin.NotSet) {
                    ListenerHolder h = this._context.getServletHandler().newListenerHolder(new Source(Source.Origin.ANNOTATION, clazz.getName()));
                    h.setHeldClass(clazz);
                    this._context.getServletHandler().addListener(h);
                    metaData.setOrigin(clazz.getName() + ".listener", clazz.getAnnotation(WebListener.class), clazz);
                }
            } else {
                LOG.warn("{} does not implement one of the servlet listener interfaces", (Object)clazz.getName());
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to add listener {}", (Object)clazz, (Object)e);
        }
    }
}

