/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.merge;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import org.protege.editor.owl.model.merge.MergeEntitiesChangeListGenerator;
import org.protege.editor.owl.ui.action.SelectedOWLEntityAction;
import org.protege.editor.owl.ui.merge.MergeEntitiesPanel;
import org.protege.editor.owl.ui.merge.MergeStrategy;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class MergeEntitiesAction
extends SelectedOWLEntityAction {
    @Override
    protected void actionPerformed(OWLEntity selectedEntity) {
        Optional<OWLEntity> targetEntity = MergeEntitiesPanel.showDialog(this.getOWLEditorKit());
        targetEntity.ifPresent(entity -> this.mergeEntities(selectedEntity, (OWLEntity)entity));
    }

    private void mergeEntities(OWLEntity sourceEntity, OWLEntity targetEntity) {
        OWLOntology rootOntology = this.getOWLModelManager().getActiveOntology();
        OWLDataFactory dataFactory = this.getOWLModelManager().getOWLDataFactory();
        MergeEntitiesChangeListGenerator gen = new MergeEntitiesChangeListGenerator(rootOntology, dataFactory, (ImmutableSet<OWLEntity>)ImmutableSet.of((Object)sourceEntity), targetEntity, MergeStrategy.DELETE_SOURCE_ENTITY);
        List<OWLOntologyChange> changes = gen.generateChanges();
        this.getOWLModelManager().applyChanges(changes);
        this.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity(targetEntity);
    }

    @Override
    protected void disposeAction() throws Exception {
    }
}

