/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.protege.editor.owl.ui.renderer.OWLEntityIcon;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;

public class OWLClassIcon
extends OWLEntityIcon {
    public static final Color COLOR = OWLSystemColors.getOWLClassColor();
    public static final BasicStroke HOLLOW_STROKE = new BasicStroke(2.0f);
    private Type type;

    public OWLClassIcon() {
        this(Type.PRIMITIVE, OWLEntityIcon.FillType.FILLED);
    }

    public OWLClassIcon(Type type) {
        this(type, OWLEntityIcon.FillType.FILLED);
    }

    public OWLClassIcon(Type type, OWLEntityIcon.FillType fillType) {
        super(fillType);
        this.type = type;
    }

    @Override
    public Color getEntityColor() {
        return COLOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int clsSize = this.getBaseSize() - 2;
            int dW = this.getIconWidth() / 2 - clsSize / 2;
            int xC = x + dW;
            int dH = this.getIconHeight() / 2 - clsSize / 2;
            int yC = y + dH;
            if (this.getFillType() == OWLEntityIcon.FillType.FILLED) {
                g2.setColor(this.getBorderColor());
                g2.fillOval(xC, yC, clsSize, clsSize);
                g2.setColor(this.getColor());
                g2.fillOval(xC + 1, yC + 1, clsSize - 2, clsSize - 2);
            } else {
                g2.setStroke(HOLLOW_STROKE);
                g2.setColor(this.getColor());
                g2.drawOval(xC + 1, yC + 1, clsSize - 2, clsSize - 2);
            }
            if (this.type.equals((Object)Type.DEFINED)) {
                if (this.getFillType() == OWLEntityIcon.FillType.FILLED) {
                    g2.setColor(Color.WHITE);
                } else {
                    g2.setColor(this.getColor());
                }
                int centreSize = (int)Math.sqrt(clsSize / 2 * clsSize / 2);
                int boxWidth = centreSize / 2 * 2;
                int boxHeight = centreSize / 5 * 5;
                int boxX = (this.getIconWidth() - boxWidth) / 2;
                int boxY = (this.getIconHeight() - boxHeight) / 2;
                g2.fillRect(x + boxX, y + boxY, boxWidth, boxHeight);
                int stripeHeight = boxHeight / 5;
                g2.setColor(this.getColor());
                g2.fillRect(x + boxX, y + boxY + stripeHeight, boxWidth, stripeHeight);
                g2.fillRect(x + boxX, y + boxY + stripeHeight * 3, boxWidth, stripeHeight);
            }
        }
        finally {
            g2.dispose();
        }
    }

    public static enum Type {
        PRIMITIVE,
        DEFINED;

    }
}

