/*
 * Decompiled with CFR 0.152.
 */
package uk.org.russet.identitas;

import java.io.IOException;
import java.io.StringReader;
import java.util.Random;
import uk.org.russet.identitas.Damm;
import uk.org.russet.proquint.Proquint;

public class Util {
    public static int INTEGER_MIN = Integer.MIN_VALUE;
    public static int INTEGER_MAX = Integer.MAX_VALUE;

    private static int max_val_by_10() {
        int a = INTEGER_MAX / 10;
        return a;
    }

    public static String randomDammProint() throws IOException {
        int checked_num;
        Random rand = new Random();
        int number = rand.nextInt(Util.max_val_by_10());
        int sign = rand.nextInt(2);
        if (sign == 1) {
            number *= -1;
        }
        try {
            checked_num = Damm.generateCheckSum(number);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("IndexOutOfBoundsException: " + e.getMessage());
        }
        return Util.intToProint(checked_num);
    }

    public static boolean prointDammValid(String int_proquint) throws Exception {
        boolean result = false;
        String temp = int_proquint.toLowerCase();
        if (temp.length() == 11 && temp.matches("[A-Za-z -]+")) {
            StringReader proint_val = new StringReader(temp);
            long return_proquint = Proquint.quint2uint(proint_val);
            try {
                result = Damm.validate(return_proquint);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("IndexOutOfBoundsException: " + e.getMessage());
            }
        } else {
            throw new IOException("Not valid entry: input must be alphabets and 11 length, plus '-' [A-Za-z -]" + temp.toString());
        }
        return result;
    }

    public static String intToProint(int number) throws IOException {
        int proint_length = 11;
        StringBuffer buffer = new StringBuffer(11);
        if (number > Integer.MAX_VALUE && number >= Integer.MIN_VALUE) {
            throw new IOException("Number out of range: " + number);
        }
        Proquint.uint2quint(buffer, number, '-');
        return buffer.toString();
    }

    public static String shortToProshort(short number) throws IOException {
        int proshort_length = 5;
        StringBuffer buffer = new StringBuffer(5);
        Proquint.uint2quint(buffer, number, '-');
        return buffer.subSequence(6, 11).toString();
    }

    public static String longToProlong(long number) throws IOException {
        long firstpart = number >> 32;
        int secpart = (int)number;
        int prolong_length = 11;
        StringBuffer longnumb = new StringBuffer(12);
        StringBuffer longnumb1 = new StringBuffer(11);
        Proquint.uint2quint(longnumb, (int)firstpart, '-');
        Proquint.uint2quint(longnumb1, secpart, '-');
        return longnumb.toString() + "-" + longnumb1.toString();
    }

    public static int prointToInt(String int_proquint) throws IOException {
        String temp = int_proquint.toLowerCase();
        if (temp.length() != 11 || !temp.matches("[A-Za-z -]+")) {
            throw new IOException("Not valid entry; input must be alphabets and 11 length, plus '-' [A-Za-z -]" + temp.toString());
        }
        StringReader proint_val = new StringReader(temp);
        int return_proquint = (int)Proquint.quint2uint(proint_val);
        return return_proquint;
    }

    public static int proshortToShort(String short_proquint) throws IOException {
        String temp = short_proquint.toLowerCase();
        if (temp.length() != 5 || !temp.matches("[A-Za-z]+")) {
            throw new IOException("Not a valid entry; input must be alphabets and 5 length" + temp.toString());
        }
        StringReader proint_val = new StringReader(temp);
        short return_proquint = (short)Proquint.quint2uint(proint_val);
        return return_proquint;
    }

    public static long prolongToLong(String long_proquint) throws IOException {
        int uint = Integer.parseUnsignedInt("4294967295");
        long bitmask = Integer.toUnsignedLong(uint);
        String temp = long_proquint.toLowerCase();
        if (temp.length() != 23 || !temp.matches("[A-Za-z -]+")) {
            throw new IOException("Not a valid entry: input must be alphabets and 23 length " + temp.toString());
        }
        StringReader proint_val = new StringReader(temp.substring(0, 11));
        StringReader proint_val2 = new StringReader(temp.substring(12, 23));
        long return_proquint = Proquint.quint2uint(proint_val);
        long return_proquint2 = Proquint.quint2uint(proint_val2);
        long left_shift = return_proquint << 32;
        long bit_and = return_proquint2 & bitmask;
        long result = left_shift | bit_and;
        return result;
    }

    public static String randomProshort() throws IOException {
        int min = Short.MIN_VALUE;
        int max = Short.MAX_VALUE;
        Random rand = new Random();
        short number = (short)(rand.nextInt(max - min) + min);
        return Util.shortToProshort(number);
    }

    public static String randomProint() throws IOException {
        Random rand = new Random();
        int number = rand.nextInt(Integer.MAX_VALUE);
        int sign = rand.nextInt(2);
        if (sign == 1) {
            number *= -1;
        }
        return Util.intToProint(number);
    }

    public static String randomProlong() throws IOException {
        Random rand = new Random();
        long n = rand.nextLong();
        return Util.longToProlong(n);
    }
}

