/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.sets.ObjectHashSet;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

class HPPCSet<S>
implements Collection<S> {
    private final ObjectHashSet<S> delegate;

    public HPPCSet() {
        this.delegate = new ObjectHashSet();
    }

    public HPPCSet(int initialCapacity) {
        this.delegate = new ObjectHashSet(initialCapacity);
    }

    public HPPCSet(int initialCapacity, double loadFactor) {
        this.delegate = new ObjectHashSet(initialCapacity, loadFactor);
    }

    public HPPCSet(Collection<S> container) {
        this.delegate = new ObjectHashSet(container.size() + 1);
        this.addAll((Collection<? extends S>)container);
    }

    public HPPCSet(Collection<S> container, S s) {
        this.delegate = new ObjectHashSet(container.size() + 1);
        this.addAll((Collection<? extends S>)container);
        this.add(s);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<S> iterator() {
        final ObjectHashSet.EntryIterator iterator = this.delegate.iterator();
        return new Iterator<S>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public S next() {
                return ((ObjectCursor)iterator.next()).value;
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(@Nullable T[] a) {
        throw new UnsupportedOperationException("Not suppoerted for " + this.getClass());
    }

    @Override
    public boolean add(@Nullable S e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(@Nullable Collection<?> c) {
        for (Object o : c) {
            if (this.delegate.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends S> c) {
        boolean toReturn = false;
        for (S s : c) {
            if (!this.add(s)) continue;
            toReturn = true;
        }
        return toReturn;
    }

    @Override
    public boolean removeAll(@Nullable Collection<?> c) {
        boolean toReturn = false;
        for (Object s : c) {
            if (!this.remove(s)) continue;
            toReturn = true;
        }
        return toReturn;
    }

    @Override
    public boolean retainAll(@Nullable Collection<?> c) {
        return this.delegate.retainAll(new HPPCSet<?>(OWLAPIPreconditions.verifyNotNull(c)).delegate) > 0;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

