# The PEP 484 type hints stub file for the Qt3DCore module.
#
# Generated by SIP 6.10.0
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-3D.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QAbstractAspect(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def unregisterBackendType(self, a0: QtCore.QMetaObject) -> None: ...
    def registerBackendType(self, a0: QtCore.QMetaObject, functor: 'QBackendNodeMapper') -> None: ...
    def rootEntityId(self) -> 'QNodeId': ...


class QAbstractFunctor(PyQt6.sip.simplewrapper):

    def __init__(self) -> None: ...

    def id(self) -> PyQt6.sip.voidptr: ...


class QNode(QtCore.QObject):

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    nodeDestroyed: typing.ClassVar[QtCore.pyqtSignal]
    enabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    parentChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setEnabled(self, isEnabled: bool) -> None: ...
    def setParent(self, parent: typing.Optional['QNode']) -> None: ...
    def isEnabled(self) -> bool: ...
    def childNodes(self) -> list['QNode']: ...
    def blockNotifications(self, block: bool) -> bool: ...
    def notificationsBlocked(self) -> bool: ...
    def parentNode(self) -> typing.Optional['QNode']: ...
    def id(self) -> 'QNodeId': ...


class QAbstractSkeleton('QNode'):

    jointCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    def jointCount(self) -> int: ...


class QComponent('QNode'):

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    removedFromEntity: typing.ClassVar[QtCore.pyqtSignal]
    addedToEntity: typing.ClassVar[QtCore.pyqtSignal]
    shareableChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setShareable(self, isShareable: bool) -> None: ...
    def entities(self) -> list['QEntity']: ...
    def isShareable(self) -> bool: ...


class QArmature('QComponent'):

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    skeletonChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSkeleton(self, skeleton: typing.Optional['QAbstractSkeleton']) -> None: ...
    def skeleton(self) -> typing.Optional['QAbstractSkeleton']: ...


class QAspectEngine(QtCore.QObject):

    class RunMode(enum.Enum):
        Manual = ... # type: QAspectEngine.RunMode
        Automatic = ... # type: QAspectEngine.RunMode

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def processFrame(self) -> None: ...
    def runMode(self) -> 'QAspectEngine.RunMode': ...
    def setRunMode(self, mode: 'QAspectEngine.RunMode') -> None: ...
    def executeCommand(self, command: typing.Optional[str]) -> typing.Any: ...
    def aspects(self) -> list['QAbstractAspect']: ...
    def aspect(self, name: typing.Optional[str]) -> typing.Optional['QAbstractAspect']: ...
    @typing.overload
    def unregisterAspect(self, aspect: typing.Optional['QAbstractAspect']) -> None: ...
    @typing.overload
    def unregisterAspect(self, name: typing.Optional[str]) -> None: ...
    @typing.overload
    def registerAspect(self, aspect: typing.Optional['QAbstractAspect']) -> None: ...
    @typing.overload
    def registerAspect(self, name: typing.Optional[str]) -> None: ...
    def rootEntity(self) -> 'QEntity': ...
    def setRootEntity(self, root: 'QEntity') -> None: ...


class QAttribute('QNode'):

    class VertexBaseType(enum.Enum):
        Byte = ... # type: QAttribute.VertexBaseType
        UnsignedByte = ... # type: QAttribute.VertexBaseType
        Short = ... # type: QAttribute.VertexBaseType
        UnsignedShort = ... # type: QAttribute.VertexBaseType
        Int = ... # type: QAttribute.VertexBaseType
        UnsignedInt = ... # type: QAttribute.VertexBaseType
        HalfFloat = ... # type: QAttribute.VertexBaseType
        Float = ... # type: QAttribute.VertexBaseType
        Double = ... # type: QAttribute.VertexBaseType

    class AttributeType(enum.Enum):
        VertexAttribute = ... # type: QAttribute.AttributeType
        IndexAttribute = ... # type: QAttribute.AttributeType
        DrawIndirectAttribute = ... # type: QAttribute.AttributeType

    @typing.overload
    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...
    @typing.overload
    def __init__(self, buf: typing.Optional['QBuffer'], vertexBaseType: 'QAttribute.VertexBaseType', vertexSize: int, count: int, offset: int = ..., stride: int = ..., parent: typing.Optional['QNode'] = ...) -> None: ...
    @typing.overload
    def __init__(self, buf: typing.Optional['QBuffer'], name: typing.Optional[str], vertexBaseType: 'QAttribute.VertexBaseType', vertexSize: int, count: int, offset: int = ..., stride: int = ..., parent: typing.Optional['QNode'] = ...) -> None: ...

    attributeTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    divisorChanged: typing.ClassVar[QtCore.pyqtSignal]
    byteOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    byteStrideChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    vertexSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    vertexBaseTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    bufferChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setAttributeType(self, attributeType: 'QAttribute.AttributeType') -> None: ...
    def setDivisor(self, divisor: int) -> None: ...
    def setByteOffset(self, byteOffset: int) -> None: ...
    def setByteStride(self, byteStride: int) -> None: ...
    def setCount(self, count: int) -> None: ...
    def setVertexSize(self, size: int) -> None: ...
    def setVertexBaseType(self, type: 'QAttribute.VertexBaseType') -> None: ...
    def setName(self, name: typing.Optional[str]) -> None: ...
    def setBuffer(self, buffer: typing.Optional['QBuffer']) -> None: ...
    @staticmethod
    def defaultTextureCoordinate2AttributeName() -> str: ...
    @staticmethod
    def defaultTextureCoordinate1AttributeName() -> str: ...
    @staticmethod
    def defaultJointWeightsAttributeName() -> str: ...
    @staticmethod
    def defaultJointIndicesAttributeName() -> str: ...
    @staticmethod
    def defaultTangentAttributeName() -> str: ...
    @staticmethod
    def defaultTextureCoordinateAttributeName() -> str: ...
    @staticmethod
    def defaultColorAttributeName() -> str: ...
    @staticmethod
    def defaultNormalAttributeName() -> str: ...
    @staticmethod
    def defaultPositionAttributeName() -> str: ...
    def attributeType(self) -> 'QAttribute.AttributeType': ...
    def divisor(self) -> int: ...
    def byteOffset(self) -> int: ...
    def byteStride(self) -> int: ...
    def count(self) -> int: ...
    def vertexSize(self) -> int: ...
    def vertexBaseType(self) -> 'QAttribute.VertexBaseType': ...
    def name(self) -> str: ...
    def buffer(self) -> typing.Optional['QBuffer']: ...


class QBackendNodeMapper(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QBackendNodeMapper') -> None: ...

    def destroy(self, id: 'QNodeId') -> None: ...
    def get(self, id: 'QNodeId') -> typing.Optional['QBackendNode']: ...
    def create(self, id: 'QNodeId') -> typing.Optional['QBackendNode']: ...


class QBackendNode(PyQt6.sip.simplewrapper):

    class Mode(enum.Enum):
        ReadOnly = ... # type: QBackendNode.Mode
        ReadWrite = ... # type: QBackendNode.Mode

    def __init__(self, mode: 'QBackendNode.Mode' = ...) -> None: ...

    def syncFromFrontEnd(self, frontEnd: typing.Optional['QNode'], firstTime: bool) -> None: ...
    def mode(self) -> 'QBackendNode.Mode': ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def peerId(self) -> 'QNodeId': ...


class QBoundingVolume('QComponent'):

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    maxPointChanged: typing.ClassVar[QtCore.pyqtSignal]
    minPointChanged: typing.ClassVar[QtCore.pyqtSignal]
    implicitPointsValidChanged: typing.ClassVar[QtCore.pyqtSignal]
    implicitMaxPointChanged: typing.ClassVar[QtCore.pyqtSignal]
    implicitMinPointChanged: typing.ClassVar[QtCore.pyqtSignal]
    viewChanged: typing.ClassVar[QtCore.pyqtSignal]
    def updateImplicitBounds(self) -> bool: ...
    def setMaxPoint(self, maxPoint: QtGui.QVector3D) -> None: ...
    def setMinPoint(self, minPoint: QtGui.QVector3D) -> None: ...
    def setView(self, view: typing.Optional['QGeometryView']) -> None: ...
    def maxPoint(self) -> QtGui.QVector3D: ...
    def minPoint(self) -> QtGui.QVector3D: ...
    def areImplicitPointsValid(self) -> bool: ...
    def implicitMaxPoint(self) -> QtGui.QVector3D: ...
    def implicitMinPoint(self) -> QtGui.QVector3D: ...
    def view(self) -> typing.Optional['QGeometryView']: ...


class QBuffer('QNode'):

    class AccessType(enum.Enum):
        Write = ... # type: QBuffer.AccessType
        Read = ... # type: QBuffer.AccessType
        ReadWrite = ... # type: QBuffer.AccessType

    class UsageType(enum.Enum):
        StreamDraw = ... # type: QBuffer.UsageType
        StreamRead = ... # type: QBuffer.UsageType
        StreamCopy = ... # type: QBuffer.UsageType
        StaticDraw = ... # type: QBuffer.UsageType
        StaticRead = ... # type: QBuffer.UsageType
        StaticCopy = ... # type: QBuffer.UsageType
        DynamicDraw = ... # type: QBuffer.UsageType
        DynamicRead = ... # type: QBuffer.UsageType
        DynamicCopy = ... # type: QBuffer.UsageType

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    dataAvailable: typing.ClassVar[QtCore.pyqtSignal]
    accessTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    usageChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setAccessType(self, access: 'QBuffer.AccessType') -> None: ...
    def setUsage(self, usage: 'QBuffer.UsageType') -> None: ...
    def updateData(self, offset: int, bytes: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def setData(self, bytes: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def accessType(self) -> 'QBuffer.AccessType': ...
    def usage(self) -> 'QBuffer.UsageType': ...


class QCoreSettings('QComponent'):

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    boundingVolumesEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setBoundingVolumesEnabled(self, boundingVolumesEnabled: bool) -> None: ...
    def boundingVolumesEnabled(self) -> bool: ...


class QEntity('QNode'):

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    def parentEntity(self) -> typing.Optional['QEntity']: ...
    def removeComponent(self, comp: typing.Optional['QComponent']) -> None: ...
    def addComponent(self, comp: typing.Optional['QComponent']) -> None: ...
    def components(self) -> list['QComponent']: ...


class QGeometry('QNode'):

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    maxExtentChanged: typing.ClassVar[QtCore.pyqtSignal]
    minExtentChanged: typing.ClassVar[QtCore.pyqtSignal]
    boundingVolumePositionAttributeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setBoundingVolumePositionAttribute(self, boundingVolumePositionAttribute: typing.Optional['QAttribute']) -> None: ...
    def maxExtent(self) -> QtGui.QVector3D: ...
    def minExtent(self) -> QtGui.QVector3D: ...
    def boundingVolumePositionAttribute(self) -> typing.Optional['QAttribute']: ...
    def removeAttribute(self, attribute: typing.Optional['QAttribute']) -> None: ...
    def addAttribute(self, attribute: typing.Optional['QAttribute']) -> None: ...
    def attributes(self) -> list['QAttribute']: ...


class QGeometryView('QNode'):

    class PrimitiveType(enum.Enum):
        Points = ... # type: QGeometryView.PrimitiveType
        Lines = ... # type: QGeometryView.PrimitiveType
        LineLoop = ... # type: QGeometryView.PrimitiveType
        LineStrip = ... # type: QGeometryView.PrimitiveType
        Triangles = ... # type: QGeometryView.PrimitiveType
        TriangleStrip = ... # type: QGeometryView.PrimitiveType
        TriangleFan = ... # type: QGeometryView.PrimitiveType
        LinesAdjacency = ... # type: QGeometryView.PrimitiveType
        TrianglesAdjacency = ... # type: QGeometryView.PrimitiveType
        LineStripAdjacency = ... # type: QGeometryView.PrimitiveType
        TriangleStripAdjacency = ... # type: QGeometryView.PrimitiveType
        Patches = ... # type: QGeometryView.PrimitiveType

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    primitiveTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    geometryChanged: typing.ClassVar[QtCore.pyqtSignal]
    primitiveRestartEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    verticesPerPatchChanged: typing.ClassVar[QtCore.pyqtSignal]
    restartIndexValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    indexBufferByteOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstVertexChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstInstanceChanged: typing.ClassVar[QtCore.pyqtSignal]
    indexOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    vertexCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    instanceCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setPrimitiveType(self, primitiveType: 'QGeometryView.PrimitiveType') -> None: ...
    def setGeometry(self, geometry: typing.Optional['QGeometry']) -> None: ...
    def setPrimitiveRestartEnabled(self, enabled: bool) -> None: ...
    def setVerticesPerPatch(self, verticesPerPatch: int) -> None: ...
    def setRestartIndexValue(self, index: int) -> None: ...
    def setIndexBufferByteOffset(self, offset: int) -> None: ...
    def setFirstVertex(self, firstVertex: int) -> None: ...
    def setFirstInstance(self, firstInstance: int) -> None: ...
    def setIndexOffset(self, indexOffset: int) -> None: ...
    def setVertexCount(self, vertexCount: int) -> None: ...
    def setInstanceCount(self, instanceCount: int) -> None: ...
    def primitiveType(self) -> 'QGeometryView.PrimitiveType': ...
    def geometry(self) -> typing.Optional['QGeometry']: ...
    def primitiveRestartEnabled(self) -> bool: ...
    def verticesPerPatch(self) -> int: ...
    def restartIndexValue(self) -> int: ...
    def indexBufferByteOffset(self) -> int: ...
    def firstVertex(self) -> int: ...
    def firstInstance(self) -> int: ...
    def indexOffset(self) -> int: ...
    def vertexCount(self) -> int: ...
    def instanceCount(self) -> int: ...


class QJoint('QNode'):

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationZChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationYChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationXChanged: typing.ClassVar[QtCore.pyqtSignal]
    inverseBindMatrixChanged: typing.ClassVar[QtCore.pyqtSignal]
    translationChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    scaleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setToIdentity(self) -> None: ...
    def setName(self, name: typing.Optional[str]) -> None: ...
    def setRotationZ(self, rotationZ: float) -> None: ...
    def setRotationY(self, rotationY: float) -> None: ...
    def setRotationX(self, rotationX: float) -> None: ...
    def setInverseBindMatrix(self, inverseBindMatrix: QtGui.QMatrix4x4) -> None: ...
    def setTranslation(self, translation: QtGui.QVector3D) -> None: ...
    def setRotation(self, rotation: QtGui.QQuaternion) -> None: ...
    def setScale(self, scale: QtGui.QVector3D) -> None: ...
    def childJoints(self) -> list['QJoint']: ...
    def removeChildJoint(self, joint: typing.Optional['QJoint']) -> None: ...
    def addChildJoint(self, joint: typing.Optional['QJoint']) -> None: ...
    def name(self) -> str: ...
    def rotationZ(self) -> float: ...
    def rotationY(self) -> float: ...
    def rotationX(self) -> float: ...
    def inverseBindMatrix(self) -> QtGui.QMatrix4x4: ...
    def translation(self) -> QtGui.QVector3D: ...
    def rotation(self) -> QtGui.QQuaternion: ...
    def scale(self) -> QtGui.QVector3D: ...


class QNodeIdTypePair(PyQt6.sip.simplewrapper):

    id = ... # type: 'QNodeId'
    type = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, _id: 'QNodeId', _type: typing.Optional[QtCore.QMetaObject]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QNodeIdTypePair') -> None: ...


class QNodeId(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QNodeId') -> None: ...

    def __ge__(self, other: 'QNodeId') -> bool: ...
    def __le__(self, other: 'QNodeId') -> bool: ...
    def __hash__(self) -> int: ...
    def __int__(self) -> bool: ...
    def id(self) -> int: ...
    def __gt__(self, other: 'QNodeId') -> bool: ...
    def __lt__(self, other: 'QNodeId') -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def isNull(self) -> bool: ...
    @staticmethod
    def createId() -> 'QNodeId': ...


class QSkeleton('QAbstractSkeleton'):

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    rootJointChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setRootJoint(self, rootJoint: typing.Optional['QJoint']) -> None: ...
    def rootJoint(self) -> typing.Optional['QJoint']: ...


class QSkeletonLoader('QAbstractSkeleton'):

    class Status(enum.Enum):
        NotReady = ... # type: QSkeletonLoader.Status
        Ready = ... # type: QSkeletonLoader.Status
        Error = ... # type: QSkeletonLoader.Status

    @typing.overload
    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...
    @typing.overload
    def __init__(self, source: QtCore.QUrl, parent: typing.Optional['QNode'] = ...) -> None: ...

    rootJointChanged: typing.ClassVar[QtCore.pyqtSignal]
    createJointsEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    statusChanged: typing.ClassVar[QtCore.pyqtSignal]
    sourceChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setCreateJointsEnabled(self, enabled: bool) -> None: ...
    def setSource(self, source: QtCore.QUrl) -> None: ...
    def rootJoint(self) -> typing.Optional['QJoint']: ...
    def isCreateJointsEnabled(self) -> bool: ...
    def status(self) -> 'QSkeletonLoader.Status': ...
    def source(self) -> QtCore.QUrl: ...


class QTransform('QComponent'):

    def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

    worldMatrixChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationZChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationYChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationXChanged: typing.ClassVar[QtCore.pyqtSignal]
    matrixChanged: typing.ClassVar[QtCore.pyqtSignal]
    translationChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    scale3DChanged: typing.ClassVar[QtCore.pyqtSignal]
    scaleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setRotationZ(self, rotationZ: float) -> None: ...
    def setRotationY(self, rotationY: float) -> None: ...
    def setRotationX(self, rotationX: float) -> None: ...
    def setMatrix(self, matrix: QtGui.QMatrix4x4) -> None: ...
    def setTranslation(self, translation: QtGui.QVector3D) -> None: ...
    def setRotation(self, rotation: QtGui.QQuaternion) -> None: ...
    def setScale3D(self, scale: QtGui.QVector3D) -> None: ...
    def setScale(self, scale: float) -> None: ...
    def rotationZ(self) -> float: ...
    def rotationY(self) -> float: ...
    def rotationX(self) -> float: ...
    def worldMatrix(self) -> QtGui.QMatrix4x4: ...
    def matrix(self) -> QtGui.QMatrix4x4: ...
    @staticmethod
    def rotateFromAxes(xAxis: QtGui.QVector3D, yAxis: QtGui.QVector3D, zAxis: QtGui.QVector3D) -> QtGui.QMatrix4x4: ...
    @staticmethod
    def rotateAround(point: QtGui.QVector3D, angle: float, axis: QtGui.QVector3D) -> QtGui.QMatrix4x4: ...
    @typing.overload
    @staticmethod
    def fromEulerAngles(eulerAngles: QtGui.QVector3D) -> QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromEulerAngles(pitch: float, yaw: float, roll: float) -> QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromAxesAndAngles(axis1: QtGui.QVector3D, angle1: float, axis2: QtGui.QVector3D, angle2: float) -> QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromAxesAndAngles(axis1: QtGui.QVector3D, angle1: float, axis2: QtGui.QVector3D, angle2: float, axis3: QtGui.QVector3D, angle3: float) -> QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromAxisAndAngle(axis: QtGui.QVector3D, angle: float) -> QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromAxisAndAngle(x: float, y: float, z: float, angle: float) -> QtGui.QQuaternion: ...
    @staticmethod
    def fromAxes(xAxis: QtGui.QVector3D, yAxis: QtGui.QVector3D, zAxis: QtGui.QVector3D) -> QtGui.QQuaternion: ...
    def translation(self) -> QtGui.QVector3D: ...
    def rotation(self) -> QtGui.QQuaternion: ...
    def scale3D(self) -> QtGui.QVector3D: ...
    def scale(self) -> float: ...


def qIdForNode(node: typing.Optional['QNode']) -> 'QNodeId': ...


PYQT_3D_VERSION = ... # type: int
PYQT_3D_VERSION_STR = ... # type: str
