/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.NormalRelativeUrlResolver;
import org.apache.ivy.core.RelativeUrlResolver;
import org.apache.ivy.core.cache.CacheUtil;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.DefaultResolutionCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.check.CheckEngineSettings;
import org.apache.ivy.core.deliver.DeliverEngineSettings;
import org.apache.ivy.core.install.InstallEngineSettings;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.publish.PublishEngineSettings;
import org.apache.ivy.core.repository.RepositoryManagementEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.core.settings.Validatable;
import org.apache.ivy.core.settings.XmlSettingsParser;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.osgi.core.OsgiLatestStrategy;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.circular.ErrorCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.WarnCircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.LatestCompatibleConflictManager;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.conflict.NoConflictManager;
import org.apache.ivy.plugins.conflict.StrictConflictManager;
import org.apache.ivy.plugins.latest.LatestLexicographicStrategy;
import org.apache.ivy.plugins.latest.LatestRevisionStrategy;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.latest.LatestTimeStrategy;
import org.apache.ivy.plugins.lock.ArtifactLockStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.lock.NoLockStrategy;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.matcher.RegexpPatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.report.LogReportOutputter;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.plugins.report.XmlReportOutputter;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.DualResolver;
import org.apache.ivy.plugins.version.ChainVersionMatcher;
import org.apache.ivy.plugins.version.ExactVersionMatcher;
import org.apache.ivy.plugins.version.LatestVersionMatcher;
import org.apache.ivy.plugins.version.SubVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.plugins.version.VersionRangeMatcher;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class IvySettings
implements CheckEngineSettings,
DeliverEngineSettings,
InstallEngineSettings,
PublishEngineSettings,
RepositoryManagementEngineSettings,
RetrieveEngineSettings,
SortEngineSettings {
    private Map typeDefs = new HashMap();
    private Map resolversMap = new HashMap();
    private DependencyResolver defaultResolver;
    private DependencyResolver dictatorResolver = null;
    private String defaultResolverName;
    private File defaultCache;
    private String defaultBranch = null;
    private boolean checkUpToDate = true;
    private ModuleRules moduleSettings = new ModuleRules();
    private Map conflictsManager = new HashMap();
    private Map latestStrategies = new HashMap();
    private Map lockStrategies = new HashMap();
    private Map namespaces = new HashMap();
    private Map matchers = new HashMap();
    private Map reportOutputters = new HashMap();
    private Map versionMatchers = new HashMap();
    private Map circularDependencyStrategies = new HashMap();
    private Map repositoryCacheManagers = new HashMap();
    private Map signatureGenerators = new HashMap();
    private List triggers = new ArrayList();
    private IvyVariableContainer variableContainer = new IvyVariableContainerImpl();
    private boolean validate = true;
    private LatestStrategy defaultLatestStrategy = null;
    private LockStrategy defaultLockStrategy = null;
    private ConflictManager defaultConflictManager = null;
    private CircularDependencyStrategy circularDependencyStrategy = null;
    private RepositoryCacheManager defaultRepositoryCacheManager = null;
    private ResolutionCacheManager resolutionCacheManager = null;
    private List listingIgnore = new ArrayList();
    private boolean repositoriesConfigured;
    private boolean useRemoteConfig = false;
    private File defaultUserDir;
    private File baseDir = new File(".").getAbsoluteFile();
    private List classpathURLs = new ArrayList();
    private ClassLoader classloader;
    private Boolean debugConflictResolution;
    private boolean logNotConvertedExclusionRule;
    private VersionMatcher versionMatcher;
    private StatusManager statusManager;
    private Boolean debugLocking;
    private String defaultCacheIvyPattern;
    private String defaultCacheArtifactPattern;
    private boolean defaultUseOrigin;
    private String defaultResolveMode = "default";

    public IvySettings() {
        this(new IvyVariableContainerImpl());
    }

    public IvySettings(IvyVariableContainer object) {
        this.setVariableContainer((IvyVariableContainer)object);
        this.setVariable("ivy.default.settings.dir", this.getDefaultSettingsDir(), true);
        this.setVariable("ivy.basedir", this.getBaseDir().getAbsolutePath());
        this.setDeprecatedVariable("ivy.default.conf.dir", "ivy.default.settings.dir");
        object = System.getProperty("ivy.typedef.files");
        if (object != null) {
            object = ((String)object).split("\\,");
            for (int i = 0; i < ((String[])object).length; ++i) {
                try {
                    this.typeDefs(new FileInputStream(Checks.checkAbsolute(object[i].trim(), "ivy.typedef.files")), true);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Message.warn("typedefs file not found: " + object[i].trim());
                    continue;
                }
                catch (IOException iOException) {
                    Message.warn("problem with typedef file: " + object[i].trim() + ": " + iOException.getMessage());
                }
            }
        } else {
            try {
                this.typeDefs(IvySettings.getSettingsURL("typedef.properties").openStream(), true);
            }
            catch (IOException iOException) {
                Message.warn("impossible to load default type defs");
            }
        }
        object = new LatestLexicographicStrategy();
        LatestRevisionStrategy latestRevisionStrategy = new LatestRevisionStrategy();
        LatestTimeStrategy latestTimeStrategy = new LatestTimeStrategy();
        OsgiLatestStrategy osgiLatestStrategy = new OsgiLatestStrategy();
        this.addLatestStrategy("latest-revision", latestRevisionStrategy);
        this.addLatestStrategy("latest-lexico", (LatestStrategy)object);
        this.addLatestStrategy("latest-time", latestTimeStrategy);
        this.addLatestStrategy("latest-osgi", osgiLatestStrategy);
        this.addLockStrategy("no-lock", new NoLockStrategy());
        this.addLockStrategy("artifact-lock", new ArtifactLockStrategy(this.debugLocking()));
        this.addConflictManager("latest-revision", new LatestConflictManager("latest-revision", latestRevisionStrategy));
        this.addConflictManager("latest-compatible", new LatestCompatibleConflictManager("latest-compatible", latestRevisionStrategy));
        this.addConflictManager("latest-time", new LatestConflictManager("latest-time", latestTimeStrategy));
        this.addConflictManager("all", new NoConflictManager());
        this.addConflictManager("strict", new StrictConflictManager());
        this.addMatcher(ExactPatternMatcher.INSTANCE);
        this.addMatcher(RegexpPatternMatcher.INSTANCE);
        this.addMatcher(ExactOrRegexpPatternMatcher.INSTANCE);
        try {
            object = IvySettings.class.getClassLoader().loadClass("org.apache.ivy.plugins.matcher.GlobPatternMatcher");
            object = ((Class)object).getField("INSTANCE");
            this.addMatcher((PatternMatcher)((Field)object).get(null));
        }
        catch (Exception exception) {
            Message.info("impossible to define glob matcher: org.apache.ivy.plugins.matcher.GlobPatternMatcher was not found.");
        }
        this.addReportOutputter(new LogReportOutputter());
        this.addReportOutputter(new XmlReportOutputter());
        this.configureDefaultCircularDependencyStrategies();
        this.listingIgnore.add(".cvsignore");
        this.listingIgnore.add("CVS");
        this.listingIgnore.add(".svn");
        this.listingIgnore.add("maven-metadata.xml");
        this.listingIgnore.add("maven-metadata.xml.md5");
        this.listingIgnore.add("maven-metadata.xml.sha1");
        this.addSystemProperties();
    }

    private void addSystemProperties() {
        try {
            this.addAllVariables((Map)System.getProperties().clone());
            return;
        }
        catch (AccessControlException accessControlException) {
            Message.verbose("access denied to getting all system properties: they won't be available as Ivy variables.\nset " + accessControlException.getPermission() + " permission if you want to access them");
            return;
        }
    }

    @Override
    public void configureRepositories(boolean bl) {
        if (!this.repositoriesConfigured) {
            Properties properties;
            block9: {
                properties = new Properties();
                boolean bl2 = false;
                if (this.useRemoteConfig && bl) {
                    try {
                        URL uRL = new URL("http://ant.apache.org/ivy/repository.properties");
                        Message.verbose("configuring repositories with " + uRL);
                        properties.load(URLHandlerRegistry.getDefault().openStream(uRL));
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        Message.verbose("unable to use remote repository configuration: " + exception.getMessage());
                        properties = new Properties();
                    }
                }
                if (!bl2) {
                    InputStream inputStream = null;
                    try {
                        inputStream = IvySettings.getSettingsURL("repository.properties").openStream();
                        properties.load(inputStream);
                    }
                    catch (IOException iOException) {
                        Message.error("unable to use internal repository configuration: " + iOException.getMessage());
                        if (inputStream == null) break block9;
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.addAllVariables(properties, false);
            this.repositoriesConfigured = true;
        }
    }

    public void typeDefs(InputStream inputStream, boolean bl) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            this.typeDefs(properties, bl);
            return;
        }
        finally {
            inputStream.close();
        }
    }

    public void typeDefs(Properties properties, boolean bl) {
        for (String string : properties.keySet()) {
            this.typeDef(string, properties.getProperty(string), bl);
        }
    }

    public void load(URL uRL) throws ParseException, IOException {
        Message.info(":: loading settings :: url = " + uRL);
        long l = System.currentTimeMillis();
        this.setSettingsVariables(uRL);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            IvySettings ivySettings = this;
            ivySettings.setDefaultIvyUserDir(Checks.checkAbsolute(ivySettings.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.loadDefaultProperties();
        new XmlSettingsParser(this).parse(uRL);
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("settings loaded (" + (System.currentTimeMillis() - l) + "ms)");
        this.dumpSettings();
    }

    public void loadDefault() throws ParseException, IOException {
        this.load(IvySettings.getDefaultSettingsURL());
    }

    private void loadDefaultProperties() throws IOException {
        this.loadProperties(IvySettings.getDefaultPropertiesURL(), false);
    }

    public static URL getDefaultPropertiesURL() {
        return IvySettings.getSettingsURL("ivy.properties");
    }

    public static URL getDefaultSettingsURL() {
        return IvySettings.getSettingsURL("ivysettings.xml");
    }

    private String getDefaultSettingsDir() {
        String string = IvySettings.getDefaultSettingsURL().toExternalForm();
        return string.substring(0, string.length() - 15 - 1);
    }

    private static URL getSettingsURL(String string) {
        return XmlSettingsParser.class.getResource(string);
    }

    public void setSettingsVariables(File serializable) {
        try {
            this.setVariable("ivy.settings.dir", new File(((File)serializable).getAbsolutePath()).getParent());
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
            this.setVariable("ivy.settings.file", ((File)serializable).getAbsolutePath());
            this.setDeprecatedVariable("ivy.conf.file", "ivy.settings.file");
            this.setVariable("ivy.settings.url", ((File)serializable).toURI().toURL().toExternalForm());
            this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
            return;
        }
        catch (MalformedURLException malformedURLException) {
            serializable = new IllegalArgumentException("given file cannot be transformed to url: " + serializable);
            ((Throwable)serializable).initCause(malformedURLException);
            throw serializable;
        }
    }

    private void setDeprecatedVariable(String string, String string2) {
        this.setVariable(string, this.getVariable(string2));
    }

    public void setSettingsVariables(URL object) {
        object = ((URL)object).toExternalForm();
        this.setVariable("ivy.settings.url", (String)object);
        this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
        int n = ((String)object).lastIndexOf(47);
        if (n != -1) {
            this.setVariable("ivy.settings.dir", ((String)object).substring(0, n));
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
            return;
        }
        Message.warn("settings url does not contain any slash (/): ivy.settings.dir variable not set");
    }

    private void dumpSettings() {
        Message.verbose("\tdefault cache: " + this.getDefaultCache());
        Message.verbose("\tdefault resolver: " + this.getDefaultResolver());
        Message.debug("\tdefault latest strategy: " + this.getDefaultLatestStrategy());
        Message.debug("\tdefault conflict manager: " + this.getDefaultConflictManager());
        Message.debug("\tcircular dependency strategy: " + this.getCircularDependencyStrategy());
        Message.debug("\tvalidate: " + this.doValidate());
        Message.debug("\tcheck up2date: " + this.isCheckUpToDate());
        if (!this.classpathURLs.isEmpty()) {
            Message.verbose("\t-- " + this.classpathURLs.size() + " custom classpath urls:");
            Iterator<Object> iterator = this.classpathURLs.iterator();
            while (iterator.hasNext()) {
                Message.debug("\t\t" + iterator.next());
            }
        }
        Message.verbose("\t-- " + this.resolversMap.size() + " resolvers:");
        for (DependencyResolver dependencyResolver : this.resolversMap.values()) {
            dependencyResolver.dumpSettings();
        }
        Message.debug("\tmodule settings:");
        this.moduleSettings.dump("\t\t");
    }

    public void loadProperties(URL uRL, boolean bl) throws IOException {
        this.loadProperties(uRL.openStream(), bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadProperties(InputStream inputStream, boolean bl) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            this.addAllVariables(properties, bl);
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void setVariable(String string, String string2) {
        this.setVariable(string, string2, true);
    }

    public void setVariable(String string, String string2, boolean bl) {
        this.variableContainer.setVariable(string, string2, bl);
    }

    public void addAllVariables(Map map) {
        this.addAllVariables(map, true);
    }

    public void addAllVariables(Map<?, ?> object, boolean bl) {
        for (Map.Entry entry : object.entrySet()) {
            String string = entry.getKey().toString();
            Object entry2 = entry.getValue();
            if (entry2 != null && !(entry2 instanceof String)) continue;
            this.setVariable(string, (String)entry2, bl);
        }
    }

    @Override
    public String substitute(String string) {
        return IvyPatternHelper.substituteVariables(string, this.variableContainer);
    }

    @Override
    public IvyVariableContainer getVariables() {
        return this.variableContainer;
    }

    public Class typeDef(String string, String string2) {
        return this.typeDef(string, string2, false);
    }

    public Class typeDef(String string, String object, boolean bl) {
        if ((object = this.classForName((String)object, bl)) != null) {
            this.typeDefs.put(string, object);
        }
        return object;
    }

    private Class classForName(String string, boolean bl) {
        try {
            return this.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                Message.info("impossible to define new type: class not found: " + string + " in " + this.classpathURLs + " nor Ivy classloader");
                return null;
            }
            throw new RuntimeException("impossible to define new type: class not found: " + string + " in " + this.classpathURLs + " nor Ivy classloader");
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classloader == null) {
            this.classloader = this.classpathURLs.isEmpty() ? Ivy.class.getClassLoader() : new URLClassLoader(this.classpathURLs.toArray(new URL[this.classpathURLs.size()]), Ivy.class.getClassLoader());
        }
        return this.classloader;
    }

    public void addClasspathURL(URL uRL) {
        this.classpathURLs.add(uRL);
        this.classloader = null;
    }

    public Map getTypeDefs() {
        return this.typeDefs;
    }

    public void addResolver(DependencyResolver object) {
        if (object == null) {
            throw new NullPointerException("null resolver");
        }
        this.init(object);
        this.resolversMap.put(object.getName(), object);
        if (object instanceof ChainResolver) {
            Object object2 = ((ChainResolver)object).getResolvers();
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (DependencyResolver)object.next();
                this.addResolver((DependencyResolver)object2);
            }
            return;
        }
        if (object instanceof DualResolver) {
            DependencyResolver dependencyResolver = ((DualResolver)object).getIvyResolver();
            if (dependencyResolver != null) {
                this.addResolver(dependencyResolver);
            }
            if ((object = ((DualResolver)object).getArtifactResolver()) != null) {
                this.addResolver((DependencyResolver)object);
            }
        }
    }

    public void setDefaultCache(File file) {
        this.setVariable("ivy.cache.dir", file.getAbsolutePath(), false);
        this.defaultCache = file;
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.defaultCache);
        }
    }

    public void setDefaultResolver(String string) {
        this.checkResolverName(string);
        if (string != null && !string.equals(this.defaultResolverName)) {
            this.defaultResolver = null;
        }
        this.defaultResolverName = string;
    }

    private void checkResolverName(String string) {
        if (string != null && !this.resolversMap.containsKey(string)) {
            throw new IllegalArgumentException("no resolver found called " + string + ": check your settings");
        }
    }

    public void addModuleConfiguration(Map map, PatternMatcher patternMatcher, String string, String string2, String string3, String string4) {
        this.checkResolverName(string);
        this.moduleSettings.defineRule(new MapMatcher(map, patternMatcher), new ModuleSettings(string, string2, string3, string4));
    }

    @Override
    public File resolveFile(String string) {
        return FileUtil.resolveFile(this.baseDir, string);
    }

    public void setBaseDir(File file) {
        this.baseDir = file.getAbsoluteFile();
        this.setVariable("ivy.basedir", this.baseDir.getAbsolutePath());
        this.setVariable("basedir", this.baseDir.getAbsolutePath(), false);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getDefaultIvyUserDir() {
        if (this.defaultUserDir == null) {
            if (this.getVariable("ivy.home") != null) {
                IvySettings ivySettings = this;
                ivySettings.setDefaultIvyUserDir(Checks.checkAbsolute(ivySettings.getVariable("ivy.home"), "ivy.home"));
                Message.verbose("using ivy.default.ivy.user.dir variable for default ivy user dir: " + this.defaultUserDir);
            } else {
                this.setDefaultIvyUserDir(new File(System.getProperty("user.home"), ".ivy2"));
                Message.verbose("no default ivy user dir defined: set to " + this.defaultUserDir);
            }
        }
        return this.defaultUserDir;
    }

    public void setDefaultIvyUserDir(File file) {
        this.defaultUserDir = file;
        this.setVariable("ivy.default.ivy.user.dir", this.defaultUserDir.getAbsolutePath());
        this.setVariable("ivy.home", this.defaultUserDir.getAbsolutePath());
    }

    public File getDefaultCache() {
        if (this.defaultCache == null) {
            String string = this.getVariable("ivy.cache.dir");
            if (string != null) {
                this.defaultCache = Checks.checkAbsolute(string, "ivy.cache.dir");
            } else {
                this.setDefaultCache(new File(this.getDefaultIvyUserDir(), "cache"));
                Message.verbose("no default cache defined: set to " + this.defaultCache);
            }
        }
        return this.defaultCache;
    }

    public void setDefaultRepositoryCacheBasedir(String string) {
        this.setVariable("ivy.cache.repository", string, true);
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.getDefaultRepositoryCacheBasedir());
        }
    }

    public void setDefaultResolutionCacheBasedir(String string) {
        this.setVariable("ivy.cache.resolution", string, true);
        if (this.resolutionCacheManager != null && this.resolutionCacheManager instanceof DefaultResolutionCacheManager) {
            ((DefaultResolutionCacheManager)this.resolutionCacheManager).setBasedir(this.getDefaultResolutionCacheBasedir());
        }
    }

    public File getDefaultRepositoryCacheBasedir() {
        String string = this.getVariable("ivy.cache.repository");
        if (string != null) {
            return Checks.checkAbsolute(string, "ivy.cache.repository");
        }
        return this.getDefaultCache();
    }

    public File getDefaultResolutionCacheBasedir() {
        String string = this.getVariable("ivy.cache.resolution");
        if (string != null) {
            return Checks.checkAbsolute(string, "ivy.cache.resolution");
        }
        return this.getDefaultCache();
    }

    @Override
    public void setDictatorResolver(DependencyResolver dependencyResolver) {
        this.dictatorResolver = dependencyResolver;
    }

    @Override
    public DependencyResolver getResolver(ModuleRevisionId object) {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        object = this.getResolverName((ModuleRevisionId)object);
        return this.getResolver((String)object);
    }

    public DependencyResolver getResolver(String string) {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        DependencyResolver dependencyResolver = (DependencyResolver)this.resolversMap.get(string);
        if (dependencyResolver == null) {
            Message.error("unknown resolver " + string);
        }
        return dependencyResolver;
    }

    public DependencyResolver getDefaultResolver() {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        if (this.defaultResolver == null) {
            this.defaultResolver = (DependencyResolver)this.resolversMap.get(this.defaultResolverName);
        }
        return this.defaultResolver;
    }

    public String getResolverName(ModuleRevisionId object) {
        if ((object = (ModuleSettings)this.moduleSettings.getRule((ModuleRevisionId)object, new Filter(){

            @Override
            public boolean accept(Object object) {
                return ((ModuleSettings)object).getResolverName() != null;
            }
        })) == null) {
            return this.defaultResolverName;
        }
        return ((ModuleSettings)object).getResolverName();
    }

    public String getDefaultBranch(ModuleId object) {
        if ((object = (ModuleSettings)this.moduleSettings.getRule((ModuleId)object, new Filter(){

            @Override
            public boolean accept(Object object) {
                return ((ModuleSettings)object).getBranch() != null;
            }
        })) == null) {
            return this.getDefaultBranch();
        }
        return ((ModuleSettings)object).getBranch();
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String string) {
        this.defaultBranch = string;
    }

    @Override
    public ConflictManager getConflictManager(ModuleId object) {
        if ((object = (ModuleSettings)this.moduleSettings.getRule((ModuleId)object, new Filter(){

            @Override
            public boolean accept(Object object) {
                return ((ModuleSettings)object).getConflictManager() != null;
            }
        })) == null) {
            return this.getDefaultConflictManager();
        }
        ConflictManager conflictManager = this.getConflictManager(((ModuleSettings)object).getConflictManager());
        if (conflictManager == null) {
            throw new IllegalStateException("ivy badly configured: unknown conflict manager " + ((ModuleSettings)object).getConflictManager());
        }
        return conflictManager;
    }

    @Override
    public String getResolveMode(ModuleId object) {
        if ((object = (ModuleSettings)this.moduleSettings.getRule((ModuleId)object, new Filter(){

            @Override
            public boolean accept(Object object) {
                return ((ModuleSettings)object).getResolveMode() != null;
            }
        })) == null) {
            return this.getDefaultResolveMode();
        }
        return ((ModuleSettings)object).getResolveMode();
    }

    public String getDefaultResolveMode() {
        return this.defaultResolveMode;
    }

    public void setDefaultResolveMode(String string) {
        this.defaultResolveMode = string;
    }

    @Override
    public ConflictManager getConflictManager(String string) {
        if ("default".equals(string)) {
            return this.getDefaultConflictManager();
        }
        return (ConflictManager)this.conflictsManager.get(string);
    }

    public void addConflictManager(String string, ConflictManager conflictManager) {
        this.init(conflictManager);
        this.conflictsManager.put(string, conflictManager);
    }

    @Override
    public LatestStrategy getLatestStrategy(String string) {
        if ("default".equals(string)) {
            return this.getDefaultLatestStrategy();
        }
        return (LatestStrategy)this.latestStrategies.get(string);
    }

    public void addLatestStrategy(String string, LatestStrategy latestStrategy) {
        this.init(latestStrategy);
        this.latestStrategies.put(string, latestStrategy);
    }

    public LockStrategy getLockStrategy(String string) {
        if ("default".equals(string)) {
            return this.getDefaultLockStrategy();
        }
        return (LockStrategy)this.lockStrategies.get(string);
    }

    public void addLockStrategy(String string, LockStrategy lockStrategy) {
        this.init(lockStrategy);
        this.lockStrategies.put(string, lockStrategy);
    }

    @Override
    public Namespace getNamespace(String string) {
        if ("system".equals(string)) {
            return this.getSystemNamespace();
        }
        return (Namespace)this.namespaces.get(string);
    }

    @Override
    public Namespace getSystemNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    @Override
    public PatternMatcher getMatcher(String string) {
        return (PatternMatcher)this.matchers.get(string);
    }

    public void addMatcher(PatternMatcher patternMatcher) {
        this.init(patternMatcher);
        this.matchers.put(patternMatcher.getName(), patternMatcher);
    }

    @Override
    public RepositoryCacheManager getRepositoryCacheManager(String string) {
        return (RepositoryCacheManager)this.repositoryCacheManagers.get(string);
    }

    public void addRepositoryCacheManager(RepositoryCacheManager repositoryCacheManager) {
        this.init(repositoryCacheManager);
        this.repositoryCacheManagers.put(repositoryCacheManager.getName(), repositoryCacheManager);
    }

    @Override
    public RepositoryCacheManager[] getRepositoryCacheManagers() {
        return this.repositoryCacheManagers.values().toArray(new RepositoryCacheManager[this.repositoryCacheManagers.size()]);
    }

    public void addReportOutputter(ReportOutputter reportOutputter) {
        this.init(reportOutputter);
        this.reportOutputters.put(reportOutputter.getName(), reportOutputter);
    }

    @Override
    public ReportOutputter[] getReportOutputters() {
        return this.reportOutputters.values().toArray(new ReportOutputter[this.reportOutputters.size()]);
    }

    public void addVersionMatcher(VersionMatcher versionMatcher) {
        this.init(versionMatcher);
        this.versionMatchers.put(versionMatcher.getName(), versionMatcher);
        if (this.versionMatcher == null) {
            this.versionMatcher = new ChainVersionMatcher();
            this.addVersionMatcher(new ExactVersionMatcher());
        }
        if (this.versionMatcher instanceof ChainVersionMatcher) {
            ChainVersionMatcher chainVersionMatcher = (ChainVersionMatcher)this.versionMatcher;
            chainVersionMatcher.add(versionMatcher);
        }
    }

    @Override
    public VersionMatcher getVersionMatcher() {
        if (this.versionMatcher == null) {
            this.configureDefaultVersionMatcher();
        }
        return this.versionMatcher;
    }

    public void configureDefaultVersionMatcher() {
        this.addVersionMatcher(new LatestVersionMatcher());
        this.addVersionMatcher(new SubVersionMatcher());
        this.addVersionMatcher(new VersionRangeMatcher());
    }

    @Override
    public CircularDependencyStrategy getCircularDependencyStrategy() {
        if (this.circularDependencyStrategy == null) {
            this.circularDependencyStrategy = this.getCircularDependencyStrategy("default");
        }
        return this.circularDependencyStrategy;
    }

    public CircularDependencyStrategy getCircularDependencyStrategy(String string) {
        if ("default".equals(string)) {
            string = "warn";
        }
        return (CircularDependencyStrategy)this.circularDependencyStrategies.get(string);
    }

    public void setCircularDependencyStrategy(CircularDependencyStrategy circularDependencyStrategy) {
        this.circularDependencyStrategy = circularDependencyStrategy;
    }

    private void addCircularDependencyStrategy(CircularDependencyStrategy circularDependencyStrategy) {
        this.circularDependencyStrategies.put(circularDependencyStrategy.getName(), circularDependencyStrategy);
    }

    private void configureDefaultCircularDependencyStrategies() {
        this.addCircularDependencyStrategy(WarnCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(ErrorCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(IgnoreCircularDependencyStrategy.getInstance());
    }

    @Override
    public StatusManager getStatusManager() {
        if (this.statusManager == null) {
            this.statusManager = StatusManager.newDefaultInstance();
        }
        return this.statusManager;
    }

    public void setStatusManager(StatusManager statusManager) {
        this.statusManager = statusManager;
    }

    @Override
    public String[] getIgnorableFilenames() {
        return this.listingIgnore.toArray(new String[this.listingIgnore.size()]);
    }

    @Override
    public void filterIgnore(Collection collection) {
        collection.removeAll(this.listingIgnore);
    }

    @Override
    public boolean isCheckUpToDate() {
        return this.checkUpToDate;
    }

    public void setCheckUpToDate(boolean bl) {
        this.checkUpToDate = bl;
    }

    public boolean doValidate() {
        return this.validate;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    @Override
    public String getVariable(String string) {
        return this.variableContainer.getVariable(string);
    }

    public ConflictManager getDefaultConflictManager() {
        if (this.defaultConflictManager == null) {
            this.defaultConflictManager = new LatestConflictManager(this.getDefaultLatestStrategy());
            ((LatestConflictManager)this.defaultConflictManager).setSettings(this);
        }
        return this.defaultConflictManager;
    }

    public void setDefaultConflictManager(ConflictManager conflictManager) {
        this.defaultConflictManager = conflictManager;
    }

    @Override
    public LatestStrategy getDefaultLatestStrategy() {
        if (this.defaultLatestStrategy == null) {
            this.defaultLatestStrategy = new LatestRevisionStrategy();
        }
        return this.defaultLatestStrategy;
    }

    public void setDefaultLatestStrategy(LatestStrategy latestStrategy) {
        this.defaultLatestStrategy = latestStrategy;
    }

    public LockStrategy getDefaultLockStrategy() {
        if (this.defaultLockStrategy == null) {
            this.defaultLockStrategy = new NoLockStrategy();
        }
        return this.defaultLockStrategy;
    }

    public void setDefaultLockStrategy(LockStrategy lockStrategy) {
        this.defaultLockStrategy = lockStrategy;
    }

    @Override
    public RepositoryCacheManager getDefaultRepositoryCacheManager() {
        if (this.defaultRepositoryCacheManager == null) {
            IvySettings ivySettings = this;
            this.defaultRepositoryCacheManager = new DefaultRepositoryCacheManager("default-cache", ivySettings, ivySettings.getDefaultRepositoryCacheBasedir());
            IvySettings ivySettings2 = this;
            ivySettings2.addRepositoryCacheManager(ivySettings2.defaultRepositoryCacheManager);
        }
        return this.defaultRepositoryCacheManager;
    }

    public void setDefaultRepositoryCacheManager(RepositoryCacheManager repositoryCacheManager) {
        this.defaultRepositoryCacheManager = repositoryCacheManager;
    }

    @Override
    public ResolutionCacheManager getResolutionCacheManager() {
        if (this.resolutionCacheManager == null) {
            this.resolutionCacheManager = new DefaultResolutionCacheManager(this.getDefaultResolutionCacheBasedir());
            IvySettings ivySettings = this;
            ivySettings.init(ivySettings.resolutionCacheManager);
        }
        return this.resolutionCacheManager;
    }

    public void setResolutionCacheManager(ResolutionCacheManager resolutionCacheManager) {
        this.resolutionCacheManager = resolutionCacheManager;
    }

    public List getTriggers() {
        return this.triggers;
    }

    public void setUseRemoteConfig(boolean bl) {
        this.useRemoteConfig = bl;
    }

    public boolean logModulesInUse() {
        String string = this.getVariable("ivy.log.modules.in.use");
        return string == null || Boolean.valueOf(string) != false;
    }

    @Override
    public boolean logModuleWhenFound() {
        String string = this.getVariable("ivy.log.module.when.found");
        return string == null || Boolean.valueOf(string) != false;
    }

    @Override
    public boolean logResolvedRevision() {
        String string = this.getVariable("ivy.log.resolved.revision");
        return string == null || Boolean.valueOf(string) != false;
    }

    @Override
    public boolean debugConflictResolution() {
        if (this.debugConflictResolution == null) {
            String string = this.getVariable("ivy.log.conflict.resolution");
            this.debugConflictResolution = string != null && Boolean.valueOf(string) != false;
        }
        return this.debugConflictResolution;
    }

    public final boolean debugLocking() {
        if (this.debugLocking == null) {
            String string = this.getVariable("ivy.log.locking");
            this.debugLocking = string != null && Boolean.valueOf(string) != false;
        }
        return this.debugLocking;
    }

    @Override
    public boolean logNotConvertedExclusionRule() {
        return this.logNotConvertedExclusionRule;
    }

    private void init(Object object) {
        if (object instanceof IvySettingsAware) {
            ((IvySettingsAware)object).setSettings(this);
            return;
        }
        if (object instanceof DependencyResolver) {
            ((DependencyResolver)object).setSettings(this);
        }
    }

    public Collection getResolvers() {
        return this.resolversMap.values();
    }

    public IvyVariableContainer getVariableContainer() {
        return this.variableContainer;
    }

    public void setVariableContainer(IvyVariableContainer ivyVariableContainer) {
        this.variableContainer = ivyVariableContainer;
    }

    @Override
    public RelativeUrlResolver getRelativeUrlResolver() {
        return new NormalRelativeUrlResolver();
    }

    public void setDefaultCacheIvyPattern(String string) {
        CacheUtil.checkCachePattern(string);
        this.defaultCacheIvyPattern = string;
    }

    public String getDefaultCacheIvyPattern() {
        return this.defaultCacheIvyPattern;
    }

    public void setDefaultCacheArtifactPattern(String string) {
        CacheUtil.checkCachePattern(string);
        this.defaultCacheArtifactPattern = string;
    }

    public String getDefaultCacheArtifactPattern() {
        return this.defaultCacheArtifactPattern;
    }

    public void setDefaultUseOrigin(boolean bl) {
        this.defaultUseOrigin = bl;
    }

    public boolean isDefaultUseOrigin() {
        return this.defaultUseOrigin;
    }

    public void validate() {
        IvySettings ivySettings = this;
        ivySettings.validateAll(ivySettings.resolversMap.values());
        IvySettings ivySettings2 = this;
        ivySettings2.validateAll(ivySettings2.conflictsManager.values());
        IvySettings ivySettings3 = this;
        ivySettings3.validateAll(ivySettings3.latestStrategies.values());
        IvySettings ivySettings4 = this;
        ivySettings4.validateAll(ivySettings4.lockStrategies.values());
        IvySettings ivySettings5 = this;
        ivySettings5.validateAll(ivySettings5.repositoryCacheManagers.values());
        IvySettings ivySettings6 = this;
        ivySettings6.validateAll(ivySettings6.reportOutputters.values());
        IvySettings ivySettings7 = this;
        ivySettings7.validateAll(ivySettings7.circularDependencyStrategies.values());
        IvySettings ivySettings8 = this;
        ivySettings8.validateAll(ivySettings8.versionMatchers.values());
        IvySettings ivySettings9 = this;
        ivySettings9.validateAll(ivySettings9.namespaces.values());
    }

    private void validateAll(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (!(e instanceof Validatable)) continue;
            ((Validatable)e).validate();
        }
    }

    @Override
    public Namespace getContextNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    private static class ModuleSettings {
        private String resolverName;
        private String branch;
        private String conflictManager;
        private String resolveMode;

        public ModuleSettings(String string, String string2, String string3, String string4) {
            this.resolverName = string;
            this.branch = string2;
            this.conflictManager = string3;
            this.resolveMode = string4;
        }

        public String toString() {
            return (this.resolverName != null ? "resolver: " + this.resolverName : "") + (this.branch != null ? "branch: " + this.branch : "") + (this.conflictManager != null ? "conflictManager: " + this.conflictManager : "") + (this.resolveMode != null ? "resolveMode: " + this.resolveMode : "");
        }

        public String getBranch() {
            return this.branch;
        }

        public String getResolverName() {
            return this.resolverName;
        }

        public String getConflictManager() {
            return this.conflictManager;
        }

        public String getResolveMode() {
            return this.resolveMode;
        }
    }
}

