/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.lang.reflect.Executable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.jdbc.diagnostics.Releaser;
import oracle.jdbc.diagnostics.SecuredLoggerImpl;

public interface SecuredLogger {
    public static final boolean IS_ENABLED = false;
    public static final int LOG_EVENT_ATTRIBUTE_LENGTH = 9;
    public static final String DEFAULT_LOG_LOCATION = System.getProperty("oracle.jdbc.diagnostics.logLocation");
    public static final String DEFAULT_CERTIFICATE_PATH = System.getProperty("oracle.jdbc.diagnostics.certificate");
    public static final String DEFAULT_CERTIFICATE_PWD = System.getProperty("oracle.jdbc.diagnostics.certificatePassword");
    public static final Filter DEFAULT_FILTER = record -> true;
    public static final ConcurrentHashMap<String, SecuredLogger> ACTIVE_LOGGER_MAP = new ConcurrentHashMap();

    public boolean isLoggable(Level var1);

    public void disableMemoryLogging();

    public void enableMemoryLogging();

    public void disableFileLogging();

    public void enableFileLogging();

    public void reset();

    public String getId();

    public void dumpLog();

    public void close();

    public void setLogLevel(Level var1);

    public Level getLogLevel();

    public void addHeader(String var1, String var2);

    public void addHeader(Properties var1);

    public void add(Level var1, String var2, String var3, String var4);

    default public void add(Level logLevel, String className, String methodName, String debugMsg, Object debugMsgParam1) {
        this.add(logLevel, className, methodName, debugMsg, debugMsgParam1, null);
    }

    default public void add(Level logLevel, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2) {
        this.add(logLevel, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, null);
    }

    default public void add(Level logLevel, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Object debugMsgParam3) {
        this.add(logLevel, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, debugMsgParam3, null);
    }

    default public void add(Level logLevel, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Object debugMsgParam3, Object debugMsgParam4) {
        this.add(logLevel, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, debugMsgParam3, debugMsgParam4, null);
    }

    default public void add(Level logLevel, String className, String methodName, String debugMsg, Object ... debugMsgParams) {
        this.add(logLevel, className, methodName, debugMsg, null, debugMsgParams);
    }

    public void add(Level var1, String var2, String var3, String var4, Object var5, Releaser var6);

    public void add(Level var1, String var2, String var3, String var4, Object var5, Object var6, Releaser var7);

    public void add(Level var1, String var2, String var3, String var4, Object var5, Object var6, Object var7, Releaser var8);

    public void add(Level var1, String var2, String var3, String var4, Object var5, Object var6, Object var7, Object var8, Releaser var9);

    public void add(Level var1, String var2, String var3, String var4, Releaser var5, Object ... var6);

    public static SecuredLogger newLogger(String id, Properties userProperties) {
        SecuredLoggerImpl logger = new SecuredLoggerImpl(id, userProperties);
        ACTIVE_LOGGER_MAP.put(id, logger);
        return logger;
    }

    public static SecuredLogger getLogger(String id) {
        return ACTIVE_LOGGER_MAP.get(id);
    }

    public static SecuredLogger releaseLogger(String id) {
        return ACTIVE_LOGGER_MAP.remove(id);
    }

    public static SecuredLogger noOpLogger() {
        return new SecuredLoggerImpl("noop", null);
    }

    public static String getStringProperty(String name, String defaultValue, Properties usrProps) {
        String val = null;
        if (usrProps != null) {
            val = usrProps.getProperty(name);
        }
        if (val == null && (val = LogManager.getLogManager().getProperty(name)) == null) {
            val = defaultValue;
        }
        return val;
    }

    public static int getIntProperty(String name, int defaultValue, Properties usrProps) {
        String val = SecuredLogger.getStringProperty(name, null, usrProps);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue, Properties usrProps) {
        String val = SecuredLogger.getStringProperty(name, null, usrProps);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    public static Level getLevelProperty(String name, Level defaultValue, Properties usrProps) {
        String val = SecuredLogger.getStringProperty(name, null, usrProps);
        if (val == null) {
            return defaultValue;
        }
        Level l2 = Level.parse(val.trim());
        return l2 != null ? l2 : defaultValue;
    }

    public static Filter getFilterProperty(String name, Filter defaultValue, Properties usrProps) {
        String val = SecuredLogger.getStringProperty(name, null, usrProps);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static Formatter getFormatterProperty(String name, Formatter defaultValue, Properties usrProps) {
        String val = SecuredLogger.getStringProperty(name, null, usrProps);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static final class Attribute
    extends Enum<Attribute> {
        public static final /* enum */ Attribute LENGTH;
        public static final /* enum */ Attribute EVENT_ID;
        public static final /* enum */ Attribute THREAD_ID;
        public static final /* enum */ Attribute CLASS_NAME;
        public static final /* enum */ Attribute METHOD_NAME;
        public static final /* enum */ Attribute LOG_LEVEL;
        public static final /* enum */ Attribute EVENT_TIME;
        public static final /* enum */ Attribute DEBUG_MESSAGE;
        public static final /* enum */ Attribute RELEASER;
        private final int index;
        private static final /* synthetic */ Attribute[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public static Attribute[] values() {
            return (Attribute[])$VALUES.clone();
        }

        public static Attribute valueOf(String name) {
            return Enum.valueOf(Attribute.class, name);
        }

        private Attribute(int position) {
            this.index = position;
        }

        public int getIndex() {
            return this.index;
        }

        private int getIndexInBuffer(int offset, int bufferLength) {
            return (offset + this.index) % bufferLength;
        }

        public Object getAttributeValue(int startIndex, Object[] buffer) {
            return buffer[this.getIndexInBuffer(startIndex, buffer.length)];
        }

        static {
            try {
                $$$methodRef$$$5 = Attribute.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Attribute.class.getDeclaredMethod("getAttributeValue", Integer.TYPE, Object[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Attribute.class.getDeclaredMethod("getIndexInBuffer", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Attribute.class.getDeclaredMethod("getIndex", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Attribute.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Attribute.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            LENGTH = new Attribute(0);
            EVENT_ID = new Attribute(1);
            THREAD_ID = new Attribute(2);
            CLASS_NAME = new Attribute(3);
            METHOD_NAME = new Attribute(4);
            LOG_LEVEL = new Attribute(5);
            EVENT_TIME = new Attribute(6);
            DEBUG_MESSAGE = new Attribute(7);
            RELEASER = new Attribute(8);
            $VALUES = new Attribute[]{LENGTH, EVENT_ID, THREAD_ID, CLASS_NAME, METHOD_NAME, LOG_LEVEL, EVENT_TIME, DEBUG_MESSAGE, RELEASER};
        }
    }
}

