/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.core;

import com.ibm.db2.cmx.internal.core.ConnectionImpl;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;

public class Request {
    public static final byte FORMAT_BYTE = -47;
    public static final byte TYPE_REQUEST = 1;
    public static final byte TYPE_REPLY = 2;
    public static final byte TYPE_MESSAGE = 3;
    private static final int DEFAULT_BUFFER_SIZE = Short.MAX_VALUE;
    private ByteBuffer envelopeByteBuffer_ = ByteBuffer.allocate(Short.MAX_VALUE);
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public Request(ConnectionImpl connectionImpl) {
    }

    protected int flushMessage(Message message, SocketChannel socketChannel, byte by2) throws UnsupportedEncodingException, IOException {
        ByteBuffer byteBuffer = message.getPayload().duplicate();
        int n2 = byteBuffer.limit();
        byte[] byArray = message.getProcessorName().getBytes("UTF-8");
        int n3 = byArray.length;
        byte[] byArray2 = this.computeLengthBytes(n2);
        this.clearAndEnsureLength(byArray2.length + 1 + 1 + 1 + n3);
        this.envelopeByteBuffer_.put(byArray2);
        this.envelopeByteBuffer_.put((byte)-47);
        this.envelopeByteBuffer_.put(by2);
        this.envelopeByteBuffer_.put((byte)n3);
        this.envelopeByteBuffer_.put(byArray);
        ((Buffer)this.envelopeByteBuffer_).flip();
        this.flushByteBuffer(this.envelopeByteBuffer_, socketChannel);
        this.flushByteBuffer(byteBuffer, socketChannel);
        return 0;
    }

    private byte[] computeLengthBytes(int n2) {
        if (n2 <= Short.MAX_VALUE) {
            return new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        }
        if ((long)n2 <= Integer.MAX_VALUE) {
            return new byte[]{-128, 4, (byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        }
        return new byte[]{-128, 8, (byte)(n2 >> 56 & 0xFF), (byte)(n2 >> 48 & 0xFF), (byte)(n2 >> 40 & 0xFF), (byte)(n2 >> 32 & 0xFF), (byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
    }

    protected void flushByteBuffer(ByteBuffer byteBuffer, SocketChannel socketChannel) throws IOException {
        int n2 = byteBuffer.limit();
        for (int i10 = 0; i10 < n2; i10 += socketChannel.write(byteBuffer)) {
        }
    }

    public static String getHexString(byte[] byArray, boolean bl2) {
        byte[] byArray2 = new byte[2 * byArray.length];
        int n2 = 0;
        boolean bl3 = true;
        for (byte by2 : byArray) {
            int n3 = by2 & 0xFF;
            byArray2[n2++] = HEX_CHAR_TABLE[n3 >>> 4];
            byArray2[n2++] = HEX_CHAR_TABLE[n3 & 0xF];
            if (by2 == 0) continue;
            bl3 = false;
        }
        try {
            if (bl2 && bl3) {
                return null;
            }
            return new String(byArray2, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger logger = Log.getCMXClientLogger();
            logger.throwing("Request", "getHexString", unsupportedEncodingException);
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private void clearAndEnsureLength(int n2) {
        if (this.envelopeByteBuffer_.capacity() < n2) {
            this.envelopeByteBuffer_ = ByteBuffer.allocate(n2);
        } else {
            ((Buffer)this.envelopeByteBuffer_).clear();
        }
    }
}

