/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator;

import com.ibm.db2.cmx.annotation.Cursor;
import com.ibm.db2.cmx.annotation.Metadata;
import com.ibm.db2.cmx.runtime.StoredProcedureResult;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.generator.BaseData;
import com.ibm.db2.cmx.runtime.generator.BaseGeneratorCallHandler;
import com.ibm.db2.cmx.runtime.generator.BaseParameterHandler;
import com.ibm.db2.cmx.runtime.generator.BaseRowHandler;
import com.ibm.db2.cmx.runtime.generator.HandlerContainer;
import com.ibm.db2.cmx.runtime.generator.QOCBaseResultSetMetaData;
import com.ibm.db2.cmx.runtime.handlers.CallHandlerWithParameters;
import com.ibm.db2.cmx.runtime.handlers.ParameterHandler;
import com.ibm.db2.cmx.runtime.handlers.ResultHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandlerWithParameters;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementAttributes;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.runtime.statement.StatementDescriptor;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.generator.codegen.CallHandlerGenerator;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MetaDataInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class Validator {
    private ClassInfo classInfo_;

    public Validator(ClassInfo classInfo) {
        this.classInfo_ = classInfo;
    }

    public void classAndMethodValidation() {
        List<MethodInfo> list = this.classInfo_.getListOfMethods();
        list = this.validationForPositionUpdateSupportAndRearrangeMethodList(list);
        this.classInfo_.setListOfMethods(list);
        this.addImportForClass(list);
        for (MethodInfo methodInfo : list) {
            this.methodLevelValidation(methodInfo);
        }
        this.removeImportsThatAreNotRequired();
    }

    private void addImportsForMethod(MethodInfo methodInfo) {
        MetaDataInfo metaDataInfo = methodInfo.getParameterMetaDataInfo();
        MetaDataInfo metaDataInfo2 = methodInfo.getResultMetaDataInfo();
        if (metaDataInfo != null || metaDataInfo2 != null) {
            this.classInfo_.addImportDeclaration(Types.class.getName());
        }
        if (metaDataInfo != null && methodInfo.getParameterHandlerType() == MethodInfo.HandlerType.GeneratedHandler) {
            this.classInfo_.addImportDeclaration(SQLException.class.getName());
            this.classInfo_.addImportDeclaration(PreparedStatement.class.getName());
            this.classInfo_.addImportDeclaration(BaseParameterHandler.class.getName());
        }
        if (methodInfo.getRowHandlerType() == MethodInfo.HandlerType.GeneratedHandler) {
            this.classInfo_.addImportDeclaration(BaseRowHandler.class.getName());
        }
        if (methodInfo.getSqlStatementType() == SqlStatementType.CALL && methodInfo.getCallHandlerType() == MethodInfo.HandlerType.GeneratedHandler) {
            this.classInfo_.addImportDeclaration(BaseGeneratorCallHandler.class.getName());
            this.classInfo_.addImportDeclaration(StoredProcedureResult.class.getName());
            this.classInfo_.addImportDeclaration(CallableStatement.class.getName());
        }
        if (methodInfo.isHandlerContainerNeeded()) {
            this.classInfo_.addImportDeclaration(HandlerContainer.class.getName());
        }
    }

    private void methodLevelValidation(MethodInfo methodInfo) {
        Object object;
        Object object2;
        SqlStatementType sqlStatementType;
        if (null != methodInfo.getResultHandlerFromParameter()) {
            methodInfo.setResultHandlerType(MethodInfo.HandlerType.HandlerProvidedAsMethodParameter);
        }
        if (null != methodInfo.getRowHandlerFromParameter()) {
            methodInfo.setRowHandlerType(MethodInfo.HandlerType.HandlerProvidedAsMethodParameter);
        }
        if (null != methodInfo.getRowHandlerWithParametersFromParameter()) {
            methodInfo.setRowHandlerType(MethodInfo.HandlerType.HandlerProvidedAsMethodParameter);
        }
        if (null != methodInfo.getParameterHandlerFromParameter()) {
            methodInfo.setParameterHandlerType(MethodInfo.HandlerType.HandlerProvidedAsMethodParameter);
        }
        if (null != methodInfo.getCallHandlerWithParametersFromParameter()) {
            methodInfo.setCallHandlerType(MethodInfo.HandlerType.HandlerProvidedAsMethodParameter);
        }
        if (SqlStatementType.CALL == (sqlStatementType = methodInfo.getSqlStatementType())) {
            this.setCallHandlerTypeInMethodInfo(methodInfo, methodInfo.getReturnType());
        }
        TypeInfo typeInfo = methodInfo.getReturnType();
        if (methodInfo.getResultHandlerType() == MethodInfo.HandlerType.NoHandler && SqlStatementType.isSELECTorVALUES(sqlStatementType) && typeInfo.getJavaType() != JavaType.JDBCRESULTSET) {
            methodInfo.setResultHandlerType(MethodInfo.HandlerType.DefaultHandler);
            object2 = typeInfo.getBaseType();
            if (((TypeInfo)object2).isBeanType()) {
                object = methodInfo.getOutputBeanInfo((TypeInfo)object2);
                ((BeanInformation)object).checkBeanValidityAndThrowExceptionIfNeeded(methodInfo);
            }
        }
        if (methodInfo.getRowHandlerType() == MethodInfo.HandlerType.NoHandler && SqlStatementType.isSELECTorVALUES(sqlStatementType) && typeInfo.getBaseType().getJavaType() != JavaType.JDBCRESULTSET && methodInfo.getResultHandlerType() == MethodInfo.HandlerType.DefaultHandler) {
            methodInfo.setRowHandlerType(MethodInfo.HandlerType.GeneratedHandler);
            object2 = typeInfo.getBaseType();
            if (((TypeInfo)object2).isBeanType()) {
                object = methodInfo.getOutputBeanInfo((TypeInfo)object2);
                ((BeanInformation)object).checkBeanValidityAndThrowExceptionIfNeeded(methodInfo);
            }
        }
        if (methodInfo.getParameterHandlerType() == MethodInfo.HandlerType.NoHandler && null != methodInfo.getParameterMetaDataInfo()) {
            methodInfo.setParameterHandlerType(MethodInfo.HandlerType.GeneratedHandler);
        }
        if (methodInfo.hasAutoGeneratedKeys() && (SqlStatementType.UPDATE == sqlStatementType || SqlStatementType.INSERT == sqlStatementType || SqlStatementType.MERGE == sqlStatementType) && methodInfo.getRowHandlerType() == MethodInfo.HandlerType.NoHandler) {
            object2 = methodInfo.getInputBeanInfo().get(0);
            ((BeanInformation)object2).checkBeanValidityAndThrowExceptionIfNeeded(methodInfo);
            object = ((BeanInformation)object2).getAutoGeneratedKeys();
            if (object != null) {
                methodInfo.setRowHandlerType(MethodInfo.HandlerType.GeneratedHandler);
            }
        }
        Validator.setDataMethodAndAllowedHandlers(methodInfo);
        this.checkHandlerCombination(methodInfo);
        if (MethodInfo.HandlerType.DefaultHandler == methodInfo.getResultHandlerType() && JavaType.ARRAY == methodInfo.getReturnType().getJavaType() && JavaType.TYPEVARIABLE == methodInfo.getReturnType().getBaseType().getJavaType()) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_DEFAULTRESULTHANDLER_AND_TYPEVARIABLEARRAY_RETURN_TYPE", ResultHandler.class.getCanonicalName()), null, 10566, null, methodInfo);
        }
        this.validateReturnTypeIsInterface(methodInfo);
        this.addImportsForMethod(methodInfo);
        methodInfo.validateStatementAttributes();
        this.validateUseOfRowsetCursors(methodInfo);
        this.validateNestedBeans(methodInfo);
    }

    private List<MethodInfo> validationForPositionUpdateSupportAndRearrangeMethodList(List<MethodInfo> list) {
        HashMap<String, MethodInfo> hashMap = new HashMap<String, MethodInfo>();
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
        MethodInfo methodInfo = null;
        int n2 = 1;
        for (MethodInfo object : list) {
            object.setValue(n2++);
        }
        for (MethodInfo methodInfo2 : list) {
            String string = methodInfo2.getCursorName();
            String string2 = methodInfo2.getPositionedCursorName();
            SqlStatementType sqlStatementType = methodInfo2.getSqlStatementType();
            if (string != null) {
                if (SqlStatementType.isSELECTorVALUES(sqlStatementType)) {
                    methodInfo = hashMap.get(string);
                    if (methodInfo != null) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_DUPLICATE_CURSOR_NAME", string, methodInfo.getMethodName()), null, 10665, null, methodInfo2);
                    }
                    if (string.startsWith("DB2JCCCURSOR") || string.startsWith("DB_PDQ_SPC")) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INVALID_CURSOR_NAME", string, methodInfo.getMethodName()), null, 10664, null, methodInfo2);
                    }
                    hashMap.put(string, methodInfo2);
                    continue;
                }
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INVALID_SELECT_CURSOR_NAME", methodInfo2.getMethodName(), string), null, 10663, null, methodInfo2);
            }
            if (string2 == null) continue;
            if (sqlStatementType.equals((Object)SqlStatementType.UPDATE) || sqlStatementType.equals((Object)SqlStatementType.DELETE)) {
                arrayList.add(methodInfo2);
                continue;
            }
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INVALID_UPDATE_CURSOR_NAME", methodInfo2.getMethodName(), string2), null, 10662, null, methodInfo2);
        }
        if (arrayList.size() > 0) {
            this.checkForCursorExistenceinSelectMap(list, hashMap, arrayList);
        }
        list = this.moveSelectMethodInfoAboveUpdateOrDeletes(list, hashMap, arrayList);
        int n3 = 1;
        for (MethodInfo methodInfo3 : list) {
            methodInfo3.setValue(n3++);
        }
        return list;
    }

    private List<MethodInfo> moveSelectMethodInfoAboveUpdateOrDeletes(List<MethodInfo> list, HashMap<String, MethodInfo> hashMap, List<MethodInfo> list2) {
        for (MethodInfo methodInfo : list2) {
            int n2;
            String string = methodInfo.getPositionedCursorName();
            MethodInfo methodInfo2 = hashMap.get(string);
            int n3 = methodInfo.getValue() - 1;
            if (n3 > (n2 = methodInfo2.getValue() - 1)) continue;
            list.remove(methodInfo2);
            methodInfo2.setValue(methodInfo.getValue());
            list.add(n3, methodInfo2);
        }
        return list;
    }

    private void checkForCursorExistenceinSelectMap(List<MethodInfo> list, HashMap<String, MethodInfo> hashMap, List<MethodInfo> list2) {
        MethodInfo methodInfo = null;
        JavaType javaType = null;
        for (MethodInfo methodInfo2 : list2) {
            String string = methodInfo2.getPositionedCursorName();
            methodInfo = hashMap.get(string);
            if (methodInfo == null) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INVALID_UPDATE_CURSOR_WITHOUT_SELECT", string), null, 10661, null, methodInfo2);
            }
            javaType = methodInfo.getReturnType().getJavaType();
            if (JavaType.ITERATOR == javaType || JavaType.JDBCRESULTSET == javaType) continue;
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RETURN_TYPE_BAD_POSITIONED_UPDATE", methodInfo2.getMethodName(), methodInfo.getCursorName(), methodInfo.getMethodName()), null, 10711, null, methodInfo);
        }
    }

    private void validateReturnTypeIsInterface(MethodInfo methodInfo) {
        TypeInfo typeInfo = this.getUnderlyingBaseType(methodInfo);
        JavaType javaType = methodInfo.getReturnType().getJavaType();
        if (typeInfo.getJavaType() == JavaType.MAP && !typeInfo.getQualifiedName().startsWith("java.util.Map")) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_MAP_SUBCLASS_NOT_SUPPORTED_ON_RETURN", new Object[0]), null, 10314, null, methodInfo);
        }
        if (javaType == JavaType.DERIVEDLIST && methodInfo.getReturnType() != methodInfo.getReturnType().getBaseType()) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_LIST_SUBCLASS_NOT_SUPPORTED_ON_RETURN", new Object[0]), null, 10315, null, methodInfo);
        }
    }

    private void addImportForClass(List<MethodInfo> list) {
        if (this.classInfo_.getArtifactOptionsSet().getOptionOrArtifactSingleValue(PossibleArgs.BASE_DATA_OVERRIDE).equals("BaseData")) {
            this.classInfo_.addImportDeclaration(BaseData.class.getName());
        }
        if (list != null && list.size() > 0) {
            this.classInfo_.addImportDeclaration(StatementDescriptor.class.getName());
            this.classInfo_.addImportDeclaration(Metadata.class.getName());
            this.classInfo_.addImportDeclaration(SqlStatementType.class.getName());
            if (this.classInfo_.isGenerateForQOC()) {
                this.classInfo_.addImportDeclaration(QOCBaseResultSetMetaData.class.getName());
            }
        }
    }

    private void setCallHandlerTypeInMethodInfo(MethodInfo methodInfo, TypeInfo typeInfo) {
        MethodInfo.HandlerType handlerType = methodInfo.getCallHandlerType();
        if (MethodInfo.HandlerType.HandlerProvidedAsMethodParameter != handlerType && MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation != handlerType) {
            if (typeInfo.getJavaType() == JavaType.VOID && CallHandlerGenerator.numberOfOutParms(methodInfo) == 0) {
                methodInfo.setCallHandlerType(MethodInfo.HandlerType.NoHandler);
            } else {
                methodInfo.setCallHandlerType(MethodInfo.HandlerType.GeneratedHandler);
            }
        }
    }

    private void removeImportsThatAreNotRequired() {
        Set<String> set = this.classInfo_.getListOfImportDeclaration();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.equals("com.ibm.db2.cmx.annotation.Update")) {
                iterator.remove();
                continue;
            }
            if (string.equals("com.ibm.db2.cmx.annotation.Select")) {
                iterator.remove();
                continue;
            }
            if (string.equals("com.ibm.db2.cmx.annotation.Call")) {
                iterator.remove();
                continue;
            }
            if (string.equals("com.ibm.db2.cmx.annotation.Handler")) {
                iterator.remove();
                continue;
            }
            if (!string.equals("com.ibm.db2.cmx.annotation.Cursor")) continue;
            iterator.remove();
        }
    }

    private void checkHandlerCombination(MethodInfo methodInfo) {
        boolean bl2;
        SqlStatementType sqlStatementType = methodInfo.getSqlStatementType();
        boolean bl3 = null != methodInfo.getResultHandlerFromParameter();
        boolean bl4 = null != methodInfo.getRowHandlerFromParameter();
        boolean bl5 = null != methodInfo.getRowHandlerWithParametersFromParameter();
        boolean bl6 = null != methodInfo.getCallHandlerWithParametersFromParameter();
        boolean bl7 = null != methodInfo.getParameterHandlerFromParameter();
        boolean bl8 = methodInfo.isResultHandlerProvidedAsAnnotation();
        boolean bl9 = methodInfo.isRowHandlerProvidedAsAnnotation();
        boolean bl10 = methodInfo.isRowHandlerWithParametersProvidedAsAnnotation();
        boolean bl11 = methodInfo.isCallHandlerWithParametersProvidedAsAnnotation();
        boolean bl12 = methodInfo.isParameterHandlerProvidedAsAnnotation();
        boolean bl13 = bl3 || bl8;
        boolean bl14 = bl4 || bl9;
        boolean bl15 = bl5 || bl10;
        boolean bl16 = bl6 || bl11;
        boolean bl17 = bl2 = bl7 || bl12;
        if (bl3 && bl8) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_HANDLER_AS_ANNOTATION_AND_PARAMETER", ResultHandler.class.getCanonicalName()), null, 10567, null, methodInfo);
        }
        if (bl4 && bl9) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_HANDLER_AS_ANNOTATION_AND_PARAMETER", RowHandler.class.getCanonicalName()), null, 10568, null, methodInfo);
        }
        if (bl5 && bl10) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_HANDLER_AS_ANNOTATION_AND_PARAMETER", RowHandlerWithParameters.class.getCanonicalName()), null, 11234, null, methodInfo);
        }
        if (bl6 && bl11) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_HANDLER_AS_ANNOTATION_AND_PARAMETER", CallHandlerWithParameters.class.getCanonicalName()), null, 10569, null, methodInfo);
        }
        if (bl7 && bl12) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_HANDLER_AS_ANNOTATION_AND_PARAMETER", ParameterHandler.class.getCanonicalName()), null, 10570, null, methodInfo);
        }
        if (bl13 && bl14) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ILLEGAL_HANDLER_COMBO", ResultHandler.class.getCanonicalName(), RowHandler.class.getCanonicalName()), null, 10571, null, methodInfo);
        }
        if (bl13 && bl15) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ILLEGAL_HANDLER_COMBO", ResultHandler.class.getCanonicalName(), RowHandlerWithParameters.class.getCanonicalName()), null, 11235, null, methodInfo);
        }
        if (bl13 && bl16) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ILLEGAL_HANDLER_COMBO", ResultHandler.class.getCanonicalName(), CallHandlerWithParameters.class.getCanonicalName()), null, 10572, null, methodInfo);
        }
        if (bl14 && bl16) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ILLEGAL_HANDLER_COMBO", RowHandler.class.getCanonicalName(), CallHandlerWithParameters.class.getCanonicalName()), null, 10573, null, methodInfo);
        }
        if (bl15 && bl16) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ILLEGAL_HANDLER_COMBO", RowHandlerWithParameters.class.getCanonicalName(), CallHandlerWithParameters.class.getCanonicalName()), null, 11236, null, methodInfo);
        }
        if (bl14 && bl15) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ILLEGAL_HANDLER_COMBO", RowHandler.class.getCanonicalName(), RowHandlerWithParameters.class.getCanonicalName()), null, 11237, null, methodInfo);
        }
        if (bl13 && !SqlStatementType.isSELECTorVALUES(sqlStatementType)) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESULTHANDLER_AND_NOT_SELECT", ResultHandler.class.getCanonicalName()), null, 10574, null, methodInfo);
        }
        if (bl2 && !methodInfo.isMethodCanUseParameterHandler()) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ANNOTATED_METHOD_PARAMETER_WITH_ILLEGAL_TYPE_FOR_THIS_METHOD", ParameterHandler.class.getCanonicalName()), null, 10637, null, methodInfo);
        }
        if (bl13 && !methodInfo.isMethodCanUseResultHandler()) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ANNOTATED_METHOD_PARAMETER_WITH_ILLEGAL_TYPE_FOR_THIS_METHOD", ResultHandler.class.getCanonicalName()), null, 10638, null, methodInfo);
        }
        if ((bl14 || bl15) && !methodInfo.isMethodCanUseRowHandler()) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ROWHANDLER_AND_NOT_INSERTUPDATE_AUTOGEN", RowHandler.class.getCanonicalName()), null, 10575, null, methodInfo);
        }
        if (bl16 && !methodInfo.isMethodCanUseCallHandlerWithParameters()) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_CALLHANDLER_AND_NOT_CALL", CallHandlerWithParameters.class.getCanonicalName()), null, 10576, null, methodInfo);
        }
    }

    private TypeInfo getUnderlyingBaseType(MethodInfo methodInfo) {
        return methodInfo.getReturnType().getBaseType();
    }

    public static void setDataMethodAndAllowedHandlers(MethodInfo methodInfo) {
        TypeInfo typeInfo = methodInfo.getReturnType();
        boolean bl2 = typeInfo.getJavaType() == JavaType.VOID;
        methodInfo.setMethodCanUseParameterHandler(true);
        SqlStatementType sqlStatementType = methodInfo.getSqlStatementType();
        if (SqlStatementType.isSELECTorVALUESorXQUERY(sqlStatementType)) {
            JavaType javaType = methodInfo.getReturnType().getJavaType();
            MethodInfo.HandlerType handlerType = methodInfo.getResultHandlerType();
            block0 : switch (handlerType) {
                case NoHandler: {
                    if (JavaType.JDBCRESULTSET == javaType) {
                        methodInfo.setCodeToInvokeDataMethod("queryResults (");
                        break;
                    }
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ILLEGAL_COMBO_HANDLERTYPE_AND_RESULTTYPE", new Object[]{handlerType, javaType}), null, 10555, null, methodInfo);
                }
                case DefaultHandler: {
                    switch (javaType) {
                        case LIST: {
                            methodInfo.setCodeToInvokeDataMethod("queryList (");
                            methodInfo.setMethodCanUseRowHandler(true);
                            break block0;
                        }
                        case ITERATOR: {
                            methodInfo.setMethodCanUseRowHandler(true);
                            methodInfo.setCodeToInvokeDataMethod("queryIterator (");
                            break block0;
                        }
                        case ARRAY: {
                            if (methodInfo.getReturnType().getBaseType().getQualifiedName().equals("byte")) {
                                methodInfo.setCodeToInvokeDataMethod("queryFirst (");
                                methodInfo.setMethodCanUseRowHandler(true);
                                break block0;
                            }
                            methodInfo.setQueryArray(true);
                            methodInfo.setCodeToInvokeDataMethod("queryArray (");
                            methodInfo.setMethodCanUseRowHandler(true);
                            break block0;
                        }
                        case JDBCRESULTSET: {
                            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ILLEGAL_COMBO_HANDLERTYPE_AND_RESULTTYPE", new Object[]{handlerType, javaType}), null, 10556, null, methodInfo);
                        }
                        case BEAN: 
                        case MAP: 
                        case BIGDECIMAL: 
                        case BLOB: 
                        case BOOLEAN: 
                        case SIMPLE_BOOLEAN: 
                        case BYTE: 
                        case SIMPLE_BYTE: 
                        case BYTE_ARRAY: 
                        case SIMPLE_BYTE_ARRAY: 
                        case CLOB: 
                        case DOUBLE: 
                        case SIMPLE_DOUBLE: 
                        case DATE: 
                        case TIME: 
                        case TIMESTAMP: 
                        case TIMESTAMPTZ: 
                        case FLOAT: 
                        case SIMPLE_FLOAT: 
                        case INTEGER: 
                        case SIMPLE_INTEGER: 
                        case LONG: 
                        case SIMPLE_LONG: 
                        case STRING: 
                        case SHORT: 
                        case SIMPLE_SHORT: 
                        case SQLXML: 
                        case ROWID: 
                        case DERIVEDLIST: {
                            methodInfo.setCodeToInvokeDataMethod("queryFirst (");
                            methodInfo.setMethodCanUseRowHandler(true);
                            break block0;
                        }
                    }
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_TYPE_NOTSUP", javaType.name()), null, 10216, null, methodInfo);
                }
                case GeneratedHandler: 
                case NestedBeanHandler: 
                case HandlerProvidedInMethodAnnotation: 
                case HandlerProvidedAsMethodParameter: {
                    methodInfo.setCodeToInvokeDataMethod("query (");
                    methodInfo.setMethodCanUseResultHandler(true);
                }
            }
        } else if (sqlStatementType == SqlStatementType.CALL) {
            methodInfo.setMethodCanUseCallHandlerWithParameters(true);
            if (bl2) {
                methodInfo.setCodeToInvokeDataMethod("call (");
            } else {
                methodInfo.setCodeToInvokeDataMethod("return call (");
            }
        } else {
            TypeInfo typeInfo2;
            JavaType javaType;
            String string = null;
            if (methodInfo != null && methodInfo.getParameterListWithoutHandlers() != null && ((javaType = (typeInfo2 = methodInfo.getParameterListWithoutHandlers().get(0)).getJavaType()) == JavaType.LIST || javaType == JavaType.ITERATOR || typeInfo2.isArrayType() && typeInfo2.getBaseType().getJavaType() != JavaType.OBJECT && typeInfo2.getBaseType().getJavaType() != JavaType.SIMPLE_BYTE)) {
                string = "updateMany (";
                methodInfo.setMethodCanUseParameterHandler(true);
                if (methodInfo.getParameterListWithoutHandlers().size() > 1) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_BATCH_UPDGEN_PARAM", new Object[0]), null, 10217, null, methodInfo);
                }
            }
            if (null == string) {
                string = "update (";
                if (methodInfo.hasAutoGeneratedKeys()) {
                    methodInfo.setUpdateWithAutogeneratedKeys(true);
                    methodInfo.setMethodCanUseRowHandler(true);
                }
            }
            methodInfo.setCodeToInvokeDataMethod(string);
        }
    }

    private void validateUseOfRowsetCursors(MethodInfo methodInfo) {
        if (methodInfo.getAllowStaticRowsetCursors()) {
            int n2 = methodInfo.getCursorConcurrency();
            String string = methodInfo.getProcessedSql();
            SqlStatementType sqlStatementType = methodInfo.getSqlStatementType();
            MetaDataInfo metaDataInfo = methodInfo.getResultMetaDataInfo();
            if (metaDataInfo != null) {
                int[] nArray = metaDataInfo.getSqlTypeForStorageInImplOrXml();
                StringBuffer stringBuffer = new StringBuffer();
                if (!StatementUtilities.doesPureQueryAllowSQLToUseRowsetCursors(string, sqlStatementType, methodInfo.isSingleRowQuery(), n2, null, nArray, stringBuffer)) {
                    String string2 = null != stringBuffer ? stringBuffer.toString() : "";
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ALLOWSTATICROWSETCURSOR_NOT_ALLOWED_IMPL", "allowStaticRowsetCursors", Cursor.class, StatementAttributes.TRUE_STRING, string2), null, 10702, null, methodInfo);
                }
            }
        }
    }

    private void validateNestedBeans(MethodInfo methodInfo) {
        HashMap<String, BeanInformation> hashMap = new HashMap<String, BeanInformation>();
        if (methodInfo.getOutputBeanInfoMap() != null) {
            hashMap.putAll(methodInfo.getOutputBeanInfoMap());
        }
        if (methodInfo.getNestedBeansInfoMap() != null) {
            hashMap.putAll(methodInfo.getNestedBeansInfoMap());
        }
        Set set = hashMap.entrySet();
        for (Map.Entry<String, BeanInformation> entry : set) {
            this.checkReplacedProperties(methodInfo, (BeanInformation)entry.getValue());
            this.validateBeanForHQB(methodInfo, entry, hashMap);
        }
    }

    private void validateBeanForHQB(MethodInfo methodInfo, Map.Entry<String, BeanInformation> entry, Map<String, BeanInformation> map) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = entry.getKey();
        BeanInformation beanInformation = entry.getValue();
        BeanInformation beanInformation2 = null;
        Collection<BeanPropertyInformation> collection = beanInformation.getBeanPropertyMap().values();
        Iterator<BeanPropertyInformation> iterator = collection.iterator();
        BeanPropertyInformation beanPropertyInformation = null;
        BeanPropertyInformation beanPropertyInformation2 = null;
        BeanPropertyInformation beanPropertyInformation3 = null;
        TypeInfo typeInfo = null;
        String string2 = null;
        String string3 = null;
        while (iterator.hasNext()) {
            beanPropertyInformation2 = iterator.next();
            do {
                beanPropertyInformation = beanPropertyInformation2;
                stringBuilder.setLength(0);
                int n2 = 0;
                do {
                    if (!beanPropertyInformation2.isOverriddenProperty() && beanPropertyInformation2.isJoinPointProperty()) {
                        typeInfo = beanPropertyInformation2.getPropertyTypeInfo();
                        if (typeInfo.getJavaType() == JavaType.LIST) {
                            typeInfo = typeInfo.getBaseType();
                        }
                        if (typeInfo.getJavaType() != JavaType.BEAN) {
                            string3 = beanPropertyInformation2.getPropertyTypeInfo().getName();
                            WarningFactory.createPureQueryWarningForGeneratorOnly(Messages.getText("WARN_JOINPOINT_INVALID_LOC", string, string3, Messages.getText("WARN_BEAN_PROP_IGN", new Object[0])), 11193, this.classInfo_.getGeneratorImpl(), null, methodInfo, this.getClass(), "generateResultHandler (MethodInfo, TypeInfo)");
                            this.flagJoinPointAsIgnore(beanPropertyInformation2);
                            beanPropertyInformation2 = beanPropertyInformation;
                            continue;
                        }
                        if ("".equals(beanPropertyInformation2.getJoinPointPropertyName())) {
                            this.flagJoinPointAsIgnore(beanPropertyInformation2);
                            beanPropertyInformation2 = beanPropertyInformation;
                            continue;
                        }
                        string2 = typeInfo.getQualifiedName();
                        beanInformation2 = map.get(string2);
                        beanPropertyInformation3 = beanPropertyInformation2.isJoinPointPropertyNameFromDefault() ? beanInformation2.getBasePropertyUsingCaseInSensitiveName(beanPropertyInformation2.getJoinPointPropertyName()) : beanInformation2.getBasePropertyUsingJoinPointPropertyName(beanPropertyInformation2.getJoinPointPropertyName());
                        if (beanPropertyInformation3 == null) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(", ");
                            }
                            stringBuilder.append(beanPropertyInformation2.getJoinPointPropertyName());
                            if (beanPropertyInformation2.isJoinPointPropertyNameFromDefault() && beanInformation2.getIdKeys().size() == 1) {
                                BeanPropertyInformation beanPropertyInformation4 = beanInformation2.getPropertyUsingCaseInSensitiveName(beanInformation2.getIdKeys().get(0), beanInformation2.getIdKeysTable().get(0), false);
                                if (beanPropertyInformation4 != null) {
                                    String string4 = beanPropertyInformation4.getPropertyTypeInfo().getName();
                                    beanPropertyInformation2.setJoinPointPropertyName(string4, false);
                                    ToolsLogger.getLogger().log(Level.FINEST, "[DEBUG] JoinPointPropertyName fixed because nested bean has 1 Id, parent bean: " + string + ", old JoinPointPropertyName: " + stringBuilder.toString() + ", new JoinPointPropertyName: " + beanPropertyInformation2.getJoinPointPropertyName());
                                } else {
                                    n2 = 99;
                                }
                            } else {
                                ++n2;
                            }
                        }
                        beanPropertyInformation2 = beanPropertyInformation2.getNextJoinPointPropInfo();
                        continue;
                    }
                    beanPropertyInformation2 = beanPropertyInformation2.getNextJoinPointPropInfo();
                } while (beanPropertyInformation2 != null && beanPropertyInformation2 != beanPropertyInformation);
                if (n2 <= 0) continue;
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESULTHANDLER_MISSING_PROP", string, string2, stringBuilder.toString()), null, 11194, null, methodInfo);
            } while ((beanPropertyInformation2 = beanPropertyInformation.getNextBeanPropInfo()) != null);
        }
    }

    private void flagJoinPointAsIgnore(BeanPropertyInformation beanPropertyInformation) {
        BeanPropertyInformation beanPropertyInformation2 = beanPropertyInformation;
        do {
            beanPropertyInformation2.setOverriddenProperty(true);
        } while ((beanPropertyInformation2 = beanPropertyInformation2.getNextJoinPointPropInfo()) != null && beanPropertyInformation2 != beanPropertyInformation);
    }

    private void checkReplacedProperties(MethodInfo methodInfo, BeanInformation beanInformation) {
        Map<String, ArrayList<BeanPropertyInformation>> map = beanInformation.getReplacedBeanProperties();
        if (map == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Set<String> set = map.keySet();
        for (String string : set) {
            ArrayList<BeanPropertyInformation> arrayList = map.get(string);
            int n2 = arrayList.size();
            for (int i10 = 0; i10 < n2; ++i10) {
                String string2;
                BeanPropertyInformation beanPropertyInformation = arrayList.get(i10);
                BeanPropertyInformation beanPropertyInformation2 = beanPropertyInformation.getNextReplacedBeanProp();
                for (int i11 = 0; i11 < beanInformation.getIdKeys().size(); ++i11) {
                    string2 = beanInformation.getIdKeys().get(i11);
                    String string3 = beanInformation.getIdKeysTable().get(i11);
                    String string4 = beanPropertyInformation.getPropertyTypeInfo().getName();
                    String string5 = beanPropertyInformation2.getPropertyTypeInfo().getName();
                    if (!string2.equalsIgnoreCase(beanPropertyInformation.getMapKey()) || (string3 != null || beanPropertyInformation.getTableName() != null) && (string3 == null || !string3.equalsIgnoreCase(beanPropertyInformation.getTableName()))) continue;
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append('\n');
                    }
                    stringBuilder2.append(Messages.getText("ERR_PROP_REP", string4, beanPropertyInformation.getTableName() + ":" + beanPropertyInformation.getMapKey(), beanInformation.getFullyQualifiedName(), string5, beanPropertyInformation2.getTableName() + ":" + beanPropertyInformation2.getMapKey(), "pureQuery Runtime"));
                }
                String string6 = beanPropertyInformation.getPropertyTypeInfo().getName();
                string2 = beanPropertyInformation2.getPropertyTypeInfo().getName();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(Messages.getText("WARN_PROP_REP", string6, beanPropertyInformation.getTableName() + ":" + beanPropertyInformation.getMapKey(), beanInformation.getFullyQualifiedName(), string2, beanPropertyInformation2.getTableName() + ":" + beanPropertyInformation2.getMapKey()));
            }
        }
        if (stringBuilder.length() > 0) {
            WarningFactory.createPureQueryWarningForGeneratorOnly(stringBuilder.toString(), 11238, this.classInfo_.getGeneratorImpl(), null, methodInfo, this.getClass(), "generateResultHandler (MethodInfo, TypeInfo)");
        }
        if (stringBuilder2.length() > 0) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(stringBuilder2.toString(), null, 11239, null, methodInfo);
        }
    }
}

