/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngineManager;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.command.script.AbstractScriptEngineExecutor;
import us.fatehi.utility.string.StringFormat;

public final class ScriptEngineExecutor
extends AbstractScriptEngineExecutor {
    private static final Logger LOGGER = Logger.getLogger(ScriptEngineExecutor.class.getName());

    public ScriptEngineExecutor(String scriptingLanguage) {
        super(scriptingLanguage);
    }

    @Override
    public boolean canGenerate() {
        try {
            this.obtainScriptEngine();
            return this.scriptEngine != null;
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, e, (Supplier<String>)new StringFormat("Script engine not found for language <%s>", new Object[]{this.scriptingLanguage}));
            return false;
        }
    }

    @Override
    protected void obtainScriptEngine() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Using script language <%s>", new Object[]{this.scriptingLanguage}));
        try {
            this.scriptEngine = scriptEngineManager.getEngineByName(this.scriptingLanguage);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Script engine not found for language, " + this.scriptingLanguage);
        }
        if (this.scriptEngine == null) {
            this.scriptEngine = scriptEngineManager.getEngineByExtension(this.scriptingLanguage);
        }
        if (this.scriptEngine == null) {
            throw new InternalRuntimeException(String.format("Script engine not found for language <%s>", this.scriptingLanguage));
        }
    }
}

