/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import java.util.Hashtable;

public class IfxLocales {
    public static final int LOCALE_INDEX = 0;
    public static final int CODESET_INDEX = 1;
    static Hashtable<String, String> IfxToJdkEncodingTable = null;
    static Hashtable<String, String> IfxNoToJdkEncodingTable = null;
    static Hashtable<String, String> IfxToJdkLocaleTable = null;

    public static String FromIfxNameToJdkName(String ifxEncName) {
        return IfxToJdkEncodingTable.get(ifxEncName);
    }

    public static String FromIfxNoToJdkName(String ifxEncNumber) {
        return IfxNoToJdkEncodingTable.get(ifxEncNumber);
    }

    public static String FromIfxToJdkLocale(String ifxLocName) {
        return IfxToJdkLocaleTable.get(ifxLocName.toLowerCase());
    }

    public static String[] FromNLSToJDK(String NLSLocName) {
        return IfxNLSLocale.FromNLSToJDK(NLSLocName);
    }

    static {
        if (IfxToJdkEncodingTable == null) {
            IfxToJdkEncodingTable = new Hashtable();
            IfxToJdkEncodingTable.put("8859-1", "ISO8859_1");
            IfxToJdkEncodingTable.put("8859-2", "ISO8859_2");
            IfxToJdkEncodingTable.put("8859-3", "ISO8859_3");
            IfxToJdkEncodingTable.put("8859-4", "ISO8859_4");
            IfxToJdkEncodingTable.put("8859-5", "ISO8859_5");
            IfxToJdkEncodingTable.put("8859-6", "ISO8859_6");
            IfxToJdkEncodingTable.put("8859-7", "ISO8859_7");
            IfxToJdkEncodingTable.put("8859-8", "ISO8859_8");
            IfxToJdkEncodingTable.put("8859-9", "ISO8859_9");
            IfxToJdkEncodingTable.put("8859-13", "ISO8859_13");
            IfxToJdkEncodingTable.put("8859-15", "ISO8859_15_FDIS");
            IfxToJdkEncodingTable.put("Latin-9", "ISO8859_15_FDIS");
            IfxToJdkEncodingTable.put("ASCII", "ASCII");
            IfxToJdkEncodingTable.put("sjis-s", "SJIS");
            IfxToJdkEncodingTable.put("utf8", "UTF8");
            IfxToJdkEncodingTable.put("big5", "Big5");
            IfxToJdkEncodingTable.put("CP1250", "Cp1250");
            IfxToJdkEncodingTable.put("CP1251", "Cp1251");
            IfxToJdkEncodingTable.put("CP1252", "Cp1252");
            IfxToJdkEncodingTable.put("CP1253", "Cp1253");
            IfxToJdkEncodingTable.put("CP1254", "Cp1254");
            IfxToJdkEncodingTable.put("CP1255", "Cp1255");
            IfxToJdkEncodingTable.put("CP1256", "Cp1256");
            IfxToJdkEncodingTable.put("CP1257", "Cp1257");
            IfxToJdkEncodingTable.put("cp949", "KSC5601");
            IfxToJdkEncodingTable.put("KS5601", "KSC5601");
            IfxToJdkEncodingTable.put("ksc", "KSC5601");
            IfxToJdkEncodingTable.put("gb", "GBK");
            IfxToJdkEncodingTable.put("GB2312-80", "GBK");
            IfxToJdkEncodingTable.put("cp936", "GBK");
            IfxToJdkEncodingTable.put("CP850", "Cp850");
            IfxToJdkEncodingTable.put("CP866", "Cp866");
            IfxToJdkEncodingTable.put("KOI-8", "KOI8_R");
            IfxToJdkEncodingTable.put("CP852", "Cp852");
            IfxToJdkEncodingTable.put("ujis", "EUC_JP");
            IfxToJdkEncodingTable.put("thai620", "MS874");
            IfxToJdkEncodingTable.put("sjis", "SJIS");
            IfxToJdkEncodingTable.put("big5-HKSCS", "Big5-HKSCS");
            IfxToJdkEncodingTable.put("big5HKSCS", "Big5-HKSCS");
            IfxToJdkEncodingTable.put("cp_949", "MS949");
            IfxToJdkEncodingTable.put("GB18030-2000", "GB18030");
        }
        if (IfxNoToJdkEncodingTable == null) {
            IfxNoToJdkEncodingTable = new Hashtable();
            IfxNoToJdkEncodingTable.put("819", "ISO8859_1");
            IfxNoToJdkEncodingTable.put("912", "ISO8859_2");
            IfxNoToJdkEncodingTable.put("57346", "ISO8859_3");
            IfxNoToJdkEncodingTable.put("57347", "ISO8859_4");
            IfxNoToJdkEncodingTable.put("915", "ISO8859_5");
            IfxNoToJdkEncodingTable.put("1089", "ISO8859_6");
            IfxNoToJdkEncodingTable.put("813", "ISO8859_7");
            IfxNoToJdkEncodingTable.put("916", "ISO8859_8");
            IfxNoToJdkEncodingTable.put("920", "ISO8859_9");
            IfxNoToJdkEncodingTable.put("57391", "ISO8859_15_FDIS");
            IfxNoToJdkEncodingTable.put("364", "ASCII");
            IfxNoToJdkEncodingTable.put("932", "SJIS");
            IfxNoToJdkEncodingTable.put("57372", "UTF8");
            IfxNoToJdkEncodingTable.put("57352", "Big5");
            IfxNoToJdkEncodingTable.put("1250", "Cp1250");
            IfxNoToJdkEncodingTable.put("1251", "Cp1251");
            IfxNoToJdkEncodingTable.put("1252", "Cp1252");
            IfxNoToJdkEncodingTable.put("1253", "Cp1253");
            IfxNoToJdkEncodingTable.put("1254", "Cp1254");
            IfxNoToJdkEncodingTable.put("1255", "Cp1255");
            IfxNoToJdkEncodingTable.put("1256", "Cp1256");
            IfxNoToJdkEncodingTable.put("1257", "Cp1257");
            IfxNoToJdkEncodingTable.put("57356", "KSC5601");
            IfxNoToJdkEncodingTable.put("57357", "GBK");
            IfxNoToJdkEncodingTable.put("850", "Cp850");
            IfxNoToJdkEncodingTable.put("866", "Cp866");
            IfxNoToJdkEncodingTable.put("57382", "KOI8_R");
            IfxNoToJdkEncodingTable.put("852", "Cp852");
            IfxNoToJdkEncodingTable.put("57351", "EUC_JP");
            IfxNoToJdkEncodingTable.put("57373", "MS874");
            IfxNoToJdkEncodingTable.put("57350", "SJIS");
            IfxNoToJdkEncodingTable.put("1375", "Big5-HKSCS");
            IfxNoToJdkEncodingTable.put("949", "MS949");
            IfxNoToJdkEncodingTable.put("5488", "GB18030");
            IfxNoToJdkEncodingTable.put("57390", "ISO8859_13");
        }
        if (IfxToJdkLocaleTable == null) {
            IfxToJdkLocaleTable = new Hashtable();
            IfxToJdkLocaleTable.put("ar_ae", "ar_AE");
            IfxToJdkLocaleTable.put("ar_bh", "ar_BH");
            IfxToJdkLocaleTable.put("ar_kw", "ar_KW");
            IfxToJdkLocaleTable.put("ar_om", "ar_OM");
            IfxToJdkLocaleTable.put("ar_qa", "ar_QA");
            IfxToJdkLocaleTable.put("ar_sa", "ar_SA");
            IfxToJdkLocaleTable.put("bg_bg", "bg_BG");
            IfxToJdkLocaleTable.put("ca_es", "ca_ES");
            IfxToJdkLocaleTable.put("cs_cz", "cs_CZ");
            IfxToJdkLocaleTable.put("da_dk", "da_DK");
            IfxToJdkLocaleTable.put("de_at", "de_AT");
            IfxToJdkLocaleTable.put("de_ch", "de_CH");
            IfxToJdkLocaleTable.put("de_de", "de_DE");
            IfxToJdkLocaleTable.put("el_gr", "el_GR");
            IfxToJdkLocaleTable.put("en_au", "en_AU");
            IfxToJdkLocaleTable.put("en_ca", "en_CA");
            IfxToJdkLocaleTable.put("en_gb", "en_GB");
            IfxToJdkLocaleTable.put("en_ie", "en_IE");
            IfxToJdkLocaleTable.put("en_nz", "en_NZ");
            IfxToJdkLocaleTable.put("en_us", "en_US");
            IfxToJdkLocaleTable.put("es_ar", "es_AR");
            IfxToJdkLocaleTable.put("es_bo", "es_BO");
            IfxToJdkLocaleTable.put("es_cl", "es_CL");
            IfxToJdkLocaleTable.put("es_co", "es_CO");
            IfxToJdkLocaleTable.put("es_cr", "es_CR");
            IfxToJdkLocaleTable.put("es_ec", "es_EC");
            IfxToJdkLocaleTable.put("es_es", "es_ES");
            IfxToJdkLocaleTable.put("es_gt", "es_GT");
            IfxToJdkLocaleTable.put("es_mx", "es_MX");
            IfxToJdkLocaleTable.put("es_pa", "es_PA");
            IfxToJdkLocaleTable.put("es_pe", "es_PE");
            IfxToJdkLocaleTable.put("es_py", "es_PY");
            IfxToJdkLocaleTable.put("es_sv", "es_SV");
            IfxToJdkLocaleTable.put("es_uy", "es_UY");
            IfxToJdkLocaleTable.put("es_ve", "es_VE");
            IfxToJdkLocaleTable.put("et_ee", "et_EE");
            IfxToJdkLocaleTable.put("fi_fi", "fi_FI");
            IfxToJdkLocaleTable.put("fr_be", "fr_BE");
            IfxToJdkLocaleTable.put("fr_ca", "fr_CA");
            IfxToJdkLocaleTable.put("fr_ch", "fr_CH");
            IfxToJdkLocaleTable.put("fr_fr", "fr_FR");
            IfxToJdkLocaleTable.put("hr_hr", "hr_HR");
            IfxToJdkLocaleTable.put("hu_hu", "hu_HU");
            IfxToJdkLocaleTable.put("is_is", "is_IS");
            IfxToJdkLocaleTable.put("it_ch", "it_CH");
            IfxToJdkLocaleTable.put("it_it", "it_IT");
            IfxToJdkLocaleTable.put("iw_il", "iw_IL");
            IfxToJdkLocaleTable.put("ja_jp", "ja_JP");
            IfxToJdkLocaleTable.put("ko_kr", "ko_KR");
            IfxToJdkLocaleTable.put("lv_lv", "lv_LV");
            IfxToJdkLocaleTable.put("mk_mk", "mk_MK");
            IfxToJdkLocaleTable.put("nl_be", "nl_BE");
            IfxToJdkLocaleTable.put("nl_nl", "nl_NL");
            IfxToJdkLocaleTable.put("no_no", "no_NO");
            IfxToJdkLocaleTable.put("pl_pl", "pl_PL");
            IfxToJdkLocaleTable.put("pt_br", "pt_BR");
            IfxToJdkLocaleTable.put("pt_pt", "pt_PT");
            IfxToJdkLocaleTable.put("ro_ro", "ro_RO");
            IfxToJdkLocaleTable.put("ru_ru", "ru_RU");
            IfxToJdkLocaleTable.put("sh_yu", "sh_YU");
            IfxToJdkLocaleTable.put("sk_sk", "sk_SK");
            IfxToJdkLocaleTable.put("sv_se", "sv_SE");
            IfxToJdkLocaleTable.put("th_th", "th_TH");
            IfxToJdkLocaleTable.put("tr_tr", "tr_TR");
            IfxToJdkLocaleTable.put("uk_ua", "uk_UA");
            IfxToJdkLocaleTable.put("zh_cn", "zh_CN");
            IfxToJdkLocaleTable.put("zh_tw", "zh_TW");
            IfxToJdkLocaleTable.put("zh_hk", "zh_HK");
        }
    }

    private static class IfxNLSLocale {
        static Hashtable<String, String[]> NLSToJDK = null;

        private IfxNLSLocale() {
        }

        private static String[] FromNLSToJDK(String NLSLocName) {
            String[] temp;
            String[] retVal = new String[2];
            if (NLSLocName != null && (temp = NLSToJDK.get(NLSLocName)) != null) {
                retVal[1] = temp[1];
                retVal[0] = temp[0];
            }
            return retVal;
        }

        static {
            if (NLSToJDK == null) {
                NLSToJDK = new Hashtable();
                NLSToJDK.put("Ar_AA.IBM-1046", new String[]{null, null});
                NLSToJDK.put("C", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("Ca_ES.IBM-850", new String[]{"ca_ES", "Cp850"});
                NLSToJDK.put("Cz_CZ.852", new String[]{null, "Cp852"});
                NLSToJDK.put("Cz_CZ.88592", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("Da_DK", new String[]{"da_DK", "Cp850"});
                NLSToJDK.put("Da_DK.646", new String[]{"da_DK", null});
                NLSToJDK.put("Da_DK.850", new String[]{"da_DK", "Cp850"});
                NLSToJDK.put("Da_DK.88591", new String[]{"da_DK", "ISO8859_1"});
                NLSToJDK.put("Da_DK.IBM-850", new String[]{"da_DK", "Cp850"});
                NLSToJDK.put("De", new String[]{"de_DE", null});
                NLSToJDK.put("De_AT.850", new String[]{"de_AT", "Cp850"});
                NLSToJDK.put("De_AT.88591", new String[]{"de_AT", "ISO8859_1"});
                NLSToJDK.put("De_CH", new String[]{"de_CH", "Cp850"});
                NLSToJDK.put("De_CH.646", new String[]{"de_CH", null});
                NLSToJDK.put("De_CH.850", new String[]{"de_CH", "Cp850"});
                NLSToJDK.put("De_CH.88591", new String[]{"de_CH", "ISO8859_1"});
                NLSToJDK.put("De_CH.8859_300", new String[]{"de_CH", "ISO8859_1"});
                NLSToJDK.put("De_CH.IBM-850", new String[]{"de_CH", "Cp850"});
                NLSToJDK.put("De_DE", new String[]{"de_DE", "Cp850"});
                NLSToJDK.put("De_DE.646", new String[]{"de_DE", null});
                NLSToJDK.put("De_DE.646@TE", new String[]{"de_DE", null});
                NLSToJDK.put("De_DE.6937", new String[]{"de_DE", null});
                NLSToJDK.put("De_DE.6937@TE", new String[]{"de_DE", null});
                NLSToJDK.put("De_DE.88591", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("De_DE.88591@TE", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("De_DE.8859_300", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("De_DE.IBM-850", new String[]{"de_DE", "Cp850"});
                NLSToJDK.put("El_GR.869", new String[]{"el_GR", null});
                NLSToJDK.put("El_GR.88597", new String[]{"el_GR", "ISO8859_7"});
                NLSToJDK.put("En", new String[]{"en_US", "ASCII"});
                NLSToJDK.put("En_GB", new String[]{"en_GB", "Cp850"});
                NLSToJDK.put("En_GB.646", new String[]{"en_GB", "ASCII"});
                NLSToJDK.put("En_GB.6937", new String[]{"en_GB", null});
                NLSToJDK.put("En_GB.850", new String[]{"en_GB", "Cp850"});
                NLSToJDK.put("En_GB.88591", new String[]{"en_GB", "ISO8859_1"});
                NLSToJDK.put("En_GB.8859_300", new String[]{"en_GB", "ISO8859_1"});
                NLSToJDK.put("En_GB.IBM-850", new String[]{"en_GB", "Cp850"});
                NLSToJDK.put("En_US", new String[]{"en_US", "Cp850"});
                NLSToJDK.put("En_US.646", new String[]{"en_US", "ASCII"});
                NLSToJDK.put("En_US.88591", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("En_US.8859_300", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("En_US.ASCII", new String[]{"en_US", "ASCII"});
                NLSToJDK.put("En_US.IBM-850", new String[]{"en_US", "Cp850"});
                NLSToJDK.put("Es_CA.850", new String[]{null, "Cp850"});
                NLSToJDK.put("Es_CA.88591", new String[]{null, "ISO8859_1"});
                NLSToJDK.put("Es_ES", new String[]{"es_ES", "Cp850"});
                NLSToJDK.put("Es_ES.646", new String[]{"es_ES", null});
                NLSToJDK.put("Es_ES.850", new String[]{"es_ES", "Cp850"});
                NLSToJDK.put("Es_ES.88591", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("Es_ES.8859_300", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("Es_ES.IBM-850", new String[]{"es_ES", "Cp850"});
                NLSToJDK.put("Fi_FI", new String[]{"fi_FI", "Cp850"});
                NLSToJDK.put("Fi_FI.850", new String[]{"fi_FI", "Cp850"});
                NLSToJDK.put("Fi_FI.88591", new String[]{"fi_FI", "ISO8859_1"});
                NLSToJDK.put("Fi_FI.IBM-850", new String[]{"fi_FI", "Cp850"});
                NLSToJDK.put("Fr_BE", new String[]{"fr_BE", "Cp850"});
                NLSToJDK.put("Fr_BE.850", new String[]{"fr_BE", "Cp850"});
                NLSToJDK.put("Fr_BE.88591", new String[]{"fr_BE", "ISO8859_1"});
                NLSToJDK.put("Fr_BE.IBM-850", new String[]{"fr_BE", "Cp850"});
                NLSToJDK.put("Fr_CA", new String[]{"fr_CA", "Cp850"});
                NLSToJDK.put("Fr_CA.850", new String[]{"fr_CA", "Cp850"});
                NLSToJDK.put("Fr_CA.88591", new String[]{"fr_CA", "ISO8859_1"});
                NLSToJDK.put("Fr_CA.IBM-850", new String[]{"fr_CA", "Cp850"});
                NLSToJDK.put("Fr_CH", new String[]{"fr_CH", "Cp850"});
                NLSToJDK.put("Fr_CH.646", new String[]{"fr_CH", null});
                NLSToJDK.put("Fr_CH.850", new String[]{"fr_CH", "Cp850"});
                NLSToJDK.put("Fr_CH.88591", new String[]{"fr_CH", "ISO8859_1"});
                NLSToJDK.put("Fr_CH.8859_300", new String[]{"fr_CH", "ISO8859_1"});
                NLSToJDK.put("Fr_CH.IBM-850", new String[]{"fr_CH", "Cp850"});
                NLSToJDK.put("Fr_FR", new String[]{"fr_FR", "Cp850"});
                NLSToJDK.put("Fr_FR.646", new String[]{"fr_FR", null});
                NLSToJDK.put("Fr_FR.850", new String[]{"fr_FR", "Cp850"});
                NLSToJDK.put("Fr_FR.88591", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("Fr_FR.8859_300", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("Fr_FR.IBM-850", new String[]{"fr_FR", "Cp850"});
                NLSToJDK.put("Hu_HU.852", new String[]{"hu_HU", "Cp852"});
                NLSToJDK.put("Hu_HU.88592", new String[]{"hu_HU", "ISO8859_2"});
                NLSToJDK.put("Is_IS", new String[]{"is_IS", "Cp850"});
                NLSToJDK.put("Is_IS.IBM-850", new String[]{"is_IS", "Cp850"});
                NLSToJDK.put("It_CH.850", new String[]{"it_CH", "Cp850"});
                NLSToJDK.put("It_CH.88591", new String[]{"it_CH", "ISO8859_1"});
                NLSToJDK.put("It_IT", new String[]{"it_IT", "Cp850"});
                NLSToJDK.put("It_IT.850", new String[]{"it_IT", "Cp850"});
                NLSToJDK.put("It_IT.88591", new String[]{"it_IT", "ISO8859_1"});
                NLSToJDK.put("It_IT.IBM-850", new String[]{"it_IT", "Cp850"});
                NLSToJDK.put("Iw_IL.IBM-856", new String[]{"iw_IL", "Cp850"});
                NLSToJDK.put("Nl_BE", new String[]{"nl_BE", "Cp850"});
                NLSToJDK.put("Nl_BE.850", new String[]{"nl_BE", "Cp850"});
                NLSToJDK.put("Nl_BE.88591", new String[]{"nl_BE", "ISO8859_1"});
                NLSToJDK.put("Nl_BE.IBM-850", new String[]{"nl_BE", "Cp850"});
                NLSToJDK.put("Nl_NL", new String[]{"nl_NL", "Cp850"});
                NLSToJDK.put("Nl_NL.646", new String[]{"nl_NL", null});
                NLSToJDK.put("Nl_NL.850", new String[]{"nl_NL", "Cp850"});
                NLSToJDK.put("Nl_NL.88591", new String[]{"nl_NL", "ISO8859_1"});
                NLSToJDK.put("Nl_NL.8859_300", new String[]{"nl_NL", "ISO8859_1"});
                NLSToJDK.put("Nl_NL.IBM-850", new String[]{"nl_NL", "Cp850"});
                NLSToJDK.put("No_NO", new String[]{"no_NO", "Cp850"});
                NLSToJDK.put("No_NO.646", new String[]{"no_NO", null});
                NLSToJDK.put("No_NO.850", new String[]{"no_NO", "Cp850"});
                NLSToJDK.put("No_NO.88591", new String[]{"no_NO", "ISO8859_1"});
                NLSToJDK.put("No_NO.8859_300", new String[]{"no_NO", "ISO8859_1"});
                NLSToJDK.put("No_NO.IBM-850", new String[]{"no_NO", "Cp850"});
                NLSToJDK.put("POSIX", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("Pl_PL.852", new String[]{"pl_PL", "Cp852"});
                NLSToJDK.put("Pl_PL.88592", new String[]{"pl_PL", "ISO8859_2"});
                NLSToJDK.put("Pt_PT", new String[]{"pt_PT", "Cp850"});
                NLSToJDK.put("Pt_PT.646", new String[]{"pt_PT", null});
                NLSToJDK.put("Pt_PT.850", new String[]{"pt_PT", "Cp850"});
                NLSToJDK.put("Pt_PT.88591", new String[]{"pt_PT", "ISO8859_1"});
                NLSToJDK.put("Pt_PT.8859_300", new String[]{"pt_PT", "ISO8859_1"});
                NLSToJDK.put("Pt_PT.IBM-850", new String[]{"pt_PT", "Cp850"});
                NLSToJDK.put("Ru_RU.866", new String[]{"ru_RU", "Cp866"});
                NLSToJDK.put("Ru_RU.88595", new String[]{"ru_RU", "ISO8859_5"});
                NLSToJDK.put("Sh_HR.852", new String[]{null, "Cp852"});
                NLSToJDK.put("Sh_HR.88592", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("Sk_SK.852", new String[]{"sk_SK", "Cp852"});
                NLSToJDK.put("Sk_SK.88592", new String[]{"sk_SK", "ISO8859_2"});
                NLSToJDK.put("Sv_SE", new String[]{"sv_SE", "Cp850"});
                NLSToJDK.put("Sv_SE.646", new String[]{"sv_SE", null});
                NLSToJDK.put("Sv_SE.850", new String[]{"sv_SE", "Cp850"});
                NLSToJDK.put("Sv_SE.88591", new String[]{"sv_SE", "ISO8859_1"});
                NLSToJDK.put("Sv_SE.8859_300", new String[]{"sv_SE", "ISO8859_1"});
                NLSToJDK.put("Sv_SE.IBM-850", new String[]{"sv_SE", "Cp850"});
                NLSToJDK.put("Tr_TR.857", new String[]{"tr_TR", null});
                NLSToJDK.put("Tr_TR.88599", new String[]{"tr_TR", "ISO8859_9"});
                NLSToJDK.put("american", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("american.iso88591", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("american.iso88591@fold", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("american.iso88591@nofold", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("american@fold", new String[]{"en_US", null});
                NLSToJDK.put("american@nofold", new String[]{"en_US", null});
                NLSToJDK.put("ar_AA", new String[]{null, "ISO8859_6"});
                NLSToJDK.put("ar_AA.ISO8859-6", new String[]{null, "ISO8859_6"});
                NLSToJDK.put("ar_DZ.ara8", new String[]{null, null});
                NLSToJDK.put("ar_SA.ara8", new String[]{"ar_SA", null});
                NLSToJDK.put("ar_SA.iso6", new String[]{"ar_SA", "ISO8859_6"});
                NLSToJDK.put("arabic", new String[]{"ar_SA", "ISO8859_6"});
                NLSToJDK.put("arabic-w", new String[]{null, null});
                NLSToJDK.put("arabic-w@fold", new String[]{null, null});
                NLSToJDK.put("arabic-w@nofold", new String[]{null, null});
                NLSToJDK.put("arabic.iso88596", new String[]{"ar_SA", "ISO8859_6"});
                NLSToJDK.put("arabic.iso88596@fold", new String[]{"ar_SA", "ISO8859_6"});
                NLSToJDK.put("arabic.iso88596@nofold", new String[]{"ar_SA", "ISO8859_6"});
                NLSToJDK.put("arabic@fold", new String[]{"ar_SA", null});
                NLSToJDK.put("arabic@nofold", new String[]{"ar_SA", null});
                NLSToJDK.put("bg_BG", new String[]{"bg_BG", "ISO8859_5"});
                NLSToJDK.put("bg_BG.ISO8859-5", new String[]{"bg_BG", "ISO8859_5"});
                NLSToJDK.put("bg_BG.iso5", new String[]{"bg_BG", "ISO8859_5"});
                NLSToJDK.put("bulgarian", new String[]{"bg_BG", "ISO8859_5"});
                NLSToJDK.put("bulgarian@fold", new String[]{"bg_BG", "ISO8859_5"});
                NLSToJDK.put("bulgarian@nofold", new String[]{"bg_BG", "ISO8859_5"});
                NLSToJDK.put("c-french", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("c-french.iso88591", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("c-french.iso88591@fold", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("c-french.iso88591@nofold", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("c-french@fold", new String[]{"fr_FR", null});
                NLSToJDK.put("c-french@nofold", new String[]{"fr_FR", null});
                NLSToJDK.put("ca_ES", new String[]{"ca_ES", "ISO8859_1"});
                NLSToJDK.put("ca_ES.ISO8859-1", new String[]{"ca_ES", "ISO8859_1"});
                NLSToJDK.put("cs", new String[]{"cs_CZ", "ISO8859_2"});
                NLSToJDK.put("cs_CZ", new String[]{"cs_CZ", "ISO8859_2"});
                NLSToJDK.put("cs_CZ.ISO8859-2", new String[]{"cs_CZ", "ISO8859_2"});
                NLSToJDK.put("cs_CZ.iso2", new String[]{"cs_CZ", "ISO8859_2"});
                NLSToJDK.put("cz", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("czech", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("czech@fold", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("czech@nofold", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("da", new String[]{"da_DK", "ISO8859_1"});
                NLSToJDK.put("da_DK", new String[]{"da_DK", "ISO8859_1"});
                NLSToJDK.put("da_DK.850", new String[]{"da_DK", "Cp850"});
                NLSToJDK.put("da_DK.865", new String[]{"da_DK", null});
                NLSToJDK.put("da_DK.ISO8859-1", new String[]{"da_DK", "ISO8859_1"});
                NLSToJDK.put("da_DK.iso1", new String[]{"da_DK", "ISO8859_1"});
                NLSToJDK.put("da_DK.rom8", new String[]{"da_DK", null});
                NLSToJDK.put("danish", new String[]{"da_DK", null});
                NLSToJDK.put("danish.iso88591", new String[]{"da_DK", "ISO8859_1"});
                NLSToJDK.put("danish.iso88591@fold", new String[]{"da_DK", "ISO8859_1"});
                NLSToJDK.put("danish.iso88591@nofold", new String[]{"da_DK", "ISO8859_1"});
                NLSToJDK.put("danish@fold", new String[]{"da_DK", null});
                NLSToJDK.put("danish@nofold", new String[]{"da_DK", null});
                NLSToJDK.put("de", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("de_AT", new String[]{"de_AT", "ISO8859_1"});
                NLSToJDK.put("de_AT.437", new String[]{"de_AT", null});
                NLSToJDK.put("de_AT.850", new String[]{"de_AT", "Cp850"});
                NLSToJDK.put("de_CH", new String[]{"de_CH", "ISO8859_1"});
                NLSToJDK.put("de_CH.437", new String[]{"de_CH", null});
                NLSToJDK.put("de_CH.850", new String[]{"de_CH", "Cp850"});
                NLSToJDK.put("de_CH.ISO8859-1", new String[]{"de_CH", "ISO8859_1"});
                NLSToJDK.put("de_DE", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("de_DE.437", new String[]{"de_DE", null});
                NLSToJDK.put("de_DE.850", new String[]{"de_DE", "Cp850"});
                NLSToJDK.put("de_DE.ISO8859-1", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("de_DE.iso1", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("de_DE.rom8", new String[]{"de_DE", null});
                NLSToJDK.put("dutch", new String[]{"nl_NL", null});
                NLSToJDK.put("dutch-belgian", new String[]{"nl_BE", "Cp1252"});
                NLSToJDK.put("dutch.iso88591", new String[]{"nl_NL", "ISO8859_1"});
                NLSToJDK.put("dutch.iso88591@fold", new String[]{"nl_NL", "ISO8859_1"});
                NLSToJDK.put("dutch.iso88591@nofold", new String[]{"nl_NL", "ISO8859_1"});
                NLSToJDK.put("dutch@fold", new String[]{"nl_NL", null});
                NLSToJDK.put("dutch@nofold", new String[]{"nl_NL", null});
                NLSToJDK.put("el", new String[]{"el_GR", "ISO8859_7"});
                NLSToJDK.put("el_GR", new String[]{"el_GR", "ISO8859_7"});
                NLSToJDK.put("el_GR.ISO8859-7", new String[]{"el_GR", "ISO8859_7"});
                NLSToJDK.put("el_GR.gre8", new String[]{"el_GR", null});
                NLSToJDK.put("el_GR.iso7", new String[]{"el_GR", "ISO8859_7"});
                NLSToJDK.put("en", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("en_AU", new String[]{"en_AU", "ISO8859_1"});
                NLSToJDK.put("en_AU.437", new String[]{"en_AU", null});
                NLSToJDK.put("en_AU.646", new String[]{"en_AU", "ASCII"});
                NLSToJDK.put("en_AU.850", new String[]{"en_AU", "Cp850"});
                NLSToJDK.put("en_CA", new String[]{"en_CA", "ISO8859_1"});
                NLSToJDK.put("en_CA.437", new String[]{"en_CA", null});
                NLSToJDK.put("en_CA.646", new String[]{"en_CA", "ASCII"});
                NLSToJDK.put("en_CA.850", new String[]{"en_CA", "Cp850"});
                NLSToJDK.put("en_CA.863", new String[]{"en_CA", null});
                NLSToJDK.put("en_GB", new String[]{"en_GB", "ISO8859_1"});
                NLSToJDK.put("en_GB.437", new String[]{"en_GB", null});
                NLSToJDK.put("en_GB.646", new String[]{"en_GB", "ASCII"});
                NLSToJDK.put("en_GB.850", new String[]{"en_GB", "Cp850"});
                NLSToJDK.put("en_GB.ISO8859-1", new String[]{"en_GB", "ISO8859_1"});
                NLSToJDK.put("en_GB.iso1", new String[]{"en_GB", "ISO8859_1"});
                NLSToJDK.put("en_GB.rom8", new String[]{"en_GB", null});
                NLSToJDK.put("en_IE", new String[]{"en_IE", "ISO8859_1"});
                NLSToJDK.put("en_IR", new String[]{null, "ISO8859_1"});
                NLSToJDK.put("en_IR.437", new String[]{null, null});
                NLSToJDK.put("en_IR.646", new String[]{null, "ASCII"});
                NLSToJDK.put("en_IR.850", new String[]{null, "Cp850"});
                NLSToJDK.put("en_NZ", new String[]{"en_NZ", "ISO8859_1"});
                NLSToJDK.put("en_NZ.437", new String[]{"en_NZ", null});
                NLSToJDK.put("en_NZ.646", new String[]{"en_NZ", "ASCII"});
                NLSToJDK.put("en_NZ.850", new String[]{"en_NZ", "Cp850"});
                NLSToJDK.put("en_UK", new String[]{null, "ISO8859_1"});
                NLSToJDK.put("en_US", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("en_US.437", new String[]{"en_US", null});
                NLSToJDK.put("en_US.646", new String[]{"en_US", "ASCII"});
                NLSToJDK.put("en_US.850", new String[]{"en_US", "Cp850"});
                NLSToJDK.put("en_US.ISO8859-1", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("en_US.ascii", new String[]{"en_US", "ASCII"});
                NLSToJDK.put("en_US.iso1", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("en_US.rom8", new String[]{"en_US", null});
                NLSToJDK.put("english", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("english-aus", new String[]{"en_AU", "Cp1252"});
                NLSToJDK.put("english-can", new String[]{"en_CA", "Cp1252"});
                NLSToJDK.put("english-ire", new String[]{null, "Cp1252"});
                NLSToJDK.put("english-nz", new String[]{"en_NZ", "Cp1252"});
                NLSToJDK.put("english-uk", new String[]{"en_GB", "Cp1252"});
                NLSToJDK.put("english-usa", new String[]{"en_US", "Cp1252"});
                NLSToJDK.put("english.iso88591", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("english.iso88591@fold", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("english.iso88591@nofold", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("english@fold", new String[]{"en_US", null});
                NLSToJDK.put("english@nofold", new String[]{"en_US", null});
                NLSToJDK.put("english_uk.8859", new String[]{null, "ISO8859_1"});
                NLSToJDK.put("english_uk.8859m", new String[]{null, "ISO8859_1"});
                NLSToJDK.put("english_uk.ascii", new String[]{null, "ASCII"});
                NLSToJDK.put("english_us.8859", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("english_us.8859m", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("english_us.ascii", new String[]{"en_US", "ASCII"});
                NLSToJDK.put("es", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("es_AR", new String[]{"es_AR", "ISO8859_1"});
                NLSToJDK.put("es_AR.437", new String[]{"es_AR", null});
                NLSToJDK.put("es_AR.850", new String[]{"es_AR", "Cp850"});
                NLSToJDK.put("es_BO", new String[]{"es_BO", "ISO8859_1"});
                NLSToJDK.put("es_CL", new String[]{"es_CL", "ISO8859_1"});
                NLSToJDK.put("es_CL.437", new String[]{"es_CL", null});
                NLSToJDK.put("es_CL.850", new String[]{"es_CL", "Cp850"});
                NLSToJDK.put("es_CO", new String[]{"es_CO", "ISO8859_1"});
                NLSToJDK.put("es_CR", new String[]{"es_CR", "ISO8859_1"});
                NLSToJDK.put("es_EC", new String[]{"es_EC", "ISO8859_1"});
                NLSToJDK.put("es_ES", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("es_ES.437", new String[]{"es_ES", null});
                NLSToJDK.put("es_ES.850", new String[]{"es_ES", "Cp850"});
                NLSToJDK.put("es_ES.ISO8859-1", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("es_ES.iso1", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("es_ES.rom8", new String[]{"es_ES", null});
                NLSToJDK.put("es_GT", new String[]{"es_GT", "ISO8859_1"});
                NLSToJDK.put("es_MX", new String[]{"es_MX", "ISO8859_1"});
                NLSToJDK.put("es_MX.437", new String[]{"es_MX", null});
                NLSToJDK.put("es_MX.850", new String[]{"es_MX", "Cp850"});
                NLSToJDK.put("es_NI", new String[]{null, "ISO8859_1"});
                NLSToJDK.put("es_PA", new String[]{"es_PA", "ISO8859_1"});
                NLSToJDK.put("es_PE", new String[]{"es_PE", "ISO8859_1"});
                NLSToJDK.put("es_PY", new String[]{"es_PY", "ISO8859_1"});
                NLSToJDK.put("es_SV", new String[]{"es_SV", "ISO8859_1"});
                NLSToJDK.put("es_UY", new String[]{"es_UY", "ISO8859_1"});
                NLSToJDK.put("es_VE", new String[]{"es_VE", "ISO8859_1"});
                NLSToJDK.put("es_VE.437", new String[]{"es_VE", null});
                NLSToJDK.put("es_VE.850", new String[]{"es_VE", "Cp850"});
                NLSToJDK.put("fi", new String[]{"fi_FI", "ISO8859_1"});
                NLSToJDK.put("fi_FI", new String[]{"fi_FI", "ISO8859_1"});
                NLSToJDK.put("fi_FI.437", new String[]{"fi_FI", null});
                NLSToJDK.put("fi_FI.850", new String[]{"fi_FI", "Cp850"});
                NLSToJDK.put("fi_FI.ISO8859-1", new String[]{"fi_FI", "ISO8859_1"});
                NLSToJDK.put("fi_FI.iso1", new String[]{"fi_FI", "ISO8859_1"});
                NLSToJDK.put("fi_FI.rom8", new String[]{"fi_FI", null});
                NLSToJDK.put("finnish", new String[]{"fi_FI", null});
                NLSToJDK.put("finnish.iso88591", new String[]{"fi_FI", "ISO8859_1"});
                NLSToJDK.put("finnish.iso88591@fold", new String[]{"fi_FI", "ISO8859_1"});
                NLSToJDK.put("finnish.iso88591@nofold", new String[]{"fi_FI", "ISO8859_1"});
                NLSToJDK.put("finnish@fold", new String[]{"fi_FI", null});
                NLSToJDK.put("finnish@nofold", new String[]{"fi_FI", null});
                NLSToJDK.put("fr", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("fr_BE", new String[]{"fr_BE", "ISO8859_1"});
                NLSToJDK.put("fr_BE.437", new String[]{"fr_BE", null});
                NLSToJDK.put("fr_BE.850", new String[]{"fr_BE", "Cp850"});
                NLSToJDK.put("fr_BE.ISO8859-1", new String[]{"fr_BE", "ISO8859_1"});
                NLSToJDK.put("fr_CA", new String[]{"fr_CA", "ISO8859_1"});
                NLSToJDK.put("fr_CA.850", new String[]{"fr_CA", "Cp850"});
                NLSToJDK.put("fr_CA.863", new String[]{"fr_CA", null});
                NLSToJDK.put("fr_CA.ISO8859-1", new String[]{"fr_CA", "ISO8859_1"});
                NLSToJDK.put("fr_CA.iso1", new String[]{"fr_CA", "ISO8859_1"});
                NLSToJDK.put("fr_CA.rom8", new String[]{"fr_CA", null});
                NLSToJDK.put("fr_CH", new String[]{"fr_CH", "ISO8859_1"});
                NLSToJDK.put("fr_CH.437", new String[]{"fr_CH", null});
                NLSToJDK.put("fr_CH.850", new String[]{"fr_CH", "Cp850"});
                NLSToJDK.put("fr_CH.ISO8859-1", new String[]{"fr_CH", "ISO8859_1"});
                NLSToJDK.put("fr_FR", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("fr_FR.437", new String[]{"fr_FR", null});
                NLSToJDK.put("fr_FR.850", new String[]{"fr_FR", "Cp850"});
                NLSToJDK.put("fr_FR.ISO8859-1", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("fr_FR.iso1", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("fr_FR.rom8", new String[]{"fr_FR", null});
                NLSToJDK.put("french", new String[]{"fr_FR", null});
                NLSToJDK.put("french-belgian", new String[]{"fr_BE", "Cp1252"});
                NLSToJDK.put("french-canadian", new String[]{"fr_CA", "Cp1252"});
                NLSToJDK.put("french-swiss", new String[]{"fr_CH", "Cp1252"});
                NLSToJDK.put("french.iso88591", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("french.iso88591@fold", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("french.iso88591@nofold", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("french@fold", new String[]{"fr_FR", null});
                NLSToJDK.put("french@nofold", new String[]{"fr_FR", null});
                NLSToJDK.put("french_france.8859", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("french_france.8859m", new String[]{"fr_FR", "ISO8859_1"});
                NLSToJDK.put("french_france.ascii", new String[]{"fr_FR", "ASCII"});
                NLSToJDK.put("german", new String[]{"de_DE", null});
                NLSToJDK.put("german-austrian", new String[]{"de_AT", "Cp1252"});
                NLSToJDK.put("german-swiss", new String[]{"de_CH", "Cp1252"});
                NLSToJDK.put("german.iso88591", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("german.iso88591@fold", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("german.iso88591@nofold", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("german@fold", new String[]{"de_DE", null});
                NLSToJDK.put("german@nofold", new String[]{"de_DE", null});
                NLSToJDK.put("german_germany.8859", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("german_germany.8859m", new String[]{"de_DE", "ISO8859_1"});
                NLSToJDK.put("german_germany.ascii", new String[]{"de_DE", "ASCII"});
                NLSToJDK.put("greek", new String[]{"el_GR", null});
                NLSToJDK.put("greek.iso88597", new String[]{"el_GR", "ISO8859_7"});
                NLSToJDK.put("greek.iso88597@fold", new String[]{"el_GR", "ISO8859_7"});
                NLSToJDK.put("greek.iso88597@nofold", new String[]{"el_GR", "ISO8859_7"});
                NLSToJDK.put("greek@fold", new String[]{"el_GR", null});
                NLSToJDK.put("greek@nofold", new String[]{"el_GR", null});
                NLSToJDK.put("hebrew", new String[]{"iw_IL", null});
                NLSToJDK.put("hebrew.iso88598", new String[]{"iw_IL", "ISO8859_8"});
                NLSToJDK.put("hebrew.iso88598@fold", new String[]{"iw_IL", "ISO8859_8"});
                NLSToJDK.put("hebrew.iso88598@nofold", new String[]{"iw_IL", "ISO8859_8"});
                NLSToJDK.put("hebrew@fold", new String[]{"iw_IL", null});
                NLSToJDK.put("hebrew@nofold", new String[]{"iw_IL", null});
                NLSToJDK.put("hr_HR", new String[]{"hr_HR", "ISO8859_2"});
                NLSToJDK.put("hr_HR.ISO8859-2", new String[]{"hr_HR", "ISO8859_2"});
                NLSToJDK.put("hr_HR.iso2", new String[]{"hr_HR", "ISO8859_2"});
                NLSToJDK.put("hu_HU", new String[]{"hu_HU", "ISO8859_2"});
                NLSToJDK.put("hu_HU.ISO8859-2", new String[]{"hu_HU", "ISO8859_2"});
                NLSToJDK.put("hu_HU.iso2", new String[]{"hu_HU", "ISO8859_2"});
                NLSToJDK.put("hungarian", new String[]{"hu_HU", "ISO8859_2"});
                NLSToJDK.put("hungarian@fold", new String[]{"hu_HU", "ISO8859_2"});
                NLSToJDK.put("hungarian@nofold", new String[]{"hu_HU", "ISO8859_2"});
                NLSToJDK.put("icelandic", new String[]{"is_IS", null});
                NLSToJDK.put("icelandic.iso88591", new String[]{"is_IS", "ISO8859_1"});
                NLSToJDK.put("icelandic.iso88591@fold", new String[]{"is_IS", "ISO8859_1"});
                NLSToJDK.put("icelandic.iso88591@nofold", new String[]{"is_IS", "ISO8859_1"});
                NLSToJDK.put("icelandic@fold", new String[]{"is_IS", null});
                NLSToJDK.put("icelandic@nofold", new String[]{"is_IS", null});
                NLSToJDK.put("is", new String[]{"is_IS", "ISO8859_1"});
                NLSToJDK.put("is_IS", new String[]{"is_IS", "ISO8859_1"});
                NLSToJDK.put("is_IS.850", new String[]{"is_IS", "Cp850"});
                NLSToJDK.put("is_IS.ISO8859-1", new String[]{"is_IS", "ISO8859_1"});
                NLSToJDK.put("is_IS.iso1", new String[]{"is_IS", "ISO8859_1"});
                NLSToJDK.put("is_IS.rom8", new String[]{"is_IS", null});
                NLSToJDK.put("iso_8859_1", new String[]{"en_US", "ISO8859_1"});
                NLSToJDK.put("it", new String[]{"it_IT", "ISO8859_1"});
                NLSToJDK.put("it_CH", new String[]{"it_CH", "ISO8859_1"});
                NLSToJDK.put("it_CH.437", new String[]{"it_CH", null});
                NLSToJDK.put("it_CH.850", new String[]{"it_CH", "Cp850"});
                NLSToJDK.put("it_IT", new String[]{"it_IT", "ISO8859_1"});
                NLSToJDK.put("it_IT.437", new String[]{"it_IT", null});
                NLSToJDK.put("it_IT.850", new String[]{"it_IT", "Cp850"});
                NLSToJDK.put("it_IT.ISO8859-1", new String[]{"it_IT", "ISO8859_1"});
                NLSToJDK.put("it_IT.iso1", new String[]{"it_IT", "ISO8859_1"});
                NLSToJDK.put("it_IT.rom8", new String[]{"it_IT", null});
                NLSToJDK.put("italian", new String[]{"it_IT", null});
                NLSToJDK.put("italian-swiss", new String[]{"it_CH", "Cp1252"});
                NLSToJDK.put("italian.iso88591", new String[]{"it_IT", "ISO8859_1"});
                NLSToJDK.put("italian.iso88591@fold", new String[]{"it_IT", "ISO8859_1"});
                NLSToJDK.put("italian.iso88591@nofold", new String[]{"it_IT", "ISO8859_1"});
                NLSToJDK.put("italian@fold", new String[]{"it_IT", null});
                NLSToJDK.put("italian@nofold", new String[]{"it_IT", null});
                NLSToJDK.put("iw_IL", new String[]{"iw_IL", "ISO8859_8"});
                NLSToJDK.put("iw_IL.ISO8859-8", new String[]{"iw_IL", "ISO8859_8"});
                NLSToJDK.put("iw_IL.heb8", new String[]{"iw_IL", null});
                NLSToJDK.put("iw_IL.iso8", new String[]{"iw_IL", "ISO8859_8"});
                NLSToJDK.put("mk_MK", new String[]{"mk_MK", "ISO8859_5"});
                NLSToJDK.put("mk_MK.ISO8859-5", new String[]{"mk_MK", "ISO8859_5"});
                NLSToJDK.put("nl", new String[]{"nl_NL", "ISO8859_1"});
                NLSToJDK.put("nl_BE", new String[]{"nl_BE", "ISO8859_1"});
                NLSToJDK.put("nl_BE.437", new String[]{"nl_BE", null});
                NLSToJDK.put("nl_BE.850", new String[]{"nl_BE", "Cp850"});
                NLSToJDK.put("nl_BE.ISO8859-1", new String[]{"nl_BE", "ISO8859_1"});
                NLSToJDK.put("nl_NL", new String[]{"nl_NL", "ISO8859_1"});
                NLSToJDK.put("nl_NL.437", new String[]{"nl_NL", null});
                NLSToJDK.put("nl_NL.850", new String[]{"nl_NL", "Cp850"});
                NLSToJDK.put("nl_NL.ISO8859-1", new String[]{"nl_NL", "ISO8859_1"});
                NLSToJDK.put("nl_NL.iso1", new String[]{"nl_NL", "ISO8859_1"});
                NLSToJDK.put("nl_NL.rom8", new String[]{"nl_NL", null});
                NLSToJDK.put("no", new String[]{"no_NO", "ISO8859_1"});
                NLSToJDK.put("no_NO", new String[]{"no_NO", "ISO8859_1"});
                NLSToJDK.put("no_NO.850", new String[]{"no_NO", "Cp850"});
                NLSToJDK.put("no_NO.865", new String[]{"no_NO", null});
                NLSToJDK.put("no_NO.ISO8859-1", new String[]{"no_NO", "ISO8859_1"});
                NLSToJDK.put("no_NO.iso1", new String[]{"no_NO", "ISO8859_1"});
                NLSToJDK.put("no_NO.rom8", new String[]{"no_NO", null});
                NLSToJDK.put("norwegian", new String[]{"no_NO", null});
                NLSToJDK.put("norwegian-bokmal", new String[]{"no_NO", "Cp1252"});
                NLSToJDK.put("norwegian-nynorsk", new String[]{null, "Cp1252"});
                NLSToJDK.put("norwegian.iso88591", new String[]{"no_NO", "ISO8859_1"});
                NLSToJDK.put("norwegian.iso88591@fold", new String[]{"no_NO", "ISO8859_1"});
                NLSToJDK.put("norwegian.iso88591@nofold", new String[]{"no_NO", "ISO8859_1"});
                NLSToJDK.put("norwegian@fold", new String[]{"no_NO", null});
                NLSToJDK.put("norwegian@nofold", new String[]{"no_NO", null});
                NLSToJDK.put("pl", new String[]{"pl_PL", "ISO8859_2"});
                NLSToJDK.put("pl_PL", new String[]{"pl_PL", "ISO8859_2"});
                NLSToJDK.put("pl_PL.ISO8859-2", new String[]{"pl_PL", "ISO8859_2"});
                NLSToJDK.put("pl_PL.iso2", new String[]{"pl_PL", "ISO8859_2"});
                NLSToJDK.put("polish", new String[]{"pl_PL", "ISO8859_2"});
                NLSToJDK.put("polish@fold", new String[]{"pl_PL", "ISO8859_2"});
                NLSToJDK.put("polish@nofold", new String[]{"pl_PL", "ISO8859_2"});
                NLSToJDK.put("portuguese", new String[]{"pt_PT", null});
                NLSToJDK.put("portuguese-brazilian", new String[]{"pt_BR", "Cp1252"});
                NLSToJDK.put("portuguese.iso88591", new String[]{"pt_PT", "ISO8859_1"});
                NLSToJDK.put("portuguese.iso88591@fold", new String[]{"pt_PT", "ISO8859_1"});
                NLSToJDK.put("portuguese.iso88591@nofold", new String[]{"pt_PT", "ISO8859_1"});
                NLSToJDK.put("portuguese@fold", new String[]{"pt_PT", null});
                NLSToJDK.put("portuguese@nofold", new String[]{"pt_PT", null});
                NLSToJDK.put("portuguese_brazil.8859", new String[]{"pt_BR", "ISO8859_1"});
                NLSToJDK.put("portuguese_brazil.8859m", new String[]{"pt_BR", "ISO8859_1"});
                NLSToJDK.put("portuguese_brazil.ascii", new String[]{"pt_BR", "ASCII"});
                NLSToJDK.put("pt", new String[]{"pt_PT", "ISO8859_1"});
                NLSToJDK.put("pt_BR", new String[]{"pt_BR", "ISO8859_1"});
                NLSToJDK.put("pt_BR.850", new String[]{"pt_BR", "Cp850"});
                NLSToJDK.put("pt_BR.860", new String[]{"pt_BR", null});
                NLSToJDK.put("pt_BR.ISO8859-1", new String[]{"pt_BR", "ISO8859_1"});
                NLSToJDK.put("pt_PT", new String[]{"pt_PT", "ISO8859_1"});
                NLSToJDK.put("pt_PT.850", new String[]{"pt_PT", "Cp850"});
                NLSToJDK.put("pt_PT.860", new String[]{"pt_PT", null});
                NLSToJDK.put("pt_PT.ISO8859-1", new String[]{"pt_PT", "ISO8859_1"});
                NLSToJDK.put("pt_PT.iso1", new String[]{"pt_PT", "ISO8859_1"});
                NLSToJDK.put("pt_PT.rom8", new String[]{"pt_PT", null});
                NLSToJDK.put("ro_RO", new String[]{"ro_RO", "ISO8859_2"});
                NLSToJDK.put("ro_RO.ISO8859-2", new String[]{"ro_RO", "ISO8859_2"});
                NLSToJDK.put("ro_RO.iso2", new String[]{"ro_RO", "ISO8859_2"});
                NLSToJDK.put("ru", new String[]{"ru_RU", "ISO8859_5"});
                NLSToJDK.put("ru_RU", new String[]{"ru_RU", "ISO8859_5"});
                NLSToJDK.put("ru_RU.1251", new String[]{"ru_RU", "Cp1251"});
                NLSToJDK.put("ru_RU.866", new String[]{"ru_RU", "Cp866"});
                NLSToJDK.put("ru_RU.ISO8859-5", new String[]{"ru_RU", "ISO8859_5"});
                NLSToJDK.put("ru_RU.iso5", new String[]{"ru_RU", "ISO8859_5"});
                NLSToJDK.put("ru_SU", new String[]{null, "ISO8859_5"});
                NLSToJDK.put("rumanian", new String[]{"ro_RO", "ISO8859_2"});
                NLSToJDK.put("rumanian@fold", new String[]{"ro_RO", "ISO8859_2"});
                NLSToJDK.put("rumanian@nofold", new String[]{"ro_RO", "ISO8859_2"});
                NLSToJDK.put("russian", new String[]{"ru_RU", "Cp1251"});
                NLSToJDK.put("russian@fold", new String[]{"ru_RU", "KOI8_R"});
                NLSToJDK.put("russian@nofold", new String[]{"ru_RU", "KOI8_R"});
                NLSToJDK.put("serbocroatian", new String[]{"sh_YU", "ISO8859_2"});
                NLSToJDK.put("serbocroatian@fold", new String[]{"sh_YU", "ISO8859_2"});
                NLSToJDK.put("serbocroatian@nofold", new String[]{"sh_YU", "ISO8859_2"});
                NLSToJDK.put("sh", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("sh_SP", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("sh_SP.ISO8859-2", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("sh_YU", new String[]{"sh_YU", "ISO8859_2"});
                NLSToJDK.put("sk", new String[]{"sk_SK", "ISO8859_2"});
                NLSToJDK.put("sk_SK", new String[]{"sk_SK", "ISO8859_2"});
                NLSToJDK.put("sk_SK.ISO8859-2", new String[]{"sk_SK", "ISO8859_2"});
                NLSToJDK.put("sk_SK.iso2", new String[]{"sk_SK", "ISO8859_2"});
                NLSToJDK.put("sl_SI", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("sl_SI.ISO8859-2", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("sl_SI.iso2", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("slovak", new String[]{"sk_SK", "Cp1250"});
                NLSToJDK.put("slovene", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("slovene@fold", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("slovene@nofold", new String[]{null, "ISO8859_2"});
                NLSToJDK.put("spanish", new String[]{"es_ES", null});
                NLSToJDK.put("spanish-mexican", new String[]{"es_MX", "Cp1252"});
                NLSToJDK.put("spanish-modern", new String[]{"es_ES", "Cp1252"});
                NLSToJDK.put("spanish.iso88591", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("spanish.iso88591@fold", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("spanish.iso88591@nofold", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("spanish@fold", new String[]{"es_ES", null});
                NLSToJDK.put("spanish@nofold", new String[]{"es_ES", null});
                NLSToJDK.put("spanish_america.8859", new String[]{null, "ISO8859_1"});
                NLSToJDK.put("spanish_america.8859m", new String[]{null, "ISO8859_1"});
                NLSToJDK.put("spanish_america.ascii", new String[]{null, "ASCII"});
                NLSToJDK.put("spanish_spain.8859", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("spanish_spain.8859m", new String[]{"es_ES", "ISO8859_1"});
                NLSToJDK.put("spanish_spain.ascii", new String[]{"es_ES", "ASCII"});
                NLSToJDK.put("sr_SP", new String[]{null, "ISO8859_5"});
                NLSToJDK.put("sr_SP.ISO8859-5", new String[]{null, "ISO8859_5"});
                NLSToJDK.put("su", new String[]{"fi_FI", "ISO8859_1"});
                NLSToJDK.put("sv", new String[]{"sv_SE", "ISO8859_1"});
                NLSToJDK.put("sv_SE", new String[]{"sv_SE", "ISO8859_1"});
                NLSToJDK.put("sv_SE.437", new String[]{"sv_SE", null});
                NLSToJDK.put("sv_SE.850", new String[]{"sv_SE", "Cp850"});
                NLSToJDK.put("sv_SE.ISO8859-1", new String[]{"sv_SE", "ISO8859_1"});
                NLSToJDK.put("sv_SE.iso1", new String[]{"sv_SE", "ISO8859_1"});
                NLSToJDK.put("sv_SE.rom8", new String[]{"sv_SE", null});
                NLSToJDK.put("swedish", new String[]{"sv_SE", null});
                NLSToJDK.put("swedish.iso88591", new String[]{"sv_SE", "ISO8859_1"});
                NLSToJDK.put("swedish.iso88591@fold", new String[]{"sv_SE", "ISO8859_1"});
                NLSToJDK.put("swedish.iso88591@nofold", new String[]{"sv_SE", "ISO8859_1"});
                NLSToJDK.put("swedish@fold", new String[]{"sv_SE", null});
                NLSToJDK.put("swedish@nofold", new String[]{"sv_SE", null});
                NLSToJDK.put("tr", new String[]{"tr_TR", "ISO8859_9"});
                NLSToJDK.put("tr_TR", new String[]{"tr_TR", "ISO8859_9"});
                NLSToJDK.put("tr_TR.ISO8859-9", new String[]{"tr_TR", "ISO8859_9"});
                NLSToJDK.put("tr_TR.iso9", new String[]{"tr_TR", "ISO8859_9"});
                NLSToJDK.put("tr_TR.tuk8", new String[]{"tr_TR", null});
                NLSToJDK.put("turkish", new String[]{"tr_TR", null});
                NLSToJDK.put("turkish.iso88599", new String[]{"tr_TR", "ISO8859_9"});
                NLSToJDK.put("turkish.iso88599@fold", new String[]{"tr_TR", "ISO8859_9"});
                NLSToJDK.put("turkish.iso88599@nofold", new String[]{"tr_TR", "ISO8859_9"});
                NLSToJDK.put("turkish@fold", new String[]{"tr_TR", null});
                NLSToJDK.put("turkish@nofold", new String[]{"tr_TR", null});
            }
        }
    }
}

