/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class CHAR
extends Datum {
    static final long serialVersionUID = 5559010489982176244L;
    public static final CharacterSet DEFAULT_CHARSET;
    private CharacterSet charSet;
    private int oracleId;
    private boolean variableLength;
    private static final byte[] empty;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    protected CHAR() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, CHAR.class, $$$methodRef$$$22, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, CHAR.class, $$$methodRef$$$22, null);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, CHAR.class, $$$methodRef$$$22, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, CHAR.class, $$$methodRef$$$22, null, throwable2);
            }
            throw throwable;
        }
    }

    public CHAR(byte[] bytes, CharacterSet charSet) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, CHAR.class, $$$methodRef$$$23, null, bytes, charSet);
            }
            this.setValue(bytes, charSet);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, CHAR.class, $$$methodRef$$$23, null);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, CHAR.class, $$$methodRef$$$23, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, CHAR.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    public CHAR(byte[] bytes, int offset, int count, CharacterSet charSet) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, CHAR.class, $$$methodRef$$$24, null, bytes, offset, count, charSet);
            }
            if (bytes == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, CHAR.class, $$$methodRef$$$24, null, sQLException);
                }
                throw sQLException;
            }
            byte[] data = new byte[count];
            System.arraycopy(bytes, offset, data, 0, count);
            this.setValue(data, charSet);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, CHAR.class, $$$methodRef$$$24, null);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, CHAR.class, $$$methodRef$$$24, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, CHAR.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    public CHAR(String str, CharacterSet charSet, int len) throws SQLException {
        this(str, charSet);
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] tmpData;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, CHAR.class, $$$methodRef$$$25, null, str, charSet, len);
            }
            if ((tmpData = this.shareBytes()).length < len) {
                byte[] tmp = new byte[len];
                System.arraycopy(tmpData, 0, tmp, 0, tmpData.length);
                for (int i2 = tmpData.length; i2 < len; ++i2) {
                    tmp[i2] = 32;
                }
                this.setShareBytes(tmp);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, CHAR.class, $$$methodRef$$$25, null);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, CHAR.class, $$$methodRef$$$25, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, CHAR.class, $$$methodRef$$$25, null, throwable2);
            }
            throw throwable;
        }
    }

    public CHAR(String str, CharacterSet charSet) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, CHAR.class, $$$methodRef$$$26, null, str, charSet);
            }
            if (str == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, CHAR.class, $$$methodRef$$$26, null, sQLException);
                }
                throw sQLException;
            }
            if (charSet == null) {
                charSet = DEFAULT_CHARSET;
            }
            this.setValue(charSet.convertWithReplacement(str), charSet);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, CHAR.class, $$$methodRef$$$26, null);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, CHAR.class, $$$methodRef$$$26, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, CHAR.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    public CHAR(Object obj, CharacterSet charSet) throws SQLException {
        this(obj == null ? (String)null : obj.toString(), charSet);
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, CHAR.class, $$$methodRef$$$27, null, obj, charSet);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, CHAR.class, $$$methodRef$$$27, null);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, CHAR.class, $$$methodRef$$$27, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, CHAR.class, $$$methodRef$$$27, null, throwable2);
            }
            throw throwable;
        }
    }

    public CharacterSet getCharacterSet() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CHAR.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.charSet == null) {
                if (this.oracleId == 0) {
                    this.oracleId = -1;
                }
                this.charSet = DEFAULT_CHARSET != null && (this.oracleId == -1 || this.oracleId == DEFAULT_CHARSET.getOracleId()) ? DEFAULT_CHARSET : CharacterSet.make(this.oracleId);
            }
            CharacterSet characterSet = this.charSet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CHAR.class, $$$methodRef$$$0, this, characterSet);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CHAR.class, $$$methodRef$$$0, this, null);
            }
            return characterSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CHAR.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public int oracleId() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CHAR.class, $$$methodRef$$$1, this, new Object[0]);
            }
            int n2 = this.oracleId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CHAR.class, $$$methodRef$$$1, this, n2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CHAR.class, $$$methodRef$$$1, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CHAR.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String getString() throws SQLException {
        return this.getCharacterSet().toString(this.shareBytes(), 0, (int)this.getLength());
    }

    @DisableTrace
    public String getStringWithReplacement() {
        byte[] bytes = this.shareBytes();
        return this.getCharacterSet().toStringWithReplacement(bytes, 0, bytes.length);
    }

    @DisableTrace
    public String toString() {
        return this.getStringWithReplacement();
    }

    @Override
    @DisableTrace
    public boolean equals(Object other) {
        boolean result;
        boolean bl = result = this == other;
        if (!result && other instanceof CHAR) {
            CHAR o2 = (CHAR)other;
            result = this.bytesEqual(o2) && this.getCharacterSet().equals(o2.getCharacterSet());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    void setValue(byte[] byArray, CharacterSet characterSet) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            void charSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CHAR.class, $$$methodRef$$$2, this, byArray, characterSet);
            }
            this.charSet = charSet == null ? DEFAULT_CHARSET : charSet;
            this.oracleId = this.charSet.getOracleId();
            this.setShareBytes((byte[])(bytes == null ? empty : bytes));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CHAR.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CHAR.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CHAR.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CHAR.class, $$$methodRef$$$3, this, new Object[0]);
            }
            String string = this.stringValue();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CHAR.class, $$$methodRef$$$3, this, string);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CHAR.class, $$$methodRef$$$3, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CHAR.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void jClass;
            String class_name;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, CHAR.class, $$$methodRef$$$4, this, clazz);
            }
            boolean bl3 = bl2 = (class_name = jClass.getName()).compareTo("java.lang.String") == 0 || class_name.compareTo("java.lang.Long") == 0 || class_name.compareTo("java.math.BigDecimal") == 0 || class_name.compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.sql.Date") == 0 || class_name.compareTo("java.sql.Time") == 0 || class_name.compareTo("java.sql.Timestamp") == 0 || class_name.compareTo("java.io.Reader") == 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CHAR.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CHAR.class, $$$methodRef$$$4, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CHAR.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DisableTrace
    public String stringValue() {
        return this.toString();
    }

    @Override
    public boolean booleanValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            String s2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, CHAR.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if ((s2 = this.stringValue()) == null || s2.trim().equals("0") || s2.trim().compareToIgnoreCase("f") == 0 || s2.trim().compareToIgnoreCase("false") == 0 || s2.trim().compareToIgnoreCase("n") == 0 || s2.trim().compareToIgnoreCase("no") == 0) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, CHAR.class, $$$methodRef$$$5, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CHAR.class, $$$methodRef$$$5, this, null);
                }
                return false;
            }
            if (s2.trim().equals("1") || s2.trim().compareToIgnoreCase("t") == 0 || s2.trim().compareToIgnoreCase("true") == 0 || s2.trim().compareToIgnoreCase("y") == 0 || s2.trim().compareToIgnoreCase("yes") == 0) {
                boolean bl3 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, CHAR.class, $$$methodRef$$$5, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CHAR.class, $$$methodRef$$$5, this, null);
                }
                return true;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, CHAR.class, $$$methodRef$$$5, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CHAR.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int intValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            long result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, CHAR.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if ((result = this.longValue()) > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(26).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, CHAR.class, $$$methodRef$$$6, this, sQLException);
                }
                throw sQLException;
            }
            int n2 = (int)result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, CHAR.class, $$$methodRef$$$6, this, n2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CHAR.class, $$$methodRef$$$6, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CHAR.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long longValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, CHAR.class, $$$methodRef$$$7, this, new Object[0]);
            }
            long ret_val = 0L;
            try {
                ret_val = Long.valueOf(this.stringValue().trim());
            }
            catch (NumberFormatException e2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, CHAR.class, $$$methodRef$$$7, this, sQLException);
                }
                throw sQLException;
            }
            long l2 = ret_val;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, CHAR.class, $$$methodRef$$$7, this, l2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, CHAR.class, $$$methodRef$$$7, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, CHAR.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public float floatValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, CHAR.class, $$$methodRef$$$8, this, new Object[0]);
            }
            float ret_val = 0.0f;
            try {
                ret_val = Float.valueOf(this.stringValue().trim()).floatValue();
            }
            catch (NumberFormatException e2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, CHAR.class, $$$methodRef$$$8, this, sQLException);
                }
                throw sQLException;
            }
            float f2 = ret_val;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, CHAR.class, $$$methodRef$$$8, this, Float.valueOf(f2));
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, CHAR.class, $$$methodRef$$$8, this, null);
            }
            return f2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, CHAR.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public double doubleValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, CHAR.class, $$$methodRef$$$9, this, new Object[0]);
            }
            double ret_val = 0.0;
            try {
                ret_val = Double.valueOf(this.stringValue().trim());
            }
            catch (NumberFormatException e2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, CHAR.class, $$$methodRef$$$9, this, sQLException);
                }
                throw sQLException;
            }
            double d2 = ret_val;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, CHAR.class, $$$methodRef$$$9, this, d2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CHAR.class, $$$methodRef$$$9, this, null);
            }
            return d2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CHAR.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte byteValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            long result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, CHAR.class, $$$methodRef$$$10, this, new Object[0]);
            }
            if ((result = this.longValue()) > 127L || result < -128L) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(26).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, CHAR.class, $$$methodRef$$$10, this, sQLException);
                }
                throw sQLException;
            }
            byte by = (byte)result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, CHAR.class, $$$methodRef$$$10, this, by);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CHAR.class, $$$methodRef$$$10, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CHAR.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Date dateValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, CHAR.class, $$$methodRef$$$11, this, new Object[0]);
            }
            Date date = Date.valueOf(this.stringValue().trim());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, CHAR.class, $$$methodRef$$$11, this, date);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, CHAR.class, $$$methodRef$$$11, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, CHAR.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Time timeValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, CHAR.class, $$$methodRef$$$12, this, new Object[0]);
            }
            Time time = Time.valueOf(this.stringValue().trim());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, CHAR.class, $$$methodRef$$$12, this, time);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, CHAR.class, $$$methodRef$$$12, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, CHAR.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, CHAR.class, $$$methodRef$$$13, this, new Object[0]);
            }
            Timestamp timestamp = Timestamp.valueOf(this.stringValue().trim());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, CHAR.class, $$$methodRef$$$13, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, CHAR.class, $$$methodRef$$$13, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, CHAR.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, CHAR.class, $$$methodRef$$$14, this, new Object[0]);
            }
            BigDecimal big_dec_val = null;
            try {
                big_dec_val = new BigDecimal(this.stringValue().trim());
            }
            catch (NumberFormatException e2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(12, "bigDecimalValue").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, CHAR.class, $$$methodRef$$$14, this, sQLException);
                }
                throw sQLException;
            }
            BigDecimal bigDecimal = big_dec_val;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, CHAR.class, $$$methodRef$$$14, this, bigDecimal);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, CHAR.class, $$$methodRef$$$14, this, null);
            }
            return bigDecimal;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, CHAR.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, CHAR.class, $$$methodRef$$$15, this, new Object[0]);
            }
            StringReader stringReader = new StringReader(this.getString());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, CHAR.class, $$$methodRef$$$15, this, stringReader);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, CHAR.class, $$$methodRef$$$15, this, null);
            }
            return stringReader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, CHAR.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, CHAR.class, $$$methodRef$$$16, this, new Object[0]);
            }
            InputStream inputStream = this.getStream();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, CHAR.class, $$$methodRef$$$16, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, CHAR.class, $$$methodRef$$$16, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, CHAR.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, CHAR.class, $$$methodRef$$$17, this, new Object[0]);
            }
            InputStream inputStream = this.getStream();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, CHAR.class, $$$methodRef$$$17, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, CHAR.class, $$$methodRef$$$17, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, CHAR.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object makeJdbcArray(int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void arraySize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, CHAR.class, $$$methodRef$$$18, this, n2);
            }
            String[] stringArray = new String[arraySize];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, CHAR.class, $$$methodRef$$$18, this, stringArray);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, CHAR.class, $$$methodRef$$$18, this, null);
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, CHAR.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, CHAR.class, $$$methodRef$$$19, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, CHAR.class, $$$methodRef$$$19, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, CHAR.class, $$$methodRef$$$19, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, CHAR.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setVariableLength(boolean bl) {
        boolean bl2 = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void variableLength;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, CHAR.class, $$$methodRef$$$20, this, bl);
            }
            this.variableLength = variableLength;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, CHAR.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, CHAR.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, CHAR.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isVariableLength() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, CHAR.class, $$$methodRef$$$21, this, new Object[0]);
            }
            boolean bl2 = this.variableLength;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, CHAR.class, $$$methodRef$$$21, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, CHAR.class, $$$methodRef$$$21, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, CHAR.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$27 = CHAR.class.getDeclaredConstructor(Object.class, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = CHAR.class.getDeclaredConstructor(String.class, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = CHAR.class.getDeclaredConstructor(String.class, CharacterSet.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = CHAR.class.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = CHAR.class.getDeclaredConstructor(byte[].class, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = CHAR.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = CHAR.class.getDeclaredMethod("isVariableLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = CHAR.class.getDeclaredMethod("setVariableLength", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = CHAR.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = CHAR.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = CHAR.class.getDeclaredMethod("binaryStreamValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = CHAR.class.getDeclaredMethod("asciiStreamValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = CHAR.class.getDeclaredMethod("characterStreamValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = CHAR.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = CHAR.class.getDeclaredMethod("timestampValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = CHAR.class.getDeclaredMethod("timeValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = CHAR.class.getDeclaredMethod("dateValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = CHAR.class.getDeclaredMethod("byteValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = CHAR.class.getDeclaredMethod("doubleValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = CHAR.class.getDeclaredMethod("floatValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = CHAR.class.getDeclaredMethod("longValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = CHAR.class.getDeclaredMethod("intValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = CHAR.class.getDeclaredMethod("booleanValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = CHAR.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = CHAR.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CHAR.class.getDeclaredMethod("setValue", byte[].class, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CHAR.class.getDeclaredMethod("oracleId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CHAR.class.getDeclaredMethod("getCharacterSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        DEFAULT_CHARSET = CharacterSet.make(-1);
        empty = new byte[0];
    }
}

