/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import schemacrawler.crawl.ImmutableDatabaseProperty;
import schemacrawler.schema.DatabaseInfo;
import us.fatehi.utility.property.BaseProductVersion;
import us.fatehi.utility.property.Property;

final class MutableDatabaseInfo
extends BaseProductVersion
implements DatabaseInfo {
    private static final long serialVersionUID = 4051323422934251828L;
    private final String userName;
    private final Set<Property> serverInfo;
    private final Set<Property> databaseProperties;

    public MutableDatabaseInfo(String databaseProductName, String databaseProductVersion, String userName) {
        super(databaseProductName, databaseProductVersion);
        this.userName = userName;
        this.serverInfo = new HashSet<Property>();
        this.databaseProperties = new HashSet<Property>();
    }

    @Override
    public Collection<Property> getProperties() {
        ArrayList<Property> properties = new ArrayList<Property>(this.databaseProperties);
        properties.sort(Comparator.naturalOrder());
        return properties;
    }

    @Override
    public Collection<Property> getServerInfo() {
        return new TreeSet<Property>(this.serverInfo);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- database: ").append(this.getProductName()).append(' ').append(this.getProductVersion()).append(System.lineSeparator());
        return info.toString();
    }

    void addAll(Collection<ImmutableDatabaseProperty> dbProperties) {
        if (dbProperties != null) {
            this.databaseProperties.addAll(dbProperties);
        }
    }

    void addServerInfo(Property property) {
        if (property != null) {
            this.serverInfo.add(property);
        }
    }
}

