/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizJdkEngine;
import guru.nidi.graphviz.engine.GraphvizV8Engine;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;

public final class GraphvizJavaExecutorUtility {
    private static final Logger LOGGER = Logger.getLogger(GraphvizJavaExecutorUtility.class.getName());

    public static void generateGraph(Path dotFile, Path outputFile, DiagramOutputFormat diagramOutputFormat) {
        Objects.requireNonNull(dotFile, "No DOT file provided");
        Objects.requireNonNull(outputFile, "No diagram output file provided");
        Objects.requireNonNull(diagramOutputFormat, "No diagram output format provided");
        try {
            String dotSource = Files.lines(dotFile).collect(Collectors.joining(" "));
            List<GraphvizEngine> engines = GraphvizJavaExecutorUtility.loadGraphvizEngines();
            Graphviz.useEngine(engines);
            Format format = GraphvizJavaExecutorUtility.map(diagramOutputFormat);
            if (format == null) {
                throw new ConfigurationException(String.format("Unsupported output format <%s>", new Object[]{diagramOutputFormat}));
            }
            Graphviz.fromString((String)dotSource).render(format).toFile(outputFile.toFile());
        }
        catch (Throwable e) {
            throw new ExecutionRuntimeException(String.format("Cannot generate diagram from <%s>", dotFile), e);
        }
    }

    private static List<GraphvizEngine> loadGraphvizEngines() {
        GraphvizJdkEngine engine;
        ArrayList<GraphvizEngine> engines = new ArrayList<GraphvizEngine>();
        try {
            engine = new GraphvizJdkEngine();
            engines.add((GraphvizEngine)engine);
            LOGGER.log(Level.CONFIG, "Loaded GraphvizJdkEngine");
        }
        catch (Throwable e) {
            LOGGER.log(Level.CONFIG, "Cannot load GraphvizJdkEngine");
        }
        try {
            engine = new GraphvizV8Engine();
            engines.add((GraphvizEngine)engine);
            LOGGER.log(Level.CONFIG, "Loaded GraphvizV8Engine");
        }
        catch (Throwable e) {
            LOGGER.log(Level.CONFIG, "Cannot load GraphvizV8Engine");
        }
        return engines;
    }

    private static Format map(DiagramOutputFormat diagramOutputFormat) {
        Format format;
        if (diagramOutputFormat == null) {
            return null;
        }
        switch (diagramOutputFormat) {
            case svg: {
                format = Format.SVG;
                break;
            }
            case png: {
                format = Format.PNG;
                break;
            }
            case ps: {
                format = Format.PS;
                break;
            }
            case xdot: {
                format = Format.XDOT;
                break;
            }
            case plain: {
                format = Format.PLAIN;
                break;
            }
            default: {
                format = null;
            }
        }
        return format;
    }

    private GraphvizJavaExecutorUtility() {
    }
}

