/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public class PropertiesUtility {
    private static final Logger LOGGER = Logger.getLogger(PropertiesUtility.class.getName());

    public static String getSystemConfigurationProperty(String key, String defaultValue) {
        String systemPropertyValue = System.getProperty(key);
        if (!Utility.isBlank(systemPropertyValue)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using value from system property <%s=%s>", key, systemPropertyValue));
            return systemPropertyValue;
        }
        String envVariableValue = System.getenv(key);
        if (!Utility.isBlank(envVariableValue)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using value from enivronmental variable <%s=%s>", key, envVariableValue));
            return envVariableValue;
        }
        return defaultValue;
    }

    public static Map<String, String> propertiesMap(Properties properties) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (properties != null) {
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                propertiesMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return propertiesMap;
    }

    private PropertiesUtility() {
    }
}

